# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class V2HealthCheckResponse(BaseModel):
    """
    V2HealthCheckResponse
    """ # noqa: E501
    pod_connectivity: Optional[StrictBool] = Field(default=None, description="Indicates whether the Agent server can connect to the Pod", alias="podConnectivity")
    pod_connectivity_error: Optional[StrictStr] = Field(default=None, description="Error details in case of no Pod connectivity", alias="podConnectivityError")
    key_manager_connectivity: Optional[StrictBool] = Field(default=None, description="Indicates whether the Agent server can connect to the Key Manager", alias="keyManagerConnectivity")
    key_manager_connectivity_error: Optional[StrictStr] = Field(default=None, description="Error details in case of no Key Manager connectivity", alias="keyManagerConnectivityError")
    firehose_connectivity: Optional[StrictBool] = Field(default=None, description="Indicates whether the Agent server can connect to Firehose Service", alias="firehoseConnectivity")
    firehose_connectivity_error: Optional[StrictStr] = Field(default=None, description="Error details in case of no Firehose connectivity", alias="firehoseConnectivityError")
    datafeed_connectivity: Optional[StrictBool] = Field(default=None, description="Indicates whether the Agent server can connect to Datafeed V2 Service", alias="datafeedConnectivity")
    datafeed_connectivity_error: Optional[StrictStr] = Field(default=None, description="Error details in case of no Datafeed V2 connectivity", alias="datafeedConnectivityError")
    datafeed_version: Optional[StrictStr] = Field(default=None, description="Indicates the Datafeed V2 version", alias="datafeedVersion")
    encrypt_decrypt_success: Optional[StrictBool] = Field(default=None, description="Indicates whether the Agent can successfully decrypt and encrypt messages", alias="encryptDecryptSuccess")
    encrypt_decrypt_error: Optional[StrictStr] = Field(default=None, description="Error details in case of the encryption or decryption of the message fails", alias="encryptDecryptError")
    pod_version: Optional[StrictStr] = Field(default=None, description="The version number of the pod", alias="podVersion")
    agent_version: Optional[StrictStr] = Field(default=None, description="The version number of the Agent server", alias="agentVersion")
    agent_service_user: Optional[StrictBool] = Field(default=None, description="Indicates whether agent service user is setup correctly.", alias="agentServiceUser")
    agent_service_user_error: Optional[StrictStr] = Field(default=None, description="Error details in case agent service user is setup incorrectly.", alias="agentServiceUserError")
    ce_service_user: Optional[StrictBool] = Field(default=None, description="Indicates whether CEService user is setup correctly.", alias="ceServiceUser")
    ce_service_user_error: Optional[StrictStr] = Field(default=None, description="Error details in case CEService user is setup incorrectly.", alias="ceServiceUserError")
    __properties: ClassVar[List[str]] = ["podConnectivity", "podConnectivityError", "keyManagerConnectivity", "keyManagerConnectivityError", "firehoseConnectivity", "firehoseConnectivityError", "datafeedConnectivity", "datafeedConnectivityError", "datafeedVersion", "encryptDecryptSuccess", "encryptDecryptError", "podVersion", "agentVersion", "agentServiceUser", "agentServiceUserError", "ceServiceUser", "ceServiceUserError"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V2HealthCheckResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V2HealthCheckResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "podConnectivity": obj.get("podConnectivity"),
            "podConnectivityError": obj.get("podConnectivityError"),
            "keyManagerConnectivity": obj.get("keyManagerConnectivity"),
            "keyManagerConnectivityError": obj.get("keyManagerConnectivityError"),
            "firehoseConnectivity": obj.get("firehoseConnectivity"),
            "firehoseConnectivityError": obj.get("firehoseConnectivityError"),
            "datafeedConnectivity": obj.get("datafeedConnectivity"),
            "datafeedConnectivityError": obj.get("datafeedConnectivityError"),
            "datafeedVersion": obj.get("datafeedVersion"),
            "encryptDecryptSuccess": obj.get("encryptDecryptSuccess"),
            "encryptDecryptError": obj.get("encryptDecryptError"),
            "podVersion": obj.get("podVersion"),
            "agentVersion": obj.get("agentVersion"),
            "agentServiceUser": obj.get("agentServiceUser"),
            "agentServiceUserError": obj.get("agentServiceUserError"),
            "ceServiceUser": obj.get("ceServiceUser"),
            "ceServiceUserError": obj.get("ceServiceUserError")
        })
        return _obj


