# coding: utf-8

"""
    Symphony Profile Manager

    Profile Manager is a microservice to manage users profile and groups

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.group_model.interaction_transfer import InteractionTransfer
from typing import Optional, Set
from typing_extensions import Self

class InteractionControl(BaseModel):
    """
    InteractionControl
    """ # noqa: E501
    allow_ims: Optional[StrictBool] = Field(default=None, alias="allowIMs")
    allow_rooms: Optional[StrictBool] = Field(default=None, alias="allowRooms")
    interaction_transfer: Optional[InteractionTransfer] = Field(default=None, alias="interactionTransfer")
    tag_stream: Optional[StrictStr] = Field(default=None, alias="tagStream")
    can_have_interaction: Optional[StrictBool] = Field(default=True, description="For the SDL groupe type this flag is true, for the company groupe type it is false", alias="canHaveInteraction")
    __properties: ClassVar[List[str]] = ["allowIMs", "allowRooms", "interactionTransfer", "tagStream", "canHaveInteraction"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InteractionControl from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of interaction_transfer
        if self.interaction_transfer:
            _dict['interactionTransfer'] = self.interaction_transfer.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InteractionControl from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowIMs": obj.get("allowIMs"),
            "allowRooms": obj.get("allowRooms"),
            "interactionTransfer": InteractionTransfer.from_dict(obj["interactionTransfer"]) if obj.get("interactionTransfer") is not None else None,
            "tagStream": obj.get("tagStream"),
            "canHaveInteraction": obj.get("canHaveInteraction") if obj.get("canHaveInteraction") is not None else True
        })
        return _obj


