# coding: utf-8

"""
    Symphony Profile Manager

    Profile Manager is a microservice to manage users profile and groups

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.group_model.implicit_connection import ImplicitConnection
from symphony.bdk.gen.group_model.visibility_restriction import VisibilityRestriction
from typing import Optional, Set
from typing_extensions import Self

class ProfileControl(BaseModel):
    """
    ProfileControl
    """ # noqa: E501
    visibility_restriction: Optional[VisibilityRestriction] = Field(default=None, alias="visibilityRestriction")
    implicit_connection: Optional[ImplicitConnection] = Field(default=None, alias="implicitConnection")
    wall_support: Optional[StrictBool] = Field(default=None, description="Not supported yet", alias="wallSupport")
    profile_fields: Optional[List[StrictStr]] = Field(default=None, alias="profileFields")
    search_fields: Optional[List[StrictStr]] = Field(default=None, alias="searchFields")
    can_have_public_profile: Optional[StrictBool] = Field(default=True, description="For the SDL groupe type this flag is true, for the company groupe type it is false", alias="canHavePublicProfile")
    __properties: ClassVar[List[str]] = ["visibilityRestriction", "implicitConnection", "wallSupport", "profileFields", "searchFields", "canHavePublicProfile"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProfileControl from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of visibility_restriction
        if self.visibility_restriction:
            _dict['visibilityRestriction'] = self.visibility_restriction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of implicit_connection
        if self.implicit_connection:
            _dict['implicitConnection'] = self.implicit_connection.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProfileControl from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "visibilityRestriction": VisibilityRestriction.from_dict(obj["visibilityRestriction"]) if obj.get("visibilityRestriction") is not None else None,
            "implicitConnection": ImplicitConnection.from_dict(obj["implicitConnection"]) if obj.get("implicitConnection") is not None else None,
            "wallSupport": obj.get("wallSupport"),
            "profileFields": obj.get("profileFields"),
            "searchFields": obj.get("searchFields"),
            "canHavePublicProfile": obj.get("canHavePublicProfile") if obj.get("canHavePublicProfile") is not None else True
        })
        return _obj


