# coding: utf-8

"""
    Symphony Profile Manager

    Profile Manager is a microservice to manage users profile and groups

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.group_model.interaction_control import InteractionControl
from symphony.bdk.gen.group_model.membership_control import MembershipControl
from symphony.bdk.gen.group_model.owner import Owner
from symphony.bdk.gen.group_model.profile_control import ProfileControl
from symphony.bdk.gen.group_model.status import Status
from typing import Optional, Set
from typing_extensions import Self

class Type(BaseModel):
    """
    Type
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Type identifier")
    owner_type: Optional[Owner] = Field(default=None, alias="ownerType")
    name: Optional[StrictStr] = Field(default=None, description="Type's name")
    status: Optional[Status] = None
    profile_control: Optional[ProfileControl] = Field(default=None, alias="profileControl")
    membership_control: Optional[MembershipControl] = Field(default=None, alias="membershipControl")
    interaction_control: Optional[InteractionControl] = Field(default=None, alias="interactionControl")
    __properties: ClassVar[List[str]] = ["id", "ownerType", "name", "status", "profileControl", "membershipControl", "interactionControl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Type from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of profile_control
        if self.profile_control:
            _dict['profileControl'] = self.profile_control.to_dict()
        # override the default output from pydantic by calling `to_dict()` of membership_control
        if self.membership_control:
            _dict['membershipControl'] = self.membership_control.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interaction_control
        if self.interaction_control:
            _dict['interactionControl'] = self.interaction_control.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Type from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "ownerType": obj.get("ownerType"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "profileControl": ProfileControl.from_dict(obj["profileControl"]) if obj.get("profileControl") is not None else None,
            "membershipControl": MembershipControl.from_dict(obj["membershipControl"]) if obj.get("membershipControl") is not None else None,
            "interactionControl": InteractionControl.from_dict(obj["interactionControl"]) if obj.get("interactionControl") is not None else None
        })
        return _obj


