# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CompanyCertInfo(BaseModel):
    """
    CompanyCertInfo
    """ # noqa: E501
    finger_print: Optional[StrictStr] = Field(default=None, description="Unique identifier", alias="fingerPrint")
    issuer_finger_print: Optional[StrictStr] = Field(default=None, description="Unique identifier of issuer cert if known", alias="issuerFingerPrint")
    last_seen: Optional[StrictInt] = Field(default=None, description="Date when we last saw this certificate presented", alias="lastSeen")
    updated_at: Optional[StrictInt] = Field(default=None, description="Date when this cert was last updated by administrator", alias="updatedAt")
    updated_by: Optional[StrictInt] = Field(default=None, description="User ID of administrator who last updated this cert", alias="updatedBy")
    common_name: Optional[StrictStr] = Field(default=None, description="The Symphony account name which this certificate authenticates", alias="commonName")
    expiry_date: Optional[StrictInt] = Field(default=None, description="Expiry date of this cert", alias="expiryDate")
    __properties: ClassVar[List[str]] = ["fingerPrint", "issuerFingerPrint", "lastSeen", "updatedAt", "updatedBy", "commonName", "expiryDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompanyCertInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompanyCertInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fingerPrint": obj.get("fingerPrint"),
            "issuerFingerPrint": obj.get("issuerFingerPrint"),
            "lastSeen": obj.get("lastSeen"),
            "updatedAt": obj.get("updatedAt"),
            "updatedBy": obj.get("updatedBy"),
            "commonName": obj.get("commonName"),
            "expiryDate": obj.get("expiryDate")
        })
        return _obj


