# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.user_id import UserId
from typing import Optional, Set
from typing_extensions import Self

class RoomSearchCriteria(BaseModel):
    """
    Room Query Object. Used to specify the parameters for room search.
    """ # noqa: E501
    query: StrictStr = Field(description="The search query. Matches the room name and description.")
    labels: Optional[List[StrictStr]] = Field(default=None, description="A list of room tag labels whose values will be queried.")
    search_fields: Optional[List[StrictStr]] = Field(default=None, description="The room fields on which to search. Parameter introduced in sbe-25.10.0", alias="searchFields")
    active: Optional[StrictBool] = Field(default=None, description="Restrict the search to active/inactive rooms. If unspecified, search all rooms.")
    private: Optional[StrictBool] = Field(default=None, description="Restrict the search to private rooms. If unspecified, search all rooms.")
    owner: Optional[UserId] = None
    creator: Optional[UserId] = None
    member: Optional[UserId] = None
    sort_order: Optional[StrictStr] = Field(default=None, description="Sort algorithm to be used. Supports two values: \"BASIC\" (legacy algorithm) and \"RELEVANCE\" (enhanced algorithm). ", alias="sortOrder")
    __properties: ClassVar[List[str]] = ["query", "labels", "searchFields", "active", "private", "owner", "creator", "member", "sortOrder"]

    @field_validator('sort_order')
    def sort_order_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['BASIC', 'RELEVANCE']):
            raise ValueError("must be one of enum values ('BASIC', 'RELEVANCE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RoomSearchCriteria from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of creator
        if self.creator:
            _dict['creator'] = self.creator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of member
        if self.member:
            _dict['member'] = self.member.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RoomSearchCriteria from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "query": obj.get("query"),
            "labels": obj.get("labels"),
            "searchFields": obj.get("searchFields"),
            "active": obj.get("active"),
            "private": obj.get("private"),
            "owner": UserId.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "creator": UserId.from_dict(obj["creator"]) if obj.get("creator") is not None else None,
            "member": UserId.from_dict(obj["member"]) if obj.get("member") is not None else None,
            "sortOrder": obj.get("sortOrder")
        })
        return _obj


