# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.room_tag import RoomTag
from typing import Optional, Set
from typing_extensions import Self

class V3RoomAttributes(BaseModel):
    """
    V3RoomAttributes
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Room name.")
    keywords: Optional[List[RoomTag]] = Field(default=None, description="Keywords for search to use to find this room")
    description: Optional[StrictStr] = Field(default=None, description="Room description.")
    members_can_invite: Optional[StrictBool] = Field(default=None, description="If true, any chatroom participant can add new participants. If false, only owners can add new participants.", alias="membersCanInvite")
    discoverable: Optional[StrictBool] = Field(default=None, description="If true, this chatroom (name, description and messages) can be searched and listed by non-participants. If false, only participants can search this room.")
    public: Optional[StrictBool] = Field(default=None, description="If true, this is a public chatroom. IF false, a private chatroom.")
    read_only: Optional[StrictBool] = Field(default=None, description="If true, only stream owners can send messages.", alias="readOnly")
    copy_protected: Optional[StrictBool] = Field(default=None, description="If true, clients disable the clipboard copy for content in this stream.", alias="copyProtected")
    cross_pod: Optional[StrictBool] = Field(default=None, description="If true, this room is a cross pod room", alias="crossPod")
    view_history: Optional[StrictBool] = Field(default=None, description="If true, new members can view the room chat history of the room.", alias="viewHistory")
    multi_lateral_room: Optional[StrictBool] = Field(default=None, description="If true, this is a multi lateral room where we can find users belonging to more than 2 companies.", alias="multiLateralRoom")
    scheduled_meeting: Optional[StrictBool] = Field(default=None, description="If true, this room is for a scheduled meeting.", alias="scheduledMeeting")
    sub_type: Optional[StrictStr] = Field(default=None, description="This field is ignored when creating a new room as it was only used for email integration which is now sunset.", alias="subType")
    pinned_message_id: Optional[StrictStr] = Field(default=None, description="UrlSafe message id of the pinned message inside the room. To perform unpin operation, send an empty string.", alias="pinnedMessageId")
    group_chat: Optional[StrictBool] = Field(default=None, description="If true, this room is a group chat. Note: this parameter is ignored for creating rooms. Since SBE 20.16.", alias="groupChat")
    __properties: ClassVar[List[str]] = ["name", "keywords", "description", "membersCanInvite", "discoverable", "public", "readOnly", "copyProtected", "crossPod", "viewHistory", "multiLateralRoom", "scheduledMeeting", "subType", "pinnedMessageId", "groupChat"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V3RoomAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in keywords (list)
        _items = []
        if self.keywords:
            for _item_keywords in self.keywords:
                if _item_keywords:
                    _items.append(_item_keywords.to_dict())
            _dict['keywords'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V3RoomAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "keywords": [RoomTag.from_dict(_item) for _item in obj["keywords"]] if obj.get("keywords") is not None else None,
            "description": obj.get("description"),
            "membersCanInvite": obj.get("membersCanInvite"),
            "discoverable": obj.get("discoverable"),
            "public": obj.get("public"),
            "readOnly": obj.get("readOnly"),
            "copyProtected": obj.get("copyProtected"),
            "crossPod": obj.get("crossPod"),
            "viewHistory": obj.get("viewHistory"),
            "multiLateralRoom": obj.get("multiLateralRoom"),
            "scheduledMeeting": obj.get("scheduledMeeting"),
            "subType": obj.get("subType"),
            "pinnedMessageId": obj.get("pinnedMessageId"),
            "groupChat": obj.get("groupChat")
        })
        return _obj


