# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated
from symphony.bdk.gen.agent_model.v5_event_list import V5EventList
from symphony.bdk.gen.agent_model.v5_events_read_body import V5EventsReadBody

from symphony.bdk.gen.api_client import ApiClient, RequestSerialized
from symphony.bdk.gen.api_response import ApiResponse
from symphony.bdk.gen.rest import RESTResponseType


class DatahoseApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def read_events(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        body: V5EventsReadBody,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V5EventList:
        """Creates and Reads a real time feed of messages and events of your pod (Datahose)

        Available on Agent 22.5.1 and above.  This API provides a real time feed of all the messages and events in the pod,  even from conversations where the calling service account is not a member. The types of events surfaced  can be found in the Real Time Events list. In case you retrieving SOCIALMESSAGE events, the credentials of the ceservice  account must be properly configured in the Agent.  The types of events returned can be found in the Real Time Events list (see definition on top of the file).   The ackId sent as parameter must be empty for the first call. In the response an ackId will be sent back and it can be used for the next call: in this way you acknowledge that you have received the events that came with that ackId.  If you have several instances of the same bot, they must share the same feed so  that events are spread across all bot instances. To do so, you must: share the same  service account provide the same \"tag\" and same \"filters\" values.  The Datahose API is an add-on to the Symphony Services, and is subject to additional charges.  Prior to using Datahose in your Symphony environment(s), you will need to enter into a specific contract. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param body: (required)
        :type body: V5EventsReadBody
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_events_serialize(
            session_token=session_token,
            body=body,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V5EventList",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def read_events_with_http_info(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        body: V5EventsReadBody,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V5EventList]:
        """Creates and Reads a real time feed of messages and events of your pod (Datahose)

        Available on Agent 22.5.1 and above.  This API provides a real time feed of all the messages and events in the pod,  even from conversations where the calling service account is not a member. The types of events surfaced  can be found in the Real Time Events list. In case you retrieving SOCIALMESSAGE events, the credentials of the ceservice  account must be properly configured in the Agent.  The types of events returned can be found in the Real Time Events list (see definition on top of the file).   The ackId sent as parameter must be empty for the first call. In the response an ackId will be sent back and it can be used for the next call: in this way you acknowledge that you have received the events that came with that ackId.  If you have several instances of the same bot, they must share the same feed so  that events are spread across all bot instances. To do so, you must: share the same  service account provide the same \"tag\" and same \"filters\" values.  The Datahose API is an add-on to the Symphony Services, and is subject to additional charges.  Prior to using Datahose in your Symphony environment(s), you will need to enter into a specific contract. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param body: (required)
        :type body: V5EventsReadBody
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_events_serialize(
            session_token=session_token,
            body=body,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V5EventList",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def read_events_without_preload_content(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        body: V5EventsReadBody,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Creates and Reads a real time feed of messages and events of your pod (Datahose)

        Available on Agent 22.5.1 and above.  This API provides a real time feed of all the messages and events in the pod,  even from conversations where the calling service account is not a member. The types of events surfaced  can be found in the Real Time Events list. In case you retrieving SOCIALMESSAGE events, the credentials of the ceservice  account must be properly configured in the Agent.  The types of events returned can be found in the Real Time Events list (see definition on top of the file).   The ackId sent as parameter must be empty for the first call. In the response an ackId will be sent back and it can be used for the next call: in this way you acknowledge that you have received the events that came with that ackId.  If you have several instances of the same bot, they must share the same feed so  that events are spread across all bot instances. To do so, you must: share the same  service account provide the same \"tag\" and same \"filters\" values.  The Datahose API is an add-on to the Symphony Services, and is subject to additional charges.  Prior to using Datahose in your Symphony environment(s), you will need to enter into a specific contract. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param body: (required)
        :type body: V5EventsReadBody
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_events_serialize(
            session_token=session_token,
            body=body,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V5EventList",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_events_serialize(
        self,
        session_token,
        body,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v5/events/read',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


