# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBytes, StrictInt, StrictStr
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from symphony.bdk.gen.agent_model.import_response import ImportResponse
from symphony.bdk.gen.agent_model.imported_message import ImportedMessage
from symphony.bdk.gen.agent_model.message import Message
from symphony.bdk.gen.agent_model.message_search_query import MessageSearchQuery
from symphony.bdk.gen.agent_model.message_submission import MessageSubmission
from symphony.bdk.gen.agent_model.v2_base_message import V2BaseMessage
from symphony.bdk.gen.agent_model.v2_import_response import V2ImportResponse
from symphony.bdk.gen.agent_model.v2_imported_message import V2ImportedMessage
from symphony.bdk.gen.agent_model.v2_message import V2Message
from symphony.bdk.gen.agent_model.v2_message_submission import V2MessageSubmission
from symphony.bdk.gen.agent_model.v4_import_response import V4ImportResponse
from symphony.bdk.gen.agent_model.v4_imported_message import V4ImportedMessage
from symphony.bdk.gen.agent_model.v4_message import V4Message
from symphony.bdk.gen.agent_model.v4_message_blast_response import V4MessageBlastResponse

from symphony.bdk.gen.api_client import ApiClient, RequestSerialized
from symphony.bdk.gen.api_response import ApiResponse
from symphony.bdk.gen.rest import RESTResponseType


class MessagesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def v1_message_id_get(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        id: Annotated[StrictStr, Field(description="Message ID as a URL-safe string")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4Message:
        """Get a message by ID


        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param id: Message ID as a URL-safe string (required)
        :type id: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_id_get_serialize(
            session_token=session_token,
            id=id,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_message_id_get_with_http_info(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        id: Annotated[StrictStr, Field(description="Message ID as a URL-safe string")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4Message]:
        """Get a message by ID


        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param id: Message ID as a URL-safe string (required)
        :type id: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_id_get_serialize(
            session_token=session_token,
            id=id,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_message_id_get_without_preload_content(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        id: Annotated[StrictStr, Field(description="Message ID as a URL-safe string")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a message by ID


        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param id: Message ID as a URL-safe string (required)
        :type id: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_id_get_serialize(
            session_token=session_token,
            id=id,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_message_id_get_serialize(
        self,
        session_token,
        id,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/message/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v1_message_import_post(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[ImportResponse]:
        """(Deprecated) Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v1/message/import is deprecated.", DeprecationWarning)

        _param = self._v1_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ImportResponse]",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_message_import_post_with_http_info(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[ImportResponse]]:
        """(Deprecated) Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v1/message/import is deprecated.", DeprecationWarning)

        _param = self._v1_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ImportResponse]",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_message_import_post_without_preload_content(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v1/message/import is deprecated.", DeprecationWarning)

        _param = self._v1_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[ImportResponse]",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_message_import_post_serialize(
        self,
        session_token,
        message_list,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'messageList': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter
        if message_list is not None:
            _body_params = message_list


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/message/import',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v1_message_search_get(
        self,
        query: Annotated[StrictStr, Field(description="The search query. See above for the query syntax.")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of results to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max no. of results to return. If no value is provided, 50 is the default.")] = None,
        scope: Annotated[Optional[StrictStr], Field(description="Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. ")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Messages sort direction : ASC or DESC (default to DESC) ")] = None,
        tier: Annotated[Optional[StrictStr], Field(description="Target search tier : hot, warm or all (default to hot) ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[V4Message]:
        """Search messages

        Search messages according to the specified criteria. The \"query\" parameter takes a search query defined as \"field:value\" pairs combined by the operator \"AND\" (e.g. \"text:foo AND autor:bar\"). Supported fields are  (case-insensitive): \"text\", \"author\", \"hashtag\", \"cashtag\", \"mention\", \"signal\", \"fromDate\", \"toDate\",  \"streamId\", \"streamType\".  \"text\" search requires a \"streamId\" to be specified.  \"streamType\" accepts one of the following values: \"chat\" (IMs and MIMs), \"im\", \"mim\", \"chatroom\", \"post\".  \"signal\" queries can only be combined with \"fromDate\", \"toDate\", \"skip\" and \"limit\" parameters. 

        :param query: The search query. See above for the query syntax. (required)
        :type query: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param skip: No. of results to skip.
        :type skip: int
        :param limit: Max no. of results to return. If no value is provided, 50 is the default.
        :type limit: int
        :param scope: Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. 
        :type scope: str
        :param sort_dir: Messages sort direction : ASC or DESC (default to DESC) 
        :type sort_dir: str
        :param tier: Target search tier : hot, warm or all (default to hot) 
        :type tier: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_search_get_serialize(
            query=query,
            session_token=session_token,
            skip=skip,
            limit=limit,
            scope=scope,
            sort_dir=sort_dir,
            tier=tier,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_message_search_get_with_http_info(
        self,
        query: Annotated[StrictStr, Field(description="The search query. See above for the query syntax.")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of results to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max no. of results to return. If no value is provided, 50 is the default.")] = None,
        scope: Annotated[Optional[StrictStr], Field(description="Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. ")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Messages sort direction : ASC or DESC (default to DESC) ")] = None,
        tier: Annotated[Optional[StrictStr], Field(description="Target search tier : hot, warm or all (default to hot) ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[V4Message]]:
        """Search messages

        Search messages according to the specified criteria. The \"query\" parameter takes a search query defined as \"field:value\" pairs combined by the operator \"AND\" (e.g. \"text:foo AND autor:bar\"). Supported fields are  (case-insensitive): \"text\", \"author\", \"hashtag\", \"cashtag\", \"mention\", \"signal\", \"fromDate\", \"toDate\",  \"streamId\", \"streamType\".  \"text\" search requires a \"streamId\" to be specified.  \"streamType\" accepts one of the following values: \"chat\" (IMs and MIMs), \"im\", \"mim\", \"chatroom\", \"post\".  \"signal\" queries can only be combined with \"fromDate\", \"toDate\", \"skip\" and \"limit\" parameters. 

        :param query: The search query. See above for the query syntax. (required)
        :type query: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param skip: No. of results to skip.
        :type skip: int
        :param limit: Max no. of results to return. If no value is provided, 50 is the default.
        :type limit: int
        :param scope: Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. 
        :type scope: str
        :param sort_dir: Messages sort direction : ASC or DESC (default to DESC) 
        :type sort_dir: str
        :param tier: Target search tier : hot, warm or all (default to hot) 
        :type tier: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_search_get_serialize(
            query=query,
            session_token=session_token,
            skip=skip,
            limit=limit,
            scope=scope,
            sort_dir=sort_dir,
            tier=tier,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_message_search_get_without_preload_content(
        self,
        query: Annotated[StrictStr, Field(description="The search query. See above for the query syntax.")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of results to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max no. of results to return. If no value is provided, 50 is the default.")] = None,
        scope: Annotated[Optional[StrictStr], Field(description="Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. ")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Messages sort direction : ASC or DESC (default to DESC) ")] = None,
        tier: Annotated[Optional[StrictStr], Field(description="Target search tier : hot, warm or all (default to hot) ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search messages

        Search messages according to the specified criteria. The \"query\" parameter takes a search query defined as \"field:value\" pairs combined by the operator \"AND\" (e.g. \"text:foo AND autor:bar\"). Supported fields are  (case-insensitive): \"text\", \"author\", \"hashtag\", \"cashtag\", \"mention\", \"signal\", \"fromDate\", \"toDate\",  \"streamId\", \"streamType\".  \"text\" search requires a \"streamId\" to be specified.  \"streamType\" accepts one of the following values: \"chat\" (IMs and MIMs), \"im\", \"mim\", \"chatroom\", \"post\".  \"signal\" queries can only be combined with \"fromDate\", \"toDate\", \"skip\" and \"limit\" parameters. 

        :param query: The search query. See above for the query syntax. (required)
        :type query: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param skip: No. of results to skip.
        :type skip: int
        :param limit: Max no. of results to return. If no value is provided, 50 is the default.
        :type limit: int
        :param scope: Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. 
        :type scope: str
        :param sort_dir: Messages sort direction : ASC or DESC (default to DESC) 
        :type sort_dir: str
        :param tier: Target search tier : hot, warm or all (default to hot) 
        :type tier: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_search_get_serialize(
            query=query,
            session_token=session_token,
            skip=skip,
            limit=limit,
            scope=scope,
            sort_dir=sort_dir,
            tier=tier,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_message_search_get_serialize(
        self,
        query,
        session_token,
        skip,
        limit,
        scope,
        sort_dir,
        tier,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if query is not None:
            
            _query_params.append(('query', query))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if scope is not None:
            
            _query_params.append(('scope', scope))
            
        if sort_dir is not None:
            
            _query_params.append(('sortDir', sort_dir))
            
        if tier is not None:
            
            _query_params.append(('tier', tier))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/message/search',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v1_message_search_post(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        query: Annotated[MessageSearchQuery, Field(description="The search query. See above for the query syntax.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of results to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max no. of results to return. If no value is provided, 50 is the default.")] = None,
        scope: Annotated[Optional[StrictStr], Field(description="Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. ")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Messages sort direction : ASC or DESC (default to DESC) ")] = None,
        tier: Annotated[Optional[StrictStr], Field(description="Target search tier : hot, warm or all (default to hot) ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[V4Message]:
        """Search messages

        Search messages according to the specified criteria.

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param query: The search query. See above for the query syntax. (required)
        :type query: MessageSearchQuery
        :param skip: No. of results to skip.
        :type skip: int
        :param limit: Max no. of results to return. If no value is provided, 50 is the default.
        :type limit: int
        :param scope: Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. 
        :type scope: str
        :param sort_dir: Messages sort direction : ASC or DESC (default to DESC) 
        :type sort_dir: str
        :param tier: Target search tier : hot, warm or all (default to hot) 
        :type tier: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_search_post_serialize(
            session_token=session_token,
            query=query,
            skip=skip,
            limit=limit,
            scope=scope,
            sort_dir=sort_dir,
            tier=tier,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_message_search_post_with_http_info(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        query: Annotated[MessageSearchQuery, Field(description="The search query. See above for the query syntax.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of results to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max no. of results to return. If no value is provided, 50 is the default.")] = None,
        scope: Annotated[Optional[StrictStr], Field(description="Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. ")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Messages sort direction : ASC or DESC (default to DESC) ")] = None,
        tier: Annotated[Optional[StrictStr], Field(description="Target search tier : hot, warm or all (default to hot) ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[V4Message]]:
        """Search messages

        Search messages according to the specified criteria.

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param query: The search query. See above for the query syntax. (required)
        :type query: MessageSearchQuery
        :param skip: No. of results to skip.
        :type skip: int
        :param limit: Max no. of results to return. If no value is provided, 50 is the default.
        :type limit: int
        :param scope: Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. 
        :type scope: str
        :param sort_dir: Messages sort direction : ASC or DESC (default to DESC) 
        :type sort_dir: str
        :param tier: Target search tier : hot, warm or all (default to hot) 
        :type tier: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_search_post_serialize(
            session_token=session_token,
            query=query,
            skip=skip,
            limit=limit,
            scope=scope,
            sort_dir=sort_dir,
            tier=tier,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_message_search_post_without_preload_content(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        query: Annotated[MessageSearchQuery, Field(description="The search query. See above for the query syntax.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of results to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max no. of results to return. If no value is provided, 50 is the default.")] = None,
        scope: Annotated[Optional[StrictStr], Field(description="Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. ")] = None,
        sort_dir: Annotated[Optional[StrictStr], Field(description="Messages sort direction : ASC or DESC (default to DESC) ")] = None,
        tier: Annotated[Optional[StrictStr], Field(description="Target search tier : hot, warm or all (default to hot) ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search messages

        Search messages according to the specified criteria.

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param query: The search query. See above for the query syntax. (required)
        :type query: MessageSearchQuery
        :param skip: No. of results to skip.
        :type skip: int
        :param limit: Max no. of results to return. If no value is provided, 50 is the default.
        :type limit: int
        :param scope: Describes where content should be searched for that query. It can exclusively apply to Symphony content or to one Connector. 
        :type scope: str
        :param sort_dir: Messages sort direction : ASC or DESC (default to DESC) 
        :type sort_dir: str
        :param tier: Target search tier : hot, warm or all (default to hot) 
        :type tier: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v1_message_search_post_serialize(
            session_token=session_token,
            query=query,
            skip=skip,
            limit=limit,
            scope=scope,
            sort_dir=sort_dir,
            tier=tier,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_message_search_post_serialize(
        self,
        session_token,
        query,
        skip,
        limit,
        scope,
        sort_dir,
        tier,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if scope is not None:
            
            _query_params.append(('scope', scope))
            
        if sort_dir is not None:
            
            _query_params.append(('sortDir', sort_dir))
            
        if tier is not None:
            
            _query_params.append(('tier', tier))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter
        if query is not None:
            _body_params = query


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/message/search',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v1_stream_sid_message_create_post(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message: MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Message:
        """(Deprecated) Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message: (required)
        :type message: MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v1/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v1_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_stream_sid_message_create_post_with_http_info(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message: MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Message]:
        """(Deprecated) Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message: (required)
        :type message: MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v1/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v1_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_stream_sid_message_create_post_without_preload_content(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message: MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message: (required)
        :type message: MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v1/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v1_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_stream_sid_message_create_post_serialize(
        self,
        sid,
        session_token,
        message,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sid is not None:
            _path_params['sid'] = sid
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter
        if message is not None:
            _body_params = message


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/stream/{sid}/message/create',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v1_stream_sid_message_get(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        offset: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        max_messages: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[Message]:
        """(Deprecated) Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param offset: No. of messages to skip.
        :type offset: int
        :param max_messages: Max No. of messages to return. If no value is provided, 50 is the default.
        :type max_messages: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v1/stream/{sid}/message is deprecated.", DeprecationWarning)

        _param = self._v1_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            offset=offset,
            max_messages=max_messages,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Message]",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v1_stream_sid_message_get_with_http_info(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        offset: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        max_messages: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[Message]]:
        """(Deprecated) Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param offset: No. of messages to skip.
        :type offset: int
        :param max_messages: Max No. of messages to return. If no value is provided, 50 is the default.
        :type max_messages: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v1/stream/{sid}/message is deprecated.", DeprecationWarning)

        _param = self._v1_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            offset=offset,
            max_messages=max_messages,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Message]",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v1_stream_sid_message_get_without_preload_content(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        offset: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        max_messages: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param offset: No. of messages to skip.
        :type offset: int
        :param max_messages: Max No. of messages to return. If no value is provided, 50 is the default.
        :type max_messages: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v1/stream/{sid}/message is deprecated.", DeprecationWarning)

        _param = self._v1_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            offset=offset,
            max_messages=max_messages,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[Message]",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v1_stream_sid_message_get_serialize(
        self,
        sid,
        since,
        session_token,
        offset,
        max_messages,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sid is not None:
            _path_params['sid'] = sid
        # process the query parameters
        if since is not None:
            
            _query_params.append(('since', since))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if max_messages is not None:
            
            _query_params.append(('maxMessages', max_messages))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/stream/{sid}/message',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v2_message_import_post(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[V2ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[V2ImportResponse]:
        """(Deprecated) Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. Optionally the original message ID can be specified to identify the imported message for the purpose of repeat imports. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[V2ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v2/message/import is deprecated.", DeprecationWarning)

        _param = self._v2_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V2ImportResponse]",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v2_message_import_post_with_http_info(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[V2ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[V2ImportResponse]]:
        """(Deprecated) Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. Optionally the original message ID can be specified to identify the imported message for the purpose of repeat imports. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[V2ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v2/message/import is deprecated.", DeprecationWarning)

        _param = self._v2_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V2ImportResponse]",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v2_message_import_post_without_preload_content(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[V2ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. Optionally the original message ID can be specified to identify the imported message for the purpose of repeat imports. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[V2ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v2/message/import is deprecated.", DeprecationWarning)

        _param = self._v2_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V2ImportResponse]",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v2_message_import_post_serialize(
        self,
        session_token,
        message_list,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'messageList': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter
        if message_list is not None:
            _body_params = message_list


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v2/message/import',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v2_stream_sid_message_create_post(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message: V2MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2Message:
        """(Deprecated) Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message (see the V2MessageSubmission parameter).  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message: (required)
        :type message: V2MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v2/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v2_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v2_stream_sid_message_create_post_with_http_info(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message: V2MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2Message]:
        """(Deprecated) Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message (see the V2MessageSubmission parameter).  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message: (required)
        :type message: V2MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v2/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v2_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v2_stream_sid_message_create_post_without_preload_content(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message: V2MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message (see the V2MessageSubmission parameter).  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message: (required)
        :type message: V2MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v2/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v2_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v2_stream_sid_message_create_post_serialize(
        self,
        sid,
        session_token,
        message,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sid is not None:
            _path_params['sid'] = sid
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter
        if message is not None:
            _body_params = message


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v2/stream/{sid}/message/create',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v2_stream_sid_message_get(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        offset: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[V2BaseMessage]:
        """(Deprecated) Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param offset: No. of messages to skip.
        :type offset: int
        :param limit: Max No. of messages to return. If no value is provided, 50 is the default.
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v2/stream/{sid}/message is deprecated.", DeprecationWarning)

        _param = self._v2_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            offset=offset,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V2BaseMessage]",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v2_stream_sid_message_get_with_http_info(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        offset: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[V2BaseMessage]]:
        """(Deprecated) Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param offset: No. of messages to skip.
        :type offset: int
        :param limit: Max No. of messages to return. If no value is provided, 50 is the default.
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v2/stream/{sid}/message is deprecated.", DeprecationWarning)

        _param = self._v2_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            offset=offset,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V2BaseMessage]",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v2_stream_sid_message_get_without_preload_content(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        offset: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default.")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param offset: No. of messages to skip.
        :type offset: int
        :param limit: Max No. of messages to return. If no value is provided, 50 is the default.
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /v2/stream/{sid}/message is deprecated.", DeprecationWarning)

        _param = self._v2_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            offset=offset,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V2BaseMessage]",
            '204': None,
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v2_stream_sid_message_get_serialize(
        self,
        sid,
        since,
        session_token,
        offset,
        limit,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sid is not None:
            _path_params['sid'] = sid
        # process the query parameters
        if since is not None:
            
            _query_params.append(('since', since))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v2/stream/{sid}/message',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v3_stream_sid_message_create_post(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        message: V2MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V2Message:
        """(Deprecated) PROVISIONAL - Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message (see the V2MessageSubmission parameter).  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param message: (required)
        :type message: V2MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v3/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v3_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v3_stream_sid_message_create_post_with_http_info(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        message: V2MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V2Message]:
        """(Deprecated) PROVISIONAL - Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message (see the V2MessageSubmission parameter).  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param message: (required)
        :type message: V2MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v3/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v3_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v3_stream_sid_message_create_post_without_preload_content(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        message: V2MessageSubmission,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) PROVISIONAL - Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message (see the V2MessageSubmission parameter).  If the message parameter type is TEXT then the message contains plain text and cannot include formating, hash tags, mentions etc.  If the message parameter type is MessageML then the message contains MessageML which allows for these entities.  If the message is in MessageML and fails schema validation a client error results  If the message is sent then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param message: (required)
        :type message: V2MessageSubmission
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("POST /v3/stream/{sid}/message/create is deprecated.", DeprecationWarning)

        _param = self._v3_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            message=message,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V2Message",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v3_stream_sid_message_create_post_serialize(
        self,
        sid,
        session_token,
        message,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sid is not None:
            _path_params['sid'] = sid
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter
        if message is not None:
            _body_params = message


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v3/stream/{sid}/message/create',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v4_message_blast_post(
        self,
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        sids: Annotated[List[StrictStr], Field(description="A comma-separated list of Stream IDs")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4MessageBlastResponse:
        """Post a message to multiple existing streams.

        Post a new message to the given list of streams. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error results  This endpoint is idempotent, it means that a 200 response will be returned even if the message has not been delivered to some streams. Check the `errors` map from the response in order to see on which stream(s) the message has not been delivered.  The maximum number of streams where the message can be sent is limitted to 100.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param sids: A comma-separated list of Stream IDs (required)
        :type sids: List[str]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_message_blast_post_serialize(
            session_token=session_token,
            sids=sids,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4MessageBlastResponse",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v4_message_blast_post_with_http_info(
        self,
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        sids: Annotated[List[StrictStr], Field(description="A comma-separated list of Stream IDs")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4MessageBlastResponse]:
        """Post a message to multiple existing streams.

        Post a new message to the given list of streams. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error results  This endpoint is idempotent, it means that a 200 response will be returned even if the message has not been delivered to some streams. Check the `errors` map from the response in order to see on which stream(s) the message has not been delivered.  The maximum number of streams where the message can be sent is limitted to 100.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param sids: A comma-separated list of Stream IDs (required)
        :type sids: List[str]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_message_blast_post_serialize(
            session_token=session_token,
            sids=sids,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4MessageBlastResponse",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v4_message_blast_post_without_preload_content(
        self,
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        sids: Annotated[List[StrictStr], Field(description="A comma-separated list of Stream IDs")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Post a message to multiple existing streams.

        Post a new message to the given list of streams. The stream can be a chatroom, an IM or a multiparty IM.  You may include an attachment on the message.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error results  This endpoint is idempotent, it means that a 200 response will be returned even if the message has not been delivered to some streams. Check the `errors` map from the response in order to see on which stream(s) the message has not been delivered.  The maximum number of streams where the message can be sent is limitted to 100.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param sids: A comma-separated list of Stream IDs (required)
        :type sids: List[str]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_message_blast_post_serialize(
            session_token=session_token,
            sids=sids,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4MessageBlastResponse",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_message_blast_post_serialize(
        self,
        session_token,
        sids,
        key_manager_token,
        message,
        data,
        version,
        attachment,
        preview,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        if sids is not None:
            _form_params.append(('sids', sids))
        if message is not None:
            _form_params.append(('message', message))
        if data is not None:
            _form_params.append(('data', data))
        if version is not None:
            _form_params.append(('version', version))
        if attachment is not None:
            _files['attachment'] = attachment
        if preview is not None:
            _files['preview'] = preview
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v4/message/blast',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v4_message_import_post(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[V4ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[V4ImportResponse]:
        """Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. Optionally the original message ID can be specified to identify the imported message for the purpose of repeat imports. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[V4ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4ImportResponse]",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v4_message_import_post_with_http_info(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[V4ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[V4ImportResponse]]:
        """Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. Optionally the original message ID can be specified to identify the imported message for the purpose of repeat imports. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[V4ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4ImportResponse]",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v4_message_import_post_without_preload_content(
        self,
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        message_list: List[V4ImportedMessage],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Import messages from other systems into Symphony.

        Sends a message to be imported into the system. Allows you to override the timestamp and author of the message with your desired values. The requesting user must have the Content Management role. The user that the message is intended to have come from must also be present in the conversation. The intended message timestamp must be a valid time from the past. It cannot be a future timestamp. Optionally the original message ID can be specified to identify the imported message for the purpose of repeat imports. 

        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param message_list: (required)
        :type message_list: List[V4ImportedMessage]
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_message_import_post_serialize(
            session_token=session_token,
            message_list=message_list,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4ImportResponse]",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_message_import_post_serialize(
        self,
        session_token,
        message_list,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'messageList': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter
        if message_list is not None:
            _body_params = message_list


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v4/message/import',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v4_stream_sid_message_create_post(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4Message:
        """Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom,,an IM or a multiparty IM.  You may include an attachment on the message.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error will be returned.  If the message is sent then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v4_stream_sid_message_create_post_with_http_info(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4Message]:
        """Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom,,an IM or a multiparty IM.  You may include an attachment on the message.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error will be returned.  If the message is sent then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v4_stream_sid_message_create_post_without_preload_content(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Post a message to one existing stream.

        Post a new message to the given stream. The stream can be a chatroom,,an IM or a multiparty IM.  You may include an attachment on the message.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  If the message is in MessageML and fails schema validation a client error will be returned.  If the message is sent then 200 is returned.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together. 

        :param sid: Stream ID (required)
        :type sid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_create_post_serialize(
            sid=sid,
            session_token=session_token,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_stream_sid_message_create_post_serialize(
        self,
        sid,
        session_token,
        key_manager_token,
        message,
        data,
        version,
        attachment,
        preview,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sid is not None:
            _path_params['sid'] = sid
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        if message is not None:
            _form_params.append(('message', message))
        if data is not None:
            _form_params.append(('data', data))
        if version is not None:
            _form_params.append(('version', version))
        if attachment is not None:
            _files['attachment'] = attachment
        if preview is not None:
            _files['preview'] = preview
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v4/stream/{sid}/message/create',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v4_stream_sid_message_get(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[V4Message]:
        """Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param skip: No. of messages to skip.
        :type skip: int
        :param limit: Max No. of messages to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            skip=skip,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v4_stream_sid_message_get_with_http_info(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[V4Message]]:
        """Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param skip: No. of messages to skip.
        :type skip: int
        :param limit: Max No. of messages to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            skip=skip,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v4_stream_sid_message_get_without_preload_content(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        since: Annotated[StrictInt, Field(description="Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970 ")],
        session_token: Annotated[StrictStr, Field(description="Session authentication token.")],
        skip: Annotated[Optional[StrictInt], Field(description="No. of messages to skip.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Max No. of messages to return. If no value is provided, 50 is the default. The maximum supported value is 500. ")] = None,
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get messages from an existing stream.

        A caller can fetch all unseen messages by passing the timestamp of the last message seen as the since parameter and the number of messages with the same timestamp value already seen as the skip parameter. This means that every message will be seen exactly once even in the case that an additional message is processed with the same timestamp as the last message returned by the previous call, and the case where there are more than maxMessages with the same timestamp value.  This method is intended for historic queries and is generally reliable but if guaranteed delivery of every message in real time is required then the equivilent firehose method should be called. 

        :param sid: Stream ID (required)
        :type sid: str
        :param since: Timestamp of first required message.  This is a long integer value representing milliseconds since Jan 1 1970  (required)
        :type since: int
        :param session_token: Session authentication token. (required)
        :type session_token: str
        :param skip: No. of messages to skip.
        :type skip: int
        :param limit: Max No. of messages to return. If no value is provided, 50 is the default. The maximum supported value is 500. 
        :type limit: int
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_get_serialize(
            sid=sid,
            since=since,
            session_token=session_token,
            skip=skip,
            limit=limit,
            key_manager_token=key_manager_token,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[V4Message]",
            '204': None,
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_stream_sid_message_get_serialize(
        self,
        sid,
        since,
        session_token,
        skip,
        limit,
        key_manager_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sid is not None:
            _path_params['sid'] = sid
        # process the query parameters
        if since is not None:
            
            _query_params.append(('since', since))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/stream/{sid}/message',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def v4_stream_sid_message_mid_update_post(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        mid: Annotated[StrictStr, Field(description="ID of the message to be updated")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        silent: Annotated[Optional[StrictStr], Field(description="Optional boolean field that will determine if the user/s should receive the message as read or not (true by default) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4Message:
        """Update an existing message.

        Update an existing message. The existing message must be a valid social message, that has not been deleted.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together.  Starting with SBE v24.1, attachments are supported. 

        :param sid: Stream ID (required)
        :type sid: str
        :param mid: ID of the message to be updated (required)
        :type mid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param silent: Optional boolean field that will determine if the user/s should receive the message as read or not (true by default) 
        :type silent: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_mid_update_post_serialize(
            sid=sid,
            mid=mid,
            session_token=session_token,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            silent=silent,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def v4_stream_sid_message_mid_update_post_with_http_info(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        mid: Annotated[StrictStr, Field(description="ID of the message to be updated")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        silent: Annotated[Optional[StrictStr], Field(description="Optional boolean field that will determine if the user/s should receive the message as read or not (true by default) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4Message]:
        """Update an existing message.

        Update an existing message. The existing message must be a valid social message, that has not been deleted.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together.  Starting with SBE v24.1, attachments are supported. 

        :param sid: Stream ID (required)
        :type sid: str
        :param mid: ID of the message to be updated (required)
        :type mid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param silent: Optional boolean field that will determine if the user/s should receive the message as read or not (true by default) 
        :type silent: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_mid_update_post_serialize(
            sid=sid,
            mid=mid,
            session_token=session_token,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            silent=silent,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def v4_stream_sid_message_mid_update_post_without_preload_content(
        self,
        sid: Annotated[StrictStr, Field(description="Stream ID")],
        mid: Annotated[StrictStr, Field(description="ID of the message to be updated")],
        session_token: Annotated[StrictStr, Field(description="Authorization token used to make delegated calls.")],
        key_manager_token: Annotated[Optional[StrictStr], Field(description="Key Manager authentication token.")] = None,
        message: Annotated[Optional[StrictStr], Field(description="The message payload in MessageML.")] = None,
        data: Annotated[Optional[StrictStr], Field(description="Optional message data in EntityJSON.")] = None,
        version: Annotated[Optional[StrictStr], Field(description="Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. ")] = None,
        attachment: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional file attachment.")] = None,
        preview: Annotated[Optional[Union[StrictBytes, StrictStr, Tuple[StrictStr, StrictBytes]]], Field(description="Optional attachment preview.")] = None,
        silent: Annotated[Optional[StrictStr], Field(description="Optional boolean field that will determine if the user/s should receive the message as read or not (true by default) ")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update an existing message.

        Update an existing message. The existing message must be a valid social message, that has not been deleted.  The message can be provided as MessageMLV2 or PresentationML. Both formats support Freemarker templates.  The optional parameter \"data\" can be used to provide a JSON payload containing entity data. If the message contains explicit references to entity data (in \"data-entity-id\" element attributes), this parameter is required.  Regarding authentication, you must either use the sessionToken which was created for delegated app access or both the sessionToken and keyManagerToken together.  Starting with SBE v24.1, attachments are supported. 

        :param sid: Stream ID (required)
        :type sid: str
        :param mid: ID of the message to be updated (required)
        :type mid: str
        :param session_token: Authorization token used to make delegated calls. (required)
        :type session_token: str
        :param key_manager_token: Key Manager authentication token.
        :type key_manager_token: str
        :param message: The message payload in MessageML.
        :type message: str
        :param data: Optional message data in EntityJSON.
        :type data: str
        :param version: Optional message version in the format \\\"major.minor\\\". If empty, defaults to the latest supported version. 
        :type version: str
        :param attachment: Optional file attachment.
        :type attachment: bytearray
        :param preview: Optional attachment preview.
        :type preview: bytearray
        :param silent: Optional boolean field that will determine if the user/s should receive the message as read or not (true by default) 
        :type silent: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_stream_sid_message_mid_update_post_serialize(
            sid=sid,
            mid=mid,
            session_token=session_token,
            key_manager_token=key_manager_token,
            message=message,
            data=data,
            version=version,
            attachment=attachment,
            preview=preview,
            silent=silent,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4Message",
            '400': "V2Error",
            '401': "V2Error",
            '403': "V2Error",
            '451': "V2Error",
            '500': "V2Error",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_stream_sid_message_mid_update_post_serialize(
        self,
        sid,
        mid,
        session_token,
        key_manager_token,
        message,
        data,
        version,
        attachment,
        preview,
        silent,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if sid is not None:
            _path_params['sid'] = sid
        if mid is not None:
            _path_params['mid'] = mid
        # process the query parameters
        # process the header parameters
        if session_token is not None:
            _header_params['sessionToken'] = session_token
        if key_manager_token is not None:
            _header_params['keyManagerToken'] = key_manager_token
        # process the form parameters
        if message is not None:
            _form_params.append(('message', message))
        if data is not None:
            _form_params.append(('data', data))
        if version is not None:
            _form_params.append(('version', version))
        if attachment is not None:
            _files['attachment'] = attachment
        if preview is not None:
            _files['preview'] = preview
        if silent is not None:
            _form_params.append(('silent', silent))
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'multipart/form-data'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v4/stream/{sid}/message/{mid}/update',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


