# coding: utf-8

"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46. 

    The version of the OpenAPI document: 25.8.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.agent_model.v4_connection_accepted import V4ConnectionAccepted
from symphony.bdk.gen.agent_model.v4_connection_requested import V4ConnectionRequested
from symphony.bdk.gen.agent_model.v4_generic_system_event import V4GenericSystemEvent
from symphony.bdk.gen.agent_model.v4_instant_message_created import V4InstantMessageCreated
from symphony.bdk.gen.agent_model.v4_message_sent import V4MessageSent
from symphony.bdk.gen.agent_model.v4_message_suppressed import V4MessageSuppressed
from symphony.bdk.gen.agent_model.v4_room_created import V4RoomCreated
from symphony.bdk.gen.agent_model.v4_room_deactivated import V4RoomDeactivated
from symphony.bdk.gen.agent_model.v4_room_member_demoted_from_owner import V4RoomMemberDemotedFromOwner
from symphony.bdk.gen.agent_model.v4_room_member_promoted_to_owner import V4RoomMemberPromotedToOwner
from symphony.bdk.gen.agent_model.v4_room_reactivated import V4RoomReactivated
from symphony.bdk.gen.agent_model.v4_room_updated import V4RoomUpdated
from symphony.bdk.gen.agent_model.v4_shared_post import V4SharedPost
from symphony.bdk.gen.agent_model.v4_symphony_elements_action import V4SymphonyElementsAction
from symphony.bdk.gen.agent_model.v4_user_joined_room import V4UserJoinedRoom
from symphony.bdk.gen.agent_model.v4_user_left_room import V4UserLeftRoom
from symphony.bdk.gen.agent_model.v4_user_requested_to_join_room import V4UserRequestedToJoinRoom
from typing import Optional, Set
from typing_extensions import Self

class V4Payload(BaseModel):
    """
    V4Payload
    """ # noqa: E501
    message_sent: Optional[V4MessageSent] = Field(default=None, alias="messageSent")
    shared_post: Optional[V4SharedPost] = Field(default=None, alias="sharedPost")
    instant_message_created: Optional[V4InstantMessageCreated] = Field(default=None, alias="instantMessageCreated")
    room_created: Optional[V4RoomCreated] = Field(default=None, alias="roomCreated")
    room_updated: Optional[V4RoomUpdated] = Field(default=None, alias="roomUpdated")
    room_deactivated: Optional[V4RoomDeactivated] = Field(default=None, alias="roomDeactivated")
    room_reactivated: Optional[V4RoomReactivated] = Field(default=None, alias="roomReactivated")
    user_joined_room: Optional[V4UserJoinedRoom] = Field(default=None, alias="userJoinedRoom")
    user_left_room: Optional[V4UserLeftRoom] = Field(default=None, alias="userLeftRoom")
    room_member_promoted_to_owner: Optional[V4RoomMemberPromotedToOwner] = Field(default=None, alias="roomMemberPromotedToOwner")
    room_member_demoted_from_owner: Optional[V4RoomMemberDemotedFromOwner] = Field(default=None, alias="roomMemberDemotedFromOwner")
    connection_requested: Optional[V4ConnectionRequested] = Field(default=None, alias="connectionRequested")
    connection_accepted: Optional[V4ConnectionAccepted] = Field(default=None, alias="connectionAccepted")
    message_suppressed: Optional[V4MessageSuppressed] = Field(default=None, alias="messageSuppressed")
    symphony_elements_action: Optional[V4SymphonyElementsAction] = Field(default=None, alias="symphonyElementsAction")
    user_requested_to_join_room: Optional[V4UserRequestedToJoinRoom] = Field(default=None, alias="userRequestedToJoinRoom")
    generic_system_event: Optional[V4GenericSystemEvent] = Field(default=None, alias="genericSystemEvent")
    __properties: ClassVar[List[str]] = ["messageSent", "sharedPost", "instantMessageCreated", "roomCreated", "roomUpdated", "roomDeactivated", "roomReactivated", "userJoinedRoom", "userLeftRoom", "roomMemberPromotedToOwner", "roomMemberDemotedFromOwner", "connectionRequested", "connectionAccepted", "messageSuppressed", "symphonyElementsAction", "userRequestedToJoinRoom", "genericSystemEvent"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V4Payload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of message_sent
        if self.message_sent:
            _dict['messageSent'] = self.message_sent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shared_post
        if self.shared_post:
            _dict['sharedPost'] = self.shared_post.to_dict()
        # override the default output from pydantic by calling `to_dict()` of instant_message_created
        if self.instant_message_created:
            _dict['instantMessageCreated'] = self.instant_message_created.to_dict()
        # override the default output from pydantic by calling `to_dict()` of room_created
        if self.room_created:
            _dict['roomCreated'] = self.room_created.to_dict()
        # override the default output from pydantic by calling `to_dict()` of room_updated
        if self.room_updated:
            _dict['roomUpdated'] = self.room_updated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of room_deactivated
        if self.room_deactivated:
            _dict['roomDeactivated'] = self.room_deactivated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of room_reactivated
        if self.room_reactivated:
            _dict['roomReactivated'] = self.room_reactivated.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_joined_room
        if self.user_joined_room:
            _dict['userJoinedRoom'] = self.user_joined_room.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_left_room
        if self.user_left_room:
            _dict['userLeftRoom'] = self.user_left_room.to_dict()
        # override the default output from pydantic by calling `to_dict()` of room_member_promoted_to_owner
        if self.room_member_promoted_to_owner:
            _dict['roomMemberPromotedToOwner'] = self.room_member_promoted_to_owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of room_member_demoted_from_owner
        if self.room_member_demoted_from_owner:
            _dict['roomMemberDemotedFromOwner'] = self.room_member_demoted_from_owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of connection_requested
        if self.connection_requested:
            _dict['connectionRequested'] = self.connection_requested.to_dict()
        # override the default output from pydantic by calling `to_dict()` of connection_accepted
        if self.connection_accepted:
            _dict['connectionAccepted'] = self.connection_accepted.to_dict()
        # override the default output from pydantic by calling `to_dict()` of message_suppressed
        if self.message_suppressed:
            _dict['messageSuppressed'] = self.message_suppressed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of symphony_elements_action
        if self.symphony_elements_action:
            _dict['symphonyElementsAction'] = self.symphony_elements_action.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_requested_to_join_room
        if self.user_requested_to_join_room:
            _dict['userRequestedToJoinRoom'] = self.user_requested_to_join_room.to_dict()
        # override the default output from pydantic by calling `to_dict()` of generic_system_event
        if self.generic_system_event:
            _dict['genericSystemEvent'] = self.generic_system_event.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V4Payload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "messageSent": V4MessageSent.from_dict(obj["messageSent"]) if obj.get("messageSent") is not None else None,
            "sharedPost": V4SharedPost.from_dict(obj["sharedPost"]) if obj.get("sharedPost") is not None else None,
            "instantMessageCreated": V4InstantMessageCreated.from_dict(obj["instantMessageCreated"]) if obj.get("instantMessageCreated") is not None else None,
            "roomCreated": V4RoomCreated.from_dict(obj["roomCreated"]) if obj.get("roomCreated") is not None else None,
            "roomUpdated": V4RoomUpdated.from_dict(obj["roomUpdated"]) if obj.get("roomUpdated") is not None else None,
            "roomDeactivated": V4RoomDeactivated.from_dict(obj["roomDeactivated"]) if obj.get("roomDeactivated") is not None else None,
            "roomReactivated": V4RoomReactivated.from_dict(obj["roomReactivated"]) if obj.get("roomReactivated") is not None else None,
            "userJoinedRoom": V4UserJoinedRoom.from_dict(obj["userJoinedRoom"]) if obj.get("userJoinedRoom") is not None else None,
            "userLeftRoom": V4UserLeftRoom.from_dict(obj["userLeftRoom"]) if obj.get("userLeftRoom") is not None else None,
            "roomMemberPromotedToOwner": V4RoomMemberPromotedToOwner.from_dict(obj["roomMemberPromotedToOwner"]) if obj.get("roomMemberPromotedToOwner") is not None else None,
            "roomMemberDemotedFromOwner": V4RoomMemberDemotedFromOwner.from_dict(obj["roomMemberDemotedFromOwner"]) if obj.get("roomMemberDemotedFromOwner") is not None else None,
            "connectionRequested": V4ConnectionRequested.from_dict(obj["connectionRequested"]) if obj.get("connectionRequested") is not None else None,
            "connectionAccepted": V4ConnectionAccepted.from_dict(obj["connectionAccepted"]) if obj.get("connectionAccepted") is not None else None,
            "messageSuppressed": V4MessageSuppressed.from_dict(obj["messageSuppressed"]) if obj.get("messageSuppressed") is not None else None,
            "symphonyElementsAction": V4SymphonyElementsAction.from_dict(obj["symphonyElementsAction"]) if obj.get("symphonyElementsAction") is not None else None,
            "userRequestedToJoinRoom": V4UserRequestedToJoinRoom.from_dict(obj["userRequestedToJoinRoom"]) if obj.get("userRequestedToJoinRoom") is not None else None,
            "genericSystemEvent": V4GenericSystemEvent.from_dict(obj["genericSystemEvent"]) if obj.get("genericSystemEvent") is not None else None
        })
        return _obj


