# coding: utf-8

"""
    Symphony Profile Manager

    Profile Manager is a microservice to manage users profile and groups

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from symphony.bdk.gen.group_model.avatar import Avatar
from typing import Optional, Set
from typing_extensions import Self

class Profile(BaseModel):
    """
    Profile
    """ # noqa: E501
    display_name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="The display name in Directory, it is expected to be the same as group name", alias="displayName")
    company_name: Optional[StrictStr] = Field(default=None, description="The company name is expected to be the same as group company owner", alias="companyName")
    email: Optional[StrictStr] = None
    mobile: Optional[StrictStr] = None
    job_title: Optional[StrictStr] = Field(default=None, alias="jobTitle")
    job_role: Optional[StrictStr] = Field(default=None, alias="jobRole")
    job_department: Optional[StrictStr] = Field(default=None, alias="jobDepartment")
    job_division: Optional[StrictStr] = Field(default=None, alias="jobDivision")
    job_phone: Optional[StrictStr] = Field(default=None, alias="jobPhone")
    job_city: Optional[StrictStr] = Field(default=None, alias="jobCity")
    industry_of_interest: Optional[List[StrictStr]] = Field(default=None, alias="industryOfInterest")
    asset_classes_of_interest: Optional[List[StrictStr]] = Field(default=None, alias="assetClassesOfInterest")
    market_coverage: Optional[List[StrictStr]] = Field(default=None, alias="marketCoverage")
    responsibility: Optional[List[StrictStr]] = None
    function: Optional[List[StrictStr]] = None
    instrument: Optional[List[StrictStr]] = None
    id: Optional[StrictStr] = Field(default=None, description="Profile unique identifier")
    avatars: Optional[List[Avatar]] = None
    __properties: ClassVar[List[str]] = ["displayName", "companyName", "email", "mobile", "jobTitle", "jobRole", "jobDepartment", "jobDivision", "jobPhone", "jobCity", "industryOfInterest", "assetClassesOfInterest", "marketCoverage", "responsibility", "function", "instrument", "id", "avatars"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Profile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in avatars (list)
        _items = []
        if self.avatars:
            for _item_avatars in self.avatars:
                if _item_avatars:
                    _items.append(_item_avatars.to_dict())
            _dict['avatars'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Profile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "displayName": obj.get("displayName"),
            "companyName": obj.get("companyName"),
            "email": obj.get("email"),
            "mobile": obj.get("mobile"),
            "jobTitle": obj.get("jobTitle"),
            "jobRole": obj.get("jobRole"),
            "jobDepartment": obj.get("jobDepartment"),
            "jobDivision": obj.get("jobDivision"),
            "jobPhone": obj.get("jobPhone"),
            "jobCity": obj.get("jobCity"),
            "industryOfInterest": obj.get("industryOfInterest"),
            "assetClassesOfInterest": obj.get("assetClassesOfInterest"),
            "marketCoverage": obj.get("marketCoverage"),
            "responsibility": obj.get("responsibility"),
            "function": obj.get("function"),
            "instrument": obj.get("instrument"),
            "id": obj.get("id"),
            "avatars": [Avatar.from_dict(_item) for _item in obj["avatars"]] if obj.get("avatars") is not None else None
        })
        return _obj


