# coding: utf-8

"""
    Symphony Profile Manager

    Profile Manager is a microservice to manage users profile and groups

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from symphony.bdk.gen.group_model.group_implicit_connection import GroupImplicitConnection
from symphony.bdk.gen.group_model.group_interaction_transfer import GroupInteractionTransfer
from symphony.bdk.gen.group_model.group_visibility_restriction import GroupVisibilityRestriction
from symphony.bdk.gen.group_model.owner import Owner
from symphony.bdk.gen.group_model.profile import Profile
from symphony.bdk.gen.group_model.read_member import ReadMember
from symphony.bdk.gen.group_model.status import Status
from typing import Optional, Set
from typing_extensions import Self

class ReadGroup(BaseModel):
    """
    ReadGroup
    """ # noqa: E501
    type: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Group type identifier")
    owner_type: Owner = Field(alias="ownerType")
    owner_id: StrictInt = Field(description="Owner id if the owner type is tenant (podId) or user (userId), otherwise null", alias="ownerId")
    name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Group's name")
    id: Optional[StrictStr] = Field(default=None, description="Group's unique identifier")
    created_date: Optional[datetime] = Field(default=None, alias="createdDate")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    updated_date: Optional[datetime] = Field(default=None, alias="updatedDate")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    status: Optional[Status] = None
    e_tag: Optional[StrictStr] = Field(default=None, alias="eTag")
    sub_type: Optional[StrictStr] = Field(default=None, description="The type of the company group, This field is mandatory in case of a company group type, but not applicable for Symphony Distribution List", alias="subType")
    referrer: Optional[StrictStr] = Field(default=None, description="The referring company name. This field is mandatory in case of a company group type, but not applicable for Symphony Distribution List")
    members: Optional[List[ReadMember]] = None
    profile: Optional[Profile] = None
    visibility_restriction: Optional[GroupVisibilityRestriction] = Field(default=None, alias="visibilityRestriction")
    implicit_connection: Optional[GroupImplicitConnection] = Field(default=None, alias="implicitConnection")
    interaction_transfer: Optional[GroupInteractionTransfer] = Field(default=None, alias="interactionTransfer")
    __properties: ClassVar[List[str]] = ["type", "ownerType", "ownerId", "name", "id", "createdDate", "createdBy", "updatedDate", "updatedBy", "status", "eTag", "subType", "referrer", "members", "profile", "visibilityRestriction", "implicitConnection", "interactionTransfer"]

    @field_validator('sub_type')
    def sub_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['COMMUNITY', 'CHANNEL']):
            raise ValueError("must be one of enum values ('COMMUNITY', 'CHANNEL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ReadGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in members (list)
        _items = []
        if self.members:
            for _item_members in self.members:
                if _item_members:
                    _items.append(_item_members.to_dict())
            _dict['members'] = _items
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        # override the default output from pydantic by calling `to_dict()` of visibility_restriction
        if self.visibility_restriction:
            _dict['visibilityRestriction'] = self.visibility_restriction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of implicit_connection
        if self.implicit_connection:
            _dict['implicitConnection'] = self.implicit_connection.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interaction_transfer
        if self.interaction_transfer:
            _dict['interactionTransfer'] = self.interaction_transfer.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ReadGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "ownerType": obj.get("ownerType"),
            "ownerId": obj.get("ownerId"),
            "name": obj.get("name"),
            "id": obj.get("id"),
            "createdDate": obj.get("createdDate"),
            "createdBy": obj.get("createdBy"),
            "updatedDate": obj.get("updatedDate"),
            "updatedBy": obj.get("updatedBy"),
            "status": obj.get("status"),
            "eTag": obj.get("eTag"),
            "subType": obj.get("subType"),
            "referrer": obj.get("referrer"),
            "members": [ReadMember.from_dict(_item) for _item in obj["members"]] if obj.get("members") is not None else None,
            "profile": Profile.from_dict(obj["profile"]) if obj.get("profile") is not None else None,
            "visibilityRestriction": GroupVisibilityRestriction.from_dict(obj["visibilityRestriction"]) if obj.get("visibilityRestriction") is not None else None,
            "implicitConnection": GroupImplicitConnection.from_dict(obj["implicitConnection"]) if obj.get("implicitConnection") is not None else None,
            "interactionTransfer": GroupInteractionTransfer.from_dict(obj["interactionTransfer"]) if obj.get("interactionTransfer") is not None else None
        })
        return _obj


