# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.message_download_receipt_count import MessageDownloadReceiptCount
from symphony.bdk.gen.pod_model.message_stream import MessageStream
from symphony.bdk.gen.pod_model.message_user import MessageUser
from typing import Optional, Set
from typing_extensions import Self

class MessageDetail(BaseModel):
    """
    Message detail
    """ # noqa: E501
    message_id: Optional[StrictStr] = Field(default=None, description="message id", alias="messageId")
    creator: Optional[MessageUser] = None
    on_behalf_of_user: Optional[MessageUser] = Field(default=None, alias="onBehalfOfUser")
    stream: Optional[MessageStream] = None
    creation_date: Optional[StrictInt] = Field(default=None, alias="creationDate")
    delivery_receipt_count: Optional[StrictInt] = Field(default=None, alias="deliveryReceiptCount")
    read_receipt_count: Optional[StrictInt] = Field(default=None, alias="readReceiptCount")
    email_notification_count: Optional[StrictInt] = Field(default=None, alias="emailNotificationCount")
    download_receipt_counts: Optional[List[MessageDownloadReceiptCount]] = Field(default=None, alias="downloadReceiptCounts")
    __properties: ClassVar[List[str]] = ["messageId", "creator", "onBehalfOfUser", "stream", "creationDate", "deliveryReceiptCount", "readReceiptCount", "emailNotificationCount", "downloadReceiptCounts"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MessageDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of creator
        if self.creator:
            _dict['creator'] = self.creator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of on_behalf_of_user
        if self.on_behalf_of_user:
            _dict['onBehalfOfUser'] = self.on_behalf_of_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stream
        if self.stream:
            _dict['stream'] = self.stream.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in download_receipt_counts (list)
        _items = []
        if self.download_receipt_counts:
            for _item_download_receipt_counts in self.download_receipt_counts:
                if _item_download_receipt_counts:
                    _items.append(_item_download_receipt_counts.to_dict())
            _dict['downloadReceiptCounts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MessageDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "messageId": obj.get("messageId"),
            "creator": MessageUser.from_dict(obj["creator"]) if obj.get("creator") is not None else None,
            "onBehalfOfUser": MessageUser.from_dict(obj["onBehalfOfUser"]) if obj.get("onBehalfOfUser") is not None else None,
            "stream": MessageStream.from_dict(obj["stream"]) if obj.get("stream") is not None else None,
            "creationDate": obj.get("creationDate"),
            "deliveryReceiptCount": obj.get("deliveryReceiptCount"),
            "readReceiptCount": obj.get("readReceiptCount"),
            "emailNotificationCount": obj.get("emailNotificationCount"),
            "downloadReceiptCounts": [MessageDownloadReceiptCount.from_dict(_item) for _item in obj["downloadReceiptCounts"]] if obj.get("downloadReceiptCounts") is not None else None
        })
        return _obj


