# coding: utf-8

"""
    Pod API

    This document refers to Symphony API calls that do not need encryption or decryption of content.  - sessionToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have made no change to the system even if ome subset of the request would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. 

    The version of the OpenAPI document: 20.17.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from symphony.bdk.gen.pod_model.group_role_scope import GroupRoleScope
from symphony.bdk.gen.pod_model.user_compp import UserCompp
from typing import Optional, Set
from typing_extensions import Self

class UserGroupAssignmentResponse(BaseModel):
    """
    User Group assignment response object
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Assignment ID")
    group_id: Optional[StrictStr] = Field(default=None, description="Group ID", alias="groupId")
    group: Optional[GroupRoleScope] = None
    user_id: Optional[StrictInt] = Field(default=None, description="User ID", alias="userId")
    user: Optional[UserCompp] = None
    user_roles: Optional[List[StrictStr]] = Field(default=None, alias="userRoles")
    active: Optional[StrictBool] = Field(default=None, description="Group membership status")
    last_added_date: Optional[StrictInt] = Field(default=None, description="Date of group membership last added", alias="lastAddedDate")
    last_removed_date: Optional[StrictInt] = Field(default=None, description="Date of group membership last removed", alias="lastRemovedDate")
    __properties: ClassVar[List[str]] = ["id", "groupId", "group", "userId", "user", "userRoles", "active", "lastAddedDate", "lastRemovedDate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserGroupAssignmentResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group
        if self.group:
            _dict['group'] = self.group.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserGroupAssignmentResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "groupId": obj.get("groupId"),
            "group": GroupRoleScope.from_dict(obj["group"]) if obj.get("group") is not None else None,
            "userId": obj.get("userId"),
            "user": UserCompp.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "userRoles": obj.get("userRoles"),
            "active": obj.get("active"),
            "lastAddedDate": obj.get("lastAddedDate"),
            "lastRemovedDate": obj.get("lastRemovedDate")
        })
        return _obj


