/******/ var __webpack_modules__ = ({

/***/ "../../node_modules/arquero/src/arrow/arrow-column.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/arrow-column.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ arrowColumn)
/* harmony export */ });
/* harmony import */ var _arrow_dictionary__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./arrow-dictionary */ "../../node_modules/arquero/src/arrow/arrow-dictionary.js");
/* harmony import */ var _arrow_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./arrow-types */ "../../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/repeat */ "../../node_modules/arquero/src/util/repeat.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/unroll */ "../../node_modules/arquero/src/util/unroll.js");







const isList = id => id === _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].List || id === _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].FixedSizeList;

/**
 * Create an Arquero column that proxies access to an Arrow column.
 * @param {object} arrow An Apache Arrow column.
 * @return {import('../table/column').ColumnType} An Arquero-compatible column.
 */
function arrowColumn(arrow, nested) {
  if (arrow.dictionary) return (0,_arrow_dictionary__WEBPACK_IMPORTED_MODULE_0__["default"])(arrow);
  const { typeId, chunks, length, numChildren } = arrow;
  const vector = chunks && chunks.length === 1 ? chunks[0] : arrow;
  const get = numChildren && nested ? getNested(vector)
    : numChildren ? memoize(getNested(vector))
    : typeId === _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Utf8 ? memoize(row => vector.get(row))
    : null;

  return get
    ? { vector, length, get, [Symbol.iterator]: () => iterator(length, get) }
    : vector;
}

function memoize(get) {
  const values = [];
  return row => {
    const v = values[row];
    return v !== undefined ? v : (values[row] = get(row));
  };
}

function* iterator(n, get) {
  for (let i = 0; i < n; ++i) {
    yield get(i);
  }
}

const arrayFrom = vector => vector.numChildren
  ? (0,_util_repeat__WEBPACK_IMPORTED_MODULE_3__["default"])(vector.length, getNested(vector))
  : vector.nullCount ? [...vector]
  : vector.toArray();

const getNested = vector => isList(vector.typeId) ? getList(vector)
  : vector.typeId === _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Struct ? getStruct(vector)
  : (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(`Unsupported Arrow type: ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_4__["default"])(vector.VectorName)}`);

const getList = vector => vector.nullCount
  ? row => vector.isValid(row) ? arrayFrom(vector.get(row)) : null
  : row => arrayFrom(vector.get(row));

function getStruct(vector) {
  const props = [];
  const code = [];
  vector.type.children.forEach((field, i) => {
    props.push(arrowColumn(vector.getChildAt(i), true));
    code.push(`${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_4__["default"])(field.name)}:_${i}.get(row)`);
  });
  const get = (0,_util_unroll__WEBPACK_IMPORTED_MODULE_5__["default"])('row', '({' + code + '})', props);

  return vector.nullCount
    ? row => vector.isValid(row) ? get(row) : null
    : get;
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/arrow-dictionary.js":
/*!****************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/arrow-dictionary.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _op_functions_sequence__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../op/functions/sequence */ "../../node_modules/arquero/src/op/functions/sequence.js");


/**
 * Create a new Arquero column that proxies access to an
 * Apache Arrow dictionary column.
 * @param {object} vector An Apache Arrow dictionary column.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(vector) {
  const { chunks, dictionary, length, nullCount } = vector;
  const size = dictionary.length;
  const keys = dictKeys(chunks || [vector], length, nullCount, size);
  const values = Array(size);

  const value = k => k == null || k < 0 || k >= size ? null
    : values[k] !== undefined ? values[k]
    : (values[k] = dictionary.get(k));

  return {
    vector,
    length,

    get: row => value(keys[row]),

    key: row => keys[row],

    keyFor(value) {
      if (value === null) return nullCount ? size : -1;
      for (let i = 0; i < size; ++i) {
        if (values[i] === undefined) values[i] = dictionary.get(i);
        if (values[i] === value) return i;
      }
      return -1;
    },

    groups(names) {
      const s = size + (nullCount ? 1 : 0);
      return { keys, get: [value], names, rows: (0,_op_functions_sequence__WEBPACK_IMPORTED_MODULE_0__["default"])(0, s), size: s };
    },

    [Symbol.iterator]() {
      return vector[Symbol.iterator]();
    }
  };
}

/**
 * Generate a dictionary key array
 * @param {object[]} chunks Arrow column chunks
 * @param {number} length The length of the Arrow column
 * @param {number} nulls The count of column null values
 * @param {number} size The backing dictionary size
 */
function dictKeys(chunks, length, nulls, size) {
  const v = chunks.length > 1 || nulls
    ? flatten(chunks, length, chunks[0].type.indices)
    : chunks[0].values;
  return nulls ? nullKeys(chunks, v, size) : v;
}

/**
 * Flatten Arrow column chunks into a single array.
 */
function flatten(chunks, length, type) {
  const array = new type.ArrayType(length);
  const n = chunks.length;
  for (let i = 0, idx = 0, len; i < n; ++i) {
    len = chunks[i].length;
    array.set(chunks[i].values.subarray(0, len), idx);
    idx += len;
  }
  return array;
}

/**
 * Encode null values as an additional dictionary key.
 * Returns a new key array with null values added.
 * TODO: safeguard against integer overflow?
 */
function nullKeys(chunks, keys, key) {
  // iterate over null bitmaps, encode null values as key
  const n = chunks.length;
  for (let i = 0, idx = 0, m, base, bits, byte; i < n; ++i) {
    bits = chunks[i].nullBitmap;
    m = chunks[i].length >> 3;
    if (bits && bits.length) {
      for (let j = 0; j <= m; ++j) {
        if ((byte = bits[j]) !== 255) {
          base = idx + (j << 3);
          if ((byte & (1 << 0)) === 0) keys[base + 0] = key;
          if ((byte & (1 << 1)) === 0) keys[base + 1] = key;
          if ((byte & (1 << 2)) === 0) keys[base + 2] = key;
          if ((byte & (1 << 3)) === 0) keys[base + 3] = key;
          if ((byte & (1 << 4)) === 0) keys[base + 4] = key;
          if ((byte & (1 << 5)) === 0) keys[base + 5] = key;
          if ((byte & (1 << 6)) === 0) keys[base + 6] = key;
          if ((byte & (1 << 7)) === 0) keys[base + 7] = key;
        }
      }
    }
    idx += chunks[i].length;
  }
  return keys;
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/arrow-table.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/arrow-table.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   from: () => (/* binding */ from),
/* harmony export */   table: () => (/* binding */ table)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");



function table() {
  // trap Table access to provide a helpful message
  // when Apache Arrow has not been imported
  try {
    return apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Table;
  } catch (err) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])(
      'Apache Arrow not imported, ' +
      'see https://github.com/uwdata/arquero#usage'
    );
  }
}

function from(arrow) {
  return arrow && arrow.chunks ? arrow : table().from(arrow);
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/arrow-types.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/arrow-types.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// Hardwire Arrow type ids to sidestep dependency
// https://github.com/apache/arrow/blob/master/js/src/enum.ts

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /** The default placeholder type */
  NONE: 0,
  /** A NULL type having no physical storage */
  Null: 1,
  /** Signed or unsigned 8, 16, 32, or 64-bit little-endian integer */
  Int: 2,
  /** 2, 4, or 8-byte floating point value */
  Float: 3,
  /** Variable-length bytes (no guarantee of UTF8-ness) */
  Binary: 4,
  /** UTF8 variable-length string as List<Char> */
  Utf8: 5,
  /** Boolean as 1 bit, LSB bit-packed ordering */
  Bool: 6,
  /** Precision-and-scale-based decimal type. Storage type depends on the parameters. */
  Decimal: 7,
  /** int32_t days or int64_t milliseconds since the UNIX epoch */
  Date: 8,
  /** Time as signed 32 or 64-bit integer, representing either seconds, milliseconds, microseconds, or nanoseconds since midnight since midnight */
  Time: 9,
  /** Exact timestamp encoded with int64 since UNIX epoch (Default unit millisecond) */
  Timestamp: 10,
  /** YEAR_MONTH or DAY_TIME interval in SQL style */
  Interval: 11,
  /** A list of some logical data type */
  List: 12,
  /** Struct of logical types */
  Struct: 13,
  /** Union of logical types */
  Union: 14,
  /** Fixed-size binary. Each value occupies the same number of bytes */
  FixedSizeBinary: 15,
  /** Fixed-size list. Each value occupies the same number of bytes */
  FixedSizeList: 16,
  /** Map of named logical types */
  Map: 17,

  /** Dictionary aka Category type */
  Dictionary: -1,
  Int8: -2,
  Int16: -3,
  Int32: -4,
  Int64: -5,
  Uint8: -6,
  Uint16: -7,
  Uint32: -8,
  Uint64: -9,
  Float16: -10,
  Float32: -11,
  Float64: -12,
  DateDay: -13,
  DateMillisecond: -14,
  TimestampSecond: -15,
  TimestampMillisecond: -16,
  TimestampMicrosecond: -17,
  TimestampNanosecond: -18,
  TimeSecond: -19,
  TimeMillisecond: -20,
  TimeMicrosecond: -21,
  TimeNanosecond: -22,
  DenseUnion: -23,
  SparseUnion: -24,
  IntervalDayTime: -25,
  IntervalYearMonth: -26
});

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/array-builder.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/array-builder.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(type.ArrayType, length);
  return {
    set(value, index) { data[index] = value; },
    data: () => ({ type, length, buffers: [null, data] })
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/bool-builder.js":
/*!********************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/bool-builder.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(type.ArrayType, length / 8);
  return {
    set(value, index) {
      if (value) data[index >> 3] |= (1 << (index % 8));
    },
    data: () => ({ type, length, buffers: [null, data] })
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/date-day-builder.js":
/*!************************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/date-day-builder.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(type.ArrayType, length);
  return {
    set(value, index) { data[index] = (value / 86400000) | 0; },
    data: () => ({ type, length, buffers: [null, data] })
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/date-millis-builder.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/date-millis-builder.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(type.ArrayType, length << 1);
  return {
    set(value, index) {
      const i = index << 1;
      data[  i] = (value % 4294967296) | 0;
      data[i+1] = (value / 4294967296) | 0;
    },
    data: () => ({ type, length, buffers: [null, data] })
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/default-builder.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/default-builder.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../../node_modules/apache-arrow/Arrow.dom.mjs");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type) {
  const b = apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Builder.new({
    type,
    nullValues: [null, undefined],
    highWaterMark: Infinity
  });
  return {
    set(value, index) { b.set(index, value); },
    data: () => b.finish().flush()
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/dictionary-builder.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/dictionary-builder.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utf8_builder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utf8-builder */ "../../node_modules/arquero/src/arrow/builder/utf8-builder.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/arrow/builder/util.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length) {
  const values = [];
  const data = (0,_util__WEBPACK_IMPORTED_MODULE_1__.array)(type.indices.ArrayType, length);
  const keys = Object.create(null);

  let next = -1;
  let strlen = 0;

  return {
    set(value, index) {
      const v = String(value);
      let k = keys[v];
      if (k === undefined) {
        strlen += v.length;
        keys[v] = k = ++next;
        values.push(v);
      }
      data[index] = k;
    },
    data: () => ({
      type,
      length,
      buffers: [null, data],
      dict: dictionary(type.dictionary, values, strlen)
    })
  };
}

function dictionary(type, values, strlen) {
  const b = (0,_utf8_builder__WEBPACK_IMPORTED_MODULE_0__["default"])(type, values.length, strlen);
  values.forEach(b.set);
  return (0,_util__WEBPACK_IMPORTED_MODULE_1__.arrowVector)(b.data());
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/index.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrow_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../arrow-types */ "../../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _array_builder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./array-builder */ "../../node_modules/arquero/src/arrow/builder/array-builder.js");
/* harmony import */ var _bool_builder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./bool-builder */ "../../node_modules/arquero/src/arrow/builder/bool-builder.js");
/* harmony import */ var _date_day_builder__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./date-day-builder */ "../../node_modules/arquero/src/arrow/builder/date-day-builder.js");
/* harmony import */ var _date_millis_builder__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./date-millis-builder */ "../../node_modules/arquero/src/arrow/builder/date-millis-builder.js");
/* harmony import */ var _default_builder__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./default-builder */ "../../node_modules/arquero/src/arrow/builder/default-builder.js");
/* harmony import */ var _dictionary_builder__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dictionary-builder */ "../../node_modules/arquero/src/arrow/builder/dictionary-builder.js");
/* harmony import */ var _valid_builder__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./valid-builder */ "../../node_modules/arquero/src/arrow/builder/valid-builder.js");









/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, nrows, nullable = true) {
  let method;

  switch (type.typeId) {
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Int:
      method = type.bitWidth < 64 ? _array_builder__WEBPACK_IMPORTED_MODULE_1__["default"] : null;
      break;
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Float:
      method = type.precision > 0 ? _array_builder__WEBPACK_IMPORTED_MODULE_1__["default"] : null;
      break;
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Dictionary:
      // check sub-types against builder assumptions
      // if check fails, fallback to default builder
      method = (
        type.dictionary.typeId === _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Utf8 &&
        type.indices.typeId === _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Int &&
        type.indices.bitWidth < 64
      ) ? _dictionary_builder__WEBPACK_IMPORTED_MODULE_6__["default"] : null;
      break;
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Bool:
      method = _bool_builder__WEBPACK_IMPORTED_MODULE_2__["default"];
      break;
    case _arrow_types__WEBPACK_IMPORTED_MODULE_0__["default"].Date:
      method = type.unit ? _date_millis_builder__WEBPACK_IMPORTED_MODULE_4__["default"] : _date_day_builder__WEBPACK_IMPORTED_MODULE_3__["default"];
      break;
  }

  return method == null ? (0,_default_builder__WEBPACK_IMPORTED_MODULE_5__["default"])(type)
    : nullable ? (0,_valid_builder__WEBPACK_IMPORTED_MODULE_7__["default"])(method(type, nrows), nrows)
    : method(type, nrows);
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/resolve-type.js":
/*!********************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/resolve-type.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _arrow_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../arrow-types */ "../../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type) {
  if (type instanceof apache_arrow__WEBPACK_IMPORTED_MODULE_0__.DataType || type == null) {
    return type;
  }

  switch (type) {
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Binary:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Binary();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Bool:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Bool();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].DateDay:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.DateDay();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].DateMillisecond:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Date:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.DateMillisecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Dictionary:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Dictionary(new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Utf8(), new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int32());
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float16:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float16();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float32:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float32();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float64:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float64();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int8:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int8();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int16:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int16();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int32:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int32();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int64:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int64();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].IntervalDayTime:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.IntervalDayTime();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Interval:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].IntervalYearMonth:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.IntervalYearMonth();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Null:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Null();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].TimeMicrosecond:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.TimeMicrosecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].TimeMillisecond:
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Time:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.TimeMillisecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].TimeNanosecond:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.TimeNanosecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].TimeSecond:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.TimeSecond();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint8:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint8();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint16:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint16();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint32:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint32();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint64:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint64();
    case _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Utf8:
      return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Utf8();
    default:
      (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(
        `Unsupported type code: ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_3__["default"])(type)}. ` +
        'Use a data type constructor instead?'
      );
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/utf8-builder.js":
/*!********************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/utf8-builder.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(type, length, strlen) {
  const offset = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(Int32Array, length + 1);
  const buf = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(Uint8Array, 3 * strlen);

  let idx = 0;

  return {
    set(value, index) {
      idx += (0,_util__WEBPACK_IMPORTED_MODULE_0__.writeUtf8)(buf, idx, value);
      offset[index + 1] = idx;
    },
    data: () => {
      // slice utf buffer if over-allocated
      const dlen = (0,_util__WEBPACK_IMPORTED_MODULE_0__.ceil64Bytes)(idx);
      const data = buf.length > dlen ? buf.subarray(0, dlen) : buf;
      return { type, length, buffers: [offset, data] };
    }
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/util.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/util.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   array: () => (/* binding */ array),
/* harmony export */   arrowData: () => (/* binding */ arrowData),
/* harmony export */   arrowVector: () => (/* binding */ arrowVector),
/* harmony export */   ceil64Bytes: () => (/* binding */ ceil64Bytes),
/* harmony export */   encode: () => (/* binding */ encode),
/* harmony export */   encodeInto: () => (/* binding */ encodeInto),
/* harmony export */   encoder: () => (/* binding */ encoder),
/* harmony export */   writeUtf8: () => (/* binding */ writeUtf8)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../../node_modules/apache-arrow/Arrow.dom.mjs");


function ceil64Bytes(length, bpe = 1) {
  return ((((length * bpe) + 63) & ~63) || 64) / bpe;
}

function array(Type, length, bpe = Type.BYTES_PER_ELEMENT) {
  return new Type(ceil64Bytes(length, bpe));
}

function arrowData(d) {
  return d instanceof apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Data
    ? d
    : apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Data.new(d.type, 0, d.length, d.nulls, d.buffers, null, d.dict);
}

function arrowVector(data) {
  return apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Vector.new(arrowData(data));
}

const encoder = new TextEncoder();

function encode(data, idx, str) {
  const bytes = encoder.encode(str);
  data.set(bytes, idx);
  return bytes.length;
}

function encodeInto(data, idx, str) {
  return encoder.encodeInto(str, data.subarray(idx)).written;
}

const writeUtf8 = encoder.encodeInto ? encodeInto : encode;

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/builder/valid-builder.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/builder/valid-builder.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/arrow/builder/util.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(builder, length) {
  const valid = (0,_util__WEBPACK_IMPORTED_MODULE_0__.array)(Uint8Array, length / 8);
  let nulls = 0;

  return {
    set(value, index) {
      if (value == null) {
        ++nulls;
      } else {
        builder.set(value, index);
        valid[index >> 3] |= (1 << (index % 8));
      }
    },
    data: () => {
      const d = builder.data();
      if (nulls) {
        d.nulls = nulls;
        d.buffers[2] = valid;
      }
      return d;
    }
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/encode/data-from-objects.js":
/*!************************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/encode/data-from-objects.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _data_from__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./data-from */ "../../node_modules/arquero/src/arrow/encode/data-from.js");
/* harmony import */ var _profiler__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./profiler */ "../../node_modules/arquero/src/arrow/encode/profiler.js");
/* harmony import */ var _builder_resolve_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../builder/resolve-type */ "../../node_modules/arquero/src/arrow/builder/resolve-type.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(data, name, nrows, scan, type, nullable = true) {
  type = (0,_builder_resolve_type__WEBPACK_IMPORTED_MODULE_2__["default"])(type);

  // perform type inference if needed
  if (!type) {
    const p = (0,_profiler__WEBPACK_IMPORTED_MODULE_1__.profile)(scan, name);
    nullable = p.nulls > 0;
    type = p.type();
  }

  return (0,_data_from__WEBPACK_IMPORTED_MODULE_0__.dataFromScan)(nrows, scan, name, type, nullable);
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/encode/data-from-table.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/encode/data-from-table.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _data_from__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./data-from */ "../../node_modules/arquero/src/arrow/encode/data-from.js");
/* harmony import */ var _profiler__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./profiler */ "../../node_modules/arquero/src/arrow/encode/profiler.js");
/* harmony import */ var _builder_resolve_type__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../builder/resolve-type */ "../../node_modules/arquero/src/arrow/builder/resolve-type.js");
/* harmony import */ var _util_is_typed_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/is-typed-array */ "../../node_modules/arquero/src/util/is-typed-array.js");






/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, name, nrows, scan, type, nullable = true) {
  type = (0,_builder_resolve_type__WEBPACK_IMPORTED_MODULE_3__["default"])(type);
  const column = table.column(name);
  const reified = !(table.isFiltered() || table.isOrdered());

  // use existing arrow data if types match
  const vec = arrowVector(column);
  if (vec && reified && typeCompatible(vec.type, type)) {
    return vec;
  }

  // if backing data is a typed array, leverage that
  const data = column.data;
  if ((0,_util_is_typed_array__WEBPACK_IMPORTED_MODULE_4__["default"])(data)) {
    const dtype = typeFromArray(data);
    if (reified && dtype && typeCompatible(dtype, type)) {
      return (0,_data_from__WEBPACK_IMPORTED_MODULE_1__.dataFromArray)(data, dtype);
    } else {
      type = type || dtype;
      nullable = false;
    }
  }

  // perform type inference if needed
  if (!type) {
    const p = (0,_profiler__WEBPACK_IMPORTED_MODULE_2__.profile)(scan, column);
    nullable = p.nulls > 0;
    type = p.type();
  }

  return (0,_data_from__WEBPACK_IMPORTED_MODULE_1__.dataFromScan)(nrows, scan, column, type, nullable);
}

function arrowVector(value) {
  return value instanceof apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Vector ? value
    : value.vector instanceof apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Vector ? value.vector
    : null;
}

function typeFromArray(data) {
  const types = {
    Float32Array:    apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float32,
    Float64Array:    apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Float64,
    Int8Array:       apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int8,
    Int16Array:      apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int16,
    Int32Array:      apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int32,
    Uint8Array:      apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint8,
    Uint16Array:     apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint16,
    Uint32Array:     apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint32,
    BigInt64Array:   apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Int64,
    BigUint64Array:  apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Uint64
  };
  const Type = types[data.constructor.name];
  return Type ? new Type() : null;
}

function typeCompatible(a, b) {
  return !a || !b ? true : a.compareTo(b);
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/encode/data-from.js":
/*!****************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/encode/data-from.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dataFromArray: () => (/* binding */ dataFromArray),
/* harmony export */   dataFromScan: () => (/* binding */ dataFromScan)
/* harmony export */ });
/* harmony import */ var _builder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../builder */ "../../node_modules/arquero/src/arrow/builder/index.js");
/* harmony import */ var _builder_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../builder/util */ "../../node_modules/arquero/src/arrow/builder/util.js");



function dataFromArray(array, type) {
  const length = array.length;
  const size = (0,_builder_util__WEBPACK_IMPORTED_MODULE_1__.ceil64Bytes)(length, array.BYTES_PER_ELEMENT);

  let data = array;
  if (length !== size) {
    data = new array.constructor(size);
    data.set(array);
  }

  return (0,_builder_util__WEBPACK_IMPORTED_MODULE_1__.arrowData)({ type, length, buffers: [null, data] });
}

function dataFromScan(nrows, scan, column, type, nullable = true) {
  const b = (0,_builder__WEBPACK_IMPORTED_MODULE_0__["default"])(type, nrows, nullable);
  scan(column, b.set);
  return (0,_builder_util__WEBPACK_IMPORTED_MODULE_1__.arrowData)(b.data());
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/encode/index.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/encode/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _data_from_objects__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./data-from-objects */ "../../node_modules/arquero/src/arrow/encode/data-from-objects.js");
/* harmony import */ var _data_from_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./data-from-table */ "../../node_modules/arquero/src/arrow/encode/data-from-table.js");
/* harmony import */ var _scan__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./scan */ "../../node_modules/arquero/src/arrow/encode/scan.js");
/* harmony import */ var _arrow_table__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../arrow-table */ "../../node_modules/arquero/src/arrow/arrow-table.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
 // eslint-disable-line no-unused-vars









/**
 * Options for Arrow encoding.
 * @typedef {object} ArrowFormatOptions
 * @property {number} [limit=Infinity] The maximum number of rows to include.
 * @property {number} [offset=0] The row offset indicating how many initial
 *  rows to skip.
 * @property {string[]|(data: object) => string[]} [columns] Ordered list of
 *  column names to include. If function-valued, the function should accept
 *  a dataset as input and return an array of column name strings.
 * @property {object} [types] The Arrow data types to use. If specified,
 *  the input should be an object with column names for keys and Arrow data
 *  types for values. If a column type is not explicitly provided, type
 *  inference will be performed to guess an appropriate type.
 */

/**
 * Create an Apache Arrow table for an input dataset.
 * @param {Array|object} data An input dataset to convert to Arrow format.
 *  If array-valued, the data should consist of an array of objects where
 *  each entry represents a row and named properties represent columns.
 *  Otherwise, the input data should be an Arquero table.
 * @param {ArrowFormatOptions} [options] Encoding options, including
 *  column data types.
 * @return {Table} An Apache Arrow Table instance.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(data, options = {}) {
  const { types = {} } = options;
  const { dataFrom, names, nrows, scan } = init(data, options);
  return (0,_arrow_table__WEBPACK_IMPORTED_MODULE_4__.table)().new(
    names.map(name => {
      const col = dataFrom(data, name, nrows, scan, types[name]);
      return col.length === nrows
        ? col
        : (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])('Column length mismatch');
    }),
    names
  );
}

function init(data, options) {
  const { columns, limit = Infinity, offset = 0 } = options;
  const names = (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(columns) ? columns(data)
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(columns) ? columns
    : null;
  if ((0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(data)) {
    return {
      dataFrom: _data_from_objects__WEBPACK_IMPORTED_MODULE_1__["default"],
      names: names || Object.keys(data[0]),
      nrows: Math.min(limit, data.length - offset),
      scan: (0,_scan__WEBPACK_IMPORTED_MODULE_3__.scanArray)(data, limit, offset)
    };
  } else if (isTable(data)) {
    return {
      dataFrom: _data_from_table__WEBPACK_IMPORTED_MODULE_2__["default"],
      names: names || data.columnNames(),
      nrows: Math.min(limit, data.numRows() - offset),
      scan: (0,_scan__WEBPACK_IMPORTED_MODULE_3__.scanTable)(data, limit, offset)
    };
  } else {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])('Unsupported input data type');
  }
}

function isTable(data) {
  return data && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(data.reify);
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/encode/profiler.js":
/*!***************************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/encode/profiler.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   profile: () => (/* binding */ profile),
/* harmony export */   profiler: () => (/* binding */ profiler)
/* harmony export */ });
/* harmony import */ var apache_arrow__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! apache-arrow */ "../../node_modules/apache-arrow/Arrow.dom.mjs");
/* harmony import */ var _arrow_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../arrow-types */ "../../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _builder_resolve_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../builder/resolve-type */ "../../node_modules/arquero/src/arrow/builder/resolve-type.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array_type__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/is-array-type */ "../../node_modules/arquero/src/util/is-array-type.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/is-date */ "../../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _util_is_exact_utc_date__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/is-exact-utc-date */ "../../node_modules/arquero/src/util/is-exact-utc-date.js");








function profile(scan, column) {
  const p = profiler();
  scan(column, p.add);
  return p;
}

function profiler() {
  const p = {
    count: 0,
    nulls: 0,
    bools: 0,
    nums: 0,
    ints: 0,
    bigints: 0,
    min: Infinity,
    max: -Infinity,
    digits: 0,
    dates: 0,
    utcdays: 0,
    strings: 0,
    strlen: 0,
    arrays: 0,
    minlen: Infinity,
    maxlen: 0,
    structs: 0,

    add(value) {
      ++p.count;
      if (value == null) {
        ++p.nulls;
        return;
      }

      const type = typeof value;
      if (type === 'string') {
        ++p.strings;
      } else if (type === 'number') {
        ++p.nums;
        if (value < p.min) p.min = value;
        if (value > p.max) p.max = value;
        if (Number.isInteger(value)) ++p.ints;
      } else if (type === 'boolean') {
        ++p.bools;
      } else if (type === 'object') {
        if ((0,_util_is_date__WEBPACK_IMPORTED_MODULE_5__["default"])(value)) {
          ++p.dates;
          if ((0,_util_is_exact_utc_date__WEBPACK_IMPORTED_MODULE_6__["default"])(value)) {
            ++p.utcdays;
          }
        } else if ((0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_4__["default"])(value)) {
          ++p.arrays;
          if (value.length < p.minlen) p.minlen = value.length;
          if (value.length > p.maxlen) p.maxlen = value.length;
          const ap = p.array_prof || (p.array_prof = profiler());
          value.forEach(ap.add);
        } else {
          ++p.structs;
          const sp = p.struct_prof || (p.struct_prof = {});
          for (const key in value) {
            const fp = sp[key] || (sp[key] = profiler());
            fp.add(value[key]);
          }
        }
      } else if (type === 'bigint') {
        ++p.bigints;
        if (value < p.min) p.min = value;
        if (value > p.max) p.max = value;
      }
    },
    type() {
      return (0,_builder_resolve_type__WEBPACK_IMPORTED_MODULE_2__["default"])(infer(p));
    }
  };

  return p;
}

function infer(p) {
  const valid = p.count - p.nulls;

  if (valid === 0) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Null;
  }
  else if (p.ints === valid) {
    const v = Math.max(Math.abs(p.min) - 1, p.max);
    return p.min < 0
      ? v >= 2 ** 31 ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float64
        : v < (1 << 7) ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int8 : v < (1 << 15) ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int16 : _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int32
      : v >= 2 ** 32 ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float64
        : v < (1 << 8) ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint8 : v < (1 << 16) ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint16 : _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint32;
  }
  else if (p.nums === valid) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Float64;
  }
  else if (p.bigints === valid) {
    const v = -p.min > p.max ? -p.min - 1n : p.max;
    return p.min < 0
      ? v < 2 ** 63 ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Int64
        : (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])(`BigInt exceeds 64 bits: ${v}`)
      : p.max < 2 ** 64 ? _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Uint64
        : (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])(`BigInt exceeds 64 bits: ${p.max}`);
  }
  else if (p.bools === valid) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Bool;
  }
  else if (p.utcdays === valid) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].DateDay;
  }
  else if (p.dates === valid) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].DateMillisecond;
  }
  else if (p.arrays === valid) {
    const type = apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Field.new('value', p.array_prof.type(), true);
    return p.minlen === p.maxlen
      ? new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.FixedSizeList(p.minlen, type)
      : new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.List(type);
  }
  else if (p.structs === valid) {
    const sp = p.struct_prof;
    return new apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Struct(
      Object.keys(sp).map(name => apache_arrow__WEBPACK_IMPORTED_MODULE_0__.Field.new(name, sp[name].type(), true))
    );
  }
  else if (p.strings > 0) {
    return _arrow_types__WEBPACK_IMPORTED_MODULE_1__["default"].Dictionary;
  }
  else {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])('Type inference failure');
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/arrow/encode/scan.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/arrow/encode/scan.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   scanArray: () => (/* binding */ scanArray),
/* harmony export */   scanTable: () => (/* binding */ scanTable)
/* harmony export */ });
/* harmony import */ var _util_is_array_type__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/is-array-type */ "../../node_modules/arquero/src/util/is-array-type.js");


function scanArray(data, limit, offset) {
  const n = Math.min(data.length, offset + limit);
  return (name, visit) => {
    for (let i = offset; i < n; ++i) {
      visit(data[i][name], i);
    }
  };
}

function scanTable(table, limit, offset) {
  const scanAll = offset === 0 && table.numRows() <= limit
               && !table.isFiltered() && !table.isOrdered();

  return (column, visit) => {
    let i = -1;
    scanAll && (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_0__["default"])(column.data)
      ? column.data.forEach(visit)
      : table.scan(
          row => visit(column.get(row), ++i),
          true, limit, offset
        );
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/concat.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/concat.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/null */ "../../node_modules/arquero/src/util/null.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, others) {
  const trows = table.numRows();
  const nrows = trows + others.reduce((n, t) => n + t.numRows(), 0);
  if (trows === nrows) return table;

  const tables = [table, ...others];
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_0__["default"])();

  table.columnNames().forEach(name => {
    const arr = Array(nrows);
    let row = 0;
    tables.forEach(table => {
      const col = table.column(name) || { get: () => _util_null__WEBPACK_IMPORTED_MODULE_1__["default"] };
      table.scan(trow => arr[row++] = col.get(trow));
    });
    cols.add(name, arr);
  });

  return table.create(cols.new());
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/derive.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/derive.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _window_window__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./window/window */ "../../node_modules/arquero/src/engine/window/window.js");
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../op */ "../../node_modules/arquero/src/op/index.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/repeat */ "../../node_modules/arquero/src/util/repeat.js");






function isWindowed(op) {
  return (0,_op__WEBPACK_IMPORTED_MODULE_2__.hasWindow)(op.name) ||
    op.frame && (
      Number.isFinite(op.frame[0]) ||
      Number.isFinite(op.frame[1])
    );
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names, exprs, ops }, options = {}) {
  // instantiate output data
  const total = table.totalRows();
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_3__["default"])(options.drop ? null : table);
  const data = names.map(name => cols.add(name, Array(total)));

  // analyze operations, compute non-windowed aggregates
  const [ aggOps, winOps ] = segmentOps(ops);

  const size = table.isGrouped() ? table.groups().size : 1;
  const result = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_1__.aggregate)(
    table, aggOps,
    (0,_util_repeat__WEBPACK_IMPORTED_MODULE_4__["default"])(ops.length, () => Array(size))
  );

  // perform table scans to generate output values
  winOps.length
    ? (0,_window_window__WEBPACK_IMPORTED_MODULE_0__.window)(table, data, exprs, result, winOps)
    : output(table, data, exprs, result);

  return table.create(cols);
}

function segmentOps(ops) {
  const aggOps = [];
  const winOps = [];
  const n = ops.length;

  for (let i = 0; i < n; ++i) {
    const op = ops[i];
    op.id = i;
    (isWindowed(op) ? winOps : aggOps).push(op);
  }

  return [aggOps, winOps];
}

function output(table, cols, exprs, result) {
  const bits = table.mask();
  const data = table.data();
  const { keys } = table.groups() || {};
  const op = keys
    ? (id, row) => result[id][keys[row]]
    : id => result[id][0];

  const m = cols.length;
  for (let j = 0; j < m; ++j) {
    const get = exprs[j];
    const col = cols[j];

    // inline the following for performance:
    // table.scan((i, data) => col[i] = get(i, data, op));
    if (bits) {
      for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
        col[i] = get(i, data, op);
      }
    } else {
      const n = table.totalRows();
      for (let i = 0; i < n; ++i) {
        col[i] = get(i, data, op);
      }
    }
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/filter.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/filter.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_bit_set__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/bit-set */ "../../node_modules/arquero/src/table/bit-set.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, predicate) {
  const n = table.totalRows();
  const bits = table.mask();
  const data = table.data();
  const filter = new _table_bit_set__WEBPACK_IMPORTED_MODULE_0__["default"](n);

  // inline the following for performance:
  // table.scan((row, data) => { if (predicate(row, data)) filter.set(row); });
  if (bits) {
    for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
      if (predicate(i, data)) filter.set(i);
    }
  } else {
    for (let i = 0; i < n; ++i) {
      if (predicate(i, data)) filter.set(i);
    }
  }

  return table.create({ filter });
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/fold.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/engine/fold.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _unroll__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./unroll */ "../../node_modules/arquero/src/engine/unroll.js");
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names = [], exprs = [], ops = [] }, options = {}) {
  if (names.length === 0) return table;

  const [k = 'key', v = 'value'] = options.as || [];
  const vals = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_1__.aggregateGet)(table, ops, exprs);

  return (0,_unroll__WEBPACK_IMPORTED_MODULE_0__["default"])(
    table,
    {
      names: [k, v],
      exprs: [() => names, (row, data) => vals.map(fn => fn(row, data))]
    },
    { ...options, drop: names }
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/groupby.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/engine/groupby.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _util_key_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/key-function */ "../../node_modules/arquero/src/util/key-function.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, exprs) {
  return table.create({
    groups: createGroups(table, exprs)
  });
}

function createGroups(table, { names = [], exprs = [], ops = [] }) {
  const n = names.length;
  if (n === 0) return null;

  // check for optimized path when grouping by a single field
  // use pre-calculated groups if available
  if (n === 1 && !table.isFiltered() && exprs[0].field) {
    const col = table.column(exprs[0].field);
    if (col.groups) return col.groups(names);
  }

  let get = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, ops, exprs);
  const getKey = (0,_util_key_function__WEBPACK_IMPORTED_MODULE_1__["default"])(get);
  const nrows = table.totalRows();
  const keys = new Uint32Array(nrows);
  const index = {};
  const rows = [];

  // inline table scan for performance
  const data = table.data();
  const bits = table.mask();
  if (bits) {
    for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
      const key = getKey(i, data) + '';
      const val = index[key];
      keys[i] = val != null ? val : (index[key] = rows.push(i) - 1);
    }
  } else {
    for (let i = 0; i < nrows; ++i) {
      const key = getKey(i, data) + '';
      const val = index[key];
      keys[i] = val != null ? val : (index[key] = rows.push(i) - 1);
    }
  }

  if (!ops.length) {
    // capture data in closure, so no interaction with select
    get = get.map(f => row => f(row, data));
  }

  return { keys, get, names, rows, size: rows.length };
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/impute.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/impute.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_is_valid__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-valid */ "../../node_modules/arquero/src/util/is-valid.js");
/* harmony import */ var _util_key_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/key-function */ "../../node_modules/arquero/src/util/key-function.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/unroll */ "../../node_modules/arquero/src/util/unroll.js");






/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values, keys, arrays) {
  const write = keys && keys.length;
  return impute(
    write ? expand(table, keys, arrays) : table,
    values,
    write
  );
}

function impute(table, { names, exprs, ops }, write) {
  const gets = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, ops, exprs);
  const cols = write ? null : (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])(table);
  const rows = table.totalRows();

  names.forEach((name, i) => {
    const col = table.column(name);
    const out = write ? col.data : cols.add(name, Array(rows));
    const get = gets[i];

    table.scan(idx => {
      const v = col.get(idx);
      out[idx] = !(0,_util_is_valid__WEBPACK_IMPORTED_MODULE_2__["default"])(v) ? get(idx) : v;
    });
  });

  return write ? table : table.create(cols);
}

function expand(table, keys, values) {
  const groups = table.groups();
  const data = table.data();

  // expansion keys and accessors
  const keyNames = (groups ? groups.names : []).concat(keys);
  const keyGet = (groups ? groups.get : [])
    .concat(keys.map(key => table.getter(key)));

  // build hash of existing rows
  const hash = new Set();
  const keyTable = (0,_util_key_function__WEBPACK_IMPORTED_MODULE_3__["default"])(keyGet);
  table.scan((idx, data) => hash.add(keyTable(idx, data)));

  // initialize output table data
  const names = table.columnNames();
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const out = names.map(name => cols.add(name, []));
  names.forEach((name, i) => {
    const old = data[name];
    const col = out[i];
    table.scan(row => col.push(old.get(row)));
  });

  // enumerate expanded value sets and augment output table
  const keyEnum = (0,_util_key_function__WEBPACK_IMPORTED_MODULE_3__["default"])(keyGet.map((k, i) => a => a[i]));
  const set = (0,_util_unroll__WEBPACK_IMPORTED_MODULE_4__["default"])(
    'v',
    '{' + out.map((_, i) => `_${i}.push(v[$${i}]);`).join('') + '}',
    out, names.map(name => keyNames.indexOf(name))
  );

  if (groups) {
    let row = groups.keys.length;
    const prod = values.reduce((p, a) => p * a.length, groups.size);
    const keys = new Uint32Array(prod + (row - hash.size));
    keys.set(groups.keys);
    enumerate(groups, values, (vec, idx) => {
      if (!hash.has(keyEnum(vec))) {
        set(vec);
        keys[row++] = idx[0];
      }
    });
    cols.groupby({ ...groups, keys });
  } else {
    enumerate(groups, values, vec => {
      if (!hash.has(keyEnum(vec))) set(vec);
    });
  }

  return table.create(cols.new());
}

function enumerate(groups, values, callback) {
  const offset = groups ? groups.get.length : 0;
  const pad = groups ? 1 : 0;
  const len = pad + values.length;
  const lens = new Int32Array(len);
  const idxs = new Int32Array(len);
  const set = [];

  if (groups) {
    const { get, rows, size } = groups;
    lens[0] = size;
    set.push((vec, idx) => {
      const row = rows[idx];
      for (let i = 0; i < offset; ++i) {
        vec[i] = get[i](row);
      }
    });
  }

  values.forEach((a, i) => {
    const j = i + offset;
    lens[i + pad] = a.length;
    set.push((vec, idx) => vec[j] = a[idx]);
  });

  const vec = Array(offset + values.length);

  // initialize value vector
  for (let i = 0; i < len; ++i) {
    set[i](vec, 0);
  }
  callback(vec, idxs);

  // enumerate all combinations of values
  for (let i = len - 1; i >= 0;) {
    const idx = ++idxs[i];
    if (idx < lens[i]) {
      set[i](vec, idx);
      callback(vec, idxs);
      i = len - 1;
    } else {
      idxs[i] = 0;
      set[i](vec, 0);
      --i;
    }
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/join-filter.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/engine/join-filter.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _join_lookup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./join/lookup */ "../../node_modules/arquero/src/engine/join/lookup.js");
/* harmony import */ var _table_bit_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/bit-set */ "../../node_modules/arquero/src/table/bit-set.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, predicate, options = {}) {
  // calculate semi-join filter mask
  const filter = new _table_bit_set__WEBPACK_IMPORTED_MODULE_1__["default"](tableL.totalRows());
  const join = (0,_util_is_array__WEBPACK_IMPORTED_MODULE_2__["default"])(predicate) ? hashSemiJoin : loopSemiJoin;
  join(filter, tableL, tableR, predicate);

  // if anti-join, negate the filter
  if (options.anti) {
    filter.not().and(tableL.mask());
  }

  return tableL.create({ filter });
}

function hashSemiJoin(filter, tableL, tableR, [keyL, keyR]) {
  // build lookup table
  const lut = (0,_join_lookup__WEBPACK_IMPORTED_MODULE_0__.rowLookup)(tableR, keyR);

  // scan table, update filter with matches
  tableL.scan((rowL, data) => {
    const rowR = lut.get(keyL(rowL, data));
    if (rowR >= 0) filter.set(rowL);
  });
}

function loopSemiJoin(filter, tableL, tableR, predicate) {
  const nL = tableL.numRows();
  const nR = tableR.numRows();
  const dataL = tableL.data();
  const dataR = tableR.data();

  if (tableL.isFiltered() || tableR.isFiltered()) {
    // use indices as at least one table is filtered
    const idxL = tableL.indices(false);
    const idxR = tableR.indices(false);
    for (let i = 0; i < nL; ++i) {
      const rowL = idxL[i];
      for (let j = 0; j < nR; ++j) {
        if (predicate(rowL, dataL, idxR[j], dataR)) {
          filter.set(rowL);
          break;
        }
      }
    }
  } else {
    // no filters, enumerate row indices directly
    for (let i = 0; i < nL; ++i) {
      for (let j = 0; j < nR; ++j) {
        if (predicate(i, dataL, j, dataR)) {
          filter.set(i);
          break;
        }
      }
    }
  }
}

// export default function(tableL, tableR, predicate, options = {}) {
//   const filter = new BitSet(tableL.totalRows());
//   const nL = tableL.numRows();
//   const nR = tableR.numRows();
//   const dataL = tableL.data();
//   const dataR = tableR.data();

//   if (tableL.isFiltered() || tableR.isFiltered()) {
//     // use indices as at least one table is filtered
//     const idxL = tableL.indices(false);
//     const idxR = tableR.indices(false);
//     for (let i = 0; i < nL; ++i) {
//       const rowL = idxL[i];
//       for (let j = 0; j < nR; ++j) {
//         if (predicate(rowL, dataL, idxR[j], dataR)) {
//           filter.set(rowL);
//           break;
//         }
//       }
//     }
//   } else {
//     // no filters, enumerate row indices directly
//     for (let i = 0; i < nL; ++i) {
//       for (let j = 0; j < nR; ++j) {
//         if (predicate(i, dataL, j, dataR)) {
//           filter.set(i);
//           break;
//         }
//       }
//     }
//   }

//   // if anti-join, negate the filter
//   if (options.anti) {
//     filter.not().and(tableL.mask());
//   }

//   return tableL.create({ filter });
// }

/***/ }),

/***/ "../../node_modules/arquero/src/engine/join.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/engine/join.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _join_lookup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./join/lookup */ "../../node_modules/arquero/src/engine/join/lookup.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/concat */ "../../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/unroll */ "../../node_modules/arquero/src/util/unroll.js");






function emitter(columns, getters) {
  const args = ['i', 'a', 'j', 'b'];
  return (0,_util_unroll__WEBPACK_IMPORTED_MODULE_4__["default"])(
    args,
    '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_2__["default"])(columns, (_, i) => `_${i}.push($${i}(${args}));`) + '}',
    columns, getters
  );
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, predicate, { names, exprs }, options = {}) {
  // initialize data for left table
  const dataL = tableL.data();
  const idxL = tableL.indices(false);
  const nL = idxL.length;
  const hitL = new Int32Array(nL);

  // initialize data for right table
  const dataR = tableR.data();
  const idxR = tableR.indices(false);
  const nR = idxR.length;
  const hitR = new Int32Array(nR);

  // initialize output data
  const ncols = names.length;
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const columns = Array(ncols);
  const getters = Array(ncols);
  for (let i = 0; i < names.length; ++i) {
    columns[i] = cols.add(names[i], []);
    getters[i] = exprs[i];
  }
  const emit = emitter(columns, getters);

  // perform join
  const join = (0,_util_is_array__WEBPACK_IMPORTED_MODULE_3__["default"])(predicate) ? hashJoin : loopJoin;
  join(emit, predicate, dataL, dataR, idxL, idxR, hitL, hitR, nL, nR);

  if (options.left) {
    for (let i = 0; i < nL; ++i) {
      if (!hitL[i]) {
        emit(idxL[i], dataL, -1, dataR);
      }
    }
  }

  if (options.right) {
    for (let j = 0; j < nR; ++j) {
      if (!hitR[j]) {
        emit(-1, dataL, idxR[j], dataR);
      }
    }
  }

  return tableL.create(cols.new());
}

function loopJoin(emit, predicate, dataL, dataR, idxL, idxR, hitL, hitR, nL, nR) {
  // perform nested-loops join
  for (let i = 0; i < nL; ++i) {
    const rowL = idxL[i];
    for (let j = 0; j < nR; ++j) {
      const rowR = idxR[j];
      if (predicate(rowL, dataL, rowR, dataR)) {
        emit(rowL, dataL, rowR, dataR);
        hitL[i] = 1;
        hitR[j] = 1;
      }
    }
  }
}

function hashJoin(emit, [keyL, keyR], dataL, dataR, idxL, idxR, hitL, hitR, nL, nR) {
  // determine which table to hash
  let dataScan, keyScan, hitScan, idxScan;
  let dataHash, keyHash, hitHash, idxHash;
  let emitScan = emit;
  if (nL >= nR) {
    dataScan = dataL; keyScan = keyL; hitScan = hitL; idxScan = idxL;
    dataHash = dataR; keyHash = keyR; hitHash = hitR; idxHash = idxR;
  } else {
    dataScan = dataR; keyScan = keyR; hitScan = hitR; idxScan = idxR;
    dataHash = dataL; keyHash = keyL; hitHash = hitL; idxHash = idxL;
    emitScan = (i, a, j, b) => emit(j, b, i, a);
  }

  // build lookup table
  const lut = (0,_join_lookup__WEBPACK_IMPORTED_MODULE_0__.indexLookup)(idxHash, dataHash, keyHash);

  // scan other table
  const m = idxScan.length;
  for (let j = 0; j < m; ++j) {
    const rowScan = idxScan[j];
    const list = lut.get(keyScan(rowScan, dataScan));
    if (list) {
      const n = list.length;
      for (let k = 0; k < n; ++k) {
        const i = list[k];
        emitScan(rowScan, dataScan, idxHash[i], dataHash);
        hitHash[i] = 1;
      }
      hitScan[j] = 1;
    }
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/join/lookup.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/engine/join/lookup.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   indexLookup: () => (/* binding */ indexLookup),
/* harmony export */   rowLookup: () => (/* binding */ rowLookup)
/* harmony export */ });
function rowLookup(table, hash) {
  const lut = new Map();
  table.scan((row, data) => {
    const key = hash(row, data);
    if (key != null && key === key) {
      lut.set(key, row);
    }
  });
  return lut;
}

function indexLookup(idx, data, hash) {
  const lut = new Map();
  const n = idx.length;
  for (let i = 0; i < n; ++i) {
    const row = idx[i];
    const key = hash(row, data);
    if (key != null && key === key) {
      lut.has(key)
        ? lut.get(key).push(i)
        : lut.set(key, [i]);
    }
  }
  return lut;
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/lookup.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/lookup.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _join_lookup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./join/lookup */ "../../node_modules/arquero/src/engine/join/lookup.js");
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/null */ "../../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/concat */ "../../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/unroll */ "../../node_modules/arquero/src/util/unroll.js");







/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, [keyL, keyR], { names, exprs, ops }) {
  // instantiate output data
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_2__["default"])(tableL);
  const total = tableL.totalRows();
  names.forEach(name => cols.add(name, Array(total).fill(_util_null__WEBPACK_IMPORTED_MODULE_3__["default"])));

  // build lookup table
  const lut = (0,_join_lookup__WEBPACK_IMPORTED_MODULE_0__.rowLookup)(tableR, keyR);

  // generate setter function for lookup match
  const set = (0,_util_unroll__WEBPACK_IMPORTED_MODULE_5__["default"])(
    ['lr', 'rr', 'data'],
    '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_4__["default"])(names, (_, i) => `_[${i}][lr] = $[${i}](rr, data);`) + '}',
    names.map(name => cols.data[name]),
    (0,_reduce_util__WEBPACK_IMPORTED_MODULE_1__.aggregateGet)(tableR, ops, exprs)
  );

  // find matching rows, set values on match
  const dataR = tableR.data();
  tableL.scan((lrow, data) => {
    const rrow = lut.get(keyL(lrow, data));
    if (rrow >= 0) set(lrow, rrow, dataR);
  });

  return tableL.create(cols);
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/orderby.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/engine/orderby.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, comparator) {
  return table.create({ order: comparator });
}


/***/ }),

/***/ "../../node_modules/arquero/src/engine/pivot.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/pivot.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");



const opt = (value, defaultValue) => value != null ? value : defaultValue;

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, on, values, options = {}) {
  const { keys, keyColumn } = pivotKeys(table, on, options);
  const vsep = opt(options.valueSeparator, '_');
  const namefn = values.names.length > 1
    ? (i, name) => name + vsep + keys[i]
    : i => keys[i];

  // perform separate aggregate operations for each key
  // if keys do not match, emit NaN so aggregate skips it
  // use custom toString method for proper field resolution
  const results = keys.map(
    k => (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregate)(table, values.ops.map(op => {
      const fields = op.fields.map(f => {
        const fn = (r, d) => k === keyColumn[r] ? f(r, d) : NaN;
        fn.toString = () => k + ':' + f + '';
        return fn;
      });
      return { ...op, fields };
    }))
  );

  return table.create(output(values, namefn, table.groups(), results));
}

function pivotKeys(table, on, options) {
  const limit = options.limit > 0 ? +options.limit : Infinity;
  const sort = opt(options.sort, true);
  const ksep = opt(options.keySeparator, '_');

  // construct key accessor function
  const get = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, on.ops, on.exprs);
  const key = get.length === 1
    ? get[0]
    : (row, data) => get.map(fn => fn(row, data)).join(ksep);

  // generate vector of per-row key values
  const kcol = Array(table.totalRows());
  table.scan((row, data) => kcol[row] = key(row, data));

  // collect unique key values
  const uniq = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregate)(
    table.ungroup(),
    [ {
      id: 0,
      name: 'array_agg_distinct',
      fields: [(row => kcol[row])], params: []
    } ]
  )[0][0];

  // get ordered set of unique key values
  const keys = sort ? uniq.sort() : uniq;

  // return key values
  return {
    keys: Number.isFinite(limit) ? keys.slice(0, limit) : keys,
    keyColumn: kcol
  };
}

function output({ names, exprs }, namefn, groups, results) {
  const size = groups ? groups.size : 1;
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const m = results.length;
  const n = names.length;

  let result;
  const op = (id, row) => result[id][row];

  // write groupby fields to output
  if (groups) (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.groupOutput)(cols, groups);

  // write pivot values to output
  for (let i = 0; i < n; ++i) {
    const get = exprs[i];
    if (get.field != null) {
      // if expression is op only, use aggregates directly
      for (let j = 0; j < m; ++j) {
        cols.add(namefn(j, names[i]), results[j][get.field]);
      }
    } else if (size > 1) {
      // if multiple groups, evaluate expression for each
      for (let j = 0; j < m; ++j) {
        result = results[j];
        const col = cols.add(namefn(j, names[i]), Array(size));
        for (let k = 0; k < size; ++k) {
          col[k] = get(k, null, op);
        }
      }
    } else {
      // if only one group, no need to loop
      for (let j = 0; j < m; ++j) {
        result = results[j];
        cols.add(namefn(j, names[i]), [ get(0, null, op) ]);
      }
    }
  }

  return cols.new();
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/reduce.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/reduce.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, reducer) {
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const groups = table.groups();

  // initialize groups
  const { get, names = [], rows, size = 1 } = groups || {};
  const counts = new Uint32Array(size + 1);
  names.forEach(name => cols.add(name, null));

  // compute reduced values
  const cells = groups
    ? (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.reduceGroups)(table, reducer, groups)
    : [ (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.reduceFlat)(table, reducer) ];

  // initialize output columns
  reducer.outputs().map(name => cols.add(name, []));

  // write reduced values to output columns
  const n = counts.length - 1;
  let len = 0;
  for (let i = 0; i < n; ++i) {
    len += counts[i + 1] = reducer.write(cells[i], cols.data, counts[i]);
  }

  // write group values to output columns
  if (groups) {
    const data = table.data();
    names.forEach((name, index) => {
      const column = cols.data[name] = Array(len);
      const getter = get[index];
      for (let i = 0, j = 0; i < size; ++i) {
        column.fill(getter(rows[i], data), j, j += counts[i + 1]);
      }
    });
  }

  return table.create(cols.new());
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/reduce/field-reducer.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/arquero/src/engine/reduce/field-reducer.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reducer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reducer */ "../../node_modules/arquero/src/engine/reduce/reducer.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../op */ "../../node_modules/arquero/src/op/index.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/concat */ "../../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_valid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/is-valid */ "../../node_modules/arquero/src/util/is-valid.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/unroll */ "../../node_modules/arquero/src/util/unroll.js");
/* harmony import */ var _util_value_list__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/value-list */ "../../node_modules/arquero/src/util/value-list.js");








const update = (ops, args, fn) => (0,_util_unroll__WEBPACK_IMPORTED_MODULE_5__["default"])(
  args,
  '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_2__["default"])(ops, (_, i) => `_${i}.${fn}(${args});`) + '}',
  ops
);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(oplist, stream) {
  const { ops, output } = expand(oplist, stream);
  const fields = oplist[0].fields;
  const n = fields.length;
  const cls = n === 0 ? FieldReducer
    : n === 1 ? Field1Reducer
    : n === 2 ? Field2Reducer
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])('Unsupported field count: ' + n);
  return new cls(fields, ops, output, stream);
}

function expand(oplist, stream) {
  const has = {};
  const ops = [];

  function add(name, params = []) {
    // check key
    const key = name + ':' + params;
    if (has[key]) return has[key];

    // get op instance
    const def = (0,_op__WEBPACK_IMPORTED_MODULE_1__.getAggregate)(name);
    const op = def.create(...params);

    // add required dependencies
    if (stream < 0 && def.stream) {
      def.stream.forEach(name => add(name, []));
    }
    if (def.req) {
      def.req.forEach(name => add(name, []));
    }

    // update state
    has[key] = op;
    ops.push(op);

    return op;
  }

  const output = oplist.map(item => {
    const op = add(item.name, item.params);
    op.output = item.id;
    return op;
  });

  return { ops, output };
}

class FieldReducer extends _reducer__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(fields, ops, outputs, stream) {
    super(outputs);
    this._op = ops;
    this._fields = fields;
    this._stream = !!stream;
  }

  init() {
    const state = { count: 0, valid: 0, stream: this._stream };
    this._op.forEach(op => op.init(state));

    // value list requested
    if (state.values) {
      state.list = new _util_value_list__WEBPACK_IMPORTED_MODULE_6__["default"]();
    }

    return state;
  }

  write(state, values, index) {
    const op = this._outputs;
    const n = op.length;
    for (let i = 0; i < n; ++i) {
      values[op[i].output][index] = op[i].value(state);
    }
    return 1;
  }

  _add() {
  }

  _rem() {
  }

  add(state) {
    ++state.count;
  }

  rem(state) {
    --state.count;
  }
}

class Field1Reducer extends FieldReducer {
  constructor(fields, ops, outputs, stream) {
    super(fields, ops, outputs, stream);

    // unroll op invocations for performance
    const args = ['state', 'v1', 'v2'];
    this._add = update(ops, args, 'add');
    this._rem = update(ops, args, 'rem');
  }

  add(state, row, data) {
    const value = this._fields[0](row, data);
    ++state.count;
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value)) {
      ++state.valid;
      if (state.list) state.list.add(value);
      this._add(state, value);
    }
  }

  rem(state, row, data) {
    const value = this._fields[0](row, data);
    --state.count;
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value)) {
      --state.valid;
      if (state.list) state.list.rem();
      this._rem(state, value);
    }
  }
}

class Field2Reducer extends FieldReducer {
  constructor(fields, ops, outputs, stream) {
    super(fields, ops, outputs, stream);

    // unroll op invocations for performance
    const args = ['state', 'v1', 'v2'];
    this._add = update(ops, args, 'add');
    this._rem = update(ops, args, 'rem');
  }

  add(state, row, data) {
    const value1 = this._fields[0](row, data);
    const value2 = this._fields[1](row, data);
    ++state.count;
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value1) && (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value2)) {
      ++state.valid;
      if (state.list) state.list.add([value1, value2]);
      this._add(state, value1, value2);
    }
  }

  rem(state, row, data) {
    const value1 = this._fields[0](row, data);
    const value2 = this._fields[1](row, data);
    --state.count;
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value1) && (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_4__["default"])(value2)) {
      --state.valid;
      if (state.list) state.list.rem();
      this._rem(state, value1, value2);
    }
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/reduce/reducer.js":
/*!***************************************************************!*\
  !*** ../../node_modules/arquero/src/engine/reduce/reducer.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Reducer)
/* harmony export */ });
/**
 * Abstract class for custom aggregation operations.
 */
class Reducer {
  constructor(outputs) {
    this._outputs = outputs;
  }

  size() {
    return this._outputs.length;
  }

  outputs() {
    return this._outputs;
  }

  init(/* columns */) {
    return {};
  }

  add(/* state, row, data */) {
    // no-op, subclasses should override
  }

  rem(/* state, row, data */) {
    // no-op, subclasses should override
  }

  write(/* state, values, index */) {
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/reduce/util.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/engine/reduce/util.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   aggregate: () => (/* binding */ aggregate),
/* harmony export */   aggregateGet: () => (/* binding */ aggregateGet),
/* harmony export */   groupOutput: () => (/* binding */ groupOutput),
/* harmony export */   reduceFlat: () => (/* binding */ reduceFlat),
/* harmony export */   reduceGroups: () => (/* binding */ reduceGroups),
/* harmony export */   reducers: () => (/* binding */ reducers)
/* harmony export */ });
/* harmony import */ var _field_reducer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./field-reducer */ "../../node_modules/arquero/src/engine/reduce/field-reducer.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/repeat */ "../../node_modules/arquero/src/util/repeat.js");



function aggregateGet(table, ops, get) {
  if (ops.length) {
    const data = table.data();
    const { keys } = table.groups() || {};
    const result = aggregate(table, ops);
    const op = keys
      ? (name, row) => result[name][keys[row]]
      : name => result[name][0];
    get = get.map(f => row => f(row, data, op));
  }

  return get;
}

function aggregate(table, ops, result) {
  if (!ops.length) return result; // early exit

  // instantiate aggregators and result store
  const aggrs = reducers(ops);
  const groups = table.groups();
  const size = groups ? groups.size : 1;
  result = result || (0,_util_repeat__WEBPACK_IMPORTED_MODULE_1__["default"])(ops.length, () => Array(size));

  // compute aggregates, extract results
  if (size > 1) {
    aggrs.forEach(aggr => {
      const cells = reduceGroups(table, aggr, groups);
      for (let i = 0; i < size; ++i) {
        aggr.write(cells[i], result, i);
      }
    });
  } else {
    aggrs.forEach(aggr => {
      const cell = reduceFlat(table, aggr);
      aggr.write(cell, result, 0);
    });
  }

  return result;
}

function reducers(ops, stream) {
  const aggrs = [];
  const fields = {};

  // group operators by field inputs
  for (const op of ops) {
    const key = op.fields.map(f => f + '').join(',');
    (fields[key] || (fields[key] = [])).push(op);
  }

  // generate a field reducer for each field
  for (const key in fields) {
    aggrs.push((0,_field_reducer__WEBPACK_IMPORTED_MODULE_0__["default"])(fields[key], stream));
  }

  return aggrs;
}

function reduceFlat(table, reducer) {
  // initialize aggregation cell
  const cell = reducer.init();

  // compute aggregate values
  // inline the following for performance:
  // table.scan((row, data) => reducer.add(cell, row, data));
  const n = table.totalRows();
  const data = table.data();
  const bits = table.mask();

  if (table.isOrdered()) {
    const idx = table.indices();
    for (let i = 0; i < n; ++i) {
      reducer.add(cell, idx[i], data);
    }
  } else if (bits) {
    for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
      reducer.add(cell, i, data);
    }
  } else {
    for (let i = 0; i < n; ++i) {
      reducer.add(cell, i, data);
    }
  }

  return cell;
}

function reduceGroups(table, reducer, groups) {
  const { keys, size } = groups;

  // initialize aggregation cells
  const cells = (0,_util_repeat__WEBPACK_IMPORTED_MODULE_1__["default"])(size, () => reducer.init());

  // compute aggregate values
  // inline the following for performance:
  // table.scan((row, data) => reducer.add(cells[keys[row]], row, data));
  const data = table.data();

  if (table.isOrdered()) {
    const idx = table.indices();
    const m = idx.length;
    for (let i = 0; i < m; ++i) {
      const row = idx[i];
      reducer.add(cells[keys[row]], row, data);
    }
  } else if (table.isFiltered()) {
    const bits = table.mask();
    for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
      reducer.add(cells[keys[i]], i, data);
    }
  } else {
    const n = table.totalRows();
    for (let i = 0; i < n; ++i) {
      reducer.add(cells[keys[i]], i, data);
    }
  }

  return cells;
}

function groupOutput(cols, groups) {
  const { get, names, rows, size } = groups;

  // write group values to output columns
  const m = names.length;
  for (let j = 0; j < m; ++j) {
    const col = cols.add(names[j], Array(size));
    const val = get[j];
    for (let i = 0; i < size; ++i) {
      col[i] = val(rows[i]);
    }
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/rollup.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/rollup.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names, exprs, ops }) {
  // output data
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const groups = table.groups();

  // write groupby fields to output
  if (groups) (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.groupOutput)(cols, groups);

  // compute and write aggregate output
  output(names, exprs, groups, (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregate)(table, ops), cols);

  // return output table
  return table.create(cols.new());
}

function output(names, exprs, groups, result = [], cols) {
  if (!exprs.length) return;
  const size = groups ? groups.size : 1;
  const op = (id, row) => result[id][row];
  const n = names.length;

  for (let i = 0; i < n; ++i) {
    const get = exprs[i];
    if (get.field != null) {
      // if expression is op only, use aggregates directly
      cols.add(names[i], result[get.field]);
    } else if (size > 1) {
      // if multiple groups, evaluate expression for each
      const col = cols.add(names[i], Array(size));
      for (let j = 0; j < size; ++j) {
        col[j] = get(j, null, op);
      }
    } else {
      // if only one group, no need to loop
      cols.add(names[i], [ get(0, null, op) ]);
    }
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/sample.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/sample.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_sample__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/sample */ "../../node_modules/arquero/src/util/sample.js");
/* harmony import */ var _util_shuffle__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/shuffle */ "../../node_modules/arquero/src/util/shuffle.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, size, weight, options = {}) {
  const { replace, shuffle } = options;
  const parts = table.partitions(false);

  let total = 0;
  size = parts.map((idx, group) => {
    let s = size(group);
    total += (s = (replace ? s : Math.min(idx.length, s)));
    return s;
  });

  const samples = new Uint32Array(total);
  let curr = 0;

  parts.forEach((idx, group) => {
    const sz = size[group];
    const buf = samples.subarray(curr, curr += sz);

    if (!replace && sz === idx.length) {
      // sample size === data size, no replacement
      // no need to sample, just copy indices
      buf.set(idx);
    } else {
      (0,_util_sample__WEBPACK_IMPORTED_MODULE_0__["default"])(buf, replace, idx, weight);
    }
  });

  if (shuffle !== false && (parts.length > 1 || !replace)) {
    // sampling with replacement methods shuffle, so in
    // that case a single partition is already good to go
    (0,_util_shuffle__WEBPACK_IMPORTED_MODULE_1__["default"])(samples);
  }

  return table.reify(samples);
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/select.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/select.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, columns) {
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_0__["default"])();

  columns.forEach((value, curr) => {
    const next = (0,_util_is_string__WEBPACK_IMPORTED_MODULE_2__["default"])(value) ? value : curr;
    if (next) {
      const col = table.column(curr) || (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])(`Unrecognized column: ${curr}`);
      cols.add(next, col);
    }
  });

  return table.create(cols);
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/spread.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/spread.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/null */ "../../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names, exprs, ops = [] }, options = {}) {
  if (names.length === 0) return table;

  // ignore 'as' if there are multiple field names
  const as = (names.length === 1 && options.as) || [];
  const drop = options.drop == null ? true : !!options.drop;
  const limit = options.limit == null
    ? as.length || Infinity
    : Math.max(1, +options.limit || 1);

  const get = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, ops, exprs);
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const map = names.reduce((map, name, i) => map.set(name, i), new Map());

  const add = (index, name) => {
    const columns = spread(table, get[index], limit);
    const n = columns.length;
    for (let i = 0; i < n; ++i) {
      cols.add(as[i] || `${name}_${i + 1}`, columns[i]);
    }
  };

  table.columnNames().forEach(name => {
    if (map.has(name)) {
      if (!drop) cols.add(name, table.column(name));
      add(map.get(name), name);
      map.delete(name);
    } else {
      cols.add(name, table.column(name));
    }
  });

  map.forEach(add);

  return table.create(cols);
}

function spread(table, get, limit) {
  const nrows = table.totalRows();
  const columns = [];

  table.scan((row, data) => {
    const values = (0,_util_to_array__WEBPACK_IMPORTED_MODULE_3__["default"])(get(row, data));
    const n = Math.min(values.length, limit);
    while (columns.length < n) {
      columns.push(Array(nrows).fill(_util_null__WEBPACK_IMPORTED_MODULE_2__["default"]));
    }
    for (let i = 0; i < n; ++i) {
      columns[i][row] = values[i];
    }
  });

  return columns;
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/ungroup.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/engine/ungroup.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table) {
  return table.isGrouped()
    ? table.create({ groups: null })
    : table;
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/unorder.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/engine/unorder.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table) {
  return table.isOrdered()
    ? table.create({ order: null })
    : table;
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/unroll.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/engine/unroll.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, { names = [], exprs = [], ops = [] }, options = {}) {
  if (!names.length) return table;

  const limit = options.limit > 0 ? +options.limit : Infinity;
  const index = options.index
    ? options.index === true ? 'index' : options.index + ''
    : null;
  const drop = new Set(options.drop);
  const get = (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.aggregateGet)(table, ops, exprs);

  // initialize output columns
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_1__["default"])();
  const nset = new Set(names);
  const priors = [];
  const copies = [];
  const unroll = [];

  // original and copied columns
  table.columnNames().forEach(name => {
    if (!drop.has(name)) {
      const col = cols.add(name, []);
      if (!nset.has(name)) {
        priors.push(table.column(name));
        copies.push(col);
      }
    }
  });

  // unrolled output columns
  names.forEach(name => {
    if (!drop.has(name)) {
      if (!cols.has(name)) cols.add(name, []);
      unroll.push(cols.data[name]);
    }
  });

  // index column, if requested
  const icol = index ? cols.add(index, []) : null;

  let start = 0;
  const m = priors.length;
  const n = unroll.length;

  const copy = (row, maxlen) => {
    for (let i = 0; i < m; ++i) {
      copies[i].length = start + maxlen;
      copies[i].fill(priors[i].get(row), start, start + maxlen);
    }
  };

  const indices = icol
    ? (row, maxlen) => {
        for (let i = 0; i < maxlen; ++i) {
          icol[row + i] = i;
        }
      }
    : () => {};

  if (n === 1) {
    // optimize common case of one array-valued column
    const fn = get[0];
    const col = unroll[0];

    table.scan((row, data) => {
      // extract array data
      const array = (0,_util_to_array__WEBPACK_IMPORTED_MODULE_2__["default"])(fn(row, data));
      const maxlen = Math.min(array.length, limit);

      // copy original table data
      copy(row, maxlen);

      // copy unrolled array data
      for (let j = 0; j < maxlen; ++j) {
        col[start + j] = array[j];
      }

      // fill in array indices
      indices(start, maxlen);

      start += maxlen;
    });
  } else {
    table.scan((row, data) => {
      let maxlen = 0;

      // extract parallel array data
      const arrays = get.map(fn => {
        const value = (0,_util_to_array__WEBPACK_IMPORTED_MODULE_2__["default"])(fn(row, data));
        maxlen = Math.min(Math.max(maxlen, value.length), limit);
        return value;
      });

      // copy original table data
      copy(row, maxlen);

      // copy unrolled array data
      for (let i = 0; i < n; ++i) {
        const col = unroll[i];
        const arr = arrays[i];
        for (let j = 0; j < maxlen; ++j) {
          col[start + j] = arr[j];
        }
      }

      // fill in array indices
      indices(start, maxlen);

      start += maxlen;
    });
  }

  return table.create(cols.new());
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/window/window-state.js":
/*!********************************************************************!*\
  !*** ../../node_modules/arquero/src/engine/window/window-state.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/ascending */ "../../node_modules/arquero/src/util/ascending.js");
/* harmony import */ var _util_bisector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/bisector */ "../../node_modules/arquero/src/util/bisector.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/concat */ "../../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/unroll */ "../../node_modules/arquero/src/util/unroll.js");





const bisect = (0,_util_bisector__WEBPACK_IMPORTED_MODULE_1__["default"])(_util_ascending__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(data, frame, adjust, ops, aggrs) {
  let rows, peer, cells, result, key;
  const isPeer = index => peer[index - 1] === peer[index];
  const numOps = ops.length;
  const numAgg = aggrs.length;

  const evaluate = ops.length
    ? (0,_util_unroll__WEBPACK_IMPORTED_MODULE_3__["default"])(
        ['w', 'r', 'k'],
        '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_2__["default"])(ops, (_, i) => `r[_${i}.id][k]=_${i}.value(w,_${i}.get);`) + '}',
        ops
      )
    : () => {};

  const w = {
    i0: 0,
    i1: 0,
    index: 0,
    size: 0,
    peer: isPeer,

    init(partition, peers, results, group) {
      w.index = w.i0 = w.i1 = 0;
      w.size = peers.length;
      rows = partition;
      peer = peers;
      result = results;
      key = group;

      // initialize aggregates
      cells = aggrs ? aggrs.map(aggr => aggr.init()) : null;

      // initialize window ops
      for (let i = 0; i < numOps; ++i) {
        ops[i].init();
      }

      return w;
    },

    value(index, get) {
      return get(rows[index], data);
    },

    step(idx) {
      const [f0, f1] = frame;
      const n = w.size;
      const p0 = w.i0;
      const p1 = w.i1;

      w.i0 = f0 != null ? Math.max(0, idx - Math.abs(f0)) : 0;
      w.i1 = f1 != null ? Math.min(n, idx + Math.abs(f1) + 1) : n;
      w.index = idx;

      if (adjust) {
        if (w.i0 > 0 && isPeer(w.i0)) {
          w.i0 = bisect.left(peer, peer[w.i0]);
        }
        if (w.i1 < n && isPeer(w.i1)) {
          w.i1 = bisect.right(peer, peer[w.i1 - 1]);
        }
      }

      // evaluate aggregates
      for (let i = 0; i < numAgg; ++i) {
        const aggr = aggrs[i];
        const cell = cells[i];
        for (let j = p0; j < w.i0; ++j) {
          aggr.rem(cell, rows[j], data);
        }
        for (let j = p1; j < w.i1; ++j) {
          aggr.add(cell, rows[j], data);
        }
        aggr.write(cell, result, key);
      }

      // evaluate window ops
      evaluate(w, result, key);

      return result;
    }
  };

  return w;
}

/***/ }),

/***/ "../../node_modules/arquero/src/engine/window/window.js":
/*!**************************************************************!*\
  !*** ../../node_modules/arquero/src/engine/window/window.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   window: () => (/* binding */ window)
/* harmony export */ });
/* harmony import */ var _reduce_util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../op */ "../../node_modules/arquero/src/op/index.js");
/* harmony import */ var _util_concat__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/concat */ "../../node_modules/arquero/src/util/concat.js");
/* harmony import */ var _util_unroll__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/unroll */ "../../node_modules/arquero/src/util/unroll.js");
/* harmony import */ var _window_state__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./window-state */ "../../node_modules/arquero/src/engine/window/window-state.js");






const frameValue = op =>
  (op.frame || [null, null]).map(v => Number.isFinite(v) ? Math.abs(v) : null);

const peersValue = op => !!op.peers;

function windowOp(spec) {
  const { id, name, fields = [], params = [] } = spec;
  const op = (0,_op__WEBPACK_IMPORTED_MODULE_1__.getWindow)(name).create(...params);
  if (fields.length) op.get = fields[0];
  op.id = id;
  return op;
}

function window(table, cols, exprs, result = {}, ops) {
  // instantiate window states
  const data = table.data();
  const states = windowStates(ops, data);
  const nstate = states.length;

  const write = (0,_util_unroll__WEBPACK_IMPORTED_MODULE_3__["default"])(
    ['r', 'd', 'op'],
    '{' + (0,_util_concat__WEBPACK_IMPORTED_MODULE_2__["default"])(cols, (_, i) => `_${i}[r] = $${i}(r, d, op);`) + '}',
    cols, exprs
  );

  // scan each ordered partition
  table.partitions().forEach((rows, key) => {
    const size = rows.length;
    const peers = windowPeers(table, rows);

    // initialize window states
    for (let i = 0; i < nstate; ++i) {
      states[i].init(rows, peers, result, key);
    }

    // calculate window values per-row
    const op = id => result[id][key];
    for (let index = 0; index < size; ++index) {
      // advance window frame, updates result object
      for (let i = 0; i < nstate; ++i) {
        states[i].step(index);
      }
      write(rows[index], data, op);
    }
  });
}

function windowStates(ops, data) {
  const map = {};

  // group operations by window frame parameters
  ops.forEach(op => {
    const frame = frameValue(op);
    const peers = peersValue(op);
    const key = `${frame},${peers}`;
    const { aggOps, winOps } = map[key] || (map[key] = {
      frame,
      peers,
      aggOps: [],
      winOps: []
    });
    (0,_op__WEBPACK_IMPORTED_MODULE_1__.hasAggregate)(op.name)
      ? aggOps.push(op)
      : winOps.push(windowOp(op));
  });

  return Object.values(map).map(_ => (0,_window_state__WEBPACK_IMPORTED_MODULE_4__["default"])(
    data, _.frame, _.peers, _.winOps,
    (0,_reduce_util__WEBPACK_IMPORTED_MODULE_0__.reducers)(_.aggOps, _.frame[0] != null ? -1 : 1)
  ));
}

function windowPeers(table, rows) {
  if (table.isOrdered()) {
    // generate peer ids for sort equality checking
    const compare = table.comparator();
    const data = table.data();
    const nrows = rows.length;
    const peers = new Uint32Array(nrows);
    for (let i = 1, index = 0; i < nrows; ++i) {
      peers[i] = compare(rows[i - 1], rows[i], data) ? ++index : index;
    }
    return peers;
  } else {
    // no sort, no peers: reuse row indices as peer ids
    return rows;
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/ast/clean.js":
/*!**************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/ast/clean.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _walk__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./walk */ "../../node_modules/arquero/src/expression/ast/walk.js");


function strip(node) {
  delete node.start;
  delete node.end;
  delete node.optional;
}

function stripMember(node) {
  strip(node);
  delete node.object;
  delete node.property;
  delete node.computed;
  if (!node.table) delete node.table;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(ast) {
  (0,_walk__WEBPACK_IMPORTED_MODULE_0__["default"])(ast, null, {
    Column: stripMember,
    Constant: stripMember,
    Default: strip
  });
  return ast;
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/ast/constants.js":
/*!******************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/ast/constants.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ArrayPattern: () => (/* binding */ ArrayPattern),
/* harmony export */   ArrowFunctionExpression: () => (/* binding */ ArrowFunctionExpression),
/* harmony export */   Column: () => (/* binding */ Column),
/* harmony export */   Constant: () => (/* binding */ Constant),
/* harmony export */   Dictionary: () => (/* binding */ Dictionary),
/* harmony export */   Function: () => (/* binding */ Function),
/* harmony export */   FunctionExpression: () => (/* binding */ FunctionExpression),
/* harmony export */   Identifier: () => (/* binding */ Identifier),
/* harmony export */   Literal: () => (/* binding */ Literal),
/* harmony export */   MemberExpression: () => (/* binding */ MemberExpression),
/* harmony export */   ObjectExpression: () => (/* binding */ ObjectExpression),
/* harmony export */   ObjectPattern: () => (/* binding */ ObjectPattern),
/* harmony export */   Op: () => (/* binding */ Op),
/* harmony export */   Parameter: () => (/* binding */ Parameter),
/* harmony export */   Property: () => (/* binding */ Property)
/* harmony export */ });
const ArrayPattern = 'ArrayPattern';
const ArrowFunctionExpression = 'ArrowFunctionExpression';
const FunctionExpression = 'FunctionExpression';
const Identifier = 'Identifier';
const Literal = 'Literal';
const MemberExpression = 'MemberExpression';
const ObjectExpression = 'ObjectExpression';
const ObjectPattern = 'ObjectPattern';
const Property = 'Property';

const Column = 'Column';
const Constant = 'Constant';
const Dictionary = 'Dictionary';
const Function = 'Function';
const Parameter = 'Parameter';
const Op = 'Op';

/***/ }),

/***/ "../../node_modules/arquero/src/expression/ast/util.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/ast/util.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   is: () => (/* binding */ is),
/* harmony export */   isFunctionExpression: () => (/* binding */ isFunctionExpression)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/arquero/src/expression/ast/constants.js");


function is(type, node) {
  return node && node.type === type;
}

function isFunctionExpression(node) {
  return is(_constants__WEBPACK_IMPORTED_MODULE_0__.FunctionExpression, node)
    || is(_constants__WEBPACK_IMPORTED_MODULE_0__.ArrowFunctionExpression, node);
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/ast/walk.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/ast/walk.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ walk)
/* harmony export */ });
function walk(node, ctx, visitors, parent) {
  const visit = visitors[node.type] || visitors['Default'];
  if (visit && visit(node, ctx, parent) === false) return;

  const walker = walkers[node.type];
  if (walker) walker(node, ctx, visitors);
}

const unary = (node, ctx, visitors) => {
  walk(node.argument, ctx, visitors, node);
};

const binary = (node, ctx, visitors) => {
  walk(node.left, ctx, visitors, node);
  walk(node.right, ctx, visitors, node);
};

const ternary = (node, ctx, visitors) => {
  walk(node.test, ctx, visitors, node);
  walk(node.consequent, ctx, visitors, node);
  if (node.alternate) walk(node.alternate, ctx, visitors, node);
};

const func = (node, ctx, visitors) => {
  list(node.params, ctx, visitors, node);
  walk(node.body, ctx, visitors, node);
};

const call = (node, ctx, visitors) => {
  walk(node.callee, ctx, visitors, node);
  list(node.arguments, ctx, visitors, node);
};

const list = (nodes, ctx, visitors, node) => {
  nodes.forEach(item => walk(item, ctx, visitors, node));
};

const walkers = {
  TemplateLiteral: (node, ctx, visitors) => {
    list(node.expressions, ctx, visitors, node);
    list(node.quasis, ctx, visitors, node);
  },
  MemberExpression: (node, ctx, visitors) => {
    walk(node.object, ctx, visitors, node);
    walk(node.property, ctx, visitors, node);
  },
  CallExpression: call,
  NewExpression: call,
  ArrayExpression: (node, ctx, visitors) => {
    list(node.elements, ctx, visitors, node);
  },
  AssignmentExpression: binary,
  AwaitExpression: unary,
  BinaryExpression: binary,
  LogicalExpression: binary,
  UnaryExpression: unary,
  UpdateExpression: unary,
  ConditionalExpression: ternary,
  ObjectExpression: (node, ctx, visitors) => {
    list(node.properties, ctx, visitors, node);
  },
  Property: (node, ctx, visitors) => {
    walk(node.key, ctx, visitors, node);
    walk(node.value, ctx, visitors, node);
  },

  ArrowFunctionExpression: func,
  FunctionExpression: func,
  FunctionDeclaration: func,

  VariableDeclaration: (node, ctx, visitors) => {
    list(node.declarations, ctx, visitors, node);
  },
  VariableDeclarator: (node, ctx, visitors) => {
    walk(node.id, ctx, visitors, node);
    walk(node.init, ctx, visitors, node);
  },
  SpreadElement: (node, ctx, visitors) => {
    walk(node.argument, ctx, visitors, node);
  },

  BlockStatement: (node, ctx, visitors) => {
    list(node.body, ctx, visitors, node);
  },
  ExpressionStatement: (node, ctx, visitors) => {
    walk(node.expression, ctx, visitors, node);
  },
  IfStatement: ternary,
  ForStatement: (node, ctx, visitors) => {
    walk(node.init, ctx, visitors, node);
    walk(node.test, ctx, visitors, node);
    walk(node.update, ctx, visitors, node);
    walk(node.body, ctx, visitors, node);
  },
  WhileStatement: (node, ctx, visitors) => {
    walk(node.test, ctx, visitors, node);
    walk(node.body, ctx, visitors, node);
  },
  DoWhileStatement: (node, ctx, visitors) => {
    walk(node.body, ctx, visitors, node);
    walk(node.test, ctx, visitors, node);
  },
  SwitchStatement: (node, ctx, visitors) => {
    walk(node.discriminant, ctx, visitors, node);
    list(node.cases, ctx, visitors, node);
  },
  SwitchCase: (node, ctx, visitors) => {
    if (node.test) walk(node.test, ctx, visitors, node);
    list(node.consequent, ctx, visitors, node);
  },
  ReturnStatement: unary,

  Program: (node, ctx, visitors) => {
    walk(node.body[0], ctx, visitors, node);
  }
};

/***/ }),

/***/ "../../node_modules/arquero/src/expression/codegen.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/codegen.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");



const visit = (node, opt) => {
  const f = visitors[node.type];
  return f
    ? f(node, opt)
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])(`Unsupported expression construct: ${node.type}`);
};

const binary = (node, opt) => {
  return '(' + visit(node.left, opt) + ' ' + node.operator + ' ' + visit(node.right, opt) + ')';
};

const func = (node, opt) => {
  return '(' + list(node.params, opt) + ')=>' + visit(node.body, opt);
};

const call = (node, opt) => {
  return visit(node.callee, opt) + '(' + list(node.arguments, opt) + ')';
};

const list = (array, opt, delim = ',') => {
  return array.map(node => visit(node, opt)).join(delim);
};

const name = node => node.computed
  ? `[${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_1__["default"])(node.name)}]`
  : `.${node.name}`;

const ref = (node, opt, method) => {
  const table = node.table || '';
  return `data${table}${name(node)}.${method}(${opt.index}${table})`;
};

const visitors = {
  Constant: node => node.raw,
  Column: (node, opt) => ref(node, opt, 'get'),
  Dictionary: (node, opt) => ref(node, opt, 'key'),
  Function: node => `fn.${node.name}`,
  Parameter: node => `$${name(node)}`,
  Op: (node, opt) => `op(${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_1__["default"])(node.name)},${opt.op || opt.index})`,
  Literal: node => node.raw,
  Identifier: node => node.name,
  TemplateLiteral: (node, opt) => {
    const { quasis, expressions } = node;
    const n = expressions.length;
    let t = quasis[0].value.raw;
    for (let i = 0; i < n;) {
      t += '${' + visit(expressions[i], opt) + '}' + quasis[++i].value.raw;
    }
    return '`' + t + '`';
  },
  MemberExpression: (node, opt) => {
    const d = !node.computed;
    const o = visit(node.object, opt);
    const p = visit(node.property, opt);
    return o + (d ? '.' + p : '[' + p + ']');
  },
  CallExpression: call,
  NewExpression: (node, opt) => {
    return 'new ' + call(node, opt);
  },
  ArrayExpression: (node, opt) => {
    return '[' + list(node.elements, opt) + ']';
  },
  AssignmentExpression: binary,
  BinaryExpression: binary,
  LogicalExpression: binary,
  UnaryExpression: (node, opt) => {
    return '(' + node.operator + visit(node.argument, opt) + ')';
  },
  ConditionalExpression: (node, opt) => {
    return '(' + visit(node.test, opt) +
      '?' + visit(node.consequent, opt) +
      ':' + visit(node.alternate, opt) + ')';
  },
  ObjectExpression: (node, opt) => {
    return '({' + list(node.properties, opt) + '})';
  },
  Property: (node, opt) => {
    const key = visit(node.key, opt);
    return (node.computed ? `[${key}]` : key) + ':' + visit(node.value, opt);
  },

  ArrowFunctionExpression: func,
  FunctionExpression: func,
  FunctionDeclaration: func,

  ArrayPattern: (node, opt) => {
    return '[' + list(node.elements, opt) + ']';
  },
  ObjectPattern: (node, opt) => {
    return '{' + list(node.properties, opt) + '}';
  },
  VariableDeclaration: (node, opt) => {
    return node.kind + ' ' + list(node.declarations, opt, ',');
  },
  VariableDeclarator: (node, opt) => {
    return visit(node.id, opt) + '=' + visit(node.init, opt);
  },
  SpreadElement: (node, opt) => {
    return '...' + visit(node.argument, opt);
  },

  BlockStatement: (node, opt) => {
    return '{' + list(node.body, opt, ';') + ';}';
  },
  BreakStatement: () => {
    return 'break';
  },
  ExpressionStatement: (node, opt) => {
    return visit(node.expression, opt);
  },
  IfStatement: (node, opt) => {
    return 'if (' + visit(node.test, opt) + ')'
      + visit(node.consequent, opt)
      + (node.alternate ? ' else ' + visit(node.alternate, opt) : '');
  },
  SwitchStatement: (node, opt) => {
    return 'switch (' + visit(node.discriminant, opt) + ') {'
     + list(node.cases, opt, '')
     + '}';
  },
  SwitchCase: (node, opt) => {
    return (node.test ? 'case ' + visit(node.test, opt) : 'default')
      + ': '
      + list(node.consequent, opt, ';') + ';';
  },
  ReturnStatement: (node, opt) => {
    return 'return ' + visit(node.argument, opt);
  },
  Program: (node, opt) => visit(node.body[0], opt)
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(node, opt = { index: 'row' }) {
  return visit(node, opt);
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/compare.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/compare.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _codegen__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./codegen */ "../../node_modules/arquero/src/expression/codegen.js");
/* harmony import */ var _parse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _engine_reduce_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../engine/reduce/util */ "../../node_modules/arquero/src/engine/reduce/util.js");




// generate code to compare a single field
const _compare = (u, v, lt, gt) =>
  `((u = ${u}) < (v = ${v}) || u == null) && v != null ? ${lt}
    : (u > v || v == null) && u != null ? ${gt}
    : ((v = v instanceof Date ? +v : v), (u = u instanceof Date ? +u : u)) !== u && v === v ? ${lt}
    : v !== v && u === u ? ${gt} : `;

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, fields) {
  // parse expressions, generate code for both a and b values
  const names = [];
  const exprs = [];
  const fn = [];
  let keys = null, opA = '0', opB = '0';
  if (table.isGrouped()) {
    keys = table.groups().keys;
    opA = 'ka';
    opB = 'kb';
  }
  const { ops } = (0,_parse__WEBPACK_IMPORTED_MODULE_1__["default"])(fields, {
    table,
    value: (name, node) => {
      names.push(name);
      if (node.escape) {
        // if an escaped function, invoke it directly
        const f = i => `fn[${fn.length}](${i}, data)`;
        exprs.push([f('a'), f('b')]);
        fn.push(node.escape);
      } else {
        // generate code to extract values to compare
        exprs.push([
          (0,_codegen__WEBPACK_IMPORTED_MODULE_0__["default"])(node, { index: 'a', op: opA }),
          (0,_codegen__WEBPACK_IMPORTED_MODULE_0__["default"])(node, { index: 'b', op: opB })
        ]);
      }
    },
    window: false
  });

  // calculate aggregate values if needed
  const result = (0,_engine_reduce_util__WEBPACK_IMPORTED_MODULE_2__.aggregate)(table, ops);
  const op = (id, row) => result[id][row];

  // generate comparison code for each field
  const n = names.length;
  let code = 'return (a, b) => {'
    + (op && table.isGrouped() ? 'const ka = keys[a], kb = keys[b];' : '')
    + 'let u, v; return ';
  for (let i = 0; i < n; ++i) {
    const o = fields.get(names[i]).desc ? -1 : 1;
    const [u, v] = exprs[i];
    code += _compare(u, v, -o, o);
  }
  code += '0;};';

  // instantiate and return comparator function
  return Function('op', 'keys', 'fn', 'data', code)(op, keys, fn, table.data());
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/compile.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/compile.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../op */ "../../node_modules/arquero/src/op/index.js");


function compile(code, fn, params) {
  code = `"use strict"; return ${code};`;
  return (Function('fn', '$', code))(fn, params);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  escape: (code, func, params) => compile(code, func, params),
  expr:   (code, params) => compile(`(row,data,op)=>${code}`, _op__WEBPACK_IMPORTED_MODULE_0__.functions, params),
  expr2:  (code, params) => compile(`(row0,data0,row,data)=>${code}`, _op__WEBPACK_IMPORTED_MODULE_0__.functions, params),
  join:   (code, params) => compile(`(row1,data1,row2,data2)=>${code}`, _op__WEBPACK_IMPORTED_MODULE_0__.functions, params),
  param:  (code, params) => compile(code, _op__WEBPACK_IMPORTED_MODULE_0__.functions, params)
});

/***/ }),

/***/ "../../node_modules/arquero/src/expression/constants.js":
/*!**************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/constants.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  undefined: 'void(0)',
  Infinity:  'Number.POSITIVE_INFINITY',
  NaN:       'Number.NaN',
  E:         'Math.E',
  LN2:       'Math.LN2',
  LN10:      'Math.LN10',
  LOG2E:     'Math.LOG2E',
  LOG10E:    'Math.LOG10E',
  PI:        'Math.PI',
  SQRT1_2:   'Math.SQRT1_2',
  SQRT2:     'Math.SQRT2'
});

/***/ }),

/***/ "../../node_modules/arquero/src/expression/parse-escape.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/parse-escape.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _compile__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./compile */ "../../node_modules/arquero/src/expression/compile.js");
/* harmony import */ var _row_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./row-object */ "../../node_modules/arquero/src/expression/row-object.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_to_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/to-function */ "../../node_modules/arquero/src/util/to-function.js");





const ERROR_ESC_AGGRONLY = 'Escaped functions are not valid as rollup or pivot values.';

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(ctx, spec, params) {
  if (ctx.aggronly) (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(ERROR_ESC_AGGRONLY);

  // generate escaped function invocation code
  const code = '(row,data)=>fn('
    + (0,_row_object__WEBPACK_IMPORTED_MODULE_1__.rowObjectCode)(ctx.table.columnNames())
    + ',$)';

  return { escape: _compile__WEBPACK_IMPORTED_MODULE_0__["default"].escape(code, (0,_util_to_function__WEBPACK_IMPORTED_MODULE_3__["default"])(spec.expr), params) };
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/parse-expression.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/parse-expression.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ parseExpression)
/* harmony export */ });
/* harmony import */ var acorn__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! acorn */ "../../node_modules/arquero/node_modules/acorn/dist/acorn.mjs");
/* harmony import */ var _ast_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ast/constants */ "../../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _ast_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ast/util */ "../../node_modules/arquero/src/expression/ast/util.js");
/* harmony import */ var _ast_walk__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ast/walk */ "../../node_modules/arquero/src/expression/ast/walk.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants */ "../../node_modules/arquero/src/expression/constants.js");
/* harmony import */ var _rewrite__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./rewrite */ "../../node_modules/arquero/src/expression/rewrite.js");
/* harmony import */ var _row_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./row-object */ "../../node_modules/arquero/src/expression/row-object.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../op */ "../../node_modules/arquero/src/op/index.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../util/has */ "../../node_modules/arquero/src/util/has.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");















const PARSER_OPT = { ecmaVersion: 11 };
const DEFAULT_PARAM_ID = '$';
const DEFAULT_TUPLE_ID = 'd';
const DEFAULT_TUPLE_ID1 = 'd1';
const DEFAULT_TUPLE_ID2 = 'd2';

const NO = msg => (node, ctx) => ctx.error(node, msg + ' not allowed');
const ERROR_AGGREGATE = NO('Aggregate function');
const ERROR_WINDOW = NO('Window function');
const ERROR_ARGUMENT = 'Invalid argument';
const ERROR_COLUMN = 'Invalid column reference';
const ERROR_AGGRONLY = ERROR_COLUMN + ' (must be input to an aggregate function)';
const ERROR_FUNCTION = 'Invalid function call';
const ERROR_MEMBER = 'Invalid member expression';
const ERROR_OP_PARAMETER = 'Invalid operator parameter';
const ERROR_PARAM = 'Invalid param reference';
const ERROR_VARIABLE = 'Invalid variable reference';
const ERROR_VARIABLE_OP = 'Variable not accessible in operator call';
const ERROR_DECLARATION = 'Unsupported variable declaration';
const ERROR_DESTRUCTURE = 'Unsupported destructuring pattern';
const ERROR_CLOSURE = 'Table expressions do not support closures';
const ERROR_ESCAPE = 'Use aq.escape(fn) to use a function as-is (including closures)';
const ERROR_USE_PARAMS = 'use table.params({ name: value }) to define dynamic parameters';
const ERROR_ADD_FUNCTION = 'use aq.addFunction(name, fn) to add new op functions';
const ERROR_VARIABLE_NOTE = `\nNote: ${ERROR_CLOSURE}. ${ERROR_ESCAPE}, or ${ERROR_USE_PARAMS}.`;
const ERROR_FUNCTION_NOTE = `\nNote: ${ERROR_CLOSURE}. ${ERROR_ESCAPE}, or ${ERROR_ADD_FUNCTION}.`;
const ERROR_ROW_OBJECT = `The ${_row_object__WEBPACK_IMPORTED_MODULE_6__.ROW_OBJECT} method is not valid in multi-table expressions.`;

function parseExpression(ctx, spec) {
  const ast = parseAST(spec);
  let node = ctx.root = ast;
  ctx.spec = spec;
  ctx.tuple = null;
  ctx.tuple1 = null;
  ctx.tuple2 = null;
  ctx.$param = null;
  ctx.$op = 0;
  ctx.scope = new Set();
  ctx.paramsRef = new Map();
  ctx.columnRef = new Map();

  // parse input column parameters
  // if no function def, assume default tuple identifiers
  if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.isFunctionExpression)(node)) {
    parseFunction(node, ctx);
    node = node.body;
  } else if (ctx.join) {
    ctx.scope.add(ctx.tuple1 = DEFAULT_TUPLE_ID1);
    ctx.scope.add(ctx.tuple2 = DEFAULT_TUPLE_ID2);
    ctx.scope.add(ctx.$param = DEFAULT_PARAM_ID);
  } else {
    ctx.scope.add(ctx.tuple = DEFAULT_TUPLE_ID);
    ctx.scope.add(ctx.$param = DEFAULT_PARAM_ID);
  }

  // rewrite column references & function calls
  (0,_ast_walk__WEBPACK_IMPORTED_MODULE_3__["default"])(node, ctx, visitors);

  return ctx.root;
}

function parseAST(expr) {
  try {
    const code = expr.field ? fieldRef(expr)
      : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_10__["default"])(expr) ? (0,_util_to_string__WEBPACK_IMPORTED_MODULE_12__["default"])(expr)
      : expr;
    return (0,acorn__WEBPACK_IMPORTED_MODULE_0__.parse)(`expr=(${code})`, PARSER_OPT).body[0].expression.right;
  } catch (err) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_8__["default"])(`Expression parse error: ${expr+''}`, err);
  }
}

function fieldRef(expr) {
  const col = JSON.stringify(expr+'');
  return !(expr.table || 0) ? `d=>d[${col}]` : `(a,b)=>b[${col}]`;
}

const visitors = {
  FunctionDeclaration: NO('Function definitions'),
  ForStatement: NO('For loops'),
  ForOfStatement: NO('For-of loops'),
  ForInStatement: NO('For-in loops'),
  WhileStatement: NO('While loops'),
  DoWhileStatement: NO('Do-while loops'),
  AwaitExpression: NO('Await expressions'),
  ArrowFunctionExpression: NO('Function definitions'),
  AssignmentExpression: NO('Assignments'),
  FunctionExpression: NO('Function definitions'),
  NewExpression: NO('Use of "new"'),
  UpdateExpression: NO('Update expressions'),

  VariableDeclarator(node, ctx) {
    handleDeclaration(node.id, ctx);
  },
  Identifier(node, ctx, parent) {
    if (handleIdentifier(node, ctx, parent) && !ctx.scope.has(node.name)) {
      // handle identifier passed responsibility here
      // raise error if identifier not defined in scope
      ctx.error(node, ERROR_VARIABLE, ERROR_VARIABLE_NOTE);
    }
  },
  CallExpression(node, ctx) {
    const name = functionName(node.callee);
    const def = (0,_op__WEBPACK_IMPORTED_MODULE_7__.getAggregate)(name) || (0,_op__WEBPACK_IMPORTED_MODULE_7__.getWindow)(name);

    // parse operator and rewrite invocation
    if (def) {
      if ((ctx.join || ctx.aggregate === false) && (0,_op__WEBPACK_IMPORTED_MODULE_7__.hasAggregate)(def)) {
        ERROR_AGGREGATE(node, ctx);
      }
      if ((ctx.join || ctx.window === false) && (0,_op__WEBPACK_IMPORTED_MODULE_7__.hasWindow)(def)) {
        ERROR_WINDOW(node, ctx);
      }

      ctx.$op = 1;
      if (ctx.ast) {
        updateFunctionNode(node, name, ctx);
        node.arguments.forEach(arg => (0,_ast_walk__WEBPACK_IMPORTED_MODULE_3__["default"])(arg, ctx, opVisitors));
      } else {
        const op = ctx.op(parseOperator(ctx, def, name, node.arguments));
        Object.assign(node, { type: _ast_constants__WEBPACK_IMPORTED_MODULE_1__.Op, name: op.id });
      }
      ctx.$op = 0;
      return false;
    } else if ((0,_op__WEBPACK_IMPORTED_MODULE_7__.hasFunction)(name)) {
      updateFunctionNode(node, name, ctx);
    } else {
      ctx.error(node, ERROR_FUNCTION, ERROR_FUNCTION_NOTE);
    }
  },
  MemberExpression(node, ctx, parent) {
    const { object, property } = node;

    // bail if left head is not an identifier
    // in this case we will recurse and handle it later
    if (!(0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, object)) return;
    const { name } = object;

    // allow use of Math prefix to access constant values
    if (isMath(node) && (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, property)
        && (0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(_constants__WEBPACK_IMPORTED_MODULE_4__["default"], property.name)) {
      updateConstantNode(node, property.name);
      return;
    }

    const index = name === ctx.tuple ? 0
      : name === ctx.tuple1 ? 1
      : name === ctx.tuple2 ? 2
      : -1;

    if (index >= 0) {
      // replace member expression with column ref
      return spliceMember(node, index, ctx, checkColumn, parent);
    } else if (name === ctx.$param) {
      // replace member expression with param ref
      return spliceMember(node, index, ctx, checkParam);
    } else if (ctx.paramsRef.has(name)) {
      updateParameterNode(node, ctx.paramsRef.get(name));
    } else if (ctx.columnRef.has(name)) {
      updateColumnNode(object, name, ctx, node);
    } else if ((0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(ctx.params, name)) {
      updateParameterNode(object, name);
    }
  }
};

function spliceMember(node, index, ctx, check, parent) {
  const { property, computed } = node;
  let name;

  if (!computed) {
    name = property.name;
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Literal, property)) {
    name = property.value;
  } else try {
    name = ctx.param(property);
  } catch (e) {
    ctx.error(node, ERROR_MEMBER);
  }

  check(node, name, index, ctx, parent);
  return false;
}

const opVisitors = {
  ...visitors,
  VariableDeclarator: NO('Variable declaration in operator call'),
  Identifier(node, ctx, parent) {
    if (handleIdentifier(node, ctx, parent)) {
      ctx.error(node, ERROR_VARIABLE_OP);
    }
  },
  CallExpression(node, ctx) {
    const name = functionName(node.callee);

    // rewrite if built-in function
    if ((0,_op__WEBPACK_IMPORTED_MODULE_7__.hasFunction)(name)) {
      updateFunctionNode(node, name, ctx);
    } else {
      ctx.error(node, ERROR_FUNCTION, ERROR_FUNCTION_NOTE);
    }
  }
};

function parseFunction(node, ctx) {
  if (node.generator) NO('Generator functions')(node, ctx);
  if (node.async) NO('Async functions')(node, ctx);

  const { params } = node;
  const len = params.length;
  const setc = index => (name, key) => ctx.columnRef.set(name, [key, index]);
  const setp = (name, key) => ctx.paramsRef.set(name, key);

  if (!len) {
    // do nothing
  } else if (ctx.join) {
    parseRef(ctx, params[0], 'tuple1', setc(1));
    if (len > 1) parseRef(ctx, params[1], 'tuple2', setc(2));
    if (len > 2) parseRef(ctx, params[2], '$param', setp);
  } else {
    parseRef(ctx, params[0], 'tuple', setc(0));
    if (len > 1) parseRef(ctx, params[1], '$param', setp);
  }

  ctx.root = node.body;
}

function parseRef(ctx, node, refName, alias) {
  if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, node)) {
    ctx.scope.add(node.name);
    ctx[refName] = node.name;
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.ObjectPattern, node)) {
    node.properties.forEach(p => {
      const key = (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, p.key) ? p.key.name
        : (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Literal, p.key) ? p.key.value
        : ctx.error(p, ERROR_ARGUMENT);
      if (!(0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, p.value)) {
        ctx.error(p.value, ERROR_DESTRUCTURE);
      }
      alias(p.value.name, key);
    });
  }
}

function parseOperator(ctx, def, name, args) {
  const fields = [];
  const params = [];
  const idxFields = def.param[0] || 0;
  const idxParams = idxFields + (def.param[1] || 0);

  args.forEach((arg, index) => {
    if (index < idxFields) {
      (0,_ast_walk__WEBPACK_IMPORTED_MODULE_3__["default"])(arg, ctx, opVisitors);
      fields.push(ctx.field(arg));
    } else if (index < idxParams) {
      (0,_ast_walk__WEBPACK_IMPORTED_MODULE_3__["default"])(arg, ctx, opVisitors);
      params.push(ctx.param(arg));
    } else {
      ctx.error(arg, ERROR_OP_PARAMETER);
    }
  });

  return { name, fields, params, ...(ctx.spec.window || {}) };
}

function functionName(node) {
  return (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, node) ? node.name
    : !(0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.MemberExpression, node) ? null
    : isMath(node) ? rewriteMath(node.property.name)
    : node.property.name;
}

function isMath(node) {
  return (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, node.object) && node.object.name === 'Math';
}

function rewriteMath(name) {
  return name === 'max' ? 'greatest'
    : name === 'min' ? 'least'
    : name;
}

function handleIdentifier(node, ctx, parent) {
  const { name } = node;

  if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.MemberExpression, parent) && parent.property === node) {
    // do nothing: check head node, not nested properties
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Property, parent) && parent.key === node) {
    // do nothing: identifiers allowed in object expressions
  } else if (ctx.paramsRef.has(name)) {
    updateParameterNode(node, ctx.paramsRef.get(name));
  } else if (ctx.columnRef.has(name)) {
    updateColumnNode(node, name, ctx, parent);
  } else if ((0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(ctx.params, name)) {
    updateParameterNode(node, name);
  } else if ((0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(_constants__WEBPACK_IMPORTED_MODULE_4__["default"], name)) {
    updateConstantNode(node, name);
  } else {
    return true;
  }
}

function checkColumn(node, name, index, ctx, parent) {
  // check column existence if we have a backing table
  const table = index === 0 ? ctx.table
    : index > 0 ? ctx.join[index - 1]
    : null;
  const col = table && table.column(name);
  if (table && !col) {
    ctx.error(node, ERROR_COLUMN);
  }

  // check if column reference is valid in current context
  if (ctx.aggronly && !ctx.$op) {
    ctx.error(node, ERROR_AGGRONLY);
  }

  // rewrite ast node as a column access
  (0,_rewrite__WEBPACK_IMPORTED_MODULE_5__["default"])(node, name, index, col, parent);
}

function updateColumnNode(node, key, ctx, parent) {
  const [name, index] = ctx.columnRef.get(key);
  checkColumn(node, name, index, ctx, parent);
}

function checkParam(node, name, index, ctx) {
  if (ctx.params && !(0,_util_has__WEBPACK_IMPORTED_MODULE_9__["default"])(ctx.params, name)) {
    ctx.error(node, ERROR_PARAM);
  }
  updateParameterNode(node, name);
}

function updateParameterNode(node, name) {
  node.type = _ast_constants__WEBPACK_IMPORTED_MODULE_1__.Parameter;
  node.name = name;
}

function updateConstantNode(node, name) {
  node.type = _ast_constants__WEBPACK_IMPORTED_MODULE_1__.Constant;
  node.name = name;
  node.raw = _constants__WEBPACK_IMPORTED_MODULE_4__["default"][name];
}

function updateFunctionNode(node, name, ctx) {
  if (name === _row_object__WEBPACK_IMPORTED_MODULE_6__.ROW_OBJECT) {
    const t = ctx.table;
    if (!t) ctx.error(node, ERROR_ROW_OBJECT);
    (0,_row_object__WEBPACK_IMPORTED_MODULE_6__.rowObjectExpression)(node,
      node.arguments.length
        ? node.arguments.map(node => {
            const col = ctx.param(node);
            const name = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_11__["default"])(col) ? t.columnName(col) : col;
            if (!t.column(name)) ctx.error(node, ERROR_COLUMN);
            return name;
          })
        : t.columnNames()
    );
  } else {
    node.callee = { type: _ast_constants__WEBPACK_IMPORTED_MODULE_1__.Function, name };
  }
}

function handleDeclaration(node, ctx) {
  if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.Identifier, node)) {
    ctx.scope.add(node.name);
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.ArrayPattern, node)) {
    node.elements.forEach(elm => handleDeclaration(elm, ctx));
  } else if ((0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_1__.ObjectPattern, node)) {
    node.properties.forEach(prop => handleDeclaration(prop.value, ctx));
  } else {
    ctx.error(node.id, ERROR_DECLARATION);
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/parse.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/expression/parse.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ast_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ast/constants */ "../../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _ast_clean__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ast/clean */ "../../node_modules/arquero/src/expression/ast/clean.js");
/* harmony import */ var _ast_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ast/util */ "../../node_modules/arquero/src/expression/ast/util.js");
/* harmony import */ var _codegen__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./codegen */ "../../node_modules/arquero/src/expression/codegen.js");
/* harmony import */ var _compile__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./compile */ "../../node_modules/arquero/src/expression/compile.js");
/* harmony import */ var _util_entries__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/entries */ "../../node_modules/arquero/src/util/entries.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _parse_escape__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./parse-escape */ "../../node_modules/arquero/src/expression/parse-escape.js");
/* harmony import */ var _parse_expression__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./parse-expression */ "../../node_modules/arquero/src/expression/parse-expression.js");












const ANNOTATE = { [_ast_constants__WEBPACK_IMPORTED_MODULE_0__.Column]: 1, [_ast_constants__WEBPACK_IMPORTED_MODULE_0__.Op]: 1 };

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(input, opt = {}) {
  const generate = opt.generate || _codegen__WEBPACK_IMPORTED_MODULE_3__["default"];
  const compiler = opt.compiler || _compile__WEBPACK_IMPORTED_MODULE_4__["default"];
  const params = getParams(opt);
  const fields = {};
  const opcall = {};
  const names = [];
  const exprs = [];
  let fieldId = 0;
  let opId = -1;

  const compileExpr = opt.join ? compiler.join
    : opt.index == 1 ? compiler.expr2
    : compiler.expr;

  // parser context
  const ctx = {
    op(op) {
      const key = opKey(op);
      return opcall[key] || (op.id = ++opId, opcall[key] = op);
    },
    field(node) {
      const code = generate(node);
      return fields[code] || (fields[code] = ++fieldId);
    },
    param(node) {
      return (0,_ast_util__WEBPACK_IMPORTED_MODULE_2__.is)(_ast_constants__WEBPACK_IMPORTED_MODULE_0__.Literal, node)
        ? node.value
        : compiler.param(generate(node), params);
    },
    value(name, node) {
      names.push(name);
      const e = node.escape || (opt.ast
        ? (0,_ast_clean__WEBPACK_IMPORTED_MODULE_1__["default"])(node)
        : compileExpr(generate(node), params));
      exprs.push(e);
      // annotate expression if it is a direct column or op access
      // this permits downstream optimizations
      if (ANNOTATE[node.type] && e !== node && (0,_util_is_object__WEBPACK_IMPORTED_MODULE_8__["default"])(e)) {
        e.field = node.name;
      }
    },
    error(node, msg, note = '') {
      // both expresions and fields are parsed
      // with added code prefixes of length 6!
      const i = node.start - 6;
      const j = node.end - 6;
      const snippet = String(ctx.spec).slice(i, j);
      (0,_util_error__WEBPACK_IMPORTED_MODULE_6__["default"])(`${msg}: "${snippet}"${note}`);
    }
  };

  // copy all options to context, potentially overwriting methods
  Object.assign(ctx, opt, { params });

  // parse each expression
  for (const [name, value] of (0,_util_entries__WEBPACK_IMPORTED_MODULE_5__["default"])(input)) {
    ctx.value(
      name + '',
      value.escape
        ? (0,_parse_escape__WEBPACK_IMPORTED_MODULE_9__["default"])(ctx, value, params)
        : (0,_parse_expression__WEBPACK_IMPORTED_MODULE_10__["default"])(ctx, value)
    );
  }

  // return expression asts if requested
  if (opt.ast) {
    return { names, exprs };
  }

  // compile input field accessors
  const f = [];
  for (const key in fields) {
    f[fields[key]] = compiler.expr(key, params);
  }

  // resolve input fields to operations
  const ops = Object.values(opcall);
  ops.forEach(op => op.fields = op.fields.map(id => f[id]));

  return { names, exprs, ops };
}

function opKey(op) {
  let key = `${op.name}(${op.fields.concat(op.params).join(',')})`;
  if (op.frame) {
    const frame = op.frame.map(v => Number.isFinite(v) ? Math.abs(v) : -1);
    key += `[${frame},${!!op.peers}]`;
  }
  return key;
}

function getParams(opt) {
  return (opt.table ? getTableParams(opt.table)
    : opt.join ? {
        ...getTableParams(opt.join[1]),
        ...getTableParams(opt.join[0])
      }
    : {}) || {};
}

function getTableParams(table) {
  return table && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(table.params) ? table.params() : {};
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/rewrite.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/rewrite.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ast_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ast/constants */ "../../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");



const dictOps = {
  '==': 1,
  '!=': 1,
  '===': 1,
  '!==': 1
};

/**
 * Rewrite AST node to be a table column reference.
 * Additionally optimizes dictionary column operations.
 * @param {object} ref AST node to rewrite to a column reference.
 * @param {string} name The name of the column.
 * @param {number} index The table index of the column.
 * @param {object} col The actual table column instance.
 * @param {object} op Parent AST node operating on the column reference.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(ref, name, index = 0, col, op) {
  ref.type = _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Column;
  ref.name = name;
  ref.table = index;

  // proceed only if has parent op and is a dictionary column
  if (op && col && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_1__["default"])(col.keyFor)) {
    // get other arg if op is an optimizeable operation
    const lit = dictOps[op.operator]
      ? op.left === ref ? op.right : op.left
      : op.callee && op.callee.name === 'equal'
      ? op.arguments[op.arguments[0] === ref ? 1 : 0]
      : null;

    // rewrite as dictionary lookup if other arg is a literal
    if (lit && lit.type === _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Literal) {
      rewriteDictionary(op, ref, lit, col.keyFor(lit.value));
    }
  }

  return ref;
}

function rewriteDictionary(op, ref, lit, key) {
  if (key < 0) {
    // value not in dictionary, rewrite op as false literal
    op.type = _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Literal;
    op.value = false;
    op.raw = 'false';
  } else {
    // rewrite ref as dict key access
    ref.type = _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Dictionary;

    // rewrite literal as target dict key
    lit.value = key;
    lit.raw = key + '';
  }

  return true;
}

/***/ }),

/***/ "../../node_modules/arquero/src/expression/row-object.js":
/*!***************************************************************!*\
  !*** ../../node_modules/arquero/src/expression/row-object.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ROW_OBJECT: () => (/* binding */ ROW_OBJECT),
/* harmony export */   rowObjectBuilder: () => (/* binding */ rowObjectBuilder),
/* harmony export */   rowObjectCode: () => (/* binding */ rowObjectCode),
/* harmony export */   rowObjectExpression: () => (/* binding */ rowObjectExpression)
/* harmony export */ });
/* harmony import */ var _ast_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ast/constants */ "../../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _codegen__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./codegen */ "../../node_modules/arquero/src/expression/codegen.js");
/* harmony import */ var _compile__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./compile */ "../../node_modules/arquero/src/expression/compile.js");
/* harmony import */ var _rewrite__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./rewrite */ "../../node_modules/arquero/src/expression/rewrite.js");
/* harmony import */ var _util_entries__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/entries */ "../../node_modules/arquero/src/util/entries.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");








const ROW_OBJECT = 'row_object';

function rowObjectExpression(node, props) {
  node.type = _ast_constants__WEBPACK_IMPORTED_MODULE_0__.ObjectExpression;

  const p = node.properties = [];
  for (const prop of (0,_util_entries__WEBPACK_IMPORTED_MODULE_4__["default"])(props)) {
    const [name, key] = (0,_util_is_array__WEBPACK_IMPORTED_MODULE_5__["default"])(prop) ? prop : [prop, prop];
    p.push({
      type: _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Property,
      key: { type: _ast_constants__WEBPACK_IMPORTED_MODULE_0__.Literal, raw: (0,_util_to_string__WEBPACK_IMPORTED_MODULE_6__["default"])(key) },
      value: (0,_rewrite__WEBPACK_IMPORTED_MODULE_3__["default"])({ computed: true }, name)
    });
  }

  return node;
}

function rowObjectCode(props) {
  return (0,_codegen__WEBPACK_IMPORTED_MODULE_1__["default"])(rowObjectExpression({}, props));
}

function rowObjectBuilder(props) {
  return _compile__WEBPACK_IMPORTED_MODULE_2__["default"].expr(rowObjectCode(props));
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/from-arrow.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/format/from-arrow.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrow_arrow_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../arrow/arrow-table */ "../../node_modules/arquero/src/arrow/arrow-table.js");
/* harmony import */ var _arrow_arrow_column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../arrow/arrow-column */ "../../node_modules/arquero/src/arrow/arrow-column.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _table_bit_set__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../table/bit-set */ "../../node_modules/arquero/src/table/bit-set.js");
/* harmony import */ var _table_column_set__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../table/column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");







/**
 * Options for Apache Arrow import.
 * @typedef {object} ArrowOptions
 * @property {import('../table/transformable').Select} columns
 *  An ordered set of columns to import. The input may consist of column name
 *  strings, column integer indices, objects with current column names as keys
 *  and new column names as values (for renaming), or selection helper
 *  functions such as {@link all}, {@link not}, or {@link range}.
 */

/**
 * Create a new table backed by an Apache Arrow table instance.
 * @param {object} arrow An Apache Arrow data table or byte buffer.
 * @param {ArrowOptions} options Options for Arrow import.
 * @return {ColumnTable} A new table containing the imported values.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(arrow, options = {}) {
  arrow = (0,_arrow_arrow_table__WEBPACK_IMPORTED_MODULE_0__.from)(arrow);
  const { chunks, length, schema } = arrow;

  // resolve column selection
  const fields = schema.fields.map(f => f.name);
  const sel = (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_2__["default"])({
    columnNames: test => test ? fields.filter(test) : fields.slice(),
    columnIndex: name => fields.indexOf(name)
  }, options.columns || (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_2__.all)());

  // build Arquero columns for backing Arrow columns
  const cols = (0,_table_column_set__WEBPACK_IMPORTED_MODULE_4__["default"])();
  sel.forEach((name, key) => {
    cols.add(name, (0,_arrow_arrow_column__WEBPACK_IMPORTED_MODULE_1__["default"])(arrow.getColumn(key)));
  });

  // build row filter bit mask as needed
  const bits = arrow.count() !== length ? new _table_bit_set__WEBPACK_IMPORTED_MODULE_3__["default"](length) : null;
  if (bits) {
    let b = 0;
    let c = 0;
    arrow.scan(
      idx => bits.set(b + idx),
      batch => { while (chunks[c] !== batch) b += chunks[c++].length; }
    );
  }

  return new _table_column_table__WEBPACK_IMPORTED_MODULE_5__["default"](cols.data, cols.names, bits);
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/from-csv.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/format/from-csv.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _from_text_rows__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./from-text-rows */ "../../node_modules/arquero/src/format/from-text-rows.js");
/* harmony import */ var _parse_parse_delimited__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parse/parse-delimited */ "../../node_modules/arquero/src/format/parse/parse-delimited.js");
 // eslint-disable-line no-unused-vars




/**
 * Options for CSV parsing.
 * @typedef {object} CSVParseOptions
 * @property {string} [delimiter=','] Single-character delimiter between values.
 * @property {string} [decimal='.'] Single-character numeric decimal separator.
 * @property {boolean} [header=true] Flag to specify presence of header row.
 *  If true, assumes the CSV contains a header row with column names. If false,
 *  indicates the CSV does not contain a header row; columns are given the
 *  names 'col1', 'col2', etc unless the *names* option is specified.
 * @property {string[]} [names] An array of column names to use for header-less
 *  CSV files. This option is ignored if the header option is true.
 * @property {number} [skip=0] The number of lines to skip before reading data.
 * @property {string} [comment] A string used to identify comment lines. Any
 *  lines that start with the comment pattern are skipped.
 * @property {boolean} [autoType=true] Flag for automatic type inference.
 * @property {number} [autoMax=1000] Maximum number of initial values to use
 *  for type inference.
 * @property {Object.<string, (value: string) => any>} [parse] Object of
 *  column parsing options. The object keys should be column names. The object
 *  values should be parsing functions that transform values upon input.
 */

/**
 * Parse a comma-separated values (CSV) string into a table. Other
 * delimiters, such as tabs or pipes ('|'), can be specified using
 * the options argument. By default, automatic type inference is performed
 * for input values; string values that match the ISO standard
 * date format are parsed into JavaScript Date objects. To disable this
 * behavior, set the autoType option to false. To perform custom parsing
 * of input column values, use the parse option.
 * @param {string} text A string in a delimited-value format.
 * @param {CSVParseOptions} options The formatting options.
 * @return {ColumnTable} A new table containing the parsed values.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(text, options = {}) {
  const next = (0,_parse_parse_delimited__WEBPACK_IMPORTED_MODULE_2__["default"])(text, options);
  return (0,_from_text_rows__WEBPACK_IMPORTED_MODULE_1__["default"])(
    next,
    options.header !== false ? next() : options.names,
    options
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/from-fixed.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/format/from-fixed.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _from_text_rows__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./from-text-rows */ "../../node_modules/arquero/src/format/from-text-rows.js");
/* harmony import */ var _parse_parse_lines__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parse/parse-lines */ "../../node_modules/arquero/src/format/parse/parse-lines.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
 // eslint-disable-line no-unused-vars





/**
 * Options for fixed width file parsing.
 * @typedef {object} FixedParseOptions
 * @property {[number, number][]} [positions] Array of start, end indices for
 *  fixed-width columns.
 * @property {number[]} [widths] Array of fixed column widths. This option is
 *  ignored if the positions property is specified.
 * @property {string[]} [names] An array of column names. The array length
 *  should match the length of the positions array. If not specified or
 *  shorter than the positions array, default column names are generated.
 * @property {string} [decimal='.'] Single-character numeric decimal separator.
 * @property {number} [skip=0] The number of lines to skip before reading data.
 * @property {string} [comment] A string used to identify comment lines. Any
 *  lines that start with the comment pattern are skipped.
 * @property {boolean} [autoType=true] Flag for automatic type inference.
 * @property {number} [autoMax=1000] Maximum number of initial values to use
 *  for type inference.
 * @property {Object.<string, (value: string) => any>} [parse] Object of
 *  column parsing options. The object keys should be column names. The object
 *  values should be parsing functions that transform values upon input.
 */

/**
 * Parse a fixed-width file (FWF) string into a table. By default, automatic
 * type inference is performed for input values; string values that match the
 * ISO standard date format are parsed into JavaScript Date objects. To
 * disable this behavior, set the autoType option to false. To perform custom
 * parsing of input column values, use the parse option.
 * @param {string} text A string in a fixed-width file format.
 * @param {FixedParseOptions} options The formatting options.
 * @return {ColumnTable} A new table containing the parsed values.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(text, options = {}) {
  const read = (0,_parse_parse_lines__WEBPACK_IMPORTED_MODULE_2__["default"])(text, options);
  const p = positions(options);
  return (0,_from_text_rows__WEBPACK_IMPORTED_MODULE_1__["default"])(
    () => {
      const line = read();
      if (line) {
        return p.map(([i, j]) => line.slice(i, j).trim());
      }
    },
    options.names,
    options
  );
}

function positions({ positions, widths }) {
  if (!positions && !widths) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])('Fixed width files require a "positions" or "widths" option');
  }
  let i = 0;
  return positions || widths.map(w => [i, i += w]);
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/from-json.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/format/from-json.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _util_default_true__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/default-true */ "../../node_modules/arquero/src/util/default-true.js");
/* harmony import */ var _util_is_array_type__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-array-type */ "../../node_modules/arquero/src/util/is-array-type.js");
/* harmony import */ var _util_is_digit_string__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-digit-string */ "../../node_modules/arquero/src/util/is-digit-string.js");
/* harmony import */ var _util_is_iso_date_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-iso-date-string */ "../../node_modules/arquero/src/util/is-iso-date-string.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");








/**
 * Options for JSON parsing.
 * @typedef {object} JSONParseOptions
 * @property {boolean} [autoType=true] Flag controlling automatic type
 *  inference. If false, date parsing for input JSON strings is disabled.
 * @property {Object.<string, (value: any) => any>} [parse] Object of column
 *  parsing options. The object keys should be column names. The object values
 *  should be parsing functions that transform values upon input.
 */

/**
 * Parse JavaScript Object Notation (JSON) data into a table.
 * The expected JSON data format is an object with column names for keys
 * and column value arrays for values. By default string values that match
 * the ISO standard date format are parsed into JavaScript Date objects.
 * To disable this behavior, set the autoType option to false. To perform
 * custom parsing of input column values, use the parse option. Auto-type
 * parsing is not performed for columns with custom parse options.
 * The data payload can also be provided as the "data" property of an
 * enclosing object, with an optional "schema" property containing table
 * metadata such as a "fields" array of ordered column information.
 * @param {string|object} data A string in JSON format, or pre-parsed object.
 * @param {JSONParseOptions} options The formatting options.
 * @return {ColumnTable} A new table containing the parsed values.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(json, options = {}) {
  const autoType = (0,_util_default_true__WEBPACK_IMPORTED_MODULE_1__["default"])(options.autoType);

  // parse string input
  if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_6__["default"])(json)) {
    json = JSON.parse(json);
  }

  // separate schema and data, as needed
  let data = json.data, names;
  if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_5__["default"])(data) && !(0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_2__["default"])(data)) {
    if (json.schema && json.schema.fields) {
      names = json.schema.fields.map(f => f.name);
    }
  } else {
    data = json;
  }

  // parse values as necessary
  if (autoType || options.parse) {
    const parsers = options.parse || {};
    for (const name in data) {
      const col = data[name];
      const len = col.length;
      if (parsers[name]) {
        // apply custom parser
        for (let i = 0; i < len; ++i) {
          col[i] = parsers[name](col[i]);
        }
      } else if (autoType) {
        // apply autoType parser
        for (let i = 0; i < len; ++i) {
          const val = col[i];
          if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_6__["default"])(val) && (0,_util_is_iso_date_string__WEBPACK_IMPORTED_MODULE_4__["default"])(val) && !(0,_util_is_digit_string__WEBPACK_IMPORTED_MODULE_3__["default"])(val)) {
            col[i] = new Date(val);
          }
        }
      }
    }
  }

  return new _table_column_table__WEBPACK_IMPORTED_MODULE_0__["default"](data, names);
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/from-text-rows.js":
/*!***************************************************************!*\
  !*** ../../node_modules/arquero/src/format/from-text-rows.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _util_identity__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/identity */ "../../node_modules/arquero/src/util/identity.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/repeat */ "../../node_modules/arquero/src/util/repeat.js");
/* harmony import */ var _util_parse_values__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/parse-values */ "../../node_modules/arquero/src/util/parse-values.js");






function defaultNames(n, off = 0) {
  return (0,_util_repeat__WEBPACK_IMPORTED_MODULE_3__["default"])(n - off, i => `col${i + off + 1}`);
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(next, names, options) {
  let row = next();
  const n = row.length;
  const automax = +options.autoMax || 1000;
  const values = (0,_util_repeat__WEBPACK_IMPORTED_MODULE_3__["default"])(n, () => []);
  names = names
    ? names.length < n ? [...names, defaultNames(n, names.length)] : names
    : defaultNames(n);

  // read in initial rows to guess types
  let idx = 0;
  for (; idx < automax && row; ++idx, row = next()) {
    for (let i = 0; i < n; ++i) {
      values[i].push(row[i] === '' ? null : row[i]);
    }
  }

  // initialize parsers
  const parsers = getParsers(names, values, options);

  // apply parsers
  parsers.forEach((parse, i) => {
    if (parse === _util_identity__WEBPACK_IMPORTED_MODULE_1__["default"]) return;
    const v = values[i];
    for (let r = 0; r < idx; ++r) {
      if (v[r] != null) v[r] = parse(v[r]);
    }
  });

  // parse remainder of file
  for (; row; row = next()) {
    for (let i = 0; i < n; ++i) {
      values[i].push(row[i] ? parsers[i](row[i]) : null);
    }
  }

  const columns = {};
  names.forEach((name, i) => columns[name] = values[i]);
  return new _table_column_table__WEBPACK_IMPORTED_MODULE_0__["default"](columns, names);
}

function getParsers(names, values, options) {
  const { parse = {} } = options;
  const noParse = options.autoType === false;

  return names.map(
    (name, i) => (0,_util_is_function__WEBPACK_IMPORTED_MODULE_2__["default"])(parse[name]) ? parse[name]
      : noParse ? _util_identity__WEBPACK_IMPORTED_MODULE_1__["default"]
      : (0,_util_parse_values__WEBPACK_IMPORTED_MODULE_4__["default"])(values[i], options)
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/infer.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/format/infer.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/is-date */ "../../node_modules/arquero/src/util/is-date.js");


function isExactDateUTC(d) {
  return d.getUTCHours() === 0
    && d.getUTCMinutes() === 0
    && d.getUTCSeconds() === 0
    && d.getUTCMilliseconds() === 0;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(scan, options = {}) {
  let count = 0;
  let nulls = 0;
  let dates = 0;
  let dutcs = 0;
  let nums = 0;
  let digits = 0;

  scan(value => {
    ++count;
    if (value == null) {
      ++nulls;
      return;
    }

    const type = typeof value;
    if (type === 'object' && (0,_util_is_date__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {
      ++dates;
      if (isExactDateUTC(value)) ++dutcs;
    } else if (type === 'number') {
      ++nums;
      if (value === value &&  (value | 0) !== value) {
        const s = value + '';
        const p = s.indexOf('.');
        if (p >= 0) {
          const e = s.indexOf('e');
          const l = e > 0 ? e : s.length;
          digits = Math.max(digits, l - p - 1);
        }
      }
    }
  });

  return {
    align:  (nulls + nums + dates) / count > 0.5 ? 'r' : 'l',
    format: {
      utc:    dates === dutcs,
      digits: Math.min(digits, options.maxdigits || 6)
    }
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/load-url.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/format/load-url.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   load: () => (/* binding */ load),
/* harmony export */   loadArrow: () => (/* binding */ loadArrow),
/* harmony export */   loadCSV: () => (/* binding */ loadCSV),
/* harmony export */   loadFixed: () => (/* binding */ loadFixed),
/* harmony export */   loadJSON: () => (/* binding */ loadJSON)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _from_arrow__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./from-arrow */ "../../node_modules/arquero/src/format/from-arrow.js");
/* harmony import */ var _from_csv__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./from-csv */ "../../node_modules/arquero/src/format/from-csv.js");
/* harmony import */ var _from_fixed__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./from-fixed */ "../../node_modules/arquero/src/format/from-fixed.js");
/* harmony import */ var _from_json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./from-json */ "../../node_modules/arquero/src/format/from-json.js");
/* harmony import */ var _table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../table */ "../../node_modules/arquero/src/table/index.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
 // eslint-disable-line no-unused-vars








/**
 * Options for file loading.
 * @typedef {object} LoadOptions
 * @property {'arrayBuffer'|'text'|'json'} [as='text'] A string indicating
 *  the data type of the file. One of 'arrayBuffer', 'json', or 'text'.
 * @property {(data: *, options?: object) => ColumnTable} [using] A function
 *  that accepts a data payload (e.g., string or buffer) and an options object
 *  as input and returns an Arquero table (such as fromCSV or fromJSON).
 * @property {object} [fetch] Options to pass to the HTTP fetch method
 *  when loading a URL.
 */

/**
 * Load data from a file and return a Promise for an Arquero table.
 * A specific format parser can be provided with the *using* option,
 * otherwise CSV format is assumed. The options to this method are
 * passed as the second argument to the format parser.
 * @param {string} url The URL to load.
 * @param {LoadOptions & object} options The loading and formatting options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.load('data/table.csv')
 * @example aq.load('data/table.json', { using: aq.fromJSON })
 * @example aq.load('data/table.json', { using: aq.from })
 */
function load(url, options = {}) {
  const parse = options.using || _from_csv__WEBPACK_IMPORTED_MODULE_2__["default"];
  return fetch(url, options.fetch)
    .then(res => res[options.as || 'text']())
    .then(data => parse(data, options));
}

/**
 * Load an Arrow file from a URL and return a Promise for an Arquero table.
 * @param {string} url The URL to load.
 * @param {LoadOptions & import('./from-arrow').ArrowOptions} options Arrow format options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.loadArrow('data/table.arrow')
 */
function loadArrow(url, options) {
  return load(url, { ...options, as: 'arrayBuffer', using: _from_arrow__WEBPACK_IMPORTED_MODULE_1__["default"] });
}

/**
 * Load a CSV file from a URL and return a Promise for an Arquero table.
 * @param {string} url The URL to load.
 * @param {LoadOptions & import('./from-csv').CSVParseOptions} options CSV format options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.loadCSV('data/table.csv')
 * @example aq.loadTSV('data/table.tsv', { delimiter: '\t' })
 */
function loadCSV(url, options) {
  return load(url, { ...options, as: 'text', using: _from_csv__WEBPACK_IMPORTED_MODULE_2__["default"] });
}

/**
 * Load a fixed width file from a URL and return a Promise for an Arquero table.
 * @param {string} url The URL to load.
 * @param {LoadOptions & import('./from-fixed').FixedParseOptions} options Fixed width format options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.loadFixedWidth('data/table.txt', { names: ['name', 'city', state'], widths: [10, 20, 2] })
 */
 function loadFixed(url, options) {
  return load(url, { ...options, as: 'text', using: _from_fixed__WEBPACK_IMPORTED_MODULE_3__["default"] });
}

/**
 * Load a JSON file from a URL and return a Promise for an Arquero table.
 * If the loaded JSON is array-valued, an array-of-objects format is assumed
 * and the aq.from method is used to construct the table. Otherwise, a
 * column object format is assumed and aq.fromJSON is applied.
 * @param {string} url The URL to load.
 * @param {LoadOptions & import('./from-json').JSONParseOptions} options JSON format options.
 * @return {Promise<ColumnTable>} A Promise for an Arquero table.
 * @example aq.loadJSON('data/table.json')
 */
function loadJSON(url, options) {
  return load(url, { ...options, as: 'json', using: parseJSON });
}

function parseJSON(data, options) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(data) ? (0,_table__WEBPACK_IMPORTED_MODULE_5__.from)(data) : (0,_from_json__WEBPACK_IMPORTED_MODULE_4__["default"])(data, options);
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/parse/constants.js":
/*!****************************************************************!*\
  !*** ../../node_modules/arquero/src/format/parse/constants.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EOF: () => (/* binding */ EOF),
/* harmony export */   EOL: () => (/* binding */ EOL),
/* harmony export */   NEWLINE: () => (/* binding */ NEWLINE),
/* harmony export */   QUOTE: () => (/* binding */ QUOTE),
/* harmony export */   RETURN: () => (/* binding */ RETURN)
/* harmony export */ });
const EOL = {};
const EOF = {};
const QUOTE = 34;
const NEWLINE = 10;
const RETURN = 13;

/***/ }),

/***/ "../../node_modules/arquero/src/format/parse/parse-delimited.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/arquero/src/format/parse/parse-delimited.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/arquero/src/format/parse/constants.js");
/* harmony import */ var _text_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./text-filter */ "../../node_modules/arquero/src/format/parse/text-filter.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/error */ "../../node_modules/arquero/src/util/error.js");




// Adapted from d3-dsv: https://github.com/d3/d3-dsv/blob/master/src/dsv.js
// Copyright 2013-2016 Mike Bostock
// All rights reserved.
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// * Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
// * Neither the name of the author nor the names of contributors may be used to
//   endorse or promote products derived from this software without specific prior
//   written permission.
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
// ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
// ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(text, { delimiter = ',', skip, comment }) {
  if (delimiter.length !== 1) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(`Text "delimiter" should be a single character, found "${delimiter}"`);
  }
  const delimCode = delimiter.charCodeAt(0);

  let N = text.length;
  let I = 0; // current character index
  let t; // current token
  let eof = N <= 0; // current token followed by EOF?
  let eol = false; // current token followed by EOL?

  // Strip the trailing newline.
  if (text.charCodeAt(N - 1) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) --N;
  if (text.charCodeAt(N - 1) === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) --N;

  function token() {
    if (eof) return _constants__WEBPACK_IMPORTED_MODULE_0__.EOF;
    if (eol) return eol = false, _constants__WEBPACK_IMPORTED_MODULE_0__.EOL;

    // Unescape quotes.
    const j = I;
    let i, c;
    if (text.charCodeAt(j) === _constants__WEBPACK_IMPORTED_MODULE_0__.QUOTE) {
      while (I++ < N && text.charCodeAt(I) !== _constants__WEBPACK_IMPORTED_MODULE_0__.QUOTE || text.charCodeAt(++I) === _constants__WEBPACK_IMPORTED_MODULE_0__.QUOTE);
      if ((i = I) >= N) eof = true;
      else if ((c = text.charCodeAt(I++)) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) eol = true;
      else if (c === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) { eol = true; if (text.charCodeAt(I) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) ++I; }
      return text.slice(j + 1, i - 1).replace(/""/g, '"');
    }

    // Find next delimiter or newline.
    while (I < N) {
      if ((c = text.charCodeAt(i = I++)) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) eol = true;
      else if (c === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) { eol = true; if (text.charCodeAt(I) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) ++I; }
      else if (c !== delimCode) continue;
      return text.slice(j, i);
    }

    // Return last token before EOF.
    return eof = true, text.slice(j, N);
  }

  function next() {
    if ((t = token()) !== _constants__WEBPACK_IMPORTED_MODULE_0__.EOF) {
      const row = [];
      while (t !== _constants__WEBPACK_IMPORTED_MODULE_0__.EOL && t !== _constants__WEBPACK_IMPORTED_MODULE_0__.EOF) row.push(t), t = token();
      return row;
    }
  }

  return (0,_text_filter__WEBPACK_IMPORTED_MODULE_1__["default"])(
    next, skip,
    comment && (x => (x && x[0] || '').startsWith(comment))
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/parse/parse-lines.js":
/*!******************************************************************!*\
  !*** ../../node_modules/arquero/src/format/parse/parse-lines.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/arquero/src/format/parse/constants.js");
/* harmony import */ var _text_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./text-filter */ "../../node_modules/arquero/src/format/parse/text-filter.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(text, { skip, comment }) {
  let N = text.length;
  let I = 0; // current character index

  // Strip the trailing newline.
  if (text.charCodeAt(N - 1) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) --N;
  if (text.charCodeAt(N - 1) === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) --N;

  function read() {
    if (I >= N) return;

    const j = I;
    let eol = false;
    let i, c;

    // Find next newline.
    while (I < N) {
      if ((c = text.charCodeAt(i = I++)) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) eol = true;
      else if (c === _constants__WEBPACK_IMPORTED_MODULE_0__.RETURN) { eol = true; if (text.charCodeAt(I) === _constants__WEBPACK_IMPORTED_MODULE_0__.NEWLINE) ++I; }
      if (eol) return text.slice(j, i);
    }

    // Return last line before EOF.
    return text.slice(j, N);
  }

  return (0,_text_filter__WEBPACK_IMPORTED_MODULE_1__["default"])(
    read, skip,
    comment && (x => (x || '').startsWith(comment))
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/parse/text-filter.js":
/*!******************************************************************!*\
  !*** ../../node_modules/arquero/src/format/parse/text-filter.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(read, skip, drop) {
  // skip initial lines, if requested
  let s = +skip || 0;
  while (--s >= 0) read();

  // return filtered stream
  return drop ? () => {
    let line;
    while (!line) {
      if (drop(line = read())) line = null;
      else return line;
    }
  } : read;
}


/***/ }),

/***/ "../../node_modules/arquero/src/format/to-arrow.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/format/to-arrow.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrow_encode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../arrow/encode */ "../../node_modules/arquero/src/arrow/encode/index.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_arrow_encode__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ "../../node_modules/arquero/src/format/to-csv.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/format/to-csv.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/format/util.js");
/* harmony import */ var _util_format_date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/format-date */ "../../node_modules/arquero/src/util/format-date.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-date */ "../../node_modules/arquero/src/util/is-date.js");
 // eslint-disable-line no-unused-vars





/**
 * Options for CSV formatting.
 * @typedef {object} CSVFormatOptions
 * @property {string} [delimiter=','] The delimiter between values.
 * @property {number} [limit=Infinity] The maximum number of rows to print.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('./util').ColumnSelectOptions} [columns] Ordered list
 *  of column names to include. If function-valued, the function should
 *  accept a table as input and return an array of column name strings.
 * @property {Object.<string, (value: any) => any>} [format] Object of column
 *  format options. The object keys should be column names. The object values
 *  should be formatting functions to invoke to transform column values prior
 *  to output. If specified, these override automatically inferred options.
 */

/**
 * Format a table as a comma-separated values (CSV) string. Other
 * delimiters, such as tabs or pipes ('|'), can be specified using
 * the options argument.
 * @param {ColumnTable} table The table to format.
 * @param {CSVFormatOptions} options The formatting options.
 * @return {string} A delimited-value format string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, options = {}) {
  const names = (0,_util__WEBPACK_IMPORTED_MODULE_1__.columns)(table, options.columns);
  const format = options.format || {};
  const delim = options.delimiter || ',';
  const reFormat = new RegExp(`["${delim}\n\r]`);

  const formatValue = value => value == null ? ''
    : (0,_util_is_date__WEBPACK_IMPORTED_MODULE_3__["default"])(value) ? (0,_util_format_date__WEBPACK_IMPORTED_MODULE_2__.formatUTCDate)(value, true)
    : reFormat.test(value += '') ? '"' + value.replace(/"/g, '""') + '"'
    : value;

  const vals = names.map(formatValue);
  let text = '';

  (0,_util__WEBPACK_IMPORTED_MODULE_1__.scan)(table, names, options.limit || Infinity, options.offset, {
    row() {
      text += vals.join(delim) + '\n';
    },
    cell(value, name, index) {
      vals[index] = formatValue(format[name] ? format[name](value) : value);
    }
  });

  return text + vals.join(delim);
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/to-html.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/format/to-html.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _value__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./value */ "../../node_modules/arquero/src/format/value.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/format/util.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_map_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/map-object */ "../../node_modules/arquero/src/util/map-object.js");
 // eslint-disable-line no-unused-vars






/**
 * Null format function.
 * @callback NullFormat
 * @param {null|undefined} [value] The value to format.
 * @return {string} The formatted HTML string.
 */

/**
 * CSS style function.
 * @callback StyleFunction
 * @param {string} name The column name.
 * @param {number} row The table row index.
 * @return {string} A CSS style string.
 */

/**
 * CSS style options.
 * @typedef {Object.<string, string | StyleFunction>} StyleOptions
 */

/**
 * Options for HTML formatting.
 * @typedef {object} HTMLFormatOptions
 * @property {number} [limit=Infinity] The maximum number of rows to print.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('./util').ColumnSelectOptions} [columns] Ordered list
 *  of column names to include. If function-valued, the function should
 *  accept a table as input and return an array of column name strings.
 * @property {import('./util').ColumnAlignOptions} [align] Object of column
 *  alignment options. The object keys should be column names. The object
 *  values should be aligment strings, one of 'l' (left), 'c' (center), or
 *  'r' (right). If specified, these override automatically inferred options.
 * @property {import('./util').ColumnFormatOptions} [format] Object of column
 *  format options. The object keys should be column names. The object values
 *  should be formatting functions or specification objects. If specified,
 *  these override automatically inferred options.
 * @property {NullFormat} [null] Format function for null or undefined values.
 *  If specified, this function will be invoked with the null or undefined
 *  value as the sole input, and the return value will be used as the HTML
 *  output for the value.
 * @property {StyleOptions} [style] CSS styles to include in HTML output.
 *  The object keys should be HTML table tag names: 'table', 'thead',
 *  'tbody', 'tr', 'th', or 'td'. The object values should be strings of
 *  valid CSS style directives (such as "font-weight: bold;") or functions
 *  that take a column name and row as inputs and return a CSS string.
 * @property {number} [maxdigits=6] The maximum number of fractional digits
 *  to include when formatting numbers. This option is passed to the format
 *  inference method and is overridden by any explicit format options.
 */

/**
 * Format a table as an HTML table string.
 * @param {ColumnTable} table The table to format.
 * @param {HTMLFormatOptions} options The formatting options.
 * @return {string} An HTML table string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, options = {}) {
  const names = (0,_util__WEBPACK_IMPORTED_MODULE_2__.columns)(table, options.columns);
  const { align, format } = (0,_util__WEBPACK_IMPORTED_MODULE_2__.formats)(table, names, options);
  const style = styles(options);
  const nullish = options.null;

  const alignValue = a => a === 'c' ? 'center' : a === 'r' ? 'right' : 'left';
  const escape = s => s.replace(/&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;');
  const baseFormat = (value, opt) => escape((0,_value__WEBPACK_IMPORTED_MODULE_1__["default"])(value, opt));
  const formatter = nullish
    ? (value, opt) => value == null ? nullish(value) : baseFormat(value, opt)
    : baseFormat;

  let r = -1;
  let idx = -1;

  const tag = (tag, name, shouldAlign) => {
    const a = shouldAlign ? alignValue(align[name]) : '';
    const s = style[tag] ? (style[tag](name, idx, r) || '') : '';
    const css = (a ? (`text-align: ${a};` + (s ? ' ' : '')) : '') + s;
    return `<${tag}${css ? ` style="${css}"` : ''}>`;
  };

  let text = tag('table')
    + tag('thead')
    + tag('tr', r)
    + names.map(name => `${tag('th', name, 1)}${name}</th>`).join('')
    + '</tr></thead>'
    + tag('tbody');

  (0,_util__WEBPACK_IMPORTED_MODULE_2__.scan)(table, names, options.limit, options.offset, {
    row(row) {
      r = row;
      text += (++idx ? '</tr>' : '') + tag('tr');
    },
    cell(value, name) {
      text += tag('td', name, 1)
        + formatter(value, format[name])
        + '</td>';
    }
  });

  return text + '</tr></tbody></table>';
}

function styles(options) {
  return (0,_util_map_object__WEBPACK_IMPORTED_MODULE_4__["default"])(
    options.style,
    value => (0,_util_is_function__WEBPACK_IMPORTED_MODULE_3__["default"])(value) ? value : () => value
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/to-json.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/format/to-json.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/format/util.js");
/* harmony import */ var _util_format_date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/format-date */ "../../node_modules/arquero/src/util/format-date.js");
/* harmony import */ var _util_default_true__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/default-true */ "../../node_modules/arquero/src/util/default-true.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-date */ "../../node_modules/arquero/src/util/is-date.js");
 // eslint-disable-line no-unused-vars






/**
 * Options for JSON formatting.
 * @typedef {object} JSONFormatOptions
 * @property {number} [limit=Infinity] The maximum number of rows to print.
 * @property {number} [offset=0] The row offset indicating how many initial
 *  rows to skip.
 * @property {boolean} [schema=true] Flag indicating if table schema metadata
 *  should be included in the JSON output. If false, only the data payload
 *  is included.
 * @property {import('./util').ColumnSelectOptions} [columns] Ordered list
 *  of column names to include. If function-valued, the function should
 *  accept a table as input and return an array of column name strings.
 * @property {Object.<string, (value: any) => any>} [format] Object of column
 *  format options. The object keys should be column names. The object values
 *  should be formatting functions to invoke to transform column values prior
 *  to output. If specified, these override automatically inferred options.
 */

const defaultFormatter = value => (0,_util_is_date__WEBPACK_IMPORTED_MODULE_4__["default"])(value)
  ? (0,_util_format_date__WEBPACK_IMPORTED_MODULE_2__.formatUTCDate)(value, true)
  : value;

/**
 * Format a table as a JavaScript Object Notation (JSON) string.
 * @param {ColumnTable} table The table to format.
 * @param {JSONFormatOptions} options The formatting options.
 * @return {string} A JSON string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, options = {}) {
  const schema = (0,_util_default_true__WEBPACK_IMPORTED_MODULE_3__["default"])(options.schema);
  const format = options.format || {};
  const names = (0,_util__WEBPACK_IMPORTED_MODULE_1__.columns)(table, options.columns);
  let text = '{';

  if (schema) {
    text += '"schema":{"fields":'
      + JSON.stringify(names.map(name => ({ name })))
      + '},"data":{';
  }

  names.forEach((name, i) => {
    text += (i ? ',' : '') + JSON.stringify(name) + ':[';

    const column = table.column(name);
    const formatter = format[name] || defaultFormatter;
    let r = -1;
    table.scan(row => {
      const value = column.get(row);
      text += (++r ? ',' : '') + JSON.stringify(formatter(value));
    }, true, options.limit, options.offset);

    text += ']';
  });

  return text + '}' + (schema ? '}' : '');
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/to-markdown.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/format/to-markdown.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _value__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./value */ "../../node_modules/arquero/src/format/value.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/format/util.js");
 // eslint-disable-line no-unused-vars




/**
 * Options for Markdown formatting.
 * @typedef {object} MarkdownFormatOptions
 * @property {number} [limit=Infinity] The maximum number of rows to print.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('./util').ColumnSelectOptions} [columns] Ordered list
 *  of column names to include. If function-valued, the function should
 *  accept a table as input and return an array of column name strings.
 * @property {import('./util').ColumnAlignOptions} [align] Object of column
 *  alignment options. The object keys should be column names. The object
 *  values should be aligment strings, one of 'l' (left), 'c' (center), or
 *  'r' (right). If specified, these override automatically inferred options.
 * @property {import('./util').ColumnFormatOptions} [format] Object of column
 *  format options. The object keys should be column names. The object values
 *  should be formatting functions or specification objects. If specified,
 *  these override automatically inferred options.
 * @property {number} [maxdigits=6] The maximum number of fractional digits
 *  to include when formatting numbers. This option is passed to the format
 *  inference method and is overridden by any explicit format options.
 */

/**
 * Format a table as a GitHub-Flavored Markdown table string.
 * @param {ColumnTable} table The table to format.
 * @param {MarkdownFormatOptions} options The formatting options.
 * @return {string} A GitHub-Flavored Markdown table string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, options = {}) {
  const names = (0,_util__WEBPACK_IMPORTED_MODULE_2__.columns)(table, options.columns);
  const { align, format } = (0,_util__WEBPACK_IMPORTED_MODULE_2__.formats)(table, names, options);

  const alignValue = a => a === 'c' ? ':-:' : a === 'r' ? '-:' : ':-';
  const escape = s => s.replace(/\|/g, '\\|');

  let text = '|'
    + names.map(escape).join('|')
    + '|\n|'
    + names.map(name => alignValue(align[name])).join('|')
    + '|';

  (0,_util__WEBPACK_IMPORTED_MODULE_2__.scan)(table, names, options.limit, options.offset, {
    row() {
      text += '\n|';
    },
    cell(value, name) {
      text += escape((0,_value__WEBPACK_IMPORTED_MODULE_1__["default"])(value, format[name])) + '|';
    }
  });

  return text + '\n';
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/util.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/format/util.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   columns: () => (/* binding */ columns),
/* harmony export */   formats: () => (/* binding */ formats),
/* harmony export */   scan: () => (/* binding */ scan)
/* harmony export */ });
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/table */ "../../node_modules/arquero/src/table/table.js");
/* harmony import */ var _infer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./infer */ "../../node_modules/arquero/src/format/infer.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
 // eslint-disable-line no-unused-vars




/**
 * Column selection function.
 * @typedef {(table: Table) => string[]} ColumnSelectFunction
 */

/**
 * Column selection options.
 * @typedef {string[]|ColumnSelectFunction} ColumnSelectOptions
 */

/**
 * Column format options. The object keys should be column names.
 * The object values should be formatting functions or objects.
 * If specified, these override any automatically inferred options.
 * @typedef {Object.<string, import('./value').ValueFormatOptions} ColumnFormatOptions
 */

/**
 * Column alignment options. The object keys should be column names.
 * The object values should be aligment strings, one of 'l' (left),
 * 'c' (center), or 'r' (right).
 * If specified, these override any automatically inferred options.
 * @typedef {Object.<string, 'l'|'c'|'r'>} ColumnAlignOptions
 */

function columns(table, names) {
  return (0,_util_is_function__WEBPACK_IMPORTED_MODULE_2__["default"])(names)
    ? names(table)
    : names || table.columnNames();
}

function formats(table, names, options) {
  const formatOpt = options.format || {};
  const alignOpt = options.align || {};
  const format = {};
  const align = {};

  names.forEach(name => {
    const auto = (0,_infer__WEBPACK_IMPORTED_MODULE_1__["default"])(values(table, name), options);
    align[name] = alignOpt[name] || auto.align;
    format[name] = formatOpt[name] || auto.format;
  });

  return { align, format };
}

function values(table, columnName) {
  const column = table.column(columnName);
  return fn => table.scan(row => fn(column.get(row)));
}

function scan(table, names, limit = 100, offset, ctx) {
  const data = table.data();
  const n = names.length;
  table.scan(row => {
    ctx.row(row);
    for (let i = 0; i < n; ++i) {
      const name = names[i];
      ctx.cell(data[names[i]].get(row), name, i);
    }
  }, true, limit, offset);
}

/***/ }),

/***/ "../../node_modules/arquero/src/format/value.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/format/value.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_format_date__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/format-date */ "../../node_modules/arquero/src/util/format-date.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-date */ "../../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_typed_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-typed-array */ "../../node_modules/arquero/src/util/is-typed-array.js");





/**
 * Column format object.
 * @typedef {object} ValueFormatObject
 * @property {boolean} [utc=false] If true, format dates in UTC time.
 * @property {number} [digits=0] The number of fractional digits to include
 *  when formatting numbers.
 * @property {number} [maxlen=30] The maximum string length for formatting
 *  nested object or array values.
 */

/**
 * @callback ValueFormatFunction
 * @param {*} value The value to format.
 * @return {*} A string-coercible or JSON-compatible formatted value.
 */

/**
 * Value format options.
 * @typedef {ValueFormatObject|ValueFormatFunction} ValueFormatOptions
 */

/**
 * Format a value as a string.
 * @param {*} v The value to format.
 * @param {ValueFormatOptions} options Formatting options.
 * @return {string} The formatted string.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(v, options = {}) {
  if ((0,_util_is_function__WEBPACK_IMPORTED_MODULE_2__["default"])(options)) {
    return options(v) + '';
  }

  const type = typeof v;

  if (type === 'object') {
    if ((0,_util_is_date__WEBPACK_IMPORTED_MODULE_1__["default"])(v)) {
      return options.utc ? (0,_util_format_date__WEBPACK_IMPORTED_MODULE_0__.formatUTCDate)(v) : (0,_util_format_date__WEBPACK_IMPORTED_MODULE_0__.formatDate)(v);
    } else {
      const s = JSON.stringify(
        v,
        (k, v) => (0,_util_is_typed_array__WEBPACK_IMPORTED_MODULE_3__["default"])(v) ? Array.from(v) : v
      );
      const maxlen = options.maxlen || 30;
      return s.length > maxlen
        ? s.slice(0, 28) + '\u2026' + (s[0] === '[' ? ']' : '}')
        : s;
    }
  } else if (type === 'number') {
    const digits = options.digits || 0;
    let a;
    return v !== 0 && ((a = Math.abs(v)) >= 1e18 || a < Math.pow(10, -digits))
      ? v.toExponential(digits)
      : v.toFixed(digits);
  } else {
    return v + '';
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/bin.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/bin.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Options for binning number values.
 * @typedef {object} BinOptions
 * @property {number} [maxbins] The maximum number of bins.
 * @property {number} [minstep] The minimum step size between bins.
 * @property {number} [step] The exact step size to use between bins.
 *  If specified, the maxbins and minstep options are ignored.
 * @property {boolean} [nice=true] Flag indicating if bins should
 *  snap to "nice" human-friendly values such as multiples of ten.
 * @property {number} [offset=0] Step offset for bin boundaries.
 *  The default floors to the lower bin boundary. A value of 1 snaps
 *  one step higher to the upper bin boundary, and so on.
 */

/**
 * Generate a table expression that performs uniform binning of
 * number values. The resulting string can be used as part of the
 * input to table transformation verbs.
 * @param {string} name The name of the column to bin.
 * @param {BinOptions} [options] Binning scheme options.
 * @return {string} A table expression string for binned values.
 * @example bin('colA', { maxbins: 20 })
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(name, options = {}) {
  const field = `d[${JSON.stringify(name)}]`;
  const { maxbins, nice, minstep, step, offset } = options;
  const args = [maxbins, nice, minstep, step];

  let n = args.length;
  while (n && args[--n] == null) args.pop();
  const a = args.length ? ', ' + args.map(a => a + '').join(', ') : '';

  return `d => op.bin(${field}, ...op.bins(${field}${a}), ${offset || 0})`;
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/desc.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/desc.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wrap */ "../../node_modules/arquero/src/helpers/wrap.js");


/**
 * Annotate a table expression to indicate descending sort order.
 * @param {string|Function|object} expr The table expression to annotate.
 * @return {object} A wrapped expression indicating descending sort.
 * @example desc('colA')
 * @example desc(d => d.colA)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(expr) {
  return (0,_wrap__WEBPACK_IMPORTED_MODULE_0__["default"])(expr, { desc: true });
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/escape.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/escape.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wrap */ "../../node_modules/arquero/src/helpers/wrap.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");



/**
 * Escape a function or value to prevent it from being parsed and recompiled.
 * This helper can be used in lieu of single-table table expressions (which
 * are internally parsed and rewritten) to apply a JavaScript function as-is,
 * including support for closures. It can also be used to pass a constant,
 * literal value as a table expression, bypassing the parser.
 * @param {*} value A function or value to escape.
 * @return {object} A wrapper object representing the escaped value.
 * @example escape(d => d.a.toFixed(2))
 * @example escape(d => d.a * -d.b)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return (0,_wrap__WEBPACK_IMPORTED_MODULE_0__["default"])(value, {
    escape: true,
    toString() { (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Escaped values can not be serialized.'); }
  });
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/field.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/field.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wrap */ "../../node_modules/arquero/src/helpers/wrap.js");


/**
 * Annotate an expression to indicate it is a string field reference.
 * @param {string|object} expr The column name, or an existing wrapped
 *  expression for a column name.
 * @param {string} [name] The column name to use. If provided, will
 *  overwrite the input expression value.
 * @param {number} [table=0] The table index of the field, in case of
 *  expressions over multiple tables.
 * @return A wrapped expression for a named column.
 * @example field('colA')
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(expr, name, table = 0) {
  const props = table ? { field: true, table } : { field: true };
  return (0,_wrap__WEBPACK_IMPORTED_MODULE_0__["default"])(
    expr,
    name ? { expr: name, ...props } : props
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/frac.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/frac.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Generate a table expression that computes the number of rows
 * corresponding to a given fraction for each group. The resulting
 * string can be used as part of the input to the sample verb.
 * @param {number} fraction The fractional value.
 * @return {string} A table expression string for computing row counts.
 * @example frac(0.5)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(fraction) {
  return `() => op.round(${+fraction} * op.count())`;
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/names.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/names.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Select columns by index and rename them to the provided names. Returns a
 * selection helper function that takes a table as input and produces a
 * rename map as output. If the number of provided names is less than the
 * number of table columns, the rename map will only include entries for the
 * provided names. If the number of table columns is less than then number of
 * provided names, only the rename map will only include entries that cover
 * the existing columns.
 * @param {...(string|string[])} names An ordered list of column names.
 * @return {Function} Selection function compatible with {@link Table#select}.
 * @example table.rename(aq.names('a', 'b', 'c'))
 * @example table.select(aq.names(['a', 'b', 'c']))
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(...names) {
  names = names.flat();
  return table => {
    const m = new Map();
    const n = Math.min(names.length, table.numCols());
    for (let i = 0; i < n; ++i) {
      m.set(table.columnName(i), names[i]);
    }
    return m;
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/rolling.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/rolling.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _wrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./wrap */ "../../node_modules/arquero/src/helpers/wrap.js");


/**
 * Annotate a table expression to compute rolling aggregate or window
 * functions within a sliding window frame. For example, to specify a
 * rolling 7-day average centered on the current day, use rolling with
 * a frame value of [-3, 3].
 * @param {string|Function|object} expr The table expression to annotate.
 * @param {[number?, number?]} [frame=[-Infinity, 0]] The sliding window frame
 *  offsets. Each entry indicates an offset from the current value. If an
 *  entry is non-finite, the frame will be unbounded in that direction,
 *  including all preceding or following values. If unspecified, the frame
 *  will include the current values and all preceding values.
 * @param {boolean} [includePeers=false] Indicates if the sliding window frame
 *  should ignore peer (tied) values. If false (the default), the window frame
 *  boundaries are insensitive to peer values. If `true`, the window frame
 *  expands to include all peers. This parameter only affects operations that
 *  depend on the window frame: aggregate functions and the first_value,
 *  last_value, and nth_value window functions.
 * @return A new wrapped expression annotated with rolling window parameters.
 * @example rolling(d => mean(d.colA), [-3, 3])
 * @example rolling(d => last_value(d.colA), null, true)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(expr, frame, includePeers) {
  return (0,_wrap__WEBPACK_IMPORTED_MODULE_0__["default"])(expr, {
    window: {
      frame: frame || [-Infinity, 0],
      peers: !!includePeers
    }
  });
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/selection.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/selection.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   all: () => (/* binding */ all),
/* harmony export */   "default": () => (/* binding */ resolve),
/* harmony export */   endswith: () => (/* binding */ endswith),
/* harmony export */   matches: () => (/* binding */ matches),
/* harmony export */   not: () => (/* binding */ not),
/* harmony export */   range: () => (/* binding */ range),
/* harmony export */   startswith: () => (/* binding */ startswith)
/* harmony export */ });
/* harmony import */ var _util_assign__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/assign */ "../../node_modules/arquero/src/util/assign.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_escape_regexp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/escape-regexp */ "../../node_modules/arquero/src/util/escape-regexp.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");










function resolve(table, sel, map = new Map()) {
  sel = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_5__["default"])(sel) ? table.columnName(sel) : sel;

  if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_7__["default"])(sel)) {
    map.set(sel, sel);
  } else if ((0,_util_is_array__WEBPACK_IMPORTED_MODULE_3__["default"])(sel)) {
    sel.forEach(r => resolve(table, r, map));
  } else if ((0,_util_is_function__WEBPACK_IMPORTED_MODULE_4__["default"])(sel)) {
    resolve(table, sel(table), map);
  } else if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_6__["default"])(sel)) {
    (0,_util_assign__WEBPACK_IMPORTED_MODULE_0__["default"])(map, sel);
  } else {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])(`Invalid column selection: ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_8__["default"])(sel)}`);
  }

  return map;
}

function decorate(value, toObject) {
  value.toObject = toObject;
  return value;
}

function toObject(value) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_3__["default"])(value) ? value.map(toObject)
    : value && value.toObject ? value.toObject()
    : value;
}

/**
 * Proxy type for SelectHelper function.
 * @typedef {import('../table/transformable').SelectHelper} SelectHelper
 */

/**
 * Select all columns in a table.
 * Returns a function-valued selection compatible with {@link Table#select}.
 * @return {SelectHelper} Selection function compatible with select().
 */
function all() {
  return decorate(
    table => table.columnNames(),
    () => ({ all: [] })
  );
}

/**
 * Negate a column selection, selecting all other columns in a table.
 * Returns a function-valued selection compatible with {@link Table#select}.
 * @param {...any} selection The selection to negate. May be a column name,
 *  column index, array of either, or a selection function (e.g., from range).
 * @return {SelectHelper} Selection function compatible with select().
 */
function not(...selection) {
  selection = selection.flat();
  return decorate(
    table => {
      const drop = resolve(table, selection);
      return table.columnNames(name => !drop.has(name));
    },
    () => ({ not: toObject(selection) })
  );
}

/**
 * Select a contiguous range of columns.
 * @param {string|number} start The name/index of the first selected column.
 * @param {string|number} end The name/index of the last selected column.
 * @return {SelectHelper} Selection function compatible with select().
 */
function range(start, end) {
  return decorate(
    table => {
      let i = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_5__["default"])(start) ? start : table.columnIndex(start);
      let j = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_5__["default"])(end) ? end : table.columnIndex(end);
      if (j < i) { const t = j; j = i; i = t; }
      return table.columnNames().slice(i, j + 1);
    },
    () => ({ range: [start, end] })
  );
}

/**
 * Select all columns whose names match a pattern.
 * @param {string|RegExp} pattern A string or regular expression pattern to match.
 * @return {SelectHelper} Selection function compatible with select().
 */
function matches(pattern) {
  if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_7__["default"])(pattern)) pattern = RegExp((0,_util_escape_regexp__WEBPACK_IMPORTED_MODULE_2__["default"])(pattern));
  return decorate(
    table => table.columnNames(name => pattern.test(name)),
    () => ({ matches: [pattern.source, pattern.flags] })
  );
}

/**
 * Select all columns whose names start with a string.
 * @param {string} string The string to match at the start of the column name.
 * @return {SelectHelper} Selection function compatible with select().
 */
function startswith(string) {
  return matches(RegExp('^' + (0,_util_escape_regexp__WEBPACK_IMPORTED_MODULE_2__["default"])(string)));
}

/**
 * Select all columns whose names end with a string.
 * @param {string} string The string to match at the end of the column name.
 * @return {SelectHelper} Selection function compatible with select().
 */
function endswith(string) {
  return matches(RegExp((0,_util_escape_regexp__WEBPACK_IMPORTED_MODULE_2__["default"])(string) + '$'));
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/slice.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/slice.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Generate a table expression that filters a table based on ordered row
 * indices from start to end (end not included), where start and end
 * represent per-group ordered row numbers in the table. The resulting
 * string can be used as the input to the filter verb.
 * @param {number} [start] Zero-based index at which to start extraction.
 *  A negative index indicates an offset from the end of the group.
 *  If start is undefined, slice starts from the index 0.
 * @param {number} [end] Zero-based index before which to end extraction.
 *  A negative index indicates an offset from the end of the group.
 *  If end is omitted, slice extracts through the end of the group.
 * @return {string} A table expression string for slicing values.
 * @example slice(1, -1)
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(start = 0, end = Infinity) {
  return `${prep(start)} < row_number() && row_number() <= ${prep(end)}`;
}

function prep(index) {
  return index < 0 ? `count() + ${index}` : index;
}

/***/ }),

/***/ "../../node_modules/arquero/src/helpers/wrap.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/helpers/wrap.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");


/**
 * Annotate an expression in an object wrapper.
 * @param {string|Function|object} expr An expression to annotate.
 * @param {object} properties The properties to annotate with.
 * @return {object} A new wrapped expression object.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(expr, properties) {
  return expr && expr.expr
    ? new Wrapper({ ...expr, ...properties })
    : new Wrapper(properties, expr);
}

class Wrapper {
  constructor(properties, expr) {
    this.expr = expr;
    Object.assign(this, properties);
  }
  toString() {
    return String(this.expr);
  }
  toObject() {
    return {
      ...this,
      expr: this.toString(),
      ...((0,_util_is_function__WEBPACK_IMPORTED_MODULE_0__["default"])(this.expr) ? { func: true } : {})
    };
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/index.js":
/*!***********************************************!*\
  !*** ../../node_modules/arquero/src/index.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Type: () => (/* reexport safe */ _arrow_arrow_types__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   addAggregateFunction: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addAggregateFunction),
/* harmony export */   addFunction: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addFunction),
/* harmony export */   addPackage: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addPackage),
/* harmony export */   addTableMethod: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addTableMethod),
/* harmony export */   addVerb: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addVerb),
/* harmony export */   addWindowFunction: () => (/* reexport safe */ _register__WEBPACK_IMPORTED_MODULE_28__.addWindowFunction),
/* harmony export */   agg: () => (/* reexport safe */ _verbs_helpers_agg__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   all: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.all),
/* harmony export */   bin: () => (/* reexport safe */ _helpers_bin__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   desc: () => (/* reexport safe */ _helpers_desc__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   endswith: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.endswith),
/* harmony export */   escape: () => (/* reexport safe */ _helpers_escape__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   field: () => (/* reexport safe */ _helpers_field__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   frac: () => (/* reexport safe */ _helpers_frac__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   from: () => (/* reexport safe */ _table__WEBPACK_IMPORTED_MODULE_29__.from),
/* harmony export */   fromArrow: () => (/* reexport safe */ _format_from_arrow__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   fromCSV: () => (/* reexport safe */ _format_from_csv__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   fromFixed: () => (/* reexport safe */ _format_from_fixed__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   fromJSON: () => (/* reexport safe */ _format_from_json__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   internal: () => (/* binding */ internal),
/* harmony export */   load: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.load),
/* harmony export */   loadArrow: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.loadArrow),
/* harmony export */   loadCSV: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.loadCSV),
/* harmony export */   loadFixed: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.loadFixed),
/* harmony export */   loadJSON: () => (/* reexport safe */ _format_load_url__WEBPACK_IMPORTED_MODULE_16__.loadJSON),
/* harmony export */   matches: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.matches),
/* harmony export */   names: () => (/* reexport safe */ _helpers_names__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   not: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.not),
/* harmony export */   op: () => (/* reexport safe */ _op_op_api__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   query: () => (/* reexport safe */ _query_query__WEBPACK_IMPORTED_MODULE_7__.query),
/* harmony export */   queryFrom: () => (/* reexport safe */ _query_query__WEBPACK_IMPORTED_MODULE_7__.queryFrom),
/* harmony export */   range: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.range),
/* harmony export */   rolling: () => (/* reexport safe */ _helpers_rolling__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   seed: () => (/* reexport safe */ _util_random__WEBPACK_IMPORTED_MODULE_10__.seed),
/* harmony export */   startswith: () => (/* reexport safe */ _helpers_selection__WEBPACK_IMPORTED_MODULE_25__.startswith),
/* harmony export */   table: () => (/* reexport safe */ _table__WEBPACK_IMPORTED_MODULE_29__.table),
/* harmony export */   toArrow: () => (/* reexport safe */ _arrow_encode__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   version: () => (/* reexport safe */ _package_json__WEBPACK_IMPORTED_MODULE_9__.version)
/* harmony export */ });
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./table/table */ "../../node_modules/arquero/src/table/table.js");
/* harmony import */ var _table_column__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./table/column */ "../../node_modules/arquero/src/table/column.js");
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _table_transformable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./table/transformable */ "../../node_modules/arquero/src/table/transformable.js");
/* harmony import */ var _engine_reduce_reducer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./engine/reduce/reducer */ "../../node_modules/arquero/src/engine/reduce/reducer.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./expression/parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _expression_ast_walk__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./expression/ast/walk */ "../../node_modules/arquero/src/expression/ast/walk.js");
/* harmony import */ var _query_query__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./query/query */ "../../node_modules/arquero/src/query/query.js");
/* harmony import */ var _query_verb__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./query/verb */ "../../node_modules/arquero/src/query/verb.js");
/* harmony import */ var _package_json__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../package.json */ "../../node_modules/arquero/package.json");
/* harmony import */ var _util_random__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./util/random */ "../../node_modules/arquero/src/util/random.js");
/* harmony import */ var _arrow_arrow_types__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./arrow/arrow-types */ "../../node_modules/arquero/src/arrow/arrow-types.js");
/* harmony import */ var _format_from_arrow__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./format/from-arrow */ "../../node_modules/arquero/src/format/from-arrow.js");
/* harmony import */ var _format_from_csv__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./format/from-csv */ "../../node_modules/arquero/src/format/from-csv.js");
/* harmony import */ var _format_from_fixed__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./format/from-fixed */ "../../node_modules/arquero/src/format/from-fixed.js");
/* harmony import */ var _format_from_json__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./format/from-json */ "../../node_modules/arquero/src/format/from-json.js");
/* harmony import */ var _format_load_url__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./format/load-url */ "../../node_modules/arquero/src/format/load-url.js");
/* harmony import */ var _arrow_encode__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./arrow/encode */ "../../node_modules/arquero/src/arrow/encode/index.js");
/* harmony import */ var _helpers_bin__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./helpers/bin */ "../../node_modules/arquero/src/helpers/bin.js");
/* harmony import */ var _helpers_escape__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./helpers/escape */ "../../node_modules/arquero/src/helpers/escape.js");
/* harmony import */ var _helpers_desc__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./helpers/desc */ "../../node_modules/arquero/src/helpers/desc.js");
/* harmony import */ var _helpers_field__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./helpers/field */ "../../node_modules/arquero/src/helpers/field.js");
/* harmony import */ var _helpers_frac__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./helpers/frac */ "../../node_modules/arquero/src/helpers/frac.js");
/* harmony import */ var _helpers_names__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./helpers/names */ "../../node_modules/arquero/src/helpers/names.js");
/* harmony import */ var _helpers_rolling__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./helpers/rolling */ "../../node_modules/arquero/src/helpers/rolling.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _verbs_helpers_agg__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./verbs/helpers/agg */ "../../node_modules/arquero/src/verbs/helpers/agg.js");
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./op/op-api */ "../../node_modules/arquero/src/op/op-api.js");
/* harmony import */ var _register__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./register */ "../../node_modules/arquero/src/register.js");
/* harmony import */ var _table__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./table */ "../../node_modules/arquero/src/table/index.js");
// export internal class definitions










const internal = {
  Table: _table_table__WEBPACK_IMPORTED_MODULE_0__["default"],
  ColumnTable: _table_column_table__WEBPACK_IMPORTED_MODULE_2__["default"],
  Transformable: _table_transformable__WEBPACK_IMPORTED_MODULE_3__["default"],
  Query: _query_query__WEBPACK_IMPORTED_MODULE_7__["default"],
  Reducer: _engine_reduce_reducer__WEBPACK_IMPORTED_MODULE_4__["default"],
  Verb: _query_verb__WEBPACK_IMPORTED_MODULE_8__.Verb,
  Verbs: _query_verb__WEBPACK_IMPORTED_MODULE_8__.Verbs,
  columnFactory: _table_column__WEBPACK_IMPORTED_MODULE_1__.columnFactory,
  parse: _expression_parse__WEBPACK_IMPORTED_MODULE_5__["default"],
  walk_ast: _expression_ast_walk__WEBPACK_IMPORTED_MODULE_6__["default"]
};

// export public API























/***/ }),

/***/ "../../node_modules/arquero/src/op/aggregate-functions.js":
/*!****************************************************************!*\
  !*** ../../node_modules/arquero/src/op/aggregate-functions.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_bins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/bins */ "../../node_modules/arquero/src/util/bins.js");
/* harmony import */ var _util_distinct_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/distinct-map */ "../../node_modules/arquero/src/util/distinct-map.js");
/* harmony import */ var _util_is_bigint__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-bigint */ "../../node_modules/arquero/src/util/is-bigint.js");
/* harmony import */ var _util_no_op__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/no-op */ "../../node_modules/arquero/src/util/no-op.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/null */ "../../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_product__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/product */ "../../node_modules/arquero/src/util/product.js");







/**
 * Initialize an aggregate operator.
 */
function initOp(op) {
  op.init = op.init || _util_no_op__WEBPACK_IMPORTED_MODULE_3__["default"];
  op.add = op.add || _util_no_op__WEBPACK_IMPORTED_MODULE_3__["default"];
  op.rem = op.rem || _util_no_op__WEBPACK_IMPORTED_MODULE_3__["default"];
  return op;
}

function initProduct(s, value) {
  s.product_v = false;
  return s.product = value;
}

/**
 * Initialize an aggregate operator.
 * @callback AggregateInit
 * @param {object} state The aggregate state object.
 * @return {void}
 */

/**
 * Add a value to an aggregate operator.
 * @callback AggregateAdd
 * @param {object} state The aggregate state object.
 * @param {*} value The value to add.
 * @return {void}
 */

/**
 * Remove a value from an aggregate operator.
 * @callback AggregateRem
 * @param {object} state The aggregate state object.
 * @param {*} value The value to remove.
 * @return {void}
 */

/**
 * Retrive an output value from an aggregate operator.
 * @callback AggregateValue
 * @param {object} state The aggregate state object.
 * @return {*} The output value.
 */

/**
 * An operator instance for an aggregate function.
 * @typedef {object} AggregateOperator
 * @property {AggregateInit} init Initialize the operator.
 * @property {AggregateAdd} add Add a value to the operator state.
 * @property {AggregateRem} rem Remove a value from the operator state.
 * @property {AggregateValue} value Retrieve an output value.
 */

/**
 * Create a new aggregate operator instance.
 * @callback AggregateCreate
 * @param {...any} params The aggregate operator parameters.
 * @return {AggregateOperator} The instantiated aggregate operator.
 */

/**
 * An operator definition for an aggregate function.
 * @typedef {object} AggregateDef
 * @property {AggregateCreate} create Create a new operator instance.
 * @property {number[]} param Two-element array containing the
 *  counts of input fields and additional parameters.
 * @property {string[]} [req] Names of operators required by this one.
 * @property {string[]} [stream] Names of operators required by this one
 *  for streaming operations (value removes).
 */

/**
 * Aggregate operator definitions.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /** @type {AggregateDef} */
  count: {
    create: () => initOp({
      value: s => s.count
    }),
    param: []
  },

  /** @type {AggregateDef} */
  array_agg: {
    create: () => initOp({
      init: s => s.values = true,
      value: s => s.list.values(s.stream)
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  object_agg: {
    create: () => initOp({
      init:  s => s.values = true,
      value: s => Object.fromEntries(s.list.values())
    }),
    param: [2]
  },

  /** @type {AggregateDef} */
  map_agg: {
    create: () => initOp({
      init:  s => s.values = true,
      value: s => new Map(s.list.values())
    }),
    param: [2]
  },

  /** @type {AggregateDef} */
  entries_agg: {
    create: () => initOp({
      init:  s => s.values = true,
      value: s => s.list.values(s.stream)
    }),
    param: [2]
  },

  /** @type {AggregateDef} */
  any: {
    create: () => initOp({
      add: (s, v) => { if (s.any == null) s.any = v; },
      value: s => s.valid ? s.any : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  valid: {
    create: () => initOp({
      value: s => s.valid
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  invalid: {
    create: () => initOp({
      value: s => s.count - s.valid
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  distinct: {
    create: () => ({
      init: s => s.distinct = (0,_util_distinct_map__WEBPACK_IMPORTED_MODULE_1__["default"])(),
      value: s => s.distinct.count() + (s.valid === s.count ? 0 : 1),
      add: (s, v) => s.distinct.increment(v),
      rem: (s, v) => s.distinct.decrement(v)
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  array_agg_distinct: {
    create: () => initOp({
      value: s => s.distinct.values()
    }),
    param: [1],
    req: ['distinct']
  },

  /** @type {AggregateDef} */
  mode: {
    create: () => initOp({
      value: s => {
        let mode = _util_null__WEBPACK_IMPORTED_MODULE_4__["default"];
        let max = 0;
        s.distinct.forEach((value, count) => {
          if (count > max) {
            max = count;
            mode = value;
          }
        });
        return mode;
      }
    }),
    param: [1],
    req: ['distinct']
  },

  /** @type {AggregateDef} */
  sum: {
    create: () => ({
      init:  s => s.sum = 0,
      value: s => s.valid ? s.sum : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      add: (s, v) => (0,_util_is_bigint__WEBPACK_IMPORTED_MODULE_2__["default"])(v)
        ? (s.sum === 0 ? s.sum = v : s.sum += v)
        : s.sum += +v,
      rem: (s, v) => s.sum -= v
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  product: {
    create: () => ({
      init:  s => initProduct(s, 1),
      value: s => s.valid
        ? (
            s.product_v
              ? initProduct(s, (0,_util_product__WEBPACK_IMPORTED_MODULE_5__["default"])(s.list.values()))
              : s.product
          )
        : undefined,
      add: (s, v) => (0,_util_is_bigint__WEBPACK_IMPORTED_MODULE_2__["default"])(v)
        ? (s.product === 1 ? s.product = v : s.product *= v)
        : s.product *= v,
      rem: (s, v) => (v == 0 || v === Infinity || v === -Infinity)
        ? s.product_v = true
        : s.product /= v
    }),
    param: [1],
    stream: ['array_agg']
  },

  /** @type {AggregateDef} */
  mean: {
    create: () => ({
      init: s => s.mean = 0,
      value: s => s.valid ? s.mean : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      add: (s, v) => {
        s.mean_d = v - s.mean;
        s.mean += s.mean_d / s.valid;
      },
      rem: (s, v) => {
        s.mean_d = v - s.mean;
        s.mean -= s.valid ? s.mean_d / s.valid : s.mean;
      }
    }),
    param: [1]
  },

  /** @type {AggregateDef} */
  average: {
    create: () => initOp({
      value: s => s.valid ? s.mean : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1],
    req: ['mean']
  },

  /** @type {AggregateDef} */
  variance: {
    create: () => ({
      init:  s => s.dev = 0,
      value: s => s.valid > 1 ? s.dev / (s.valid - 1) : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      add: (s, v) => s.dev += s.mean_d * (v - s.mean),
      rem: (s, v) => s.dev -= s.mean_d * (v - s.mean)
    }),
    param: [1],
    req: ['mean']
  },

  /** @type {AggregateDef} */
  variancep: {
    create: () => initOp({
      value: s => s.valid > 1 ? s.dev / s.valid : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1],
    req: ['variance']
  },

  /** @type {AggregateDef} */
  stdev: {
    create: () => initOp({
      value: s => s.valid > 1 ? Math.sqrt(s.dev / (s.valid - 1)) : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1],
    req: ['variance']
  },

  /** @type {AggregateDef} */
  stdevp: {
    create: () => initOp({
      value: s => s.valid > 1 ? Math.sqrt(s.dev / s.valid) : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [1],
    req: ['variance']
  },

  /** @type {AggregateDef} */
  min: {
    create: () => ({
      init:  s => s.min = _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      value: s => s.min = (Number.isNaN(s.min) ? s.list.min() : s.min),
      add: (s, v) => { if (v < s.min || s.min === _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]) s.min = v; },
      rem: (s, v) => { if (v <= s.min) s.min = NaN; }
    }),
    param: [1],
    stream: ['array_agg']
  },

  /** @type {AggregateDef} */
  max: {
    create: () => ({
      init:  s => s.max = _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      value: s => s.max = (Number.isNaN(s.max) ? s.list.max() : s.max),
      add: (s, v) => { if (v > s.max || s.max === _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]) s.max = v; },
      rem: (s, v) => { if (v >= s.max) s.max = NaN; }
    }),
    param: [1],
    stream: ['array_agg']
  },

  /** @type {AggregateDef} */
  quantile: {
    create: (p) => initOp({
      value: s => s.list.quantile(p)
    }),
    param: [1, 1],
    req: ['array_agg']
  },

  /** @type {AggregateDef} */
  median: {
    create: () => initOp({
      value: s => s.list.quantile(0.5)
    }),
    param: [1],
    req: ['array_agg']
  },

  /** @type {AggregateDef} */
  covariance: {
    create: () => ({
      init:  s => {
        s.cov = s.mean_x = s.mean_y = s.dev_x = s.dev_y = 0;
      },
      value: s => s.valid > 1 ? s.cov / (s.valid - 1) : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"],
      add: (s, x, y) => {
        const dx = x - s.mean_x;
        const dy = y - s.mean_y;
        s.mean_x += dx / s.valid;
        s.mean_y += dy / s.valid;
        const dy2 = y - s.mean_y;
        s.dev_x += dx * (x - s.mean_x);
        s.dev_y += dy * dy2;
        s.cov += dx * dy2;
      },
      rem: (s, x, y) => {
        const dx = x - s.mean_x;
        const dy = y - s.mean_y;
        s.mean_x -= s.valid ? dx / s.valid : s.mean_x;
        s.mean_y -= s.valid ? dy / s.valid : s.mean_y;
        const dy2 = y - s.mean_y;
        s.dev_x -= dx * (x - s.mean_x);
        s.dev_y -= dy * dy2;
        s.cov -= dx * dy2;
      }
    }),
    param: [2]
  },

  /** @type {AggregateDef} */
  covariancep: {
    create: () => initOp({
      value: s => s.valid > 1 ? s.cov / s.valid : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [2],
    req: ['covariance']
  },

  /** @type {AggregateDef} */
  corr: {
    create: () => initOp({
      value: s => s.valid > 1
        ? s.cov / (Math.sqrt(s.dev_x) * Math.sqrt(s.dev_y))
        : _util_null__WEBPACK_IMPORTED_MODULE_4__["default"]
    }),
    param: [2],
    req: ['covariance']
  },

  /** @type {AggregateDef} */
  bins: {
    create: (maxbins, nice, minstep, step) => initOp({
      value: s => (0,_util_bins__WEBPACK_IMPORTED_MODULE_0__["default"])(s.min, s.max, maxbins, nice, minstep, step)
    }),
    param: [1, 4],
    req: ['min', 'max']
  }
});

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/array.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/array.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/null */ "../../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_is_array_type__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/is-array-type */ "../../node_modules/arquero/src/util/is-array-type.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_is_valid__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/is-valid */ "../../node_modules/arquero/src/util/is-valid.js");





const isSeq = (seq) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(seq) || (0,_util_is_string__WEBPACK_IMPORTED_MODULE_2__["default"])(seq);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  compact:      (arr) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(arr) ? arr.filter(v => (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_3__["default"])(v)) : arr,
  concat:       (...values) => [].concat(...values),
  includes:     (seq, value, index) => isSeq(seq)
                  ? seq.includes(value, index)
                  : false,
  indexof:      (seq, value) => isSeq(seq) ? seq.indexOf(value) : -1,
  join:         (arr, delim) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(arr) ? arr.join(delim) : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"],
  lastindexof:  (seq, value) => isSeq(seq) ? seq.lastIndexOf(value) : -1,
  length:       (seq) => isSeq(seq) ? seq.length : 0,
  pluck:        (arr, prop) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(arr)
                  ? arr.map(v => (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_3__["default"])(v) ? v[prop] : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"])
                  : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"],
  reverse:      (seq) => (0,_util_is_array_type__WEBPACK_IMPORTED_MODULE_1__["default"])(seq) ? seq.slice().reverse()
                  : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_2__["default"])(seq) ? seq.split('').reverse().join('')
                  : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"],
  slice:        (seq, start, end) => isSeq(seq) ? seq.slice(start, end) : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"]
});


/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/bin.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/bin.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Truncate a value to a bin boundary.
 * Useful for creating equal-width histograms.
 * Values outside the [min, max] range will be mapped to
 * -Infinity (< min) or +Infinity (> max).
 * @param {number} value - The value to bin.
 * @param {number} min - The minimum bin boundary.
 * @param {number} max - The maximum bin boundary.
 * @param {number} step - The step size between bin boundaries.
 * @param {number} [offset=0] - Offset in steps by which to adjust
 *  the bin value. An offset of 1 will return the next boundary.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, min, max, step, offset) {
  return value == null ? null
    : value < min ? -Infinity
    : value > max ? +Infinity
    : (
        value = Math.max(min, Math.min(value, max)),
        min + step * Math.floor(1e-14 + (value - min) / step + (offset || 0))
      );
}

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/date.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/date.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_format_date__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/format-date */ "../../node_modules/arquero/src/util/format-date.js");
/* harmony import */ var _util_parse_iso_date__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/parse-iso-date */ "../../node_modules/arquero/src/util/parse-iso-date.js");



const msMinute = 6e4;
const msDay = 864e5;
const msWeek = 6048e5;

const t0 = new Date();
const t1 = new Date();
const t = d => (
  t0.setTime(typeof d === 'string' ? (0,_util_parse_iso_date__WEBPACK_IMPORTED_MODULE_1__["default"])(d) : d),
  t0
);

/**
 * Function to create a new Date value.
 * If no arguments are provided, the current time is used.
 * @param {number} [year] The year.
 * @param {number} [month=0] The (zero-based) month.
 * @param {number} [date=1] The date within the month.
 * @param {number} [hours=0] The hour within the day.
 * @param {number} [minutes=0] The minute within the hour.
 * @param {number} [seconds=0] The second within the minute.
 * @param {number} [milliseconds=0] The milliseconds within the second.
 * @return {date} The resuting Date value.
 */
function datetime(year, month, date, hours, minutes, seconds, milliseconds) {
  return !arguments.length
    ? new Date(Date.now())
    : new Date(
        year,
        month || 0,
        date == null ? 1 : date,
        hours || 0,
        minutes || 0,
        seconds || 0,
        milliseconds || 0
      );
}

/**
 * Function to create a new Date value according to UTC time.
 * If no arguments are provided, the current time is used.
 * @param {number} [year] The year.
 * @param {number} [month=0] The (zero-based) month.
 * @param {number} [date=1] The date within the month.
 * @param {number} [hours=0] The hour within the day.
 * @param {number} [minutes=0] The minute within the hour.
 * @param {number} [seconds=0] The second within the minute.
 * @param {number} [milliseconds=0] The milliseconds within the second.
 * @return {date} The resuting Date value.
 */
function utcdatetime(year, month, date, hours, minutes, seconds, milliseconds) {
  return !arguments.length
    ? new Date(Date.now())
    : new Date(Date.UTC(
        year,
        month || 0,
        date == null ? 1 : date,
        hours || 0,
        minutes || 0,
        seconds || 0,
        milliseconds || 0
      ));
}

function dayofyear(date) {
  t1.setTime(+date);
  t1.setHours(0, 0, 0, 0);
  t0.setTime(+t1);
  t0.setMonth(0);
  t0.setDate(1);
  const tz = (t1.getTimezoneOffset() - t0.getTimezoneOffset()) * msMinute;
  return Math.floor(1 + ((t1 - t0) - tz) / msDay);
}

function utcdayofyear(date) {
  t1.setTime(+date);
  t1.setUTCHours(0, 0, 0, 0);
  const t0 = Date.UTC(t1.getUTCFullYear(), 0, 1);
  return Math.floor(1 + (t1 - t0) / msDay);
}

function week(date, firstday) {
  const i = firstday || 0;
  t1.setTime(+date);
  t1.setDate(t1.getDate() - (t1.getDay() + 7 - i) % 7);
  t1.setHours(0, 0, 0, 0);
  t0.setTime(+date);
  t0.setMonth(0);
  t0.setDate(1);
  t0.setDate(1 - (t0.getDay() + 7 - i) % 7);
  t0.setHours(0, 0, 0, 0);
  const tz = (t1.getTimezoneOffset() - t0.getTimezoneOffset()) * msMinute;
  return Math.floor((1 + (t1 - t0) - tz) / msWeek);
}

function utcweek(date, firstday) {
  const i = firstday || 0;
  t1.setTime(+date);
  t1.setUTCDate(t1.getUTCDate() - (t1.getUTCDay() + 7 - i) % 7);
  t1.setUTCHours(0, 0, 0, 0);
  t0.setTime(+date);
  t0.setUTCMonth(0);
  t0.setUTCDate(1);
  t0.setUTCDate(1 - (t0.getUTCDay() + 7 - i) % 7);
  t0.setUTCHours(0, 0, 0, 0);
  return Math.floor((1 + (t1 - t0)) / msWeek);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  format_date:     (date, shorten) => (0,_util_format_date__WEBPACK_IMPORTED_MODULE_0__.formatDate)(t(date), !shorten),
  format_utcdate:  (date, shorten) => (0,_util_format_date__WEBPACK_IMPORTED_MODULE_0__.formatUTCDate)(t(date), !shorten),
  timestamp:       (date) => +t(date),
  year:            (date) => t(date).getFullYear(),
  quarter:         (date) => Math.floor(t(date).getMonth() / 3),
  month:           (date) => t(date).getMonth(),
  date:            (date) => t(date).getDate(),
  dayofweek:       (date) => t(date).getDay(),
  hours:           (date) => t(date).getHours(),
  minutes:         (date) => t(date).getMinutes(),
  seconds:         (date) => t(date).getSeconds(),
  milliseconds:    (date) => t(date).getMilliseconds(),
  utcyear:         (date) => t(date).getUTCFullYear(),
  utcquarter:      (date) => Math.floor(t(date).getUTCMonth() / 3),
  utcmonth:        (date) => t(date).getUTCMonth(),
  utcdate:         (date) => t(date).getUTCDate(),
  utcdayofweek:    (date) => t(date).getUTCDay(),
  utchours:        (date) => t(date).getUTCHours(),
  utcminutes:      (date) => t(date).getUTCMinutes(),
  utcseconds:      (date) => t(date).getUTCSeconds(),
  utcmilliseconds: (date) => t(date).getUTCMilliseconds(),
  datetime,
  dayofyear,
  week,
  utcdatetime,
  utcdayofyear,
  utcweek,
  now: Date.now
});

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/equal.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/equal.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ equal)
/* harmony export */ });
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/is-date */ "../../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _util_is_regexp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/is-regexp */ "../../node_modules/arquero/src/util/is-regexp.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");




/**
 * Compare two values for equality, using join semantics in which null
 * !== null. If the inputs are object-valued, a deep equality check
 * of array entries or object key-value pairs is performed.
 * @param {*} a The first input.
 * @param {*} b The second input.
 * @return {boolean} True if equal, false if not.
 */
function equal(a, b) {
  return (a == null || b == null || a !== a || b !== b) ? false
    : a === b ? true
    : ((0,_util_is_date__WEBPACK_IMPORTED_MODULE_0__["default"])(a) || (0,_util_is_date__WEBPACK_IMPORTED_MODULE_0__["default"])(b)) ? +a === +b
    : ((0,_util_is_regexp__WEBPACK_IMPORTED_MODULE_1__["default"])(a) && (0,_util_is_regexp__WEBPACK_IMPORTED_MODULE_1__["default"])(b)) ? a + '' === b + ''
    : ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_2__["default"])(a) && (0,_util_is_object__WEBPACK_IMPORTED_MODULE_2__["default"])(b)) ? deepEqual(a, b)
    : false;
}

function deepEqual(a, b) {
  if (Object.getPrototypeOf(a) !== Object.getPrototypeOf(b)) {
    return false;
  }

  if (a.length || b.length) {
    return arrayEqual(a, b);
  }

  const keysA = Object.keys(a);
  const keysB = Object.keys(b);
  if (keysA.length !== keysB.length) {
    return false;
  }
  keysA.sort();
  keysB.sort();

  if (!arrayEqual(keysA, keysB, (a, b) => a === b)) {
    return false;
  }

  const n = keysA.length;
  for (let i = 0; i < n; ++i) {
    const k = keysA[i];
    if (!equal(a[k], b[k])) {
      return false;
    }
  }

  return true;
}

function arrayEqual(a, b, test = equal) {
  const n = a.length;
  if (n !== b.length) return false;

  for (let i = 0; i < n; ++i) {
    if (!test(a[i], b[i])) {
      return false;
    }
  }

  return true;
}

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/index.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./array */ "../../node_modules/arquero/src/op/functions/array.js");
/* harmony import */ var _bin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bin */ "../../node_modules/arquero/src/op/functions/bin.js");
/* harmony import */ var _date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./date */ "../../node_modules/arquero/src/op/functions/date.js");
/* harmony import */ var _equal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./equal */ "../../node_modules/arquero/src/op/functions/equal.js");
/* harmony import */ var _json__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./json */ "../../node_modules/arquero/src/op/functions/json.js");
/* harmony import */ var _math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./math */ "../../node_modules/arquero/src/op/functions/math.js");
/* harmony import */ var _object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./object */ "../../node_modules/arquero/src/op/functions/object.js");
/* harmony import */ var _recode__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./recode */ "../../node_modules/arquero/src/op/functions/recode.js");
/* harmony import */ var _sequence__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./sequence */ "../../node_modules/arquero/src/op/functions/sequence.js");
/* harmony import */ var _string__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./string */ "../../node_modules/arquero/src/op/functions/string.js");











/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  bin: _bin__WEBPACK_IMPORTED_MODULE_1__["default"],
  equal: _equal__WEBPACK_IMPORTED_MODULE_3__["default"],
  recode: _recode__WEBPACK_IMPORTED_MODULE_7__["default"],
  sequence: _sequence__WEBPACK_IMPORTED_MODULE_8__["default"],
  ..._array__WEBPACK_IMPORTED_MODULE_0__["default"],
  ..._date__WEBPACK_IMPORTED_MODULE_2__["default"],
  ..._json__WEBPACK_IMPORTED_MODULE_4__["default"],
  ..._math__WEBPACK_IMPORTED_MODULE_5__["default"],
  ..._object__WEBPACK_IMPORTED_MODULE_6__["default"],
  ..._string__WEBPACK_IMPORTED_MODULE_9__["default"]
});

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/json.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/json.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  parse_json: (str) => JSON.parse(str),
  to_json:    (val) => JSON.stringify(val)
});

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/math.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/math.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_random__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/random */ "../../node_modules/arquero/src/util/random.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  random: _util_random__WEBPACK_IMPORTED_MODULE_0__.random,
  is_nan:    Number.isNaN,
  is_finite: Number.isFinite,

  abs:      Math.abs,
  cbrt:     Math.cbrt,
  ceil:     Math.ceil,
  clz32:    Math.clz32,
  exp:      Math.exp,
  expm1:    Math.expm1,
  floor:    Math.floor,
  fround:   Math.fround,
  greatest: Math.max,
  least:    Math.min,
  log:      Math.log,
  log10:    Math.log10,
  log1p:    Math.log1p,
  log2:     Math.log2,
  pow:      Math.pow,
  round:    Math.round,
  sign:     Math.sign,
  sqrt:     Math.sqrt,
  trunc:    Math.trunc,

  degrees:  (rad) => 180 * rad / Math.PI,
  radians:  (deg) => Math.PI * deg / 180,
  acos:     Math.acos,
  acosh:    Math.acosh,
  asin:     Math.asin,
  asinh:    Math.asinh,
  atan:     Math.atan,
  atan2:    Math.atan2,
  atanh:    Math.atanh,
  cos:      Math.cos,
  cosh:     Math.cosh,
  sin:      Math.sin,
  sinh:     Math.sinh,
  tan:      Math.tan,
  tanh:     Math.tanh
});

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/object.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/object.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/null */ "../../node_modules/arquero/src/util/null.js");
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/has */ "../../node_modules/arquero/src/util/has.js");
/* harmony import */ var _util_is_map__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/is-map */ "../../node_modules/arquero/src/util/is-map.js");
/* harmony import */ var _util_is_map_or_set__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/is-map-or-set */ "../../node_modules/arquero/src/util/is-map-or-set.js");





function array(iter) {
  return Array.from(iter);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  has:      (obj, key) => (0,_util_is_map_or_set__WEBPACK_IMPORTED_MODULE_3__["default"])(obj) ? obj.has(key)
              : obj != null ? (0,_util_has__WEBPACK_IMPORTED_MODULE_1__["default"])(obj, key)
              : false,
  keys:     (obj) => (0,_util_is_map__WEBPACK_IMPORTED_MODULE_2__["default"])(obj) ? array(obj.keys())
              : obj != null ? Object.keys(obj)
              : [],
  values:   (obj) => (0,_util_is_map_or_set__WEBPACK_IMPORTED_MODULE_3__["default"])(obj) ? array(obj.values())
              : obj != null ? Object.values(obj)
              : [],
  entries:  (obj) => (0,_util_is_map_or_set__WEBPACK_IMPORTED_MODULE_3__["default"])(obj) ? array(obj.entries())
              : obj != null ? Object.entries(obj)
              : [],
  object:   (entries) => entries ? Object.fromEntries(entries) : _util_null__WEBPACK_IMPORTED_MODULE_0__["default"]
});

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/recode.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/recode.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../util/has */ "../../node_modules/arquero/src/util/has.js");


/**
 * Recodes an input value to an alternative value, based on a provided
 * value map. If a fallback value is specified, it will be returned when
 * a matching value is not found in the map; otherwise, the input value
 * is returned unchanged.
 * @param {*} value The value to recode. The value must be safely
 *  coercible to a string for lookup against the value map.
 * @param {object|Map} map An object or Map with input values for keys and
 *  output recoded values as values. If a non-Map object, only the object's
 *  own properties will be considered.
 * @param {*} [fallback] A default fallback value to use if the input
 *  value is not found in the value map.
 * @return {*} The recoded value.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, map, fallback) {
  if (map instanceof Map) {
    if (map.has(value)) return map.get(value);
  } else if ((0,_util_has__WEBPACK_IMPORTED_MODULE_0__["default"])(map, value)) {
    return map[value];
  }
  return fallback !== undefined ? fallback : value;
}

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/sequence.js":
/*!***************************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/sequence.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Returns an array containing an arithmetic sequence from the start value
 * to the stop value, in step increments. If step is positive, the last
 * element is the largest start + i * step less than stop; if step is
 * negative, the last element is the smallest start + i * step greater
 * than stop. If the returned array would contain an infinite number of
 * values, an empty range is returned.
 * @param {number} [start=0] The starting value of the sequence.
 * @param {number} [stop] The stopping value of the sequence.
 *  The stop value is exclusive; it is not included in the result.
 * @param {number} [step=1] The step increment between sequence values.
 * @return {number[]} The generated sequence.
 */
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(start, stop, step) {
  let n = arguments.length;
  start = +start;
  stop = +stop;
  step = n < 2
    ? (stop = start, start = 0, 1)
    : n < 3 ? 1 : +step;

  n = Math.max(0, Math.ceil((stop - start) / step)) | 0;
  const seq = new Array(n);

  for (let i = 0; i < n; ++i) {
    seq[i] = start + i * step;
  }

  return seq;
}

/***/ }),

/***/ "../../node_modules/arquero/src/op/functions/string.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/op/functions/string.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  parse_date:   (str) => str == null ? str : new Date(str),
  parse_float:  (str) => str == null ? str : Number.parseFloat(str),
  parse_int:    (str, radix) => str == null ? str : Number.parseInt(str, radix),
  endswith:     (str, search, length) => str == null ? false
                  : String(str).endsWith(search, length),
  match:        (str, regexp, index) => {
                  const m = str == null ? str : String(str).match(regexp);
                  return index == null || m == null ? m
                    : typeof index === 'number' ? m[index]
                    : m.groups ? m.groups[index]
                    : null;
                },
  normalize:    (str, form) => str == null ? str
                  : String(str).normalize(form),
  padend:       (str, len, fill) => str == null ? str
                  : String(str).padEnd(len, fill),
  padstart:     (str, len, fill) => str == null ? str
                  : String(str).padStart(len, fill),
  upper:        (str) => str == null ? str
                  : String(str).toUpperCase(),
  lower:        (str) => str == null ? str
                  : String(str).toLowerCase(),
  repeat:       (str, num) => str == null ? str
                  : String(str).repeat(num),
  replace:      (str, pattern, replacement) => str == null ? str
                  : String(str).replace(pattern, String(replacement)),
  substring:    (str, start, end) => str == null ? str
                  : String(str).substring(start, end),
  split:        (str, separator, limit) => str == null ? []
                  : String(str).split(separator, limit),
  startswith:   (str, search, length) => str == null ? false
                  : String(str).startsWith(search, length),
  trim:         (str) => str == null ? str
                  : String(str).trim()
});

/***/ }),

/***/ "../../node_modules/arquero/src/op/index.js":
/*!**************************************************!*\
  !*** ../../node_modules/arquero/src/op/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   aggregateFunctions: () => (/* reexport safe */ _aggregate_functions__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   functions: () => (/* reexport safe */ _functions__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   getAggregate: () => (/* binding */ getAggregate),
/* harmony export */   getFunction: () => (/* binding */ getFunction),
/* harmony export */   getWindow: () => (/* binding */ getWindow),
/* harmony export */   hasAggregate: () => (/* binding */ hasAggregate),
/* harmony export */   hasFunction: () => (/* binding */ hasFunction),
/* harmony export */   hasWindow: () => (/* binding */ hasWindow),
/* harmony export */   windowFunctions: () => (/* reexport safe */ _window_functions__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _aggregate_functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./aggregate-functions */ "../../node_modules/arquero/src/op/aggregate-functions.js");
/* harmony import */ var _window_functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./window-functions */ "../../node_modules/arquero/src/op/window-functions.js");
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./functions */ "../../node_modules/arquero/src/op/functions/index.js");
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/has */ "../../node_modules/arquero/src/util/has.js");







/**
 * Check if an aggregate function with the given name exists.
 * @param {string} name The name of the aggregate function.
 * @return {boolean} True if found, false otherwise.
 */
function hasAggregate(name) {
  return (0,_util_has__WEBPACK_IMPORTED_MODULE_3__["default"])(_aggregate_functions__WEBPACK_IMPORTED_MODULE_0__["default"], name);
}

/**
 * Check if a window function with the given name exists.
 * @param {string} name The name of the window function.
 * @return {boolean} True if found, false otherwise.
 */
function hasWindow(name) {
  return (0,_util_has__WEBPACK_IMPORTED_MODULE_3__["default"])(_window_functions__WEBPACK_IMPORTED_MODULE_1__["default"], name);
}

/**
 * Check if an expression function with the given name exists.
 * @param {string} name The name of the function.
 * @return {boolean} True if found, false otherwise.
 */
 function hasFunction(name) {
  return (0,_util_has__WEBPACK_IMPORTED_MODULE_3__["default"])(_functions__WEBPACK_IMPORTED_MODULE_2__["default"], name) || name === 'row_object';
}

/**
 * Get an aggregate function definition.
 * @param {string} name The name of the aggregate function.
 * @return {AggregateDef} The aggregate function definition,
 *  or undefined if not found.
 */
function getAggregate(name) {
  return hasAggregate(name) && _aggregate_functions__WEBPACK_IMPORTED_MODULE_0__["default"][name];
}

/**
 * Get a window function definition.
 * @param {string} name The name of the window function.
 * @return {WindowDef} The window function definition,
 *  or undefined if not found.
 */
function getWindow(name) {
  return hasWindow(name) && _window_functions__WEBPACK_IMPORTED_MODULE_1__["default"][name];
}

/**
 * Get an expression function definition.
 * @param {string} name The name of the function.
 * @return {Function} The function instance, or undefined if not found.
 */
function getFunction(name) {
  return hasFunction(name) && _functions__WEBPACK_IMPORTED_MODULE_2__["default"][name];
}

/***/ }),

/***/ "../../node_modules/arquero/src/op/op-api.js":
/*!***************************************************!*\
  !*** ../../node_modules/arquero/src/op/op-api.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   any: () => (/* binding */ any),
/* harmony export */   array_agg: () => (/* binding */ array_agg),
/* harmony export */   array_agg_distinct: () => (/* binding */ array_agg_distinct),
/* harmony export */   count: () => (/* binding */ count),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   entries_agg: () => (/* binding */ entries_agg),
/* harmony export */   map_agg: () => (/* binding */ map_agg),
/* harmony export */   object_agg: () => (/* binding */ object_agg)
/* harmony export */ });
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./functions */ "../../node_modules/arquero/src/op/functions/index.js");
/* harmony import */ var _op__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./op */ "../../node_modules/arquero/src/op/op.js");



const any = (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('any', field);
const count = () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('count');
const array_agg = (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('array_agg', field);
const array_agg_distinct = (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('array_agg_distinct', field);
const map_agg = (key, value) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('map_agg', [key, value]);
const object_agg = (key, value) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('object_agg', [key, value]);
const entries_agg = (key, value) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('entries_agg', [key, value]);

/**
 * @typedef {import('../table/transformable').Struct} Struct
 */

/**
 * All table expression operations including normal functions,
 * aggregate functions, and window functions.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  ..._functions__WEBPACK_IMPORTED_MODULE_0__["default"],

  /**
   * Generate an object representing the current table row.
   * @param {...string} names The column names to include in the object.
   *  If unspecified, all columns are included.
   * @return {Struct} The generated row object.
   */
  row_object: (...names) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('row_object', null, names.flat()),

  /**
   * Aggregate function to count the number of records (rows).
   * @returns {number} The count of records.
   */
  count,

  /**
   * Aggregate function returning an arbitrary observed value.
   * @param {*} field The data field.
   * @return {*} An arbitrary observed value.
   */
  any,

  /**
   * Aggregate function to collect an array of values.
   * @param {*} field The data field.
   * @return {Array} A list of values.
   */
  array_agg,

  /**
   * Aggregate function to collect an array of distinct (unique) values.
   * @param {*} field The data field.
   * @return {Array} An array of unique values.
   */
  array_agg_distinct,

  /**
   * Aggregate function to create an object given input key and value fields.
   * @param {*} key The object key field.
   * @param {*} value The object value field.
   * @return {Struct} An object of key-value pairs.
   */
  object_agg,

  /**
   * Aggregate function to create a Map given input key and value fields.
   * @param {*} key The object key field.
   * @param {*} value The object value field.
   * @return {Map} A Map of key-value pairs.
   */
  map_agg,

  /**
   * Aggregate function to create an array in the style of Object.entries()
   * given input key and value fields.
   * @param {*} key The object key field.
   * @param {*} value The object value field.
   * @return {[[any, any]]} An array of [key, value] arrays.
   */
  entries_agg,

  /**
   * Aggregate function to count the number of valid values.
   * Invalid values are null, undefined, or NaN.
   * @param {*} field The data field.
   * @return {number} The count of valid values.
   */
  valid: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('valid', field),

  /**
   * Aggregate function to count the number of invalid values.
   * Invalid values are null, undefined, or NaN.
   * @param {*} field The data field.
   * @return {number} The count of invalid values.
   */
  invalid: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('invalid', field),

  /**
   * Aggregate function to count the number of distinct values.
   * @param {*} field The data field.
   * @return {number} The count of distinct values.
   */
  distinct: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('distinct', field),

  /**
   * Aggregate function to determine the mode (most frequent) value.
   * @param {*} field The data field.
   * @return {number} The mode value.
   */
  mode: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('mode', field),

  /**
   * Aggregate function to sum values.
   * @param {string} field The data field.
   * @return {number} The sum of the values.
   */
  sum: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('sum', field),

  /**
   * Aggregate function to multiply values.
   * @param {*} field The data field.
   * @return {number} The product of the values.
   */
  product: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('product', field),

  /**
   * Aggregate function for the mean (average) value.
   * @param {*} field The data field.
   * @return {number} The mean (average) of the values.
   */
  mean: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('mean', field),

  /**
   * Aggregate function for the average (mean) value.
   * @param {*} field The data field.
   * @return {number} The average (mean) of the values.
   */
  average: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('average', field),

  /**
   * Aggregate function for the sample variance.
   * @param {*} field The data field.
   * @return {number} The sample variance of the values.
   */
  variance: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('variance', field),

  /**
   * Aggregate function for the population variance.
   * @param {*} field The data field.
   * @return {number} The population variance of the values.
   */
  variancep: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('variancep', field),

  /**
   * Aggregate function for the sample standard deviation.
   * @param {*} field The data field.
   * @return {number} The sample standard deviation of the values.
   */
  stdev: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('stdev', field),

  /**
   * Aggregate function for the population standard deviation.
   * @param {*} field The data field.
   * @return {number} The population standard deviation of the values.
   */
  stdevp: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('stdevp', field),

  /**
   * Aggregate function for the minimum value.
   * @param {*} field The data field.
   * @return {number} The minimum value.
   */
  min: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('min', field),

  /**
   * Aggregate function for the maximum value.
   * @param {*} field The data field.
   * @return {number} The maximum value.
   */
  max: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('max', field),

  /**
   * Aggregate function to compute the quantile boundary
   * of a data field for a probability threshold.
   * @param {*} field The data field.
   * @param {number} p The probability threshold.
   * @return {number} The quantile value.
   */
  quantile: (field, p) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('quantile', field, p),

  /**
   * Aggregate function for the median value.
   * This is a shorthand for the 0.5 quantile value.
   * @param {*} field The data field.
   * @return {number} The median value.
   */
  median: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('median', field),

  /**
   * Aggregate function for the sample covariance between two variables.
   * @param {*} field1 The first data field.
   * @param {*} field2 The second data field.
   * @return {number} The sample covariance of the values.
   */
  covariance: (field1, field2) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('covariance', [field1, field2]),

  /**
   * Aggregate function for the population covariance between two variables.
   * @param {*} field1 The first data field.
   * @param {*} field2 The second data field.
   * @return {number} The population covariance of the values.
   */
  covariancep: (field1, field2) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('covariancep', [field1, field2]),

  /**
   * Aggregate function for the product-moment correlation between two variables.
   * To instead compute a rank correlation, compute the average ranks for each
   * variable and then apply this function to the result.
   * @param {*} field1 The first data field.
   * @param {*} field2 The second data field.
   * @return {number} The correlation between the field values.
   */
  corr: (field1, field2) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('corr', [field1, field2]),

  /**
   * Aggregate function for calculating a binning scheme in terms of
   * the minimum bin boundary, maximum bin boundary, and step size.
   * @param {*} field The data field.
   * @param {number} [maxbins=15] The maximum number of allowed bins.
   * @param {boolean} [nice=true] Flag indicating if the bin min and max
   *  should snap to "nice" human-friendly values.
   * @param {number} [minstep] The minimum allowed step size between bins.
   * @param {number} [step] The exact step size to use between bins.
   *  If specified, the maxbins and minstep arguments are ignored.
   * @return {[number, number, number]} The bin [min, max, and step] values.
   */
  bins: (field, maxbins, nice, minstep) =>
    (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('bins', field, [maxbins, nice, minstep]),

  /**
   * Window function to assign consecutive row numbers, starting from 1.
   * @return {number} The row number value.
   */
  row_number: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('row_number'),

  /**
   * Window function to assign a rank to each value in a group, starting
   * from 1. Peer values are assigned the same rank. Subsequent ranks
   * reflect the number of prior values: if the first two values tie for
   * rank 1, the third value is assigned rank 3.
   * @return {number} The rank value.
   */
  rank: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('rank'),

  /**
   * Window function to assign a fractional (average) rank to each value in
   * a group, starting from 1. Peer values are assigned the average of their
   * indices: if the first two values tie, both will be assigned rank 1.5.
   * @return {number} The peer-averaged rank value.
   */
  avg_rank: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('avg_rank'),

  /**
   * Window function to assign a dense rank to each value in a group,
   * starting from 1. Peer values are assigned the same rank. Subsequent
   * ranks do not reflect the number of prior values: if the first two
   * values tie for rank 1, the third value is assigned rank 2.
   * @return {number} The dense rank value.
   */
  dense_rank: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('dense_rank'),

  /**
   * Window function to assign a percentage rank to each value in a group.
   * The percent is calculated as (rank - 1) / (group_size - 1).
   * @return {number} The percentage rank value.
   */
  percent_rank: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('percent_rank'),

  /**
   * Window function to assign a cumulative distribution value between 0 and 1
   * to each value in a group.
   * @return {number} The cumulative distribution value.
   */
  cume_dist: () => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('cume_dist'),

  /**
   * Window function to assign a quantile (e.g., percentile) value to each
   * value in a group. Accepts an integer parameter indicating the number of
   * buckets to use (e.g., 100 for percentiles, 5 for quintiles).
   * @param {number} num The number of buckets for ntile calculation.
   * @return {number} The quantile value.
   */
  ntile: (num) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('ntile', null, num),

  /**
   * Window function to assign a value that precedes the current value by
   * a specified number of positions. If no such value exists, returns a
   * default value instead.
   * @param {*} field The data field.
   * @param {number} [offset=1] The lag offset from the current value.
   * @param {*} [defaultValue=undefined] The default value.
   * @return {*} The lagging value.
   */
  lag: (field, offset, defaultValue) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('lag', field, [offset, defaultValue]),

  /**
   * Window function to assign a value that follows the current value by
   * a specified number of positions. If no such value exists, returns a
   * default value instead.
   * @param {*} field The data field.
   * @param {number} [offset=1] The lead offset from the current value.
   * @param {*} [defaultValue=undefined] The default value.
   * @return {*} The leading value.
   */
  lead: (field, offset, defaultValue) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('lead', field, [offset, defaultValue]),

  /**
   * Window function to assign the first value in a sliding window frame.
   * @param {*} field The data field.
   * @return {*} The first value in the current frame.
   */
  first_value: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('first_value', field),

  /**
   * Window function to assign the last value in a sliding window frame.
   * @param {*} field The data field.
   * @return {*} The last value in the current frame.
   */
  last_value: (field) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('last_value', field),

  /**
   * Window function to assign the nth value in a sliding window frame
   * (counting from 1), or undefined if no such value exists.
   * @param {*} field The data field.
   * @param {number} nth The nth position, starting from 1.
   * @return {*} The nth value in the current frame.
   */
  nth_value: (field, nth) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('nth_value', field, nth),

  /**
   * Window function to fill in missing values with preceding values.
   * @param {*} field The data field.
   * @param {*} [defaultValue=undefined] The default value.
   * @return {*} The current value if valid, otherwise the first preceding
   *  valid value. If no such value exists, returns the default value.
   */
  fill_down: (field, defaultValue) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('fill_down', field, defaultValue),

  /**
   * Window function to fill in missing values with subsequent values.
   * @param {*} field The data field.
   * @param {*} [defaultValue=undefined] The default value.
   * @return {*} The current value if valid, otherwise the first subsequent
   *  valid value. If no such value exists, returns the default value.
   */
  fill_up: (field, defaultValue) => (0,_op__WEBPACK_IMPORTED_MODULE_1__["default"])('fill_up', field, defaultValue)
});

/***/ }),

/***/ "../../node_modules/arquero/src/op/op.js":
/*!***********************************************!*\
  !*** ../../node_modules/arquero/src/op/op.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Op: () => (/* binding */ Op),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(name, fields = [], params = []) {
  return new Op(name, (0,_util_to_array__WEBPACK_IMPORTED_MODULE_0__["default"])(fields), (0,_util_to_array__WEBPACK_IMPORTED_MODULE_0__["default"])(params));
}

class Op {
  constructor(name, fields, params) {
    this.name = name;
    this.fields = fields;
    this.params = params;
  }
  toString() {
    const args = [
      ...this.fields.map(f => `d[${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_1__["default"])(f)}]`),
      ...this.params.map(_util_to_string__WEBPACK_IMPORTED_MODULE_1__["default"])
    ];
    return `d => op.${this.name}(${args})`;
  }
  toObject() {
    return { expr: this.toString(), func: true };
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/op/window-functions.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/op/window-functions.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_valid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-valid */ "../../node_modules/arquero/src/util/is-valid.js");
/* harmony import */ var _util_no_op__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/no-op */ "../../node_modules/arquero/src/util/no-op.js");
/* harmony import */ var _util_null__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/null */ "../../node_modules/arquero/src/util/null.js");





/**
 * Initialize a window operator.
 * @callback WindowInit
 * @return {void}
 */

/**
 * Retrieve an output value from a window operator.
 * @callback WindowValue
 * @param {WindowState} state The window state object.
 * @return {*} The output value.
 */

/**
 * An operator instance for a window function.
 * @typedef {object} WindowOperator
 * @property {AggregateInit} init Initialize the operator.
 * @property {AggregateValue} value Retrieve an output value.
 */

/**
 * Create a new window operator instance.
 * @callback WindowCreate
 * @param {...any} params The aggregate operator parameters.
 * @return {WindowOperator} The instantiated window operator.
 */

/**
 * An operator definition for a window function.
 * @typedef {object} WindowDef
 * @property {AggregateCreate} create Create a new operator instance.
 * @property {number[]} param Two-element array containing the
 *  counts of input fields and additional parameters.
 */

const rank = {
  create() {
    let rank;
    return {
      init: () => rank = 1,
      value: w => {
        const i = w.index;
        return (i && !w.peer(i)) ? (rank = i + 1) : rank;
      }
    };
  },
  param: []
};

const cume_dist = {
  create() {
    let cume;
    return {
      init: () => cume = 0,
      value: w => {
        const { index, peer, size } = w;
        let i = index;
        if (cume < i) {
          while (i + 1 < size && peer(i + 1)) ++i;
          cume = i;
        }
        return (1 + cume) / size;
      }
    };
  },
  param: []
};

/**
 * Window operator definitions.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  /** @type {WindowDef} */
  row_number: {
    create() {
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: w => w.index + 1
      };
    },
    param: []
  },

  /** @type {WindowDef} */
  rank,

  /** @type {WindowDef} */
  avg_rank: {
    create() {
      let j, rank;
      return {
        init: () => (j = -1, rank = 1),
        value: w => {
          const i = w.index;
          if (i >= j) {
            for (rank = j = i + 1; w.peer(j); rank += ++j);
            rank /= (j - i);
          }
          return rank;
        }
      };
    },
    param: []
  },

  /** @type {WindowDef} */
  dense_rank: {
    create() {
      let drank;
      return {
        init: () => drank = 1,
        value: w => {
          const i = w.index;
          return (i && !w.peer(i)) ? ++drank : drank;
        }
      };
    },
    param: []
  },

  /** @type {WindowDef} */
  percent_rank: {
    create() {
      const { init, value } = rank.create();
      return {
        init,
        value: w => (value(w) - 1) / (w.size - 1)
      };
    },
    param: []
  },

  /** @type {WindowDef} */
  cume_dist,

  /** @type {WindowDef} */
  ntile: {
    create(num) {
      num = +num;
      if (!(num > 0)) (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('ntile num must be greater than zero.');
      const { init, value } = cume_dist.create();
      return {
        init,
        value: w => Math.ceil(num * value(w))
      };
    },
    param: [0, 1]
  },

  /** @type {WindowDef} */
  lag: {
    create(offset, defaultValue = _util_null__WEBPACK_IMPORTED_MODULE_3__["default"]) {
      offset = +offset || 1;
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => {
          const i = w.index - offset;
          return i >= 0 ? w.value(i, f) : defaultValue;
        }
      };
    },
    param: [1, 2]
  },

  /** @type {WindowDef} */
  lead: {
    create(offset, defaultValue = _util_null__WEBPACK_IMPORTED_MODULE_3__["default"]) {
      offset = +offset || 1;
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => {
          const i = w.index + offset;
          return i < w.size ? w.value(i, f) : defaultValue;
        }
      };
    },
    param: [1, 2]
  },

  /** @type {WindowDef} */
  first_value: {
    create() {
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => w.value(w.i0, f)
      };
    },
    param: [1]
  },

  /** @type {WindowDef} */
  last_value: {
    create() {
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => w.value(w.i1 - 1, f)
      };
    },
    param: [1]
  },

  /** @type {WindowDef} */
  nth_value: {
    create(nth) {
      nth = +nth;
      if (!(nth > 0)) (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('nth_value nth must be greater than zero.');
      return {
        init: _util_no_op__WEBPACK_IMPORTED_MODULE_2__["default"],
        value: (w, f) => {
          const i = w.i0 + (nth - 1);
          return i < w.i1 ? w.value(i, f) : _util_null__WEBPACK_IMPORTED_MODULE_3__["default"];
        }
      };
    },
    param: [1, 1]
  },

  /** @type {WindowDef} */
  fill_down: {
    create(defaultValue = _util_null__WEBPACK_IMPORTED_MODULE_3__["default"]) {
      let value;
      return {
        init: () => value = defaultValue,
        value: (w, f) => {
          const v = w.value(w.index, f);
          return (0,_util_is_valid__WEBPACK_IMPORTED_MODULE_1__["default"])(v) ? (value = v) : value;
        }
      };
    },
    param: [1, 1]
  },

  /** @type {WindowDef} */
  fill_up: {
    create(defaultValue = _util_null__WEBPACK_IMPORTED_MODULE_3__["default"]) {
      let value, idx;
      return {
        init: () => (value = defaultValue, idx = -1),
        value: (w, f) => w.index <= idx ? value
          : (idx = find(w, f, w.index)) >= 0 ? (value = w.value(idx, f))
          : (idx = w.size, value = defaultValue)
      };
    },
    param: [1, 1]
  }
});

function find(w, f, i) {
  for (const n = w.size; i < n; ++i) {
    if ((0,_util_is_valid__WEBPACK_IMPORTED_MODULE_1__["default"])(w.value(i, f))) return i;
  }
  return -1;
}


/***/ }),

/***/ "../../node_modules/arquero/src/query/constants.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/query/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Descending: () => (/* binding */ Descending),
/* harmony export */   Expr: () => (/* binding */ Expr),
/* harmony export */   ExprList: () => (/* binding */ ExprList),
/* harmony export */   ExprNumber: () => (/* binding */ ExprNumber),
/* harmony export */   ExprObject: () => (/* binding */ ExprObject),
/* harmony export */   JoinKeys: () => (/* binding */ JoinKeys),
/* harmony export */   JoinValues: () => (/* binding */ JoinValues),
/* harmony export */   Options: () => (/* binding */ Options),
/* harmony export */   OrderbyKeys: () => (/* binding */ OrderbyKeys),
/* harmony export */   Query: () => (/* binding */ Query),
/* harmony export */   Selection: () => (/* binding */ Selection),
/* harmony export */   SelectionList: () => (/* binding */ SelectionList),
/* harmony export */   TableRef: () => (/* binding */ TableRef),
/* harmony export */   TableRefList: () => (/* binding */ TableRefList),
/* harmony export */   Verb: () => (/* binding */ Verb),
/* harmony export */   Window: () => (/* binding */ Window)
/* harmony export */ });
const Expr = 'Expr';
const ExprList = 'ExprList';
const ExprNumber = 'ExprNumber';
const ExprObject = 'ExprObject';
const JoinKeys = 'JoinKeys';
const JoinValues = 'JoinValues';
const Options = 'Options';
const OrderbyKeys = 'OrderKeys';
const SelectionList = 'SelectionList';
const TableRef = 'TableRef';
const TableRefList = 'TableRefList';

const Descending = 'Descending';
const Query = 'Query';
const Selection = 'Selection';
const Verb = 'Verb';
const Window = 'Window';

/***/ }),

/***/ "../../node_modules/arquero/src/query/query.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/query/query.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addQueryVerb: () => (/* binding */ addQueryVerb),
/* harmony export */   "default": () => (/* binding */ Query),
/* harmony export */   query: () => (/* binding */ query),
/* harmony export */   queryFrom: () => (/* binding */ queryFrom)
/* harmony export */ });
/* harmony import */ var _table_transformable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../table/transformable */ "../../node_modules/arquero/src/table/transformable.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/arquero/src/query/constants.js");
/* harmony import */ var _verb__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./verb */ "../../node_modules/arquero/src/query/verb.js");




/**
 * Create a new query instance. The query interface provides
 * a table-like verb API to construct a query that can be
 * serialized or evaluated against Arquero tables.
 * @param {string} [tableName] The name of the table to query. If
 *  provided, will be used as the default input table to pull from
 *  a provided catalog to run the query against.
 * @return {Query} A new builder instance.
 */
function query(tableName) {
  return new Query(null, null, tableName);
}

/**
 * Create a new query instance from a serialized object.
 * @param {object} object A serialized query representation, such as
 *  those generated by query(...).toObject().
 * @returns {Query} The instantiated query instance.
 */
function queryFrom(object) {
  return Query.from(object);
}

/**
 * Model a query as a collection of serializble verbs.
 * Provides a table-like interface for constructing queries.
 */
class Query extends _table_transformable__WEBPACK_IMPORTED_MODULE_0__["default"] {

  /**
   * Construct a new query instance.
   * @param {Verb[]} verbs An array of verb instances.
   * @param {object} [params] Optional query parameters, corresponding
   *  to parameter references in table expressions.
   * @param {string} [table] Optional name of the table to query.
   */
  constructor(verbs, params, table) {
    super(params);
    this._verbs = verbs || [];
    this._table = table;
  }

  /**
   * Create a new query instance from the given serialized object.
   * @param {QueryObject} object A serialized query representation, such as
   *  those generated by Query.toObject.
   * @returns {Query} The instantiated query.
   */
  static from({ verbs, table, params }) {
    return new Query(verbs.map(_verb__WEBPACK_IMPORTED_MODULE_2__.Verb.from), params, table);
  }

  /**
   * Provide an informative object string tag.
   */
  get [Symbol.toStringTag]() {
    if (!this._verbs) return 'Object'; // bail if called on prototype
    const ns = this._verbs.length;
    return `Query: ${ns} verbs` + (this._table ? ` on '${this._table}'` : '');
  }

  /**
   * Return the number of verbs in this query.
   */
  get length() {
    return this._verbs.length;
  }

  /**
   * Return the name of the table this query applies to.
   * @return {string} The name of the source table, or undefined.
   */
  get tableName() {
    return this._table;
  }

  /**
   * Get or set table expression parameter values.
   * If called with no arguments, returns the current parameter values
   * as an object. Otherwise, adds the provided parameters to this
   * query's parameter set and returns the table. Any prior parameters
   * with names matching the input parameters are overridden.
   * @param {object} values The parameter values.
   * @return {Query|object} The current parameter values (if called
   *  with no arguments) or this query.
   */
  params(values) {
    if (arguments.length) {
      this._params = { ...this._params, ...values };
      return this;
    } else {
      return this._params;
    }
  }

  /**
   * Evaluate this query against a given table and catalog.
   * @param {Table} table The Arquero table to process.
   * @param {Function} catalog A table lookup function that accepts a table
   *  name string as input and returns a corresponding Arquero table.
   * @returns {Table} The resulting Arquero table.
   */
  evaluate(table, catalog) {
    table = table || catalog(this._table);
    for (const verb of this._verbs) {
      table = verb.evaluate(table.params(this._params), catalog);
    }
    return table;
  }

  /**
   * Serialize this query as a JSON-compatible object. The resulting
   * object can be passed to Query.from to re-instantiate this query.
   * @returns {object} A JSON-compatible object representing this query.
   */
  toObject() {
    return serialize(this, 'toObject');
  }

  /**
   * Serialize this query as a JSON-compatible object. The resulting
   * object can be passed to Query.from to re-instantiate this query.
   * This method simply returns the result of toObject, but is provided
   * as a separate method to allow later customization of JSON export.
   * @returns {object} A JSON-compatible object representing this query.
   */
  toJSON() {
    return this.toObject();
  }

  /**
   * Serialize this query to a JSON-compatible abstract syntax tree.
   * All table expressions will be parsed and represented as AST instances
   * using a modified form of the Mozilla JavaScript AST format.
   * This method can be used to output parsed and serialized representations
   * to translate Arquero queries to alternative data processing platforms.
   * @returns {object} A JSON-compatible abstract syntax tree object.
   */
  toAST() {
    return serialize(this, 'toAST', { type: _constants__WEBPACK_IMPORTED_MODULE_1__.Query });
  }
}

/**
 * Serialized object representation of a query.
 * @typedef {object} QueryObject
 * @property {object[]} verbs An array of verb definitions.
 * @property {object} [params] An object of parameter values.
 * @property {string} [table] The name of the table to query.
 */

function serialize(query, method, props) {
  return {
    ...props,
    verbs: query._verbs.map(verb => verb[method]()),
    ...(query._params ? { params: query._params } : null),
    ...(query._table ? { table: query._table } : null)
  };
}

function append(qb, verb) {
  return new Query(
    qb._verbs.concat(verb),
    qb._params,
    qb._table
  );
}

function addQueryVerb(name, verb) {
  Query.prototype[name] = function(...args) {
    return append(this, verb(...args));
  };
}

// Internal verb handlers
for (const name in _verb__WEBPACK_IMPORTED_MODULE_2__.Verbs) {
  const verb = _verb__WEBPACK_IMPORTED_MODULE_2__.Verbs[name];
  Query.prototype['__' + name] = function(qb, ...args) {
    return append(qb, verb(...args));
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/query/to-ast.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/query/to-ast.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/query/util.js");
/* harmony import */ var _expression_ast_constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../expression/ast/constants */ "../../node_modules/arquero/src/expression/ast/constants.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./constants */ "../../node_modules/arquero/src/query/constants.js");













const Methods = {
  [_constants__WEBPACK_IMPORTED_MODULE_10__.Expr]: astExpr,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.ExprList]: astExprList,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.ExprNumber]: astExprNumber,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.ExprObject]: astExprObject,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.JoinKeys]: astJoinKeys,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.JoinValues]: astJoinValues,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.OrderbyKeys]: astExprList,
  [_constants__WEBPACK_IMPORTED_MODULE_10__.SelectionList]: astSelectionList
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, type, propTypes) {
  return type === _constants__WEBPACK_IMPORTED_MODULE_10__.TableRef ? astTableRef(value)
    : type === _constants__WEBPACK_IMPORTED_MODULE_10__.TableRefList ? value.map(astTableRef)
    : ast((0,_util__WEBPACK_IMPORTED_MODULE_8__.toObject)(value), type, propTypes);
}

function ast(value, type, propTypes) {
  return type === _constants__WEBPACK_IMPORTED_MODULE_10__.Options
    ? (value ? astOptions(value, propTypes) : value)
    : Methods[type](value);
}

function astOptions(value, types = {}) {
  const output = {};
  for (const key in value) {
    const prop = value[key];
    output[key] = types[key] ? ast(prop, types[key]) : prop;
  }
  return output;
}

function astParse(expr, opt) {
  return (0,_expression_parse__WEBPACK_IMPORTED_MODULE_7__["default"])({ expr }, { ...opt, ast: true }).exprs[0];
}

function astColumn(name) {
  return { type: _expression_ast_constants__WEBPACK_IMPORTED_MODULE_9__.Column, name };
}

function astColumnIndex(index) {
  return { type: _expression_ast_constants__WEBPACK_IMPORTED_MODULE_9__.Column, index };
}

function astExprObject(obj, opt) {
  if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_5__["default"])(obj)) {
    return astParse(obj, opt);
  }

  if (obj.expr) {
    let ast;
    if (obj.field === true) {
      ast = astColumn(obj.expr);
    } else if (obj.func === true) {
      ast = astExprObject(obj.expr, opt);
    }
    if (ast) {
      if (obj.desc) {
        ast = { type: _constants__WEBPACK_IMPORTED_MODULE_10__.Descending, expr: ast };
      }
      if (obj.window) {
        ast = { type: _constants__WEBPACK_IMPORTED_MODULE_10__.Window, expr: ast, ...obj.window };
      }
      return ast;
    }
  }

  return Object.keys(obj)
    .map(key => ({
      ...astExprObject(obj[key], opt),
      as: key
    }));
}

function astSelection(sel) {
  const type = _constants__WEBPACK_IMPORTED_MODULE_10__.Selection;
  return sel.all ? { type, operator: 'all' }
    : sel.not ? { type, operator: 'not', arguments: astExprList(sel.not) }
    : sel.range ? { type, operator: 'range', arguments: astExprList(sel.range) }
    : sel.matches ? { type, operator: 'matches', arguments: sel.matches }
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('Invalid input');
}

function astSelectionList(arr) {
  return (0,_util_to_array__WEBPACK_IMPORTED_MODULE_6__["default"])(arr).map(astSelectionItem).flat();
}

function astSelectionItem(val) {
  return (0,_util__WEBPACK_IMPORTED_MODULE_8__.isSelection)(val) ? astSelection(val)
    : (0,_util_is_number__WEBPACK_IMPORTED_MODULE_3__["default"])(val) ? astColumnIndex(val)
    : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_5__["default"])(val) ? astColumn(val)
    : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_4__["default"])(val) ? Object.keys(val)
      .map(name => ({ type: _expression_ast_constants__WEBPACK_IMPORTED_MODULE_9__.Column, name, as: val[name] }))
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('Invalid input');
}

function astExpr(val) {
  return (0,_util__WEBPACK_IMPORTED_MODULE_8__.isSelection)(val) ? astSelection(val)
    : (0,_util_is_number__WEBPACK_IMPORTED_MODULE_3__["default"])(val) ? astColumnIndex(val)
    : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_5__["default"])(val) ? astColumn(val)
    : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_4__["default"])(val) ? astExprObject(val)
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])('Invalid input');
}

function astExprList(arr) {
  return (0,_util_to_array__WEBPACK_IMPORTED_MODULE_6__["default"])(arr).map(astExpr).flat();
}

function astExprNumber(val) {
  return (0,_util_is_number__WEBPACK_IMPORTED_MODULE_3__["default"])(val) ? val : astExprObject(val);
}

function astJoinKeys(val) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_1__["default"])(val)
    ? val.map(astExprList)
    : astExprObject(val, { join: true });
}

function astJoinValues(val) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_1__["default"])(val)
    ? val.map((v, i) => i < 2
        ? astExprList(v)
        : astExprObject(v, { join: true })
      )
    : astExprObject(val, { join: true });
}

function astTableRef(value) {
  return value && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_2__["default"])(value.toAST)
    ? value.toAST()
    : value;
}

/***/ }),

/***/ "../../node_modules/arquero/src/query/util.js":
/*!****************************************************!*\
  !*** ../../node_modules/arquero/src/query/util.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fromObject: () => (/* binding */ fromObject),
/* harmony export */   getTable: () => (/* binding */ getTable),
/* harmony export */   isSelection: () => (/* binding */ isSelection),
/* harmony export */   joinKeys: () => (/* binding */ joinKeys),
/* harmony export */   joinValues: () => (/* binding */ joinValues),
/* harmony export */   orderbyKeys: () => (/* binding */ orderbyKeys),
/* harmony export */   toObject: () => (/* binding */ toObject)
/* harmony export */ });
/* harmony import */ var _helpers_desc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers/desc */ "../../node_modules/arquero/src/helpers/desc.js");
/* harmony import */ var _helpers_field__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/field */ "../../node_modules/arquero/src/helpers/field.js");
/* harmony import */ var _helpers_rolling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/rolling */ "../../node_modules/arquero/src/helpers/rolling.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _query__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./query */ "../../node_modules/arquero/src/query/query.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_map_object__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../util/map-object */ "../../node_modules/arquero/src/util/map-object.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");














function func(expr) {
  const f = d => d;
  f.toString = () => expr;
  return f;
}

function getTable(catalog, ref) {
  ref = ref && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(ref.query) ? ref.query() : ref;
  return ref && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(ref.evaluate)
    ? ref.evaluate(null, catalog)
    : catalog(ref);
}

function isSelection(value) {
  return (0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(value) && (
    (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.all) ||
    (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.matches) ||
    (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.not) ||
    (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.range)
  );
}

function toObject(value) {
  return value && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(value.toObject) ? value.toObject()
    : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(value) ? { expr: String(value), func: true }
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value) ? value.map(toObject)
    : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(value) ? (0,_util_map_object__WEBPACK_IMPORTED_MODULE_11__["default"])(value, _ => toObject(_))
    : value;
}

function fromObject(value) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value) ? value.map(fromObject)
    : !(0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(value) ? value
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.verbs) ? _query__WEBPACK_IMPORTED_MODULE_4__["default"].from(value)
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.all) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_3__.all)()
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.range) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_3__.range)(...value.range)
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.match) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_3__.matches)(RegExp(...value.match))
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(value.not) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_3__.not)(value.not.map(toObject))
    : fromExprObject(value);
}

function fromExprObject(value) {
  let output = value;
  let expr = value.expr;

  if (expr != null) {
    if (value.field === true) {
      output = expr = (0,_helpers_field__WEBPACK_IMPORTED_MODULE_1__["default"])(expr);
    } else if (value.func === true) {
      output = expr = func(expr);
    }

    if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(value.window)) {
      const { frame, peers } = value.window;
      output = expr = (0,_helpers_rolling__WEBPACK_IMPORTED_MODULE_2__["default"])(expr, frame, peers);
    }

    if (value.desc === true) {
      output = (0,_helpers_desc__WEBPACK_IMPORTED_MODULE_0__["default"])(expr);
    }
  }

  return value === output
    ? (0,_util_map_object__WEBPACK_IMPORTED_MODULE_11__["default"])(value, _ => fromObject(_))
    : output;
}

function joinKeys(keys) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(keys) ? keys.map(parseJoinKeys)
    : keys;
}

function parseJoinKeys(keys) {
  const list = [];

  (0,_util_to_array__WEBPACK_IMPORTED_MODULE_12__["default"])(keys).forEach(param => {
    (0,_util_is_number__WEBPACK_IMPORTED_MODULE_8__["default"])(param) ? list.push(param)
      : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_10__["default"])(param) ? list.push((0,_helpers_field__WEBPACK_IMPORTED_MODULE_1__["default"])(param, null))
      : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(param) && param.expr ? list.push(param)
      : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(param) ? list.push(param)
      : (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])(`Invalid key value: ${param+''}`);
  });

  return list;
}

function joinValues(values) {
  return (0,_util_is_array__WEBPACK_IMPORTED_MODULE_6__["default"])(values)
    ? values.map(parseJoinValues)
    : values;
}

function parseJoinValues(values, index) {
  return index < 2 ? (0,_util_to_array__WEBPACK_IMPORTED_MODULE_12__["default"])(values) : values;
}

function orderbyKeys(keys) {
  const list = [];

  keys.forEach(param => {
    const expr = param.expr != null ? param.expr : param;
    if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_9__["default"])(expr) && !(0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(expr)) {
      for (const key in expr) {
        list.push(expr[key]);
      }
    } else {
      param = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_8__["default"])(expr) ? expr
        : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_10__["default"])(expr) ? (0,_helpers_field__WEBPACK_IMPORTED_MODULE_1__["default"])(param)
        : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_7__["default"])(expr) ? param
        : (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])(`Invalid orderby field: ${param+''}`);
      list.push(param);
    }
  });

  return list;
}

/***/ }),

/***/ "../../node_modules/arquero/src/query/verb.js":
/*!****************************************************!*\
  !*** ../../node_modules/arquero/src/query/verb.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Verb: () => (/* binding */ Verb),
/* harmony export */   Verbs: () => (/* binding */ Verbs),
/* harmony export */   createVerb: () => (/* binding */ createVerb)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/arquero/src/query/constants.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util */ "../../node_modules/arquero/src/query/util.js");
/* harmony import */ var _to_ast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./to-ast */ "../../node_modules/arquero/src/query/to-ast.js");








/**
 * Model an Arquero verb as a serializable object.
 */
class Verb {

  /**
   * Construct a new verb instance.
   * @param {string} verb The verb name.
   * @param {object[]} schema Schema describing verb parameters.
   * @param {any[]} params Array of parameter values.
   */
  constructor(verb, schema = [], params = []) {
    this.verb = verb;
    this.schema = schema;
    schema.forEach((s, index) => {
      const type = s.type;
      const param = params[index];
      const value = type === _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys ? (0,_util__WEBPACK_IMPORTED_MODULE_1__.joinKeys)(param)
        : type === _constants__WEBPACK_IMPORTED_MODULE_0__.JoinValues ? (0,_util__WEBPACK_IMPORTED_MODULE_1__.joinValues)(param)
        : type === _constants__WEBPACK_IMPORTED_MODULE_0__.OrderbyKeys ? (0,_util__WEBPACK_IMPORTED_MODULE_1__.orderbyKeys)(param)
        : param;
      this[s.name] = value !== undefined ? value : s.default;
    });
  }

  /**
   * Create new verb instance from the given serialized object.
   * @param {object} object A serialized verb representation, such as
   *  those generated by Verb.toObject.
   * @returns {Verb} The instantiated verb.
   */
  static from(object) {
    const verb = Verbs[object.verb];
    const params = (verb.schema || [])
      .map(({ name }) => (0,_util__WEBPACK_IMPORTED_MODULE_1__.fromObject)(object[name]));
    return verb(...params);
  }

  /**
   * Evaluate this verb against a given table and catalog.
   * @param {Table} table The Arquero table to process.
   * @param {Function} catalog A table lookup function that accepts a table
   *  name string as input and returns a corresponding Arquero table.
   * @returns {Table} The resulting Arquero table.
   */
  evaluate(table, catalog) {
    const params = this.schema.map(({ name, type }) => {
      const value = this[name];
      return type === _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef ? (0,_util__WEBPACK_IMPORTED_MODULE_1__.getTable)(catalog, value)
        : type === _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList ? value.map(t => (0,_util__WEBPACK_IMPORTED_MODULE_1__.getTable)(catalog, t))
        : value;
    });
    return table[this.verb](...params);
  }

  /**
   * Serialize this verb as a JSON-compatible object. The resulting
   * object can be passed to Verb.from to re-instantiate this verb.
   * @returns {object} A JSON-compatible object representing this verb.
   */
  toObject() {
    const obj = { verb: this.verb };
    this.schema.forEach(({ name }) => {
      obj[name] = (0,_util__WEBPACK_IMPORTED_MODULE_1__.toObject)(this[name]);
    });
    return obj;
  }

  /**
   * Serialize this verb to a JSON-compatible abstract syntax tree.
   * All table expressions will be parsed and represented as AST instances
   * using a modified form of the Mozilla JavaScript AST format.
   * This method can be used to output parsed and serialized representations
   * to translate Arquero verbs to alternative data processing platforms.
   * @returns {object} A JSON-compatible abstract syntax tree object.
   */
  toAST() {
    const obj = { type: _constants__WEBPACK_IMPORTED_MODULE_0__.Verb, verb: this.verb };
    this.schema.forEach(({ name, type, props }) => {
      obj[name] = (0,_to_ast__WEBPACK_IMPORTED_MODULE_2__["default"])(this[name], type, props);
    });
    return obj;
  }
}

/**
 * Verb parameter type.
 * @typedef {Expr|ExprList|ExprNumber|ExprObject|JoinKeys|JoinValues|Options|OrderbyKeys|SelectionList|TableRef|TableRefList} ParamType
 */

/**
 * Verb parameter schema.
 * @typedef {object} ParamDef
 * @property {string} name The name of the parameter.
 * @property {ParamType} type The type of the parameter.
 * @property {{ [key: string]: ParamType }} [props] Types for non-literal properties.
 */

/**
 * Create a new constructors.
 * @param {string} name The name of the verb.
 * @param {ParamDef[]} schema The verb parameter schema.
 * @return {Function} A verb constructor function.
 */
function createVerb(name, schema) {
  return Object.assign(
    (...params) => new Verb(name, schema, params),
    { schema }
  );
}

/**
 * A lookup table of verb classes.
 */
const Verbs = {
  count:      createVerb('count', [
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  derive:     createVerb('derive', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprObject },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options,
                  props: { before: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList, after: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList }
                }
              ]),
  filter:     createVerb('filter', [
                { name: 'criteria', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprObject }
              ]),
  groupby:    createVerb('groupby', [
                { name: 'keys', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList }
              ]),
  orderby:    createVerb('orderby', [
                { name: 'keys', type: _constants__WEBPACK_IMPORTED_MODULE_0__.OrderbyKeys }
              ]),
  relocate:   createVerb('relocate', [
                { name: 'columns', type: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options,
                  props: { before: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList, after: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList }
                }
              ]),
  rename:     createVerb('rename', [
                { name: 'columns', type: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList }
              ]),
  rollup:     createVerb('rollup', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprObject }
              ]),
  sample:     createVerb('sample', [
                { name: 'size', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprNumber },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options, props: { weight: _constants__WEBPACK_IMPORTED_MODULE_0__.Expr } }
              ]),
  select:     createVerb('select', [
                { name: 'columns', type: _constants__WEBPACK_IMPORTED_MODULE_0__.SelectionList }
              ]),
  ungroup:    createVerb('ungroup'),
  unorder:    createVerb('unorder'),
  reify:      createVerb('reify'),
  dedupe:     createVerb('dedupe', [
                { name: 'keys', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList, default: [] }
              ]),
  impute:     createVerb('impute', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprObject },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options, props: { expand: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList } }
              ]),
  fold:       createVerb('fold', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  pivot:      createVerb('pivot', [
                { name: 'keys', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  spread:     createVerb('spread', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  unroll:     createVerb('unroll', [
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options, props: { drop: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList } }
              ]),
  lookup:     createVerb('lookup', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'on', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys },
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.ExprList }
              ]),
  join:       createVerb('join', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'on', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys },
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinValues },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  cross:      createVerb('cross', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'values', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinValues },
                { name: 'options', type: _constants__WEBPACK_IMPORTED_MODULE_0__.Options }
              ]),
  semijoin:   createVerb('semijoin', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'on', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys }
              ]),
  antijoin:   createVerb('antijoin', [
                { name: 'table', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRef },
                { name: 'on', type: _constants__WEBPACK_IMPORTED_MODULE_0__.JoinKeys }
              ]),
  concat:     createVerb('concat', [
                { name: 'tables', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList }
              ]),
  union:      createVerb('union', [
                { name: 'tables', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList }
              ]),
  intersect:  createVerb('intersect', [
                { name: 'tables', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList }
              ]),
  except:     createVerb('except', [
                { name: 'tables', type: _constants__WEBPACK_IMPORTED_MODULE_0__.TableRefList }
              ])
};

/***/ }),

/***/ "../../node_modules/arquero/src/register.js":
/*!**************************************************!*\
  !*** ../../node_modules/arquero/src/register.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addAggregateFunction: () => (/* binding */ addAggregateFunction),
/* harmony export */   addFunction: () => (/* binding */ addFunction),
/* harmony export */   addPackage: () => (/* binding */ addPackage),
/* harmony export */   addTableMethod: () => (/* binding */ addTableMethod),
/* harmony export */   addVerb: () => (/* binding */ addVerb),
/* harmony export */   addWindowFunction: () => (/* binding */ addWindowFunction)
/* harmony export */ });
/* harmony import */ var _table_column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./table/column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _op_aggregate_functions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./op/aggregate-functions */ "../../node_modules/arquero/src/op/aggregate-functions.js");
/* harmony import */ var _op_window_functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./op/window-functions */ "../../node_modules/arquero/src/op/window-functions.js");
/* harmony import */ var _op_functions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./op/functions */ "../../node_modules/arquero/src/op/functions/index.js");
/* harmony import */ var _op_op__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./op/op */ "../../node_modules/arquero/src/op/op.js");
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./op/op-api */ "../../node_modules/arquero/src/op/op-api.js");
/* harmony import */ var _query_query__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./query/query */ "../../node_modules/arquero/src/query/query.js");
/* harmony import */ var _query_verb__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./query/verb */ "../../node_modules/arquero/src/query/verb.js");
/* harmony import */ var _expression_row_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./expression/row-object */ "../../node_modules/arquero/src/expression/row-object.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./util/has */ "../../node_modules/arquero/src/util/has.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./util/to-string */ "../../node_modules/arquero/src/util/to-string.js");













const onIllegal = (name, type) =>
  (0,_util_error__WEBPACK_IMPORTED_MODULE_9__["default"])(`Illegal ${type} name: ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_11__["default"])(name)}`);

const onDefined = (name, type) =>
  (0,_util_error__WEBPACK_IMPORTED_MODULE_9__["default"])(`The ${type} ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_11__["default"])(name)} is already defined. Use override option?`);

const onReserve = (name, type) =>
  (0,_util_error__WEBPACK_IMPORTED_MODULE_9__["default"])(`The ${type} name ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_11__["default"])(name)} is reserved and can not be overridden.`);

function check(name, options, obj = _op_op_api__WEBPACK_IMPORTED_MODULE_5__["default"], type = 'function') {
  if (!name) onIllegal(name, type);
  if (!options.override && (0,_util_has__WEBPACK_IMPORTED_MODULE_10__["default"])(obj, name)) onDefined(name, type);
}

// -- Op Functions --------------------------------------------------

function verifyFunction(name, def, object, options) {
  return object[name] === def || check(name, options);
}

/**
 * Register an aggregate or window operation.
 * @param {string} name The name of the operation
 * @param {AggregateDef|WindowDef} def The operation definition.
 * @param {object} object The registry object to add the definition to.
 * @param {RegisterOptions} [options] Registration options.
 */
function addOp(name, def, object, options = {}) {
  if (verifyFunction(name, def, object, options)) return;
  const [nf = 0, np = 0] = def.param;
  object[name] = def;
  _op_op_api__WEBPACK_IMPORTED_MODULE_5__["default"][name] = (...params) => (0,_op_op__WEBPACK_IMPORTED_MODULE_4__["default"])(
    name,
    params.slice(0, nf),
    params.slice(nf, nf + np)
  );
}

/**
 * Register a custom aggregate function.
 * @param {string} name The name to use for the aggregate function.
 * @param {AggregateDef} def The aggregate operator definition.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified.
 */
function addAggregateFunction(name, def, options) {
  addOp(name, def, _op_aggregate_functions__WEBPACK_IMPORTED_MODULE_1__["default"], options);
}

/**
 * Register a custom window function.
 * @param {string} name The name to use for the window function.
 * @param {WindowDef} def The window operator definition.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified.
 */
function addWindowFunction(name, def, options) {
  addOp(name, def, _op_window_functions__WEBPACK_IMPORTED_MODULE_2__["default"], options);
}

/**
 * Register a function for use within table expressions.
 * If only a single argument is provided, it will be assumed to be a
 * function and the system will try to extract its name.
 * @param {string} name The name to use for the function.
 * @param {Function} fn A standard JavaScript function.
 * @param {RegisterOptions} [options] Function registration options.
 * @throws If a function with the same name is already registered and
 *  the override option is not specified, or if no name is provided
 *  and the input function is anonymous.
 */
function addFunction(name, fn, options = {}) {
  if (arguments.length === 1) {
    fn = name;
    name = fn.name;
    if (name === '' || name === 'anonymous') {
      (0,_util_error__WEBPACK_IMPORTED_MODULE_9__["default"])('Anonymous function provided, please include a name argument.');
    } else if (name === _expression_row_object__WEBPACK_IMPORTED_MODULE_8__.ROW_OBJECT) {
      onReserve(_expression_row_object__WEBPACK_IMPORTED_MODULE_8__.ROW_OBJECT, 'function');
    }
  }
  if (verifyFunction(name, fn, _op_functions__WEBPACK_IMPORTED_MODULE_3__["default"], options)) return;
  _op_functions__WEBPACK_IMPORTED_MODULE_3__["default"][name] = fn;
  _op_op_api__WEBPACK_IMPORTED_MODULE_5__["default"][name] = fn;
}

// -- Table Methods and Verbs ---------------------------------------

const proto = _table_column_table__WEBPACK_IMPORTED_MODULE_0__["default"].prototype;

/**
 * Reserved table/query methods that must not be overwritten.
 */
let RESERVED;

function addReserved(obj) {
  for (; obj; obj = Object.getPrototypeOf(obj)) {
    Object.getOwnPropertyNames(obj).forEach(name => RESERVED[name] = 1);
  }
}

function verifyTableMethod(name, fn, options) {
  const type = 'method';

  // exit early if duplicate re-assignment
  if (proto[name] && proto[name].fn === fn) return true;

  // initialize reserved properties to avoid overriding internals
  if (!RESERVED) {
    RESERVED = {};
    addReserved(proto);
    addReserved(_query_query__WEBPACK_IMPORTED_MODULE_6__["default"].prototype);
  }

  // perform name checks
  if (RESERVED[name]) onReserve(name, type);
  if ((name + '')[0] === '_') onIllegal(name, type);
  check(name, options, proto, type);
}

/**
 * Register a new table method. A new method will be added to the column
 * table prototype. When invoked from a table, the registered method will
 * be invoked with the table as the first argument, followed by all the
 * provided arguments.
 * @param {string} name The name of the table method.
 * @param {Function} method The table method.
 * @param {RegisterOptions} options
 */
function addTableMethod(name, method, options = {}) {
  if (verifyTableMethod(name, method, options)) return;
  proto[name] = function(...args) { return method(this, ...args); };
  proto[name].fn = method;
}

/**
 * Register a new transformation verb.
 * @param {string} name The name of the verb.
 * @param {Function} method The verb implementation.
 * @param {ParamDef[]} params The verb parameter schema.
 * @param {RegisterOptions} options Function registration options.
 */
function addVerb(name, method, params, options = {}) {
  // register table method first
  // if that doesn't throw, add serializable verb entry
  addTableMethod(name, method, options);
  (0,_query_query__WEBPACK_IMPORTED_MODULE_6__.addQueryVerb)(name, _query_verb__WEBPACK_IMPORTED_MODULE_7__.Verbs[name] = (0,_query_verb__WEBPACK_IMPORTED_MODULE_7__.createVerb)(name, params));
}

// -- Package Bundles -----------------------------------------------

const PACKAGE = 'arquero_package';

/**
 * Add an extension package of functions, table methods, and/or verbs.
 * @param {Package|PackageBundle} bundle The package of extensions.
 * @throws If package validation fails.
 */
function addPackage(bundle, options = {}) {
  const pkg = bundle && bundle[PACKAGE] || bundle;
  const parts = {
    functions: [
      (name, def, opt) => verifyFunction(name, def, _op_functions__WEBPACK_IMPORTED_MODULE_3__["default"], opt),
      addFunction
    ],
    aggregateFunctions: [
      (name, def, opt) => verifyFunction(name, def, _op_aggregate_functions__WEBPACK_IMPORTED_MODULE_1__["default"], opt),
      addAggregateFunction
    ],
    windowFunctions: [
      (name, def, opt) => verifyFunction(name, def, _op_window_functions__WEBPACK_IMPORTED_MODULE_2__["default"], opt),
      addWindowFunction
    ],
    tableMethods: [
      verifyTableMethod,
      addTableMethod
    ],
    verbs: [
      (name, obj, opt) => verifyTableMethod(name, obj.method, opt),
      (name, obj, opt) => addVerb(name, obj.method, obj.params, opt)
    ]
  };

  function scan(index) {
    for (const key in parts) {
      const part = parts[key];
      const p = pkg[key];
      for (const name in p) part[index](name, p[name], options);
    }
  }
  scan(0); // first validate package, throw if validation fails
  scan(1); // then add package content
}

/**
 * Aggregate function definition.
 * @typedef {import('./op/aggregate-functions').AggregateDef} AggregateDef
 */

/**
 * Window function definition.
 * @typedef {import('./op/window-functions').WindowDef} WindowDef
 */

/**
 * Verb parameter definition.
 * @typedef {import('./query/verb').ParamDef} ParamDef
 */

/**
 * Verb definition.
 * @typedef {object} VerbDef
 * @property {Function} method A function implementing the verb.
 * @property {ParamDef[]} params The verb parameter schema.
 */

/**
 * Verb parameter definition.
 * @typedef {object} ParamDef
 * @property {string} name The verb parameter name.
 * @property {ParamType} type The verb parameter type.
 */

/**
 * A package of op function and table method definitions.
 * @typedef {object} Package
 * @property {{[name: string]: Function}} [functions] Standard function entries.
 * @property {{[name: string]: AggregateDef}} [aggregateFunctions] Aggregate function entries.
 * @property {{[name: string]: WindowDef}} [windowFunctions] Window function entries.
 * @property {{[name: string]: Function}} [tableMethods] Table method entries.
 * @property {{[name: string]: VerbDef}} [verbs] Verb entries.
 */

/**
 * An object containing an extension package.
 * @typedef {object} PackageBundle
 * @property {Package} arquero.package The package bundle.
 */

/**
 * Options for registering new functions.
 * @typedef {object} RegisterOptions
 * @property {boolean} [override=false] Flag indicating if the added
 *  function can override an existing function with the same name.
 */

/***/ }),

/***/ "../../node_modules/arquero/src/table/bit-set.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/table/bit-set.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BitSet)
/* harmony export */ });
const ONE = 0x80000000;
const ALL = 0xFFFFFFFF;

/**
 * Represent an indexable set of bits.
 */
class BitSet {
  /**
   * Instantiate a new BitSet instance.
   * @param {number} size The number of bits.
   */
  constructor(size) {
    this._size = size;
    this._bits = new Uint32Array(Math.ceil(size / 32));
  }

  /**
   * The number of bits.
   * @return {number}
   */
  get length() {
    return this._size;
  }

  /**
   * The number of bits set to one.
   * https://graphics.stanford.edu/~seander/bithacks.html#CountBitsSetKernighan
   * @return {number}
   */
  count() {
    const n = this._bits.length;
    let count = 0;
    for (let i = 0; i < n; ++i) {
      for (let b = this._bits[i]; b; ++count) {
        b &= b - 1;
      }
    }
    return count;
  }

  /**
   * Get the bit at a given index.
   * @param {number} i The bit index.
   */
  get(i) {
    return this._bits[i >> 5] & (ONE >>> i);
  }

  /**
   * Set the bit at a given index to one.
   * @param {number} i The bit index.
   */
  set(i) {
    this._bits[i >> 5] |= (ONE >>> i);
  }

  /**
   * Clear the bit at a given index to zero.
   * @param {number} i The bit index.
   */
  clear(i) {
    this._bits[i >> 5] &= ~(ONE >>> i);
  }

  /**
   * Scan the bits, invoking a callback function with the index of
   * each non-zero bit.
   * @param {(i: number) => void} fn A callback function.
   */
  scan(fn) {
    for (let i = this.next(0); i >= 0; i = this.next(i + 1)) {
      fn(i);
    }
  }

  /**
   * Get the next non-zero bit starting from a given index.
   * @param {number} i The bit index.
   */
  next(i) {
    const bits = this._bits;
    const n = bits.length;

    let index = i >> 5;
    let curr = bits[index] & (ALL >>> i);

    for (; index < n; curr = bits[++index]) {
      if (curr !== 0) {
        return (index << 5) + Math.clz32(curr);
      }
    }

    return -1;
  }

  /**
   * Return the index of the nth non-zero bit.
   * @param {number} n The number of non-zero bits to advance.
   * @return {number} The index of the nth non-zero bit.
   */
  nth(n) {
    let i = this.next(0);
    while (n-- && i >= 0) i = this.next(i + 1);
    return i;
  }

  /**
   * Negate all bits in this bitset.
   * Modifies this BitSet in place.
   * @return {this}
   */
  not() {
    const bits = this._bits;
    const n = bits.length;

    // invert all bits
    for (let i = 0; i < n; ++i) {
      bits[i] = ~bits[i];
    }

    // unset extraneous trailing bits
    const tail = this._size % 32;
    if (tail) {
      bits[n - 1] &= ONE >> (tail - 1);
    }

    return this;
  }

  /**
   * Compute the logical AND of this BitSet and another.
   * @param {BitSet} bitset The BitSet to combine with.
   * @return {BitSet} This BitSet updated with the logical AND.
   */
  and(bitset) {
    if (bitset) {
      const a = this._bits;
      const b = bitset._bits;
      const n = a.length;

      for (let i = 0; i < n; ++i) {
        a[i] &= b[i];
      }
    }
    return this;
  }

  /**
   * Compute the logical OR of this BitSet and another.
   * @param {BitSet} bitset The BitSet to combine with.
   * @return {BitSet} This BitSet updated with the logical OR.
   */
  or(bitset) {
    if (bitset) {
      const a = this._bits;
      const b = bitset._bits;
      const n = a.length;

      for (let i = 0; i < n; ++i) {
        a[i] |= b[i];
      }
    }
    return this;
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/table/column-set.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/table/column-set.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_has__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/has */ "../../node_modules/arquero/src/util/has.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table) {
  return table
    ? new ColumnSet({ ...table.data() }, table.columnNames())
    : new ColumnSet();
}

class ColumnSet {
  constructor(data, names) {
    this.data = data || {};
    this.names = names || [];
  }

  add(name, values) {
    if (!this.has(name)) this.names.push(name + '');
    return this.data[name] = values;
  }

  has(name) {
    return (0,_util_has__WEBPACK_IMPORTED_MODULE_0__["default"])(this.data, name);
  }

  new() {
    this.filter = null;
    this.groups = this.groups || null;
    this.order = null;
    return this;
  }

  groupby(groups) {
    this.groups = groups;
    return this;
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/table/column-table.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/table/column-table.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ColumnTable)
/* harmony export */ });
/* harmony import */ var _column__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./column */ "../../node_modules/arquero/src/table/column.js");
/* harmony import */ var _columns_from__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./columns-from */ "../../node_modules/arquero/src/table/columns-from.js");
/* harmony import */ var _column_set__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./column-set */ "../../node_modules/arquero/src/table/column-set.js");
/* harmony import */ var _table__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./table */ "../../node_modules/arquero/src/table/table.js");
/* harmony import */ var _regroup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./regroup */ "../../node_modules/arquero/src/table/regroup.js");
/* harmony import */ var _expression_row_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../expression/row-object */ "../../node_modules/arquero/src/expression/row-object.js");
/* harmony import */ var _format_to_arrow__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../format/to-arrow */ "../../node_modules/arquero/src/format/to-arrow.js");
/* harmony import */ var _format_to_csv__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../format/to-csv */ "../../node_modules/arquero/src/format/to-csv.js");
/* harmony import */ var _format_to_html__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../format/to-html */ "../../node_modules/arquero/src/format/to-html.js");
/* harmony import */ var _format_to_json__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../format/to-json */ "../../node_modules/arquero/src/format/to-json.js");
/* harmony import */ var _format_to_markdown__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../format/to-markdown */ "../../node_modules/arquero/src/format/to-markdown.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _util_array_type__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../util/array-type */ "../../node_modules/arquero/src/util/array-type.js");
/* harmony import */ var _util_entries__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../util/entries */ "../../node_modules/arquero/src/util/entries.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_map_object__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../util/map-object */ "../../node_modules/arquero/src/util/map-object.js");

















/**
 * Class representing a table backed by a named set of columns.
 */
class ColumnTable extends _table__WEBPACK_IMPORTED_MODULE_3__["default"] {

  /**
   * Create a new ColumnTable from existing input data.
   * @param {object[]|Iterable<object>|object|Map} values The backing table data values.
   *  If array-valued, should be a list of JavaScript objects with
   *  key-value properties for each column value.
   *  If object- or Map-valued, a table with two columns (one for keys,
   *  one for values) will be created.
   * @param {string[]} [names] The named columns to include.
   * @return {ColumnTable} A new ColumnTable instance.
   */
  static from(values, names) {
    return new ColumnTable((0,_columns_from__WEBPACK_IMPORTED_MODULE_1__["default"])(values, names), names);
  }

  /**
   * Create a new table for a set of named columns.
   * @param {object|Map} columns
   *  The set of named column arrays. Keys are column names.
   *  The enumeration order of the keys determines the column indices,
   *  unless the names parameter is specified.
   *  Values must be arrays (or array-like values) of identical length.
   * @param {string[]} [names] Ordered list of column names. If specified,
   *  this array determines the column indices. If not specified, the
   *  key enumeration order of the columns object is used.
   * @return {ColumnTable} the instantiated ColumnTable instance.
   */
  static new(columns, names) {
    if (columns instanceof ColumnTable) return columns;
    const data = {};
    const keys = [];
    for (const [key, value] of (0,_util_entries__WEBPACK_IMPORTED_MODULE_13__["default"])(columns)) {
      data[key] = value;
      keys.push(key);
    }
    return new ColumnTable(data, names || keys);
  }

  /**
   * Instantiate a new ColumnTable instance.
   * @param {object} columns An object mapping column names to values.
   * @param {string[]} [names] An ordered list of column names.
   * @param {BitSet} [filter] A filtering BitSet.
   * @param {GroupBySpec} [group] A groupby specification.
   * @param {RowComparator} [order] A row comparator function.
   * @param {Params} [params] An object mapping parameter names to values.
   */
  constructor(columns, names, filter, group, order, params) {
    (0,_util_map_object__WEBPACK_IMPORTED_MODULE_15__["default"])(columns, _column__WEBPACK_IMPORTED_MODULE_0__.defaultColumnFactory, columns);
    names = names || Object.keys(columns);
    const nrows = names.length ? columns[names[0]].length : 0;
    super(names, nrows, columns, filter, group, order, params);
  }

  /**
   * Create a new table with the same type as this table.
   * The new table may have different data, filter, grouping, or ordering
   * based on the values of the optional configuration argument. If a
   * setting is not specified, it is inherited from the current table.
   * @param {CreateOptions} [options] Creation options for the new table.
   * @return {ColumnTable} A newly created table.
   */
  create({ data, names, filter, groups, order }) {
    const f = filter !== undefined ? filter : this.mask();

    return new ColumnTable(
      data || this._data,
      names || (!data ? this._names : null),
      f,
      groups !== undefined ? groups : (0,_regroup__WEBPACK_IMPORTED_MODULE_4__.regroup)(this._group, filter && f),
      order !== undefined ? order : this._order,
      this._params
    );
  }

  /**
   * Create a new table with additional columns drawn from one or more input
   * tables. All tables must have the same numer of rows and are reified
   * prior to assignment. In the case of repeated column names, input table
   * columns overwrite existing columns.
   * @param {...ColumnTable} tables The tables to merge with this table.
   * @return {ColumnTable} A new table with merged columns.
   * @example table.assign(table1, table2)
   */
  assign(...tables) {
    const nrows = this.numRows();
    const base = this.reify();
    const cset = (0,_column_set__WEBPACK_IMPORTED_MODULE_2__["default"])(base).groupby(base.groups());
    tables.forEach(input => {
      input = ColumnTable.new(input);
      if (input.numRows() !== nrows) (0,_util_error__WEBPACK_IMPORTED_MODULE_14__["default"])('Assign row counts do not match');
      input = input.reify();
      input.columnNames(name => cset.add(name, input.column(name)));
    });
    return this.create(cset.new());
  }

  /**
   * Get the backing set of columns for this table.
   * @return {ColumnData} Object of named column instances.
   */
  columns() {
    return this._data;
  }

  /**
   * Get the column instance with the given name.
   * @param {string} name The column name.
   * @return {ColumnType | undefined} The named column, or undefined if it does not exist.
   */
  column(name) {
    return this._data[name];
  }

  /**
   * Get the column instance at the given index position.
   * @param {number} index The zero-based column index.
   * @return {ColumnType | undefined} The column, or undefined if it does not exist.
   */
  columnAt(index) {
    return this._data[this._names[index]];
  }

  /**
   * Get an array of values contained in a column. The resulting array
   * respects any table filter or orderby criteria.
   * @param {string} name The column name.
   * @param {ArrayConstructor|import('./table').TypedArrayConstructor} [constructor=Array]
   *  The array constructor for instantiating the output array.
   * @return {import('./table').DataValue[]|import('./table).TypedArray} The array of column values.
   */
  array(name, constructor = Array) {
    const column = this.column(name);
    const array = new constructor(this.numRows());
    let idx = -1;
    this.scan(row => array[++idx] = column.get(row), true);
    return array;
  }

  /**
   * Get the value for the given column and row.
   * @param {string} name The column name.
   * @param {number} [row=0] The row index, defaults to zero if not specified.
   * @return {import('./table').DataValue} The table value at (column, row).
   */
  get(name, row = 0) {
    const column = this.column(name);
    return this.isFiltered() || this.isOrdered()
      ? column.get(this.indices()[row])
      : column.get(row);
  }

  /**
   * Returns an accessor ("getter") function for a column. The returned
   * function takes a row index as its single argument and returns the
   * corresponding column value.
   * @param {string} name The column name.
   * @return {import('./table').ColumnGetter} The column getter function.
   */
  getter(name) {
    const column = this.column(name);
    const indices = this.isFiltered() || this.isOrdered() ? this.indices() : null;
    return indices ? row => column.get(indices[row])
      : column ? row => column.get(row)
      : (0,_util_error__WEBPACK_IMPORTED_MODULE_14__["default"])(`Unrecognized column: ${name}`);
  }

  /**
   * Returns an object representing a table row.
   * @param {number} [row=0] The row index, defaults to zero if not specified.
   * @return {object} A row object with named properties for each column.
   */
  object(row = 0) {
    return objectBuilder(this)(row);
  }

  /**
   * Returns an array of objects representing table rows.
   * @param {ObjectsOptions} [options] The options for row object generation.
   * @return {object[]} An array of row objects.
   */
  objects(options = {}) {
    const { grouped, limit, offset } = options;

    // generate array of row objects
    const names = (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_11__["default"])(this, options.columns || (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_11__.all)());
    const create = (0,_expression_row_object__WEBPACK_IMPORTED_MODULE_5__.rowObjectBuilder)(names);
    const obj = [];
    this.scan(
      (row, data) => obj.push(create(row, data)),
      true, limit, offset
    );

    // produce nested output as requested
    if (grouped && this.isGrouped()) {
      const idx = [];
      this.scan(row => idx.push(row), true, limit, offset);
      return (0,_regroup__WEBPACK_IMPORTED_MODULE_4__.nest)(this, idx, obj, grouped);
    }

    return obj;
  }

  /**
   * Returns an iterator over objects representing table rows.
   * @return {Iterator<object>} An iterator over row objects.
   */
  *[Symbol.iterator]() {
    const create = objectBuilder(this);
    const n = this.numRows();
    for (let i = 0; i < n; ++i) {
      yield create(i);
    }
  }

  /**
   * Create a new fully-materialized instance of this table.
   * All filter and orderby settings are removed from the new table.
   * Instead, the backing data itself is filtered and ordered as needed.
   * @param {number[]} [indices] Ordered row indices to materialize.
   *  If unspecified, all rows passing the table filter are used.
   * @return {ColumnTable} A reified table.
   */
  reify(indices) {
    const nrows = indices ? indices.length : this.numRows();
    const names = this._names;
    let data, groups;

    if (!indices && !this.isOrdered()) {
      if (!this.isFiltered()) {
        return this; // data already reified
      } else if (nrows === this.totalRows()) {
        data = this.data(); // all rows pass filter, skip copy
      }
    }

    if (!data) {
      const scan = indices ? f => indices.forEach(f) : f => this.scan(f, true);
      const ncols = names.length;
      data = {};

      for (let i = 0; i < ncols; ++i) {
        const name = names[i];
        const prev = this.column(name);
        const curr = data[name] = new ((0,_util_array_type__WEBPACK_IMPORTED_MODULE_12__["default"])(prev))(nrows);
        let r = -1;
        scan(row => curr[++r] = prev.get(row));
      }

      if (this.isGrouped()) {
        groups = (0,_regroup__WEBPACK_IMPORTED_MODULE_4__.reindex)(this.groups(), scan, !!indices, nrows);
      }
    }

    return this.create({ data, names, groups, filter: null, order: null });
  }

  /**
   * Apply a sequence of transformations to this table. The output
   * of each transform is passed as input to the next transform, and
   * the output of the last transform is then returned.
   * @param {...(Transform|Transform[])} transforms Transformation
   *  functions to apply to the table in sequence. Each function should
   *  take a single table as input and return a table as output.
   * @return {ColumnTable} The output of the last transform.
   */
  transform(...transforms) {
    return transforms.flat().reduce((t, f) => f(t), this);
  }

  /**
   * Format this table as an Apache Arrow table.
   * @param {ArrowFormatOptions} [options] The formatting options.
   * @return {import('apache-arrow').Table} An Apache Arrow table.
   */
  toArrow(options) {
    return (0,_format_to_arrow__WEBPACK_IMPORTED_MODULE_6__["default"])(this, options);
  }

  /**
   * Format this table as binary data in the Apache Arrow IPC format.
   * @param {ArrowFormatOptions} [options] The formatting options.
   * @return {Uint8Array} A new Uint8Array of Arrow-encoded binary data.
   */
  toArrowBuffer(options) {
    return (0,_format_to_arrow__WEBPACK_IMPORTED_MODULE_6__["default"])(this, options).serialize();
  }

  /**
   * Format this table as a comma-separated values (CSV) string. Other
   * delimiters, such as tabs or pipes ('|'), can be specified using
   * the options argument.
   * @param {CSVFormatOptions} [options] The formatting options.
   * @return {string} A delimited value string.
   */
  toCSV(options) {
    return (0,_format_to_csv__WEBPACK_IMPORTED_MODULE_7__["default"])(this, options);
  }

  /**
   * Format this table as an HTML table string.
   * @param {HTMLFormatOptions} [options] The formatting options.
   * @return {string} An HTML table string.
   */
  toHTML(options) {
    return (0,_format_to_html__WEBPACK_IMPORTED_MODULE_8__["default"])(this, options);
  }

  /**
   * Format this table as a JavaScript Object Notation (JSON) string.
   * @param {JSONFormatOptions} [options] The formatting options.
   * @return {string} A JSON string.
   */
  toJSON(options) {
    return (0,_format_to_json__WEBPACK_IMPORTED_MODULE_9__["default"])(this, options);
  }

  /**
   * Format this table as a GitHub-Flavored Markdown table string.
   * @param {MarkdownFormatOptions} [options] The formatting options.
   * @return {string} A GitHub-Flavored Markdown table string.
   */
  toMarkdown(options) {
    return (0,_format_to_markdown__WEBPACK_IMPORTED_MODULE_10__["default"])(this, options);
  }
}

function objectBuilder(table) {
  let b = table._builder;

  if (!b) {
    const create = (0,_expression_row_object__WEBPACK_IMPORTED_MODULE_5__.rowObjectBuilder)(table.columnNames());
    const data = table.data();
    if (table.isOrdered() || table.isFiltered()) {
      const indices = table.indices();
      b = row => create(indices[row], data);
    } else {
      b = row => create(row, data);
    }
    table._builder = b;
  }

  return b;
}

/**
 * A table transformation.
 * @typedef {(table: ColumnTable) => ColumnTable} Transform
 */

/**
 * Proxy type for BitSet class.
 * @typedef {import('./table').BitSet} BitSet
 */

/**
 * Proxy type for ColumnType interface.
 * @typedef {import('./column').ColumnType} ColumnType
 */

/**
 * A named collection of columns.
 * @typedef {{[key: string]: ColumnType}} ColumnData
 */

/**
 * Proxy type for GroupBySpec.
 * @typedef {import('./table').GroupBySpec} GroupBySpec
 */

/**
 * Proxy type for RowComparator.
 * @typedef {import('./table').RowComparator} RowComparator
 */

/**
 * Proxy type for Params.
 * @typedef {import('./table').Params} Params
 */

/**
 * Options for Arrow formatting.
 * @typedef {import('../arrow/encode').ArrowFormatOptions} ArrowFormatOptions
 */

/**
 * Options for CSV formatting.
 * @typedef {import('../format/to-csv').CSVFormatOptions} CSVFormatOptions
 */

/**
 * Options for HTML formatting.
 * @typedef {import('../format/to-html').HTMLFormatOptions} HTMLFormatOptions
 */

/**
 * Options for JSON formatting.
 * @typedef {import('../format/to-json').JSONFormatOptions} JSONFormatOptions
 */

/**
 * Options for Markdown formatting.
 * @typedef {import('../format/to-markdown').MarkdownFormatOptions} MarkdownFormatOptions
 */

/***/ }),

/***/ "../../node_modules/arquero/src/table/column.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/table/column.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   columnFactory: () => (/* binding */ columnFactory),
/* harmony export */   "default": () => (/* binding */ Column),
/* harmony export */   defaultColumnFactory: () => (/* binding */ defaultColumnFactory)
/* harmony export */ });
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");


/**
 * Class representing an array-backed data column.
 */
class Column {
  /**
   * Create a new column instance.
   * @param {Array} data The backing array (or array-like object)
   *  containing the column data.
   */
  constructor(data) {
    this.data = data;
  }

  /**
   * Get the length (number of rows) of the column.
   * @return {number} The length of the column array.
   */
  get length() {
    return this.data.length;
  }

  /**
   * Get the column value at the given row index.
   * @param {number} row The row index of the value to retrieve.
   * @return {import('./table').DataValue} The column value.
   */
  get(row) {
    return this.data[row];
  }

  /**
   * Returns an iterator over the column values.
   * @return {Iterator<object>} An iterator over column values.
   */
  [Symbol.iterator]() {
    return this.data[Symbol.iterator]();
  }
}

/**
 * Column interface. Any object that adheres to this interface
 * can be used as a data column within a {@link ColumnTable}.
 * @typedef {object} ColumnType
 * @property {number} length
 *  The length (number of rows) of the column.
 * @property {import('./table').ColumnGetter} get
 *  Column value getter.
 */

/**
 * Column factory function interface.
 * @callback ColumnFactory
 * @param {*} data The input column data.
 * @return {ColumnType} A column instance.
 */

/**
 * Create a new column from the given input data.
 * @param {any} data The backing column data. If the value conforms to
 *  the Column interface it is returned directly. If the value is an
 *  array, it will be wrapped in a new Column instance.
 * @return {ColumnType} A compatible column instance.
 */
let defaultColumnFactory = function(data) {
  return data && (0,_util_is_function__WEBPACK_IMPORTED_MODULE_0__["default"])(data.get) ? data : new Column(data);
};

/**
 * Get or set the default factory function for instantiating table columns.
 * @param {ColumnFactory} [factory] The new default factory.
 * @return {ColumnFactory} The current default column factory.
 */
function columnFactory(factory) {
  return arguments.length
    ? (defaultColumnFactory = factory)
    : defaultColumnFactory;
}

/***/ }),

/***/ "../../node_modules/arquero/src/table/columns-from.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/table/columns-from.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_date__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-date */ "../../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_regexp__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-regexp */ "../../node_modules/arquero/src/util/is-regexp.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");








/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(values, names) {
  const raise = type => (0,_util_error__WEBPACK_IMPORTED_MODULE_0__["default"])(`Illegal argument type: ${type || typeof values}`);
  return values instanceof Map ? fromKeyValuePairs(values.entries(), names)
    : (0,_util_is_date__WEBPACK_IMPORTED_MODULE_2__["default"])(values) ? raise('Date')
    : (0,_util_is_regexp__WEBPACK_IMPORTED_MODULE_5__["default"])(values) ? raise('RegExp')
    : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_6__["default"])(values) ? raise()
    : (0,_util_is_array__WEBPACK_IMPORTED_MODULE_1__["default"])(values) ? fromArray(values, names)
    : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_3__["default"])(values[Symbol.iterator]) ? fromIterable(values, names)
    : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_4__["default"])(values) ? fromKeyValuePairs(Object.entries(values), names)
    : raise();
}

function fromKeyValuePairs(entries, names = ['key', 'value']) {
  const keys = [];
  const vals = [];

  for (const [key, val] of entries) {
    keys.push(key);
    vals.push(val);
  }

  const columns = {};
  if (names[0]) columns[names[0]] = keys;
  if (names[1]) columns[names[1]] = vals;
  return columns;
}

function fromArray(values, names) {
  const len = values.length;
  const columns = {};
  const add = name => columns[name] = Array(len);

  if (len) {
    names = names || Object.keys(values[0]);
    const cols = names.map(add);
    const n = cols.length;
    for (let idx = 0; idx < len; ++idx) {
      const row = values[idx];
      for (let i = 0; i < n; ++i) {
        cols[i][idx] = row[names[i]];
      }
    }
  } else if (names) {
    names.forEach(add);
  }

  return columns;
}

function fromIterable(values, names) {
  const columns = {};
  const add = name => columns[name] = [];

  let cols;
  let n;
  for (const row of values) {
    if (!cols) {
      names = names || Object.keys(row);
      cols = names.map(add);
      n = cols.length;
    }
    for (let i = 0; i < n; ++i) {
      cols[i].push(row[names[i]]);
    }
  }

  if (!cols && names) {
    names.forEach(add);
  }

  return columns;
}

/***/ }),

/***/ "../../node_modules/arquero/src/table/index.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/table/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   from: () => (/* binding */ from),
/* harmony export */   table: () => (/* binding */ table)
/* harmony export */ });
/* harmony import */ var _column_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./column-table */ "../../node_modules/arquero/src/table/column-table.js");
/* harmony import */ var _verbs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../verbs */ "../../node_modules/arquero/src/verbs/index.js");



// Add verb implementations to ColumnTable prototype
Object.assign(_column_table__WEBPACK_IMPORTED_MODULE_0__["default"].prototype, _verbs__WEBPACK_IMPORTED_MODULE_1__["default"]);

/**
 * Create a new table for a set of named columns.
 * @param {object|Map} columns
 *  The set of named column arrays. Keys are column names.
 *  The enumeration order of the keys determines the column indices,
 *  unless the names parameter is specified.
 *  Values must be arrays (or array-like values) of identical length.
 * @param {string[]} [names] Ordered list of column names. If specified,
 *  this array determines the column indices. If not specified, the
 *  key enumeration order of the columns object is used.
 * @return {ColumnTable} the instantiated table
 * @example table({ colA: ['a', 'b', 'c'], colB: [3, 4, 5] })
 */
function table(columns, names) {
  return _column_table__WEBPACK_IMPORTED_MODULE_0__["default"].new(columns, names);
}

/**
 * Create a new table from an existing object, such as an array of
 * objects or a set of key-value pairs.
 * @param {object|Array|Map} values Data values to populate the table.
 *  If array-valued or iterable, imports rows for each non-null value,
 *  using the provided column names as keys for each row object. If no
 *  names are provided, the first non-null object's own keys are used.
 *  If object- or Map-valued, create columns for the keys and values.
 * @param {string[]} [names] Column names to include.
 *  For object or Map values, specifies the key and value column names.
 *  Otherwise, specifies the keys to look up on each row object.
 * @return {ColumnTable} the instantiated table.
 * @example from([ { colA: 1, colB: 2 }, { colA: 3, colB: 4 } ])
 */
function from(values, names) {
  return _column_table__WEBPACK_IMPORTED_MODULE_0__["default"].from(values, names);
}

/***/ }),

/***/ "../../node_modules/arquero/src/table/regroup.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/table/regroup.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   nest: () => (/* binding */ nest),
/* harmony export */   regroup: () => (/* binding */ regroup),
/* harmony export */   reindex: () => (/* binding */ reindex)
/* harmony export */ });
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../op/op-api */ "../../node_modules/arquero/src/op/op-api.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_unique_name__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/unique-name */ "../../node_modules/arquero/src/util/unique-name.js");




/**
 * Regroup table rows in response to a BitSet filter.
 * @param {GroupBySpec} groups The current groupby specification.
 * @param {BitSet} filter The filter to apply.
 */
function regroup(groups, filter) {
  if (!groups || !filter) return groups;

  // check for presence of rows for each group
  const { keys, rows, size } = groups;
  const map = new Int32Array(size);
  filter.scan(row => map[keys[row]] = 1);

  // check sum, exit early if all groups occur
  const sum = map.reduce((sum, val) => sum + val, 0);
  if (sum === size) return groups;

  // create group index map, filter exemplar rows
  const _rows = Array(sum);
  let _size = 0;
  for (let i = 0; i < size; ++i) {
    if (map[i]) _rows[map[i] = _size++] = rows[i];
  }

  // re-index the group keys
  const _keys = new Uint32Array(keys.length);
  filter.scan(row => _keys[row] = map[keys[row]]);

  return { ...groups, keys: _keys, rows: _rows, size: _size };
}

/**
 * Regroup table rows in response to a re-indexing.
 * This operation may or may not involve filtering of rows.
 * @param {GroupBySpec} groups The current groupby specification.
 * @param {Function} scan Function to scan new row indices.
 * @param {boolean} filter Flag indicating if filtering may occur.
 * @param {number} nrows The number of rows in the new table.
 */
function reindex(groups, scan, filter, nrows) {
  const { keys, rows, size } = groups;
  let _rows = rows;
  let _size = size;
  let map = null;

  if (filter) {
    // check for presence of rows for each group
    map = new Int32Array(size);
    scan(row => map[keys[row]] = 1);

    // check sum, regroup if not all groups occur
    const sum = map.reduce((sum, val) => sum + val, 0);
    if (sum !== size) {
      // create group index map, filter exemplar rows
      _rows = Array(sum);
      _size = 0;
      for (let i = 0; i < size; ++i) {
        if (map[i]) _rows[map[i] = _size++] = rows[i];
      }
    }
  }

  // re-index the group keys
  let r = -1;
  const _keys = new Uint32Array(nrows);
  const fn = _size !== size
    ? row => _keys[++r] = map[keys[row]]
    : row => _keys[++r] = keys[row];
  scan(fn);

  return { ...groups, keys: _keys, rows: _rows, size: _size };
}

function nest(table, idx, obj, type) {
  const agg = type === 'map' || type === true ? _op_op_api__WEBPACK_IMPORTED_MODULE_0__.map_agg
    : type === 'entries' ? _op_op_api__WEBPACK_IMPORTED_MODULE_0__.entries_agg
    : type === 'object' ? _op_op_api__WEBPACK_IMPORTED_MODULE_0__.object_agg
    : (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('groups option must be "map", "entries", or "object".');

  const { names } = table.groups();
  const col = (0,_util_unique_name__WEBPACK_IMPORTED_MODULE_2__["default"])(table.columnNames(), '_');

  // create table with one column of row objects
  // then aggregate into per-group arrays
  let t = table
    .select()
    .reify(idx)
    .create({ data: { [col]: obj } })
    .rollup({ [col]: (0,_op_op_api__WEBPACK_IMPORTED_MODULE_0__.array_agg)(col) });

  // create nested structures for each level of grouping
  for (let i = names.length; --i >= 0;) {
    t = t
      .groupby(names.slice(0, i))
      .rollup({ [col]: agg(names[i], col) });
  }

  // return the final aggregated structure
  return t.get(col);
}

/***/ }),

/***/ "../../node_modules/arquero/src/table/table.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/table/table.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Table)
/* harmony export */ });
/* harmony import */ var _transformable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./transformable */ "../../node_modules/arquero/src/table/transformable.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_repeat__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/repeat */ "../../node_modules/arquero/src/util/repeat.js");





/**
 * Abstract class representing a data table.
 */
class Table extends _transformable__WEBPACK_IMPORTED_MODULE_0__["default"] {

  /**
   * Instantiate a new Table instance.
   * @param {string[]} names An ordered list of column names.
   * @param {number} nrows The number of rows.
   * @param {TableData} data The backing data, which can vary by implementation.
   * @param {BitSet} [filter] A bit mask for which rows to include.
   * @param {GroupBySpec} [groups] A groupby specification for grouping ows.
   * @param {RowComparator} [order] A comparator function for sorting rows.
   * @param {Params} [params] Parameter values for table expressions.
   */
  constructor(names, nrows, data, filter, groups, order, params) {
    super(params);
    this._names = Object.freeze(names);
    this._data = data;
    this._total = nrows;
    this._nrows = filter ? filter.count() : nrows;
    this._mask = (nrows !== this._nrows && filter) || null;
    this._group = groups || null;
    this._order = order || null;
  }

  /**
   * Create a new table with the same type as this table.
   * The new table may have different data, filter, grouping, or ordering
   * based on the values of the optional configuration argument. If a
   * setting is not specified, it is inherited from the current table.
   * @param {CreateOptions} [options] Creation options for the new table.
   * @return {this} A newly created table.
   */
  create(options) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Provide an informative object string tag.
   */
  get [Symbol.toStringTag]() {
    if (!this._names) return 'Object'; // bail if called on prototype
    const nr = this.numRows() + ' row' + (this.numRows() !== 1 ? 's' : '');
    const nc = this.numCols() + ' col' + (this.numCols() !== 1 ? 's' : '');
    return `Table: ${nc} x ${nr}`
      + (this.isFiltered() ? ` (${this.totalRows()} backing)` : '')
      + (this.isGrouped() ? `, ${this._group.size} groups` : '')
      + (this.isOrdered() ? ', ordered' : '');
  }

  /**
   * Indicates if the table has a filter applied.
   * @return {boolean} True if filtered, false otherwise.
   */
  isFiltered() {
    return !!this._mask;
  }

  /**
   * Indicates if the table has a groupby specification.
   * @return {boolean} True if grouped, false otherwise.
   */
  isGrouped() {
    return !!this._group;
  }

  /**
   * Indicates if the table has a row order comparator.
   * @return {boolean} True if ordered, false otherwise.
   */
  isOrdered() {
    return !!this._order;
  }

  /**
   * Returns the internal table storage data structure.
   * @return {TableData} The backing table storage data structure.
   */
  data() {
    return this._data;
  }

  /**
   * Returns the filter bitset mask, if defined.
   * @return {BitSet} The filter bitset mask.
   */
  mask() {
    return this._mask;
  }

  /**
   * Returns the groupby specification, if defined.
   * @return {GroupBySpec} The groupby specification.
   */
  groups() {
    return this._group;
  }

  /**
   * Returns the row order comparator function, if specified.
   * @return {RowComparator} The row order comparator function.
   */
  comparator() {
    return this._order;
  }

  /**
   * The total number of rows in this table, counting both
   * filtered and unfiltered rows.
   * @return {number} The number of total rows.
   */
  totalRows() {
    return this._total;
  }

  /**
   * The number of active rows in this table. This number may be
   * less than the total rows if the table has been filtered.
   * @see Table.totalRows
   * @return {number} The number of rows.
   */
  numRows() {
    return this._nrows;
  }

  /**
   * The number of active rows in this table. This number may be
   * less than the total rows if the table has been filtered.
   * @see Table.totalRows
   * @return {number} The number of rows.
   */
  get size() {
    return this._nrows;
  }

  /**
   * The number of columns in this table.
   * @return {number} The number of columns.
   */
  numCols() {
    return this._names.length;
  }

  /**
   * Filter function invoked for each column name.
   * @callback NameFilter
   * @param {string} name The column name.
   * @param {number} index The column index.
   * @param {string[]} array The array of names.
   * @return {boolean} Returns true to retain the column name.
   */

  /**
   * The table column names, optionally filtered.
   * @param {NameFilter} [filter] An optional filter function.
   *  If unspecified, all column names are returned.
   * @return {string[]} An array of matching column names.
   */
  columnNames(filter) {
    return filter ? this._names.filter(filter) : this._names.slice();
  }

  /**
   * The column name at the given index.
   * @param {number} index The column index.
   * @return {string} The column name,
   *  or undefined if the index is out of range.
   */
  columnName(index) {
    return this._names[index];
  }

  /**
   * The column index for the given name.
   * @param {string} name The column name.
   * @return {number} The column index, or -1 if the name is not found.
   */
  columnIndex(name) {
    return this._names.indexOf(name);
  }

  /**
   * Deprecated alias for the table array() method: use table.array()
   * instead. Get an array of values contained in a column. The resulting
   * array respects any table filter or orderby criteria.
   * @param {string} name The column name.
   * @param {ArrayConstructor|TypedArrayConstructor} [constructor=Array]
   *  The array constructor for instantiating the output array.
   * @return {DataValue[]|TypedArray} The array of column values.
   */
  columnArray(name, constructor) {
    return this.array(name, constructor);
  }

  /**
   * Get an array of values contained in a column. The resulting array
   * respects any table filter or orderby criteria.
   * @param {string} name The column name.
   * @param {ArrayConstructor|TypedArrayConstructor} [constructor=Array]
   *  The array constructor for instantiating the output array.
   * @return {DataValue[]|TypedArray} The array of column values.
   */
  array(name, constructor) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an iterator over column values.
   * @return {Iterator<object>} An iterator over row objects.
   */
  *values(name) {
    const get = this.getter(name);
    const n = this.numRows();
    for (let i = 0; i < n; ++i) {
      yield get(i);
    }
  }

  /**
   * Get the value for the given column and row.
   * @param {string} name The column name.
   * @param {number} [row=0] The row index, defaults to zero if not specified.
   * @return {DataValue} The data value at (column, row).
   */
  get(name, row = 0) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an accessor ("getter") function for a column. The returned
   * function takes a row index as its single argument and returns the
   * corresponding column value.
   * @param {string} name The column name.
   * @return {ColumnGetter} The column getter function.
   */
  getter(name) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an array of objects representing table rows.
   * @param {ObjectsOptions} [options] The options for row object generation.
   * @return {RowObject[]} An array of row objects.
   */
  objects(options) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an object representing a table row.
   * @param {number} [row=0] The row index, defaults to zero if not specified.
   * @return {object} A row object with named properties for each column.
   */
   object(row) { // eslint-disable-line no-unused-vars
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Returns an iterator over objects representing table rows.
   * @return {Iterator<object>} An iterator over row objects.
   */
  [Symbol.iterator]() {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Not implemented');
  }

  /**
   * Print the contents of this table using the console.table() method.
   * @param {PrintOptions|number} options The options for row object
   *  generation, determining which rows and columns are printed. If
   *  number-valued, specifies the row limit.
   */
  print(options = {}) {
    if ((0,_util_is_number__WEBPACK_IMPORTED_MODULE_2__["default"])(options)) {
      options = { limit: options };
    } else if (options.limit == null) {
      options.limit = 10;
    }

    const obj = this.objects({ ...options, grouped: false });
    const msg = `${this[Symbol.toStringTag]}. Showing ${obj.length} rows.`;

    console.log(msg);   // eslint-disable-line no-console
    console.table(obj); // eslint-disable-line no-console
  }

  /**
   * Returns an array of indices for all rows passing the table filter.
   * @param {boolean} [order=true] A flag indicating if the returned
   *  indices should be sorted if this table is ordered. If false, the
   *  returned indices may or may not be sorted.
   * @return {Uint32Array} An array of row indices.
   */
  indices(order = true) {
    if (this._index) return this._index;

    const n = this.numRows();
    const index = new Uint32Array(n);
    const ordered = this.isOrdered();
    const bits = this.mask();
    let row = -1;

    // inline the following for performance:
    // this.scan(row => index[++i] = row);
    if (bits) {
      for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
        index[++row] = i;
      }
    } else {
      for (let i = 0; i < n; ++i) {
        index[++row] = i;
      }
    }

    // sort index vector
    if (order && ordered) {
      const compare = this._order;
      const data = this._data;
      index.sort((a, b) => compare(a, b, data));
    }

    // save indices if they reflect table metadata
    if (order || !ordered) {
      this._index = index;
    }

    return index;
  }

  /**
   * Returns an array of indices for each group in the table.
   * If the table is not grouped, the result is the same as
   * {@link indices}, but wrapped within an array.
   * @param {boolean} [order=true] A flag indicating if the returned
   *  indices should be sorted if this table is ordered. If false, the
   *  returned indices may or may not be sorted.
   * @return {number[][]} An array of row index arrays, one per group.
   *  The indices will be filtered if the table is filtered.
   */
  partitions(order = true) {
    // return partitions if already generated
    if (this._partitions) {
      return this._partitions;
    }

    // if not grouped, return a single partition
    if (!this.isGrouped()) {
      return [ this.indices(order) ];
    }

    // generate partitions
    const { keys, size } = this._group;
    const part = (0,_util_repeat__WEBPACK_IMPORTED_MODULE_3__["default"])(size, () => []);

    // populate partitions, don't sort if indices don't exist
    // inline the following for performance:
    // this.scan(row => part[keys[row]].push(row), sort);
    const sort = this._index;
    const bits = this.mask();
    const n = this.numRows();
    if (sort && this.isOrdered()) {
      for (let i = 0, r; i < n; ++i) {
        r = sort[i];
        part[keys[r]].push(r);
      }
    } else if (bits) {
      for (let i = bits.next(0); i >= 0; i = bits.next(i + 1)) {
        part[keys[i]].push(i);
      }
    } else {
      for (let i = 0; i < n; ++i) {
        part[keys[i]].push(i);
      }
    }

    // if ordered but not yet sorted, sort partitions directly
    if (order && !sort && this.isOrdered()) {
      const compare = this._order;
      const data = this._data;
      for (let i = 0; i < size; ++i) {
        part[i].sort((a, b) => compare(a, b, data));
      }
    }

    // save partitions if they reflect table metadata
    if (order || !this.isOrdered()) {
      this._partitions = part;
    }

    return part;
  }

  /**
   * Callback function to cancel a table scan.
   * @callback ScanStop
   * @return {void}
   */

  /**
   * Callback function invoked for each row of a table scan.
   * @callback ScanVisitor
   * @param {number} [row] The table row index.
   * @param {TableData} [data] The backing table data store.
   * @param {ScanStop} [stop] Function to stop the scan early.
   *  Callees can invoke this function to prevent future calls.
   * @return {void}
   */

  /**
   * Perform a table scan, visiting each row of the table.
   * If this table is filtered, only rows passing the filter are visited.
   * @param {ScanVisitor} fn Callback invoked for each row of the table.
   * @param {boolean} [order=false] Indicates if the table should be
   *  scanned in the order determined by {@link Table#orderby}. This
   *  argument has no effect if the table is unordered.
   * @property {number} [limit=Infinity] The maximum number of objects to create.
   * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
   */
  scan(fn, order, limit = Infinity, offset = 0) {
    const filter = this._mask;
    const nrows = this._nrows;
    const data = this._data;

    let i = offset || 0;
    if (i > nrows) return;

    const n = Math.min(nrows, i + limit);
    const stop = () => i = this._total;

    if (order && this.isOrdered() || filter && this._index) {
      const index = this.indices();
      const data = this._data;
      for (; i < n; ++i) {
        fn(index[i], data, stop);
      }
    } else if (filter) {
      let c = n - i + 1;
      for (i = filter.nth(i); --c && i > -1; i = filter.next(i + 1)) {
        fn(i, data, stop);
      }
    } else {
      for (; i < n; ++i) {
        fn(i, data, stop);
      }
    }
  }

  /**
   * Extract rows with indices from start to end (end not included), where
   * start and end represent per-group ordered row numbers in the table.
   * @param {number} [start] Zero-based index at which to start extraction.
   *  A negative index indicates an offset from the end of the group.
   *  If start is undefined, slice starts from the index 0.
   * @param {number} [end] Zero-based index before which to end extraction.
   *  A negative index indicates an offset from the end of the group.
   *  If end is omitted, slice extracts through the end of the group.
   * @return {this} A new table with sliced rows.
   * @example table.slice(1, -1)
   */
  slice(start = 0, end = Infinity) {
    if (this.isGrouped()) return super.slice(start, end);

    // if not grouped, scan table directly
    const indices = [];
    const nrows = this.numRows();
    start = Math.max(0, start + (start < 0 ? nrows : 0));
    end = Math.min(nrows, Math.max(0, end + (end < 0 ? nrows : 0)));
    this.scan(row => indices.push(row), true, end - start, start);
    return this.reify(indices);
  }

  /**
   * Reduce a table, processing all rows to produce a new table.
   * To produce standard aggregate summaries, use {@link rollup}.
   * This method allows the use of custom reducer implementations,
   * for example to produce multiple rows for an aggregate.
   * @param {Reducer} reducer The reducer to apply.
   * @return {Table} A new table of reducer outputs.
   */
  reduce(reducer) {
    return this.__reduce(this, reducer);
  }
}

/**
 * A typed array constructor.
 * @typedef {Uint8ArrayConstructor|Uint16ArrayConstructor|Uint32ArrayConstructor|BigUint64ArrayConstructor|Int8ArrayConstructor|Int16ArrayConstructor|Int32ArrayConstructor|BigInt64ArrayConstructor|Float32ArrayConstructor|Float64ArrayConstructor} TypedArrayConstructor
 */

/**
 * A typed array instance.
 * @typedef {Uint8Array|Uint16Array|Uint32Array|BigUint64Array|Int8Array|Int16Array|Int32Array|BigInt64Array|Float32Array|Float64Array} TypedArray
 */

/**
 * Backing table data.
 * @typedef {object|Array} TableData
 */

/**
 * Table value.
 * @typedef {*} DataValue
 */

/**
 * Table row object.
 * @typedef {Object.<string, DataValue>} RowObject
 */

/**
 * Table expression parameters.
 * @typedef {import('./transformable').Params} Params
 */

/**
 * Proxy type for BitSet class.
 * @typedef {import('./bit-set').default} BitSet
 */

/**
 * A table groupby specification.
 * @typedef {object} GroupBySpec
 * @property {number} size The number of groups.
 * @property {string[]} names Column names for each group.
 * @property {RowExpression[]} get Value accessor functions for each group.
 * @property {number[]} rows Indices of an example table row for each group.
 * @property {number[]} keys Per-row group indices, length is total rows of table.
 */

/**
 * Column value accessor.
 * @callback ColumnGetter
 * @param {number} [row] The table row.
 * @return {DataValue}
 */

/**
 * An expression evaluated over a table row.
 * @callback RowExpression
 * @param {number} [row] The table row.
 * @param {TableData} [data] The backing table data store.
 * @return {DataValue}
 */

/**
 * Comparator function for sorting table rows.
 * @callback RowComparator
 * @param {number} rowA The table row index for the first row.
 * @param {number} rowB The table row index for the second row.
 * @param {TableData} data The backing table data store.
 * @return {number} Negative if rowA < rowB, positive if
 *  rowA > rowB, otherwise zero.
 */

/**
 * Options for derived table creation.
 * @typedef {object} CreateOptions
 * @property {TableData} [data] The backing column data.
 * @property {string[]} [names] An ordered list of column names.
 * @property {BitSet} [filter] An additional filter BitSet to apply.
 * @property {GroupBySpec} [groups] The groupby specification to use, or null for no groups.
 * @property {RowComparator} [order] The orderby comparator function to use, or null for no order.
 */

/**
 * Options for generating row objects.
 * @typedef {object} PrintOptions
 * @property {number} [limit=Infinity] The maximum number of objects to create.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('../table/transformable').Select} [columns]
 *  An ordered set of columns to include. The input may consist of column name
 *  strings, column integer indices, objects with current column names as keys
 *  and new column names as values (for renaming), or selection helper
 *  functions such as {@link all}, {@link not}, or {@link range}.
 */

/**
 * Options for generating row objects.
 * @typedef {object} ObjectsOptions
 * @property {number} [limit=Infinity] The maximum number of objects to create.
 * @property {number} [offset=0] The row offset indicating how many initial rows to skip.
 * @property {import('../table/transformable').Select} [columns]
 *  An ordered set of columns to include. The input may consist of column name
 *  strings, column integer indices, objects with current column names as keys
 *  and new column names as values (for renaming), or selection helper
 *  functions such as {@link all}, {@link not}, or {@link range}.
 * @property {'map'|'entries'|'object'|boolean} [grouped=false]
 *  The export format for groups of rows. The default (false) is to ignore
 *  groups, returning a flat array of objects. The valid values are 'map' or
 *  true (for Map instances), 'object' (for standard objects), or 'entries'
 *  (for arrays in the style of Object.entries). For the 'object' format,
 *  groupby keys are coerced to strings to use as object property names; note
 *  that this can lead to undesirable behavior if the groupby keys are object
 *  values. The 'map' and 'entries' options preserve the groupby key values.
 */


/***/ }),

/***/ "../../node_modules/arquero/src/table/transformable.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/table/transformable.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Transformable)
/* harmony export */ });
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");
/* harmony import */ var _helpers_slice__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/slice */ "../../node_modules/arquero/src/helpers/slice.js");



/**
 * Abstract base class for transforming data.
 */
class Transformable {

  /**
   * Instantiate a new Transformable instance.
   * @param {Params} [params] The parameter values.
   */
  constructor(params) {
    if (params) this._params = params;
  }

  /**
   * Get or set table expression parameter values.
   * If called with no arguments, returns the current parameter values
   * as an object. Otherwise, adds the provided parameters to this
   * table's parameter set and returns the table. Any prior parameters
   * with names matching the input parameters are overridden.
   * @param {Params} [values] The parameter values.
   * @return {this|Params} The current parameters values (if called with
   *  no arguments) or this table.
   */
  params(values) {
    if (arguments.length) {
      if (values) {
        this._params = { ...this._params, ...values };
      }
      return this;
    } else {
      return this._params;
    }
  }

  /**
   * Create a new fully-materialized instance of this table.
   * All filter and orderby settings are removed from the new table.
   * Instead, the backing data itself is filtered and ordered as needed.
   * @param {number[]} [indices] Ordered row indices to materialize.
   *  If unspecified, all rows passing the table filter are used.
   * @return {this} A reified table.
   */
  reify(indices) {
    return this.__reify(this, indices);
  }

  // -- Transformation Verbs ------------------------------------------------

  /**
   * Count the number of values in a group. This method is a shorthand
   * for {@link Transformable#rollup} with a count aggregate function.
   * @param {CountOptions} [options] Options for the count.
   * @return {this} A new table with groupby and count columns.
   * @example table.groupby('colA').count()
   * @example table.groupby('colA').count({ as: 'num' })
   */
  count(options) {
    return this.__count(this, options);
  }

  /**
   * Derive new column values based on the provided expressions. By default,
   * new columns are added after (higher indices than) existing columns. Use
   * the before or after options to place new columns elsewhere.
   * @param {ExprObject} values Object of name-value pairs defining the
   *  columns to derive. The input object should have output column
   *  names for keys and table expressions for values.
   * @param {DeriveOptions} [options] Options for dropping or relocating
   *  derived columns. Use either a before or after property to indicate
   *  where to place derived columns. Specifying both before and after is an
   *  error. Unlike the relocate verb, this option affects only new columns;
   *  updated columns with existing names are excluded from relocation.
   * @return {this} A new table with derived columns added.
   * @example table.derive({ sumXY: d => d.x + d.y })
   * @example table.derive({ z: d => d.x * d.y }, { before: 'x' })
   */
  derive(values, options) {
    return this.__derive(this, values, options);
  }

  /**
   * Filter a table to a subset of rows based on the input criteria.
   * The resulting table provides a filtered view over the original data; no
   * data copy is made. To create a table that copies only filtered data to
   * new data structures, call {@link Transformable#reify} on the output table.
   * @param {TableExpr} criteria Filter criteria as a table expression.
   *  Both aggregate and window functions are permitted, taking into account
   *  {@link Transformable#groupby} or {@link Transformable#orderby} settings.
   * @return {this} A new table with filtered rows.
   * @example table.filter(d => abs(d.value) < 5)
   */
  filter(criteria) {
    return this.__filter(this, criteria);
  }

  /**
   * Extract rows with indices from start to end (end not included), where
   * start and end represent per-group ordered row numbers in the table.
   * @param {number} [start] Zero-based index at which to start extraction.
   *  A negative index indicates an offset from the end of the group.
   *  If start is undefined, slice starts from the index 0.
   * @param {number} [end] Zero-based index before which to end extraction.
   *  A negative index indicates an offset from the end of the group.
   *  If end is omitted, slice extracts through the end of the group.
   * @return {this} A new table with sliced rows.
   * @example table.slice(1, -1)
   */
  slice(start, end) {
    return this.filter((0,_helpers_slice__WEBPACK_IMPORTED_MODULE_1__["default"])(start, end)).reify();
  }

  /**
   * Group table rows based on a set of column values.
   * Subsequent operations that are sensitive to grouping (such as
   * aggregate functions) will operate over the grouped rows.
   * To undo grouping, use {@link Transformable#ungroup}.
   * @param  {...ExprList} keys Key column values to group by.
   *  The keys may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @return {this} A new table with grouped rows.
   * @example table.groupby('colA', 'colB')
   * @example table.groupby({ key: d => d.colA + d.colB })
   */
  groupby(...keys) {
    return this.__groupby(this, keys.flat());
  }

  /**
   * Order table rows based on a set of column values.
   * Subsequent operations sensitive to ordering (such as window functions)
   * will operate over sorted values.
   * The resulting table provides an view over the original data, without
   * any copying. To create a table with sorted data copied to new data
   * strucures, call {@link Transformable#reify} on the result of this method.
   * To undo ordering, use {@link Transformable#unorder}.
   * @param  {...OrderKeys} keys Key values to sort by, in precedence order.
   *  By default, sorting is done in ascending order.
   *  To sort in descending order, wrap values using {@link desc}.
   *  If a string, order by the column with that name.
   *  If a number, order by the column with that index.
   *  If a function, must be a valid table expression; aggregate functions
   *  are permitted, but window functions are not.
   *  If an object, object values must be valid values parameters
   *  with output column names for keys and table expressions
   *  for values (the output names will be ignored).
   *  If an array, array values must be valid key parameters.
   * @return {this} A new ordered table.
   * @example table.orderby('a', desc('b'))
   * @example table.orderby({ a: 'a', b: desc('b') )})
   * @example table.orderby(desc(d => d.a))
   */
  orderby(...keys) {
    return this.__orderby(this, keys.flat());
  }

  /**
   * Relocate a subset of columns to change their positions, also
   * potentially renaming them.
   * @param {Selection} columns An ordered selection of columns to relocate.
   *  The input may consist of column name strings, column integer indices,
   *  rename objects with current column names as keys and new column names
   *  as values, or functions that take a table as input and returns a valid
   *  selection parameter (typically the output of selection helper functions
   *  such as {@link all}, {@link not}, or {@link range}).
   * @param {RelocateOptions} options Options for relocating. Must include
   *  either the before or after property to indicate where to place the
   *  relocated columns. Specifying both before and after is an error.
   * @return {this} A new table with relocated columns.
   * @example table.relocate(['colY', 'colZ'], { after: 'colX' })
   * @example table.relocate(not('colB', 'colC'), { before: 'colA' })
   * @example table.relocate({ colA: 'newA', colB: 'newB' }, { after: 'colC' })
   */
  relocate(columns, options) {
    return this.__relocate(this, (0,_util_to_array__WEBPACK_IMPORTED_MODULE_0__["default"])(columns), options);
  }

  /**
   * Rename one or more columns, preserving column order.
   * @param {...Select} columns One or more rename objects with current
   *  column names as keys and new column names as values.
   * @return {this} A new table with renamed columns.
   * @example table.rename({ oldName: 'newName' })
   * @example table.rename({ a: 'a2', b: 'b2' })
   */
  rename(...columns) {
    return this.__rename(this, columns.flat());
  }

  /**
   * Rollup a table to produce an aggregate summary.
   * Often used in conjunction with {@link Transformable#groupby}.
   * To produce counts only, {@link Transformable#count} is a shortcut.
   * @param {ExprObject} [values] Object of name-value pairs defining aggregate
   *  output columns. The input object should have output column names for
   *  keys and table expressions for values. The expressions must be valid
   *  aggregate expressions: window functions are not allowed and column
   *  references must be arguments to aggregate functions.
   * @return {this} A new table of aggregate summary values.
   * @example table.groupby('colA').rollup({ mean: d => mean(d.colB) })
   * @example table.groupby('colA').rollup({ mean: op.median('colB') })
   */
  rollup(values) {
    return this.__rollup(this, values);
  }

  /**
   * Generate a table from a random sample of rows.
   * If the table is grouped, performs a stratified sample by
   * sampling from each group separately.
   * @param {number|TableExpr} size The number of samples to draw per group.
   *  If number-valued, the same sample size is used for each group.
   *  If function-valued, the input should be an aggregate table
   *  expression compatible with {@link Transformable#rollup}.
   * @param {SampleOptions} [options] Options for sampling.
   * @return {this} A new table with sampled rows.
   * @example table.sample(50)
   * @example table.sample(100, { replace: true })
   * @example table.groupby('colA').sample(() => op.floor(0.5 * op.count()))
   */
  sample(size, options) {
    return this.__sample(this, size, options);
  }

  /**
   * Select a subset of columns into a new table, potentially renaming them.
   * @param {...Select} columns An ordered selection of columns.
   *  The input may consist of column name strings, column integer indices,
   *  rename objects with current column names as keys and new column names
   *  as values, or functions that take a table as input and returns a valid
   *  selection parameter (typically the output of selection helper functions
   *  such as {@link all}, {@link not}, or {@link range}).
   * @return {this} A new table of selected columns.
   * @example table.select('colA', 'colB')
   * @example table.select(not('colB', 'colC'))
   * @example table.select({ colA: 'newA', colB: 'newB' })
   */
  select(...columns) {
    return this.__select(this, columns.flat());
  }

  /**
   * Ungroup a table, removing any grouping criteria.
   * Undoes the effects of {@link Transformable#groupby}.
   * @return {this} A new ungrouped table, or this table if not grouped.
   * @example table.ungroup()
   */
  ungroup() {
    return this.__ungroup(this);
  }

  /**
   * Unorder a table, removing any sorting criteria.
   * Undoes the effects of {@link Transformable#orderby}.
   * @return {this} A new unordered table, or this table if not ordered.
   * @example table.unorder()
   */
  unorder() {
    return this.__unorder(this);
  }

  // -- Cleaning Verbs ------------------------------------------------------

  /**
   * De-duplicate table rows by removing repeated row values.
   * @param {...ExprList} keys Key columns to check for duplicates.
   *  Two rows are considered duplicates if they have matching values for
   *  all keys. If keys are unspecified, all columns are used.
   *  The keys may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @return {this} A new de-duplicated table.
   * @example table.dedupe()
   * @example table.dedupe('a', 'b')
   * @example table.dedupe({ abs: d => op.abs(d.a) })
   */
  dedupe(...keys) {
    return this.__dedupe(this, keys.flat());
  }

  /**
   * Impute missing values or rows. Accepts a set of column-expression pairs
   * and evaluates the expressions to replace any missing (null, undefined,
   * or NaN) values in the original column.
   * If the expand option is specified, imputes new rows for missing
   * combinations of values. All combinations of key values (a full cross
   * product) are considered for each level of grouping (specified by
   * {@link Transformable#groupby}). New rows will be added for any combination
   * of key and groupby values not already contained in the table. For all
   * non-key and non-group columns the new rows are populated with imputation
   * values (first argument) if specified, otherwise undefined.
   * If the expand option is specified, any filter or orderby settings are
   * removed from the output table, but groupby settings persist.
   * @param {ExprObject} values Object of name-value pairs for the column values
   *  to impute. The input object should have existing column names for keys
   *  and table expressions for values. The expressions will be evaluated to
   *  determine replacements for any missing values.
   * @param {ImputeOptions} [options] Imputation options. The expand
   *  property specifies a set of column values to consider for imputing
   *  missing rows. All combinations of expanded values are considered, and
   *  new rows are added for each combination that does not appear in the
   *  input table.
   * @return {this} A new table with imputed values and/or rows.
   * @example table.impute({ v: () => 0 })
   * @example table.impute({ v: d => op.mean(d.v) })
   * @example table.impute({ v: () => 0 }, { expand: ['x', 'y'] })
   */
  impute(values, options) {
    return this.__impute(this, values, options);
  }

  // -- Reshaping Verbs -----------------------------------------------------

  /**
   * Fold one or more columns into two key-value pair columns.
   * The fold transform is an inverse of the {@link Transformable#pivot} transform.
   * The resulting table has two new columns, one containing the column
   * names (named "key") and the other the column values (named "value").
   * The number of output rows equals the original row count multiplied
   * by the number of folded columns.
   * @param {ExprList} values The columns to fold.
   *  The columns may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @param {FoldOptions} [options] Options for folding.
   * @return {this} A new folded table.
   * @example table.fold('colA')
   * @example table.fold(['colA', 'colB'])
   * @example table.fold(range(5, 8))
   */
  fold(values, options) {
    return this.__fold(this, values, options);
  }

  /**
   * Pivot columns into a cross-tabulation.
   * The pivot transform is an inverse of the {@link Transformable#fold} transform.
   * The resulting table has new columns for each unique combination
   * of the provided *keys*, populated with the provided *values*.
   * The provided *values* must be aggregates, as a single set of keys may
   * include more than one row. If string-valued, the *any* aggregate is used.
   * If only one *values* column is defined, the new pivoted columns will
   * be named using key values directly. Otherwise, input value column names
   * will be included as a component of the output column names.
   * @param {ExprList} keys Key values to map to new column names.
   *  The keys may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @param {ExprList} values Output values for pivoted columns.
   *  Column references will be wrapped in an *any* aggregate.
   *  If object-valued, the input object should have output value
   *  names for keys and aggregate table expressions for values.
   * @param {PivotOptions} [options] Options for pivoting.
   * @return {this} A new pivoted table.
   * @example table.pivot('key', 'value')
   * @example table.pivot(['keyA', 'keyB'], ['valueA', 'valueB'])
   * @example table.pivot({ key: d => d.key }, { value: d => sum(d.value) })
   */
  pivot(keys, values, options) {
    return this.__pivot(this, keys, values, options);
  }

  /**
   * Spread array elements into a set of new columns.
   * Output columns are named based on the value key and array index.
   * @param {ExprList} values The column values to spread.
   *  The values may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @param {SpreadOptions} [options] Options for spreading.
   * @return {this} A new table with the spread columns added.
   * @example table.spread({ a: split(d.text, '') })
   * @example table.spread('arrayCol', { limit: 100 })
   */
  spread(values, options) {
    return this.__spread(this, values, options);
  }

  /**
   * Unroll one or more array-valued columns into new rows.
   * If more than one array value is used, the number of new rows
   * is the smaller of the limit and the largest length.
   * Values for all other columns are copied over.
   * @param {ExprList} values The column values to unroll.
   *  The values may be specified using column name strings, column index
   *  numbers, value objects with output column names for keys and table
   *  expressions for values, or selection helper functions.
   * @param {UnrollOptions} [options] Options for unrolling.
   * @return {this} A new unrolled table.
   * @example table.unroll('colA', { limit: 1000 })
   */
  unroll(values, options) {
    return this.__unroll(this, values, options);
  }

  // -- Joins ---------------------------------------------------------------

  /**
   * Lookup values from a secondary table and add them as new columns.
   * A lookup occurs upon matching key values for rows in both tables.
   * If the secondary table has multiple rows with the same key, only
   * the last observed instance will be considered in the lookup.
   * Lookup is similar to {@link Transformable#join_left}, but with a simpler
   * syntax and the added constraint of allowing at most one match only.
   * @param {TableRef} other The secondary table to look up values from.
   * @param {JoinKeys} [on] Lookup keys (column name strings or table
   *  expressions) for this table and the secondary table, respectively.
   * @param {...ExprList} values The column values to add from the
   *  secondary table. Can be column name strings or objects with column
   *  names as keys and table expressions as values.
   * @return {this} A new table with lookup values added.
   * @example table.lookup(other, ['key1', 'key2'], 'value1', 'value2')
   */
  lookup(other, on, ...values) {
    return this.__lookup(this, other, on, values.flat());
  }

  /**
   * Join two tables, extending the columns of one table with
   * values from the other table. The current table is considered
   * the "left" table in the join, and the new table input is
   * considered the "right" table in the join. By default an inner
   * join is performed, removing all rows that do not match the
   * join criteria. To perform left, right, or full outer joins, use
   * the {@link Transformable#join_left}, {@link Transformable#join_right}, or
   * {@link Transformable#join_full} methods, or provide an options argument.
   * @param {TableRef} other The other (right) table to join with.
   * @param {JoinPredicate} [on] The join criteria for matching table rows.
   *  If unspecified, the values of all columns with matching names
   *  are compared.
   *  If array-valued, a two-element array should be provided, containing
   *  the columns to compare for the left and right tables, respectively.
   *  If a one-element array or a string value is provided, the same
   *  column names will be drawn from both tables.
   *  If function-valued, should be a two-table table expression that
   *  returns a boolean value. When providing a custom predicate, note that
   *  join key values can be arrays or objects, and that normal join
   *  semantics do not consider null or undefined values to be equal (that is,
   *  null !== null). Use the op.equal function to handle these cases.
   * @param {JoinValues} [values] The columns to include in the join output.
   *  If unspecified, all columns from both tables are included; paired
   *  join keys sharing the same column name are included only once.
   *  If array-valued, a two element array should be provided, containing
   *  the columns to include for the left and right tables, respectively.
   *  Array input may consist of column name strings, objects with output
   *  names as keys and single-table table expressions as values, or the
   *  selection helper functions {@link all}, {@link not}, or {@link range}.
   *  If object-valued, specifies the key-value pairs for each output,
   *  defined using two-table table expressions.
   * @param {JoinOptions} [options] Options for the join.
   * @return {this} A new joined table.
   * @example table.join(other, ['keyL', 'keyR'])
   * @example table.join(other, (a, b) => equal(a.keyL, b.keyR))
   */
  join(other, on, values, options) {
    return this.__join(this, other, on, values, options);
  }

  /**
   * Perform a left outer join on two tables. Rows in the left table
   * that do not match a row in the right table will be preserved.
   * This is a convenience method with fixed options for {@link Transformable#join}.
   * @param {TableRef} other The other (right) table to join with.
   * @param {JoinPredicate} [on] The join criteria for matching table rows.
   *  If unspecified, the values of all columns with matching names
   *  are compared.
   *  If array-valued, a two-element array should be provided, containing
   *  the columns to compare for the left and right tables, respectively.
   *  If a one-element array or a string value is provided, the same
   *  column names will be drawn from both tables.
   *  If function-valued, should be a two-table table expression that
   *  returns a boolean value. When providing a custom predicate, note that
   *  join key values can be arrays or objects, and that normal join
   *  semantics do not consider null or undefined values to be equal (that is,
   *  null !== null). Use the op.equal function to handle these cases.
   * @param {JoinValues} [values] The columns to include in the join output.
   *  If unspecified, all columns from both tables are included; paired
   *  join keys sharing the same column name are included only once.
   *  If array-valued, a two element array should be provided, containing
   *  the columns to include for the left and right tables, respectively.
   *  Array input may consist of column name strings, objects with output
   *  names as keys and single-table table expressions as values, or the
   *  selection helper functions {@link all}, {@link not}, or {@link range}.
   *  If object-valued, specifies the key-value pairs for each output,
   *  defined using two-table table expressions.
   * @param {JoinOptions} [options] Options for the join. With this method,
   *  any options will be overridden with {left: true, right: false}.
   * @return {this} A new joined table.
   * @example table.join_left(other, ['keyL', 'keyR'])
   * @example table.join_left(other, (a, b) => equal(a.keyL, b.keyR))
   */
  join_left(other, on, values, options) {
    const opt = { ...options, left: true, right: false };
    return this.__join(this, other, on, values, opt);
  }

  /**
   * Perform a right outer join on two tables. Rows in the right table
   * that do not match a row in the left table will be preserved.
   * This is a convenience method with fixed options for {@link Transformable#join}.
   * @param {TableRef} other The other (right) table to join with.
   * @param {JoinPredicate} [on] The join criteria for matching table rows.
   *  If unspecified, the values of all columns with matching names
   *  are compared.
   *  If array-valued, a two-element array should be provided, containing
   *  the columns to compare for the left and right tables, respectively.
   *  If a one-element array or a string value is provided, the same
   *  column names will be drawn from both tables.
   *  If function-valued, should be a two-table table expression that
   *  returns a boolean value. When providing a custom predicate, note that
   *  join key values can be arrays or objects, and that normal join
   *  semantics do not consider null or undefined values to be equal (that is,
   *  null !== null). Use the op.equal function to handle these cases.
   * @param {JoinValues} [values] The columns to include in the join output.
   *  If unspecified, all columns from both tables are included; paired
   *  join keys sharing the same column name are included only once.
   *  If array-valued, a two element array should be provided, containing
   *  the columns to include for the left and right tables, respectively.
   *  Array input may consist of column name strings, objects with output
   *  names as keys and single-table table expressions as values, or the
   *  selection helper functions {@link all}, {@link not}, or {@link range}.
   *  If object-valued, specifies the key-value pairs for each output,
   *  defined using two-table table expressions.
   * @param {JoinOptions} [options] Options for the join. With this method,
   *  any options will be overridden with {left: false, right: true}.
   * @return {this} A new joined table.
   * @example table.join_right(other, ['keyL', 'keyR'])
   * @example table.join_right(other, (a, b) => equal(a.keyL, b.keyR))
   */
  join_right(other, on, values, options) {
    const opt = { ...options, left: false, right: true };
    return this.__join(this, other, on, values, opt);
  }

  /**
   * Perform a full outer join on two tables. Rows in either the left or
   * right table that do not match a row in the other will be preserved.
   * This is a convenience method with fixed options for {@link Transformable#join}.
   * @param {TableRef} other The other (right) table to join with.
   * @param {JoinPredicate} [on] The join criteria for matching table rows.
   *  If unspecified, the values of all columns with matching names
   *  are compared.
   *  If array-valued, a two-element array should be provided, containing
   *  the columns to compare for the left and right tables, respectively.
   *  If a one-element array or a string value is provided, the same
   *  column names will be drawn from both tables.
   *  If function-valued, should be a two-table table expression that
   *  returns a boolean value. When providing a custom predicate, note that
   *  join key values can be arrays or objects, and that normal join
   *  semantics do not consider null or undefined values to be equal (that is,
   *  null !== null). Use the op.equal function to handle these cases.
   * @param {JoinValues} [values] The columns to include in the join output.
   *  If unspecified, all columns from both tables are included; paired
   *  join keys sharing the same column name are included only once.
   *  If array-valued, a two element array should be provided, containing
   *  the columns to include for the left and right tables, respectively.
   *  Array input may consist of column name strings, objects with output
   *  names as keys and single-table table expressions as values, or the
   *  selection helper functions {@link all}, {@link not}, or {@link range}.
   *  If object-valued, specifies the key-value pairs for each output,
   *  defined using two-table table expressions.
   * @param {JoinOptions} [options] Options for the join. With this method,
   *  any options will be overridden with {left: true, right: true}.
   * @return {this} A new joined table.
   * @example table.join_full(other, ['keyL', 'keyR'])
   * @example table.join_full(other, (a, b) => equal(a.keyL, b.keyR))
   */
  join_full(other, on, values, options) {
    const opt = { ...options, left: true, right: true };
    return this.__join(this, other, on, values, opt);
  }

  /**
   * Produce the Cartesian cross product of two tables. The output table
   * has one row for every pair of input table rows. Beware that outputs
   * may be quite large, as the number of output rows is the product of
   * the input row counts.
   * This is a convenience method for {@link Transformable#join} in which the
   * join criteria is always true.
   * @param {TableRef} other The other (right) table to join with.
   * @param {JoinValues} [values] The columns to include in the output.
   *  If unspecified, all columns from both tables are included.
   *  If array-valued, a two element array should be provided, containing
   *  the columns to include for the left and right tables, respectively.
   *  Array input may consist of column name strings, objects with output
   *  names as keys and single-table table expressions as values, or the
   *  selection helper functions {@link all}, {@link not}, or {@link range}.
   *  If object-valued, specifies the key-value pairs for each output,
   *  defined using two-table table expressions.
   * @param {JoinOptions} [options] Options for the join.
   * @return {this} A new joined table.
   * @example table.cross(other)
   * @example table.cross(other, [['leftKey', 'leftVal'], ['rightVal']])
   */
  cross(other, values, options) {
    return this.__cross(this, other, values, options);
  }

  /**
   * Perform a semi-join, filtering the left table to only rows that
   * match a row in the right table.
   * @param {TableRef} other The other (right) table to join with.
   * @param {JoinPredicate} [on] The join criteria for matching table rows.
   *  If unspecified, the values of all columns with matching names
   *  are compared.
   *  If array-valued, a two-element array should be provided, containing
   *  the columns to compare for the left and right tables, respectively.
   *  If a one-element array or a string value is provided, the same
   *  column names will be drawn from both tables.
   *  If function-valued, should be a two-table table expression that
   *  returns a boolean value. When providing a custom predicate, note that
   *  join key values can be arrays or objects, and that normal join
   *  semantics do not consider null or undefined values to be equal (that is,
   *  null !== null). Use the op.equal function to handle these cases.
   * @return {this} A new filtered table.
   * @example table.semijoin(other)
   * @example table.semijoin(other, ['keyL', 'keyR'])
   * @example table.semijoin(other, (a, b) => equal(a.keyL, b.keyR))
   */
  semijoin(other, on) {
    return this.__semijoin(this, other, on);
  }

  /**
   * Perform an anti-join, filtering the left table to only rows that
   * do *not* match a row in the right table.
   * @param {TableRef} other The other (right) table to join with.
   * @param {JoinPredicate} [on] The join criteria for matching table rows.
   *  If unspecified, the values of all columns with matching names
   *  are compared.
   *  If array-valued, a two-element array should be provided, containing
   *  the columns to compare for the left and right tables, respectively.
   *  If a one-element array or a string value is provided, the same
   *  column names will be drawn from both tables.
   *  If function-valued, should be a two-table table expression that
   *  returns a boolean value. When providing a custom predicate, note that
   *  join key values can be arrays or objects, and that normal join
   *  semantics do not consider null or undefined values to be equal (that is,
   *  null !== null). Use the op.equal function to handle these cases.
   * @return {this} A new filtered table.
   * @example table.antijoin(other)
   * @example table.antijoin(other, ['keyL', 'keyR'])
   * @example table.antijoin(other, (a, b) => equal(a.keyL, b.keyR))
   */
  antijoin(other, on) {
    return this.__antijoin(this, other, on);
  }

  // -- Set Operations ------------------------------------------------------

  /**
   * Concatenate multiple tables into a single table, preserving all rows.
   * This transformation mirrors the UNION_ALL operation in SQL.
   * Only named columns in this table are included in the output.
   * @see Transformable#union
   * @param  {...TableRef} tables A list of tables to concatenate.
   * @return {this} A new concatenated table.
   * @example table.concat(other)
   * @example table.concat(other1, other2)
   * @example table.concat([other1, other2])
   */
  concat(...tables) {
    return this.__concat(this, tables.flat());
  }

  /**
   * Union multiple tables into a single table, deduplicating all rows.
   * This transformation mirrors the UNION operation in SQL. It is
   * similar to {@link Transformable#concat} but suppresses duplicate rows with
   * values identical to another row.
   * Only named columns in this table are included in the output.
   * @see Transformable#concat
   * @param  {...TableRef} tables A list of tables to union.
   * @return {this} A new unioned table.
   * @example table.union(other)
   * @example table.union(other1, other2)
   * @example table.union([other1, other2])
   */
  union(...tables) {
    return this.__union(this, tables.flat());
  }

  /**
   * Intersect multiple tables, keeping only rows whose with identical
   * values for all columns in all tables, and deduplicates the rows.
   * This transformation is similar to a series of {@link Transformable#semijoin}
   * calls, but additionally suppresses duplicate rows.
   * @see Transformable#semijoin
   * @param  {...TableRef} tables A list of tables to intersect.
   * @return {this} A new filtered table.
   * @example table.intersect(other)
   * @example table.intersect(other1, other2)
   * @example table.intersect([other1, other2])
   */
  intersect(...tables) {
    return this.__intersect(this, tables.flat());
  }

  /**
   * Compute the set difference with multiple tables, keeping only rows in
   * this table that whose values do not occur in the other tables.
   * This transformation is similar to a series of {@link Transformable#antijoin}
   * calls, but additionally suppresses duplicate rows.
   * @see Transformable#antijoin
   * @param  {...TableRef} tables A list of tables to difference.
   * @return {this} A new filtered table.
   * @example table.except(other)
   * @example table.except(other1, other2)
   * @example table.except([other1, other2])
   */
  except(...tables) {
    return this.__except(this, tables.flat());
  }
}

// -- Parameter Types -------------------------------------------------------

/**
 * Table expression parameters.
 * @typedef {Object.<string, *>} Params
 */

/**
 * A reference to a column by string name or integer index.
 * @typedef {string|number} ColumnRef
 */

/**
 * A value that can be coerced to a string.
 * @typedef {object} Stringable
 * @property {() => string} toString String coercion method.
 */

/**
 * A table expression provided as a string or string-coercible value.
 * @typedef {string|Stringable} TableExprString
 */

/**
 * A struct object with arbitraty named properties.
 * @typedef {Object.<string, *>} Struct
 */

/**
 * A function defined over a table row.
 * @typedef {(d?: Struct, $?: Params) => any} TableExprFunc
 */

/**
 * A table expression defined over a single table.
 * @typedef {TableExprFunc|TableExprString} TableExpr
 */

/**
 * A function defined over rows from two tables.
 * @typedef {(a?: Struct, b?: Struct, $?: Params) => any} TableFunc2
 */

/**
 * A table expression defined over two tables.
 * @typedef {TableExprFunc2|TableExprString} TableExpr2
 */

/**
 * An object that maps current column names to new column names.
 * @typedef {{ [name: string]: string }} RenameMap
 */

/**
 * A selection helper function.
 * @typedef {(table: any) => string[]} SelectHelper
 */

/**
 * One or more column selections, potentially with renaming.
 * The input may consist of a column name string, column integer index, a
 * rename map object with current column names as keys and new column names
 * as values, or a select helper function that takes a table as input and
 * returns a valid selection parameter.
 * @typedef {ColumnRef|RenameMap|SelectHelper} SelectEntry
 */

/**
 * An ordered set of column selections, potentially with renaming.
 * @typedef {SelectEntry|SelectEntry[]} Select
 */

/**
 * An object of column name / table expression pairs.
 * @typedef {{ [name: string]: TableExpr }} ExprObject
 */

/**
 * An object of column name / two-table expression pairs.
 * @typedef {{ [name: string]: TableExpr2 }} Expr2Object
 */

/**
 * An ordered set of one or more column values.
 * @typedef {ColumnRef|SelectHelper|ExprObject} ListEntry
 */

/**
 * An ordered set of column values.
 * Entries may be column name strings, column index numbers, value objects
 * with output column names for keys and table expressions for values,
 * or a selection helper function.
 * @typedef {ListEntry|ListEntry[]} ExprList
 */

/**
 * A reference to a data table or transformable instance.
 * @typedef {Transformable|string} TableRef
 */

/**
 * One or more orderby sort criteria.
 * If a string, order by the column with that name.
 * If a number, order by the column with that index.
 * If a function, must be a valid table expression; aggregate functions
 *  are permitted, but window functions are not.
 * If an object, object values must be valid values parameters
 *  with output column names for keys and table expressions
 *  for values. The output name keys will subsequently be ignored.
 * @typedef {ColumnRef|TableExpr|ExprObject} OrderKey
 */

/**
 * An ordered set of orderby sort criteria, in precedence order.
 * @typedef {OrderKey|OrderKey[]} OrderKeys
 */

/**
 * Column values to use as a join key.
 * @typedef {ColumnRef|TableExprFunc} JoinKey
 */

/**
 * An ordered set of join keys.
 * @typedef {JoinKey|[JoinKey[]]|[JoinKey[], JoinKey[]]} JoinKeys
 */

/**
 * A predicate specification for joining two tables.
 * @typedef {JoinKeys|TableExprFunc2|null} JoinPredicate
 */

/**
 * An array of per-table join values to extract.
 * @typedef {[ExprList]|[ExprList, ExprList]|[ExprList, ExprList, Expr2Object]} JoinList
 */

/**
 * A specification of join values to extract.
 * @typedef {JoinList|Expr2Object} JoinValues
 */

// -- Transform Options -----------------------------------------------------

/**
 * Options for count transformations.
 * @typedef {object} CountOptions
 * @property {string} [as='count'] The name of the output count column.
 */

/**
 * Options for derive transformations.
 * @typedef {object} DeriveOptions
 * @property {boolean} [drop=false] A flag indicating if the original
 *  columns should be dropped, leaving only the derived columns. If true,
 *  the before and after options are ignored.
 * @property {Select} [before]
 *  An anchor column that relocated columns should be placed before.
 *  The value can be any legal column selection. If multiple columns are
 *  selected, only the first column will be used as an anchor.
 *  It is an error to specify both before and after options.
 * @property {Select} [after]
 *  An anchor column that relocated columns should be placed after.
 *  The value can be any legal column selection. If multiple columns are
 *  selected, only the last column will be used as an anchor.
 *  It is an error to specify both before and after options.
 */

/**
 * Options for relocate transformations.
 * @typedef {object} RelocateOptions
 * @property {Selection} [before]
 *  An anchor column that relocated columns should be placed before.
 *  The value can be any legal column selection. If multiple columns are
 *  selected, only the first column will be used as an anchor.
 *  It is an error to specify both before and after options.
 * @property {Selection} [after]
 *  An anchor column that relocated columns should be placed after.
 *  The value can be any legal column selection. If multiple columns are
 *  selected, only the last column will be used as an anchor.
 *  It is an error to specify both before and after options.
 */

/**
 * Options for sample transformations.
 * @typedef {object} SampleOptions
 * @property {boolean} [replace=false] Flag for sampling with replacement.
 * @property {boolean} [shuffle=true] Flag to ensure randomly ordered rows.
 * @property {string|TableExprFunc} [weight] Column values to use as weights
 *  for sampling. Rows will be sampled with probability proportional to
 *  their relative weight. The input should be a column name string or
 *  a table expression compatible with {@link Transformable#derive}.
 */

/**
 * Options for impute transformations.
 * @typedef {object} ImputeOptions
 * @property {ExprList} [expand] Column values to combine to impute missing
 *  rows. For column names and indices, all unique column values are
 *  considered. Otherwise, each entry should be an object of name-expresion
 *  pairs, with valid table expressions for {@link Transformable#rollup}.
 *  All combinations of values are checked for each set of unique groupby
 *  values.
 */

/**
 * Options for fold transformations.
 * @typedef {object} FoldOptions
 * @property {string[]} [as=['key', 'value']] An array indicating the
 *  output column names to use for the key and value columns, respectively.
 */

/**
 * Options for pivot transformations.
 * @typedef {object} PivotOptions
 * @property {number} [limit=Infinity] The maximum number of new columns to generate.
 * @property {string} [keySeparator='_'] A string to place between multiple key names.
 * @property {string} [valueSeparator='_'] A string to place between key and value names.
 * @property {boolean} [sort=true] Flag for alphabetical sorting of new column names.
 */

/**
 * Options for spread transformations.
 * @typedef {object} SpreadOptions
 * @property {boolean} [drop=true] Flag indicating if input columns to the
 *  spread operation should be dropped in the output table.
 * @property {number} [limit=Infinity] The maximum number of new columns to
 *  generate.
 * @property {string[]} [as] Output column names to use. This option only
 *  applies when a single column is spread. If the given array of names is
 *  shorter than the number of generated columns and no limit option is
 *  specified, the additional generated columns will be dropped.
 */

/**
 * Options for unroll transformations.
 * @typedef {object} UnrollOptions
 * @property {number} [limit=Infinity] The maximum number of new rows
 *  to generate per array value.
 * @property {boolean|string} [index=false] Flag or column name for adding
 *  zero-based array index values as an output column. If true, a new column
 *  named "index" will be included. If string-valued, a new column with
 *  the given name will be added.
 * @property {Select} [drop] Columns to drop from the output. The input may
 *  consist of column name strings, column integer indices, objects with
 *  column names as keys, or functions that take a table as input and
 *  return a valid selection parameter (typically the output of selection
 *  helper functions such as {@link all}, {@link not}, or {@link range}).
 */

/**
 * Options for join transformations.
 * @typedef {object} JoinOptions
 * @property {boolean} [left=false] Flag indicating a left outer join.
 *  If both the *left* and *right* are true, indicates a full outer join.
 * @property {boolean} [right=false] Flag indicating a right outer join.
 *  If both the *left* and *right* are true, indicates a full outer join.
 * @property {string[]} [suffix=['_1', '_2']] Column name suffixes to
 *  append if two columns with the same name are produced by the join.
 */

/***/ }),

/***/ "../../node_modules/arquero/src/util/array-type.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/util/array-type.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_typed_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-typed-array */ "../../node_modules/arquero/src/util/is-typed-array.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(column) {
  return (0,_is_typed_array__WEBPACK_IMPORTED_MODULE_0__["default"])(column.data) ? column.data.constructor : Array;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/ascending.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/util/ascending.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(a, b) {
  return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/assign.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/util/assign.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _entries__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./entries */ "../../node_modules/arquero/src/util/entries.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(map, pairs) {
  for (const [key, value] of (0,_entries__WEBPACK_IMPORTED_MODULE_0__["default"])(pairs)) {
    map.set(key, value);
  }
  return map;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/bins.js":
/*!***************************************************!*\
  !*** ../../node_modules/arquero/src/util/bins.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(min, max, maxbins = 15, nice = true, minstep = 0, step) {
  const base = 10;
  const logb = Math.LN10;

  if (step == null) {
    const level = Math.ceil(Math.log(maxbins) / logb);
    const span = (max - min) || Math.abs(min) || 1;
    const div = [5, 2];

    step = Math.max(
      minstep,
      Math.pow(base, Math.round(Math.log(span) / logb) - level)
    );

    // increase step size if too many bins
    while (Math.ceil(span / step) > maxbins) {
      step *= base;
    }

    // decrease step size if it stays within maxbins
    const n = div.length;
    for (let i = 0; i < n; ++i) {
      const v = step / div[i];
      if (v >= minstep && span / v <= maxbins) {
        step = v;
      }
    }
  }

  // snap to "nice" boundaries
  if (nice) {
    let v = Math.log(step);
    const precision = v >= 0 ? 0 : ~~(-v / logb) + 1;
    const eps = Math.pow(base, -precision - 1);
    v = Math.floor(min / step + eps) * step;
    min = min < v ? v - step : v;
    max = Math.ceil(max / step) * step;
  }

  return [
    min,
    max === min ? min + step : max,
    step
  ];
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/bisector.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/util/bisector.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(compare) {
  return {
    left(a, x, lo, hi) {
      if (lo == null) lo = 0;
      if (hi == null) hi = a.length;
      while (lo < hi) {
        const mid = lo + hi >>> 1;
        if (compare(a[mid], x) < 0) lo = mid + 1;
        else hi = mid;
      }
      return lo;
    },
    right(a, x, lo, hi) {
      if (lo == null) lo = 0;
      if (hi == null) hi = a.length;
      while (lo < hi) {
        const mid = lo + hi >>> 1;
        if (compare(a[mid], x) > 0) hi = mid;
        else lo = mid + 1;
      }
      return lo;
    }
  };
}


/***/ }),

/***/ "../../node_modules/arquero/src/util/concat.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/util/concat.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(list, fn = (x => x), delim = '') {
  const n = list.length;
  if (!n) return '';

  let s = fn(list[0], 0);
  for (let i = 1; i < n; ++i) {
    s += delim + fn(list[i], i);
  }

  return s;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/default-true.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/util/default-true.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, trueValue = true, falseValue = false) {
  return (value === undefined || value) ? trueValue : falseValue;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/distinct-map.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/util/distinct-map.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _key_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./key-function */ "../../node_modules/arquero/src/util/key-function.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  const map = new Map();
  return {
    count() {
      return map.size;
    },
    values() {
      return Array.from(map.values(), _ => _.v);
    },
    increment(v) {
      const k = (0,_key_function__WEBPACK_IMPORTED_MODULE_0__.key)(v);
      const e = map.get(k);
      e ? ++e.n : map.set(k, { v, n: 1 });
    },
    decrement(v) {
      const k = (0,_key_function__WEBPACK_IMPORTED_MODULE_0__.key)(v);
      const e = map.get(k);
      e.n === 1 ? map.delete(k) : --e.n;
    },
    forEach(fn) {
      map.forEach(({ v, n }) => fn(v, n));
    }
  };
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/entries.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/util/entries.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _is_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./is-map */ "../../node_modules/arquero/src/util/is-map.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return (0,_is_array__WEBPACK_IMPORTED_MODULE_0__["default"])(value) ? value
    : (0,_is_map__WEBPACK_IMPORTED_MODULE_1__["default"])(value) ? value.entries()
    : value ? Object.entries(value)
    : [];
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/error.js":
/*!****************************************************!*\
  !*** ../../node_modules/arquero/src/util/error.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(message) {
  throw Error(message);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/escape-regexp.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/util/escape-regexp.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(str) {
  return str.replace(/[.*+\-?^${}()|[\]\\]/g, '\\$&');
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/format-date.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/util/format-date.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   formatDate: () => (/* binding */ formatDate),
/* harmony export */   formatISO: () => (/* binding */ formatISO),
/* harmony export */   formatUTCDate: () => (/* binding */ formatUTCDate)
/* harmony export */ });
/* harmony import */ var _pad__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pad */ "../../node_modules/arquero/src/util/pad.js");


const pad2 = v => (v < 10 ? '0' : '') + v;

const formatYear = year => year < 0 ? '-' + (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(-year, 6)
  : year > 9999 ? '+' + (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(year, 6)
  : (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(year, 4);

function formatISO(year, month, date, hours, min, sec, ms, utc, short) {
  const suffix = utc ? 'Z' : '';
  return formatYear(year) + '-' + pad2(month + 1) + '-' + pad2(date) + (
    !short || ms ? 'T' + pad2(hours) + ':' + pad2(min) + ':' + pad2(sec) + '.' + (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(ms, 3) + suffix
    : sec ? 'T' + pad2(hours) + ':' + pad2(min) + ':' + pad2(sec) + suffix
    : min || hours || !utc ? 'T' + pad2(hours) + ':' + pad2(min) + suffix
    : ''
  );
}

function formatDate(d, short) {
  return isNaN(d)
    ? 'Invalid Date'
    : formatISO(
      d.getFullYear(),
      d.getMonth(),
      d.getDate(),
      d.getHours(),
      d.getMinutes(),
      d.getSeconds(),
      d.getMilliseconds(),
      false, short
    );
}

function formatUTCDate(d, short) {
  return isNaN(d)
    ? 'Invalid Date'
    : formatISO(
      d.getUTCFullYear(),
      d.getUTCMonth(),
      d.getUTCDate(),
      d.getUTCHours(),
      d.getUTCMinutes(),
      d.getUTCSeconds(),
      d.getUTCMilliseconds(),
      true, short
    );
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/has.js":
/*!**************************************************!*\
  !*** ../../node_modules/arquero/src/util/has.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const { hasOwnProperty } = Object.prototype;

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(object, property) {
  return hasOwnProperty.call(object, property);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/identity.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/util/identity.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (x => x);

/***/ }),

/***/ "../../node_modules/arquero/src/util/intersect.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/util/intersect.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ intersect)
/* harmony export */ });
function intersect(a, b) {
  const set = new Set(b);
  return a.filter(x => set.has(x));
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-array-type.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-array-type.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isArrayType)
/* harmony export */ });
/* harmony import */ var _is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _is_typed_array__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./is-typed-array */ "../../node_modules/arquero/src/util/is-typed-array.js");



function isArrayType(value) {
  return (0,_is_array__WEBPACK_IMPORTED_MODULE_0__["default"])(value) || (0,_is_typed_array__WEBPACK_IMPORTED_MODULE_1__["default"])(value);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-array.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-array.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Array.isArray);


/***/ }),

/***/ "../../node_modules/arquero/src/util/is-bigint.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-bigint.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return typeof value === 'bigint';
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-date.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-date.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value instanceof Date;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-digit-string.js":
/*!**************************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-digit-string.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  const n = value.length;
  for (let i = 0; i < n; ++i) {
    const c = value.charCodeAt(i);
    if (c < 48 || c > 57) return false;
  }
  return true;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-exact-utc-date.js":
/*!****************************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-exact-utc-date.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(d) {
  return d.getUTCHours() === 0
    && d.getUTCMinutes() === 0
    && d.getUTCSeconds() === 0
    && d.getUTCMilliseconds() === 0;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-function.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-function.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return typeof value === 'function';
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-iso-date-string.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-iso-date-string.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const iso_re = /^([-+]\d{2})?\d{4}(-\d{2}(-\d{2})?)?(T\d{2}:\d{2}(:\d{2}(\.\d{3})?)?(Z|[-+]\d{2}:\d{2})?)?$/;

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value.match(iso_re);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-map-or-set.js":
/*!************************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-map-or-set.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_map__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-map */ "../../node_modules/arquero/src/util/is-map.js");
/* harmony import */ var _is_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./is-set */ "../../node_modules/arquero/src/util/is-set.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return (0,_is_map__WEBPACK_IMPORTED_MODULE_0__["default"])(value) || (0,_is_set__WEBPACK_IMPORTED_MODULE_1__["default"])(value);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-map.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-map.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value instanceof Map;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-number.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-number.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return typeof value === 'number';
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-object.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-object.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value === Object(value);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-regexp.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-regexp.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value instanceof RegExp;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-set.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-set.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value instanceof Set;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-string.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-string.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return typeof value === 'string';
}


/***/ }),

/***/ "../../node_modules/arquero/src/util/is-typed-array.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-typed-array.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const TypedArray = Object.getPrototypeOf(Int8Array);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value instanceof TypedArray;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/is-valid.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/util/is-valid.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value != null && value === value;
}


/***/ }),

/***/ "../../node_modules/arquero/src/util/key-function.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/util/key-function.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   key: () => (/* binding */ key)
/* harmony export */ });
/* harmony import */ var _is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _is_date__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./is-date */ "../../node_modules/arquero/src/util/is-date.js");
/* harmony import */ var _is_regexp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./is-regexp */ "../../node_modules/arquero/src/util/is-regexp.js");
/* harmony import */ var _is_typed_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./is-typed-array */ "../../node_modules/arquero/src/util/is-typed-array.js");





function key(value) {
  const type = typeof value;
  return type === 'string' ? `"${value}"`
    : type !== 'object' || !value ? value
    : (0,_is_date__WEBPACK_IMPORTED_MODULE_1__["default"])(value) ? +value
    : (0,_is_array__WEBPACK_IMPORTED_MODULE_0__["default"])(value) || (0,_is_typed_array__WEBPACK_IMPORTED_MODULE_3__["default"])(value) ? `[${value.map(key)}]`
    : (0,_is_regexp__WEBPACK_IMPORTED_MODULE_2__["default"])(value) ? value + ''
    : objectKey(value);
}

function objectKey(value) {
  let s = '{';
  let i = -1;
  for (const k in value) {
    if (++i > 0) s += ',';
    s += `"${k}":${key(value[k])}`;
  }
  s += '}';
  return s;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(get, nulls) {
  const n = get.length;
  return n === 1
    ? (row, data) => key(get[0](row, data))
    : (row, data) => {
        let s = '';
        for (let i = 0; i < n; ++i) {
          if (i > 0) s += '|';
          const v = get[i](row, data);
          if (nulls && (v == null || v !== v)) return null;
          s += key(v);
        }
        return s;
      };
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/map-object.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/util/map-object.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(obj, fn, output = {}) {
  for (const key in obj) {
    output[key] = fn(obj[key], key);
  }
  return output;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/max.js":
/*!**************************************************!*\
  !*** ../../node_modules/arquero/src/util/max.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _null__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./null */ "../../node_modules/arquero/src/util/null.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(values, start = 0, stop = values.length) {
  let max = stop ? values[start++] : _null__WEBPACK_IMPORTED_MODULE_0__["default"];

  for (let i = start; i < stop; ++i) {
    if (max < values[i]) {
      max = values[i];
    }
  }

  return max;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/min.js":
/*!**************************************************!*\
  !*** ../../node_modules/arquero/src/util/min.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _null__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./null */ "../../node_modules/arquero/src/util/null.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(values, start = 0, stop = values.length) {
  let min = stop ? values[start++] : _null__WEBPACK_IMPORTED_MODULE_0__["default"];

  for (let i = start; i < stop; ++i) {
    if (min > values[i]) {
      min = values[i];
    }
  }

  return min;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/no-op.js":
/*!****************************************************!*\
  !*** ../../node_modules/arquero/src/util/no-op.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {}

/***/ }),

/***/ "../../node_modules/arquero/src/util/null.js":
/*!***************************************************!*\
  !*** ../../node_modules/arquero/src/util/null.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Default NULL (missing) value to use.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (undefined);

/***/ }),

/***/ "../../node_modules/arquero/src/util/pad.js":
/*!**************************************************!*\
  !*** ../../node_modules/arquero/src/util/pad.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, width, char = '0') {
  const s = value + '';
  const len = s.length;
  return len < width ? Array(width - len + 1).join(char) + s : s;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/parse-iso-date.js":
/*!*************************************************************!*\
  !*** ../../node_modules/arquero/src/util/parse-iso-date.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_iso_date_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-iso-date-string */ "../../node_modules/arquero/src/util/is-iso-date-string.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value, parse = Date.parse) {
  return (0,_is_iso_date_string__WEBPACK_IMPORTED_MODULE_0__["default"])(value) ? parse(value) : value;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/parse-values.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/util/parse-values.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _identity__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./identity */ "../../node_modules/arquero/src/util/identity.js");
/* harmony import */ var _is_iso_date_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./is-iso-date-string */ "../../node_modules/arquero/src/util/is-iso-date-string.js");



const parseBoolean = [ // boolean
  v => (v === 'true') || (v === 'false'),
  v => v === 'false' ? false : true
];

const parseNumber = [ // number
  v => v === 'NaN' || (v = +v) === v,
  v => +v
];

const parseDate = [ // iso date
  _is_iso_date_string__WEBPACK_IMPORTED_MODULE_1__["default"],
  v => new Date(Date.parse(v))
];

function numberParser(options) {
  const { decimal } = options;
  return decimal && decimal !== '.'
    ? parseNumber.map(f => s => f(s && s.replace(decimal, '.')))
    : parseNumber;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(values, options) {
  const types = [parseBoolean, numberParser(options), parseDate];
  const n = types.length;
  for (let i = 0; i < n; ++i) {
    const [test, parser] = types[i];
    if (check(values, test)) {
      return parser;
    }
  }
  return _identity__WEBPACK_IMPORTED_MODULE_0__["default"];
}

function check(values, test) {
  const n = values.length;
  for (let i = 0; i < n; ++i) {
    const v = values[i];
    if (v != null && !test(v)) {
      return false;
    }
  }
  return true;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/product.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/util/product.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(values, start = 0, stop = values.length) {
  let prod = values[start++];

  for (let i = start; i < stop; ++i) {
    prod *= values[i];
  }

  return prod;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/quantile.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/util/quantile.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ quantile)
/* harmony export */ });
/* harmony import */ var _is_bigint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-bigint */ "../../node_modules/arquero/src/util/is-bigint.js");
/* harmony import */ var _null__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./null */ "../../node_modules/arquero/src/util/null.js");
/* harmony import */ var _to_numeric__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./to-numeric */ "../../node_modules/arquero/src/util/to-numeric.js");




function quantile(values, p) {
  const n = values.length;

  if (!n) return _null__WEBPACK_IMPORTED_MODULE_1__["default"];
  if ((p = +p) <= 0 || n < 2) return (0,_to_numeric__WEBPACK_IMPORTED_MODULE_2__["default"])(values[0]);
  if (p >= 1) return (0,_to_numeric__WEBPACK_IMPORTED_MODULE_2__["default"])(values[n - 1]);

  const i = (n - 1) * p;
  const i0 = Math.floor(i);
  const v0 = (0,_to_numeric__WEBPACK_IMPORTED_MODULE_2__["default"])(values[i0]);
  return (0,_is_bigint__WEBPACK_IMPORTED_MODULE_0__["default"])(v0)
    ? v0
    : v0 + ((0,_to_numeric__WEBPACK_IMPORTED_MODULE_2__["default"])(values[i0 + 1]) - v0) * (i - i0);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/random.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/util/random.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   random: () => (/* binding */ random),
/* harmony export */   seed: () => (/* binding */ seed)
/* harmony export */ });
/* harmony import */ var _is_valid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-valid */ "../../node_modules/arquero/src/util/is-valid.js");


let source = Math.random;

function random() {
  return source();
}

/**
 * Set a seed value for random number generation.
 * If the seed is a valid number, a 32-bit linear congruential generator
 * with the given seed will be used to generate random values.
 * If the seed is null, undefined, or not a valid number, the random
 * number generator will revert to Math.random.
 * @param {number} seed The random seed value. Should either be an
 *  integer or a fraction between 0 and 1.
 */
function seed(seed) {
  source = (0,_is_valid__WEBPACK_IMPORTED_MODULE_0__["default"])(seed) && isFinite(seed = +seed) ? lcg(seed) : Math.random;
}

function lcg(seed) {
  const a = 0x19660D;
  const c = 0x3C6EF35F;
  const m = 1 / 0x100000000;
  seed = (0 <= seed && seed < 1 ? seed / m : Math.abs(seed)) | 0;

  // Random numbers using a Linear Congruential Generator with seed value
  // https://en.wikipedia.org/wiki/Linear_congruential_generator
  return () => (seed = a * seed + c | 0, m * (seed >>> 0));
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/repeat.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/util/repeat.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-function */ "../../node_modules/arquero/src/util/is-function.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(reps, value) {
  const result = Array(reps);
  if ((0,_is_function__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {
    for (let i = 0; i < reps; ++i) {
      result[i] = value(i);
    }
  } else {
    result.fill(value);
  }
  return result;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/sample.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/util/sample.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ "../../node_modules/arquero/src/util/ascending.js");
/* harmony import */ var _bisector__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bisector */ "../../node_modules/arquero/src/util/bisector.js");
/* harmony import */ var _random__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./random */ "../../node_modules/arquero/src/util/random.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(buffer, replace, index, weight) {
  return (
    replace
      ? (weight ? sampleRW : sampleRU)
      : (weight ? sampleNW : sampleNU)
  )(buffer.length, buffer, index, weight);
}

// uniform sampling with replacement
// uses straightforward uniform sampling
function sampleRU(size, buffer, index) {
  const n = index.length;
  for (let i = 0; i < size; ++i) {
    buffer[i] = index[(n * (0,_random__WEBPACK_IMPORTED_MODULE_2__.random)()) | 0];
  }
  return buffer;
}

// weighted sampling with replacement
// uses binary search lookup against cumulative weight
function sampleRW(size, buffer, index, weight) {
  const n = index.length;
  const w = new Float64Array(n);

  let sum = 0;
  for (let i = 0; i < n; ++i) {
    w[i] = (sum += weight(index[i]));
  }

  const bisect = (0,_bisector__WEBPACK_IMPORTED_MODULE_1__["default"])(_ascending__WEBPACK_IMPORTED_MODULE_0__["default"]).right;
  for (let i = 0; i < size; ++i) {
    buffer[i] = index[bisect(w, sum * (0,_random__WEBPACK_IMPORTED_MODULE_2__.random)())];
  }
  return buffer;
}

// uniform sampling without replacement
// uses reservoir sampling to build out the sample
// https://en.wikipedia.org/wiki/Reservoir_sampling
function sampleNU(size, buffer, index) {
  const n = index.length;
  if (size >= n) return index;

  for (let i = 0; i < size; ++i) {
    buffer[i] = index[i];
  }

  for (let i = size; i < n; ++i) {
    const j = i * (0,_random__WEBPACK_IMPORTED_MODULE_2__.random)();
    if (j < size) {
      buffer[j | 0] = index[i];
    }
  }

  return buffer;
}

// weighted sample without replacement
// uses method of Efraimidis and Spirakis
// TODO: could use min-heap to improve efficiency
function sampleNW(size, buffer, index, weight) {
  const n = index.length;
  if (size >= n) return index;

  const w = new Float32Array(n);
  const k = new Uint32Array(n);
  for (let i = 0; i < n; ++i) {
    k[i] = i;
    w[i] = -Math.log((0,_random__WEBPACK_IMPORTED_MODULE_2__.random)()) / weight(index[i]);
  }

  k.sort((a, b) => w[a] - w[b]);
  for (let i = 0; i < size; ++i) {
    buffer[i] = index[k[i]];
  }
  return buffer;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/shuffle.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/util/shuffle.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _random__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./random */ "../../node_modules/arquero/src/util/random.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(array, lo = 0, hi = array.length) {
  let n = hi - (lo = +lo);

  while (n) {
    const i = (0,_random__WEBPACK_IMPORTED_MODULE_0__.random)() * n-- | 0;
    const v = array[n + lo];
    array[n + lo] = array[i + lo];
    array[i + lo] = v;
  }

  return array;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/to-array.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/util/to-array.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_array__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-array */ "../../node_modules/arquero/src/util/is-array.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return value != null
    ? ((0,_is_array__WEBPACK_IMPORTED_MODULE_0__["default"])(value) ? value : [value])
    : [];
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/to-function.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/util/to-function.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_function__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-function */ "../../node_modules/arquero/src/util/is-function.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return (0,_is_function__WEBPACK_IMPORTED_MODULE_0__["default"])(value) ? value : () => value;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/to-numeric.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/util/to-numeric.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_bigint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-bigint */ "../../node_modules/arquero/src/util/is-bigint.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(value) {
  return (0,_is_bigint__WEBPACK_IMPORTED_MODULE_0__["default"])(value) ? value : +value;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/to-string.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/util/to-string.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_bigint__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-bigint */ "../../node_modules/arquero/src/util/is-bigint.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(v) {
  return v === undefined ? v + ''
    : (0,_is_bigint__WEBPACK_IMPORTED_MODULE_0__["default"])(v) ? v + 'n'
    : JSON.stringify(v);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/unique-name.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/util/unique-name.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _is_map_or_set__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./is-map-or-set */ "../../node_modules/arquero/src/util/is-map-or-set.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(names, name) {
  names = (0,_is_map_or_set__WEBPACK_IMPORTED_MODULE_0__["default"])(names) ? names : new Set(names);
  let uname = name;
  let index = 0;

  while (names.has(uname)) {
    uname = name + ++index;
  }

  return uname;
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/unroll.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/util/unroll.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(args, code, ...lists) {
  const v = ['_', '$'];
  const a = v.slice(0, lists.length);
  a.push('"use strict"; const '
    + lists
        .map((l, j) => l.map((_, i) => `${v[j]}${i} = ${v[j]}[${i}]`).join(', '))
        .join(', ')
    + `; return (${args}) => ${code};`
  );
  return Function(...a)(...lists);
}

/***/ }),

/***/ "../../node_modules/arquero/src/util/value-list.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/util/value-list.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ValueList)
/* harmony export */ });
/* harmony import */ var _ascending__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ascending */ "../../node_modules/arquero/src/util/ascending.js");
/* harmony import */ var _min__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./min */ "../../node_modules/arquero/src/util/min.js");
/* harmony import */ var _max__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./max */ "../../node_modules/arquero/src/util/max.js");
/* harmony import */ var _quantile__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./quantile */ "../../node_modules/arquero/src/util/quantile.js");





class ValueList {
  constructor(values) {
    this._values = values || [];
    this._sorted = null;
    this._start = 0;
  }

  values(copy) {
    if (this._start) {
      this._values = this._values.slice(this._start);
      this._start = 0;
    }
    return copy
      ? this._values.slice()
      : this._values;
  }

  add(value) {
    this._values.push(value);
    this._sorted = null;
  }

  rem() {
    this._start += 1;
    this._sorted = null;
  }

  min() {
    return this._sorted && this._sorted.length
      ? this._sorted[0]
      : (0,_min__WEBPACK_IMPORTED_MODULE_1__["default"])(this._values, this._start);
  }

  max() {
    return this._sorted && this._sorted.length
      ? this._sorted[this._sorted.length - 1]
      : (0,_max__WEBPACK_IMPORTED_MODULE_2__["default"])(this._values, this._start);
  }

  quantile(p) {
    if (!this._sorted) {
      this._sorted = this.values(true);
      this._sorted.sort(_ascending__WEBPACK_IMPORTED_MODULE_0__["default"]);
    }
    return (0,_quantile__WEBPACK_IMPORTED_MODULE_3__["default"])(this._sorted, p);
  }
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/dedupe.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/dedupe.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, keys = []) {
  return table
    .groupby(keys.length ? keys : table.columnNames())
    .filter('row_number() === 1')
    .ungroup()
    .reify();
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/derive.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/derive.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _relocate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./relocate */ "../../node_modules/arquero/src/verbs/relocate.js");
/* harmony import */ var _engine_derive__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../engine/derive */ "../../node_modules/arquero/src/engine/derive.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values, options = {}) {
  const dt = (0,_engine_derive__WEBPACK_IMPORTED_MODULE_1__["default"])(table, (0,_expression_parse__WEBPACK_IMPORTED_MODULE_2__["default"])(values, { table }), options);

  return options.drop || (options.before == null && options.after == null)
    ? dt
    : (0,_relocate__WEBPACK_IMPORTED_MODULE_0__["default"])(dt,
        Object.keys(values).filter(name => !table.column(name)),
        options
      );
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/except.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/except.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, others) {
  if (others.length === 0) return table;
  const names = table.columnNames();
  return others.reduce((a, b) => a.antijoin(b.select(names)), table).dedupe();
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/filter.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/filter.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_derive__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/derive */ "../../node_modules/arquero/src/engine/derive.js");
/* harmony import */ var _engine_filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../engine/filter */ "../../node_modules/arquero/src/engine/filter.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, criteria) {
  const test = (0,_expression_parse__WEBPACK_IMPORTED_MODULE_2__["default"])({ p: criteria }, { table });
  let predicate = test.exprs[0];
  if (test.ops.length) {
    const { data } = (0,_engine_derive__WEBPACK_IMPORTED_MODULE_0__["default"])(table, test, { drop: true }).column('p');
    predicate = row => data[row];
  }
  return (0,_engine_filter__WEBPACK_IMPORTED_MODULE_1__["default"])(table, predicate);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/fold.js":
/*!****************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/fold.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_fold__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/fold */ "../../node_modules/arquero/src/engine/fold.js");
/* harmony import */ var _util_parse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util/parse */ "../../node_modules/arquero/src/verbs/util/parse.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values, options) {
  return (0,_engine_fold__WEBPACK_IMPORTED_MODULE_0__["default"])(table, (0,_util_parse__WEBPACK_IMPORTED_MODULE_1__["default"])('fold', table, values), options);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/groupby.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/groupby.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_groupby__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/groupby */ "../../node_modules/arquero/src/engine/groupby.js");
/* harmony import */ var _util_parse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util/parse */ "../../node_modules/arquero/src/verbs/util/parse.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values) {
  return (0,_engine_groupby__WEBPACK_IMPORTED_MODULE_0__["default"])(table, (0,_util_parse__WEBPACK_IMPORTED_MODULE_1__["default"])('groupby', table, values));
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/helpers/agg.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/helpers/agg.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ agg)
/* harmony export */ });
/* harmony import */ var _table_table__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../table/table */ "../../node_modules/arquero/src/table/table.js");
 // eslint-disable-line no-unused-vars

/**
 * Convenience function for computing a single aggregate value for
 * a table. Equivalent to ungrouping a table, applying a rollup verb
 * for a single aggregate, and extracting the resulting value.
 * @param {Table} table A table instance.
 * @param {import('../../table/transformable').TableExpr} expr An
 *   aggregate table expression to evaluate.
 * @return {import('../../table/table').DataValue} The aggregate value.
 * @example agg(table, op.max('colA'))
 * @example agg(table, d => [op.min('colA'), op.max('colA')])
 */
function agg(table, expr) {
  return table.ungroup().rollup({ _: expr }).get('_');
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/impute.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/impute.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_impute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/impute */ "../../node_modules/arquero/src/engine/impute.js");
/* harmony import */ var _engine_rollup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../engine/rollup */ "../../node_modules/arquero/src/engine/rollup.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _util_parse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util/parse */ "../../node_modules/arquero/src/verbs/util/parse.js");
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../op/op-api */ "../../node_modules/arquero/src/op/op-api.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");








/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values, options = {}) {
  values = (0,_expression_parse__WEBPACK_IMPORTED_MODULE_2__["default"])(values, { table });

  values.names.forEach(name =>
    table.column(name) ? 0 : (0,_util_error__WEBPACK_IMPORTED_MODULE_5__["default"])(`Invalid impute column ${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_6__["default"])(name)}`)
  );

  if (options.expand) {
    const opt = { preparse, aggronly: true };
    const params = (0,_util_parse__WEBPACK_IMPORTED_MODULE_3__["default"])('impute', table, options.expand, opt);
    const result = (0,_engine_rollup__WEBPACK_IMPORTED_MODULE_1__["default"])(table.ungroup(), params);
    return (0,_engine_impute__WEBPACK_IMPORTED_MODULE_0__["default"])(
      table, values, params.names,
      params.names.map(name => result.get(name, 0))
    );
  } else {
    return (0,_engine_impute__WEBPACK_IMPORTED_MODULE_0__["default"])(table, values);
  }
}

// map direct field reference to "unique" aggregate
function preparse(map) {
  map.forEach((value, key) =>
    value.field ? map.set(key, (0,_op_op_api__WEBPACK_IMPORTED_MODULE_4__.array_agg_distinct)(value + '')) : 0
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/index.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dedupe__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dedupe */ "../../node_modules/arquero/src/verbs/dedupe.js");
/* harmony import */ var _derive__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./derive */ "../../node_modules/arquero/src/verbs/derive.js");
/* harmony import */ var _except__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./except */ "../../node_modules/arquero/src/verbs/except.js");
/* harmony import */ var _filter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./filter */ "../../node_modules/arquero/src/verbs/filter.js");
/* harmony import */ var _fold__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./fold */ "../../node_modules/arquero/src/verbs/fold.js");
/* harmony import */ var _impute__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./impute */ "../../node_modules/arquero/src/verbs/impute.js");
/* harmony import */ var _intersect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./intersect */ "../../node_modules/arquero/src/verbs/intersect.js");
/* harmony import */ var _join__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./join */ "../../node_modules/arquero/src/verbs/join.js");
/* harmony import */ var _join_filter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./join-filter */ "../../node_modules/arquero/src/verbs/join-filter.js");
/* harmony import */ var _lookup__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./lookup */ "../../node_modules/arquero/src/verbs/lookup.js");
/* harmony import */ var _pivot__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./pivot */ "../../node_modules/arquero/src/verbs/pivot.js");
/* harmony import */ var _relocate__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./relocate */ "../../node_modules/arquero/src/verbs/relocate.js");
/* harmony import */ var _rename__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./rename */ "../../node_modules/arquero/src/verbs/rename.js");
/* harmony import */ var _rollup__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./rollup */ "../../node_modules/arquero/src/verbs/rollup.js");
/* harmony import */ var _sample__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./sample */ "../../node_modules/arquero/src/verbs/sample.js");
/* harmony import */ var _select__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./select */ "../../node_modules/arquero/src/verbs/select.js");
/* harmony import */ var _spread__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./spread */ "../../node_modules/arquero/src/verbs/spread.js");
/* harmony import */ var _union__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./union */ "../../node_modules/arquero/src/verbs/union.js");
/* harmony import */ var _unroll__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./unroll */ "../../node_modules/arquero/src/verbs/unroll.js");
/* harmony import */ var _groupby__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./groupby */ "../../node_modules/arquero/src/verbs/groupby.js");
/* harmony import */ var _orderby__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./orderby */ "../../node_modules/arquero/src/verbs/orderby.js");
/* harmony import */ var _engine_concat__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../engine/concat */ "../../node_modules/arquero/src/engine/concat.js");
/* harmony import */ var _engine_reduce__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../engine/reduce */ "../../node_modules/arquero/src/engine/reduce.js");
/* harmony import */ var _engine_ungroup__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../engine/ungroup */ "../../node_modules/arquero/src/engine/ungroup.js");
/* harmony import */ var _engine_unorder__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../engine/unorder */ "../../node_modules/arquero/src/engine/unorder.js");
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../op/op-api */ "../../node_modules/arquero/src/op/op-api.js");





























/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  __antijoin: (table, other, on) =>
    (0,_join_filter__WEBPACK_IMPORTED_MODULE_8__["default"])(table, other, on, { anti: true }),
  __count: (table, options = {}) =>
    (0,_rollup__WEBPACK_IMPORTED_MODULE_13__["default"])(table, { [options.as || 'count']: (0,_op_op_api__WEBPACK_IMPORTED_MODULE_25__.count)() }),
  __cross: (table, other, values, options) =>
    (0,_join__WEBPACK_IMPORTED_MODULE_7__["default"])(table, other, () => true, values, {
      ...options, left: true, right: true
    }),
  __concat: _engine_concat__WEBPACK_IMPORTED_MODULE_21__["default"],
  __dedupe: _dedupe__WEBPACK_IMPORTED_MODULE_0__["default"],
  __derive: _derive__WEBPACK_IMPORTED_MODULE_1__["default"],
  __except: _except__WEBPACK_IMPORTED_MODULE_2__["default"],
  __filter: _filter__WEBPACK_IMPORTED_MODULE_3__["default"],
  __fold: _fold__WEBPACK_IMPORTED_MODULE_4__["default"],
  __impute: _impute__WEBPACK_IMPORTED_MODULE_5__["default"],
  __intersect: _intersect__WEBPACK_IMPORTED_MODULE_6__["default"],
  __join: _join__WEBPACK_IMPORTED_MODULE_7__["default"],
  __lookup: _lookup__WEBPACK_IMPORTED_MODULE_9__["default"],
  __pivot: _pivot__WEBPACK_IMPORTED_MODULE_10__["default"],
  __relocate: _relocate__WEBPACK_IMPORTED_MODULE_11__["default"],
  __rename: _rename__WEBPACK_IMPORTED_MODULE_12__["default"],
  __rollup: _rollup__WEBPACK_IMPORTED_MODULE_13__["default"],
  __sample: _sample__WEBPACK_IMPORTED_MODULE_14__["default"],
  __select: _select__WEBPACK_IMPORTED_MODULE_15__["default"],
  __semijoin: _join_filter__WEBPACK_IMPORTED_MODULE_8__["default"],
  __spread: _spread__WEBPACK_IMPORTED_MODULE_16__["default"],
  __union: _union__WEBPACK_IMPORTED_MODULE_17__["default"],
  __unroll: _unroll__WEBPACK_IMPORTED_MODULE_18__["default"],
  __groupby: _groupby__WEBPACK_IMPORTED_MODULE_19__["default"],
  __orderby: _orderby__WEBPACK_IMPORTED_MODULE_20__["default"],
  __ungroup: _engine_ungroup__WEBPACK_IMPORTED_MODULE_23__["default"],
  __unorder: _engine_unorder__WEBPACK_IMPORTED_MODULE_24__["default"],
  __reduce: _engine_reduce__WEBPACK_IMPORTED_MODULE_22__["default"]
});

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/intersect.js":
/*!*********************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/intersect.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, others) {
  const names = table.columnNames();
  return others.length
    ? others.reduce((a, b) => a.semijoin(b.select(names)), table).dedupe()
    : table.reify([]);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/join-filter.js":
/*!***********************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/join-filter.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_join_filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/join-filter */ "../../node_modules/arquero/src/engine/join-filter.js");
/* harmony import */ var _util_join_keys__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util/join-keys */ "../../node_modules/arquero/src/verbs/util/join-keys.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");






/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, on, options) {
  on = (0,_util_join_keys__WEBPACK_IMPORTED_MODULE_1__.inferKeys)(tableL, tableR, on);

  const predicate = (0,_util_is_array__WEBPACK_IMPORTED_MODULE_3__["default"])(on)
    ? (0,_util_join_keys__WEBPACK_IMPORTED_MODULE_1__.keyPredicate)(tableL, tableR, ...on.map(_util_to_array__WEBPACK_IMPORTED_MODULE_4__["default"]))
    : (0,_expression_parse__WEBPACK_IMPORTED_MODULE_2__["default"])({ on }, { join: [tableL, tableR] }).exprs[0];

  return (0,_engine_join_filter__WEBPACK_IMPORTED_MODULE_0__["default"])(tableL, tableR, predicate, options);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/join.js":
/*!****************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/join.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_join__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/join */ "../../node_modules/arquero/src/engine/join.js");
/* harmony import */ var _util_join_keys__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util/join-keys */ "../../node_modules/arquero/src/verbs/util/join-keys.js");
/* harmony import */ var _util_parse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util/parse */ "../../node_modules/arquero/src/verbs/util/parse.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");
/* harmony import */ var _util_to_string__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../util/to-string */ "../../node_modules/arquero/src/util/to-string.js");










const OPT_L = { aggregate: false, window: false };
const OPT_R = { ...OPT_L, index: 1 };

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, on, values, options = {}) {
  on = (0,_util_join_keys__WEBPACK_IMPORTED_MODULE_1__.inferKeys)(tableL, tableR, on);
  const optParse = { join: [tableL, tableR] };
  let predicate;

  if ((0,_util_is_array__WEBPACK_IMPORTED_MODULE_5__["default"])(on)) {
    const [onL, onR] = on.map(_util_to_array__WEBPACK_IMPORTED_MODULE_7__["default"]);
    predicate = (0,_util_join_keys__WEBPACK_IMPORTED_MODULE_1__.keyPredicate)(tableL, tableR, onL, onR);

    if (!values) {
      // infer output columns, suppress duplicated key columns
      values = inferValues(tableL, onL, onR, options);
    }
  } else {
    predicate = (0,_expression_parse__WEBPACK_IMPORTED_MODULE_3__["default"])({ on }, optParse).exprs[0];

    if (!values) {
      // include all table columns if values not provided
      values = [(0,_helpers_selection__WEBPACK_IMPORTED_MODULE_4__.all)(), (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_4__.all)()];
    }
  }

  return (0,_engine_join__WEBPACK_IMPORTED_MODULE_0__["default"])(
    tableL, tableR, predicate,
    parseValues(tableL, tableR, values, optParse, options && options.suffix),
    options
  );
}

function inferValues(tableL, onL, onR, options) {
  const isect = [];
  onL.forEach((s, i) => (0,_util_is_string__WEBPACK_IMPORTED_MODULE_6__["default"])(s) && s === onR[i] ? isect.push(s) : 0);
  const vR = (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_4__.not)(isect);

  if (options.left && options.right) {
    // for full join, merge shared key columns together
    const shared = new Set(isect);
    return [
      tableL.columnNames().map(s => {
        const c = `[${(0,_util_to_string__WEBPACK_IMPORTED_MODULE_8__["default"])(s)}]`;
        return shared.has(s)
          ? { [s]: `(a, b) => a${c} == null ? b${c} : a${c}` }
          : s;
      }),
      vR
    ];
  }

  return options.right ? [vR, (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_4__.all)()] : [(0,_helpers_selection__WEBPACK_IMPORTED_MODULE_4__.all)(), vR];
}

function parseValues(tableL, tableR, values, optParse, suffix = []) {
  if ((0,_util_is_array__WEBPACK_IMPORTED_MODULE_5__["default"])(values)) {
    let vL, vR, vJ, n = values.length;
    vL = vR = vJ = { names: [], exprs: [] };

    if (n--) {
      vL = (0,_util_parse__WEBPACK_IMPORTED_MODULE_2__["default"])('join', tableL, values[0], optParse);
    }
    if (n--) {
      vR = (0,_util_parse__WEBPACK_IMPORTED_MODULE_2__["default"])('join', tableR, values[1], OPT_R);
    }
    if (n--) {
      vJ = (0,_expression_parse__WEBPACK_IMPORTED_MODULE_3__["default"])(values[2], optParse);
    }

    // handle name collisions
    const rename = new Set();
    const namesL = new Set(vL.names);
    vR.names.forEach(name => {
      if (namesL.has(name)) {
        rename.add(name);
      }
    });
    if (rename.size) {
      rekey(vL.names, rename, suffix[0] || '_1');
      rekey(vR.names, rename, suffix[1] || '_2');
    }

    return {
      names: vL.names.concat(vR.names, vJ.names),
      exprs: vL.exprs.concat(vR.exprs, vJ.exprs)
    };
  } else {
    return (0,_expression_parse__WEBPACK_IMPORTED_MODULE_3__["default"])(values, optParse);
  }
}

function rekey(names, rename, suffix) {
  names.forEach((name, i) => rename.has(name)
    ? (names[i] = name + suffix)
    : 0);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/lookup.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/lookup.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_lookup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/lookup */ "../../node_modules/arquero/src/engine/lookup.js");
/* harmony import */ var _util_join_keys__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util/join-keys */ "../../node_modules/arquero/src/verbs/util/join-keys.js");
/* harmony import */ var _util_parse_key__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util/parse-key */ "../../node_modules/arquero/src/verbs/util/parse-key.js");
/* harmony import */ var _util_parse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util/parse */ "../../node_modules/arquero/src/verbs/util/parse.js");





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(tableL, tableR, on, values) {
  on = (0,_util_join_keys__WEBPACK_IMPORTED_MODULE_1__.inferKeys)(tableL, tableR, on);
  return (0,_engine_lookup__WEBPACK_IMPORTED_MODULE_0__["default"])(
    tableL,
    tableR,
    [ (0,_util_parse_key__WEBPACK_IMPORTED_MODULE_2__["default"])('lookup', tableL, on[0]), (0,_util_parse_key__WEBPACK_IMPORTED_MODULE_2__["default"])('lookup', tableR, on[1]) ],
    (0,_util_parse__WEBPACK_IMPORTED_MODULE_3__["default"])('lookup', tableR, values)
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/orderby.js":
/*!*******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/orderby.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_orderby__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/orderby */ "../../node_modules/arquero/src/engine/orderby.js");
/* harmony import */ var _expression_compare__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../expression/compare */ "../../node_modules/arquero/src/expression/compare.js");
/* harmony import */ var _helpers_field__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../helpers/field */ "../../node_modules/arquero/src/helpers/field.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");









/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values) {
  return (0,_engine_orderby__WEBPACK_IMPORTED_MODULE_0__["default"])(table, parseValues(table, values));
}

function parseValues(table, params) {
  let index = -1;
  const exprs = new Map();
  const add = val => exprs.set(++index + '', val);

  params.forEach(param => {
    const expr = param.expr != null ? param.expr : param;

    if ((0,_util_is_object__WEBPACK_IMPORTED_MODULE_5__["default"])(expr) && !(0,_util_is_function__WEBPACK_IMPORTED_MODULE_4__["default"])(expr)) {
      for (const key in expr) add(expr[key]);
    } else {
      add(
        (0,_util_is_number__WEBPACK_IMPORTED_MODULE_6__["default"])(expr) ? (0,_helpers_field__WEBPACK_IMPORTED_MODULE_2__["default"])(param, table.columnName(expr))
          : (0,_util_is_string__WEBPACK_IMPORTED_MODULE_7__["default"])(expr) ? (0,_helpers_field__WEBPACK_IMPORTED_MODULE_2__["default"])(param)
          : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_4__["default"])(expr) ? param
          : (0,_util_error__WEBPACK_IMPORTED_MODULE_3__["default"])(`Invalid orderby field: ${param+''}`)
      );
    }
  });

  return (0,_expression_compare__WEBPACK_IMPORTED_MODULE_1__["default"])(table, exprs);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/pivot.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/pivot.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_pivot__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/pivot */ "../../node_modules/arquero/src/engine/pivot.js");
/* harmony import */ var _op_op_api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../op/op-api */ "../../node_modules/arquero/src/op/op-api.js");
/* harmony import */ var _util_parse__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util/parse */ "../../node_modules/arquero/src/verbs/util/parse.js");




// TODO: enforce aggregates only (no output changes) for values
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, on, values, options) {
  return (0,_engine_pivot__WEBPACK_IMPORTED_MODULE_0__["default"])(
    table,
    (0,_util_parse__WEBPACK_IMPORTED_MODULE_2__["default"])('fold', table, on),
    (0,_util_parse__WEBPACK_IMPORTED_MODULE_2__["default"])('fold', table, values, { preparse, aggronly: true }),
    options
  );
}

// map direct field reference to "any" aggregate
function preparse(map) {
  map.forEach((value, key) =>
    value.field ? map.set(key, (0,_op_op_api__WEBPACK_IMPORTED_MODULE_1__.any)(value + '')) : 0
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/relocate.js":
/*!********************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/relocate.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/select */ "../../node_modules/arquero/src/engine/select.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../util/error */ "../../node_modules/arquero/src/util/error.js");




/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, columns, { before, after } = {}) {
  const bef = before != null;
  const aft = after != null;

  if (!(bef || aft)) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])('relocate requires a before or after option.');
  }
  if (bef && aft) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])('relocate accepts only one of the before or after options.');
  }

  columns = (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_1__["default"])(table, columns);
  const anchors = [...(0,_helpers_selection__WEBPACK_IMPORTED_MODULE_1__["default"])(table, bef ? before : after).keys()];
  const anchor = bef ? anchors[0] : anchors.pop();
  const select = new Map();

  // marshal inputs to select in desired order
  table.columnNames().forEach(name => {
    // check if we should assign the current column
    const assign = !columns.has(name);

    // at anchor column, insert relocated columns
    if (name === anchor) {
      if (aft && assign) select.set(name, name);
      for (const [key, value] of columns) {
        select.set(key, value);
      }
      if (aft) return; // exit if current column has been handled
    }

    if (assign) select.set(name, name);
  });

  return (0,_engine_select__WEBPACK_IMPORTED_MODULE_0__["default"])(table, select);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/rename.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/rename.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/select */ "../../node_modules/arquero/src/engine/select.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, columns) {
  const map = new Map();
  table.columnNames(x => (map.set(x, x), 0));
  return (0,_engine_select__WEBPACK_IMPORTED_MODULE_0__["default"])(table, (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_1__["default"])(table, columns, map));
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/rollup.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/rollup.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_rollup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/rollup */ "../../node_modules/arquero/src/engine/rollup.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values) {
  return (0,_engine_rollup__WEBPACK_IMPORTED_MODULE_0__["default"])(table, (0,_expression_parse__WEBPACK_IMPORTED_MODULE_1__["default"])(values, { table, aggronly: true }));
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/sample.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/sample.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_derive__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/derive */ "../../node_modules/arquero/src/engine/derive.js");
/* harmony import */ var _engine_rollup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../engine/rollup */ "../../node_modules/arquero/src/engine/rollup.js");
/* harmony import */ var _engine_sample__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../engine/sample */ "../../node_modules/arquero/src/engine/sample.js");
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");







/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, size, options = {}) {
  return (0,_engine_sample__WEBPACK_IMPORTED_MODULE_2__["default"])(
    table,
    parseSize(table, size),
    parseWeight(table, options.weight),
    options
  );
}

const get = col => row => col.get(row) || 0;

function parseSize(table, size) {
  return (0,_util_is_number__WEBPACK_IMPORTED_MODULE_4__["default"])(size)
    ? () => size
    : get((0,_engine_rollup__WEBPACK_IMPORTED_MODULE_1__["default"])(table, (0,_expression_parse__WEBPACK_IMPORTED_MODULE_3__["default"])({ size }, { table })).column('size'));
}

function parseWeight(table, w) {
  if (w == null) return null;
  w = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_4__["default"])(w) ? table.columnName(w) : w;
  return get(
    (0,_util_is_string__WEBPACK_IMPORTED_MODULE_5__["default"])(w)
      ? table.column(w)
      : (0,_engine_derive__WEBPACK_IMPORTED_MODULE_0__["default"])(table, (0,_expression_parse__WEBPACK_IMPORTED_MODULE_3__["default"])({ w }, { table }), { drop: true }).column('w')
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/select.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/select.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/select */ "../../node_modules/arquero/src/engine/select.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, columns) {
  return (0,_engine_select__WEBPACK_IMPORTED_MODULE_0__["default"])(table, (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_1__["default"])(table, columns));
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/spread.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/spread.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_spread__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/spread */ "../../node_modules/arquero/src/engine/spread.js");
/* harmony import */ var _util_parse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util/parse */ "../../node_modules/arquero/src/verbs/util/parse.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values, options) {
  return (0,_engine_spread__WEBPACK_IMPORTED_MODULE_0__["default"])(table, (0,_util_parse__WEBPACK_IMPORTED_MODULE_1__["default"])('spread', table, values), options);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/union.js":
/*!*****************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/union.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, others) {
  return table.concat(others).dedupe();
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/unroll.js":
/*!******************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/unroll.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _engine_unroll__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../engine/unroll */ "../../node_modules/arquero/src/engine/unroll.js");
/* harmony import */ var _util_parse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util/parse */ "../../node_modules/arquero/src/verbs/util/parse.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(table, values, options) {
  return (0,_engine_unroll__WEBPACK_IMPORTED_MODULE_0__["default"])(
    table,
    (0,_util_parse__WEBPACK_IMPORTED_MODULE_1__["default"])('unroll', table, values),
    options && options.drop
      ? { ...options, drop: (0,_util_parse__WEBPACK_IMPORTED_MODULE_1__["default"])('unroll', table, options.drop).names }
      : options
  );
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/util/join-keys.js":
/*!**************************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/util/join-keys.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   inferKeys: () => (/* binding */ inferKeys),
/* harmony export */   keyPredicate: () => (/* binding */ keyPredicate)
/* harmony export */ });
/* harmony import */ var _parse_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parse-key */ "../../node_modules/arquero/src/verbs/util/parse-key.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_intersect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/intersect */ "../../node_modules/arquero/src/util/intersect.js");
/* harmony import */ var _util_is_array__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/is-array */ "../../node_modules/arquero/src/util/is-array.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");






function inferKeys(tableL, tableR, on) {
  if (!on) {
    // perform natural join if join condition not provided
    const isect = (0,_util_intersect__WEBPACK_IMPORTED_MODULE_2__["default"])(tableL.columnNames(), tableR.columnNames());
    if (!isect.length) (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Natural join requires shared column names.');
    on = [isect, isect];
  } else if ((0,_util_is_string__WEBPACK_IMPORTED_MODULE_4__["default"])(on)) {
    on = [on, on];
  } else if ((0,_util_is_array__WEBPACK_IMPORTED_MODULE_3__["default"])(on) && on.length === 1) {
    on = [on[0], on[0]];
  }

  return on;
}

function keyPredicate(tableL, tableR, onL, onR) {
  if (onL.length !== onR.length) {
    (0,_util_error__WEBPACK_IMPORTED_MODULE_1__["default"])('Mismatched number of join keys');
  }
  return [
    (0,_parse_key__WEBPACK_IMPORTED_MODULE_0__["default"])('join', tableL, onL),
    (0,_parse_key__WEBPACK_IMPORTED_MODULE_0__["default"])('join', tableR, onR)
  ];
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/util/parse-key.js":
/*!**************************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/util/parse-key.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _helpers_field__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/field */ "../../node_modules/arquero/src/helpers/field.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_key_function__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/key-function */ "../../node_modules/arquero/src/util/key-function.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");










/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(name, table, params) {
  const exprs = new Map();

  (0,_util_to_array__WEBPACK_IMPORTED_MODULE_8__["default"])(params).forEach((param, i) => {
    param = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_4__["default"])(param) ? table.columnName(param) : param;
    (0,_util_is_string__WEBPACK_IMPORTED_MODULE_6__["default"])(param) ? exprs.set(i, (0,_helpers_field__WEBPACK_IMPORTED_MODULE_1__["default"])(param))
      : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_3__["default"])(param) || (0,_util_is_object__WEBPACK_IMPORTED_MODULE_5__["default"])(param) && param.expr ? exprs.set(i, param)
      : (0,_util_error__WEBPACK_IMPORTED_MODULE_2__["default"])(`Invalid ${name} key value: ${param+''}`);
  });

  const fn = (0,_expression_parse__WEBPACK_IMPORTED_MODULE_0__["default"])(exprs, { table, aggregate: false, window: false });
  return (0,_util_key_function__WEBPACK_IMPORTED_MODULE_7__["default"])(fn.exprs, true);
}

/***/ }),

/***/ "../../node_modules/arquero/src/verbs/util/parse.js":
/*!**********************************************************!*\
  !*** ../../node_modules/arquero/src/verbs/util/parse.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _expression_parse__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../expression/parse */ "../../node_modules/arquero/src/expression/parse.js");
/* harmony import */ var _helpers_field__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/field */ "../../node_modules/arquero/src/helpers/field.js");
/* harmony import */ var _helpers_selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers/selection */ "../../node_modules/arquero/src/helpers/selection.js");
/* harmony import */ var _util_assign__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../util/assign */ "../../node_modules/arquero/src/util/assign.js");
/* harmony import */ var _util_error__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../util/error */ "../../node_modules/arquero/src/util/error.js");
/* harmony import */ var _util_is_number__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../util/is-number */ "../../node_modules/arquero/src/util/is-number.js");
/* harmony import */ var _util_is_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../util/is-object */ "../../node_modules/arquero/src/util/is-object.js");
/* harmony import */ var _util_is_string__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/is-string */ "../../node_modules/arquero/src/util/is-string.js");
/* harmony import */ var _util_is_function__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../util/is-function */ "../../node_modules/arquero/src/util/is-function.js");
/* harmony import */ var _util_to_array__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../util/to-array */ "../../node_modules/arquero/src/util/to-array.js");











/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(name, table, params, options = { window: false }) {
  const exprs = new Map();

  const marshal = param => {
    param = (0,_util_is_number__WEBPACK_IMPORTED_MODULE_5__["default"])(param) ? table.columnName(param) : param;
    (0,_util_is_string__WEBPACK_IMPORTED_MODULE_7__["default"])(param) ? exprs.set(param, (0,_helpers_field__WEBPACK_IMPORTED_MODULE_1__["default"])(param))
      : (0,_util_is_function__WEBPACK_IMPORTED_MODULE_8__["default"])(param) ? (0,_helpers_selection__WEBPACK_IMPORTED_MODULE_2__["default"])(table, param).forEach(marshal)
      : (0,_util_is_object__WEBPACK_IMPORTED_MODULE_6__["default"])(param) ? (0,_util_assign__WEBPACK_IMPORTED_MODULE_3__["default"])(exprs, param)
      : (0,_util_error__WEBPACK_IMPORTED_MODULE_4__["default"])(`Invalid ${name} value: ${param+''}`);
  };

  (0,_util_to_array__WEBPACK_IMPORTED_MODULE_9__["default"])(params).forEach(marshal);

  if (options.preparse) {
    options.preparse(exprs);
  }

  return (0,_expression_parse__WEBPACK_IMPORTED_MODULE_0__["default"])(exprs, { table, ...options });
}

/***/ }),

/***/ "../../node_modules/batch-processor/src/batch-processor.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/batch-processor/src/batch-processor.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var utils = __webpack_require__(/*! ./utils */ "../../node_modules/batch-processor/src/utils.js");

module.exports = function batchProcessorMaker(options) {
    options             = options || {};
    var reporter        = options.reporter;
    var asyncProcess    = utils.getOption(options, "async", true);
    var autoProcess     = utils.getOption(options, "auto", true);

    if(autoProcess && !asyncProcess) {
        reporter && reporter.warn("Invalid options combination. auto=true and async=false is invalid. Setting async=true.");
        asyncProcess = true;
    }

    var batch = Batch();
    var asyncFrameHandler;
    var isProcessing = false;

    function addFunction(level, fn) {
        if(!isProcessing && autoProcess && asyncProcess && batch.size() === 0) {
            // Since this is async, it is guaranteed to be executed after that the fn is added to the batch.
            // This needs to be done before, since we're checking the size of the batch to be 0.
            processBatchAsync();
        }

        batch.add(level, fn);
    }

    function processBatch() {
        // Save the current batch, and create a new batch so that incoming functions are not added into the currently processing batch.
        // Continue processing until the top-level batch is empty (functions may be added to the new batch while processing, and so on).
        isProcessing = true;
        while (batch.size()) {
            var processingBatch = batch;
            batch = Batch();
            processingBatch.process();
        }
        isProcessing = false;
    }

    function forceProcessBatch(localAsyncProcess) {
        if (isProcessing) {
            return;
        }

        if(localAsyncProcess === undefined) {
            localAsyncProcess = asyncProcess;
        }

        if(asyncFrameHandler) {
            cancelFrame(asyncFrameHandler);
            asyncFrameHandler = null;
        }

        if(localAsyncProcess) {
            processBatchAsync();
        } else {
            processBatch();
        }
    }

    function processBatchAsync() {
        asyncFrameHandler = requestFrame(processBatch);
    }

    function clearBatch() {
        batch           = {};
        batchSize       = 0;
        topLevel        = 0;
        bottomLevel     = 0;
    }

    function cancelFrame(listener) {
        // var cancel = window.cancelAnimationFrame || window.mozCancelAnimationFrame || window.webkitCancelAnimationFrame || window.clearTimeout;
        var cancel = clearTimeout;
        return cancel(listener);
    }

    function requestFrame(callback) {
        // var raf = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || function(fn) { return window.setTimeout(fn, 20); };
        var raf = function(fn) { return setTimeout(fn, 0); };
        return raf(callback);
    }

    return {
        add: addFunction,
        force: forceProcessBatch
    };
};

function Batch() {
    var batch       = {};
    var size        = 0;
    var topLevel    = 0;
    var bottomLevel = 0;

    function add(level, fn) {
        if(!fn) {
            fn = level;
            level = 0;
        }

        if(level > topLevel) {
            topLevel = level;
        } else if(level < bottomLevel) {
            bottomLevel = level;
        }

        if(!batch[level]) {
            batch[level] = [];
        }

        batch[level].push(fn);
        size++;
    }

    function process() {
        for(var level = bottomLevel; level <= topLevel; level++) {
            var fns = batch[level];

            for(var i = 0; i < fns.length; i++) {
                var fn = fns[i];
                fn();
            }
        }
    }

    function getSize() {
        return size;
    }

    return {
        add: add,
        process: process,
        size: getSize
    };
}


/***/ }),

/***/ "../../node_modules/batch-processor/src/utils.js":
/*!*******************************************************!*\
  !*** ../../node_modules/batch-processor/src/utils.js ***!
  \*******************************************************/
/***/ ((module) => {



var utils = module.exports = {};

utils.getOption = getOption;

function getOption(options, name, defaultValue) {
    var value = options[name];

    if((value === undefined || value === null) && defaultValue !== undefined) {
        return defaultValue;
    }

    return value;
}


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/browser-detector.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/browser-detector.js ***!
  \**************************************************************************/
/***/ ((module) => {



var detector = module.exports = {};

detector.isIE = function(version) {
    function isAnyIeVersion() {
        var agent = navigator.userAgent.toLowerCase();
        return agent.indexOf("msie") !== -1 || agent.indexOf("trident") !== -1 || agent.indexOf(" edge/") !== -1;
    }

    if(!isAnyIeVersion()) {
        return false;
    }

    if(!version) {
        return true;
    }

    //Shamelessly stolen from https://gist.github.com/padolsey/527683
    var ieVersion = (function(){
        var undef,
            v = 3,
            div = document.createElement("div"),
            all = div.getElementsByTagName("i");

        do {
            div.innerHTML = "<!--[if gt IE " + (++v) + "]><i></i><![endif]-->";
        }
        while (all[0]);

        return v > 4 ? v : undef;
    }());

    return version === ieVersion;
};

detector.isLegacyOpera = function() {
    return !!window.opera;
};


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/collection-utils.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/collection-utils.js ***!
  \**************************************************************************/
/***/ ((module) => {



var utils = module.exports = {};

/**
 * Loops through the collection and calls the callback for each element. if the callback returns truthy, the loop is broken and returns the same value.
 * @public
 * @param {*} collection The collection to loop through. Needs to have a length property set and have indices set from 0 to length - 1.
 * @param {function} callback The callback to be called for each element. The element will be given as a parameter to the callback. If this callback returns truthy, the loop is broken and the same value is returned.
 * @returns {*} The value that a callback has returned (if truthy). Otherwise nothing.
 */
utils.forEach = function(collection, callback) {
    for(var i = 0; i < collection.length; i++) {
        var result = callback(collection[i]);
        if(result) {
            return result;
        }
    }
};


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/detection-strategy/object.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/detection-strategy/object.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Resize detection strategy that injects objects to elements in order to detect resize events.
 * Heavily inspired by: http://www.backalleycoder.com/2013/03/18/cross-browser-event-based-element-resize-detection/
 */



var browserDetector = __webpack_require__(/*! ../browser-detector */ "../../node_modules/element-resize-detector/src/browser-detector.js");

module.exports = function(options) {
    options             = options || {};
    var reporter        = options.reporter;
    var batchProcessor  = options.batchProcessor;
    var getState        = options.stateHandler.getState;

    if(!reporter) {
        throw new Error("Missing required dependency: reporter.");
    }

    /**
     * Adds a resize event listener to the element.
     * @public
     * @param {element} element The element that should have the listener added.
     * @param {function} listener The listener callback to be called for each resize event of the element. The element will be given as a parameter to the listener callback.
     */
    function addListener(element, listener) {
        function listenerProxy() {
            listener(element);
        }

        if(browserDetector.isIE(8)) {
            //IE 8 does not support object, but supports the resize event directly on elements.
            getState(element).object = {
                proxy: listenerProxy
            };
            element.attachEvent("onresize", listenerProxy);
        } else {
            var object = getObject(element);

            if(!object) {
                throw new Error("Element is not detectable by this strategy.");
            }

            object.contentDocument.defaultView.addEventListener("resize", listenerProxy);
        }
    }

    function buildCssTextString(rules) {
        var seperator = options.important ? " !important; " : "; ";

        return (rules.join(seperator) + seperator).trim();
    }

    /**
     * Makes an element detectable and ready to be listened for resize events. Will call the callback when the element is ready to be listened for resize changes.
     * @private
     * @param {object} options Optional options object.
     * @param {element} element The element to make detectable
     * @param {function} callback The callback to be called when the element is ready to be listened for resize changes. Will be called with the element as first parameter.
     */
    function makeDetectable(options, element, callback) {
        if (!callback) {
            callback = element;
            element = options;
            options = null;
        }

        options = options || {};
        var debug = options.debug;

        function injectObject(element, callback) {
            var OBJECT_STYLE = buildCssTextString(["display: block", "position: absolute", "top: 0", "left: 0", "width: 100%", "height: 100%", "border: none", "padding: 0", "margin: 0", "opacity: 0", "z-index: -1000", "pointer-events: none"]);

            //The target element needs to be positioned (everything except static) so the absolute positioned object will be positioned relative to the target element.

            // Position altering may be performed directly or on object load, depending on if style resolution is possible directly or not.
            var positionCheckPerformed = false;

            // The element may not yet be attached to the DOM, and therefore the style object may be empty in some browsers.
            // Since the style object is a reference, it will be updated as soon as the element is attached to the DOM.
            var style = window.getComputedStyle(element);
            var width = element.offsetWidth;
            var height = element.offsetHeight;

            getState(element).startSize = {
                width: width,
                height: height
            };

            function mutateDom() {
                function alterPositionStyles() {
                    if(style.position === "static") {
                        element.style.setProperty("position", "relative", options.important ? "important" : "");

                        var removeRelativeStyles = function(reporter, element, style, property) {
                            function getNumericalValue(value) {
                                return value.replace(/[^-\d\.]/g, "");
                            }

                            var value = style[property];

                            if(value !== "auto" && getNumericalValue(value) !== "0") {
                                reporter.warn("An element that is positioned static has style." + property + "=" + value + " which is ignored due to the static positioning. The element will need to be positioned relative, so the style." + property + " will be set to 0. Element: ", element);
                                element.style.setProperty(property, "0", options.important ? "important" : "");
                            }
                        };

                        //Check so that there are no accidental styles that will make the element styled differently now that is is relative.
                        //If there are any, set them to 0 (this should be okay with the user since the style properties did nothing before [since the element was positioned static] anyway).
                        removeRelativeStyles(reporter, element, style, "top");
                        removeRelativeStyles(reporter, element, style, "right");
                        removeRelativeStyles(reporter, element, style, "bottom");
                        removeRelativeStyles(reporter, element, style, "left");
                    }
                }

                function onObjectLoad() {
                    // The object has been loaded, which means that the element now is guaranteed to be attached to the DOM.
                    if (!positionCheckPerformed) {
                        alterPositionStyles();
                    }

                    /*jshint validthis: true */

                    function getDocument(element, callback) {
                        //Opera 12 seem to call the object.onload before the actual document has been created.
                        //So if it is not present, poll it with an timeout until it is present.
                        //TODO: Could maybe be handled better with object.onreadystatechange or similar.
                        if(!element.contentDocument) {
                            var state = getState(element);
                            if (state.checkForObjectDocumentTimeoutId) {
                                window.clearTimeout(state.checkForObjectDocumentTimeoutId);
                            }
                            state.checkForObjectDocumentTimeoutId = setTimeout(function checkForObjectDocument() {
                                state.checkForObjectDocumentTimeoutId = 0;
                                getDocument(element, callback);
                            }, 100);

                            return;
                        }

                        callback(element.contentDocument);
                    }

                    //Mutating the object element here seems to fire another load event.
                    //Mutating the inner document of the object element is fine though.
                    var objectElement = this;

                    //Create the style element to be added to the object.
                    getDocument(objectElement, function onObjectDocumentReady(objectDocument) {
                        //Notify that the element is ready to be listened to.
                        callback(element);
                    });
                }

                // The element may be detached from the DOM, and some browsers does not support style resolving of detached elements.
                // The alterPositionStyles needs to be delayed until we know the element has been attached to the DOM (which we are sure of when the onObjectLoad has been fired), if style resolution is not possible.
                if (style.position !== "") {
                    alterPositionStyles(style);
                    positionCheckPerformed = true;
                }

                //Add an object element as a child to the target element that will be listened to for resize events.
                var object = document.createElement("object");
                object.style.cssText = OBJECT_STYLE;
                object.tabIndex = -1;
                object.type = "text/html";
                object.setAttribute("aria-hidden", "true");
                object.onload = onObjectLoad;

                //Safari: This must occur before adding the object to the DOM.
                //IE: Does not like that this happens before, even if it is also added after.
                if(!browserDetector.isIE()) {
                    object.data = "about:blank";
                }

                if (!getState(element)) {
                    // The element has been uninstalled before the actual loading happened.
                    return;
                }

                element.appendChild(object);
                getState(element).object = object;

                //IE: This must occur after adding the object to the DOM.
                if(browserDetector.isIE()) {
                    object.data = "about:blank";
                }
            }

            if(batchProcessor) {
                batchProcessor.add(mutateDom);
            } else {
                mutateDom();
            }
        }

        if(browserDetector.isIE(8)) {
            //IE 8 does not support objects properly. Luckily they do support the resize event.
            //So do not inject the object and notify that the element is already ready to be listened to.
            //The event handler for the resize event is attached in the utils.addListener instead.
            callback(element);
        } else {
            injectObject(element, callback);
        }
    }

    /**
     * Returns the child object of the target element.
     * @private
     * @param {element} element The target element.
     * @returns The object element of the target.
     */
    function getObject(element) {
        return getState(element).object;
    }

    function uninstall(element) {
        if (!getState(element)) {
            return;
        }

        var object = getObject(element);

        if (!object) {
            return;
        }

        if (browserDetector.isIE(8)) {
            element.detachEvent("onresize", object.proxy);
        } else {
            element.removeChild(object);
        }

        if (getState(element).checkForObjectDocumentTimeoutId) {
            window.clearTimeout(getState(element).checkForObjectDocumentTimeoutId);
        }

        delete getState(element).object;
    }

    return {
        makeDetectable: makeDetectable,
        addListener: addListener,
        uninstall: uninstall
    };
};


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/detection-strategy/scroll.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/detection-strategy/scroll.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/**
 * Resize detection strategy that injects divs to elements in order to detect resize events on scroll events.
 * Heavily inspired by: https://github.com/marcj/css-element-queries/blob/master/src/ResizeSensor.js
 */



var forEach = (__webpack_require__(/*! ../collection-utils */ "../../node_modules/element-resize-detector/src/collection-utils.js").forEach);

module.exports = function(options) {
    options             = options || {};
    var reporter        = options.reporter;
    var batchProcessor  = options.batchProcessor;
    var getState        = options.stateHandler.getState;
    var hasState        = options.stateHandler.hasState;
    var idHandler       = options.idHandler;

    if (!batchProcessor) {
        throw new Error("Missing required dependency: batchProcessor");
    }

    if (!reporter) {
        throw new Error("Missing required dependency: reporter.");
    }

    //TODO: Could this perhaps be done at installation time?
    var scrollbarSizes = getScrollbarSizes();

    var styleId = "erd_scroll_detection_scrollbar_style";
    var detectionContainerClass = "erd_scroll_detection_container";

    function initDocument(targetDocument) {
        // Inject the scrollbar styling that prevents them from appearing sometimes in Chrome.
        // The injected container needs to have a class, so that it may be styled with CSS (pseudo elements).
        injectScrollStyle(targetDocument, styleId, detectionContainerClass);
    }

    initDocument(window.document);

    function buildCssTextString(rules) {
        var seperator = options.important ? " !important; " : "; ";

        return (rules.join(seperator) + seperator).trim();
    }

    function getScrollbarSizes() {
        var width = 500;
        var height = 500;

        var child = document.createElement("div");
        child.style.cssText = buildCssTextString(["position: absolute", "width: " + width*2 + "px", "height: " + height*2 + "px", "visibility: hidden", "margin: 0", "padding: 0"]);

        var container = document.createElement("div");
        container.style.cssText = buildCssTextString(["position: absolute", "width: " + width + "px", "height: " + height + "px", "overflow: scroll", "visibility: none", "top: " + -width*3 + "px", "left: " + -height*3 + "px", "visibility: hidden", "margin: 0", "padding: 0"]);

        container.appendChild(child);

        document.body.insertBefore(container, document.body.firstChild);

        var widthSize = width - container.clientWidth;
        var heightSize = height - container.clientHeight;

        document.body.removeChild(container);

        return {
            width: widthSize,
            height: heightSize
        };
    }

    function injectScrollStyle(targetDocument, styleId, containerClass) {
        function injectStyle(style, method) {
            method = method || function (element) {
                targetDocument.head.appendChild(element);
            };

            var styleElement = targetDocument.createElement("style");
            styleElement.innerHTML = style;
            styleElement.id = styleId;
            method(styleElement);
            return styleElement;
        }

        if (!targetDocument.getElementById(styleId)) {
            var containerAnimationClass = containerClass + "_animation";
            var containerAnimationActiveClass = containerClass + "_animation_active";
            var style = "/* Created by the element-resize-detector library. */\n";
            style += "." + containerClass + " > div::-webkit-scrollbar { " + buildCssTextString(["display: none"]) + " }\n\n";
            style += "." + containerAnimationActiveClass + " { " + buildCssTextString(["-webkit-animation-duration: 0.1s", "animation-duration: 0.1s", "-webkit-animation-name: " + containerAnimationClass, "animation-name: " + containerAnimationClass]) + " }\n";
            style += "@-webkit-keyframes " + containerAnimationClass +  " { 0% { opacity: 1; } 50% { opacity: 0; } 100% { opacity: 1; } }\n";
            style += "@keyframes " + containerAnimationClass +          " { 0% { opacity: 1; } 50% { opacity: 0; } 100% { opacity: 1; } }";
            injectStyle(style);
        }
    }

    function addAnimationClass(element) {
        element.className += " " + detectionContainerClass + "_animation_active";
    }

    function addEvent(el, name, cb) {
        if (el.addEventListener) {
            el.addEventListener(name, cb);
        } else if(el.attachEvent) {
            el.attachEvent("on" + name, cb);
        } else {
            return reporter.error("[scroll] Don't know how to add event listeners.");
        }
    }

    function removeEvent(el, name, cb) {
        if (el.removeEventListener) {
            el.removeEventListener(name, cb);
        } else if(el.detachEvent) {
            el.detachEvent("on" + name, cb);
        } else {
            return reporter.error("[scroll] Don't know how to remove event listeners.");
        }
    }

    function getExpandElement(element) {
        return getState(element).container.childNodes[0].childNodes[0].childNodes[0];
    }

    function getShrinkElement(element) {
        return getState(element).container.childNodes[0].childNodes[0].childNodes[1];
    }

    /**
     * Adds a resize event listener to the element.
     * @public
     * @param {element} element The element that should have the listener added.
     * @param {function} listener The listener callback to be called for each resize event of the element. The element will be given as a parameter to the listener callback.
     */
    function addListener(element, listener) {
        var listeners = getState(element).listeners;

        if (!listeners.push) {
            throw new Error("Cannot add listener to an element that is not detectable.");
        }

        getState(element).listeners.push(listener);
    }

    /**
     * Makes an element detectable and ready to be listened for resize events. Will call the callback when the element is ready to be listened for resize changes.
     * @private
     * @param {object} options Optional options object.
     * @param {element} element The element to make detectable
     * @param {function} callback The callback to be called when the element is ready to be listened for resize changes. Will be called with the element as first parameter.
     */
    function makeDetectable(options, element, callback) {
        if (!callback) {
            callback = element;
            element = options;
            options = null;
        }

        options = options || {};

        function debug() {
            if (options.debug) {
                var args = Array.prototype.slice.call(arguments);
                args.unshift(idHandler.get(element), "Scroll: ");
                if (reporter.log.apply) {
                    reporter.log.apply(null, args);
                } else {
                    for (var i = 0; i < args.length; i++) {
                        reporter.log(args[i]);
                    }
                }
            }
        }

        function isDetached(element) {
            function isInDocument(element) {
                var isInShadowRoot = element.getRootNode && element.getRootNode().contains(element);
                return element === element.ownerDocument.body || element.ownerDocument.body.contains(element) || isInShadowRoot;
            }

            if (!isInDocument(element)) {
                return true;
            }

            // FireFox returns null style in hidden iframes. See https://github.com/wnr/element-resize-detector/issues/68 and https://bugzilla.mozilla.org/show_bug.cgi?id=795520
            if (window.getComputedStyle(element) === null) {
                return true;
            }

            return false;
        }

        function isUnrendered(element) {
            // Check the absolute positioned container since the top level container is display: inline.
            var container = getState(element).container.childNodes[0];
            var style = window.getComputedStyle(container);
            return !style.width || style.width.indexOf("px") === -1; //Can only compute pixel value when rendered.
        }

        function getStyle() {
            // Some browsers only force layouts when actually reading the style properties of the style object, so make sure that they are all read here,
            // so that the user of the function can be sure that it will perform the layout here, instead of later (important for batching).
            var elementStyle            = window.getComputedStyle(element);
            var style                   = {};
            style.position              = elementStyle.position;
            style.width                 = element.offsetWidth;
            style.height                = element.offsetHeight;
            style.top                   = elementStyle.top;
            style.right                 = elementStyle.right;
            style.bottom                = elementStyle.bottom;
            style.left                  = elementStyle.left;
            style.widthCSS              = elementStyle.width;
            style.heightCSS             = elementStyle.height;
            return style;
        }

        function storeStartSize() {
            var style = getStyle();
            getState(element).startSize = {
                width: style.width,
                height: style.height
            };
            debug("Element start size", getState(element).startSize);
        }

        function initListeners() {
            getState(element).listeners = [];
        }

        function storeStyle() {
            debug("storeStyle invoked.");
            if (!getState(element)) {
                debug("Aborting because element has been uninstalled");
                return;
            }

            var style = getStyle();
            getState(element).style = style;
        }

        function storeCurrentSize(element, width, height) {
            getState(element).lastWidth = width;
            getState(element).lastHeight  = height;
        }

        function getExpandChildElement(element) {
            return getExpandElement(element).childNodes[0];
        }

        function getWidthOffset() {
            return 2 * scrollbarSizes.width + 1;
        }

        function getHeightOffset() {
            return 2 * scrollbarSizes.height + 1;
        }

        function getExpandWidth(width) {
            return width + 10 + getWidthOffset();
        }

        function getExpandHeight(height) {
            return height + 10 + getHeightOffset();
        }

        function getShrinkWidth(width) {
            return width * 2 + getWidthOffset();
        }

        function getShrinkHeight(height) {
            return height * 2 + getHeightOffset();
        }

        function positionScrollbars(element, width, height) {
            var expand          = getExpandElement(element);
            var shrink          = getShrinkElement(element);
            var expandWidth     = getExpandWidth(width);
            var expandHeight    = getExpandHeight(height);
            var shrinkWidth     = getShrinkWidth(width);
            var shrinkHeight    = getShrinkHeight(height);
            expand.scrollLeft   = expandWidth;
            expand.scrollTop    = expandHeight;
            shrink.scrollLeft   = shrinkWidth;
            shrink.scrollTop    = shrinkHeight;
        }

        function injectContainerElement() {
            var container = getState(element).container;

            if (!container) {
                container                   = document.createElement("div");
                container.className         = detectionContainerClass;
                container.style.cssText     = buildCssTextString(["visibility: hidden", "display: inline", "width: 0px", "height: 0px", "z-index: -1", "overflow: hidden", "margin: 0", "padding: 0"]);
                getState(element).container = container;
                addAnimationClass(container);
                element.appendChild(container);

                var onAnimationStart = function () {
                    getState(element).onRendered && getState(element).onRendered();
                };

                addEvent(container, "animationstart", onAnimationStart);

                // Store the event handler here so that they may be removed when uninstall is called.
                // See uninstall function for an explanation why it is needed.
                getState(element).onAnimationStart = onAnimationStart;
            }

            return container;
        }

        function injectScrollElements() {
            function alterPositionStyles() {
                var style = getState(element).style;

                if(style.position === "static") {
                    element.style.setProperty("position", "relative",options.important ? "important" : "");

                    var removeRelativeStyles = function(reporter, element, style, property) {
                        function getNumericalValue(value) {
                            return value.replace(/[^-\d\.]/g, "");
                        }

                        var value = style[property];

                        if(value !== "auto" && getNumericalValue(value) !== "0") {
                            reporter.warn("An element that is positioned static has style." + property + "=" + value + " which is ignored due to the static positioning. The element will need to be positioned relative, so the style." + property + " will be set to 0. Element: ", element);
                            element.style[property] = 0;
                        }
                    };

                    //Check so that there are no accidental styles that will make the element styled differently now that is is relative.
                    //If there are any, set them to 0 (this should be okay with the user since the style properties did nothing before [since the element was positioned static] anyway).
                    removeRelativeStyles(reporter, element, style, "top");
                    removeRelativeStyles(reporter, element, style, "right");
                    removeRelativeStyles(reporter, element, style, "bottom");
                    removeRelativeStyles(reporter, element, style, "left");
                }
            }

            function getLeftTopBottomRightCssText(left, top, bottom, right) {
                left = (!left ? "0" : (left + "px"));
                top = (!top ? "0" : (top + "px"));
                bottom = (!bottom ? "0" : (bottom + "px"));
                right = (!right ? "0" : (right + "px"));

                return ["left: " + left, "top: " + top, "right: " + right, "bottom: " + bottom];
            }

            debug("Injecting elements");

            if (!getState(element)) {
                debug("Aborting because element has been uninstalled");
                return;
            }

            alterPositionStyles();

            var rootContainer = getState(element).container;

            if (!rootContainer) {
                rootContainer = injectContainerElement();
            }

            // Due to this WebKit bug https://bugs.webkit.org/show_bug.cgi?id=80808 (currently fixed in Blink, but still present in WebKit browsers such as Safari),
            // we need to inject two containers, one that is width/height 100% and another that is left/top -1px so that the final container always is 1x1 pixels bigger than
            // the targeted element.
            // When the bug is resolved, "containerContainer" may be removed.

            // The outer container can occasionally be less wide than the targeted when inside inline elements element in WebKit (see https://bugs.webkit.org/show_bug.cgi?id=152980).
            // This should be no problem since the inner container either way makes sure the injected scroll elements are at least 1x1 px.

            var scrollbarWidth          = scrollbarSizes.width;
            var scrollbarHeight         = scrollbarSizes.height;
            var containerContainerStyle = buildCssTextString(["position: absolute", "flex: none", "overflow: hidden", "z-index: -1", "visibility: hidden", "width: 100%", "height: 100%", "left: 0px", "top: 0px"]);
            var containerStyle          = buildCssTextString(["position: absolute", "flex: none", "overflow: hidden", "z-index: -1", "visibility: hidden"].concat(getLeftTopBottomRightCssText(-(1 + scrollbarWidth), -(1 + scrollbarHeight), -scrollbarHeight, -scrollbarWidth)));
            var expandStyle             = buildCssTextString(["position: absolute", "flex: none", "overflow: scroll", "z-index: -1", "visibility: hidden", "width: 100%", "height: 100%"]);
            var shrinkStyle             = buildCssTextString(["position: absolute", "flex: none", "overflow: scroll", "z-index: -1", "visibility: hidden", "width: 100%", "height: 100%"]);
            var expandChildStyle        = buildCssTextString(["position: absolute", "left: 0", "top: 0"]);
            var shrinkChildStyle        = buildCssTextString(["position: absolute", "width: 200%", "height: 200%"]);

            var containerContainer      = document.createElement("div");
            var container               = document.createElement("div");
            var expand                  = document.createElement("div");
            var expandChild             = document.createElement("div");
            var shrink                  = document.createElement("div");
            var shrinkChild             = document.createElement("div");

            // Some browsers choke on the resize system being rtl, so force it to ltr. https://github.com/wnr/element-resize-detector/issues/56
            // However, dir should not be set on the top level container as it alters the dimensions of the target element in some browsers.
            containerContainer.dir              = "ltr";

            containerContainer.style.cssText    = containerContainerStyle;
            containerContainer.className        = detectionContainerClass;
            container.className                 = detectionContainerClass;
            container.style.cssText             = containerStyle;
            expand.style.cssText                = expandStyle;
            expandChild.style.cssText           = expandChildStyle;
            shrink.style.cssText                = shrinkStyle;
            shrinkChild.style.cssText           = shrinkChildStyle;

            expand.appendChild(expandChild);
            shrink.appendChild(shrinkChild);
            container.appendChild(expand);
            container.appendChild(shrink);
            containerContainer.appendChild(container);
            rootContainer.appendChild(containerContainer);

            function onExpandScroll() {
                getState(element).onExpand && getState(element).onExpand();
            }

            function onShrinkScroll() {
                getState(element).onShrink && getState(element).onShrink();
            }

            addEvent(expand, "scroll", onExpandScroll);
            addEvent(shrink, "scroll", onShrinkScroll);

            // Store the event handlers here so that they may be removed when uninstall is called.
            // See uninstall function for an explanation why it is needed.
            getState(element).onExpandScroll = onExpandScroll;
            getState(element).onShrinkScroll = onShrinkScroll;
        }

        function registerListenersAndPositionElements() {
            function updateChildSizes(element, width, height) {
                var expandChild             = getExpandChildElement(element);
                var expandWidth             = getExpandWidth(width);
                var expandHeight            = getExpandHeight(height);
                expandChild.style.setProperty("width", expandWidth + "px", options.important ? "important" : "");
                expandChild.style.setProperty("height", expandHeight + "px", options.important ? "important" : "");
            }

            function updateDetectorElements(done) {
                var width           = element.offsetWidth;
                var height          = element.offsetHeight;

                // Check whether the size has actually changed since last time the algorithm ran. If not, some steps may be skipped.
                var sizeChanged = width !== getState(element).lastWidth || height !== getState(element).lastHeight;

                debug("Storing current size", width, height);

                // Store the size of the element sync here, so that multiple scroll events may be ignored in the event listeners.
                // Otherwise the if-check in handleScroll is useless.
                storeCurrentSize(element, width, height);

                // Since we delay the processing of the batch, there is a risk that uninstall has been called before the batch gets to execute.
                // Since there is no way to cancel the fn executions, we need to add an uninstall guard to all fns of the batch.

                batchProcessor.add(0, function performUpdateChildSizes() {
                    if (!sizeChanged) {
                        return;
                    }

                    if (!getState(element)) {
                        debug("Aborting because element has been uninstalled");
                        return;
                    }

                    if (!areElementsInjected()) {
                        debug("Aborting because element container has not been initialized");
                        return;
                    }

                    if (options.debug) {
                        var w = element.offsetWidth;
                        var h = element.offsetHeight;

                        if (w !== width || h !== height) {
                            reporter.warn(idHandler.get(element), "Scroll: Size changed before updating detector elements.");
                        }
                    }

                    updateChildSizes(element, width, height);
                });

                batchProcessor.add(1, function updateScrollbars() {
                    // This function needs to be invoked event though the size is unchanged. The element could have been resized very quickly and then
                    // been restored to the original size, which will have changed the scrollbar positions.

                    if (!getState(element)) {
                        debug("Aborting because element has been uninstalled");
                        return;
                    }

                    if (!areElementsInjected()) {
                        debug("Aborting because element container has not been initialized");
                        return;
                    }

                    positionScrollbars(element, width, height);
                });

                if (sizeChanged && done) {
                    batchProcessor.add(2, function () {
                        if (!getState(element)) {
                            debug("Aborting because element has been uninstalled");
                            return;
                        }

                        if (!areElementsInjected()) {
                          debug("Aborting because element container has not been initialized");
                          return;
                        }

                        done();
                    });
                }
            }

            function areElementsInjected() {
                return !!getState(element).container;
            }

            function notifyListenersIfNeeded() {
                function isFirstNotify() {
                    return getState(element).lastNotifiedWidth === undefined;
                }

                debug("notifyListenersIfNeeded invoked");

                var state = getState(element);

                // Don't notify if the current size is the start size, and this is the first notification.
                if (isFirstNotify() && state.lastWidth === state.startSize.width && state.lastHeight === state.startSize.height) {
                    return debug("Not notifying: Size is the same as the start size, and there has been no notification yet.");
                }

                // Don't notify if the size already has been notified.
                if (state.lastWidth === state.lastNotifiedWidth && state.lastHeight === state.lastNotifiedHeight) {
                    return debug("Not notifying: Size already notified");
                }


                debug("Current size not notified, notifying...");
                state.lastNotifiedWidth = state.lastWidth;
                state.lastNotifiedHeight = state.lastHeight;
                forEach(getState(element).listeners, function (listener) {
                    listener(element);
                });
            }

            function handleRender() {
                debug("startanimation triggered.");

                if (isUnrendered(element)) {
                    debug("Ignoring since element is still unrendered...");
                    return;
                }

                debug("Element rendered.");
                var expand = getExpandElement(element);
                var shrink = getShrinkElement(element);
                if (expand.scrollLeft === 0 || expand.scrollTop === 0 || shrink.scrollLeft === 0 || shrink.scrollTop === 0) {
                    debug("Scrollbars out of sync. Updating detector elements...");
                    updateDetectorElements(notifyListenersIfNeeded);
                }
            }

            function handleScroll() {
                debug("Scroll detected.");

                if (isUnrendered(element)) {
                    // Element is still unrendered. Skip this scroll event.
                    debug("Scroll event fired while unrendered. Ignoring...");
                    return;
                }

                updateDetectorElements(notifyListenersIfNeeded);
            }

            debug("registerListenersAndPositionElements invoked.");

            if (!getState(element)) {
                debug("Aborting because element has been uninstalled");
                return;
            }

            getState(element).onRendered = handleRender;
            getState(element).onExpand = handleScroll;
            getState(element).onShrink = handleScroll;

            var style = getState(element).style;
            updateChildSizes(element, style.width, style.height);
        }

        function finalizeDomMutation() {
            debug("finalizeDomMutation invoked.");

            if (!getState(element)) {
                debug("Aborting because element has been uninstalled");
                return;
            }

            var style = getState(element).style;
            storeCurrentSize(element, style.width, style.height);
            positionScrollbars(element, style.width, style.height);
        }

        function ready() {
            callback(element);
        }

        function install() {
            debug("Installing...");
            initListeners();
            storeStartSize();

            batchProcessor.add(0, storeStyle);
            batchProcessor.add(1, injectScrollElements);
            batchProcessor.add(2, registerListenersAndPositionElements);
            batchProcessor.add(3, finalizeDomMutation);
            batchProcessor.add(4, ready);
        }

        debug("Making detectable...");

        if (isDetached(element)) {
            debug("Element is detached");

            injectContainerElement();

            debug("Waiting until element is attached...");

            getState(element).onRendered = function () {
                debug("Element is now attached");
                install();
            };
        } else {
            install();
        }
    }

    function uninstall(element) {
        var state = getState(element);

        if (!state) {
            // Uninstall has been called on a non-erd element.
            return;
        }

        // Uninstall may have been called in the following scenarios:
        // (1) Right between the sync code and async batch (here state.busy = true, but nothing have been registered or injected).
        // (2) In the ready callback of the last level of the batch by another element (here, state.busy = true, but all the stuff has been injected).
        // (3) After the installation process (here, state.busy = false and all the stuff has been injected).
        // So to be on the safe side, let's check for each thing before removing.

        // We need to remove the event listeners, because otherwise the event might fire on an uninstall element which results in an error when trying to get the state of the element.
        state.onExpandScroll && removeEvent(getExpandElement(element), "scroll", state.onExpandScroll);
        state.onShrinkScroll && removeEvent(getShrinkElement(element), "scroll", state.onShrinkScroll);
        state.onAnimationStart && removeEvent(state.container, "animationstart", state.onAnimationStart);

        state.container && element.removeChild(state.container);
    }

    return {
        makeDetectable: makeDetectable,
        addListener: addListener,
        uninstall: uninstall,
        initDocument: initDocument
    };
};


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/element-resize-detector.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/element-resize-detector.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var forEach                 = (__webpack_require__(/*! ./collection-utils */ "../../node_modules/element-resize-detector/src/collection-utils.js").forEach);
var elementUtilsMaker       = __webpack_require__(/*! ./element-utils */ "../../node_modules/element-resize-detector/src/element-utils.js");
var listenerHandlerMaker    = __webpack_require__(/*! ./listener-handler */ "../../node_modules/element-resize-detector/src/listener-handler.js");
var idGeneratorMaker        = __webpack_require__(/*! ./id-generator */ "../../node_modules/element-resize-detector/src/id-generator.js");
var idHandlerMaker          = __webpack_require__(/*! ./id-handler */ "../../node_modules/element-resize-detector/src/id-handler.js");
var reporterMaker           = __webpack_require__(/*! ./reporter */ "../../node_modules/element-resize-detector/src/reporter.js");
var browserDetector         = __webpack_require__(/*! ./browser-detector */ "../../node_modules/element-resize-detector/src/browser-detector.js");
var batchProcessorMaker     = __webpack_require__(/*! batch-processor */ "../../node_modules/batch-processor/src/batch-processor.js");
var stateHandler            = __webpack_require__(/*! ./state-handler */ "../../node_modules/element-resize-detector/src/state-handler.js");

//Detection strategies.
var objectStrategyMaker     = __webpack_require__(/*! ./detection-strategy/object.js */ "../../node_modules/element-resize-detector/src/detection-strategy/object.js");
var scrollStrategyMaker     = __webpack_require__(/*! ./detection-strategy/scroll.js */ "../../node_modules/element-resize-detector/src/detection-strategy/scroll.js");

function isCollection(obj) {
    return Array.isArray(obj) || obj.length !== undefined;
}

function toArray(collection) {
    if (!Array.isArray(collection)) {
        var array = [];
        forEach(collection, function (obj) {
            array.push(obj);
        });
        return array;
    } else {
        return collection;
    }
}

function isElement(obj) {
    return obj && obj.nodeType === 1;
}

/**
 * @typedef idHandler
 * @type {object}
 * @property {function} get Gets the resize detector id of the element.
 * @property {function} set Generate and sets the resize detector id of the element.
 */

/**
 * @typedef Options
 * @type {object}
 * @property {boolean} callOnAdd    Determines if listeners should be called when they are getting added.
                                    Default is true. If true, the listener is guaranteed to be called when it has been added.
                                    If false, the listener will not be guarenteed to be called when it has been added (does not prevent it from being called).
 * @property {idHandler} idHandler  A custom id handler that is responsible for generating, setting and retrieving id's for elements.
                                    If not provided, a default id handler will be used.
 * @property {reporter} reporter    A custom reporter that handles reporting logs, warnings and errors.
                                    If not provided, a default id handler will be used.
                                    If set to false, then nothing will be reported.
 * @property {boolean} debug        If set to true, the the system will report debug messages as default for the listenTo method.
 */

/**
 * Creates an element resize detector instance.
 * @public
 * @param {Options?} options Optional global options object that will decide how this instance will work.
 */
module.exports = function(options) {
    options = options || {};

    //idHandler is currently not an option to the listenTo function, so it should not be added to globalOptions.
    var idHandler;

    if (options.idHandler) {
        // To maintain compatability with idHandler.get(element, readonly), make sure to wrap the given idHandler
        // so that readonly flag always is true when it's used here. This may be removed next major version bump.
        idHandler = {
            get: function (element) { return options.idHandler.get(element, true); },
            set: options.idHandler.set
        };
    } else {
        var idGenerator = idGeneratorMaker();
        var defaultIdHandler = idHandlerMaker({
            idGenerator: idGenerator,
            stateHandler: stateHandler
        });
        idHandler = defaultIdHandler;
    }

    //reporter is currently not an option to the listenTo function, so it should not be added to globalOptions.
    var reporter = options.reporter;

    if(!reporter) {
        //If options.reporter is false, then the reporter should be quiet.
        var quiet = reporter === false;
        reporter = reporterMaker(quiet);
    }

    //batchProcessor is currently not an option to the listenTo function, so it should not be added to globalOptions.
    var batchProcessor = getOption(options, "batchProcessor", batchProcessorMaker({ reporter: reporter }));

    //Options to be used as default for the listenTo function.
    var globalOptions = {};
    globalOptions.callOnAdd     = !!getOption(options, "callOnAdd", true);
    globalOptions.debug         = !!getOption(options, "debug", false);

    var eventListenerHandler    = listenerHandlerMaker(idHandler);
    var elementUtils            = elementUtilsMaker({
        stateHandler: stateHandler
    });

    //The detection strategy to be used.
    var detectionStrategy;
    var desiredStrategy = getOption(options, "strategy", "object");
    var importantCssRules = getOption(options, "important", false);
    var strategyOptions = {
        reporter: reporter,
        batchProcessor: batchProcessor,
        stateHandler: stateHandler,
        idHandler: idHandler,
        important: importantCssRules
    };

    if(desiredStrategy === "scroll") {
        if (browserDetector.isLegacyOpera()) {
            reporter.warn("Scroll strategy is not supported on legacy Opera. Changing to object strategy.");
            desiredStrategy = "object";
        } else if (browserDetector.isIE(9)) {
            reporter.warn("Scroll strategy is not supported on IE9. Changing to object strategy.");
            desiredStrategy = "object";
        }
    }

    if(desiredStrategy === "scroll") {
        detectionStrategy = scrollStrategyMaker(strategyOptions);
    } else if(desiredStrategy === "object") {
        detectionStrategy = objectStrategyMaker(strategyOptions);
    } else {
        throw new Error("Invalid strategy name: " + desiredStrategy);
    }

    //Calls can be made to listenTo with elements that are still being installed.
    //Also, same elements can occur in the elements list in the listenTo function.
    //With this map, the ready callbacks can be synchronized between the calls
    //so that the ready callback can always be called when an element is ready - even if
    //it wasn't installed from the function itself.
    var onReadyCallbacks = {};

    /**
     * Makes the given elements resize-detectable and starts listening to resize events on the elements. Calls the event callback for each event for each element.
     * @public
     * @param {Options?} options Optional options object. These options will override the global options. Some options may not be overriden, such as idHandler.
     * @param {element[]|element} elements The given array of elements to detect resize events of. Single element is also valid.
     * @param {function} listener The callback to be executed for each resize event for each element.
     */
    function listenTo(options, elements, listener) {
        function onResizeCallback(element) {
            var listeners = eventListenerHandler.get(element);
            forEach(listeners, function callListenerProxy(listener) {
                listener(element);
            });
        }

        function addListener(callOnAdd, element, listener) {
            eventListenerHandler.add(element, listener);

            if(callOnAdd) {
                listener(element);
            }
        }

        //Options object may be omitted.
        if(!listener) {
            listener = elements;
            elements = options;
            options = {};
        }

        if(!elements) {
            throw new Error("At least one element required.");
        }

        if(!listener) {
            throw new Error("Listener required.");
        }

        if (isElement(elements)) {
            // A single element has been passed in.
            elements = [elements];
        } else if (isCollection(elements)) {
            // Convert collection to array for plugins.
            // TODO: May want to check so that all the elements in the collection are valid elements.
            elements = toArray(elements);
        } else {
            return reporter.error("Invalid arguments. Must be a DOM element or a collection of DOM elements.");
        }

        var elementsReady = 0;

        var callOnAdd = getOption(options, "callOnAdd", globalOptions.callOnAdd);
        var onReadyCallback = getOption(options, "onReady", function noop() {});
        var debug = getOption(options, "debug", globalOptions.debug);

        forEach(elements, function attachListenerToElement(element) {
            if (!stateHandler.getState(element)) {
                stateHandler.initState(element);
                idHandler.set(element);
            }

            var id = idHandler.get(element);

            debug && reporter.log("Attaching listener to element", id, element);

            if(!elementUtils.isDetectable(element)) {
                debug && reporter.log(id, "Not detectable.");
                if(elementUtils.isBusy(element)) {
                    debug && reporter.log(id, "System busy making it detectable");

                    //The element is being prepared to be detectable. Do not make it detectable.
                    //Just add the listener, because the element will soon be detectable.
                    addListener(callOnAdd, element, listener);
                    onReadyCallbacks[id] = onReadyCallbacks[id] || [];
                    onReadyCallbacks[id].push(function onReady() {
                        elementsReady++;

                        if(elementsReady === elements.length) {
                            onReadyCallback();
                        }
                    });
                    return;
                }

                debug && reporter.log(id, "Making detectable...");
                //The element is not prepared to be detectable, so do prepare it and add a listener to it.
                elementUtils.markBusy(element, true);
                return detectionStrategy.makeDetectable({ debug: debug, important: importantCssRules }, element, function onElementDetectable(element) {
                    debug && reporter.log(id, "onElementDetectable");

                    if (stateHandler.getState(element)) {
                        elementUtils.markAsDetectable(element);
                        elementUtils.markBusy(element, false);
                        detectionStrategy.addListener(element, onResizeCallback);
                        addListener(callOnAdd, element, listener);

                        // Since the element size might have changed since the call to "listenTo", we need to check for this change,
                        // so that a resize event may be emitted.
                        // Having the startSize object is optional (since it does not make sense in some cases such as unrendered elements), so check for its existance before.
                        // Also, check the state existance before since the element may have been uninstalled in the installation process.
                        var state = stateHandler.getState(element);
                        if (state && state.startSize) {
                            var width = element.offsetWidth;
                            var height = element.offsetHeight;
                            if (state.startSize.width !== width || state.startSize.height !== height) {
                                onResizeCallback(element);
                            }
                        }

                        if(onReadyCallbacks[id]) {
                            forEach(onReadyCallbacks[id], function(callback) {
                                callback();
                            });
                        }
                    } else {
                        // The element has been unisntalled before being detectable.
                        debug && reporter.log(id, "Element uninstalled before being detectable.");
                    }

                    delete onReadyCallbacks[id];

                    elementsReady++;
                    if(elementsReady === elements.length) {
                        onReadyCallback();
                    }
                });
            }

            debug && reporter.log(id, "Already detecable, adding listener.");

            //The element has been prepared to be detectable and is ready to be listened to.
            addListener(callOnAdd, element, listener);
            elementsReady++;
        });

        if(elementsReady === elements.length) {
            onReadyCallback();
        }
    }

    function uninstall(elements) {
        if(!elements) {
            return reporter.error("At least one element is required.");
        }

        if (isElement(elements)) {
            // A single element has been passed in.
            elements = [elements];
        } else if (isCollection(elements)) {
            // Convert collection to array for plugins.
            // TODO: May want to check so that all the elements in the collection are valid elements.
            elements = toArray(elements);
        } else {
            return reporter.error("Invalid arguments. Must be a DOM element or a collection of DOM elements.");
        }

        forEach(elements, function (element) {
            eventListenerHandler.removeAllListeners(element);
            detectionStrategy.uninstall(element);
            stateHandler.cleanState(element);
        });
    }

    function initDocument(targetDocument) {
        detectionStrategy.initDocument && detectionStrategy.initDocument(targetDocument);
    }

    return {
        listenTo: listenTo,
        removeListener: eventListenerHandler.removeListener,
        removeAllListeners: eventListenerHandler.removeAllListeners,
        uninstall: uninstall,
        initDocument: initDocument
    };
};

function getOption(options, name, defaultValue) {
    var value = options[name];

    if((value === undefined || value === null) && defaultValue !== undefined) {
        return defaultValue;
    }

    return value;
}


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/element-utils.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/element-utils.js ***!
  \***********************************************************************/
/***/ ((module) => {



module.exports = function(options) {
    var getState = options.stateHandler.getState;

    /**
     * Tells if the element has been made detectable and ready to be listened for resize events.
     * @public
     * @param {element} The element to check.
     * @returns {boolean} True or false depending on if the element is detectable or not.
     */
    function isDetectable(element) {
        var state = getState(element);
        return state && !!state.isDetectable;
    }

    /**
     * Marks the element that it has been made detectable and ready to be listened for resize events.
     * @public
     * @param {element} The element to mark.
     */
    function markAsDetectable(element) {
        getState(element).isDetectable = true;
    }

    /**
     * Tells if the element is busy or not.
     * @public
     * @param {element} The element to check.
     * @returns {boolean} True or false depending on if the element is busy or not.
     */
    function isBusy(element) {
        return !!getState(element).busy;
    }

    /**
     * Marks the object is busy and should not be made detectable.
     * @public
     * @param {element} element The element to mark.
     * @param {boolean} busy If the element is busy or not.
     */
    function markBusy(element, busy) {
        getState(element).busy = !!busy;
    }

    return {
        isDetectable: isDetectable,
        markAsDetectable: markAsDetectable,
        isBusy: isBusy,
        markBusy: markBusy
    };
};


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/id-generator.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/id-generator.js ***!
  \**********************************************************************/
/***/ ((module) => {



module.exports = function() {
    var idCount = 1;

    /**
     * Generates a new unique id in the context.
     * @public
     * @returns {number} A unique id in the context.
     */
    function generate() {
        return idCount++;
    }

    return {
        generate: generate
    };
};


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/id-handler.js":
/*!********************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/id-handler.js ***!
  \********************************************************************/
/***/ ((module) => {



module.exports = function(options) {
    var idGenerator     = options.idGenerator;
    var getState        = options.stateHandler.getState;

    /**
     * Gets the resize detector id of the element.
     * @public
     * @param {element} element The target element to get the id of.
     * @returns {string|number|null} The id of the element. Null if it has no id.
     */
    function getId(element) {
        var state = getState(element);

        if (state && state.id !== undefined) {
            return state.id;
        }

        return null;
    }

    /**
     * Sets the resize detector id of the element. Requires the element to have a resize detector state initialized.
     * @public
     * @param {element} element The target element to set the id of.
     * @returns {string|number|null} The id of the element.
     */
    function setId(element) {
        var state = getState(element);

        if (!state) {
            throw new Error("setId required the element to have a resize detection state.");
        }

        var id = idGenerator.generate();

        state.id = id;

        return id;
    }

    return {
        get: getId,
        set: setId
    };
};


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/listener-handler.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/listener-handler.js ***!
  \**************************************************************************/
/***/ ((module) => {



module.exports = function(idHandler) {
    var eventListeners = {};

    /**
     * Gets all listeners for the given element.
     * @public
     * @param {element} element The element to get all listeners for.
     * @returns All listeners for the given element.
     */
    function getListeners(element) {
        var id = idHandler.get(element);

        if (id === undefined) {
            return [];
        }

        return eventListeners[id] || [];
    }

    /**
     * Stores the given listener for the given element. Will not actually add the listener to the element.
     * @public
     * @param {element} element The element that should have the listener added.
     * @param {function} listener The callback that the element has added.
     */
    function addListener(element, listener) {
        var id = idHandler.get(element);

        if(!eventListeners[id]) {
            eventListeners[id] = [];
        }

        eventListeners[id].push(listener);
    }

    function removeListener(element, listener) {
        var listeners = getListeners(element);
        for (var i = 0, len = listeners.length; i < len; ++i) {
            if (listeners[i] === listener) {
              listeners.splice(i, 1);
              break;
            }
        }
    }

    function removeAllListeners(element) {
      var listeners = getListeners(element);
      if (!listeners) { return; }
      listeners.length = 0;
    }

    return {
        get: getListeners,
        add: addListener,
        removeListener: removeListener,
        removeAllListeners: removeAllListeners
    };
};


/***/ }),

/***/ "../../node_modules/element-resize-detector/src/reporter.js":
/*!******************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/reporter.js ***!
  \******************************************************************/
/***/ ((module) => {



/* global console: false */

/**
 * Reporter that handles the reporting of logs, warnings and errors.
 * @public
 * @param {boolean} quiet Tells if the reporter should be quiet or not.
 */
module.exports = function(quiet) {
    function noop() {
        //Does nothing.
    }

    var reporter = {
        log: noop,
        warn: noop,
        error: noop
    };

    if(!quiet && window.console) {
        var attachFunction = function(reporter, name) {
            //The proxy is needed to be able to call the method with the console context,
            //since we cannot use bind.
            reporter[name] = function reporterProxy() {
                var f = console[name];
                if (f.apply) { //IE9 does not support console.log.apply :)
                    f.apply(console, arguments);
                } else {
                    for (var i = 0; i < arguments.length; i++) {
                        f(arguments[i]);
                    }
                }
            };
        };

        attachFunction(reporter, "log");
        attachFunction(reporter, "warn");
        attachFunction(reporter, "error");
    }

    return reporter;
};

/***/ }),

/***/ "../../node_modules/element-resize-detector/src/state-handler.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/element-resize-detector/src/state-handler.js ***!
  \***********************************************************************/
/***/ ((module) => {



var prop = "_erd";

function initState(element) {
    element[prop] = {};
    return getState(element);
}

function getState(element) {
    return element[prop];
}

function cleanState(element) {
    delete element[prop];
}

module.exports = {
    initState: initState,
    getState: getState,
    cleanState: cleanState
};


/***/ }),

/***/ "../../node_modules/pub-sub-es/src/index.js":
/*!**************************************************!*\
  !*** ../../node_modules/pub-sub-es/src/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPubSub: () => (/* binding */ createPubSub),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   globalPubSub: () => (/* binding */ globalPubSub)
/* harmony export */ });
/**
 * A new or fake broadcast channel.
 * @type {BroadcastChannel|object}
 */
const bc = (() => {
  try {
    return new window.BroadcastChannel('pub-sub-es');
  } catch (e) {
    return { postMessage: () => {} };
  }
})();

/**
 * Get final event name
 * @param {string} eventName - Event name to be adjusted
 * @param {boolean} caseInsensitive - If `true`, `eventName` will be lowercased
 */
const getEventName = (eventName, caseInsensitive) =>
  caseInsensitive ? eventName.toLowerCase() : eventName;

/**
 * Setup subscriber.
 * @param {object} stack - The bound event stack.
 * @return {function} - Curried function for subscribing to an event on a
 *   specific event stack.
 */
const subscribe = (stack, { caseInsensitive } = {}) =>
  /**
   * Subscribe to an event.
   * @param {string} event - Event name to subscribe to.
   * @param {function} handler - Function to be called when event of type
   *   `event` is published.
   * @param {number} times - Number of times the handler should called for the
   *   given event. The event listener will automatically be unsubscribed once
   *   the number of calls exceeds `times`.
   * @return {object} Object with the event name and the handler. The object
   *   can be used to unsubscribe.
   */
  (event, handler, times = Infinity) => {
    const e = getEventName(event, caseInsensitive);

    if (!stack[e]) {
      stack[e] = [];
      stack.__times__[e] = [];
    }

    stack[e].push(handler);
    stack.__times__[e].push(+times || Infinity);

    return { event: e, handler };
  };

/**
 * Setup unsubscriber.
 * @param {object} stack - The bound event stack.
 * @return {function} - Curried function for unsubscribing an event from a
 *   specific event stack.
 */
const unsubscribe = (stack, { caseInsensitive } = {}) =>
  /**
   * Unsubscribe from event.
   * @curried
   * @param {string|object} event - Event from which to unsubscribe or the return
   *   object provided by `subscribe()`.
   * @param {function} handler - Handler function to be unsubscribed. It is
   *   ignored if `id` is provided.
   */
  (event, handler) => {
    if (typeof event === 'object') {
      handler = event.handler; // eslint-disable-line no-param-reassign
      event = event.event; // eslint-disable-line no-param-reassign
    }

    const e = getEventName(event, caseInsensitive);

    if (!stack[e]) return;

    const id = stack[e].indexOf(handler);

    if (id === -1 || id >= stack[e].length) return;

    stack[e].splice(id, 1);
    stack.__times__[e].splice(id, 1);
  };

/**
 * Inform listeners about some news
 * @param {array} listeners - List of listeners
 * @param {*} news - News object
 */
const inform = (listeners, news) => () => {
  listeners.forEach((listener) => listener(news));
};

/**
 * Setup the publisher.
 * @param  {object} stack - The bound event stack.
 * @param  {boolean} isGlobal - If `true` event will be published globally.
 * @return {function} - Curried function for publishing an event on a specific
 *   event stack.
 */
const publish = (stack, { isGlobal, caseInsensitive, async } = {}) => {
  const unsubscriber = unsubscribe(stack);

  /**
   * Public interface for publishing an event.
   * @curried
   * @param {string} event - Event type to be published.
   * @param {any} news - The news to be published.
   * @param {object} options - Option object with
   *   - {boolean} isNoGlobalBroadcast - If `true` event will *not* be
   *     broadcasted gloablly even if `isGlobal` is `true`.
   *   - {boolean} async - If `true` event will *not* be broadcasted
   *     synchronously even if `async` is `false` globally.
   */
  return (event, news, options = {}) => {
    const e = getEventName(event, caseInsensitive);

    if (!stack[e]) return;

    const listeners = [...stack[e]];

    listeners.forEach((listener, i) => {
      if (--stack.__times__[e][i] < 1) unsubscriber(e, listener);
    });

    if (async || options.async) {
      setTimeout(inform(listeners, news), 0);
    } else {
      inform(listeners, news)();
    }

    if (isGlobal && !options.isNoGlobalBroadcast) {
      try {
        bc.postMessage({ event: e, news });
      } catch (error) {
        if (error instanceof DOMException) {
          console.warn(
            `Could not broadcast '${e}' globally. Payload is not clonable.`
          );
        } else {
          throw error;
        }
      }
    }
  };
};

/**
 * Setup event clearer
 * @param {object} stack - The bound event stack.
 * @return {function} - A curried function removing all event listeners on a
 *   specific event stack.
 */
const clear = (stack) =>
  /**
   * Remove all event listeners and unset listening times
   * @curried
   */
  () => {
    Object.keys(stack)
      .filter((eventName) => eventName[0] !== '_')
      .forEach((eventName) => {
        stack[eventName] = undefined;
        stack.__times__[eventName] = undefined;
        delete stack[eventName];
        delete stack.__times__[eventName];
      });
  };

/**
 * Create a new empty stack object
 * @return {object} - An empty stack object.
 */
const createEmptyStack = () => ({ __times__: {} });

/**
 * Create a new pub-sub instance
 * @param {object} stack - Object to be used as the event stack.
 * @return {object} - A new pub-sub instance.
 */
const createPubSub = ({
  async = false,
  caseInsensitive = false,
  stack = createEmptyStack(),
} = {}) => {
  if (!stack.__times__) stack.__times__ = {};

  return {
    publish: publish(stack, { async, caseInsensitive }),
    subscribe: subscribe(stack, { caseInsensitive }),
    unsubscribe: unsubscribe(stack, { caseInsensitive }),
    clear: clear(stack),
    stack,
  };
};

/**
 * Global pub-sub stack object
 * @type {object}
 */
const globalPubSubStack = createEmptyStack();
/**
 * Global pub-sub stack instance
 * @type {object}
 */
const globalPubSub = {
  publish: publish(globalPubSubStack, { isGlobal: true }),
  subscribe: subscribe(globalPubSubStack),
  unsubscribe: unsubscribe(globalPubSubStack),
  stack: globalPubSubStack,
};
bc.onmessage = ({ data: { event, news } }) =>
  globalPubSub.publish(event, news, true);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPubSub);


/***/ }),

/***/ "../../node_modules/regl-scatterplot/dist/regl-scatterplot.esm.js":
/*!************************************************************************!*\
  !*** ../../node_modules/regl-scatterplot/dist/regl-scatterplot.esm.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRegl: () => (/* binding */ createRegl),
/* harmony export */   createTextureFromUrl: () => (/* binding */ createTextureFromUrl),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var pub_sub_es__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! pub-sub-es */ "../../node_modules/pub-sub-es/src/index.js");
/* harmony import */ var regl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! regl */ "../../node_modules/regl/dist/regl.js");
/* harmony import */ var regl__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(regl__WEBPACK_IMPORTED_MODULE_1__);



/**
 * Common utilities
 * @module glMatrix
 */
// Configuration Constants
var EPSILON = 0.000001;
var ARRAY_TYPE = typeof Float32Array !== 'undefined' ? Float32Array : Array;
if (!Math.hypot) Math.hypot = function () {
  var y = 0,
      i = arguments.length;

  while (i--) {
    y += arguments[i] * arguments[i];
  }

  return Math.sqrt(y);
};

/**
 * 4x4 Matrix<br>Format: column-major, when typed out it looks like row-major<br>The matrices are being post multiplied.
 * @module mat4
 */

/**
 * Creates a new identity mat4
 *
 * @returns {mat4} a new 4x4 matrix
 */

function create$2() {
  var out = new ARRAY_TYPE(16);

  if (ARRAY_TYPE != Float32Array) {
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
    out[4] = 0;
    out[6] = 0;
    out[7] = 0;
    out[8] = 0;
    out[9] = 0;
    out[11] = 0;
    out[12] = 0;
    out[13] = 0;
    out[14] = 0;
  }

  out[0] = 1;
  out[5] = 1;
  out[10] = 1;
  out[15] = 1;
  return out;
}
/**
 * Creates a new mat4 initialized with values from an existing matrix
 *
 * @param {ReadonlyMat4} a matrix to clone
 * @returns {mat4} a new 4x4 matrix
 */

function clone(a) {
  var out = new ARRAY_TYPE(16);
  out[0] = a[0];
  out[1] = a[1];
  out[2] = a[2];
  out[3] = a[3];
  out[4] = a[4];
  out[5] = a[5];
  out[6] = a[6];
  out[7] = a[7];
  out[8] = a[8];
  out[9] = a[9];
  out[10] = a[10];
  out[11] = a[11];
  out[12] = a[12];
  out[13] = a[13];
  out[14] = a[14];
  out[15] = a[15];
  return out;
}
/**
 * Inverts a mat4
 *
 * @param {mat4} out the receiving matrix
 * @param {ReadonlyMat4} a the source matrix
 * @returns {mat4} out
 */

function invert(out, a) {
  var a00 = a[0],
      a01 = a[1],
      a02 = a[2],
      a03 = a[3];
  var a10 = a[4],
      a11 = a[5],
      a12 = a[6],
      a13 = a[7];
  var a20 = a[8],
      a21 = a[9],
      a22 = a[10],
      a23 = a[11];
  var a30 = a[12],
      a31 = a[13],
      a32 = a[14],
      a33 = a[15];
  var b00 = a00 * a11 - a01 * a10;
  var b01 = a00 * a12 - a02 * a10;
  var b02 = a00 * a13 - a03 * a10;
  var b03 = a01 * a12 - a02 * a11;
  var b04 = a01 * a13 - a03 * a11;
  var b05 = a02 * a13 - a03 * a12;
  var b06 = a20 * a31 - a21 * a30;
  var b07 = a20 * a32 - a22 * a30;
  var b08 = a20 * a33 - a23 * a30;
  var b09 = a21 * a32 - a22 * a31;
  var b10 = a21 * a33 - a23 * a31;
  var b11 = a22 * a33 - a23 * a32; // Calculate the determinant

  var det = b00 * b11 - b01 * b10 + b02 * b09 + b03 * b08 - b04 * b07 + b05 * b06;

  if (!det) {
    return null;
  }

  det = 1.0 / det;
  out[0] = (a11 * b11 - a12 * b10 + a13 * b09) * det;
  out[1] = (a02 * b10 - a01 * b11 - a03 * b09) * det;
  out[2] = (a31 * b05 - a32 * b04 + a33 * b03) * det;
  out[3] = (a22 * b04 - a21 * b05 - a23 * b03) * det;
  out[4] = (a12 * b08 - a10 * b11 - a13 * b07) * det;
  out[5] = (a00 * b11 - a02 * b08 + a03 * b07) * det;
  out[6] = (a32 * b02 - a30 * b05 - a33 * b01) * det;
  out[7] = (a20 * b05 - a22 * b02 + a23 * b01) * det;
  out[8] = (a10 * b10 - a11 * b08 + a13 * b06) * det;
  out[9] = (a01 * b08 - a00 * b10 - a03 * b06) * det;
  out[10] = (a30 * b04 - a31 * b02 + a33 * b00) * det;
  out[11] = (a21 * b02 - a20 * b04 - a23 * b00) * det;
  out[12] = (a11 * b07 - a10 * b09 - a12 * b06) * det;
  out[13] = (a00 * b09 - a01 * b07 + a02 * b06) * det;
  out[14] = (a31 * b01 - a30 * b03 - a32 * b00) * det;
  out[15] = (a20 * b03 - a21 * b01 + a22 * b00) * det;
  return out;
}
/**
 * Multiplies two mat4s
 *
 * @param {mat4} out the receiving matrix
 * @param {ReadonlyMat4} a the first operand
 * @param {ReadonlyMat4} b the second operand
 * @returns {mat4} out
 */

function multiply(out, a, b) {
  var a00 = a[0],
      a01 = a[1],
      a02 = a[2],
      a03 = a[3];
  var a10 = a[4],
      a11 = a[5],
      a12 = a[6],
      a13 = a[7];
  var a20 = a[8],
      a21 = a[9],
      a22 = a[10],
      a23 = a[11];
  var a30 = a[12],
      a31 = a[13],
      a32 = a[14],
      a33 = a[15]; // Cache only the current line of the second matrix

  var b0 = b[0],
      b1 = b[1],
      b2 = b[2],
      b3 = b[3];
  out[0] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
  out[1] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
  out[2] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
  out[3] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
  b0 = b[4];
  b1 = b[5];
  b2 = b[6];
  b3 = b[7];
  out[4] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
  out[5] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
  out[6] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
  out[7] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
  b0 = b[8];
  b1 = b[9];
  b2 = b[10];
  b3 = b[11];
  out[8] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
  out[9] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
  out[10] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
  out[11] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
  b0 = b[12];
  b1 = b[13];
  b2 = b[14];
  b3 = b[15];
  out[12] = b0 * a00 + b1 * a10 + b2 * a20 + b3 * a30;
  out[13] = b0 * a01 + b1 * a11 + b2 * a21 + b3 * a31;
  out[14] = b0 * a02 + b1 * a12 + b2 * a22 + b3 * a32;
  out[15] = b0 * a03 + b1 * a13 + b2 * a23 + b3 * a33;
  return out;
}
/**
 * Creates a matrix from a vector translation
 * This is equivalent to (but much faster than):
 *
 *     mat4.identity(dest);
 *     mat4.translate(dest, dest, vec);
 *
 * @param {mat4} out mat4 receiving operation result
 * @param {ReadonlyVec3} v Translation vector
 * @returns {mat4} out
 */

function fromTranslation(out, v) {
  out[0] = 1;
  out[1] = 0;
  out[2] = 0;
  out[3] = 0;
  out[4] = 0;
  out[5] = 1;
  out[6] = 0;
  out[7] = 0;
  out[8] = 0;
  out[9] = 0;
  out[10] = 1;
  out[11] = 0;
  out[12] = v[0];
  out[13] = v[1];
  out[14] = v[2];
  out[15] = 1;
  return out;
}
/**
 * Creates a matrix from a vector scaling
 * This is equivalent to (but much faster than):
 *
 *     mat4.identity(dest);
 *     mat4.scale(dest, dest, vec);
 *
 * @param {mat4} out mat4 receiving operation result
 * @param {ReadonlyVec3} v Scaling vector
 * @returns {mat4} out
 */

function fromScaling(out, v) {
  out[0] = v[0];
  out[1] = 0;
  out[2] = 0;
  out[3] = 0;
  out[4] = 0;
  out[5] = v[1];
  out[6] = 0;
  out[7] = 0;
  out[8] = 0;
  out[9] = 0;
  out[10] = v[2];
  out[11] = 0;
  out[12] = 0;
  out[13] = 0;
  out[14] = 0;
  out[15] = 1;
  return out;
}
/**
 * Creates a matrix from a given angle around a given axis
 * This is equivalent to (but much faster than):
 *
 *     mat4.identity(dest);
 *     mat4.rotate(dest, dest, rad, axis);
 *
 * @param {mat4} out mat4 receiving operation result
 * @param {Number} rad the angle to rotate the matrix by
 * @param {ReadonlyVec3} axis the axis to rotate around
 * @returns {mat4} out
 */

function fromRotation(out, rad, axis) {
  var x = axis[0],
      y = axis[1],
      z = axis[2];
  var len = Math.hypot(x, y, z);
  var s, c, t;

  if (len < EPSILON) {
    return null;
  }

  len = 1 / len;
  x *= len;
  y *= len;
  z *= len;
  s = Math.sin(rad);
  c = Math.cos(rad);
  t = 1 - c; // Perform rotation-specific matrix multiplication

  out[0] = x * x * t + c;
  out[1] = y * x * t + z * s;
  out[2] = z * x * t - y * s;
  out[3] = 0;
  out[4] = x * y * t - z * s;
  out[5] = y * y * t + c;
  out[6] = z * y * t + x * s;
  out[7] = 0;
  out[8] = x * z * t + y * s;
  out[9] = y * z * t - x * s;
  out[10] = z * z * t + c;
  out[11] = 0;
  out[12] = 0;
  out[13] = 0;
  out[14] = 0;
  out[15] = 1;
  return out;
}
/**
 * Returns the translation vector component of a transformation
 *  matrix. If a matrix is built with fromRotationTranslation,
 *  the returned vector will be the same as the translation vector
 *  originally supplied.
 * @param  {vec3} out Vector to receive translation component
 * @param  {ReadonlyMat4} mat Matrix to be decomposed (input)
 * @return {vec3} out
 */

function getTranslation(out, mat) {
  out[0] = mat[12];
  out[1] = mat[13];
  out[2] = mat[14];
  return out;
}
/**
 * Returns the scaling factor component of a transformation
 *  matrix. If a matrix is built with fromRotationTranslationScale
 *  with a normalized Quaternion paramter, the returned vector will be
 *  the same as the scaling vector
 *  originally supplied.
 * @param  {vec3} out Vector to receive scaling factor component
 * @param  {ReadonlyMat4} mat Matrix to be decomposed (input)
 * @return {vec3} out
 */

function getScaling(out, mat) {
  var m11 = mat[0];
  var m12 = mat[1];
  var m13 = mat[2];
  var m21 = mat[4];
  var m22 = mat[5];
  var m23 = mat[6];
  var m31 = mat[8];
  var m32 = mat[9];
  var m33 = mat[10];
  out[0] = Math.hypot(m11, m12, m13);
  out[1] = Math.hypot(m21, m22, m23);
  out[2] = Math.hypot(m31, m32, m33);
  return out;
}

/**
 * 4 Dimensional Vector
 * @module vec4
 */

/**
 * Creates a new, empty vec4
 *
 * @returns {vec4} a new 4D vector
 */

function create$1() {
  var out = new ARRAY_TYPE(4);

  if (ARRAY_TYPE != Float32Array) {
    out[0] = 0;
    out[1] = 0;
    out[2] = 0;
    out[3] = 0;
  }

  return out;
}
/**
 * Transforms the vec4 with a mat4.
 *
 * @param {vec4} out the receiving vector
 * @param {ReadonlyVec4} a the vector to transform
 * @param {ReadonlyMat4} m matrix to transform with
 * @returns {vec4} out
 */

function transformMat4(out, a, m) {
  var x = a[0],
      y = a[1],
      z = a[2],
      w = a[3];
  out[0] = m[0] * x + m[4] * y + m[8] * z + m[12] * w;
  out[1] = m[1] * x + m[5] * y + m[9] * z + m[13] * w;
  out[2] = m[2] * x + m[6] * y + m[10] * z + m[14] * w;
  out[3] = m[3] * x + m[7] * y + m[11] * z + m[15] * w;
  return out;
}
/**
 * Perform some operation over an array of vec4s.
 *
 * @param {Array} a the array of vectors to iterate over
 * @param {Number} stride Number of elements between the start of each vec4. If 0 assumes tightly packed
 * @param {Number} offset Number of elements to skip at the beginning of the array
 * @param {Number} count Number of vec4s to iterate over. If 0 iterates over entire array
 * @param {Function} fn Function to call for each vector in the array
 * @param {Object} [arg] additional argument to pass to fn
 * @returns {Array} a
 * @function
 */

(function () {
  var vec = create$1();
  return function (a, stride, offset, count, fn, arg) {
    var i, l;

    if (!stride) {
      stride = 4;
    }

    if (!offset) {
      offset = 0;
    }

    if (count) {
      l = Math.min(count * stride + offset, a.length);
    } else {
      l = a.length;
    }

    for (i = offset; i < l; i += stride) {
      vec[0] = a[i];
      vec[1] = a[i + 1];
      vec[2] = a[i + 2];
      vec[3] = a[i + 3];
      fn(vec, vec, arg);
      a[i] = vec[0];
      a[i + 1] = vec[1];
      a[i + 2] = vec[2];
      a[i + 3] = vec[3];
    }

    return a;
  };
})();

/**
 * 2 Dimensional Vector
 * @module vec2
 */

/**
 * Creates a new, empty vec2
 *
 * @returns {vec2} a new 2D vector
 */

function create() {
  var out = new ARRAY_TYPE(2);

  if (ARRAY_TYPE != Float32Array) {
    out[0] = 0;
    out[1] = 0;
  }

  return out;
}
/**
 * Get the angle between two 2D vectors
 * @param {ReadonlyVec2} a The first operand
 * @param {ReadonlyVec2} b The second operand
 * @returns {Number} The angle in radians
 */

function angle(a, b) {
  var x1 = a[0],
      y1 = a[1],
      x2 = b[0],
      y2 = b[1],
      // mag is the product of the magnitudes of a and b
  mag = Math.sqrt(x1 * x1 + y1 * y1) * Math.sqrt(x2 * x2 + y2 * y2),
      // mag &&.. short circuits if mag == 0
  cosine = mag && (x1 * x2 + y1 * y2) / mag; // Math.min(Math.max(cosine, -1), 1) clamps the cosine between -1 and 1

  return Math.acos(Math.min(Math.max(cosine, -1), 1));
}
/**
 * Perform some operation over an array of vec2s.
 *
 * @param {Array} a the array of vectors to iterate over
 * @param {Number} stride Number of elements between the start of each vec2. If 0 assumes tightly packed
 * @param {Number} offset Number of elements to skip at the beginning of the array
 * @param {Number} count Number of vec2s to iterate over. If 0 iterates over entire array
 * @param {Function} fn Function to call for each vector in the array
 * @param {Object} [arg] additional argument to pass to fn
 * @returns {Array} a
 * @function
 */

(function () {
  var vec = create();
  return function (a, stride, offset, count, fn, arg) {
    var i, l;

    if (!stride) {
      stride = 2;
    }

    if (!offset) {
      offset = 0;
    }

    if (count) {
      l = Math.min(count * stride + offset, a.length);
    } else {
      l = a.length;
    }

    for (i = offset; i < l; i += stride) {
      vec[0] = a[i];
      vec[1] = a[i + 1];
      fn(vec, vec, arg);
      a[i] = vec[0];
      a[i + 1] = vec[1];
    }

    return a;
  };
})();

const createCamera = (
  initTarget = [0, 0],
  initDistance = 1,
  initRotation = 0,
  initViewCenter = [0, 0],
  initScaleBounds = [0, Infinity]
) => {
  // Scratch variables
  const scratch0 = new Float32Array(16);
  const scratch1 = new Float32Array(16);
  const scratch2 = new Float32Array(16);

  let view = create$2();
  let viewCenter = [...initViewCenter.slice(0, 2), 0, 1];

  const scaleBounds = [...initScaleBounds];

  const getRotation = () => Math.acos(view[0] / getScaling$1());

  const getScaling$1 = () => getScaling(scratch0, view)[0];

  const getScaleBounds = () => [...scaleBounds];

  const getDistance = () => 1 / getScaling$1();

  const getTranslation$1 = () => getTranslation(scratch0, view).slice(0, 2);

  const getTarget = () =>
    transformMat4(scratch0, viewCenter, invert(scratch2, view))
      .slice(0, 2);

  const getView = () => view;

  const getViewCenter = () => viewCenter.slice(0, 2);

  const lookAt = ([x = 0, y = 0] = [], newDistance = 1, newRotation = 0) => {
    // Reset the view
    view = create$2();

    translate([-x, -y]);
    rotate(newRotation);
    scale(1 / newDistance);
  };

  const translate = ([x = 0, y = 0] = []) => {
    scratch0[0] = x;
    scratch0[1] = y;
    scratch0[2] = 0;

    const t = fromTranslation(scratch1, scratch0);

    // Translate about the viewport center
    // This is identical to `i * t * i * view` where `i` is the identity matrix
    multiply(view, t, view);
  };

  const scale = (d, mousePos) => {
    if (d <= 0) return;

    const scale = getScaling$1();
    const newScale = scale * d;

    d = Math.max(scaleBounds[0], Math.min(newScale, scaleBounds[1])) / scale;

    if (d === 1) return; // There is nothing to do

    scratch0[0] = d;
    scratch0[1] = d;
    scratch0[2] = 1;

    const s = fromScaling(scratch1, scratch0);

    const scaleCenter = mousePos ? [...mousePos, 0] : viewCenter;
    const a = fromTranslation(scratch0, scaleCenter);

    // Translate about the scale center
    // I.e., the mouse position or the view center
    multiply(
      view,
      a,
      multiply(
        view,
        s,
        multiply(view, invert(scratch2, a), view)
      )
    );
  };

  const rotate = rad => {
    const r = create$2();
    fromRotation(r, rad, [0, 0, 1]);

    // Rotate about the viewport center
    // This is identical to `i * r * i * view` where `i` is the identity matrix
    multiply(view, r, view);
  };

  const setScaleBounds = newBounds => {
    scaleBounds[0] = newBounds[0];
    scaleBounds[1] = newBounds[1];
  };

  const setView = newView => {
    if (!newView || newView.length < 16) return;
    view = newView;
  };

  const setViewCenter = newViewCenter => {
    viewCenter = [...newViewCenter.slice(0, 2), 0, 1];
  };

  const reset = () => {
    lookAt(initTarget, initDistance, initRotation);
  };

  // Init
  lookAt(initTarget, initDistance, initRotation);

  return {
    get translation() {
      return getTranslation$1();
    },
    get target() {
      return getTarget();
    },
    get scaling() {
      return getScaling$1();
    },
    get scaleBounds() {
      return getScaleBounds();
    },
    get distance() {
      return getDistance();
    },
    get rotation() {
      return getRotation();
    },
    get view() {
      return getView();
    },
    get viewCenter() {
      return getViewCenter();
    },
    lookAt,
    translate,
    pan: translate,
    rotate,
    scale,
    zoom: scale,
    reset,
    set: (...args) => {
      console.warn("`set()` is deprecated. Please use `setView()` instead.");
      return setView(...args);
    },
    setScaleBounds,
    setView,
    setViewCenter
  };
};

const MOUSE_DOWN_MOVE_ACTIONS = ["pan", "rotate"];
const KEY_MAP = {
  alt: "altKey",
  cmd: "metaKey",
  ctrl: "ctrlKey",
  meta: "metaKey",
  shift: "shiftKey"
};

const dom2dCamera = (
  element,
  {
    distance = 1.0,
    target = [0, 0],
    rotation = 0,
    isNdc = true,
    isFixed = false,
    isPan = true,
    panSpeed = 1,
    isRotate = true,
    rotateSpeed = 1,
    defaultMouseDownMoveAction = "pan",
    mouseDownMoveModKey = "alt",
    isZoom = true,
    zoomSpeed = 1,
    viewCenter,
    scaleBounds,
    onKeyDown = () => {},
    onKeyUp = () => {},
    onMouseDown = () => {},
    onMouseUp = () => {},
    onMouseMove = () => {},
    onWheel = () => {}
  } = {}
) => {
  let camera = createCamera(
    target,
    distance,
    rotation,
    viewCenter,
    scaleBounds
  );
  let isChanged = false;
  let mouseX = 0;
  let mouseY = 0;
  let prevMouseX = 0;
  let prevMouseY = 0;
  let isLeftMousePressed = false;
  let yScroll = 0;

  let width = 1;
  let height = 1;
  let aspectRatio = 1;
  let isMouseDownMoveModActive = false;

  let panOnMouseDownMove = defaultMouseDownMoveAction === "pan";

  const transformPanX = isNdc
    ? dX => (dX / width) * 2 * aspectRatio // to normalized device coords
    : dX => dX;
  const transformPanY = isNdc
    ? dY => (dY / height) * 2 // to normalized device coords
    : dY => -dY;

  const transformScaleX = isNdc
    ? x => (-1 + (x / width) * 2) * aspectRatio // to normalized device coords
    : x => x;
  const transformScaleY = isNdc
    ? y => 1 - (y / height) * 2 // to normalized device coords
    : y => y;

  const tick = () => {
    if (isFixed) return false;

    isChanged = false;

    if (
      isPan &&
      isLeftMousePressed &&
      ((panOnMouseDownMove && !isMouseDownMoveModActive) ||
        (!panOnMouseDownMove && isMouseDownMoveModActive))
    ) {
      // To pan 1:1 we need to half the width and height because the uniform
      // coordinate system goes from -1 to 1.
      camera.pan([
        transformPanX(panSpeed * (mouseX - prevMouseX)),
        transformPanY(panSpeed * (prevMouseY - mouseY))
      ]);
      isChanged = true;
    }

    if (isZoom && yScroll) {
      const dZ = zoomSpeed * Math.exp(yScroll / height);

      // Get normalized device coordinates (NDC)
      const transformedX = transformScaleX(mouseX);
      const transformedY = transformScaleY(mouseY);

      camera.scale(1 / dZ, [transformedX, transformedY]);

      isChanged = true;
    }

    if (
      isRotate &&
      isLeftMousePressed &&
      ((panOnMouseDownMove && isMouseDownMoveModActive) ||
        (!panOnMouseDownMove && !isMouseDownMoveModActive))
    ) {
      const wh = width / 2;
      const hh = height / 2;
      const x1 = prevMouseX - wh;
      const y1 = hh - prevMouseY;
      const x2 = mouseX - wh;
      const y2 = hh - mouseY;
      // Angle between the start and end mouse position with respect to the
      // viewport center
      const radians = angle([x1, y1], [x2, y2]);
      // Determine the orientation
      const cross = x1 * y2 - x2 * y1;

      camera.rotate(rotateSpeed * radians * Math.sign(cross));

      isChanged = true;
    }

    // Reset scroll delta and mouse position
    yScroll = 0;
    prevMouseX = mouseX;
    prevMouseY = mouseY;

    return isChanged;
  };

  const config = ({
    defaultMouseDownMoveAction: newDefaultMouseDownMoveAction = null,
    isFixed: newIsFixed = null,
    isPan: newIsPan = null,
    isRotate: newIsRotate = null,
    isZoom: newIsZoom = null,
    panSpeed: newPanSpeed = null,
    rotateSpeed: newRotateSpeed = null,
    zoomSpeed: newZoomSpeed = null,
    mouseDownMoveModKey: newMouseDownMoveModKey = null
  } = {}) => {
    defaultMouseDownMoveAction =
      newDefaultMouseDownMoveAction !== null &&
      MOUSE_DOWN_MOVE_ACTIONS.includes(newDefaultMouseDownMoveAction)
        ? newDefaultMouseDownMoveAction
        : defaultMouseDownMoveAction;

    panOnMouseDownMove = defaultMouseDownMoveAction === "pan";

    isFixed = newIsFixed !== null ? newIsFixed : isFixed;
    isPan = newIsPan !== null ? newIsPan : isPan;
    isRotate = newIsRotate !== null ? newIsRotate : isRotate;
    isZoom = newIsZoom !== null ? newIsZoom : isZoom;
    panSpeed = +newPanSpeed > 0 ? newPanSpeed : panSpeed;
    rotateSpeed = +newRotateSpeed > 0 ? newRotateSpeed : rotateSpeed;
    zoomSpeed = +newZoomSpeed > 0 ? newZoomSpeed : zoomSpeed;

    mouseDownMoveModKey =
      newMouseDownMoveModKey !== null &&
      Object.keys(KEY_MAP).includes(newMouseDownMoveModKey)
        ? newMouseDownMoveModKey
        : mouseDownMoveModKey;
  };

  const refresh = () => {
    console.warn(
      "refresh() is deprecated. You do not have to call it anymore."
    );
  };

  const keyUpHandler = event => {
    isMouseDownMoveModActive = false;

    onKeyUp(event);
  };

  const keyDownHandler = event => {
    isMouseDownMoveModActive = event[KEY_MAP[mouseDownMoveModKey]];

    onKeyDown(event);
  };

  const mouseUpHandler = event => {
    isLeftMousePressed = false;

    onMouseUp(event);
  };

  const mouseDownHandler = event => {
    isLeftMousePressed = event.buttons === 1;

    onMouseDown(event);
  };

  const mouseMoveHandler = event => {
    prevMouseX = mouseX;
    prevMouseY = mouseY;

    // Normalize mouse coordinates
    const bBox = element.getBoundingClientRect();
    mouseX = event.clientX - bBox.left;
    mouseY = event.clientY - bBox.top;

    // Since we caculated the bBox already lets update some other props too
    width = bBox.width;
    height = bBox.height;
    aspectRatio = width / height;

    onMouseMove(event);
  };

  const wheelHandler = event => {
    event.preventDefault();

    const scale = event.deltaMode === 1 ? 12 : 1;

    yScroll += scale * (event.deltaY || 0);

    onWheel(event);
  };

  const dispose = () => {
    camera = undefined;
    window.removeEventListener("keydown", keyDownHandler);
    window.removeEventListener("keyup", keyUpHandler);
    element.removeEventListener("mousedown", mouseDownHandler);
    window.removeEventListener("mouseup", mouseUpHandler);
    window.removeEventListener("mousemove", mouseMoveHandler);
    element.removeEventListener("wheel", wheelHandler);
  };

  window.addEventListener("keydown", keyDownHandler, { passive: true });
  window.addEventListener("keyup", keyUpHandler, { passive: true });
  element.addEventListener("mousedown", mouseDownHandler, { passive: true });
  window.addEventListener("mouseup", mouseUpHandler, { passive: true });
  window.addEventListener("mousemove", mouseMoveHandler, { passive: true });
  element.addEventListener("wheel", wheelHandler, { passive: false });

  camera.config = config;
  camera.dispose = dispose;
  camera.refresh = refresh;
  camera.tick = tick;

  return camera;
};

function sortKD(ids, coords, nodeSize, left, right, depth) {
    if (right - left <= nodeSize) return;

    const m = (left + right) >> 1;

    select(ids, coords, m, left, right, depth % 2);

    sortKD(ids, coords, nodeSize, left, m - 1, depth + 1);
    sortKD(ids, coords, nodeSize, m + 1, right, depth + 1);
}

function select(ids, coords, k, left, right, inc) {

    while (right > left) {
        if (right - left > 600) {
            const n = right - left + 1;
            const m = k - left + 1;
            const z = Math.log(n);
            const s = 0.5 * Math.exp(2 * z / 3);
            const sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
            const newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
            const newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
            select(ids, coords, k, newLeft, newRight, inc);
        }

        const t = coords[2 * k + inc];
        let i = left;
        let j = right;

        swapItem(ids, coords, left, k);
        if (coords[2 * right + inc] > t) swapItem(ids, coords, left, right);

        while (i < j) {
            swapItem(ids, coords, i, j);
            i++;
            j--;
            while (coords[2 * i + inc] < t) i++;
            while (coords[2 * j + inc] > t) j--;
        }

        if (coords[2 * left + inc] === t) swapItem(ids, coords, left, j);
        else {
            j++;
            swapItem(ids, coords, j, right);
        }

        if (j <= k) left = j + 1;
        if (k <= j) right = j - 1;
    }
}

function swapItem(ids, coords, i, j) {
    swap(ids, i, j);
    swap(coords, 2 * i, 2 * j);
    swap(coords, 2 * i + 1, 2 * j + 1);
}

function swap(arr, i, j) {
    const tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
}

function range(ids, coords, minX, minY, maxX, maxY, nodeSize) {
    const stack = [0, ids.length - 1, 0];
    const result = [];
    let x, y;

    while (stack.length) {
        const axis = stack.pop();
        const right = stack.pop();
        const left = stack.pop();

        if (right - left <= nodeSize) {
            for (let i = left; i <= right; i++) {
                x = coords[2 * i];
                y = coords[2 * i + 1];
                if (x >= minX && x <= maxX && y >= minY && y <= maxY) result.push(ids[i]);
            }
            continue;
        }

        const m = Math.floor((left + right) / 2);

        x = coords[2 * m];
        y = coords[2 * m + 1];

        if (x >= minX && x <= maxX && y >= minY && y <= maxY) result.push(ids[m]);

        const nextAxis = (axis + 1) % 2;

        if (axis === 0 ? minX <= x : minY <= y) {
            stack.push(left);
            stack.push(m - 1);
            stack.push(nextAxis);
        }
        if (axis === 0 ? maxX >= x : maxY >= y) {
            stack.push(m + 1);
            stack.push(right);
            stack.push(nextAxis);
        }
    }

    return result;
}

function within(ids, coords, qx, qy, r, nodeSize) {
    const stack = [0, ids.length - 1, 0];
    const result = [];
    const r2 = r * r;

    while (stack.length) {
        const axis = stack.pop();
        const right = stack.pop();
        const left = stack.pop();

        if (right - left <= nodeSize) {
            for (let i = left; i <= right; i++) {
                if (sqDist(coords[2 * i], coords[2 * i + 1], qx, qy) <= r2) result.push(ids[i]);
            }
            continue;
        }

        const m = Math.floor((left + right) / 2);

        const x = coords[2 * m];
        const y = coords[2 * m + 1];

        if (sqDist(x, y, qx, qy) <= r2) result.push(ids[m]);

        const nextAxis = (axis + 1) % 2;

        if (axis === 0 ? qx - r <= x : qy - r <= y) {
            stack.push(left);
            stack.push(m - 1);
            stack.push(nextAxis);
        }
        if (axis === 0 ? qx + r >= x : qy + r >= y) {
            stack.push(m + 1);
            stack.push(right);
            stack.push(nextAxis);
        }
    }

    return result;
}

function sqDist(ax, ay, bx, by) {
    const dx = ax - bx;
    const dy = ay - by;
    return dx * dx + dy * dy;
}

const defaultGetX = p => p[0];
const defaultGetY = p => p[1];

class KDBush {
    constructor(points, getX = defaultGetX, getY = defaultGetY, nodeSize = 64, ArrayType = Float64Array) {
        this.nodeSize = nodeSize;
        this.points = points;

        const IndexArrayType = points.length < 65536 ? Uint16Array : Uint32Array;

        const ids = this.ids = new IndexArrayType(points.length);
        const coords = this.coords = new ArrayType(points.length * 2);

        for (let i = 0; i < points.length; i++) {
            ids[i] = i;
            coords[2 * i] = getX(points[i]);
            coords[2 * i + 1] = getY(points[i]);
        }

        sortKD(ids, coords, nodeSize, 0, ids.length - 1, 0);
    }

    range(minX, minY, maxX, maxY) {
        return range(this.ids, this.coords, minX, minY, maxX, maxY, this.nodeSize);
    }

    within(x, y, r) {
        return within(this.ids, this.coords, x, y, r, this.nodeSize);
    }
}

const FRAGMENT_SHADER$3 = `
precision mediump float;
varying vec4 color;
void main() {
  gl_FragColor = color;
}`;

// Vertex shader from https://mattdesl.svbtle.com/drawing-lines-is-hard
// The MIT License (MIT) Copyright (c) 2015 Matt DesLauriers
const VERTEX_SHADER$2 = `
uniform mat4 projectionViewModel;
uniform float aspectRatio;

uniform sampler2D colorTex;
uniform float colorTexRes;
uniform float colorTexEps;
uniform float width;
uniform float useOpacity;
uniform float useColorOpacity;
uniform int miter;

attribute vec3 prevPosition;
attribute vec3 currPosition;
attribute vec3 nextPosition;
attribute float opacity;
attribute float offsetScale;
attribute float colorIndex;

varying vec4 color;

void main() {
  vec2 aspectVec = vec2(aspectRatio, 1.0);
  vec4 prevProjected = projectionViewModel * vec4(prevPosition, 1.0);
  vec4 currProjected = projectionViewModel * vec4(currPosition, 1.0);
  vec4 nextProjected = projectionViewModel * vec4(nextPosition, 1.0);

  // get 2D screen space with W divide and aspect correction
  vec2 prevScreen = prevProjected.xy / prevProjected.w * aspectVec;
  vec2 currScreen = currProjected.xy / currProjected.w * aspectVec;
  vec2 nextScreen = nextProjected.xy / nextProjected.w * aspectVec;

  // starting point uses (next - current)
  vec2 dir = vec2(0.0);
  if (currScreen == prevScreen) {
    dir = normalize(nextScreen - currScreen);
  }
  // ending point uses (current - previous)
  else if (currScreen == nextScreen) {
    dir = normalize(currScreen - prevScreen);
  }
  // somewhere in middle, needs a join
  else {
    // get directions from (C - B) and (B - A)
    vec2 dirA = normalize((currScreen - prevScreen));
    if (miter == 1) {
      vec2 dirB = normalize((nextScreen - currScreen));
      // now compute the miter join normal and length
      vec2 tangent = normalize(dirA + dirB);
      vec2 perp = vec2(-dirA.y, dirA.x);
      vec2 miter = vec2(-tangent.y, tangent.x);
      dir = tangent;
    } else {
      dir = dirA;
    }
  }

  vec2 normal = vec2(-dir.y, dir.x) * width;
  normal.x /= aspectRatio;
  vec4 offset = vec4(normal * offsetScale, 0.0, 0.0);
  gl_Position = currProjected + offset;

  // Get color from texture
  float colorRowIndex = floor((colorIndex + colorTexEps) / colorTexRes);
  vec2 colorTexIndex = vec2(
    (colorIndex / colorTexRes) - colorRowIndex + colorTexEps,
    colorRowIndex / colorTexRes + colorTexEps
  );

  color = texture2D(colorTex, colorTexIndex);
  color.a = useColorOpacity * color.a + useOpacity * opacity;
}`;

const { push, splice } = Array.prototype;

const I = new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
const FLOAT_BYTES$1 = Float32Array.BYTES_PER_ELEMENT;

const createMesh = (numPointsPerLine, buffer = []) => {
  let numPrevPoints = 0;
  numPointsPerLine.forEach((numPoints) => {
    for (let i = 0; i < numPoints - 1; i++) {
      const a = numPrevPoints + i * 2; // `2`  because we duplicated all points
      const b = a + 1;
      const c = a + 2;
      const d = a + 3;
      buffer.push(a, b, c, c, b, d);
    }
    // Each line adds an additional start and end point, hence, `numPoints + 2`
    // And again, since all points are duplicated, we have `* 2`
    numPrevPoints += (numPoints + 2) * 2;
  });
  return buffer;
};

const Buffer = {
  duplicate(buffer, stride = 1, dupScale = 1) {
    const out = [];
    const component = new Array(stride * 2);
    for (let i = 0, il = buffer.length / stride; i < il; i++) {
      const index = i * stride;
      for (let j = 0; j < stride; j++) {
        const value = buffer[index + j];
        component[j] = value;
        component[j + stride] = value * dupScale;
      }
      push.apply(out, component);
    }
    return out;
  },

  mapElement(buffer, elementIndex, stride, map) {
    for (let i = 0, il = buffer.length / stride; i < il; i++) {
      const index = elementIndex + i * stride;
      buffer[index] = map(buffer[index], index, i);
    }
    return buffer;
  },

  copyElement(buffer, sourceElementIndex, targetIndex, stride) {
    const component = new Array(stride);
    const ai = sourceElementIndex * stride;
    // Copy source element component wise
    for (let i = 0; i < stride; i++) component[i] = buffer[ai + i];
    splice.call(buffer, targetIndex * stride, 0, ...component);
    return buffer;
  },

  increaseStride(buffer, stride, newStride, undefValue = 0) {
    const out = [];
    const component = new Array(newStride).fill(undefValue);
    for (let i = 0, il = buffer.length / stride; i < il; i++) {
      const index = i * stride;
      for (let j = 0; j < stride; j++) {
        component[j] = buffer[index + j];
      }
      push.apply(out, component);
    }
    return out;
  },
};

const createLine = (
  regl,
  {
    projection = I,
    model = I,
    view = I,
    points = [],
    colorIndices = [],
    color = [0.8, 0.5, 0, 1],
    opacity = null,
    opacities = [],
    width = 1,
    widths = [],
    miter = 1,
    is2d = false,
    zPos2d = 0,
  } = {}
) => {
  if (!regl) {
    console.error('Regl instance is undefined.');
    return;
  }

  const pvm = new Float32Array(16);

  let numLines;
  let numPoints;
  let numPointsPerLine;
  let pointsPadded;
  let pointsDup;
  let colorIndicesDup;
  let opacitiesDup;
  let widthsDup;
  let indices;
  let pointBuffer;
  let opacityBuffer;
  let widthBuffer;
  let colorTex;
  let colorTexRes;
  let colorIndexBuffer;
  let attributes;
  let elements;
  let drawLine;
  let dim = is2d ? 2 : 3;

  const useOpacity = () =>
    +(opacities.length === numPoints || opacity !== null);

  const init = () => {
    pointBuffer = regl.buffer();
    opacityBuffer = regl.buffer();
    widthBuffer = regl.buffer();
    colorIndexBuffer = regl.buffer();

    attributes = {
      prevPosition: {
        buffer: () => pointBuffer,
        offset: 0,
        stride: FLOAT_BYTES$1 * 3,
      },
      currPosition: {
        buffer: () => pointBuffer,
        // note that each point is duplicated, hence we need to skip over the first two
        offset: FLOAT_BYTES$1 * 3 * 2,
        stride: FLOAT_BYTES$1 * 3,
      },
      nextPosition: {
        buffer: () => pointBuffer,
        // note that each point is duplicated, hence we need to skip over the first four
        offset: FLOAT_BYTES$1 * 3 * 4,
        stride: FLOAT_BYTES$1 * 3,
      },
      opacity: {
        buffer: () => opacityBuffer,
        // note that each point is duplicated, hence we need to skip over the first two
        offset: FLOAT_BYTES$1 * 2,
        stride: FLOAT_BYTES$1,
      },
      offsetScale: {
        buffer: () => widthBuffer,
        // note that each point is duplicated, hence we need to skip over the first two
        offset: FLOAT_BYTES$1 * 2,
        stride: FLOAT_BYTES$1,
      },
      colorIndex: {
        buffer: () => colorIndexBuffer,
        // note that each point is duplicated, hence we need to skip over the first two
        offset: FLOAT_BYTES$1 * 2,
        stride: FLOAT_BYTES$1,
      },
    };

    elements = regl.elements();

    drawLine = regl({
      attributes,
      depth: { enable: !is2d },
      blend: {
        enable: true,
        func: {
          srcRGB: 'src alpha',
          srcAlpha: 'one',
          dstRGB: 'one minus src alpha',
          dstAlpha: 'one minus src alpha',
        },
      },
      uniforms: {
        projectionViewModel: (context, props) => {
          const projection = context.projection || props.projection;
          const model = context.model || props.model;
          const view = context.view || props.view;
          return multiply(
            pvm,
            projection,
            multiply(pvm, view, model)
          );
        },
        aspectRatio: ({ viewportWidth, viewportHeight }) =>
          viewportWidth / viewportHeight,
        colorTex: () => colorTex,
        colorTexRes: () => colorTexRes,
        colorTexEps: () => 0.5 / colorTexRes,
        pixelRatio: ({ pixelRatio }) => pixelRatio,
        width: ({ pixelRatio, viewportHeight }) =>
          (width / viewportHeight) * pixelRatio,
        useOpacity,
        useColorOpacity: () => +!useOpacity(),
        miter,
      },
      elements: () => elements,
      vert: VERTEX_SHADER$2,
      frag: FRAGMENT_SHADER$3,
    });
  };

  const prepare = () => {
    if (numLines === 1 && points.length % dim > 0) {
      console.warn(
        `The length of points (${numPoints}) does not match the dimensions (${dim}). Incomplete points are ignored.`
      );
    }

    // Copy all points belonging to complete points
    pointsPadded = points.flat().slice(0, numPoints * dim);

    // Add the missing z point
    if (is2d) {
      pointsPadded = Buffer.increaseStride(pointsPadded, 2, 3, zPos2d);
    }

    if (colorIndices.length !== numPoints)
      colorIndices = new Array(numPoints).fill(0);

    if (widths.length !== numPoints) widths = new Array(numPoints).fill(1);

    let finalColorIndices = colorIndices.slice();
    let finalOpacities =
      opacities.length === numPoints
        ? opacities.slice()
        : new Array(numPoints).fill(+opacity);
    let finalWidths = widths.slice();

    let k = 0;
    numPointsPerLine.forEach((n) => {
      const lastPointIdx = k + n - 1;
      // For each line, duplicate the first and last point.
      // E.g., [1,2,3] -> [1,1,2,3,3]
      // First, copy the last point to the end
      Buffer.copyElement(pointsPadded, lastPointIdx, lastPointIdx, 3);
      // Second, copy the first point to the beginning
      Buffer.copyElement(pointsPadded, k, k, 3);

      Buffer.copyElement(finalColorIndices, lastPointIdx, lastPointIdx, 1);
      Buffer.copyElement(finalColorIndices, k, k, 1);
      Buffer.copyElement(finalOpacities, lastPointIdx, lastPointIdx, 1);
      Buffer.copyElement(finalOpacities, k, k, 1);
      Buffer.copyElement(finalWidths, lastPointIdx, lastPointIdx, 1);
      Buffer.copyElement(finalWidths, k, k, 1);

      k += n + 2;
    });

    // duplicate each point for the positive and negative width (see below)
    pointsDup = new Float32Array(Buffer.duplicate(pointsPadded, 3));
    // duplicate each color, opacity, and width such that we have a positive
    // and negative width
    colorIndicesDup = Buffer.duplicate(finalColorIndices);
    opacitiesDup = Buffer.duplicate(finalOpacities);
    widthsDup = Buffer.duplicate(finalWidths, 1, -1);
    // create the line mesh, i.e., the vertex indices
    indices = createMesh(numPointsPerLine);

    pointBuffer({
      usage: 'dynamic',
      type: 'float',
      length: pointsDup.length * FLOAT_BYTES$1,
      data: pointsDup,
    });

    opacityBuffer({
      usage: 'dynamic',
      type: 'float',
      length: opacitiesDup.length * FLOAT_BYTES$1,
      data: opacitiesDup,
    });

    widthBuffer({
      usage: 'dynamic',
      type: 'float',
      length: widthsDup.length * FLOAT_BYTES$1,
      data: widthsDup,
    });

    colorIndexBuffer({
      usage: 'dynamic',
      type: 'float',
      length: colorIndicesDup.length * FLOAT_BYTES$1,
      data: colorIndicesDup,
    });

    elements({
      primitive: 'triangles',
      usage: 'dynamic',
      type: indices.length > 2 ** 16 ? 'uint32' : 'uint16',
      data: indices,
    });
  };

  const clear = () => {
    destroy();
    init();
  };

  const destroy = () => {
    points = null;
    pointsPadded = null;
    pointsDup = null;
    widthsDup = null;
    indices = null;
    pointBuffer.destroy();
    widthBuffer.destroy();
    elements.destroy();
  };

  const draw = ({
    projection: newProjection,
    model: newModel,
    view: newView,
  } = {}) => {
    // cache the view-defining matrices
    if (newProjection) {
      projection = newProjection;
    }
    if (newModel) {
      model = newModel;
    }
    if (newView) {
      view = newView;
    }
    // only draw when some points have been specified
    if (points && points.length > 1) {
      drawLine({ projection, model, view });
    }
  };

  const getPerPointProperty = (property, newValues) => {
    const flatNewValues = newValues.flat(2);

    if (flatNewValues.length === numPoints) {
      return flatNewValues;
    } else if (flatNewValues.length === numLines) {
      return numPointsPerLine
        .map((n, i) => Array(n).fill(flatNewValues[i]))
        .flat();
    }

    return property;
  };

  const getPoints = () => points;

  const setPoints = (
    newPoints = [],
    {
      colorIndices: newColorIndices = colorIndices,
      opacities: newOpacities = opacities,
      widths: newWidths = widths,
      is2d: newIs2d = is2d,
    } = {}
  ) => {
    points = newPoints;
    is2d = newIs2d;
    dim = is2d ? 2 : 3;

    numLines = Array.isArray(points[0]) ? points.length : 1;
    numPointsPerLine =
      numLines > 1
        ? points.map((pts) => Math.floor(pts.length / dim))
        : [Math.floor(points.length / dim)];
    numPoints = numPointsPerLine.reduce((n, nPts) => n + nPts, 0);

    colorIndices = getPerPointProperty(colorIndices, newColorIndices);
    opacities = getPerPointProperty(opacities, newOpacities);
    widths = getPerPointProperty(widths, newWidths);

    if (points && numPoints > 1) {
      prepare();
    } else {
      clear();
    }
  };

  const getNestedness = (arr, level = -1) => {
    if (!Array.isArray(arr)) return level;
    if (arr.length && !Array.isArray(arr[0])) return level + 1;
    return getNestedness(arr[0], ++level);
  };

  const createColorTexture = () => {
    const colors = getNestedness(color) === 0 ? [color] : color;

    colorTexRes = Math.max(2, Math.ceil(Math.sqrt(colors.length)));
    const rgba = new Uint8Array(colorTexRes ** 2 * 4);

    colors.forEach((color, i) => {
      rgba[i * 4] = Math.min(255, Math.max(0, Math.round(color[0] * 255))); // r
      rgba[i * 4 + 1] = Math.min(255, Math.max(0, Math.round(color[1] * 255))); // g
      rgba[i * 4 + 2] = Math.min(255, Math.max(0, Math.round(color[2] * 255))); // b
      rgba[i * 4 + 3] = Number.isNaN(+color[3])
        ? 255
        : Math.min(255, Math.max(0, Math.round(color[3] * 255))); // a
    });

    colorTex = regl.texture({
      data: rgba,
      shape: [colorTexRes, colorTexRes, 4],
    });
  };

  const setColor = (newColor, newOpacity = opacity) => {
    color = newColor;
    opacity = newOpacity;
    if (colorTex) colorTex.destroy();
    createColorTexture();
  };

  const getStyle = () => ({ color, miter, width });

  const setStyle = ({
    color: newColor,
    opacity: newOpacity,
    miter: newMiter,
    width: newWidth,
  } = {}) => {
    if (newColor) setColor(newColor, newOpacity);
    if (newMiter) miter = newMiter;
    if (+newWidth > 0) width = newWidth;
  };

  const getBuffer = () => ({
    points: pointBuffer,
    widths: widthBuffer,
    opacities: opacityBuffer,
    colorIndices: colorIndexBuffer,
  });

  const getData = () => ({
    points: pointsDup,
    widths: widthsDup,
    opacities: opacitiesDup,
    colorIndices: colorIndicesDup,
  });

  // initialize parameters
  init();
  createColorTexture();

  // prepare data if points are already specified
  if (points && points.length > 1) {
    setPoints(points);
  }

  return {
    clear,
    destroy,
    draw,
    getPoints,
    setPoints,
    getData,
    getBuffer,
    getStyle,
    setStyle,
  };
};

// @flekschas/utils v0.28.0 Copyright 2021 Fritz Lekschas
/* eslint no-param-reassign:0 */

/**
 * Cubic in easing function
 * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
 *   refers to the start and `1` to the end
 * @return {number} The eased time
 */
const cubicIn = (t) => t * t * t;

/**
 * Cubic in and out easing function
 * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
 *   refers to the start and `1` to the end
 * @return {number} The eased time
 */
const cubicInOut = (t) =>
  t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;

/**
 * Cubic out easing function
 * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
 *   refers to the start and `1` to the end
 * @return {number} The eased time
 */
const cubicOut = (t) => --t * t * t + 1;

/**
 * Linear easing function
 * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
 *   refers to the start and `1` to the end
 * @return {number} Same as the input
 */
const linear = (t) => t;

/**
 * Quadratic in easing function
 * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
 *   refers to the start and `1` to the end
 * @return {number} The eased time
 */
const quadIn = (t) => t * t;

/**
 * Quadratic in and out easing function
 * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
 *   refers to the start and `1` to the end
 * @return {number} The eased time
 */
const quadInOut = (t) => (t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t);

/**
 * Quadratic out easing function
 * @param {number} t - The input time to be eased. Must be in [0, 1] where `0`
 *   refers to the start and `1` to the end
 * @return {number} The eased time
 */
const quadOut = (t) => t * (2 - t);

/**
 * Identity function
 * @param   {*}  x  Any kind of value
 * @return  {*}  `x`
 */
const identity = (x) => x;

/**
 * Initialize an array of a certain length using a mapping function
 *
 * @description
 * This is equivalent to `Array(length).fill().map(mapFn)` but about 60% faster
 *
 * @param {number} length - Size of the array
 * @param {function} mapFn - Mapping function
 * @return {array} Initialized array
 */
const rangeMap = (length, mapFn = (x) => x) => {
  const out = [];
  for (let i = 0; i < length; i++) {
    out.push(mapFn(i, length));
  }
  return out;
};

/**
 * Get the unique union of two vectors of integers
 * @param {array} v - First vector of integers
 * @param {array} w - Second vector of integers
 * @return {array} Unique union of `v` and `w`
 */
const unionIntegers = (v, w) => {
  const a = [];
  v.forEach((x) => {
    a[x] = true;
  });
  w.forEach((x) => {
    a[x] = true;
  });
  return a.reduce((union, value, i) => {
    if (value) union.push(i);
    return union;
  }, []);
};

const assign = (target, ...sources) => {
  sources.forEach((source) => {
    // eslint-disable-next-line no-shadow
    const descriptors = Object.keys(source).reduce((descriptors, key) => {
      descriptors[key] = Object.getOwnPropertyDescriptor(source, key);
      return descriptors;
    }, {});

    // By default, Object.assign copies enumerable Symbols, too
    Object.getOwnPropertySymbols(source).forEach((symbol) => {
      const descriptor = Object.getOwnPropertyDescriptor(source, symbol);
      if (descriptor.enumerable) {
        descriptors[symbol] = descriptor;
      }
    });
    Object.defineProperties(target, descriptors);
  });
  return target;
};

/**
 * Convenience function to compose functions
 * @param {...[function]} fns - Array of functions
 * @return {function} The composed function
 */
const pipe = (...fns) =>
  /**
   * @param {*} x - Some value
   * @return {*} Output of the composed function
   */
  (x) => fns.reduce((y, f) => f(y), x);

/**
 * Assign a constructor to the object
 * @param {function} constructor - Constructor functions
 */
const withConstructor = (constructor) => (self) =>
  assign(
    {
      __proto__: {
        constructor,
      },
    },
    self
  );

/**
 * Assign a static property to an object
 * @param {string} name - Name of the property
 * @param {*} value - Static value
 */
const withStaticProperty = (name, value) => (self) =>
  assign(self, {
    get [name]() {
      return value;
    },
  });

/**
 * L2 distance between a pair of points
 *
 * @description
 * Identical but much faster than `l2Dist([fromX, fromY], [toX, toY])`
 *
 * @param {number} fromX - X coordinate of the first point
 * @param {number} fromY - Y coordinate of the first point
 * @param {number} toX - X coordinate of the second point
 * @param {number} toY - Y coordinate of the first point
 * @return {number} L2 distance
 */
const l2PointDist = (fromX, fromY, toX, toY) =>
  Math.sqrt((fromX - toX) ** 2 + (fromY - toY) ** 2);

/**
 * Create a worker from a function
 * @param {function} fn - Function to be turned into a worker
 * @return {Worker} Worker function
 */
const createWorker = (fn) =>
  new Worker(
    window.URL.createObjectURL(
      new Blob([`(${fn.toString()})()`], { type: 'text/javascript' })
    )
  );

/**
 * Get a promise that resolves after the next `n` animation frames
 * @param {number} n - Number of animation frames to wait
 * @return {Promise} A promise that resolves after the next `n` animation frames
 */
const nextAnimationFrame = (n = 1) =>
  new Promise((resolve) => {
    let i = 0;

    const raf = () =>
      requestAnimationFrame(() => {
        i++;
        if (i < n) raf();
        else resolve();
      });

    raf();
  });

/**
 * Throttle and debounce a function call
 *
 * Throttling a function call means that the function is called at most every
 * `interval` milliseconds no matter how frequently you trigger a call.
 * Debouncing a function call means that the function is called the earliest
 * after `finalWait` milliseconds wait time where the function was not called.
 * Combining the two ensures that the function is called at most every
 * `interval` milliseconds and is ensured to be called with the very latest
 * arguments after after `finalWait` milliseconds wait time at the end.
 *
 * The following imaginary scenario describes the behavior:
 *
 * MS | throttleTime=3 and debounceTime=3
 * 1. y(f, 3, 3)(args1) => f(args1) called
 * 2. y(f, 3, 3)(args2) => call ignored due to throttling
 * 3. y(f, 3, 3)(args3) => call ignored due to throttling
 * 4. y(f, 3, 3)(args4) => f(args4) called
 * 5. y(f, 3, 3)(args5) => all ignored due to throttling
 * 6. No call           => nothing
 * 7. No call           => f(args5) called due to debouncing
 *
 * @param {functon} func - Function to be throttled and debounced
 * @param {number} interval - Throttle intevals in milliseconds
 * @param {number} wait - Debounce wait time in milliseconds By default this is
 *   the same as `interval`.
 * @return {function} - Throttled and debounced function
 */
const throttleAndDebounce = (fn, throttleTime, debounceTime = null) => {
  let timeout;
  let blockedCalls = 0;

  // eslint-disable-next-line no-param-reassign
  debounceTime = debounceTime === null ? throttleTime : debounceTime;

  const debounced = (...args) => {
    const later = () => {
      // Since we throttle and debounce we should check whether there were
      // actually multiple attempts to call this function after the most recent
      // throttled call. If there were no more calls we don't have to call
      // the function again.
      if (blockedCalls > 0) {
        fn(...args);
        blockedCalls = 0;
      }
    };

    clearTimeout(timeout);
    timeout = setTimeout(later, debounceTime);
  };

  let isWaiting = false;
  const throttledAndDebounced = (...args) => {
    if (!isWaiting) {
      fn(...args);
      debounced(...args);

      isWaiting = true;
      blockedCalls = 0;

      setTimeout(() => {
        isWaiting = false;
      }, throttleTime);
    } else {
      blockedCalls++;
      debounced(...args);
    }
  };

  throttledAndDebounced.reset = () => {
    isWaiting = false;
  };

  throttledAndDebounced.cancel = () => {
    clearTimeout(timeout);
  };

  throttledAndDebounced.now = (...args) => fn(...args);

  return throttledAndDebounced;
};

/**
 * Promise that resolves after some time
 * @param {number} msec - Time in milliseconds until the promise is resolved
 * @return {Promise} Promise resolving after `msec` milliseconds
 */
const wait = (msec) =>
  new Promise((resolve) => setTimeout(resolve, msec));

const DEFAULT_LASSO_START_INITIATOR_SHOW = true;
const DEFAULT_LASSO_MIN_DELAY$1 = 8;
const DEFAULT_LASSO_MIN_DIST$1 = 2;
const LASSO_SHOW_START_INITIATOR_TIME = 2500;
const LASSO_HIDE_START_INITIATOR_TIME = 250;

const ifNotNull = (v, alternative = null) => (v === null ? alternative : v);

const lassoStyleEl = document.createElement('style');
document.head.appendChild(lassoStyleEl);

const lassoStylesheets = lassoStyleEl.sheet;

const addRule = (rule) => {
  const currentNumRules = lassoStylesheets.rules.length;
  lassoStylesheets.insertRule(rule, currentNumRules);
  return currentNumRules;
};

const removeRule = (index) => {
  lassoStylesheets.deleteRule(index);
};

const inAnimation = `${LASSO_SHOW_START_INITIATOR_TIME}ms ease scaleInFadeOut 0s 1 normal backwards`;

const createInAnimationRule = (opacity, scale, rotate) => `
@keyframes scaleInFadeOut {
  0% {
    opacity: ${opacity};
    transform: translate(-50%,-50%) scale(${scale}) rotate(${rotate}deg);
  }
  10% {
    opacity: 1;
    transform: translate(-50%,-50%) scale(1) rotate(${rotate + 20}deg);
  }
  100% {
    opacity: 0;
    transform: translate(-50%,-50%) scale(0.9) rotate(${rotate + 60}deg);
  }
}
`;
let inAnimationRuleIndex = null;

const outAnimation = `${LASSO_HIDE_START_INITIATOR_TIME}ms ease fadeScaleOut 0s 1 normal backwards`;

const createOutAnimationRule = (opacity, scale, rotate) => `
@keyframes fadeScaleOut {
  0% {
    opacity: ${opacity};
    transform: translate(-50%,-50%) scale(${scale}) rotate(${rotate}deg);
  }
  100% {
    opacity: 0;
    transform: translate(-50%,-50%) scale(0) rotate(${rotate}deg);
  }
}
`;
let outAnimationRuleIndex = null;

const createLasso = (
  element,
  {
    onDraw: initialOnDraw = identity,
    onStart: initialOnStart = identity,
    onEnd: initialOnEnd = identity,
    enableInitiator: initialenableInitiator = DEFAULT_LASSO_START_INITIATOR_SHOW,
    initiatorParentElement: initialinitiatorParentElement = document.body,
    minDelay: initialMinDelay = DEFAULT_LASSO_MIN_DELAY$1,
    minDist: initialMinDist = DEFAULT_LASSO_MIN_DIST$1,
    pointNorm: initialPointNorm = identity,
  } = {}
) => {
  let enableInitiator = initialenableInitiator;
  let initiatorParentElement = initialinitiatorParentElement;

  let onDraw = initialOnDraw;
  let onStart = initialOnStart;
  let onEnd = initialOnEnd;

  let pointNorm = initialPointNorm;

  const initiator = document.createElement('div');
  const id =
    Math.random().toString(36).substring(2, 5) +
    Math.random().toString(36).substring(2, 5);
  initiator.id = `lasso-initiator-${id}`;
  initiator.style.position = 'fixed';
  initiator.style.display = 'flex';
  initiator.style.justifyContent = 'center';
  initiator.style.alignItems = 'center';
  initiator.style.zIndex = 99;
  initiator.style.width = '4rem';
  initiator.style.height = '4rem';
  initiator.style.borderRadius = '4rem';
  initiator.style.opacity = 0.5;
  initiator.style.transform = 'translate(-50%,-50%) scale(0) rotate(0deg)';

  let isMouseDown = false;
  let isLasso = false;
  let lassoPos = [];
  let lassoPosFlat = [];
  let lassoPrevMousePos;

  const mouseUpHandler = () => {
    isMouseDown = false;
  };

  const getMousePosition = (event) => {
    const { left, top } = element.getBoundingClientRect();

    return [event.clientX - left, event.clientY - top];
  };

  window.addEventListener('mouseup', mouseUpHandler);

  const resetinitiatorStyle = () => {
    initiator.style.opacity = 0.5;
    initiator.style.transform = 'translate(-50%,-50%) scale(0) rotate(0deg)';
  };

  const getCurrentinitiatorAnimationStyle = () => {
    const computedStyle = getComputedStyle(initiator);
    const opacity = +computedStyle.opacity;
    // The css rule `transform: translate(-1, -1) scale(0.5);` is represented as
    // `matrix(0.5, 0, 0, 0.5, -1, -1)`
    const m = computedStyle.transform.match(/([0-9.-]+)+/g);

    const a = +m[0];
    const b = +m[1];

    const scale = Math.sqrt(a * a + b * b);
    const rotate = Math.atan2(b, a) * (180 / Math.PI);

    return { opacity, scale, rotate };
  };

  const showInitiator = (event) => {
    if (!enableInitiator) return;

    wait(0).then(() => {
      const x = event.clientX;
      const y = event.clientY;

      if (isMouseDown) return;

      let opacity = 0.5;
      let scale = 0;
      let rotate = 0;

      const style = getCurrentinitiatorAnimationStyle();
      opacity = style.opacity;
      scale = style.scale;
      rotate = style.rotate;
      initiator.style.opacity = opacity;
      initiator.style.transform = `translate(-50%,-50%) scale(${scale}) rotate(${rotate}deg)`;

      initiator.style.animation = 'none';

      // See https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Animations/Tips
      // why we need to wait for two animation frames
      nextAnimationFrame(2).then(() => {
        initiator.style.top = `${y}px`;
        initiator.style.left = `${x}px`;

        if (inAnimationRuleIndex !== null) removeRule(inAnimationRuleIndex);

        inAnimationRuleIndex = addRule(
          createInAnimationRule(opacity, scale, rotate)
        );

        initiator.style.animation = inAnimation;

        nextAnimationFrame().then(() => {
          resetinitiatorStyle();
        });
      });
    });
  };

  const hideInitiator = () => {
    const { opacity, scale, rotate } = getCurrentinitiatorAnimationStyle();
    initiator.style.opacity = opacity;
    initiator.style.transform = `translate(-50%,-50%) scale(${scale}) rotate(${rotate}deg)`;

    initiator.style.animation = 'none';

    nextAnimationFrame(2).then(() => {
      if (outAnimationRuleIndex !== null) removeRule(outAnimationRuleIndex);

      outAnimationRuleIndex = addRule(
        createOutAnimationRule(opacity, scale, rotate)
      );

      initiator.style.animation = outAnimation;

      nextAnimationFrame().then(() => {
        resetinitiatorStyle();
      });
    });
  };

  const draw = () => {
    onDraw(lassoPos, lassoPosFlat);
  };

  const extend = (currMousePos) => {
    if (!lassoPrevMousePos) {
      if (!isLasso) {
        isLasso = true;
        onStart();
      }
      lassoPrevMousePos = currMousePos;
      const point = pointNorm(currMousePos);
      lassoPos = [point];
      lassoPosFlat = [point[0], point[1]];
    } else {
      const d = l2PointDist(
        currMousePos[0],
        currMousePos[1],
        lassoPrevMousePos[0],
        lassoPrevMousePos[1]
      );

      if (d > DEFAULT_LASSO_MIN_DIST$1) {
        lassoPrevMousePos = currMousePos;
        const point = pointNorm(currMousePos);
        lassoPos.push(point);
        lassoPosFlat.push(point[0], point[1]);
        if (lassoPos.length > 1) {
          draw();
        }
      }
    }
  };

  const extendDb = throttleAndDebounce(
    extend,
    DEFAULT_LASSO_MIN_DELAY$1,
    DEFAULT_LASSO_MIN_DELAY$1
  );

  const extendPublic = (event, debounced) => {
    const mousePosition = getMousePosition(event);
    if (debounced) return extendDb(mousePosition);
    return extend(mousePosition);
  };

  const clear = () => {
    lassoPos = [];
    lassoPosFlat = [];
    lassoPrevMousePos = undefined;
    draw();
  };

  const initiatorClickHandler = (event) => {
    showInitiator(event);
  };

  const initiatorMouseDownHandler = () => {
    isMouseDown = true;
    isLasso = true;
    clear();
    onStart();
  };

  const initiatorMouseLeaveHandler = () => {
    hideInitiator();
  };

  const end = ({ merge = false } = {}) => {
    isLasso = false;

    const currLassoPos = [...lassoPos];
    const currLassoPosFlat = [...lassoPosFlat];

    extendDb.cancel();

    clear();

    // When `currLassoPos` is empty the user didn't actually lasso
    if (currLassoPos.length) onEnd(currLassoPos, currLassoPosFlat, { merge });

    return currLassoPos;
  };

  const set = ({
    onDraw: newOnDraw = null,
    onStart: newOnStart = null,
    onEnd: newOnEnd = null,
    enableInitiator: newEnableInitiator = null,
    initiatorParentElement: newInitiatorParentElement = null,
    minDelay: newMinDelay = null,
    minDist: newMinDist = null,
    pointNorm: newPointNorm = null,
  } = {}) => {
    onDraw = ifNotNull(newOnDraw, onDraw);
    onStart = ifNotNull(newOnStart, onStart);
    onEnd = ifNotNull(newOnEnd, onEnd);
    enableInitiator = ifNotNull(newEnableInitiator, enableInitiator);
    pointNorm = ifNotNull(newPointNorm, pointNorm);

    if (
      newInitiatorParentElement !== null &&
      newInitiatorParentElement !== initiatorParentElement
    ) {
      initiatorParentElement.removeChild(initiator);
      newInitiatorParentElement.appendChild(initiator);
      initiatorParentElement = newInitiatorParentElement;
    }

    if (enableInitiator) {
      initiator.addEventListener('click', initiatorClickHandler);
      initiator.addEventListener('mousedown', initiatorMouseDownHandler);
      initiator.addEventListener('mouseleave', initiatorMouseLeaveHandler);
    } else {
      initiator.removeEventListener('mousedown', initiatorMouseDownHandler);
      initiator.removeEventListener('mouseleave', initiatorMouseLeaveHandler);
    }
  };

  const destroy = () => {
    initiatorParentElement.removeChild(initiator);
    window.removeEventListener('mouseup', mouseUpHandler);
    initiator.removeEventListener('click', initiatorClickHandler);
    initiator.removeEventListener('mousedown', initiatorMouseDownHandler);
    initiator.removeEventListener('mouseleave', initiatorMouseLeaveHandler);
  };

  const withPublicMethods = () => (self) =>
    assign(self, {
      clear,
      destroy,
      end,
      extend: extendPublic,
      set,
      showInitiator,
      hideInitiator,
    });

  initiatorParentElement.appendChild(initiator);

  set({
    onDraw,
    onStart,
    onEnd,
    enableInitiator,
    initiatorParentElement,
  });

  return pipe(
    withStaticProperty('initiator', initiator),
    withPublicMethods(),
    withConstructor(createLasso)
  )({});
};

const FRAGMENT_SHADER$2 = `
precision mediump float;

uniform sampler2D texture;

varying vec2 uv;

void main () {
  gl_FragColor = texture2D(texture, uv);
}
`;

const VERTEX_SHADER$1 = `
precision mediump float;

uniform mat4 projectionViewModel;

attribute vec2 position;

varying vec2 uv;

void main () {
  uv = position;
  gl_Position = projectionViewModel * vec4(-1.0 + 2.0 * uv.x, 1.0 - 2.0 * uv.y, 0, 1);
}
`;

const FRAGMENT_SHADER$1 = `
precision highp float;

varying vec4 color;
varying float finalPointSize;

float linearstep(float edge0, float edge1, float x) {
  return clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
}

void main() {
  vec2 c = gl_PointCoord * 2.0 - 1.0;
  float sdf = length(c) * finalPointSize;
  float alpha = linearstep(finalPointSize + 0.5, finalPointSize - 0.5, sdf);

  gl_FragColor = vec4(color.rgb, alpha * color.a);
}
`;

const FRAGMENT_SHADER = `precision highp float;

varying vec4 color;

void main() {
  gl_FragColor = color;
}
`;

const VERTEX_SHADER = `
precision highp float;

uniform sampler2D colorTex;
uniform float colorTexRes;
uniform float colorTexEps;
uniform sampler2D stateTex;
uniform float stateTexRes;
uniform float stateTexEps;
uniform float devicePixelRatio;
uniform sampler2D encodingTex;
uniform float encodingTexRes;
uniform float encodingTexEps;
uniform float pointSizeExtra;
uniform float numPoints;
uniform float globalState;
uniform float isColoredByZ;
uniform float isColoredByW;
uniform float isOpacityByZ;
uniform float isOpacityByW;
uniform float isOpacityByDensity;
uniform float isSizedByZ;
uniform float isSizedByW;
uniform float colorMultiplicator;
uniform float opacityMultiplicator;
uniform float opacityDensity;
uniform float sizeMultiplicator;
uniform float numColorStates;
uniform float pointScale;
uniform mat4 projectionViewModel;

attribute vec2 stateIndex;

// variables to send to the fragment shader
varying vec4 color;
varying float finalPointSize;

void main() {
  vec4 state = texture2D(stateTex, stateIndex);

  gl_Position = projectionViewModel * vec4(state.x, state.y, 0.0, 1.0);

  // Determine color index
  float colorIndexZ =  isColoredByZ * floor(state.z * colorMultiplicator);
  float colorIndexW =  isColoredByW * floor(state.w * colorMultiplicator);

  // Multiply by the number of color states per color
  // I.e., normal, active, hover, background, etc.
  float colorIndex = (colorIndexZ + colorIndexW) * numColorStates;

  // Half a "pixel" or "texel" in texture coordinates
  float colorLinearIndex = colorIndex + globalState;

  // Need to add cEps here to avoid floating point issue that can lead to
  // dramatic changes in which color is loaded as floor(3/2.9999) = 1 but
  // floor(3/3.0001) = 0!
  float colorRowIndex = floor((colorLinearIndex + colorTexEps) / colorTexRes);

  vec2 colorTexIndex = vec2(
    (colorLinearIndex / colorTexRes) - colorRowIndex + colorTexEps,
    colorRowIndex / colorTexRes + colorTexEps
  );

  color = texture2D(colorTex, colorTexIndex);

  // Retrieve point size
  float pointSizeIndexZ = isSizedByZ * floor(state.z * sizeMultiplicator);
  float pointSizeIndexW = isSizedByW * floor(state.w * sizeMultiplicator);
  float pointSizeIndex = pointSizeIndexZ + pointSizeIndexW;

  float pointSizeRowIndex = floor((pointSizeIndex + encodingTexEps) / encodingTexRes);
  vec2 pointSizeTexIndex = vec2(
    (pointSizeIndex / encodingTexRes) - pointSizeRowIndex + encodingTexEps,
    pointSizeRowIndex / encodingTexRes + encodingTexEps
  );
  float pointSize = texture2D(encodingTex, pointSizeTexIndex).x;

  // Retrieve opacity
  if (isOpacityByDensity < 0.5) {
    float opacityIndexZ = isOpacityByZ * floor(state.z * opacityMultiplicator);
    float opacityIndexW = isOpacityByW * floor(state.w * opacityMultiplicator);
    float opacityIndex = opacityIndexZ + opacityIndexW;

    float opacityRowIndex = floor((opacityIndex + encodingTexEps) / encodingTexRes);
    vec2 opacityTexIndex = vec2(
      (opacityIndex / encodingTexRes) - opacityRowIndex + encodingTexEps,
      opacityRowIndex / encodingTexRes + encodingTexEps
    );
    color.a = min(1.0, texture2D(encodingTex, opacityTexIndex).y + globalState);
  } else {
    color.a = min(1.0, opacityDensity + globalState);
  }

  finalPointSize = (pointSize * pointScale) + pointSizeExtra;
  gl_PointSize = finalPointSize;
}
`;

const SHADER$1 = `precision highp float;

uniform sampler2D startStateTex;
uniform sampler2D endStateTex;
uniform float t;

varying vec2 particleTextureIndex;

void main() {
  // Interpolate x, y, and value
  vec3 start = texture2D(startStateTex, particleTextureIndex).xyw;
  vec3 end = texture2D(endStateTex, particleTextureIndex).xyw;
  vec3 curr = start * (1.0 - t) + end * t;

  // The category cannot be interpolated
  float endCategory = texture2D(endStateTex, particleTextureIndex).z;

  gl_FragColor = vec4(curr.xy, endCategory, curr.z);
}`;

const SHADER = `precision highp float;

attribute vec2 position;
varying vec2 particleTextureIndex;

void main() {
  // map normalized device coords to texture coords
  particleTextureIndex = 0.5 * (1.0 + position);

  gl_Position = vec4(position, 0, 1);
}`;

/* eslint-env worker */
/* eslint no-restricted-globals: 1 */

const worker = function worker() {

  /**
   * Catmull-Rom interpolation
   * @param {number} t - Progress value
   * @param {array} p0 - First point
   * @param {array} p1 - Second point
   * @param {array} p2 - Third point
   * @param {array} p3 - Forth point
   * @return {number} Interpolated value
   */
  const catmullRom = (t, p0, p1, p2, p3) => {
    const v0 = (p2 - p0) * 0.5;
    const v1 = (p3 - p1) * 0.5;
    return (
      (2 * p1 - 2 * p2 + v0 + v1) * t * t * t +
      (-3 * p1 + 3 * p2 - 2 * v0 - v1) * t * t +
      v0 * t +
      p1
    );
  };

  /**
   * Interpolate a point with Catmull-Rom
   * @param {number} t - Progress value
   * @param {array} points - Key points
   * @param {number}  maxPointIdx - Highest point index. Same as array.length - 1
   * @return {array} Interpolated point
   */
  const interpolatePoint = (t, points, maxPointIdx) => {
    const p = maxPointIdx * t;

    const intPoint = Math.floor(p);
    const weight = p - intPoint;

    const p0 = points[Math.max(0, intPoint - 1)];
    const p1 = points[intPoint];
    const p2 = points[Math.min(maxPointIdx, intPoint + 1)];
    const p3 = points[Math.min(maxPointIdx, intPoint + 2)];

    return [
      catmullRom(weight, p0[0], p1[0], p2[0], p3[0]),
      catmullRom(weight, p0[1], p1[1], p2[1], p3[1]),
    ];
  };

  /**
   * Square distance
   * @param {number} x1 - First x coordinate
   * @param {number} y1 - First y coordinate
   * @param {number} x2 - Second x coordinate
   * @param {number} y2 - Second y coordinate
   * @return {number} Distance
   */
  const sqDist = (x1, y1, x2, y2) => (x1 - x2) ** 2 + (y1 - y2) ** 2;

  /**
   * Douglas Peucker square segment distance
   * Implementation from https://github.com/mourner/simplify-js
   * @author Vladimir Agafonkin
   * @copyright Vladimir Agafonkin 2013
   * @license BSD
   * @param {array} p - Point
   * @param {array} p1 - First boundary point
   * @param {array} p2 - Second boundary point
   * @return {number} Distance
   */
  const sqSegDist = (p, p1, p2) => {
    let x = p1[0];
    let y = p1[1];
    let dx = p2[0] - x;
    let dy = p2[1] - y;

    if (dx !== 0 || dy !== 0) {
      const t = ((p[0] - x) * dx + (p[1] - y) * dy) / (dx * dx + dy * dy);

      if (t > 1) {
        x = p2[0];
        y = p2[1];
      } else if (t > 0) {
        x += dx * t;
        y += dy * t;
      }
    }

    dx = p[0] - x;
    dy = p[1] - y;

    return dx * dx + dy * dy;
  };

  /**
   * Douglas Peucker step function
   * Implementation from https://github.com/mourner/simplify-js
   * @author Vladimir Agafonkin
   * @copyright Vladimir Agafonkin 2013
   * @license BSD
   * @param   {[type]}  points  [description]
   * @param   {[type]}  first  [description]
   * @param   {[type]}  last  [description]
   * @param   {[type]}  tolerance  [description]
   * @param   {[type]}  simplified  [description]
   * @return  {[type]}  [description]
   */
  const simplifyDPStep = (points, first, last, tolerance, simplified) => {
    let maxDist = tolerance;
    let index;

    for (let i = first + 1; i < last; i++) {
      const dist = sqSegDist(points[i], points[first], points[last]);

      if (dist > maxDist) {
        index = i;
        maxDist = dist;
      }
    }

    if (maxDist > tolerance) {
      if (index - first > 1)
        simplifyDPStep(points, first, index, tolerance, simplified);
      simplified.push(points[index]);
      if (last - index > 1)
        simplifyDPStep(points, index, last, tolerance, simplified);
    }
  };

  /**
   * Douglas Peucker. Implementation from https://github.com/mourner/simplify-js
   * @author Vladimir Agafonkin
   * @copyright Vladimir Agafonkin 2013
   * @license BSD
   * @param {array} points - List of points to be simplified
   * @param {number} tolerance - Tolerance level. Points below this distance level will be ignored
   * @return {array} Simplified point list
   */
  const simplifyDouglasPeucker = (points, tolerance) => {
    const last = points.length - 1;
    const simplified = [points[0]];

    simplifyDPStep(points, 0, last, tolerance, simplified);
    simplified.push(points[last]);

    return simplified;
  };

  /**
   * Interpolate intermediate points between key points
   * @param {array} points - Fixed key points
   * @param {number} options.maxIntPointsPerSegment - Maximum number of points between two key points
   * @param {number} options.tolerance - Simplification tolerance
   * @return {array} Interpolated points including key points
   */
  const interpolatePoints = (
    points,
    { maxIntPointsPerSegment = 100, tolerance = 0.002 } = {}
  ) => {
    const numPoints = points.length;
    const maxPointIdx = numPoints - 1;

    const maxOutPoints = maxPointIdx * maxIntPointsPerSegment + 1;
    const sqTolerance = tolerance ** 2;

    let outPoints = [];
    let prevPoint;

    // Generate interpolated points where the squared-distance between points
    // is larger than sqTolerance
    for (let i = 0; i < numPoints - 1; i++) {
      let segmentPoints = [points[i].slice(0, 2)];
      prevPoint = points[i];

      for (let j = 1; j < maxIntPointsPerSegment; j++) {
        const t = (i * maxIntPointsPerSegment + j) / maxOutPoints;
        const intPoint = interpolatePoint(t, points, maxPointIdx);

        // Check squared distance simplification
        if (
          sqDist(prevPoint[0], prevPoint[1], intPoint[0], intPoint[1]) >
          sqTolerance
        ) {
          segmentPoints.push(intPoint);
          prevPoint = intPoint;
        }
      }

      // Add next key point. Needed for the simplification algorithm
      segmentPoints.push(points[i + 1]);
      // Simplify interpolated points using the douglas-peuckner algorithm
      segmentPoints = simplifyDouglasPeucker(segmentPoints, sqTolerance);
      // Add simplified points without the last key point, which is added
      // anyway in the next segment
      outPoints = outPoints.concat(
        segmentPoints.slice(0, segmentPoints.length - 1)
      );
    }
    outPoints.push(points[points.length - 1].slice(0, 2));

    return outPoints.flat();
  };

  /**
   * Group points by line assignment (the fifth component of a point)
   * @param {array} points - Flat list of points
   * @return {array} List of lists of ordered points by line
   */
  const groupPoints = (points) => {
    const groupedPoints = {};

    const isOrdered = !Number.isNaN(+points[0][5]);
    points.forEach((point) => {
      const segId = point[4];

      if (!groupedPoints[segId]) groupedPoints[segId] = [];

      if (isOrdered) groupedPoints[segId][point[5]] = point;
      else groupedPoints[segId].push(point);
    });

    // The filtering ensures that non-existing array entries are removed
    Object.entries(groupedPoints).forEach((idPoints) => {
      groupedPoints[idPoints[0]] = idPoints[1].filter((v) => v);
      // Store the first point as the reference
      groupedPoints[idPoints[0]].reference = idPoints[1][0];
    });

    return groupedPoints;
  };

  self.onmessage = function onmessage(event) {
    const numPoints = event.data.points ? +event.data.points.length : 0;

    if (!numPoints)
      self.postMessage({ error: new Error('No points provided') });

    event.data.points;

    const groupedPoints = groupPoints(event.data.points);

    self.postMessage({
      points: Object.entries(groupedPoints).reduce(
        (curvePoints, idAndPoints) => {
          curvePoints[idAndPoints[0]] = interpolatePoints(
            idAndPoints[1],
            event.data.options
          );
          // Make sure the reference is passed on
          curvePoints[idAndPoints[0]].reference = idAndPoints[1].reference;
          return curvePoints;
        },
        {}
      ),
    });
  };
};

const createSplineCurve = (
  points,
  options = { tolerance: 0.002, maxIntPointsPerSegment: 100 }
) =>
  new Promise((resolve, reject) => {
    const worker$1 = createWorker(worker);

    worker$1.onmessage = (e) => {
      if (e.data.error) reject(e.data.error);
      else resolve(e.data.points);
      worker$1.terminate();
    };

    worker$1.postMessage({ points, options });
  });

const COLOR_NORMAL_IDX = 0;
const COLOR_ACTIVE_IDX = 1;
const COLOR_HOVER_IDX = 2;
const COLOR_BG_IDX = 3;
const COLOR_NUM_STATES = 4;
const FLOAT_BYTES = Float32Array.BYTES_PER_ELEMENT;
const GL_EXTENSIONS = [
  'OES_texture_float',
  'OES_element_index_uint',
  'WEBGL_color_buffer_float',
  'EXT_float_blend',
];

const MOUSE_MODE_PANZOOM = 'panZoom';
const MOUSE_MODE_LASSO = 'lasso';
const MOUSE_MODE_ROTATE = 'rotate';
const MOUSE_MODES = [
  MOUSE_MODE_PANZOOM,
  MOUSE_MODE_LASSO,
  MOUSE_MODE_ROTATE,
];
const DEFAULT_MOUSE_MODE = MOUSE_MODE_PANZOOM;

// Easing
const EASING_FNS = {
  cubicIn,
  cubicInOut,
  cubicOut,
  linear,
  quadIn,
  quadInOut,
  quadOut,
};
const DEFAULT_EASING = cubicInOut;

// Default lasso
const LASSO_CLEAR_ON_DESELECT = 'deselect';
const LASSO_CLEAR_ON_END = 'lassoEnd';
const LASSO_CLEAR_EVENTS = [LASSO_CLEAR_ON_DESELECT, LASSO_CLEAR_ON_END];
const DEFAULT_LASSO_COLOR = [0, 0.666666667, 1, 1];
const DEFAULT_LASSO_LINE_WIDTH = 2;
const DEFAULT_LASSO_INITIATOR = false;
const DEFAULT_LASSO_MIN_DELAY = 10;
const DEFAULT_LASSO_MIN_DIST = 3;
const DEFAULT_LASSO_CLEAR_EVENT = LASSO_CLEAR_ON_END;

// Key mapping
const KEY_ACTION_LASSO = 'lasso';
const KEY_ACTION_ROTATE = 'rotate';
const KEY_ACTION_MERGE = 'merge';
const KEY_ACTIONS = [
  KEY_ACTION_LASSO,
  KEY_ACTION_ROTATE,
  KEY_ACTION_MERGE,
];
const KEY_ALT = 'alt';
const KEY_CMD = 'cmd';
const KEY_CTRL = 'ctrl';
const KEY_META = 'meta';
const KEY_SHIFT = 'shift';
const KEYS = [KEY_ALT, KEY_CMD, KEY_CTRL, KEY_META, KEY_SHIFT];
const DEFAULT_KEY_MAP = {
  [KEY_ALT]: KEY_ACTION_ROTATE,
  [KEY_SHIFT]: KEY_ACTION_LASSO,
  [KEY_CMD]: KEY_ACTION_MERGE,
};

// Default attribute
const DEFAULT_DATA_ASPECT_RATIO = 1;
const DEFAULT_WIDTH = 'auto';
const DEFAULT_HEIGHT = 'auto';
const DEFAULT_GAMMA = 1;

// Default styles
const MIN_POINT_SIZE = 1;
const DEFAULT_POINT_SIZE = 6;
const DEFAULT_POINT_SIZE_SELECTED = 2;
const DEFAULT_POINT_OUTLINE_WIDTH = 2;
const DEFAULT_SIZE_BY = null;
const DEFAULT_POINT_CONNECTION_SIZE = 2;
const DEFAULT_POINT_CONNECTION_SIZE_ACTIVE = 2;
const DEFAULT_POINT_CONNECTION_SIZE_BY = null;
const DEFAULT_POINT_CONNECTION_OPACITY = null;
const DEFAULT_POINT_CONNECTION_OPACITY_BY = null;
const DEFAULT_POINT_CONNECTION_OPACITY_ACTIVE = 0.66;
const DEFAULT_OPACITY = 1;
const DEFAULT_OPACITY_BY = null;
const DEFAULT_OPACITY_BY_DENSITY_FILL = 0.15;
const DEFAULT_OPACITY_BY_DENSITY_DEBOUNCE_TIME = 25;
const DEFAULT_COLOR_BY = null;
const DEFAULT_COLOR_NORMAL = [0.66, 0.66, 0.66, 1];
const DEFAULT_COLOR_ACTIVE = [0, 0.55, 1, 1];
const DEFAULT_COLOR_HOVER = [1, 1, 1, 1];
const DEFAULT_COLOR_BG = [0, 0, 0, 1];
const DEFAULT_POINT_CONNECTION_COLOR_BY = null;
const DEFAULT_POINT_CONNECTION_COLOR_NORMAL = [0.66, 0.66, 0.66, 0.2];
const DEFAULT_POINT_CONNECTION_COLOR_ACTIVE = [0, 0.55, 1, 1];
const DEFAULT_POINT_CONNECTION_COLOR_HOVER = [1, 1, 1, 1];

// Default view
const DEFAULT_TARGET = [0, 0];
const DEFAULT_DISTANCE = 1;
const DEFAULT_ROTATION = 0;
// prettier-ignore
const DEFAULT_VIEW = new Float32Array([
  1, 0, 0, 0,
  0, 1, 0, 0,
  0, 0, 1, 0,
  0, 0, 0, 1
]);

// Default misc
const DEFAULT_BACKGROUND_IMAGE = null;
const DEFAULT_SHOW_RETICLE = false;
const DEFAULT_RETICLE_COLOR = [1, 1, 1, 0.5];
const DEFAULT_DESELECT_ON_DBL_CLICK = true;
const DEFAULT_DESELECT_ON_ESCAPE = true;
const DEFAULT_SHOW_POINT_CONNECTIONS = false;
const DEFAULT_POINT_CONNECTION_MAX_INT_POINTS_PER_SEGMENT = 100;
const DEFAULT_POINT_CONNECTION_INT_POINTS_TOLERANCE = 1 / 500;
const DEFAULT_POINT_SIZE_MOUSE_DETECTION = 'auto';
const DEFAULT_PERFORMANCE_MODE = false;
const SINGLE_CLICK_DELAY = 200;
const LONG_CLICK_TIME = 500;
const Z_NAMES = new Set(['z', 'valueZ', 'valueA', 'value1', 'category']);
const W_NAMES = new Set(['w', 'valueW', 'valueB', 'value2', 'value']);

/**
 * Check if all GL extensions are enabled and warn otherwise
 * @param   {import('regl').Regl}  regl  Regl instance to be tested
 * @return  {function}  Returns the Regl instance itself
 */
const checkReglExtensions = (regl) => {
  if (!regl) return false;
  return GL_EXTENSIONS.reduce((every, EXTENSION) => {
    if (!regl.hasExtension(EXTENSION)) {
      console.warn(
        `WebGL: ${EXTENSION} extension not supported. Scatterplot might not render properly`
      );
      return false;
    }
    return every;
  }, true);
};

/**
 * Create a new Regl instance with `GL_EXTENSIONS` enables
 * @param   {HTMLCanvasElement}  canvas  Canvas element to be rendered on
 * @return  {import('regl').Regl}  New Regl instance
 */
const createRegl = (canvas) => {
  const gl = canvas.getContext('webgl', {
    antialias: true,
    preserveDrawingBuffer: true,
  });
  const extensions = [];

  // Needed to run the tests properly as the headless-gl doesn't support all
  // extensions, which is fine for the functional tests.
  GL_EXTENSIONS.forEach((EXTENSION) => {
    if (gl.getExtension(EXTENSION)) {
      extensions.push(EXTENSION);
    } else {
      console.warn(
        `WebGL: ${EXTENSION} extension not supported. Scatterplot might not render properly`
      );
    }
  });

  return regl__WEBPACK_IMPORTED_MODULE_1___default()({ gl, extensions });
};

/**
 * L2 distance between a pair of 2D points
 * @param   {number}  x1  X coordinate of the first point
 * @param   {number}  y1  Y coordinate of the first point
 * @param   {number}  x2  X coordinate of the second point
 * @param   {number}  y2  Y coordinate of the first point
 * @return  {number}  L2 distance
 */
const dist = (x1, y1, x2, y2) =>
  Math.sqrt((x1 - x2) ** 2 + (y1 - y2) ** 2);

/**
 * Get the bounding box of a set of 2D positions
 * @param   {array}  positions2d  2D positions to be checked
 * @return  {array}  Quadruple of form `[xMin, yMin, xMax, yMax]` defining the
 *  bounding box
 */
const getBBox = (positions2d) => {
  let xMin = Infinity;
  let xMax = -Infinity;
  let yMin = Infinity;
  let yMax = -Infinity;

  for (let i = 0; i < positions2d.length; i += 2) {
    xMin = positions2d[i] < xMin ? positions2d[i] : xMin;
    xMax = positions2d[i] > xMax ? positions2d[i] : xMax;
    yMin = positions2d[i + 1] < yMin ? positions2d[i + 1] : yMin;
    yMax = positions2d[i + 1] > yMax ? positions2d[i + 1] : yMax;
  }

  return [xMin, yMin, xMax, yMax];
};

/**
 * Convert a HEX-encoded color to an RGB-encoded color
 * @param   {string}  hex  HEX-encoded color string.
 * @param   {boolean}  isNormalize  If `true` the returned RGB values will be
 *   normalized to `[0,1]`.
 * @return  {array}  Triple holding the RGB values.
 */
const hexToRgb = (hex, isNormalize = false) =>
  hex
    .replace(
      /^#?([a-f\d])([a-f\d])([a-f\d])$/i,
      (m, r, g, b) => `#${r}${r}${g}${g}${b}${b}`
    )
    .substring(1)
    .match(/.{2}/g)
    .map((x) => parseInt(x, 16) / 255 ** isNormalize);

const isConditionalArray = (a, condition, { minLength = 0 } = {}) =>
  Array.isArray(a) && a.length >= minLength && a.every(condition);

const isPositiveNumber = (x) => !Number.isNaN(+x) && +x >= 0;

const isStrictlyPositiveNumber = (x) => !Number.isNaN(+x) && +x > 0;

/**
 * Create a function to limit choices to a predefined list
 * @param   {array}  choices  Array of acceptable choices
 * @param   {*}  defaultOption  Default choice
 * @return  {function}  Function limiting the choices
 */
const limit = (choices, defaultChoice) => (choice) =>
  choices.indexOf(choice) >= 0 ? choice : defaultChoice;

/**
 * Promised-based image loading
 * @param {string}  src  Remote image source, i.e., a URL
 * @param {boolean} isCrossOrigin If `true` allow loading image from a source of another origin.
 * @return  {Promise<HTMLImageElement>}  Promise resolving to the image once its loaded
 */
const loadImage = (src, isCrossOrigin = false) =>
  new Promise((accept, reject) => {
    const image = new Image();
    if (isCrossOrigin) image.crossOrigin = 'anonymous';
    image.src = src;
    image.onload = () => {
      accept(image);
    };
    image.onerror = (error) => {
      reject(error);
    };
  });

/**
 * @deprecated Please use `scatterplot.createTextureFromUrl(url)`
 *
 * Create a Regl texture from an URL.
 * @param   {import('regl').Regl}  regl  Regl instance used for creating the texture.
 * @param   {string}  url  Source URL of the image.
 * @return  {Promise<import('regl').Texture2D>}  Promise resolving to the texture object.
 */
const createTextureFromUrl = (regl, url) =>
  new Promise((resolve, reject) => {
    loadImage(
      url,
      url.indexOf(window.location.origin) !== 0 && url.indexOf('base64') === -1
    )
      .then((image) => {
        resolve(regl.texture(image));
      })
      .catch((error) => {
        reject(error);
      });
  });

/**
 * Convert a HEX-encoded color to an RGBA-encoded color
 * @param   {string}  hex  HEX-encoded color string.
 * @param   {boolean}  isNormalize  If `true` the returned RGBA values will be
 *   normalized to `[0,1]`.
 * @return  {array}  Triple holding the RGBA values.
 */
const hexToRgba = (hex, isNormalize = false) => [
  ...hexToRgb(hex, isNormalize),
  255 ** !isNormalize,
];

/**
 * Tests if a string is a valid HEX color encoding
 * @param   {string}  hex  HEX-encoded color string.
 * @return  {boolean}  If `true` the string is a valid HEX color encoding.
 */
const isHex = (hex) => /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);

/**
 * Tests if a number is in `[0,1]`.
 * @param   {number}  x  Number to be tested.
 * @return  {boolean}  If `true` the number is in `[0,1]`.
 */
const isNormFloat = (x) => x >= 0 && x <= 1;

/**
 * Tests if an array consist of normalized numbers that are in `[0,1]` only.
 * @param   {array}  a  Array to be tested
 * @return  {boolean}  If `true` the array contains only numbers in `[0,1]`.
 */
const isNormFloatArray = (a) => Array.isArray(a) && a.every(isNormFloat);

/**
 * From: https://wrf.ecse.rpi.edu//Research/Short_Notes/pnpoly.html
 * @param   {Array}  point  Tuple of the form `[x,y]` to be tested.
 * @param   {Array}  polygon  1D list of vertices defining the polygon.
 * @return  {boolean}  If `true` point lies within the polygon.
 */
const isPointInPolygon = ([px, py] = [], polygon) => {
  let x1;
  let y1;
  let x2;
  let y2;
  let isWithin = false;
  for (let i = 0, j = polygon.length - 2; i < polygon.length; i += 2) {
    x1 = polygon[i];
    y1 = polygon[i + 1];
    x2 = polygon[j];
    y2 = polygon[j + 1];
    if (y1 > py !== y2 > py && px < ((x2 - x1) * (py - y1)) / (y2 - y1) + x1)
      isWithin = !isWithin;
    j = i;
  }
  return isWithin;
};

/**
 * Tests if a variable is a string
 * @param   {*}  s  Variable to be tested
 * @return  {boolean}  If `true` variable is a string
 */
const isString = (s) => typeof s === 'string' || s instanceof String;

/**
 * Tests if a number is an interger and in `[0,255]`.
 * @param   {number}  x  Number to be tested.
 * @return  {boolean}  If `true` the number is an interger and in `[0,255]`.
 */
const isUint8 = (x) => Number.isInteger(x) && x >= 0 && x <= 255;

/**
 * Tests if an array consist of Uint8 numbers only.
 * @param   {array}  a  Array to be tested.
 * @return  {boolean}  If `true` the array contains only Uint8 numbers.
 */
const isUint8Array = (a) => Array.isArray(a) && a.every(isUint8);

/**
 * Tests if an array is encoding an RGB color.
 * @param   {array}  rgb  Array to be tested
 * @return  {boolean}  If `true` the array hold a triple of Uint8 numbers or
 *   a triple of normalized floats.
 */
const isRgb = (rgb) =>
  rgb.length === 3 && (isNormFloatArray(rgb) || isUint8Array(rgb));

/**
 * Tests if an array is encoding an RGBA color.
 * @param   {array}  rgb  Array to be tested
 * @return  {boolean}  If `true` the array hold a quadruple of Uint8 numbers or
 *   a quadruple of normalized floats.
 */
const isRgba = (rgba) =>
  rgba.length === 4 && (isNormFloatArray(rgba) || isUint8Array(rgba));

/**
 * Test if a color is multiple colors
 * @param   {*}  color  To be tested
 * @return  {boolean}  If `true`, `color` is an array of colors.
 */
const isMultipleColors = (color) =>
  Array.isArray(color) &&
  color.length &&
  (Array.isArray(color[0]) || isString(color[0]));

/**
 * Fast version of `Math.max`. Based on
 *   https://jsperf.com/math-min-max-vs-ternary-vs-if/24 `Math.max` is not
 *   very fast
 * @param   {number}  a  Value A
 * @param   {number}  b  Value B
 * @return  {boolean}  If `true` A is greater than B.
 */
const max = (a, b) => (a > b ? a : b);

/**
 * Fast version of `Math.min`. Based on
 *   https://jsperf.com/math-min-max-vs-ternary-vs-if/24 `Math.max` is not
 *   very fast
 * @param   {number}  a  Value A
 * @param   {number}  b  Value B
 * @return  {boolean}  If `true` A is smaller than B.
 */
const min = (a, b) => (a < b ? a : b);

/**
 * Convert a color to an RGBA color
 * @param   {*}  color  Color to be converted. Currently supports:
 *   HEX, RGB, or RGBA.
 * @param   {boolean}  isNormalize  If `true` the returned RGBA values will be
 *   normalized to `[0,1]`.
 * @return  {array}  Quadruple defining an RGBA color.
 */
const toRgba = (color, shouldNormalize) => {
  if (isRgba(color)) {
    const isNormalized = isNormFloatArray(color);
    if (
      (shouldNormalize && isNormalized) ||
      (!shouldNormalize && !isNormalized)
    )
      return color;
    if (shouldNormalize && !isNormalized) return color.map((x) => x / 255);
    return color.map((x) => x * 255);
  }

  if (isRgb(color)) {
    const base = 255 ** !shouldNormalize;
    const isNormalized = isNormFloatArray(color);

    if (
      (shouldNormalize && isNormalized) ||
      (!shouldNormalize && !isNormalized)
    )
      return [...color, base];
    if (shouldNormalize && !isNormalized)
      return [...color.map((x) => x / 255), base];
    return [...color.map((x) => x * 255), base];
  }

  if (isHex(color)) return hexToRgba(color, shouldNormalize);

  console.warn(
    'Only HEX, RGB, and RGBA are handled by this function. Returning white instead.'
  );
  return shouldNormalize ? [1, 1, 1, 1] : [255, 255, 255, 255];
};

/**
 * Flip the key-value pairs of an object
 * @param {object} obj - Object to be flipped
 * @return {object} Flipped object
 */
const flipObj = (obj) =>
  Object.entries(obj).reduce((out, [key, value]) => {
    if (out[value]) {
      out[value] = [...out[value], key];
    } else {
      out[value] = key;
    }
    return out;
  }, {});

const rgbBrightness = (rgb) =>
  0.21 * rgb[0] + 0.72 * rgb[1] + 0.07 * rgb[2];

var version = "1.0.0";

const deprecations = {
  showRecticle: 'showReticle',
  recticleColor: 'reticleColor',
};

const checkDeprecations = (properties) => {
  Object.keys(properties)
    .filter((prop) => deprecations[prop])
    .forEach((name) => {
      console.warn(
        `regl-scatterplot: the "${name}" property is deprecated. Please use "${deprecations[name]}" instead.`
      );
      properties[deprecations[name]] = properties[name];
      delete properties[name];
    });
};

const getEncodingType = (
  type,
  defaultValue,
  { allowSegment = false, allowDensity = false } = {}
) => {
  // Z refers to the 3rd component of the RGBA value
  if (Z_NAMES.has(type)) return 'valueZ';

  // W refers to the 4th component of the RGBA value
  if (W_NAMES.has(type)) return 'valueW';

  if (type === 'segment') return allowSegment ? 'segment' : defaultValue;

  if (type === 'density') return allowDensity ? 'density' : defaultValue;

  return defaultValue;
};

const getEncodingIdx = (type) => {
  switch (type) {
    case 'valueZ':
      return 2;

    case 'valueW':
      return 3;

    default:
      return null;
  }
};

const createScatterplot = (
  /** @type {Partial<import('./types').Properties>} */ initialProperties = {}
) => {
  /** @type {import('./types').PubSub} */
  const pubSub = (0,pub_sub_es__WEBPACK_IMPORTED_MODULE_0__["default"])({
    async: !initialProperties.syncEvents,
    caseInsensitive: true,
  });
  const scratch = new Float32Array(16);
  const pvm = new Float32Array(16);
  const mousePosition = [0, 0];

  checkDeprecations(initialProperties);

  let {
    regl,
    backgroundColor = DEFAULT_COLOR_BG,
    backgroundImage = DEFAULT_BACKGROUND_IMAGE,
    canvas = document.createElement('canvas'),
    colorBy = DEFAULT_COLOR_BY,
    deselectOnDblClick = DEFAULT_DESELECT_ON_DBL_CLICK,
    deselectOnEscape = DEFAULT_DESELECT_ON_ESCAPE,
    lassoColor = DEFAULT_LASSO_COLOR,
    lassoLineWidth = DEFAULT_LASSO_LINE_WIDTH,
    lassoMinDelay = DEFAULT_LASSO_MIN_DELAY,
    lassoMinDist = DEFAULT_LASSO_MIN_DIST,
    lassoClearEvent = DEFAULT_LASSO_CLEAR_EVENT,
    lassoInitiator = DEFAULT_LASSO_INITIATOR,
    lassoInitiatorParentElement = document.body,
    keyMap = DEFAULT_KEY_MAP,
    mouseMode = DEFAULT_MOUSE_MODE,
    showReticle = DEFAULT_SHOW_RETICLE,
    reticleColor = DEFAULT_RETICLE_COLOR,
    pointColor = DEFAULT_COLOR_NORMAL,
    pointColorActive = DEFAULT_COLOR_ACTIVE,
    pointColorHover = DEFAULT_COLOR_HOVER,
    showPointConnections = DEFAULT_SHOW_POINT_CONNECTIONS,
    pointConnectionColor = DEFAULT_POINT_CONNECTION_COLOR_NORMAL,
    pointConnectionColorActive = DEFAULT_POINT_CONNECTION_COLOR_ACTIVE,
    pointConnectionColorHover = DEFAULT_POINT_CONNECTION_COLOR_HOVER,
    pointConnectionColorBy = DEFAULT_POINT_CONNECTION_COLOR_BY,
    pointConnectionOpacity = DEFAULT_POINT_CONNECTION_OPACITY,
    pointConnectionOpacityBy = DEFAULT_POINT_CONNECTION_OPACITY_BY,
    pointConnectionOpacityActive = DEFAULT_POINT_CONNECTION_OPACITY_ACTIVE,
    pointConnectionSize = DEFAULT_POINT_CONNECTION_SIZE,
    pointConnectionSizeActive = DEFAULT_POINT_CONNECTION_SIZE_ACTIVE,
    pointConnectionSizeBy = DEFAULT_POINT_CONNECTION_SIZE_BY,
    pointConnectionMaxIntPointsPerSegment = DEFAULT_POINT_CONNECTION_MAX_INT_POINTS_PER_SEGMENT,
    pointConnectionTolerance = DEFAULT_POINT_CONNECTION_INT_POINTS_TOLERANCE,
    pointSize = DEFAULT_POINT_SIZE,
    pointSizeSelected = DEFAULT_POINT_SIZE_SELECTED,
    pointSizeMouseDetection = DEFAULT_POINT_SIZE_MOUSE_DETECTION,
    pointOutlineWidth = DEFAULT_POINT_OUTLINE_WIDTH,
    opacity = DEFAULT_OPACITY,
    opacityBy = DEFAULT_OPACITY_BY,
    opacityByDensityFill = DEFAULT_OPACITY_BY_DENSITY_FILL,
    sizeBy = DEFAULT_SIZE_BY,
    height = DEFAULT_HEIGHT,
    width = DEFAULT_WIDTH,
    gamma = DEFAULT_GAMMA,
  } = initialProperties;

  let currentWidth = width === 'auto' ? 1 : width;
  let currentHeight = height === 'auto' ? 1 : height;

  // The following properties cannot be changed after the initialization
  const {
    performanceMode = DEFAULT_PERFORMANCE_MODE,
    opacityByDensityDebounceTime = DEFAULT_OPACITY_BY_DENSITY_DEBOUNCE_TIME,
  } = initialProperties;

  checkReglExtensions(regl);

  // Same as regl ||= createRegl(canvas) but avoids having to rely on
  // https://babeljs.io/docs/en/babel-plugin-proposal-logical-assignment-operators
  // eslint-disable-next-line no-unused-expressions
  regl || (regl = createRegl(canvas));

  backgroundColor = toRgba(backgroundColor, true);
  lassoColor = toRgba(lassoColor, true);
  reticleColor = toRgba(reticleColor, true);

  const fboRes = [512, 512];
  const fbo = regl.framebuffer({
    width: fboRes[0],
    height: fboRes[1],
    colorFormat: 'rgba',
    colorType: 'float',
  });
  let backgroundColorBrightness = rgbBrightness(backgroundColor);
  let camera;
  let lasso;
  let mouseDown = false;
  let selection = [];
  const selectionSet = new Set();
  const selectionConnecionSet = new Set();
  let mouseDownTime = null;
  let mouseDownPosition = [0, 0];
  let numPoints = 0;
  let numPointsInView = 0;
  let lassoActive = false;
  let lassoPointsCurr = [];
  let searchIndex;
  let viewAspectRatio;
  let dataAspectRatio = DEFAULT_DATA_ASPECT_RATIO;
  let projection;
  let model;
  let pointConnections;
  let pointConnectionMap;
  let computingPointConnectionCurves;
  let reticleHLine;
  let reticleVLine;
  let computedPointSizeMouseDetection;
  let keyActionMap = flipObj(keyMap);
  let lassoInitiatorTimeout;
  let topRightNdc;
  let bottomLeftNdc;

  let draw = true;
  let drawReticleOnce = false;

  pointColor = isMultipleColors(pointColor) ? [...pointColor] : [pointColor];
  pointColorActive = isMultipleColors(pointColorActive)
    ? [...pointColorActive]
    : [pointColorActive];
  pointColorHover = isMultipleColors(pointColorHover)
    ? [...pointColorHover]
    : [pointColorHover];

  pointColor = pointColor.map((color) => toRgba(color, true));
  pointColorActive = pointColorActive.map((color) => toRgba(color, true));
  pointColorHover = pointColorHover.map((color) => toRgba(color, true));

  opacity =
    !Array.isArray(opacity) && Number.isNaN(+opacity)
      ? pointColor[0][3]
      : opacity;
  opacity = isConditionalArray(opacity, isPositiveNumber, {
    minLength: 1,
  })
    ? [...opacity]
    : [opacity];

  pointSize = isConditionalArray(pointSize, isPositiveNumber, {
    minLength: 1,
  })
    ? [...pointSize]
    : [pointSize];

  let minPointScale = MIN_POINT_SIZE / pointSize[0];

  if (pointConnectionColor === 'inherit') {
    pointConnectionColor = [...pointColor];
  } else {
    pointConnectionColor = isMultipleColors(pointConnectionColor)
      ? [...pointConnectionColor]
      : [pointConnectionColor];
    pointConnectionColor = pointConnectionColor.map((color) =>
      toRgba(color, true)
    );
  }

  if (pointConnectionColorActive === 'inherit') {
    pointConnectionColorActive = [...pointColorActive];
  } else {
    pointConnectionColorActive = isMultipleColors(pointConnectionColorActive)
      ? [...pointConnectionColorActive]
      : [pointConnectionColorActive];
    pointConnectionColorActive = pointConnectionColorActive.map((color) =>
      toRgba(color, true)
    );
  }

  if (pointConnectionColorHover === 'inherit') {
    pointConnectionColorHover = [...pointColorHover];
  } else {
    pointConnectionColorHover = isMultipleColors(pointConnectionColorHover)
      ? [...pointConnectionColorHover]
      : [pointConnectionColorHover];
    pointConnectionColorHover = pointConnectionColorHover.map((color) =>
      toRgba(color, true)
    );
  }

  if (pointConnectionOpacity === 'inherit') {
    pointConnectionOpacity = [...opacity];
  } else {
    pointConnectionOpacity = isConditionalArray(
      pointConnectionOpacity,
      isPositiveNumber,
      {
        minLength: 1,
      }
    )
      ? [...pointConnectionOpacity]
      : [pointConnectionOpacity];
  }

  if (pointConnectionSize === 'inherit') {
    pointConnectionSize = [...pointSize];
  } else {
    pointConnectionSize = isConditionalArray(
      pointConnectionSize,
      isPositiveNumber,
      {
        minLength: 1,
      }
    )
      ? [...pointConnectionSize]
      : [pointConnectionSize];
  }

  colorBy = getEncodingType(colorBy, DEFAULT_COLOR_BY);
  opacityBy = getEncodingType(opacityBy, DEFAULT_OPACITY_BY, {
    allowDensity: true,
  });
  sizeBy = getEncodingType(sizeBy, DEFAULT_SIZE_BY);

  pointConnectionColorBy = getEncodingType(
    pointConnectionColorBy,
    DEFAULT_POINT_CONNECTION_COLOR_BY,
    { allowSegment: true }
  );
  pointConnectionOpacityBy = getEncodingType(
    pointConnectionOpacityBy,
    DEFAULT_POINT_CONNECTION_OPACITY_BY,
    { allowSegment: true }
  );
  pointConnectionSizeBy = getEncodingType(
    pointConnectionSizeBy,
    DEFAULT_POINT_CONNECTION_SIZE_BY,
    { allowSegment: true }
  );

  let stateTex; // Stores the point texture holding x, y, category, and value
  let prevStateTex; // Stores the previous point texture. Used for transitions
  let tmpStateTex; // Stores a temporary point texture. Used for transitions
  let tmpStateBuffer; // Temporary frame buffer
  let stateTexRes = 0; // Width and height of the texture
  let stateTexEps = 0; // Half a texel
  let normalPointsIndexBuffer; // Buffer holding the indices pointing to the correct texel
  let selectedPointsIndexBuffer; // Used for pointing to the selected texels
  let hoveredPointIndexBuffer; // Used for pointing to the hovered texels

  let isTransitioning = false;
  let transitionStartTime = null;
  let transitionDuration;
  let transitionEasing;
  let preTransitionShowReticle = showReticle;

  let colorTex; // Stores the point color texture
  let colorTexRes = 0; // Width and height of the texture
  let encodingTex; // Stores the point sizes and opacity values
  let encodingTexRes = 0; // Width and height of the texture

  let isViewChanged = false;
  let isInit = false;

  let maxValueZ = 0;
  let maxValueW = 0;

  let hoveredPoint;
  let isMouseInCanvas = false;

  let xScale = initialProperties.xScale || null;
  let yScale = initialProperties.yScale || null;
  let xDomainStart = 0;
  let xDomainSize = 0;
  let yDomainStart = 0;
  let yDomainSize = 0;
  if (xScale) {
    xDomainStart = xScale.domain()[0];
    xDomainSize = xScale.domain()[1] - xScale.domain()[0];
    xScale.range([0, currentWidth]);
  }
  if (yScale) {
    yDomainStart = yScale.domain()[0];
    yDomainSize = yScale.domain()[1] - yScale.domain()[0];
    yScale.range([currentHeight, 0]);
  }

  const getNdcX = (x) => -1 + (x / currentWidth) * 2;
  const getNdcY = (y) => 1 + (y / currentHeight) * -2;

  // Get relative WebGL position
  const getMouseGlPos = () => [
    getNdcX(mousePosition[0]),
    getNdcY(mousePosition[1]),
  ];

  const getScatterGlPos = (xGl, yGl) => {
    // Homogeneous vector
    const v = [xGl, yGl, 1, 1];

    // projection^-1 * view^-1 * model^-1 is the same as
    // model * view^-1 * projection
    const mvp = invert(
      scratch,
      multiply(
        scratch,
        projection,
        multiply(scratch, camera.view, model)
      )
    );

    // Translate vector
    transformMat4(v, v, mvp);

    return v.slice(0, 2);
  };

  const raycast = () => {
    const [xGl, yGl] = getMouseGlPos();
    const [xNdc, yNdc] = getScatterGlPos(xGl, yGl);

    // eslint-disable-next-line no-use-before-define
    const pointScale = getPointScale();

    // The height of the view in normalized device coordinates
    const heightNdc = topRightNdc[1] - bottomLeftNdc[1];
    // The size of a pixel in the current view in normalized device coordinates
    const pxNdc = heightNdc / currentHeight;
    // The scaled point size in normalized device coordinates
    const pointSizeNdc =
      computedPointSizeMouseDetection * pointScale * pxNdc * 0.66;

    // Get all points within a close range
    const pointsInBBox = searchIndex.range(
      xNdc - pointSizeNdc,
      yNdc - pointSizeNdc,
      xNdc + pointSizeNdc,
      yNdc + pointSizeNdc
    );

    // Find the closest point
    let minDist = pointSizeNdc;
    let clostestPoint;
    pointsInBBox.forEach((idx) => {
      const [ptX, ptY] = searchIndex.points[idx];
      const d = dist(ptX, ptY, xNdc, yNdc);
      if (d < minDist) {
        minDist = d;
        clostestPoint = idx;
      }
    });

    if (minDist < (computedPointSizeMouseDetection / currentWidth) * 2)
      return clostestPoint;
    return -1;
  };

  const lassoExtend = (lassoPoints, lassoPointsFlat) => {
    lassoPointsCurr = lassoPoints;
    lasso.setPoints(lassoPointsFlat);
    pubSub.publish('lassoExtend', { coordinates: lassoPoints });
  };

  const findPointsInLasso = (lassoPolygon) => {
    // get the bounding box of the lasso selection...
    const bBox = getBBox(lassoPolygon);
    // ...to efficiently preselect potentially selected points
    const pointsInBBox = searchIndex.range(...bBox);
    // next we test each point in the bounding box if it is in the polygon too
    const pointsInPolygon = [];
    pointsInBBox.forEach((pointIdx) => {
      if (isPointInPolygon(searchIndex.points[pointIdx], lassoPolygon))
        pointsInPolygon.push(pointIdx);
    });

    return pointsInPolygon;
  };

  const lassoClear = () => {
    lassoPointsCurr = [];
    if (lasso) lasso.clear();
  };

  const hasPointConnections = (point) => point && point.length > 4;

  const setPointConnectionColorState = (pointIdxs, stateIndex) => {
    if (
      computingPointConnectionCurves ||
      !showPointConnections ||
      !hasPointConnections(searchIndex.points[pointIdxs[0]])
    )
      return;

    const isNormal = stateIndex === 0;
    const lineIdCacher =
      stateIndex === 1
        ? (lineId) => selectionConnecionSet.add(lineId)
        : identity;

    // Get line IDs
    const lineIds = Object.keys(
      pointIdxs.reduce((ids, pointIdx) => {
        const point = searchIndex.points[pointIdx];
        const isStruct = Array.isArray(point[4]);
        const lineId = isStruct ? point[4][0] : point[4];

        ids[lineId] = true;

        return ids;
      }, {})
    );

    const buffer = pointConnections.getData().opacities;

    lineIds
      .filter((lineId) => !selectionConnecionSet.has(+lineId))
      .forEach((lineId) => {
        const index = pointConnectionMap[lineId][0];
        const numPointPerLine = pointConnectionMap[lineId][2];
        const pointOffset = pointConnectionMap[lineId][3];

        const bufferStart = index * 4 + pointOffset * 2;
        const bufferEnd = bufferStart + numPointPerLine * 2 + 4;

        // eslint-disable-next-line no-underscore-dangle
        if (buffer.__original__ === undefined) {
          // eslint-disable-next-line no-underscore-dangle
          buffer.__original__ = buffer.slice();
        }

        for (let i = bufferStart; i < bufferEnd; i++) {
          // buffer[i] = Math.floor(buffer[i] / 4) * 4 + stateIndex;
          buffer[i] = isNormal
            ? // eslint-disable-next-line no-underscore-dangle
              buffer.__original__[i]
            : pointConnectionOpacityActive;
        }

        lineIdCacher(lineId);
      });

    pointConnections.getBuffer().opacities.subdata(buffer, 0);
  };

  const indexToStateTexCoord = (index) => [
    (index % stateTexRes) / stateTexRes + stateTexEps,
    Math.floor(index / stateTexRes) / stateTexRes + stateTexEps,
  ];

  const deselect = ({ preventEvent = false } = {}) => {
    if (lassoClearEvent === LASSO_CLEAR_ON_DESELECT) lassoClear();
    if (selection.length) {
      if (!preventEvent) pubSub.publish('deselect');
      selectionConnecionSet.clear();
      setPointConnectionColorState(selection, 0);
      selection = [];
      selectionSet.clear();
      draw = true;
    }
  };

  /**
   * @param {number | number[]} pointIdxs
   * @param {import('./types').ScatterplotMethodOptions['select']}
   */
  const select = (pointIdxs, { merge = false, preventEvent = false } = {}) => {
    const pointIdxsArr = Array.isArray(pointIdxs) ? pointIdxs : [pointIdxs];

    if (merge) {
      selection = unionIntegers(selection, pointIdxsArr);
    } else {
      // Unset previously highlight point connections
      if (selection && selection.length)
        setPointConnectionColorState(selection, 0);
      selection = pointIdxsArr;
    }

    const selectionBuffer = [];

    selectionSet.clear();
    selectionConnecionSet.clear();

    for (let i = selection.length - 1; i >= 0; i--) {
      const pointIdx = selection[i];

      if (pointIdx < 0 || pointIdx >= numPoints) {
        // Remove invalid selection
        selection.splice(i, 1);
      } else {
        selectionSet.add(pointIdx);
        const texCoords = indexToStateTexCoord(pointIdx);
        selectionBuffer.push(texCoords[0]);
        selectionBuffer.push(texCoords[1]);
      }
    }

    selectedPointsIndexBuffer({
      usage: 'dynamic',
      type: 'float',
      data: selectionBuffer,
    });

    setPointConnectionColorState(selection, 1);

    if (!preventEvent) pubSub.publish('select', { points: selection });

    draw = true;
  };

  const getRelativeMousePosition = (event) => {
    const rect = canvas.getBoundingClientRect();

    mousePosition[0] = event.clientX - rect.left;
    mousePosition[1] = event.clientY - rect.top;

    return [...mousePosition];
  };

  const lassoStart = () => {
    // Fix camera for the lasso selection
    camera.config({ isFixed: true });
    mouseDown = true;
    lassoActive = true;
    lassoClear();
    pubSub.publish('lassoStart');
  };

  const lassoEnd = (lassoPoints, lassoPointsFlat, { merge = false } = {}) => {
    camera.config({ isFixed: false });
    lassoPointsCurr = [...lassoPoints];
    // const t0 = performance.now();
    const pointsInLasso = findPointsInLasso(lassoPointsFlat);
    // console.log(`found ${pointsInLasso.length} in ${performance.now() - t0} msec`);
    select(pointsInLasso, { merge });
    pubSub.publish('lassoEnd', {
      coordinates: lassoPointsCurr,
    });
    if (lassoClearEvent === LASSO_CLEAR_ON_END) lassoClear();
  };

  const lassoManager = createLasso(canvas, {
    onStart: lassoStart,
    onDraw: lassoExtend,
    onEnd: lassoEnd,
    enableInitiator: lassoInitiator,
    initiatorParentElement: lassoInitiatorParentElement,
    pointNorm: ([x, y]) => getScatterGlPos(getNdcX(x), getNdcY(y)),
  });

  const checkLassoMode = () => mouseMode === MOUSE_MODE_LASSO;

  const checkModKey = (event, action) => {
    switch (keyActionMap[action]) {
      case KEY_ALT:
        return event.altKey;

      case KEY_CMD:
        return event.metaKey;

      case KEY_CTRL:
        return event.ctrlKey;

      case KEY_META:
        return event.metaKey;

      case KEY_SHIFT:
        return event.shiftKey;

      default:
        return false;
    }
  };

  const mouseDownHandler = (event) => {
    if (!isInit) return;

    mouseDown = true;
    mouseDownTime = performance.now();

    mouseDownPosition = getRelativeMousePosition(event);
    lassoActive = checkLassoMode() || checkModKey(event, KEY_ACTION_LASSO);
  };

  const mouseUpHandler = (event) => {
    if (!isInit) return;

    mouseDown = false;

    if (lassoActive) {
      event.preventDefault();
      lassoActive = false;
      lassoManager.end({
        merge: checkModKey(event, KEY_ACTION_MERGE),
      });
    }
  };

  const mouseClickHandler = (event) => {
    if (!isInit) return;

    event.preventDefault();

    const currentMousePosition = getRelativeMousePosition(event);

    if (dist(...currentMousePosition, ...mouseDownPosition) >= lassoMinDist)
      return;

    const clickTime = performance.now() - mouseDownTime;

    if (lassoInitiator && clickTime > LONG_CLICK_TIME) {
      // Show lasso initiator on long click immideately
      lassoManager.showInitiator(event);
    } else {
      // If the user clicked normally (i.e., fast) we'll only show the lasso
      // initiator if the use click into the void
      const clostestPoint = raycast();
      if (clostestPoint >= 0) {
        if (selection.length && lassoClearEvent === LASSO_CLEAR_ON_DESELECT) {
          // Special case where we silently "deselect" the previous points by
          // overriding the selection. Hence, we need to clear the lasso.
          lassoClear();
        }
        select([clostestPoint], {
          merge: checkModKey(event, KEY_ACTION_MERGE),
        });
      } else if (!lassoInitiatorTimeout) {
        // We'll also wait to make sure the user didn't double click
        lassoInitiatorTimeout = setTimeout(() => {
          lassoInitiatorTimeout = null;
          lassoManager.showInitiator(event);
        }, SINGLE_CLICK_DELAY);
      }
    }
  };

  const mouseDblClickHandler = (event) => {
    lassoManager.hideInitiator();
    if (lassoInitiatorTimeout) {
      clearTimeout(lassoInitiatorTimeout);
      lassoInitiatorTimeout = null;
    }
    if (deselectOnDblClick) {
      event.preventDefault();
      deselect();
    }
  };

  const mouseMoveHandler = (event) => {
    if (!isInit || (!isMouseInCanvas && !mouseDown)) return;

    getRelativeMousePosition(event);

    // Only ray cast if the mouse cursor is inside
    if (isMouseInCanvas && !lassoActive) {
      hover(raycast()); // eslint-disable-line no-use-before-define
    }

    if (lassoActive) {
      event.preventDefault();
      lassoManager.extend(event, true);
    }

    // Always redraw when mousedown as the user might have panned or lassoed
    if (mouseDown) draw = true;
  };

  const blurHandler = () => {
    if (!isInit) return;

    if (+hoveredPoint >= 0 && !selectionSet.has(hoveredPoint))
      setPointConnectionColorState([hoveredPoint], 0);
    hoveredPoint = undefined;
    isMouseInCanvas = false;
    mouseUpHandler();
    draw = true;
  };

  const createEncodingTexture = () => {
    const maxEncoding = Math.max(pointSize.length, opacity.length);

    encodingTexRes = Math.max(2, Math.ceil(Math.sqrt(maxEncoding)));
    const rgba = new Float32Array(encodingTexRes ** 2 * 4);

    for (let i = 0; i < maxEncoding; i++) {
      rgba[i * 4] = pointSize[i] || 0;
      rgba[i * 4 + 1] = opacity[i] || 0;
    }

    return regl.texture({
      data: rgba,
      shape: [encodingTexRes, encodingTexRes, 4],
      type: 'float',
    });
  };

  const getColors = (
    baseColor = pointColor,
    activeColor = pointColorActive,
    hoverColor = pointColorHover
  ) => {
    const n = baseColor.length;
    const n2 = activeColor.length;
    const n3 = hoverColor.length;
    const colors = [];
    if (n === n2 && n2 === n3) {
      for (let i = 0; i < n; i++) {
        colors.push(
          baseColor[i],
          activeColor[i],
          hoverColor[i],
          backgroundColor
        );
      }
    } else {
      for (let i = 0; i < n; i++) {
        const rgbaOpaque = [
          baseColor[i][0],
          baseColor[i][1],
          baseColor[i][2],
          1,
        ];
        const colorActive =
          colorBy === DEFAULT_COLOR_BY ? activeColor[0] : rgbaOpaque;
        const colorHover =
          colorBy === DEFAULT_COLOR_BY ? hoverColor[0] : rgbaOpaque;
        colors.push(baseColor[i], colorActive, colorHover, backgroundColor);
      }
    }
    return colors;
  };

  const createColorTexture = () => {
    const colors = getColors();
    const numColors = colors.length;
    colorTexRes = Math.max(2, Math.ceil(Math.sqrt(numColors)));
    const rgba = new Float32Array(colorTexRes ** 2 * 4);
    colors.forEach((color, i) => {
      rgba[i * 4] = color[0]; // r
      rgba[i * 4 + 1] = color[1]; // g
      rgba[i * 4 + 2] = color[2]; // b
      rgba[i * 4 + 3] = color[3]; // a
    });

    return regl.texture({
      data: rgba,
      shape: [colorTexRes, colorTexRes, 4],
      type: 'float',
    });
  };

  const updateFbo = () => {
    fboRes[0] = Math.floor(currentWidth * window.devicePixelRatio);
    fboRes[1] = Math.floor(currentHeight * window.devicePixelRatio);
    fbo.resize(...fboRes);
  };

  const updateViewAspectRatio = () => {
    viewAspectRatio = currentWidth / currentHeight;
    projection = fromScaling([], [1 / viewAspectRatio, 1, 1]);
    model = fromScaling([], [dataAspectRatio, 1, 1]);
    updateFbo();
  };

  const setDataAspectRatio = (newDataAspectRatio) => {
    if (+newDataAspectRatio <= 0) return;
    dataAspectRatio = newDataAspectRatio;
  };

  const setColors = (getter, setter) => (newColors) => {
    if (!newColors || !newColors.length) return;

    const colors = getter();
    const prevColors = [...colors];

    let tmpColors = isMultipleColors(newColors) ? newColors : [newColors];
    tmpColors = tmpColors.map((color) => toRgba(color, true));

    if (colorTex) colorTex.destroy();

    try {
      setter(tmpColors);
      colorTex = createColorTexture();
    } catch (e) {
      console.error('Invalid colors. Switching back to default colors.');
      // eslint-disable-next-line no-param-reassign
      setter(prevColors);
      colorTex = createColorTexture();
    }
  };

  const setPointColor = setColors(
    () => pointColor,
    (colors) => {
      pointColor = colors;
    }
  );
  const setPointColorActive = setColors(
    () => pointColorActive,
    (colors) => {
      pointColorActive = colors;
    }
  );
  const setPointColorHover = setColors(
    () => pointColorHover,
    (colors) => {
      pointColorHover = colors;
    }
  );

  const computeDomainView = () => {
    const xyStartPt = getScatterGlPos(-1, -1);
    const xyEndPt = getScatterGlPos(1, 1);

    const xStart = (xyStartPt[0] + 1) / 2;
    const xEnd = (xyEndPt[0] + 1) / 2;
    const yStart = (xyStartPt[1] + 1) / 2;
    const yEnd = (xyEndPt[1] + 1) / 2;

    const xDomainView = [
      xDomainStart + xStart * xDomainSize,
      xDomainStart + xEnd * xDomainSize,
    ];
    const yDomainView = [
      yDomainStart + yStart * yDomainSize,
      yDomainStart + yEnd * yDomainSize,
    ];

    return [xDomainView, yDomainView];
  };

  const updateScales = () => {
    if (!xScale && !yScale) return;

    const [xDomainView, yDomainView] = computeDomainView();

    if (xScale) xScale.domain(xDomainView);
    if (yScale) yScale.domain(yDomainView);
  };

  const setCurrentHeight = (newCurrentHeight) => {
    currentHeight = newCurrentHeight;
    canvas.height = Math.floor(currentHeight * window.devicePixelRatio);
    if (yScale) {
      yScale.range([currentHeight, 0]);
      updateScales();
    }
  };

  const setHeight = (newHeight) => {
    if (newHeight === 'auto') {
      height = newHeight;
      canvas.style.height = '100%';
      window.requestAnimationFrame(() => {
        if (canvas) setCurrentHeight(canvas.getBoundingClientRect().height);
      });
      return;
    }

    if (!+newHeight || +newHeight <= 0) return;

    height = +newHeight;
    setCurrentHeight(height);
    canvas.style.height = `${height}px`;
  };

  const computePointSizeMouseDetection = () => {
    computedPointSizeMouseDetection = pointSizeMouseDetection;

    if (pointSizeMouseDetection === 'auto') {
      computedPointSizeMouseDetection = Array.isArray(pointSize)
        ? pointSize[Math.floor(pointSize.length / 2)]
        : pointSize;
    }
  };

  const setPointSize = (newPointSize) => {
    if (isConditionalArray(newPointSize, isPositiveNumber, { minLength: 1 }))
      pointSize = [...newPointSize];

    if (isStrictlyPositiveNumber(+newPointSize)) pointSize = [+newPointSize];

    minPointScale = MIN_POINT_SIZE / pointSize[0];
    encodingTex = createEncodingTexture();
    computePointSizeMouseDetection();
  };

  const setPointSizeSelected = (newPointSizeSelected) => {
    if (!+newPointSizeSelected || +newPointSizeSelected < 0) return;
    pointSizeSelected = +newPointSizeSelected;
  };

  const setPointOutlineWidth = (newPointOutlineWidth) => {
    if (!+newPointOutlineWidth || +newPointOutlineWidth < 0) return;
    pointOutlineWidth = +newPointOutlineWidth;
  };

  const setCurrentWidth = (newCurrentWidth) => {
    currentWidth = newCurrentWidth;
    canvas.width = Math.floor(currentWidth * window.devicePixelRatio);
    if (xScale) {
      xScale.range([0, currentWidth]);
      updateScales();
    }
  };

  const setWidth = (newWidth) => {
    if (newWidth === 'auto') {
      width = newWidth;
      canvas.style.width = '100%';
      window.requestAnimationFrame(() => {
        if (canvas) setCurrentWidth(canvas.getBoundingClientRect().width);
      });
      return;
    }

    if (!+newWidth || +newWidth <= 0) return;

    width = +newWidth;
    setCurrentWidth(width);
    canvas.style.width = `${currentWidth}px`;
  };

  const setOpacity = (newOpacity) => {
    if (isConditionalArray(newOpacity, isPositiveNumber, { minLength: 1 }))
      opacity = [...newOpacity];

    if (isStrictlyPositiveNumber(+newOpacity)) opacity = [+newOpacity];

    encodingTex = createEncodingTexture();
  };

  const getEncodingDataType = (type) => {
    switch (type) {
      case 'valueZ':
        return maxValueZ > 1 ? 'categorical' : 'continuous';

      case 'valueW':
        return maxValueW > 1 ? 'categorical' : 'continuous';

      default:
        return null;
    }
  };

  const getEncodingValueToIdx = (type, rangeValues) => {
    switch (type) {
      default:
      case 'categorical':
        return identity;

      case 'continuous':
        return (value) => Math.round(value * (rangeValues.length - 1));
    }
  };

  const setColorBy = (type) => {
    colorBy = getEncodingType(type, DEFAULT_COLOR_BY);
  };
  const setOpacityBy = (type) => {
    opacityBy = getEncodingType(type, DEFAULT_OPACITY_BY, {
      allowDensity: true,
    });
  };
  const setSizeBy = (type) => {
    sizeBy = getEncodingType(type, DEFAULT_SIZE_BY);
  };
  const setPointConnectionColorBy = (type) => {
    pointConnectionColorBy = getEncodingType(
      type,
      DEFAULT_POINT_CONNECTION_COLOR_BY,
      { allowSegment: true }
    );
  };
  const setPointConnectionOpacityBy = (type) => {
    pointConnectionOpacityBy = getEncodingType(
      type,
      DEFAULT_POINT_CONNECTION_OPACITY_BY,
      { allowSegment: true }
    );
  };
  const setPointConnectionSizeBy = (type) => {
    pointConnectionSizeBy = getEncodingType(
      type,
      DEFAULT_POINT_CONNECTION_SIZE_BY,
      { allowSegment: true }
    );
  };

  const getBackgroundImage = () => backgroundImage;
  const getColorTex = () => colorTex;
  const getColorTexRes = () => colorTexRes;
  const getColorTexEps = () => 0.5 / colorTexRes;
  const getDevicePixelRatio = () => window.devicePixelRatio;
  const getNormalPointsIndexBuffer = () => normalPointsIndexBuffer;
  const getSelectedPointsIndexBuffer = () => selectedPointsIndexBuffer;
  const getEncodingTex = () => encodingTex;
  const getEncodingTexRes = () => encodingTexRes;
  const getEncodingTexEps = () => 0.5 / encodingTexRes;
  const getNormalPointSizeExtra = () => 0;
  const getStateTex = () => tmpStateTex || stateTex;
  const getStateTexRes = () => stateTexRes;
  const getStateTexEps = () => 0.5 / stateTexRes;
  const getProjection = () => projection;
  const getView = () => camera.view;
  const getModel = () => model;
  const getProjectionViewModel = () =>
    multiply(pvm, projection, multiply(pvm, camera.view, model));
  const getPointScale = () => {
    if (camera.scaling > 1)
      return (
        (Math.asinh(max(1.0, camera.scaling)) / Math.asinh(1)) *
        window.devicePixelRatio
      );

    return max(minPointScale, camera.scaling) * window.devicePixelRatio;
  };
  // 1 + Math.log2(max(1.0, camera.scaling)) * window.devicePixelRatio;
  const getNormalNumPoints = () => numPoints;
  const getIsColoredByZ = () => +(colorBy === 'valueZ');
  const getIsColoredByW = () => +(colorBy === 'valueW');
  const getIsOpacityByZ = () => +(opacityBy === 'valueZ');
  const getIsOpacityByW = () => +(opacityBy === 'valueW');
  const getIsOpacityByDensity = () => +(opacityBy === 'density');
  const getIsSizedByZ = () => +(sizeBy === 'valueZ');
  const getIsSizedByW = () => +(sizeBy === 'valueW');
  const getColorMultiplicator = () => {
    if (colorBy === 'valueZ') return maxValueZ <= 1 ? pointColor.length - 1 : 1;
    return maxValueW <= 1 ? pointColor.length - 1 : 1;
  };
  const getOpacityMultiplicator = () => {
    if (opacityBy === 'valueZ') return maxValueZ <= 1 ? opacity.length - 1 : 1;
    return maxValueW <= 1 ? opacity.length - 1 : 1;
  };
  const getSizeMultiplicator = () => {
    if (sizeBy === 'valueZ') return maxValueZ <= 1 ? pointSize.length - 1 : 1;
    return maxValueW <= 1 ? pointSize.length - 1 : 1;
  };
  const getOpacityDensity = (context) => {
    if (opacityBy !== 'density') return 1;

    // Adopted from the fabulous Ricky Reusser:
    // https://observablehq.com/@rreusser/selecting-the-right-opacity-for-2d-point-clouds
    // Extended with a point-density based approach
    const pointScale = getPointScale();
    const p = pointSize[0] * pointScale;

    // Compute the plot's x and y range from the view matrix, though these could come from any source
    const s = (2 / (2 / camera.view[0])) * (2 / (2 / camera.view[5]));

    // Viewport size, in device pixels
    const H = context.viewportHeight;
    const W = context.viewportWidth;

    // Adaptation: Instead of using the global number of points, I am using a
    // density-based approach that takes the points in the view into context
    // when zooming in. This ensure that in sparse areas, points are opaque and
    // in dense areas points are more translucent.
    let alpha =
      ((opacityByDensityFill * W * H) / (numPointsInView * p * p)) * min(1, s);

    // In performanceMode we use squares, otherwise we use circles, which only
    // take up (pi r^2) of the unit square
    alpha *= performanceMode ? 1 : 1 / (0.25 * Math.PI);

    // If the pixels shrink below the minimum permitted size, then we adjust the opacity instead
    // and apply clamping of the point size in the vertex shader. Note that we add 0.5 since we
    // slightly inrease the size of points during rendering to accommodate SDF-style antialiasing.
    const clampedPointDeviceSize = max(MIN_POINT_SIZE, p) + 0.5;

    // We square this since we're concerned with the ratio of *areas*.
    // eslint-disable-next-line no-restricted-properties
    alpha *= Math.pow(p / clampedPointDeviceSize, 2);

    // And finally, we clamp to the range [0, 1]. We should really clamp this to 1 / precision
    // on the low end, depending on the data type of the destination so that we never render *nothing*.
    return min(1, max(0, alpha));
  };

  const updatePoints = regl({
    framebuffer: () => tmpStateBuffer,

    vert: SHADER,
    frag: SHADER$1,

    attributes: {
      position: [-4, 0, 4, 4, 4, -4],
    },

    uniforms: {
      startStateTex: () => prevStateTex,
      endStateTex: () => stateTex,
      t: (ctx, props) => props.t,
    },

    count: 3,
  });

  // From https://observablehq.com/@rreusser/selecting-the-right-opacity-for-2d-point-clouds
  const copyToScreen = regl({
    vert: `
      precision highp float;
      attribute vec2 xy;
      void main () {
        gl_Position = vec4(xy, 0, 1);
      }`,
    frag: `
      precision highp float;
      uniform vec2 srcRes;
      uniform sampler2D src;
      uniform float gamma;

      vec3 approxLinearToSRGB (vec3 rgb, float gamma) {
        return pow(clamp(rgb, vec3(0), vec3(1)), vec3(1.0 / gamma));
      }

      void main () {
        vec4 color = texture2D(src, gl_FragCoord.xy / srcRes);
        gl_FragColor = vec4(approxLinearToSRGB(color.rgb, gamma), color.a);
      }`,
    attributes: {
      xy: [-4, -4, 4, -4, 0, 4],
    },
    uniforms: {
      src: () => fbo,
      srcRes: () => fboRes,
      gamma: () => gamma,
    },
    count: 3,
    depth: { enable: false },
    blend: {
      enable: true,
      func: {
        srcRGB: 'one',
        srcAlpha: 'one',
        dstRGB: 'one minus src alpha',
        dstAlpha: 'one minus src alpha',
      },
    },
  });

  const drawPoints = (
    getPointSizeExtra,
    getNumPoints,
    getStateIndexBuffer,
    globalState = COLOR_NORMAL_IDX
  ) =>
    regl({
      frag: performanceMode ? FRAGMENT_SHADER : FRAGMENT_SHADER$1,
      vert: VERTEX_SHADER,

      blend: {
        enable: !performanceMode,
        func: {
          srcRGB: 'src alpha',
          srcAlpha: 'one',
          dstRGB: 'one minus src alpha',
          dstAlpha: 'one minus src alpha',
        },
      },

      depth: { enable: false },

      attributes: {
        stateIndex: {
          buffer: getStateIndexBuffer,
          size: 2,
        },
      },

      uniforms: {
        projectionViewModel: getProjectionViewModel,
        devicePixelRatio: getDevicePixelRatio,
        pointScale: getPointScale,
        encodingTex: getEncodingTex,
        encodingTexRes: getEncodingTexRes,
        encodingTexEps: getEncodingTexEps,
        pointSizeExtra: getPointSizeExtra,
        globalState,
        colorTex: getColorTex,
        colorTexRes: getColorTexRes,
        colorTexEps: getColorTexEps,
        stateTex: getStateTex,
        stateTexRes: getStateTexRes,
        stateTexEps: getStateTexEps,
        isColoredByZ: getIsColoredByZ,
        isColoredByW: getIsColoredByW,
        isOpacityByZ: getIsOpacityByZ,
        isOpacityByW: getIsOpacityByW,
        isOpacityByDensity: getIsOpacityByDensity,
        isSizedByZ: getIsSizedByZ,
        isSizedByW: getIsSizedByW,
        colorMultiplicator: getColorMultiplicator,
        opacityMultiplicator: getOpacityMultiplicator,
        opacityDensity: getOpacityDensity,
        sizeMultiplicator: getSizeMultiplicator,
        numColorStates: COLOR_NUM_STATES,
      },

      count: getNumPoints,

      primitive: 'points',
    });

  const drawPointBodies = drawPoints(
    getNormalPointSizeExtra,
    getNormalNumPoints,
    getNormalPointsIndexBuffer
  );

  const drawHoveredPoint = drawPoints(
    getNormalPointSizeExtra,
    () => 1,
    () => hoveredPointIndexBuffer,
    COLOR_HOVER_IDX
  );

  const drawSelectedPoint = () => {
    const numOutlinedPoints = selection.length;

    // Draw outer outline
    drawPoints(
      () =>
        (pointSizeSelected + pointOutlineWidth * 2) * window.devicePixelRatio,
      () => numOutlinedPoints,
      getSelectedPointsIndexBuffer,
      COLOR_ACTIVE_IDX
    )();

    // Draw inner outline
    drawPoints(
      () => (pointSizeSelected + pointOutlineWidth) * window.devicePixelRatio,
      () => numOutlinedPoints,
      getSelectedPointsIndexBuffer,
      COLOR_BG_IDX
    )();

    // Draw body
    drawPoints(
      () => pointSizeSelected,
      () => numOutlinedPoints,
      getSelectedPointsIndexBuffer,
      COLOR_ACTIVE_IDX
    )();
  };

  const drawBackgroundImage = regl({
    frag: FRAGMENT_SHADER$2,
    vert: VERTEX_SHADER$1,

    attributes: {
      position: [0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0],
    },

    uniforms: {
      projectionViewModel: getProjectionViewModel,
      texture: getBackgroundImage,
    },

    count: 6,
  });

  const drawPolygon2d = regl({
    vert: `
      precision mediump float;
      uniform mat4 projectionViewModel;
      attribute vec2 position;
      void main () {
        gl_Position = projectionViewModel * vec4(position, 0, 1);
      }`,

    frag: `
      precision mediump float;
      uniform vec4 color;
      void main () {
        gl_FragColor = vec4(color.rgb, 0.2);
      }`,

    depth: { enable: false },

    blend: {
      enable: true,
      func: {
        srcRGB: 'src alpha',
        srcAlpha: 'one',
        dstRGB: 'one minus src alpha',
        dstAlpha: 'one minus src alpha',
      },
    },

    attributes: {
      position: () => lassoPointsCurr,
    },

    uniforms: {
      projectionViewModel: getProjectionViewModel,
      color: () => lassoColor,
    },

    elements: () =>
      Array(lassoPointsCurr.length - 2)
        .fill()
        .map((_, i) => [0, i + 1, i + 2]),
  });

  const drawReticle = () => {
    if (!(hoveredPoint >= 0)) return;

    const [x, y] = searchIndex.points[hoveredPoint].slice(0, 2);

    // Homogeneous coordinates of the point
    const v = [x, y, 0, 1];

    // We have to calculate the model-view-projection matrix outside of the
    // shader as we actually don't want the mode, view, or projection of the
    // line view space to change such that the reticle is visualized across the
    // entire view container and not within the view of the scatterplot
    multiply(
      scratch,
      projection,
      multiply(scratch, camera.view, model)
    );

    transformMat4(v, v, scratch);

    reticleHLine.setPoints([-1, v[1], 1, v[1]]);
    reticleVLine.setPoints([v[0], 1, v[0], -1]);

    reticleHLine.draw();
    reticleVLine.draw();

    // Draw outer outline
    drawPoints(
      () =>
        (pointSizeSelected + pointOutlineWidth * 2) * window.devicePixelRatio,
      () => 1,
      hoveredPointIndexBuffer,
      COLOR_ACTIVE_IDX
    )();

    // Draw inner outline
    drawPoints(
      () => (pointSizeSelected + pointOutlineWidth) * window.devicePixelRatio,
      () => 1,
      hoveredPointIndexBuffer,
      COLOR_BG_IDX
    )();
  };

  const createPointIndex = (numNewPoints) => {
    const index = new Float32Array(numNewPoints * 2);

    let j = 0;
    for (let i = 0; i < numNewPoints; ++i) {
      const texCoord = indexToStateTexCoord(i);
      index[j] = texCoord[0]; // x
      index[j + 1] = texCoord[1]; // y
      j += 2;
    }

    return index;
  };

  const createStateTexture = (newPoints) => {
    const numNewPoints = newPoints.length;
    stateTexRes = Math.max(2, Math.ceil(Math.sqrt(numNewPoints)));
    stateTexEps = 0.5 / stateTexRes;
    const data = new Float32Array(stateTexRes ** 2 * 4);

    maxValueZ = 0;
    maxValueW = 0;

    for (let i = 0; i < numNewPoints; ++i) {
      data[i * 4] = newPoints[i][0]; // x
      data[i * 4 + 1] = newPoints[i][1]; // y
      data[i * 4 + 2] = newPoints[i][2] || 0; // z: value 1
      data[i * 4 + 3] = newPoints[i][3] || 0; // w: value 2

      maxValueZ = Math.max(maxValueZ, data[i * 4 + 2]);
      maxValueW = Math.max(maxValueW, data[i * 4 + 3]);
    }

    return regl.texture({
      data,
      shape: [stateTexRes, stateTexRes, 4],
      type: 'float',
    });
  };

  const cachePoints = (newPoints) => {
    if (!stateTex) return false;

    if (isTransitioning) {
      const tmp = prevStateTex;
      prevStateTex = tmpStateTex;
      tmp.destroy();
    } else {
      prevStateTex = stateTex;
    }

    tmpStateTex = createStateTexture(newPoints);
    tmpStateBuffer = regl.framebuffer({
      color: tmpStateTex,
      depth: false,
      stencil: false,
    });
    stateTex = undefined;

    return true;
  };

  const clearCachedPoints = () => {
    if (prevStateTex) {
      prevStateTex.destroy();
      prevStateTex = undefined;
    }

    if (tmpStateTex) {
      tmpStateTex.destroy();
      tmpStateTex = undefined;
    }
  };

  const setPoints = (newPoints) => {
    isInit = false;

    numPoints = newPoints.length;
    numPointsInView = numPoints;

    if (stateTex) stateTex.destroy();
    stateTex = createStateTexture(newPoints);

    normalPointsIndexBuffer({
      usage: 'static',
      type: 'float',
      data: createPointIndex(numPoints),
    });

    searchIndex = new KDBush(
      newPoints,
      (p) => p[0],
      (p) => p[1],
      16
    );

    isInit = true;
  };

  const getPointConnectionColorIndices = (curvePoints) => {
    const colorEncoding =
      pointConnectionColorBy === 'inherit' ? colorBy : pointConnectionColorBy;

    if (colorEncoding === 'segment') {
      const maxColorIdx = pointConnectionColor.length - 1;
      if (maxColorIdx < 1) return [];
      return curvePoints.reduce((colorIndices, curve, index) => {
        let totalLength = 0;
        const segLengths = [];
        // Compute the total length of the line
        for (let i = 2; i < curve.length; i += 2) {
          const segLength = Math.sqrt(
            (curve[i - 2] - curve[i]) ** 2 + (curve[i - 1] - curve[i + 1]) ** 2
          );
          segLengths.push(segLength);
          totalLength += segLength;
        }
        colorIndices[index] = [0];
        let cumLength = 0;
        // Assign the color index based on the cumulative length
        for (let i = 0; i < curve.length / 2 - 1; i++) {
          cumLength += segLengths[i];
          // The `4` comes from the fact that we have 4 color states:
          // normal, active, hover, and background
          colorIndices[index].push(
            Math.floor((cumLength / totalLength) * maxColorIdx) * 4
          );
        }
        // The `4` comes from the fact that we have 4 color states:
        // normal, active, hover, and background
        // colorIndices[index] = rangeMap(
        //   curve.length,
        //   (i) => Math.floor((i / (curve.length - 1)) * maxColorIdx) * 4
        // );
        return colorIndices;
      }, []);
    }

    if (colorEncoding) {
      const encodingIdx = getEncodingIdx(colorEncoding);
      const encodingValueToIdx = getEncodingValueToIdx(
        getEncodingDataType(colorEncoding),
        pointConnectionColorBy === 'inherit' ? pointColor : pointConnectionColor
      );
      return pointConnectionMap.reduce(
        (colorIndices, [index, referencePoint]) => {
          // The `4` comes from the fact that we have 4 color states:
          // normal, active, hover, and background
          colorIndices[index] =
            encodingValueToIdx(referencePoint[encodingIdx]) * 4;
          return colorIndices;
        },
        []
      );
    }

    return Array(pointConnectionMap.length).fill(0);
  };

  const getPointConnectionOpacities = () => {
    const opacityEncoding =
      pointConnectionOpacityBy === 'inherit'
        ? opacityBy
        : pointConnectionOpacityBy;

    if (opacityEncoding === 'segment') {
      const maxOpacityIdx = pointConnectionOpacity.length - 1;
      if (maxOpacityIdx < 1) return [];
      return pointConnectionMap.reduce(
        // eslint-disable-next-line no-unused-vars
        (opacities, [index, referencePoint, length]) => {
          opacities[index] = rangeMap(
            length,
            (i) =>
              pointConnectionOpacity[
                Math.floor((i / (length - 1)) * maxOpacityIdx)
              ]
          );
          return opacities;
        },
        []
      );
    }

    if (opacityEncoding) {
      const encodingIdx = getEncodingIdx(opacityEncoding);
      const encodingRangeMap =
        pointConnectionOpacityBy === 'inherit'
          ? opacity
          : pointConnectionOpacity;
      const encodingValueToIdx = getEncodingValueToIdx(
        getEncodingDataType(opacityEncoding),
        encodingRangeMap
      );
      return pointConnectionMap.reduce((opacities, [index, referencePoint]) => {
        opacities[index] =
          encodingRangeMap[encodingValueToIdx(referencePoint[encodingIdx])];
        return opacities;
      }, []);
    }

    return undefined;
  };

  const getPointConnectionWidths = () => {
    const sizeEncoding =
      pointConnectionSizeBy === 'inherit' ? sizeBy : pointConnectionSizeBy;

    if (sizeEncoding === 'segment') {
      const maxSizeIdx = pointConnectionSize.length - 1;
      if (maxSizeIdx < 1) return [];
      return pointConnectionMap.reduce(
        // eslint-disable-next-line no-unused-vars
        (widths, [index, referencePoint, length]) => {
          widths[index] = rangeMap(
            length,
            (i) =>
              pointConnectionSize[Math.floor((i / (length - 1)) * maxSizeIdx)]
          );
          return widths;
        },
        []
      );
    }

    if (sizeEncoding) {
      const encodingIdx = getEncodingIdx(sizeEncoding);
      const encodingRangeMap =
        pointConnectionSizeBy === 'inherit' ? pointSize : pointConnectionSize;
      const encodingValueToIdx = getEncodingValueToIdx(
        getEncodingDataType(sizeEncoding),
        encodingRangeMap
      );
      return pointConnectionMap.reduce((widths, [index, referencePoint]) => {
        widths[index] =
          encodingRangeMap[encodingValueToIdx(referencePoint[encodingIdx])];
        return widths;
      }, []);
    }

    return undefined;
  };

  const setPointConnectionMap = (curvePoints) => {
    pointConnectionMap = [];

    let cumLinePoints = 0;
    Object.keys(curvePoints).forEach((id, index) => {
      pointConnectionMap[id] = [
        index,
        curvePoints[id].reference,
        curvePoints[id].length / 2,
        // Used for offsetting in the buffer manipulations on
        // hovering and selecting
        cumLinePoints,
      ];
      cumLinePoints += curvePoints[id].length / 2;
    });
  };

  const setPointConnections = (newPoints) =>
    new Promise((resolve) => {
      pointConnections.setPoints([]);
      if (!newPoints || !newPoints.length) {
        resolve();
      } else {
        computingPointConnectionCurves = true;
        createSplineCurve(newPoints, {
          maxIntPointsPerSegment: pointConnectionMaxIntPointsPerSegment,
          tolerance: pointConnectionTolerance,
        }).then((curvePoints) => {
          setPointConnectionMap(curvePoints);
          const curvePointValues = Object.values(curvePoints);
          pointConnections.setPoints(curvePointValues, {
            colorIndices: getPointConnectionColorIndices(curvePointValues),
            opacities: getPointConnectionOpacities(),
            widths: getPointConnectionWidths(),
          });
          computingPointConnectionCurves = false;
          resolve();
        });
      }
    });

  const computeNumPointsInView = () => {
    numPointsInView =
      camera.scaling <= 1
        ? numPoints
        : searchIndex.range(
            bottomLeftNdc[0],
            bottomLeftNdc[1],
            topRightNdc[0],
            topRightNdc[1]
          ).length;
  };
  const computeNumPointsInViewDb = throttleAndDebounce(
    computeNumPointsInView,
    opacityByDensityDebounceTime
  );

  const tween = (duration, easing) => {
    if (!transitionStartTime) transitionStartTime = performance.now();

    const dt = performance.now() - transitionStartTime;

    updatePoints({ t: Math.min(1, Math.max(0, easing(dt / duration))) });

    return dt < duration;
  };

  const endTransition = () => {
    isTransitioning = false;
    transitionStartTime = null;
    transitionDuration = undefined;
    transitionEasing = undefined;
    showReticle = preTransitionShowReticle;

    clearCachedPoints();

    pubSub.publish('transitionEnd');
  };

  const startTransition = ({ duration = 500, easing = DEFAULT_EASING }) => {
    if (isTransitioning) pubSub.publish('transitionEnd');

    isTransitioning = true;
    transitionStartTime = null;
    transitionDuration = duration;
    transitionEasing = isString(easing)
      ? EASING_FNS[easing] || DEFAULT_EASING
      : easing;
    preTransitionShowReticle = showReticle;
    showReticle = false;

    pubSub.publish('transitionStart');
  };

  const toArrayOrientedPoints = (points) =>
    new Promise((resolve, reject) => {
      if (!points || Array.isArray(points)) {
        resolve(points);
      } else {
        const getX = Array.isArray(points.x) && ((i) => points.x[i]);
        const getY = Array.isArray(points.y) && ((i) => points.y[i]);
        const getL = Array.isArray(points.line) && ((i) => points.line[i]);
        const getLO =
          Array.isArray(points.lineOrder) && ((i) => points.lineOrder[i]);

        const components = Object.keys(points);
        const getZ = (() => {
          const z = components.find((c) => Z_NAMES.has(c));
          return z && ((i) => points[z][i]);
        })();
        const getW = (() => {
          const w = components.find((c) => W_NAMES.has(c));
          return w && ((i) => points[w][i]);
        })();

        if (getX && getY && getZ && getW && getL && getLO) {
          resolve(
            points.x.map((x, i) => [
              x,
              getY(i),
              getZ(i),
              getW(i),
              getL(i),
              getLO(i),
            ])
          );
        } else if (getX && getY && getZ && getW && getL) {
          resolve(
            points.x.map((x, i) => [x, getY(i), getZ(i), getW(i), getL(i)])
          );
        } else if (getX && getY && getZ && getW) {
          resolve(points.x.map((x, i) => [x, getY(i), getZ(i), getW(i)]));
        } else if (getX && getY && getZ) {
          resolve(points.x.map((x, i) => [x, getY(i), getZ(i)]));
        } else if (getX && getY) {
          resolve(points.x.map((x, i) => [x, getY(i)]));
        } else {
          reject(new Error('You need to specify at least x and y'));
        }
      }
    });

  /**
   * @param {import('./types').Points} newPoints
   * @param {import('./types').ScatterplotMethodOptions['draw']} options
   * @returns {Promise<void>}
   */
  const publicDraw = (newPoints, options = {}) =>
    toArrayOrientedPoints(newPoints).then(
      (points) =>
        new Promise((resolve) => {
          let pointsCached = false;
          if (points) {
            if (options.transition) {
              if (points.length === numPoints) {
                pointsCached = cachePoints(points);
              } else {
                console.warn(
                  'Cannot transition! The number of points between the previous and current draw call must be identical.'
                );
              }
            }
            setPoints(points);
            if (
              showPointConnections ||
              (options.showPointConnectionsOnce &&
                hasPointConnections(points[0]))
            ) {
              setPointConnections(points).then(() => {
                pubSub.publish('pointConnectionsDraw');
                draw = true;
                drawReticleOnce = options.showReticleOnce;
              });
            }
          }

          if (options.transition && pointsCached) {
            pubSub.subscribe(
              'transitionEnd',
              () => {
                // Point connects cannot be transitioned yet so we hide them during
                // the transition. Hence, we need to make sure we call `draw()` once
                // the transition has ended.
                draw = true;
                drawReticleOnce = options.showReticleOnce;
                resolve();
              },
              1
            );
            startTransition({
              duration: options.transitionDuration,
              easing: options.transitionEasing,
            });
          } else {
            pubSub.subscribe('draw', resolve, 1);
            draw = true;
            drawReticleOnce = options.showReticleOnce;
          }
        })
    );

  /** @type {<F extends Function>(f: F) => (...args: Parameters<F>) => ReturnType<F>} */
  const withDraw = (f) => (...args) => {
    const out = f(...args);
    draw = true;
    return out;
  };

  const updatePointConnectionStyle = () => {
    pointConnections.setStyle({
      color: getColors(
        pointConnectionColor,
        pointConnectionColorActive,
        pointConnectionColorHover
      ),
      opacity:
        pointConnectionOpacity === null ? null : pointConnectionOpacity[0],
      width: pointConnectionSize[0],
    });
  };

  const updateLassoInitiatorStyle = () => {
    const v = Math.round(backgroundColorBrightness) > 0 ? 0 : 255;
    lassoManager.initiator.style.border = `1px dashed rgba(${v}, ${v}, ${v}, 0.33)`;
    lassoManager.initiator.style.background = `rgba(${v}, ${v}, ${v}, 0.1)`;
  };

  const setBackgroundColor = (newBackgroundColor) => {
    if (!newBackgroundColor) return;

    backgroundColor = toRgba(newBackgroundColor, true);
    backgroundColorBrightness = rgbBrightness(backgroundColor);
    updateLassoInitiatorStyle();
  };

  const setBackgroundImage = (newBackgroundImage) => {
    if (!newBackgroundImage) {
      backgroundImage = null;
    } else if (isString(newBackgroundImage)) {
      createTextureFromUrl(regl, newBackgroundImage).then((texture) => {
        backgroundImage = texture;
        draw = true;
        pubSub.publish('backgroundImageReady');
      });
      // eslint-disable-next-line no-underscore-dangle
    } else if (newBackgroundImage._reglType === 'texture2d') {
      backgroundImage = newBackgroundImage;
    } else {
      backgroundImage = null;
    }
  };

  const setCameraDistance = (distance) => {
    if (distance > 0) camera.lookAt(camera.target, distance, camera.rotation);
  };

  const setCameraRotation = (rotation) => {
    if (rotation !== null)
      camera.lookAt(camera.target, camera.distance, rotation);
  };

  const setCameraTarget = (target) => {
    if (target) camera.lookAt(target, camera.distance, camera.rotation);
  };

  const setCameraView = (view) => {
    if (view) camera.setView(view);
  };

  const setLassoColor = (newLassoColor) => {
    if (!newLassoColor) return;

    lassoColor = toRgba(newLassoColor, true);

    lasso.setStyle({ color: lassoColor });
  };

  const setLassoLineWidth = (newLassoLineWidth) => {
    if (Number.isNaN(+newLassoLineWidth) || +newLassoLineWidth < 1) return;

    lassoLineWidth = +newLassoLineWidth;

    lasso.setStyle({ width: lassoLineWidth });
  };

  const setLassoMinDelay = (newLassoMinDelay) => {
    if (!+newLassoMinDelay) return;

    lassoMinDelay = +newLassoMinDelay;

    lassoManager.set({
      minDelay: lassoMinDelay,
    });
  };

  const setLassoMinDist = (newLassoMinDist) => {
    if (!+newLassoMinDist) return;

    lassoMinDist = +newLassoMinDist;

    lassoManager.set({
      minDist: lassoMinDist,
    });
  };

  const setLassoClearEvent = (newLassoClearEvent) => {
    lassoClearEvent = limit(
      LASSO_CLEAR_EVENTS,
      lassoClearEvent
    )(newLassoClearEvent);
  };

  const setLassoInitiator = (newLassoInitiator) => {
    lassoInitiator = Boolean(newLassoInitiator);

    lassoManager.set({
      enableInitiator: lassoInitiator,
    });
  };

  const setLassoInitiatorParentElement = (newLassoInitiatorParentElement) => {
    lassoInitiatorParentElement = newLassoInitiatorParentElement;

    lassoManager.set({
      startInitiatorParentElement: lassoInitiatorParentElement,
    });
  };

  const setKeyMap = (newKeyMap) => {
    keyMap = Object.entries(newKeyMap).reduce((map, [key, value]) => {
      if (KEYS.includes(key) && KEY_ACTIONS.includes(value)) {
        map[key] = value;
      }
      return map;
    }, {});
    keyActionMap = flipObj(keyMap);

    if (keyActionMap[KEY_ACTION_ROTATE]) {
      camera.config({
        isRotate: true,
        mouseDownMoveModKey: keyActionMap[KEY_ACTION_ROTATE],
      });
    } else {
      camera.config({
        isRotate: false,
      });
    }
  };

  const setMouseMode = (newMouseMode) => {
    mouseMode = limit(MOUSE_MODES, MOUSE_MODE_PANZOOM)(newMouseMode);

    camera.config({
      defaultMouseDownMoveAction:
        mouseMode === MOUSE_MODE_ROTATE ? 'rotate' : 'pan',
    });
  };

  const setShowReticle = (newShowReticle) => {
    if (newShowReticle === null) return;

    showReticle = newShowReticle;
  };

  const setReticleColor = (newReticleColor) => {
    if (!newReticleColor) return;

    reticleColor = toRgba(newReticleColor, true);

    reticleHLine.setStyle({ color: reticleColor });
    reticleVLine.setStyle({ color: reticleColor });
  };

  const setXScale = (newXScale) => {
    if (!newXScale) return;

    xScale = newXScale;
    xDomainStart = newXScale.domain()[0];
    xDomainSize = newXScale ? newXScale.domain()[1] - newXScale.domain()[0] : 0;
  };

  const setYScale = (newYScale) => {
    if (!newYScale) return;

    yScale = newYScale;
    yDomainStart = yScale.domain()[0];
    yDomainSize = yScale ? yScale.domain()[1] - yScale.domain()[0] : 0;
  };

  const setDeselectOnDblClick = (newDeselectOnDblClick) => {
    deselectOnDblClick = !!newDeselectOnDblClick;
  };

  const setDeselectOnEscape = (newDeselectOnEscape) => {
    deselectOnEscape = !!newDeselectOnEscape;
  };

  const setShowPointConnections = (newShowPointConnections) => {
    showPointConnections = !!newShowPointConnections;
    if (showPointConnections) {
      if (hasPointConnections(searchIndex.points[0])) {
        setPointConnections(searchIndex.points).then(() => {
          pubSub.publish('pointConnectionsDraw');
          draw = true;
        });
      }
    } else {
      setPointConnections();
    }
  };

  const setPointConnectionColors = (setter, getInheritance) => (newColors) => {
    if (newColors === 'inherit') {
      setter([...getInheritance()]);
    } else {
      const tmpColors = isMultipleColors(newColors) ? newColors : [newColors];
      setter(tmpColors.map((color) => toRgba(color, true)));
    }
    updatePointConnectionStyle();
  };

  const setPointConnectionColor = setPointConnectionColors(
    (newColors) => {
      pointConnectionColor = newColors;
    },
    () => pointColor
  );

  const setPointConnectionColorActive = setPointConnectionColors(
    (newColors) => {
      pointConnectionColorActive = newColors;
    },
    () => pointColorActive
  );

  const setPointConnectionColorHover = setPointConnectionColors(
    (newColors) => {
      pointConnectionColorHover = newColors;
    },
    () => pointColorHover
  );

  const setPointConnectionOpacity = (newOpacity) => {
    if (isConditionalArray(newOpacity, isPositiveNumber, { minLength: 1 }))
      pointConnectionOpacity = [...newOpacity];

    if (isStrictlyPositiveNumber(+newOpacity))
      pointConnectionOpacity = [+newOpacity];

    pointConnectionColor = pointConnectionColor.map((color) => {
      color[3] = !Number.isNaN(+pointConnectionOpacity[0])
        ? +pointConnectionOpacity[0]
        : color[3];
      return color;
    });

    updatePointConnectionStyle();
  };

  const setPointConnectionOpacityActive = (newOpacity) => {
    if (!Number.isNaN(+newOpacity) && +newOpacity)
      pointConnectionOpacityActive = +newOpacity;
  };

  const setPointConnectionSize = (newPointConnectionSize) => {
    if (
      isConditionalArray(newPointConnectionSize, isPositiveNumber, {
        minLength: 1,
      })
    )
      pointConnectionSize = [...newPointConnectionSize];

    if (isStrictlyPositiveNumber(+newPointConnectionSize))
      pointConnectionSize = [+newPointConnectionSize];

    updatePointConnectionStyle();
  };

  const setPointConnectionSizeActive = (newPointConnectionSizeActive) => {
    if (
      !Number.isNaN(+newPointConnectionSizeActive) &&
      +newPointConnectionSizeActive
    )
      pointConnectionSizeActive = Math.max(0, newPointConnectionSizeActive);
  };

  const setPointConnectionMaxIntPointsPerSegment = (
    newPointConnectionMaxIntPointsPerSegment
  ) => {
    pointConnectionMaxIntPointsPerSegment = Math.max(
      0,
      newPointConnectionMaxIntPointsPerSegment
    );
  };

  const setPointConnectionTolerance = (newPointConnectionTolerance) => {
    pointConnectionTolerance = Math.max(0, newPointConnectionTolerance);
  };

  const setPointSizeMouseDetection = (newPointSizeMouseDetection) => {
    pointSizeMouseDetection = newPointSizeMouseDetection;
    computePointSizeMouseDetection();
  };

  const setOpacityByDensityFill = (newOpacityByDensityFill) => {
    opacityByDensityFill = +newOpacityByDensityFill;
  };

  const setGamma = (newGamma) => {
    gamma = +newGamma;
  };

  /**
   * Update Regl's viewport, drawingBufferWidth, and drawingBufferHeight
   *
   * @description Call this method after the viewport has changed, e.g., width
   * or height have been altered
   */
  const refresh = () => {
    regl.poll();
  };

  /** @type {<Key extends keyof import('./types').Properties>(property: Key) => import('./types').Properties[Key] } */
  const get = (property) => {
    checkDeprecations({ property: true });

    if (property === 'aspectRatio') return dataAspectRatio;
    if (property === 'background') return backgroundColor;
    if (property === 'backgroundColor') return backgroundColor;
    if (property === 'backgroundImage') return backgroundImage;
    if (property === 'camera') return camera;
    if (property === 'cameraTarget') return camera.target;
    if (property === 'cameraDistance') return camera.distance;
    if (property === 'cameraRotation') return camera.rotation;
    if (property === 'cameraView') return camera.view;
    if (property === 'canvas') return canvas;
    if (property === 'colorBy') return colorBy;
    if (property === 'sizeBy') return sizeBy;
    if (property === 'deselectOnDblClick') return deselectOnDblClick;
    if (property === 'deselectOnEscape') return deselectOnEscape;
    if (property === 'height') return height;
    if (property === 'lassoColor') return lassoColor;
    if (property === 'lassoLineWidth') return lassoLineWidth;
    if (property === 'lassoMinDelay') return lassoMinDelay;
    if (property === 'lassoMinDist') return lassoMinDist;
    if (property === 'lassoClearEvent') return lassoClearEvent;
    if (property === 'lassoInitiator') return lassoInitiator;
    if (property === 'lassoInitiatorElement') return lassoManager.initiator;
    if (property === 'lassoInitiatorParentElement')
      return lassoInitiatorParentElement;
    if (property === 'keyMap') return { ...keyMap };
    if (property === 'mouseMode') return mouseMode;
    if (property === 'opacity')
      return opacity.length === 1 ? opacity[0] : opacity;
    if (property === 'opacityBy') return opacityBy;
    if (property === 'opacityByDensityFill') return opacityByDensityFill;
    if (property === 'opacityByDensityDebounceTime')
      return opacityByDensityDebounceTime;
    if (property === 'pointColor')
      return pointColor.length === 1 ? pointColor[0] : pointColor;
    if (property === 'pointColorActive')
      return pointColorActive.length === 1
        ? pointColorActive[0]
        : pointColorActive;
    if (property === 'pointColorHover')
      return pointColorHover.length === 1
        ? pointColorHover[0]
        : pointColorHover;
    if (property === 'pointOutlineWidth') return pointOutlineWidth;
    if (property === 'pointSize')
      return pointSize.length === 1 ? pointSize[0] : pointSize;
    if (property === 'pointSizeSelected') return pointSizeSelected;
    if (property === 'pointSizeMouseDetection') return pointSizeMouseDetection;
    if (property === 'showPointConnections') return showPointConnections;
    if (property === 'pointConnectionColor')
      return pointConnectionColor.length === 1
        ? pointConnectionColor[0]
        : pointConnectionColor;
    if (property === 'pointConnectionColorActive')
      return pointConnectionColorActive.length === 1
        ? pointConnectionColorActive[0]
        : pointConnectionColorActive;
    if (property === 'pointConnectionColorHover')
      return pointConnectionColorHover.length === 1
        ? pointConnectionColorHover[0]
        : pointConnectionColorHover;
    if (property === 'pointConnectionColorBy') return pointConnectionColorBy;
    if (property === 'pointConnectionOpacity')
      return pointConnectionOpacity.length === 1
        ? pointConnectionOpacity[0]
        : pointConnectionOpacity;
    if (property === 'pointConnectionOpacityBy')
      return pointConnectionOpacityBy;
    if (property === 'pointConnectionOpacityActive')
      return pointConnectionOpacityActive;
    if (property === 'pointConnectionSize')
      return pointConnectionSize.length === 1
        ? pointConnectionSize[0]
        : pointConnectionSize;
    if (property === 'pointConnectionSizeActive')
      return pointConnectionSizeActive;
    if (property === 'pointConnectionSizeBy') return pointConnectionSizeBy;
    if (property === 'pointConnectionMaxIntPointsPerSegment')
      return pointConnectionMaxIntPointsPerSegment;
    if (property === 'pointConnectionTolerance')
      return pointConnectionTolerance;
    if (property === 'reticleColor') return reticleColor;
    if (property === 'regl') return regl;
    if (property === 'showReticle') return showReticle;
    if (property === 'version') return version;
    if (property === 'width') return width;
    if (property === 'xScale') return xScale;
    if (property === 'yScale') return yScale;
    if (property === 'performanceMode') return performanceMode;
    if (property === 'gamma') return gamma;

    return undefined;
  };

  /** @type {(properties: Partial<import('./types').Settable>) => void} */
  const set = (properties = {}) => {
    checkDeprecations(properties);

    if (
      properties.backgroundColor !== undefined ||
      properties.background !== undefined
    ) {
      setBackgroundColor(properties.backgroundColor || properties.background);
    }

    if (properties.backgroundImage !== undefined) {
      setBackgroundImage(properties.backgroundImage);
    }

    if (properties.cameraTarget !== undefined) {
      setCameraTarget(properties.cameraTarget);
    }

    if (properties.cameraDistance !== undefined) {
      setCameraDistance(properties.cameraDistance);
    }

    if (properties.cameraRotation !== undefined) {
      setCameraRotation(properties.cameraRotation);
    }

    if (properties.cameraView !== undefined) {
      setCameraView(properties.cameraView);
    }

    if (properties.colorBy !== undefined) {
      setColorBy(properties.colorBy);
    }

    if (properties.pointColor !== undefined) {
      setPointColor(properties.pointColor);
    }

    if (properties.pointColorActive !== undefined) {
      setPointColorActive(properties.pointColorActive);
    }

    if (properties.pointColorHover !== undefined) {
      setPointColorHover(properties.pointColorHover);
    }

    if (properties.pointSize !== undefined) {
      setPointSize(properties.pointSize);
    }

    if (properties.pointSizeSelected !== undefined) {
      setPointSizeSelected(properties.pointSizeSelected);
    }

    if (properties.pointSizeMouseDetection !== undefined) {
      setPointSizeMouseDetection(properties.pointSizeMouseDetection);
    }

    if (properties.sizeBy !== undefined) {
      setSizeBy(properties.sizeBy);
    }

    if (properties.opacity !== undefined) {
      setOpacity(properties.opacity);
    }

    if (properties.showPointConnections !== undefined) {
      setShowPointConnections(properties.showPointConnections);
    }

    if (properties.pointConnectionColor !== undefined) {
      setPointConnectionColor(properties.pointConnectionColor);
    }

    if (properties.pointConnectionColorActive !== undefined) {
      setPointConnectionColorActive(properties.pointConnectionColorActive);
    }

    if (properties.pointConnectionColorHover !== undefined) {
      setPointConnectionColorHover(properties.pointConnectionColorHover);
    }

    if (properties.pointConnectionColorBy !== undefined) {
      setPointConnectionColorBy(properties.pointConnectionColorBy);
    }

    if (properties.pointConnectionOpacityBy !== undefined) {
      setPointConnectionOpacityBy(properties.pointConnectionOpacityBy);
    }

    if (properties.pointConnectionOpacity !== undefined) {
      setPointConnectionOpacity(properties.pointConnectionOpacity);
    }

    if (properties.pointConnectionOpacityActive !== undefined) {
      setPointConnectionOpacityActive(properties.pointConnectionOpacityActive);
    }

    if (properties.pointConnectionSize !== undefined) {
      setPointConnectionSize(properties.pointConnectionSize);
    }

    if (properties.pointConnectionSizeActive !== undefined) {
      setPointConnectionSizeActive(properties.pointConnectionSizeActive);
    }

    if (properties.pointConnectionSizeBy !== undefined) {
      setPointConnectionSizeBy(properties.pointConnectionSizeBy);
    }

    if (properties.pointConnectionMaxIntPointsPerSegment !== undefined) {
      setPointConnectionMaxIntPointsPerSegment(
        properties.pointConnectionMaxIntPointsPerSegment
      );
    }

    if (properties.pointConnectionTolerance !== undefined) {
      setPointConnectionTolerance(properties.pointConnectionTolerance);
    }

    if (properties.opacityBy !== undefined) {
      setOpacityBy(properties.opacityBy);
    }

    if (properties.lassoColor !== undefined) {
      setLassoColor(properties.lassoColor);
    }

    if (properties.lassoLineWidth !== undefined) {
      setLassoLineWidth(properties.lassoLineWidth);
    }

    if (properties.lassoMinDelay !== undefined) {
      setLassoMinDelay(properties.lassoMinDelay);
    }

    if (properties.lassoMinDist !== undefined) {
      setLassoMinDist(properties.lassoMinDist);
    }

    if (properties.lassoClearEvent !== undefined) {
      setLassoClearEvent(properties.lassoClearEvent);
    }

    if (properties.lassoInitiator !== undefined) {
      setLassoInitiator(properties.lassoInitiator);
    }

    if (properties.lassoInitiatorParentElement !== undefined) {
      setLassoInitiatorParentElement(properties.lassoInitiatorParentElement);
    }

    if (properties.keyMap !== undefined) {
      setKeyMap(properties.keyMap);
    }

    if (properties.mouseMode !== undefined) {
      setMouseMode(properties.mouseMode);
    }

    if (properties.showReticle !== undefined) {
      setShowReticle(properties.showReticle);
    }

    if (properties.reticleColor !== undefined) {
      setReticleColor(properties.reticleColor);
    }

    if (properties.pointOutlineWidth !== undefined) {
      setPointOutlineWidth(properties.pointOutlineWidth);
    }

    if (properties.height !== undefined) {
      setHeight(properties.height);
    }

    if (properties.width !== undefined) {
      setWidth(properties.width);
    }

    if (properties.aspectRatio !== undefined) {
      setDataAspectRatio(properties.aspectRatio);
    }

    if (properties.xScale !== undefined) {
      setXScale(properties.xScale);
    }

    if (properties.yScale !== undefined) {
      setYScale(properties.yScale);
    }

    if (properties.deselectOnDblClick !== undefined) {
      setDeselectOnDblClick(properties.deselectOnDblClick);
    }

    if (properties.deselectOnEscape !== undefined) {
      setDeselectOnEscape(properties.deselectOnEscape);
    }

    if (properties.opacityByDensityFill !== undefined) {
      setOpacityByDensityFill(properties.opacityByDensityFill);
    }

    if (properties.gamma !== undefined) {
      setGamma(properties.gamma);
    }

    // setWidth and setHeight can be async when width or height are set to
    // 'auto'. And since draw() would have anyway been async we can just make
    // all calls async.
    return new Promise((resolve) =>
      window.requestAnimationFrame(() => {
        if (!canvas) return; // Instance was destroyed in between
        updateViewAspectRatio();
        refresh();
        draw = true;
        resolve();
      })
    );
  };

  /**
   * @param {number | number[]} point
   * @param {import('./types').ScatterplotMethodOptions['hover']} options
   */
  const hover = (
    point,
    { showReticleOnce = false, preventEvent = false } = {}
  ) => {
    let needsRedraw = false;

    if (point >= 0 && point < numPoints) {
      needsRedraw = true;
      const oldHoveredPoint = hoveredPoint;
      const newHoveredPoint = point !== hoveredPoint;
      if (
        +oldHoveredPoint >= 0 &&
        newHoveredPoint &&
        !selectionSet.has(oldHoveredPoint)
      ) {
        setPointConnectionColorState([oldHoveredPoint], 0);
      }
      hoveredPoint = point;
      hoveredPointIndexBuffer.subdata(indexToStateTexCoord(point));
      if (!selectionSet.has(point)) setPointConnectionColorState([point], 2);
      if (newHoveredPoint && !preventEvent)
        pubSub.publish('pointover', hoveredPoint);
    } else {
      needsRedraw = +hoveredPoint >= 0;
      if (needsRedraw) {
        if (!selectionSet.has(hoveredPoint)) {
          setPointConnectionColorState([hoveredPoint], 0);
        }
        if (!preventEvent) {
          pubSub.publish('pointout', hoveredPoint);
        }
      }
      hoveredPoint = undefined;
    }

    if (needsRedraw) {
      draw = true;
      drawReticleOnce = showReticleOnce;
    }
  };

  const initCamera = () => {
    if (!camera) camera = dom2dCamera(canvas);

    if (initialProperties.cameraView) {
      camera.setView(clone(initialProperties.cameraView));
    } else if (
      initialProperties.cameraTarget ||
      initialProperties.cameraDistance ||
      initialProperties.cameraRotation
    ) {
      camera.lookAt(
        [...(initialProperties.cameraTarget || DEFAULT_TARGET)],
        initialProperties.cameraDistance || DEFAULT_DISTANCE,
        initialProperties.cameraRotation || DEFAULT_ROTATION
      );
    } else {
      camera.setView(clone(DEFAULT_VIEW));
    }

    topRightNdc = getScatterGlPos(1, 1);
    bottomLeftNdc = getScatterGlPos(-1, -1);
  };

  const reset = () => {
    initCamera();
    updateScales();

    pubSub.publish('view', {
      view: camera.view,
      camera,
      xScale,
      yScale,
    });
  };

  const keyUpHandler = ({ key }) => {
    switch (key) {
      case 'Escape':
        if (deselectOnEscape) deselect();
        break;
      // Nothing
    }
  };

  const mouseEnterCanvasHandler = () => {
    isMouseInCanvas = true;
  };

  const mouseLeaveCanvasHandler = () => {
    hover();
    isMouseInCanvas = false;
    draw = true;
  };

  const wheelHandler = () => {
    draw = true;
  };

  const clear = () => {
    setPoints([]);
    pointConnections.clear();
  };

  const resizeHandler = () => {
    const autoWidth = width === 'auto';
    const autoHeight = height === 'auto';
    if (autoWidth || autoHeight) {
      const {
        width: newWidth,
        height: newHeight,
      } = canvas.getBoundingClientRect();

      if (autoWidth) setCurrentWidth(newWidth);
      if (autoHeight) setCurrentHeight(newHeight);

      updateViewAspectRatio();
      draw = true;
    }
  };

  /** @param {import('regl').ReadOptions<Uint8Array>} options */
  const exportFn = (options = {}) => ({
    pixels: Uint8ClampedArray.from(regl.read(options)),
    width: currentWidth * window.devicePixelRatio,
    height: currentHeight * window.devicePixelRatio,
  });

  const init = () => {
    updateViewAspectRatio();
    initCamera();
    updateScales();

    lasso = createLine(regl, {
      color: lassoColor,
      width: lassoLineWidth,
      is2d: true,
    });
    pointConnections = createLine(regl, {
      color: pointConnectionColor,
      colorHover: pointConnectionColorHover,
      colorActive: pointConnectionColorActive,
      opacity:
        pointConnectionOpacity === null ? null : pointConnectionOpacity[0],
      width: pointConnectionSize[0],
      widthActive: pointConnectionSizeActive,
      is2d: true,
    });
    reticleHLine = createLine(regl, {
      color: reticleColor,
      width: 1,
      is2d: true,
    });
    reticleVLine = createLine(regl, {
      color: reticleColor,
      width: 1,
      is2d: true,
    });
    computePointSizeMouseDetection();

    // Event listeners
    canvas.addEventListener('wheel', wheelHandler);

    // Buffers
    normalPointsIndexBuffer = regl.buffer();
    selectedPointsIndexBuffer = regl.buffer();
    hoveredPointIndexBuffer = regl.buffer({
      usage: 'dynamic',
      type: 'float',
      length: FLOAT_BYTES * 2, // This buffer is fixed to exactly 1 point consisting of 2 coordinates
    });

    colorTex = createColorTexture();
    encodingTex = createEncodingTexture();

    // Set dimensions
    const whenSet = set({
      backgroundImage,
      width,
      height,
      keyMap,
    });
    updateLassoInitiatorStyle();

    // Setup event handler
    window.addEventListener('keyup', keyUpHandler, false);
    window.addEventListener('blur', blurHandler, false);
    window.addEventListener('mouseup', mouseUpHandler, false);
    window.addEventListener('mousemove', mouseMoveHandler, false);
    window.addEventListener('resize', resizeHandler);
    window.addEventListener('orientationchange', resizeHandler);
    canvas.addEventListener('mousedown', mouseDownHandler, false);
    canvas.addEventListener('mouseenter', mouseEnterCanvasHandler, false);
    canvas.addEventListener('mouseleave', mouseLeaveCanvasHandler, false);
    canvas.addEventListener('click', mouseClickHandler, false);
    canvas.addEventListener('dblclick', mouseDblClickHandler, false);

    whenSet.then(() => {
      pubSub.publish('init');
    });
  };

  const frame = regl.frame(() => {
    if (!isInit || !(draw || isTransitioning)) return;

    if (isTransitioning && !tween(transitionDuration, transitionEasing))
      endTransition();

    // Update camera
    isViewChanged = camera.tick();

    if (isViewChanged) {
      topRightNdc = getScatterGlPos(1, 1);
      bottomLeftNdc = getScatterGlPos(-1, -1);
      computeNumPointsInViewDb();
    }

    regl.clear({
      // background color (transparent)
      color: [0, 0, 0, 0],
      depth: 1,
    });

    // eslint-disable-next-line no-underscore-dangle
    if (backgroundImage && backgroundImage._reglType) {
      drawBackgroundImage();
    }

    if (lassoPointsCurr.length > 2) drawPolygon2d();

    // The draw order of the following calls is important!
    if (!isTransitioning)
      pointConnections.draw({
        projection: getProjection(),
        model: getModel(),
        view: getView(),
      });

    fbo.use(() => {
      regl.clear({
        // background color (transparent)
        color: [0, 0, 0, 0],
        depth: 1,
      });

      drawPointBodies();
      if (!mouseDown && (showReticle || drawReticleOnce)) drawReticle();
      if (hoveredPoint >= 0) drawHoveredPoint();
      if (selection.length) drawSelectedPoint();
    });

    copyToScreen();

    lasso.draw({
      projection: getProjection(),
      model: getModel(),
      view: getView(),
    });

    // Publish camera change
    if (isViewChanged) {
      updateScales();

      pubSub.publish('view', {
        view: camera.view,
        camera,
        xScale,
        yScale,
      });
    }

    draw = false;
    drawReticleOnce = false;

    pubSub.publish('draw');
  });

  const destroy = () => {
    frame.cancel();
    window.removeEventListener('keyup', keyUpHandler, false);
    window.removeEventListener('blur', blurHandler, false);
    window.removeEventListener('mouseup', mouseUpHandler, false);
    window.removeEventListener('mousemove', mouseMoveHandler, false);
    window.removeEventListener('resize', resizeHandler);
    window.removeEventListener('orientationchange', resizeHandler);
    canvas.removeEventListener('mousedown', mouseDownHandler, false);
    canvas.removeEventListener('mouseenter', mouseEnterCanvasHandler, false);
    canvas.removeEventListener('mouseleave', mouseLeaveCanvasHandler, false);
    canvas.removeEventListener('click', mouseClickHandler, false);
    canvas.removeEventListener('dblclick', mouseDblClickHandler, false);
    canvas = undefined;
    camera.dispose();
    camera = undefined;
    regl = undefined;
    lasso.destroy();
    pointConnections.destroy();
    reticleHLine.destroy();
    reticleVLine.destroy();
    pubSub.publish('destroy');
    pubSub.clear();
  };

  init();

  return {
    clear: withDraw(clear),
    createTextureFromUrl: (/** @type {string} */ url) =>
      createTextureFromUrl(regl, url),
    deselect,
    destroy,
    draw: publicDraw,
    get,
    hover,
    refresh,
    reset: withDraw(reset),
    select,
    set,
    export: exportFn,
    subscribe: pubSub.subscribe,
    unsubscribe: pubSub.unsubscribe,
  };
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createScatterplot);



/***/ }),

/***/ "../../node_modules/regl/dist/regl.js":
/*!********************************************!*\
  !*** ../../node_modules/regl/dist/regl.js ***!
  \********************************************/
/***/ (function(module) {

(function (global, factory) {
     true ? module.exports = factory() :
    0;
}(this, (function () { 'use strict';

var isTypedArray = function (x) {
  return (
    x instanceof Uint8Array ||
    x instanceof Uint16Array ||
    x instanceof Uint32Array ||
    x instanceof Int8Array ||
    x instanceof Int16Array ||
    x instanceof Int32Array ||
    x instanceof Float32Array ||
    x instanceof Float64Array ||
    x instanceof Uint8ClampedArray
  )
}

var extend = function (base, opts) {
  var keys = Object.keys(opts)
  for (var i = 0; i < keys.length; ++i) {
    base[keys[i]] = opts[keys[i]]
  }
  return base
}

// Error checking and parameter validation.
//
// Statements for the form `check.someProcedure(...)` get removed by
// a browserify transform for optimized/minified bundles.
//
/* globals atob */
var endl = '\n'

// only used for extracting shader names.  if atob not present, then errors
// will be slightly crappier
function decodeB64 (str) {
  if (typeof atob !== 'undefined') {
    return atob(str)
  }
  return 'base64:' + str
}

function raise (message) {
  var error = new Error('(regl) ' + message)
  console.error(error)
  throw error
}

function check (pred, message) {
  if (!pred) {
    raise(message)
  }
}

function encolon (message) {
  if (message) {
    return ': ' + message
  }
  return ''
}

function checkParameter (param, possibilities, message) {
  if (!(param in possibilities)) {
    raise('unknown parameter (' + param + ')' + encolon(message) +
          '. possible values: ' + Object.keys(possibilities).join())
  }
}

function checkIsTypedArray (data, message) {
  if (!isTypedArray(data)) {
    raise(
      'invalid parameter type' + encolon(message) +
      '. must be a typed array')
  }
}

function standardTypeEh (value, type) {
  switch (type) {
    case 'number': return typeof value === 'number'
    case 'object': return typeof value === 'object'
    case 'string': return typeof value === 'string'
    case 'boolean': return typeof value === 'boolean'
    case 'function': return typeof value === 'function'
    case 'undefined': return typeof value === 'undefined'
    case 'symbol': return typeof value === 'symbol'
  }
}

function checkTypeOf (value, type, message) {
  if (!standardTypeEh(value, type)) {
    raise(
      'invalid parameter type' + encolon(message) +
      '. expected ' + type + ', got ' + (typeof value))
  }
}

function checkNonNegativeInt (value, message) {
  if (!((value >= 0) &&
        ((value | 0) === value))) {
    raise('invalid parameter type, (' + value + ')' + encolon(message) +
          '. must be a nonnegative integer')
  }
}

function checkOneOf (value, list, message) {
  if (list.indexOf(value) < 0) {
    raise('invalid value' + encolon(message) + '. must be one of: ' + list)
  }
}

var constructorKeys = [
  'gl',
  'canvas',
  'container',
  'attributes',
  'pixelRatio',
  'extensions',
  'optionalExtensions',
  'profile',
  'onDone'
]

function checkConstructor (obj) {
  Object.keys(obj).forEach(function (key) {
    if (constructorKeys.indexOf(key) < 0) {
      raise('invalid regl constructor argument "' + key + '". must be one of ' + constructorKeys)
    }
  })
}

function leftPad (str, n) {
  str = str + ''
  while (str.length < n) {
    str = ' ' + str
  }
  return str
}

function ShaderFile () {
  this.name = 'unknown'
  this.lines = []
  this.index = {}
  this.hasErrors = false
}

function ShaderLine (number, line) {
  this.number = number
  this.line = line
  this.errors = []
}

function ShaderError (fileNumber, lineNumber, message) {
  this.file = fileNumber
  this.line = lineNumber
  this.message = message
}

function guessCommand () {
  var error = new Error()
  var stack = (error.stack || error).toString()
  var pat = /compileProcedure.*\n\s*at.*\((.*)\)/.exec(stack)
  if (pat) {
    return pat[1]
  }
  var pat2 = /compileProcedure.*\n\s*at\s+(.*)(\n|$)/.exec(stack)
  if (pat2) {
    return pat2[1]
  }
  return 'unknown'
}

function guessCallSite () {
  var error = new Error()
  var stack = (error.stack || error).toString()
  var pat = /at REGLCommand.*\n\s+at.*\((.*)\)/.exec(stack)
  if (pat) {
    return pat[1]
  }
  var pat2 = /at REGLCommand.*\n\s+at\s+(.*)\n/.exec(stack)
  if (pat2) {
    return pat2[1]
  }
  return 'unknown'
}

function parseSource (source, command) {
  var lines = source.split('\n')
  var lineNumber = 1
  var fileNumber = 0
  var files = {
    unknown: new ShaderFile(),
    0: new ShaderFile()
  }
  files.unknown.name = files[0].name = command || guessCommand()
  files.unknown.lines.push(new ShaderLine(0, ''))
  for (var i = 0; i < lines.length; ++i) {
    var line = lines[i]
    var parts = /^\s*#\s*(\w+)\s+(.+)\s*$/.exec(line)
    if (parts) {
      switch (parts[1]) {
        case 'line':
          var lineNumberInfo = /(\d+)(\s+\d+)?/.exec(parts[2])
          if (lineNumberInfo) {
            lineNumber = lineNumberInfo[1] | 0
            if (lineNumberInfo[2]) {
              fileNumber = lineNumberInfo[2] | 0
              if (!(fileNumber in files)) {
                files[fileNumber] = new ShaderFile()
              }
            }
          }
          break
        case 'define':
          var nameInfo = /SHADER_NAME(_B64)?\s+(.*)$/.exec(parts[2])
          if (nameInfo) {
            files[fileNumber].name = (nameInfo[1]
              ? decodeB64(nameInfo[2])
              : nameInfo[2])
          }
          break
      }
    }
    files[fileNumber].lines.push(new ShaderLine(lineNumber++, line))
  }
  Object.keys(files).forEach(function (fileNumber) {
    var file = files[fileNumber]
    file.lines.forEach(function (line) {
      file.index[line.number] = line
    })
  })
  return files
}

function parseErrorLog (errLog) {
  var result = []
  errLog.split('\n').forEach(function (errMsg) {
    if (errMsg.length < 5) {
      return
    }
    var parts = /^ERROR:\s+(\d+):(\d+):\s*(.*)$/.exec(errMsg)
    if (parts) {
      result.push(new ShaderError(
        parts[1] | 0,
        parts[2] | 0,
        parts[3].trim()))
    } else if (errMsg.length > 0) {
      result.push(new ShaderError('unknown', 0, errMsg))
    }
  })
  return result
}

function annotateFiles (files, errors) {
  errors.forEach(function (error) {
    var file = files[error.file]
    if (file) {
      var line = file.index[error.line]
      if (line) {
        line.errors.push(error)
        file.hasErrors = true
        return
      }
    }
    files.unknown.hasErrors = true
    files.unknown.lines[0].errors.push(error)
  })
}

function checkShaderError (gl, shader, source, type, command) {
  if (!gl.getShaderParameter(shader, gl.COMPILE_STATUS)) {
    var errLog = gl.getShaderInfoLog(shader)
    var typeName = type === gl.FRAGMENT_SHADER ? 'fragment' : 'vertex'
    checkCommandType(source, 'string', typeName + ' shader source must be a string', command)
    var files = parseSource(source, command)
    var errors = parseErrorLog(errLog)
    annotateFiles(files, errors)

    Object.keys(files).forEach(function (fileNumber) {
      var file = files[fileNumber]
      if (!file.hasErrors) {
        return
      }

      var strings = ['']
      var styles = ['']

      function push (str, style) {
        strings.push(str)
        styles.push(style || '')
      }

      push('file number ' + fileNumber + ': ' + file.name + '\n', 'color:red;text-decoration:underline;font-weight:bold')

      file.lines.forEach(function (line) {
        if (line.errors.length > 0) {
          push(leftPad(line.number, 4) + '|  ', 'background-color:yellow; font-weight:bold')
          push(line.line + endl, 'color:red; background-color:yellow; font-weight:bold')

          // try to guess token
          var offset = 0
          line.errors.forEach(function (error) {
            var message = error.message
            var token = /^\s*'(.*)'\s*:\s*(.*)$/.exec(message)
            if (token) {
              var tokenPat = token[1]
              message = token[2]
              switch (tokenPat) {
                case 'assign':
                  tokenPat = '='
                  break
              }
              offset = Math.max(line.line.indexOf(tokenPat, offset), 0)
            } else {
              offset = 0
            }

            push(leftPad('| ', 6))
            push(leftPad('^^^', offset + 3) + endl, 'font-weight:bold')
            push(leftPad('| ', 6))
            push(message + endl, 'font-weight:bold')
          })
          push(leftPad('| ', 6) + endl)
        } else {
          push(leftPad(line.number, 4) + '|  ')
          push(line.line + endl, 'color:red')
        }
      })
      if (typeof document !== 'undefined' && !window.chrome) {
        styles[0] = strings.join('%c')
        console.log.apply(console, styles)
      } else {
        console.log(strings.join(''))
      }
    })

    check.raise('Error compiling ' + typeName + ' shader, ' + files[0].name)
  }
}

function checkLinkError (gl, program, fragShader, vertShader, command) {
  if (!gl.getProgramParameter(program, gl.LINK_STATUS)) {
    var errLog = gl.getProgramInfoLog(program)
    var fragParse = parseSource(fragShader, command)
    var vertParse = parseSource(vertShader, command)

    var header = 'Error linking program with vertex shader, "' +
      vertParse[0].name + '", and fragment shader "' + fragParse[0].name + '"'

    if (typeof document !== 'undefined') {
      console.log('%c' + header + endl + '%c' + errLog,
        'color:red;text-decoration:underline;font-weight:bold',
        'color:red')
    } else {
      console.log(header + endl + errLog)
    }
    check.raise(header)
  }
}

function saveCommandRef (object) {
  object._commandRef = guessCommand()
}

function saveDrawCommandInfo (opts, uniforms, attributes, stringStore) {
  saveCommandRef(opts)

  function id (str) {
    if (str) {
      return stringStore.id(str)
    }
    return 0
  }
  opts._fragId = id(opts.static.frag)
  opts._vertId = id(opts.static.vert)

  function addProps (dict, set) {
    Object.keys(set).forEach(function (u) {
      dict[stringStore.id(u)] = true
    })
  }

  var uniformSet = opts._uniformSet = {}
  addProps(uniformSet, uniforms.static)
  addProps(uniformSet, uniforms.dynamic)

  var attributeSet = opts._attributeSet = {}
  addProps(attributeSet, attributes.static)
  addProps(attributeSet, attributes.dynamic)

  opts._hasCount = (
    'count' in opts.static ||
    'count' in opts.dynamic ||
    'elements' in opts.static ||
    'elements' in opts.dynamic)
}

function commandRaise (message, command) {
  var callSite = guessCallSite()
  raise(message +
    ' in command ' + (command || guessCommand()) +
    (callSite === 'unknown' ? '' : ' called from ' + callSite))
}

function checkCommand (pred, message, command) {
  if (!pred) {
    commandRaise(message, command || guessCommand())
  }
}

function checkParameterCommand (param, possibilities, message, command) {
  if (!(param in possibilities)) {
    commandRaise(
      'unknown parameter (' + param + ')' + encolon(message) +
      '. possible values: ' + Object.keys(possibilities).join(),
      command || guessCommand())
  }
}

function checkCommandType (value, type, message, command) {
  if (!standardTypeEh(value, type)) {
    commandRaise(
      'invalid parameter type' + encolon(message) +
      '. expected ' + type + ', got ' + (typeof value),
      command || guessCommand())
  }
}

function checkOptional (block) {
  block()
}

function checkFramebufferFormat (attachment, texFormats, rbFormats) {
  if (attachment.texture) {
    checkOneOf(
      attachment.texture._texture.internalformat,
      texFormats,
      'unsupported texture format for attachment')
  } else {
    checkOneOf(
      attachment.renderbuffer._renderbuffer.format,
      rbFormats,
      'unsupported renderbuffer format for attachment')
  }
}

var GL_CLAMP_TO_EDGE = 0x812F

var GL_NEAREST = 0x2600
var GL_NEAREST_MIPMAP_NEAREST = 0x2700
var GL_LINEAR_MIPMAP_NEAREST = 0x2701
var GL_NEAREST_MIPMAP_LINEAR = 0x2702
var GL_LINEAR_MIPMAP_LINEAR = 0x2703

var GL_BYTE = 5120
var GL_UNSIGNED_BYTE = 5121
var GL_SHORT = 5122
var GL_UNSIGNED_SHORT = 5123
var GL_INT = 5124
var GL_UNSIGNED_INT = 5125
var GL_FLOAT = 5126

var GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033
var GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034
var GL_UNSIGNED_SHORT_5_6_5 = 0x8363
var GL_UNSIGNED_INT_24_8_WEBGL = 0x84FA

var GL_HALF_FLOAT_OES = 0x8D61

var TYPE_SIZE = {}

TYPE_SIZE[GL_BYTE] =
TYPE_SIZE[GL_UNSIGNED_BYTE] = 1

TYPE_SIZE[GL_SHORT] =
TYPE_SIZE[GL_UNSIGNED_SHORT] =
TYPE_SIZE[GL_HALF_FLOAT_OES] =
TYPE_SIZE[GL_UNSIGNED_SHORT_5_6_5] =
TYPE_SIZE[GL_UNSIGNED_SHORT_4_4_4_4] =
TYPE_SIZE[GL_UNSIGNED_SHORT_5_5_5_1] = 2

TYPE_SIZE[GL_INT] =
TYPE_SIZE[GL_UNSIGNED_INT] =
TYPE_SIZE[GL_FLOAT] =
TYPE_SIZE[GL_UNSIGNED_INT_24_8_WEBGL] = 4

function pixelSize (type, channels) {
  if (type === GL_UNSIGNED_SHORT_5_5_5_1 ||
      type === GL_UNSIGNED_SHORT_4_4_4_4 ||
      type === GL_UNSIGNED_SHORT_5_6_5) {
    return 2
  } else if (type === GL_UNSIGNED_INT_24_8_WEBGL) {
    return 4
  } else {
    return TYPE_SIZE[type] * channels
  }
}

function isPow2 (v) {
  return !(v & (v - 1)) && (!!v)
}

function checkTexture2D (info, mipData, limits) {
  var i
  var w = mipData.width
  var h = mipData.height
  var c = mipData.channels

  // Check texture shape
  check(w > 0 && w <= limits.maxTextureSize &&
        h > 0 && h <= limits.maxTextureSize,
  'invalid texture shape')

  // check wrap mode
  if (info.wrapS !== GL_CLAMP_TO_EDGE || info.wrapT !== GL_CLAMP_TO_EDGE) {
    check(isPow2(w) && isPow2(h),
      'incompatible wrap mode for texture, both width and height must be power of 2')
  }

  if (mipData.mipmask === 1) {
    if (w !== 1 && h !== 1) {
      check(
        info.minFilter !== GL_NEAREST_MIPMAP_NEAREST &&
        info.minFilter !== GL_NEAREST_MIPMAP_LINEAR &&
        info.minFilter !== GL_LINEAR_MIPMAP_NEAREST &&
        info.minFilter !== GL_LINEAR_MIPMAP_LINEAR,
        'min filter requires mipmap')
    }
  } else {
    // texture must be power of 2
    check(isPow2(w) && isPow2(h),
      'texture must be a square power of 2 to support mipmapping')
    check(mipData.mipmask === (w << 1) - 1,
      'missing or incomplete mipmap data')
  }

  if (mipData.type === GL_FLOAT) {
    if (limits.extensions.indexOf('oes_texture_float_linear') < 0) {
      check(info.minFilter === GL_NEAREST && info.magFilter === GL_NEAREST,
        'filter not supported, must enable oes_texture_float_linear')
    }
    check(!info.genMipmaps,
      'mipmap generation not supported with float textures')
  }

  // check image complete
  var mipimages = mipData.images
  for (i = 0; i < 16; ++i) {
    if (mipimages[i]) {
      var mw = w >> i
      var mh = h >> i
      check(mipData.mipmask & (1 << i), 'missing mipmap data')

      var img = mipimages[i]

      check(
        img.width === mw &&
        img.height === mh,
        'invalid shape for mip images')

      check(
        img.format === mipData.format &&
        img.internalformat === mipData.internalformat &&
        img.type === mipData.type,
        'incompatible type for mip image')

      if (img.compressed) {
        // TODO: check size for compressed images
      } else if (img.data) {
        // check(img.data.byteLength === mw * mh *
        // Math.max(pixelSize(img.type, c), img.unpackAlignment),
        var rowSize = Math.ceil(pixelSize(img.type, c) * mw / img.unpackAlignment) * img.unpackAlignment
        check(img.data.byteLength === rowSize * mh,
          'invalid data for image, buffer size is inconsistent with image format')
      } else if (img.element) {
        // TODO: check element can be loaded
      } else if (img.copy) {
        // TODO: check compatible format and type
      }
    } else if (!info.genMipmaps) {
      check((mipData.mipmask & (1 << i)) === 0, 'extra mipmap data')
    }
  }

  if (mipData.compressed) {
    check(!info.genMipmaps,
      'mipmap generation for compressed images not supported')
  }
}

function checkTextureCube (texture, info, faces, limits) {
  var w = texture.width
  var h = texture.height
  var c = texture.channels

  // Check texture shape
  check(
    w > 0 && w <= limits.maxTextureSize && h > 0 && h <= limits.maxTextureSize,
    'invalid texture shape')
  check(
    w === h,
    'cube map must be square')
  check(
    info.wrapS === GL_CLAMP_TO_EDGE && info.wrapT === GL_CLAMP_TO_EDGE,
    'wrap mode not supported by cube map')

  for (var i = 0; i < faces.length; ++i) {
    var face = faces[i]
    check(
      face.width === w && face.height === h,
      'inconsistent cube map face shape')

    if (info.genMipmaps) {
      check(!face.compressed,
        'can not generate mipmap for compressed textures')
      check(face.mipmask === 1,
        'can not specify mipmaps and generate mipmaps')
    } else {
      // TODO: check mip and filter mode
    }

    var mipmaps = face.images
    for (var j = 0; j < 16; ++j) {
      var img = mipmaps[j]
      if (img) {
        var mw = w >> j
        var mh = h >> j
        check(face.mipmask & (1 << j), 'missing mipmap data')
        check(
          img.width === mw &&
          img.height === mh,
          'invalid shape for mip images')
        check(
          img.format === texture.format &&
          img.internalformat === texture.internalformat &&
          img.type === texture.type,
          'incompatible type for mip image')

        if (img.compressed) {
          // TODO: check size for compressed images
        } else if (img.data) {
          check(img.data.byteLength === mw * mh *
            Math.max(pixelSize(img.type, c), img.unpackAlignment),
          'invalid data for image, buffer size is inconsistent with image format')
        } else if (img.element) {
          // TODO: check element can be loaded
        } else if (img.copy) {
          // TODO: check compatible format and type
        }
      }
    }
  }
}

var check$1 = extend(check, {
  optional: checkOptional,
  raise: raise,
  commandRaise: commandRaise,
  command: checkCommand,
  parameter: checkParameter,
  commandParameter: checkParameterCommand,
  constructor: checkConstructor,
  type: checkTypeOf,
  commandType: checkCommandType,
  isTypedArray: checkIsTypedArray,
  nni: checkNonNegativeInt,
  oneOf: checkOneOf,
  shaderError: checkShaderError,
  linkError: checkLinkError,
  callSite: guessCallSite,
  saveCommandRef: saveCommandRef,
  saveDrawInfo: saveDrawCommandInfo,
  framebufferFormat: checkFramebufferFormat,
  guessCommand: guessCommand,
  texture2D: checkTexture2D,
  textureCube: checkTextureCube
});

var VARIABLE_COUNTER = 0

var DYN_FUNC = 0
var DYN_CONSTANT = 5
var DYN_ARRAY = 6

function DynamicVariable (type, data) {
  this.id = (VARIABLE_COUNTER++)
  this.type = type
  this.data = data
}

function escapeStr (str) {
  return str.replace(/\\/g, '\\\\').replace(/"/g, '\\"')
}

function splitParts (str) {
  if (str.length === 0) {
    return []
  }

  var firstChar = str.charAt(0)
  var lastChar = str.charAt(str.length - 1)

  if (str.length > 1 &&
      firstChar === lastChar &&
      (firstChar === '"' || firstChar === "'")) {
    return ['"' + escapeStr(str.substr(1, str.length - 2)) + '"']
  }

  var parts = /\[(false|true|null|\d+|'[^']*'|"[^"]*")\]/.exec(str)
  if (parts) {
    return (
      splitParts(str.substr(0, parts.index))
        .concat(splitParts(parts[1]))
        .concat(splitParts(str.substr(parts.index + parts[0].length)))
    )
  }

  var subparts = str.split('.')
  if (subparts.length === 1) {
    return ['"' + escapeStr(str) + '"']
  }

  var result = []
  for (var i = 0; i < subparts.length; ++i) {
    result = result.concat(splitParts(subparts[i]))
  }
  return result
}

function toAccessorString (str) {
  return '[' + splitParts(str).join('][') + ']'
}

function defineDynamic (type, data) {
  return new DynamicVariable(type, toAccessorString(data + ''))
}

function isDynamic (x) {
  return (typeof x === 'function' && !x._reglType) || (x instanceof DynamicVariable)
}

function unbox (x, path) {
  if (typeof x === 'function') {
    return new DynamicVariable(DYN_FUNC, x)
  } else if (typeof x === 'number' || typeof x === 'boolean') {
    return new DynamicVariable(DYN_CONSTANT, x)
  } else if (Array.isArray(x)) {
    return new DynamicVariable(DYN_ARRAY, x.map(function (y, i) { return unbox(y, path + '[' + i + ']') }))
  } else if (x instanceof DynamicVariable) {
    return x
  }
  check$1(false, 'invalid option type in uniform ' + path)
}

var dynamic = {
  DynamicVariable: DynamicVariable,
  define: defineDynamic,
  isDynamic: isDynamic,
  unbox: unbox,
  accessor: toAccessorString
};

/* globals requestAnimationFrame, cancelAnimationFrame */
var raf = {
  next: typeof requestAnimationFrame === 'function'
    ? function (cb) { return requestAnimationFrame(cb) }
    : function (cb) { return setTimeout(cb, 16) },
  cancel: typeof cancelAnimationFrame === 'function'
    ? function (raf) { return cancelAnimationFrame(raf) }
    : clearTimeout
};

/* globals performance */
var clock = (typeof performance !== 'undefined' && performance.now)
    ? function () { return performance.now() }
    : function () { return +(new Date()) };

function createStringStore () {
  var stringIds = { '': 0 }
  var stringValues = ['']
  return {
    id: function (str) {
      var result = stringIds[str]
      if (result) {
        return result
      }
      result = stringIds[str] = stringValues.length
      stringValues.push(str)
      return result
    },

    str: function (id) {
      return stringValues[id]
    }
  }
}

// Context and canvas creation helper functions
function createCanvas (element, onDone, pixelRatio) {
  var canvas = document.createElement('canvas')
  extend(canvas.style, {
    border: 0,
    margin: 0,
    padding: 0,
    top: 0,
    left: 0,
    width: '100%',
    height: '100%'
  })
  element.appendChild(canvas)

  if (element === document.body) {
    canvas.style.position = 'absolute'
    extend(element.style, {
      margin: 0,
      padding: 0
    })
  }

  function resize () {
    var w = window.innerWidth
    var h = window.innerHeight
    if (element !== document.body) {
      var bounds = canvas.getBoundingClientRect()
      w = bounds.right - bounds.left
      h = bounds.bottom - bounds.top
    }
    canvas.width = pixelRatio * w
    canvas.height = pixelRatio * h
  }

  var resizeObserver
  if (element !== document.body && typeof ResizeObserver === 'function') {
    // ignore 'ResizeObserver' is not defined
    // eslint-disable-next-line
    resizeObserver = new ResizeObserver(function () {
      // setTimeout to avoid flicker
      setTimeout(resize)
    })
    resizeObserver.observe(element)
  } else {
    window.addEventListener('resize', resize, false)
  }

  function onDestroy () {
    if (resizeObserver) {
      resizeObserver.disconnect()
    } else {
      window.removeEventListener('resize', resize)
    }
    element.removeChild(canvas)
  }

  resize()

  return {
    canvas: canvas,
    onDestroy: onDestroy
  }
}

function createContext (canvas, contextAttributes) {
  function get (name) {
    try {
      return canvas.getContext(name, contextAttributes)
    } catch (e) {
      return null
    }
  }
  return (
    get('webgl') ||
    get('experimental-webgl') ||
    get('webgl-experimental')
  )
}

function isHTMLElement (obj) {
  return (
    typeof obj.nodeName === 'string' &&
    typeof obj.appendChild === 'function' &&
    typeof obj.getBoundingClientRect === 'function'
  )
}

function isWebGLContext (obj) {
  return (
    typeof obj.drawArrays === 'function' ||
    typeof obj.drawElements === 'function'
  )
}

function parseExtensions (input) {
  if (typeof input === 'string') {
    return input.split()
  }
  check$1(Array.isArray(input), 'invalid extension array')
  return input
}

function getElement (desc) {
  if (typeof desc === 'string') {
    check$1(typeof document !== 'undefined', 'not supported outside of DOM')
    return document.querySelector(desc)
  }
  return desc
}

function parseArgs (args_) {
  var args = args_ || {}
  var element, container, canvas, gl
  var contextAttributes = {}
  var extensions = []
  var optionalExtensions = []
  var pixelRatio = (typeof window === 'undefined' ? 1 : window.devicePixelRatio)
  var profile = false
  var onDone = function (err) {
    if (err) {
      check$1.raise(err)
    }
  }
  var onDestroy = function () {}
  if (typeof args === 'string') {
    check$1(
      typeof document !== 'undefined',
      'selector queries only supported in DOM enviroments')
    element = document.querySelector(args)
    check$1(element, 'invalid query string for element')
  } else if (typeof args === 'object') {
    if (isHTMLElement(args)) {
      element = args
    } else if (isWebGLContext(args)) {
      gl = args
      canvas = gl.canvas
    } else {
      check$1.constructor(args)
      if ('gl' in args) {
        gl = args.gl
      } else if ('canvas' in args) {
        canvas = getElement(args.canvas)
      } else if ('container' in args) {
        container = getElement(args.container)
      }
      if ('attributes' in args) {
        contextAttributes = args.attributes
        check$1.type(contextAttributes, 'object', 'invalid context attributes')
      }
      if ('extensions' in args) {
        extensions = parseExtensions(args.extensions)
      }
      if ('optionalExtensions' in args) {
        optionalExtensions = parseExtensions(args.optionalExtensions)
      }
      if ('onDone' in args) {
        check$1.type(
          args.onDone, 'function',
          'invalid or missing onDone callback')
        onDone = args.onDone
      }
      if ('profile' in args) {
        profile = !!args.profile
      }
      if ('pixelRatio' in args) {
        pixelRatio = +args.pixelRatio
        check$1(pixelRatio > 0, 'invalid pixel ratio')
      }
    }
  } else {
    check$1.raise('invalid arguments to regl')
  }

  if (element) {
    if (element.nodeName.toLowerCase() === 'canvas') {
      canvas = element
    } else {
      container = element
    }
  }

  if (!gl) {
    if (!canvas) {
      check$1(
        typeof document !== 'undefined',
        'must manually specify webgl context outside of DOM environments')
      var result = createCanvas(container || document.body, onDone, pixelRatio)
      if (!result) {
        return null
      }
      canvas = result.canvas
      onDestroy = result.onDestroy
    }
    // workaround for chromium bug, premultiplied alpha value is platform dependent
    if (contextAttributes.premultipliedAlpha === undefined) contextAttributes.premultipliedAlpha = true
    gl = createContext(canvas, contextAttributes)
  }

  if (!gl) {
    onDestroy()
    onDone('webgl not supported, try upgrading your browser or graphics drivers http://get.webgl.org')
    return null
  }

  return {
    gl: gl,
    canvas: canvas,
    container: container,
    extensions: extensions,
    optionalExtensions: optionalExtensions,
    pixelRatio: pixelRatio,
    profile: profile,
    onDone: onDone,
    onDestroy: onDestroy
  }
}

function createExtensionCache (gl, config) {
  var extensions = {}

  function tryLoadExtension (name_) {
    check$1.type(name_, 'string', 'extension name must be string')
    var name = name_.toLowerCase()
    var ext
    try {
      ext = extensions[name] = gl.getExtension(name)
    } catch (e) {}
    return !!ext
  }

  for (var i = 0; i < config.extensions.length; ++i) {
    var name = config.extensions[i]
    if (!tryLoadExtension(name)) {
      config.onDestroy()
      config.onDone('"' + name + '" extension is not supported by the current WebGL context, try upgrading your system or a different browser')
      return null
    }
  }

  config.optionalExtensions.forEach(tryLoadExtension)

  return {
    extensions: extensions,
    restore: function () {
      Object.keys(extensions).forEach(function (name) {
        if (extensions[name] && !tryLoadExtension(name)) {
          throw new Error('(regl): error restoring extension ' + name)
        }
      })
    }
  }
}

function loop (n, f) {
  var result = Array(n)
  for (var i = 0; i < n; ++i) {
    result[i] = f(i)
  }
  return result
}

var GL_BYTE$1 = 5120
var GL_UNSIGNED_BYTE$2 = 5121
var GL_SHORT$1 = 5122
var GL_UNSIGNED_SHORT$1 = 5123
var GL_INT$1 = 5124
var GL_UNSIGNED_INT$1 = 5125
var GL_FLOAT$2 = 5126

function nextPow16 (v) {
  for (var i = 16; i <= (1 << 28); i *= 16) {
    if (v <= i) {
      return i
    }
  }
  return 0
}

function log2 (v) {
  var r, shift
  r = (v > 0xFFFF) << 4
  v >>>= r
  shift = (v > 0xFF) << 3
  v >>>= shift; r |= shift
  shift = (v > 0xF) << 2
  v >>>= shift; r |= shift
  shift = (v > 0x3) << 1
  v >>>= shift; r |= shift
  return r | (v >> 1)
}

function createPool () {
  var bufferPool = loop(8, function () {
    return []
  })

  function alloc (n) {
    var sz = nextPow16(n)
    var bin = bufferPool[log2(sz) >> 2]
    if (bin.length > 0) {
      return bin.pop()
    }
    return new ArrayBuffer(sz)
  }

  function free (buf) {
    bufferPool[log2(buf.byteLength) >> 2].push(buf)
  }

  function allocType (type, n) {
    var result = null
    switch (type) {
      case GL_BYTE$1:
        result = new Int8Array(alloc(n), 0, n)
        break
      case GL_UNSIGNED_BYTE$2:
        result = new Uint8Array(alloc(n), 0, n)
        break
      case GL_SHORT$1:
        result = new Int16Array(alloc(2 * n), 0, n)
        break
      case GL_UNSIGNED_SHORT$1:
        result = new Uint16Array(alloc(2 * n), 0, n)
        break
      case GL_INT$1:
        result = new Int32Array(alloc(4 * n), 0, n)
        break
      case GL_UNSIGNED_INT$1:
        result = new Uint32Array(alloc(4 * n), 0, n)
        break
      case GL_FLOAT$2:
        result = new Float32Array(alloc(4 * n), 0, n)
        break
      default:
        return null
    }
    if (result.length !== n) {
      return result.subarray(0, n)
    }
    return result
  }

  function freeType (array) {
    free(array.buffer)
  }

  return {
    alloc: alloc,
    free: free,
    allocType: allocType,
    freeType: freeType
  }
}

var pool = createPool()

// zero pool for initial zero data
pool.zero = createPool()

var GL_SUBPIXEL_BITS = 0x0D50
var GL_RED_BITS = 0x0D52
var GL_GREEN_BITS = 0x0D53
var GL_BLUE_BITS = 0x0D54
var GL_ALPHA_BITS = 0x0D55
var GL_DEPTH_BITS = 0x0D56
var GL_STENCIL_BITS = 0x0D57

var GL_ALIASED_POINT_SIZE_RANGE = 0x846D
var GL_ALIASED_LINE_WIDTH_RANGE = 0x846E

var GL_MAX_TEXTURE_SIZE = 0x0D33
var GL_MAX_VIEWPORT_DIMS = 0x0D3A
var GL_MAX_VERTEX_ATTRIBS = 0x8869
var GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB
var GL_MAX_VARYING_VECTORS = 0x8DFC
var GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D
var GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C
var GL_MAX_TEXTURE_IMAGE_UNITS = 0x8872
var GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD
var GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C
var GL_MAX_RENDERBUFFER_SIZE = 0x84E8

var GL_VENDOR = 0x1F00
var GL_RENDERER = 0x1F01
var GL_VERSION = 0x1F02
var GL_SHADING_LANGUAGE_VERSION = 0x8B8C

var GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF

var GL_MAX_COLOR_ATTACHMENTS_WEBGL = 0x8CDF
var GL_MAX_DRAW_BUFFERS_WEBGL = 0x8824

var GL_TEXTURE_2D = 0x0DE1
var GL_TEXTURE_CUBE_MAP = 0x8513
var GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515
var GL_TEXTURE0 = 0x84C0
var GL_RGBA = 0x1908
var GL_FLOAT$1 = 0x1406
var GL_UNSIGNED_BYTE$1 = 0x1401
var GL_FRAMEBUFFER = 0x8D40
var GL_FRAMEBUFFER_COMPLETE = 0x8CD5
var GL_COLOR_ATTACHMENT0 = 0x8CE0
var GL_COLOR_BUFFER_BIT$1 = 0x4000

var wrapLimits = function (gl, extensions) {
  var maxAnisotropic = 1
  if (extensions.ext_texture_filter_anisotropic) {
    maxAnisotropic = gl.getParameter(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT)
  }

  var maxDrawbuffers = 1
  var maxColorAttachments = 1
  if (extensions.webgl_draw_buffers) {
    maxDrawbuffers = gl.getParameter(GL_MAX_DRAW_BUFFERS_WEBGL)
    maxColorAttachments = gl.getParameter(GL_MAX_COLOR_ATTACHMENTS_WEBGL)
  }

  // detect if reading float textures is available (Safari doesn't support)
  var readFloat = !!extensions.oes_texture_float
  if (readFloat) {
    var readFloatTexture = gl.createTexture()
    gl.bindTexture(GL_TEXTURE_2D, readFloatTexture)
    gl.texImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 1, 1, 0, GL_RGBA, GL_FLOAT$1, null)

    var fbo = gl.createFramebuffer()
    gl.bindFramebuffer(GL_FRAMEBUFFER, fbo)
    gl.framebufferTexture2D(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_2D, readFloatTexture, 0)
    gl.bindTexture(GL_TEXTURE_2D, null)

    if (gl.checkFramebufferStatus(GL_FRAMEBUFFER) !== GL_FRAMEBUFFER_COMPLETE) readFloat = false

    else {
      gl.viewport(0, 0, 1, 1)
      gl.clearColor(1.0, 0.0, 0.0, 1.0)
      gl.clear(GL_COLOR_BUFFER_BIT$1)
      var pixels = pool.allocType(GL_FLOAT$1, 4)
      gl.readPixels(0, 0, 1, 1, GL_RGBA, GL_FLOAT$1, pixels)

      if (gl.getError()) readFloat = false
      else {
        gl.deleteFramebuffer(fbo)
        gl.deleteTexture(readFloatTexture)

        readFloat = pixels[0] === 1.0
      }

      pool.freeType(pixels)
    }
  }

  // detect non power of two cube textures support (IE doesn't support)
  var isIE = typeof navigator !== 'undefined' && (/MSIE/.test(navigator.userAgent) || /Trident\//.test(navigator.appVersion) || /Edge/.test(navigator.userAgent))

  var npotTextureCube = true

  if (!isIE) {
    var cubeTexture = gl.createTexture()
    var data = pool.allocType(GL_UNSIGNED_BYTE$1, 36)
    gl.activeTexture(GL_TEXTURE0)
    gl.bindTexture(GL_TEXTURE_CUBE_MAP, cubeTexture)
    gl.texImage2D(GL_TEXTURE_CUBE_MAP_POSITIVE_X, 0, GL_RGBA, 3, 3, 0, GL_RGBA, GL_UNSIGNED_BYTE$1, data)
    pool.freeType(data)
    gl.bindTexture(GL_TEXTURE_CUBE_MAP, null)
    gl.deleteTexture(cubeTexture)
    npotTextureCube = !gl.getError()
  }

  return {
    // drawing buffer bit depth
    colorBits: [
      gl.getParameter(GL_RED_BITS),
      gl.getParameter(GL_GREEN_BITS),
      gl.getParameter(GL_BLUE_BITS),
      gl.getParameter(GL_ALPHA_BITS)
    ],
    depthBits: gl.getParameter(GL_DEPTH_BITS),
    stencilBits: gl.getParameter(GL_STENCIL_BITS),
    subpixelBits: gl.getParameter(GL_SUBPIXEL_BITS),

    // supported extensions
    extensions: Object.keys(extensions).filter(function (ext) {
      return !!extensions[ext]
    }),

    // max aniso samples
    maxAnisotropic: maxAnisotropic,

    // max draw buffers
    maxDrawbuffers: maxDrawbuffers,
    maxColorAttachments: maxColorAttachments,

    // point and line size ranges
    pointSizeDims: gl.getParameter(GL_ALIASED_POINT_SIZE_RANGE),
    lineWidthDims: gl.getParameter(GL_ALIASED_LINE_WIDTH_RANGE),
    maxViewportDims: gl.getParameter(GL_MAX_VIEWPORT_DIMS),
    maxCombinedTextureUnits: gl.getParameter(GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS),
    maxCubeMapSize: gl.getParameter(GL_MAX_CUBE_MAP_TEXTURE_SIZE),
    maxRenderbufferSize: gl.getParameter(GL_MAX_RENDERBUFFER_SIZE),
    maxTextureUnits: gl.getParameter(GL_MAX_TEXTURE_IMAGE_UNITS),
    maxTextureSize: gl.getParameter(GL_MAX_TEXTURE_SIZE),
    maxAttributes: gl.getParameter(GL_MAX_VERTEX_ATTRIBS),
    maxVertexUniforms: gl.getParameter(GL_MAX_VERTEX_UNIFORM_VECTORS),
    maxVertexTextureUnits: gl.getParameter(GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS),
    maxVaryingVectors: gl.getParameter(GL_MAX_VARYING_VECTORS),
    maxFragmentUniforms: gl.getParameter(GL_MAX_FRAGMENT_UNIFORM_VECTORS),

    // vendor info
    glsl: gl.getParameter(GL_SHADING_LANGUAGE_VERSION),
    renderer: gl.getParameter(GL_RENDERER),
    vendor: gl.getParameter(GL_VENDOR),
    version: gl.getParameter(GL_VERSION),

    // quirks
    readFloat: readFloat,
    npotTextureCube: npotTextureCube
  }
}

function isNDArrayLike (obj) {
  return (
    !!obj &&
    typeof obj === 'object' &&
    Array.isArray(obj.shape) &&
    Array.isArray(obj.stride) &&
    typeof obj.offset === 'number' &&
    obj.shape.length === obj.stride.length &&
    (Array.isArray(obj.data) ||
      isTypedArray(obj.data)))
}

var values = function (obj) {
  return Object.keys(obj).map(function (key) { return obj[key] })
}

var flattenUtils = {
  shape: arrayShape$1,
  flatten: flattenArray
};

function flatten1D (array, nx, out) {
  for (var i = 0; i < nx; ++i) {
    out[i] = array[i]
  }
}

function flatten2D (array, nx, ny, out) {
  var ptr = 0
  for (var i = 0; i < nx; ++i) {
    var row = array[i]
    for (var j = 0; j < ny; ++j) {
      out[ptr++] = row[j]
    }
  }
}

function flatten3D (array, nx, ny, nz, out, ptr_) {
  var ptr = ptr_
  for (var i = 0; i < nx; ++i) {
    var row = array[i]
    for (var j = 0; j < ny; ++j) {
      var col = row[j]
      for (var k = 0; k < nz; ++k) {
        out[ptr++] = col[k]
      }
    }
  }
}

function flattenRec (array, shape, level, out, ptr) {
  var stride = 1
  for (var i = level + 1; i < shape.length; ++i) {
    stride *= shape[i]
  }
  var n = shape[level]
  if (shape.length - level === 4) {
    var nx = shape[level + 1]
    var ny = shape[level + 2]
    var nz = shape[level + 3]
    for (i = 0; i < n; ++i) {
      flatten3D(array[i], nx, ny, nz, out, ptr)
      ptr += stride
    }
  } else {
    for (i = 0; i < n; ++i) {
      flattenRec(array[i], shape, level + 1, out, ptr)
      ptr += stride
    }
  }
}

function flattenArray (array, shape, type, out_) {
  var sz = 1
  if (shape.length) {
    for (var i = 0; i < shape.length; ++i) {
      sz *= shape[i]
    }
  } else {
    sz = 0
  }
  var out = out_ || pool.allocType(type, sz)
  switch (shape.length) {
    case 0:
      break
    case 1:
      flatten1D(array, shape[0], out)
      break
    case 2:
      flatten2D(array, shape[0], shape[1], out)
      break
    case 3:
      flatten3D(array, shape[0], shape[1], shape[2], out, 0)
      break
    default:
      flattenRec(array, shape, 0, out, 0)
  }
  return out
}

function arrayShape$1 (array_) {
  var shape = []
  for (var array = array_; array.length; array = array[0]) {
    shape.push(array.length)
  }
  return shape
}

var arrayTypes =  {
	"[object Int8Array]": 5120,
	"[object Int16Array]": 5122,
	"[object Int32Array]": 5124,
	"[object Uint8Array]": 5121,
	"[object Uint8ClampedArray]": 5121,
	"[object Uint16Array]": 5123,
	"[object Uint32Array]": 5125,
	"[object Float32Array]": 5126,
	"[object Float64Array]": 5121,
	"[object ArrayBuffer]": 5121
};

var int8 = 5120;
var int16 = 5122;
var int32 = 5124;
var uint8 = 5121;
var uint16 = 5123;
var uint32 = 5125;
var float = 5126;
var float32 = 5126;
var glTypes = {
	int8: int8,
	int16: int16,
	int32: int32,
	uint8: uint8,
	uint16: uint16,
	uint32: uint32,
	float: float,
	float32: float32
};

var dynamic$1 = 35048;
var stream = 35040;
var usageTypes = {
	dynamic: dynamic$1,
	stream: stream,
	"static": 35044
};

var arrayFlatten = flattenUtils.flatten
var arrayShape = flattenUtils.shape

var GL_STATIC_DRAW = 0x88E4
var GL_STREAM_DRAW = 0x88E0

var GL_UNSIGNED_BYTE$3 = 5121
var GL_FLOAT$3 = 5126

var DTYPES_SIZES = []
DTYPES_SIZES[5120] = 1 // int8
DTYPES_SIZES[5122] = 2 // int16
DTYPES_SIZES[5124] = 4 // int32
DTYPES_SIZES[5121] = 1 // uint8
DTYPES_SIZES[5123] = 2 // uint16
DTYPES_SIZES[5125] = 4 // uint32
DTYPES_SIZES[5126] = 4 // float32

function typedArrayCode (data) {
  return arrayTypes[Object.prototype.toString.call(data)] | 0
}

function copyArray (out, inp) {
  for (var i = 0; i < inp.length; ++i) {
    out[i] = inp[i]
  }
}

function transpose (
  result, data, shapeX, shapeY, strideX, strideY, offset) {
  var ptr = 0
  for (var i = 0; i < shapeX; ++i) {
    for (var j = 0; j < shapeY; ++j) {
      result[ptr++] = data[strideX * i + strideY * j + offset]
    }
  }
}

function wrapBufferState (gl, stats, config, destroyBuffer) {
  var bufferCount = 0
  var bufferSet = {}

  function REGLBuffer (type) {
    this.id = bufferCount++
    this.buffer = gl.createBuffer()
    this.type = type
    this.usage = GL_STATIC_DRAW
    this.byteLength = 0
    this.dimension = 1
    this.dtype = GL_UNSIGNED_BYTE$3

    this.persistentData = null

    if (config.profile) {
      this.stats = { size: 0 }
    }
  }

  REGLBuffer.prototype.bind = function () {
    gl.bindBuffer(this.type, this.buffer)
  }

  REGLBuffer.prototype.destroy = function () {
    destroy(this)
  }

  var streamPool = []

  function createStream (type, data) {
    var buffer = streamPool.pop()
    if (!buffer) {
      buffer = new REGLBuffer(type)
    }
    buffer.bind()
    initBufferFromData(buffer, data, GL_STREAM_DRAW, 0, 1, false)
    return buffer
  }

  function destroyStream (stream$$1) {
    streamPool.push(stream$$1)
  }

  function initBufferFromTypedArray (buffer, data, usage) {
    buffer.byteLength = data.byteLength
    gl.bufferData(buffer.type, data, usage)
  }

  function initBufferFromData (buffer, data, usage, dtype, dimension, persist) {
    var shape
    buffer.usage = usage
    if (Array.isArray(data)) {
      buffer.dtype = dtype || GL_FLOAT$3
      if (data.length > 0) {
        var flatData
        if (Array.isArray(data[0])) {
          shape = arrayShape(data)
          var dim = 1
          for (var i = 1; i < shape.length; ++i) {
            dim *= shape[i]
          }
          buffer.dimension = dim
          flatData = arrayFlatten(data, shape, buffer.dtype)
          initBufferFromTypedArray(buffer, flatData, usage)
          if (persist) {
            buffer.persistentData = flatData
          } else {
            pool.freeType(flatData)
          }
        } else if (typeof data[0] === 'number') {
          buffer.dimension = dimension
          var typedData = pool.allocType(buffer.dtype, data.length)
          copyArray(typedData, data)
          initBufferFromTypedArray(buffer, typedData, usage)
          if (persist) {
            buffer.persistentData = typedData
          } else {
            pool.freeType(typedData)
          }
        } else if (isTypedArray(data[0])) {
          buffer.dimension = data[0].length
          buffer.dtype = dtype || typedArrayCode(data[0]) || GL_FLOAT$3
          flatData = arrayFlatten(
            data,
            [data.length, data[0].length],
            buffer.dtype)
          initBufferFromTypedArray(buffer, flatData, usage)
          if (persist) {
            buffer.persistentData = flatData
          } else {
            pool.freeType(flatData)
          }
        } else {
          check$1.raise('invalid buffer data')
        }
      }
    } else if (isTypedArray(data)) {
      buffer.dtype = dtype || typedArrayCode(data)
      buffer.dimension = dimension
      initBufferFromTypedArray(buffer, data, usage)
      if (persist) {
        buffer.persistentData = new Uint8Array(new Uint8Array(data.buffer))
      }
    } else if (isNDArrayLike(data)) {
      shape = data.shape
      var stride = data.stride
      var offset = data.offset

      var shapeX = 0
      var shapeY = 0
      var strideX = 0
      var strideY = 0
      if (shape.length === 1) {
        shapeX = shape[0]
        shapeY = 1
        strideX = stride[0]
        strideY = 0
      } else if (shape.length === 2) {
        shapeX = shape[0]
        shapeY = shape[1]
        strideX = stride[0]
        strideY = stride[1]
      } else {
        check$1.raise('invalid shape')
      }

      buffer.dtype = dtype || typedArrayCode(data.data) || GL_FLOAT$3
      buffer.dimension = shapeY

      var transposeData = pool.allocType(buffer.dtype, shapeX * shapeY)
      transpose(transposeData,
        data.data,
        shapeX, shapeY,
        strideX, strideY,
        offset)
      initBufferFromTypedArray(buffer, transposeData, usage)
      if (persist) {
        buffer.persistentData = transposeData
      } else {
        pool.freeType(transposeData)
      }
    } else if (data instanceof ArrayBuffer) {
      buffer.dtype = GL_UNSIGNED_BYTE$3
      buffer.dimension = dimension
      initBufferFromTypedArray(buffer, data, usage)
      if (persist) {
        buffer.persistentData = new Uint8Array(new Uint8Array(data))
      }
    } else {
      check$1.raise('invalid buffer data')
    }
  }

  function destroy (buffer) {
    stats.bufferCount--

    // remove attribute link
    destroyBuffer(buffer)

    var handle = buffer.buffer
    check$1(handle, 'buffer must not be deleted already')
    gl.deleteBuffer(handle)
    buffer.buffer = null
    delete bufferSet[buffer.id]
  }

  function createBuffer (options, type, deferInit, persistent) {
    stats.bufferCount++

    var buffer = new REGLBuffer(type)
    bufferSet[buffer.id] = buffer

    function reglBuffer (options) {
      var usage = GL_STATIC_DRAW
      var data = null
      var byteLength = 0
      var dtype = 0
      var dimension = 1
      if (Array.isArray(options) ||
          isTypedArray(options) ||
          isNDArrayLike(options) ||
          options instanceof ArrayBuffer) {
        data = options
      } else if (typeof options === 'number') {
        byteLength = options | 0
      } else if (options) {
        check$1.type(
          options, 'object',
          'buffer arguments must be an object, a number or an array')

        if ('data' in options) {
          check$1(
            data === null ||
            Array.isArray(data) ||
            isTypedArray(data) ||
            isNDArrayLike(data),
            'invalid data for buffer')
          data = options.data
        }

        if ('usage' in options) {
          check$1.parameter(options.usage, usageTypes, 'invalid buffer usage')
          usage = usageTypes[options.usage]
        }

        if ('type' in options) {
          check$1.parameter(options.type, glTypes, 'invalid buffer type')
          dtype = glTypes[options.type]
        }

        if ('dimension' in options) {
          check$1.type(options.dimension, 'number', 'invalid dimension')
          dimension = options.dimension | 0
        }

        if ('length' in options) {
          check$1.nni(byteLength, 'buffer length must be a nonnegative integer')
          byteLength = options.length | 0
        }
      }

      buffer.bind()
      if (!data) {
        // #475
        if (byteLength) gl.bufferData(buffer.type, byteLength, usage)
        buffer.dtype = dtype || GL_UNSIGNED_BYTE$3
        buffer.usage = usage
        buffer.dimension = dimension
        buffer.byteLength = byteLength
      } else {
        initBufferFromData(buffer, data, usage, dtype, dimension, persistent)
      }

      if (config.profile) {
        buffer.stats.size = buffer.byteLength * DTYPES_SIZES[buffer.dtype]
      }

      return reglBuffer
    }

    function setSubData (data, offset) {
      check$1(offset + data.byteLength <= buffer.byteLength,
        'invalid buffer subdata call, buffer is too small. ' + ' Can\'t write data of size ' + data.byteLength + ' starting from offset ' + offset + ' to a buffer of size ' + buffer.byteLength)

      gl.bufferSubData(buffer.type, offset, data)
    }

    function subdata (data, offset_) {
      var offset = (offset_ || 0) | 0
      var shape
      buffer.bind()
      if (isTypedArray(data) || data instanceof ArrayBuffer) {
        setSubData(data, offset)
      } else if (Array.isArray(data)) {
        if (data.length > 0) {
          if (typeof data[0] === 'number') {
            var converted = pool.allocType(buffer.dtype, data.length)
            copyArray(converted, data)
            setSubData(converted, offset)
            pool.freeType(converted)
          } else if (Array.isArray(data[0]) || isTypedArray(data[0])) {
            shape = arrayShape(data)
            var flatData = arrayFlatten(data, shape, buffer.dtype)
            setSubData(flatData, offset)
            pool.freeType(flatData)
          } else {
            check$1.raise('invalid buffer data')
          }
        }
      } else if (isNDArrayLike(data)) {
        shape = data.shape
        var stride = data.stride

        var shapeX = 0
        var shapeY = 0
        var strideX = 0
        var strideY = 0
        if (shape.length === 1) {
          shapeX = shape[0]
          shapeY = 1
          strideX = stride[0]
          strideY = 0
        } else if (shape.length === 2) {
          shapeX = shape[0]
          shapeY = shape[1]
          strideX = stride[0]
          strideY = stride[1]
        } else {
          check$1.raise('invalid shape')
        }
        var dtype = Array.isArray(data.data)
          ? buffer.dtype
          : typedArrayCode(data.data)

        var transposeData = pool.allocType(dtype, shapeX * shapeY)
        transpose(transposeData,
          data.data,
          shapeX, shapeY,
          strideX, strideY,
          data.offset)
        setSubData(transposeData, offset)
        pool.freeType(transposeData)
      } else {
        check$1.raise('invalid data for buffer subdata')
      }
      return reglBuffer
    }

    if (!deferInit) {
      reglBuffer(options)
    }

    reglBuffer._reglType = 'buffer'
    reglBuffer._buffer = buffer
    reglBuffer.subdata = subdata
    if (config.profile) {
      reglBuffer.stats = buffer.stats
    }
    reglBuffer.destroy = function () { destroy(buffer) }

    return reglBuffer
  }

  function restoreBuffers () {
    values(bufferSet).forEach(function (buffer) {
      buffer.buffer = gl.createBuffer()
      gl.bindBuffer(buffer.type, buffer.buffer)
      gl.bufferData(
        buffer.type, buffer.persistentData || buffer.byteLength, buffer.usage)
    })
  }

  if (config.profile) {
    stats.getTotalBufferSize = function () {
      var total = 0
      // TODO: Right now, the streams are not part of the total count.
      Object.keys(bufferSet).forEach(function (key) {
        total += bufferSet[key].stats.size
      })
      return total
    }
  }

  return {
    create: createBuffer,

    createStream: createStream,
    destroyStream: destroyStream,

    clear: function () {
      values(bufferSet).forEach(destroy)
      streamPool.forEach(destroy)
    },

    getBuffer: function (wrapper) {
      if (wrapper && wrapper._buffer instanceof REGLBuffer) {
        return wrapper._buffer
      }
      return null
    },

    restore: restoreBuffers,

    _initBuffer: initBufferFromData
  }
}

var points = 0;
var point = 0;
var lines = 1;
var line = 1;
var triangles = 4;
var triangle = 4;
var primTypes = {
	points: points,
	point: point,
	lines: lines,
	line: line,
	triangles: triangles,
	triangle: triangle,
	"line loop": 2,
	"line strip": 3,
	"triangle strip": 5,
	"triangle fan": 6
};

var GL_POINTS = 0
var GL_LINES = 1
var GL_TRIANGLES = 4

var GL_BYTE$2 = 5120
var GL_UNSIGNED_BYTE$4 = 5121
var GL_SHORT$2 = 5122
var GL_UNSIGNED_SHORT$2 = 5123
var GL_INT$2 = 5124
var GL_UNSIGNED_INT$2 = 5125

var GL_ELEMENT_ARRAY_BUFFER = 34963

var GL_STREAM_DRAW$1 = 0x88E0
var GL_STATIC_DRAW$1 = 0x88E4

function wrapElementsState (gl, extensions, bufferState, stats) {
  var elementSet = {}
  var elementCount = 0

  var elementTypes = {
    'uint8': GL_UNSIGNED_BYTE$4,
    'uint16': GL_UNSIGNED_SHORT$2
  }

  if (extensions.oes_element_index_uint) {
    elementTypes.uint32 = GL_UNSIGNED_INT$2
  }

  function REGLElementBuffer (buffer) {
    this.id = elementCount++
    elementSet[this.id] = this
    this.buffer = buffer
    this.primType = GL_TRIANGLES
    this.vertCount = 0
    this.type = 0
  }

  REGLElementBuffer.prototype.bind = function () {
    this.buffer.bind()
  }

  var bufferPool = []

  function createElementStream (data) {
    var result = bufferPool.pop()
    if (!result) {
      result = new REGLElementBuffer(bufferState.create(
        null,
        GL_ELEMENT_ARRAY_BUFFER,
        true,
        false)._buffer)
    }
    initElements(result, data, GL_STREAM_DRAW$1, -1, -1, 0, 0)
    return result
  }

  function destroyElementStream (elements) {
    bufferPool.push(elements)
  }

  function initElements (
    elements,
    data,
    usage,
    prim,
    count,
    byteLength,
    type) {
    elements.buffer.bind()
    var dtype
    if (data) {
      var predictedType = type
      if (!type && (
        !isTypedArray(data) ||
         (isNDArrayLike(data) && !isTypedArray(data.data)))) {
        predictedType = extensions.oes_element_index_uint
          ? GL_UNSIGNED_INT$2
          : GL_UNSIGNED_SHORT$2
      }
      bufferState._initBuffer(
        elements.buffer,
        data,
        usage,
        predictedType,
        3)
    } else {
      gl.bufferData(GL_ELEMENT_ARRAY_BUFFER, byteLength, usage)
      elements.buffer.dtype = dtype || GL_UNSIGNED_BYTE$4
      elements.buffer.usage = usage
      elements.buffer.dimension = 3
      elements.buffer.byteLength = byteLength
    }

    dtype = type
    if (!type) {
      switch (elements.buffer.dtype) {
        case GL_UNSIGNED_BYTE$4:
        case GL_BYTE$2:
          dtype = GL_UNSIGNED_BYTE$4
          break

        case GL_UNSIGNED_SHORT$2:
        case GL_SHORT$2:
          dtype = GL_UNSIGNED_SHORT$2
          break

        case GL_UNSIGNED_INT$2:
        case GL_INT$2:
          dtype = GL_UNSIGNED_INT$2
          break

        default:
          check$1.raise('unsupported type for element array')
      }
      elements.buffer.dtype = dtype
    }
    elements.type = dtype

    // Check oes_element_index_uint extension
    check$1(
      dtype !== GL_UNSIGNED_INT$2 ||
      !!extensions.oes_element_index_uint,
      '32 bit element buffers not supported, enable oes_element_index_uint first')

    // try to guess default primitive type and arguments
    var vertCount = count
    if (vertCount < 0) {
      vertCount = elements.buffer.byteLength
      if (dtype === GL_UNSIGNED_SHORT$2) {
        vertCount >>= 1
      } else if (dtype === GL_UNSIGNED_INT$2) {
        vertCount >>= 2
      }
    }
    elements.vertCount = vertCount

    // try to guess primitive type from cell dimension
    var primType = prim
    if (prim < 0) {
      primType = GL_TRIANGLES
      var dimension = elements.buffer.dimension
      if (dimension === 1) primType = GL_POINTS
      if (dimension === 2) primType = GL_LINES
      if (dimension === 3) primType = GL_TRIANGLES
    }
    elements.primType = primType
  }

  function destroyElements (elements) {
    stats.elementsCount--

    check$1(elements.buffer !== null, 'must not double destroy elements')
    delete elementSet[elements.id]
    elements.buffer.destroy()
    elements.buffer = null
  }

  function createElements (options, persistent) {
    var buffer = bufferState.create(null, GL_ELEMENT_ARRAY_BUFFER, true)
    var elements = new REGLElementBuffer(buffer._buffer)
    stats.elementsCount++

    function reglElements (options) {
      if (!options) {
        buffer()
        elements.primType = GL_TRIANGLES
        elements.vertCount = 0
        elements.type = GL_UNSIGNED_BYTE$4
      } else if (typeof options === 'number') {
        buffer(options)
        elements.primType = GL_TRIANGLES
        elements.vertCount = options | 0
        elements.type = GL_UNSIGNED_BYTE$4
      } else {
        var data = null
        var usage = GL_STATIC_DRAW$1
        var primType = -1
        var vertCount = -1
        var byteLength = 0
        var dtype = 0
        if (Array.isArray(options) ||
            isTypedArray(options) ||
            isNDArrayLike(options)) {
          data = options
        } else {
          check$1.type(options, 'object', 'invalid arguments for elements')
          if ('data' in options) {
            data = options.data
            check$1(
              Array.isArray(data) ||
                isTypedArray(data) ||
                isNDArrayLike(data),
              'invalid data for element buffer')
          }
          if ('usage' in options) {
            check$1.parameter(
              options.usage,
              usageTypes,
              'invalid element buffer usage')
            usage = usageTypes[options.usage]
          }
          if ('primitive' in options) {
            check$1.parameter(
              options.primitive,
              primTypes,
              'invalid element buffer primitive')
            primType = primTypes[options.primitive]
          }
          if ('count' in options) {
            check$1(
              typeof options.count === 'number' && options.count >= 0,
              'invalid vertex count for elements')
            vertCount = options.count | 0
          }
          if ('type' in options) {
            check$1.parameter(
              options.type,
              elementTypes,
              'invalid buffer type')
            dtype = elementTypes[options.type]
          }
          if ('length' in options) {
            byteLength = options.length | 0
          } else {
            byteLength = vertCount
            if (dtype === GL_UNSIGNED_SHORT$2 || dtype === GL_SHORT$2) {
              byteLength *= 2
            } else if (dtype === GL_UNSIGNED_INT$2 || dtype === GL_INT$2) {
              byteLength *= 4
            }
          }
        }
        initElements(
          elements,
          data,
          usage,
          primType,
          vertCount,
          byteLength,
          dtype)
      }

      return reglElements
    }

    reglElements(options)

    reglElements._reglType = 'elements'
    reglElements._elements = elements
    reglElements.subdata = function (data, offset) {
      buffer.subdata(data, offset)
      return reglElements
    }
    reglElements.destroy = function () {
      destroyElements(elements)
    }

    return reglElements
  }

  return {
    create: createElements,
    createStream: createElementStream,
    destroyStream: destroyElementStream,
    getElements: function (elements) {
      if (typeof elements === 'function' &&
          elements._elements instanceof REGLElementBuffer) {
        return elements._elements
      }
      return null
    },
    clear: function () {
      values(elementSet).forEach(destroyElements)
    }
  }
}

var FLOAT = new Float32Array(1)
var INT = new Uint32Array(FLOAT.buffer)

var GL_UNSIGNED_SHORT$4 = 5123

function convertToHalfFloat (array) {
  var ushorts = pool.allocType(GL_UNSIGNED_SHORT$4, array.length)

  for (var i = 0; i < array.length; ++i) {
    if (isNaN(array[i])) {
      ushorts[i] = 0xffff
    } else if (array[i] === Infinity) {
      ushorts[i] = 0x7c00
    } else if (array[i] === -Infinity) {
      ushorts[i] = 0xfc00
    } else {
      FLOAT[0] = array[i]
      var x = INT[0]

      var sgn = (x >>> 31) << 15
      var exp = ((x << 1) >>> 24) - 127
      var frac = (x >> 13) & ((1 << 10) - 1)

      if (exp < -24) {
        // round non-representable denormals to 0
        ushorts[i] = sgn
      } else if (exp < -14) {
        // handle denormals
        var s = -14 - exp
        ushorts[i] = sgn + ((frac + (1 << 10)) >> s)
      } else if (exp > 15) {
        // round overflow to +/- Infinity
        ushorts[i] = sgn + 0x7c00
      } else {
        // otherwise convert directly
        ushorts[i] = sgn + ((exp + 15) << 10) + frac
      }
    }
  }

  return ushorts
}

function isArrayLike (s) {
  return Array.isArray(s) || isTypedArray(s)
}

var isPow2$1 = function (v) {
  return !(v & (v - 1)) && (!!v)
}

var GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3

var GL_TEXTURE_2D$1 = 0x0DE1
var GL_TEXTURE_CUBE_MAP$1 = 0x8513
var GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 = 0x8515

var GL_RGBA$1 = 0x1908
var GL_ALPHA = 0x1906
var GL_RGB = 0x1907
var GL_LUMINANCE = 0x1909
var GL_LUMINANCE_ALPHA = 0x190A

var GL_RGBA4 = 0x8056
var GL_RGB5_A1 = 0x8057
var GL_RGB565 = 0x8D62

var GL_UNSIGNED_SHORT_4_4_4_4$1 = 0x8033
var GL_UNSIGNED_SHORT_5_5_5_1$1 = 0x8034
var GL_UNSIGNED_SHORT_5_6_5$1 = 0x8363
var GL_UNSIGNED_INT_24_8_WEBGL$1 = 0x84FA

var GL_DEPTH_COMPONENT = 0x1902
var GL_DEPTH_STENCIL = 0x84F9

var GL_SRGB_EXT = 0x8C40
var GL_SRGB_ALPHA_EXT = 0x8C42

var GL_HALF_FLOAT_OES$1 = 0x8D61

var GL_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0
var GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1
var GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2
var GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3

var GL_COMPRESSED_RGB_ATC_WEBGL = 0x8C92
var GL_COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL = 0x8C93
var GL_COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL = 0x87EE

var GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 0x8C00
var GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 0x8C01
var GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 0x8C02
var GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 0x8C03

var GL_COMPRESSED_RGB_ETC1_WEBGL = 0x8D64

var GL_UNSIGNED_BYTE$5 = 0x1401
var GL_UNSIGNED_SHORT$3 = 0x1403
var GL_UNSIGNED_INT$3 = 0x1405
var GL_FLOAT$4 = 0x1406

var GL_TEXTURE_WRAP_S = 0x2802
var GL_TEXTURE_WRAP_T = 0x2803

var GL_REPEAT = 0x2901
var GL_CLAMP_TO_EDGE$1 = 0x812F
var GL_MIRRORED_REPEAT = 0x8370

var GL_TEXTURE_MAG_FILTER = 0x2800
var GL_TEXTURE_MIN_FILTER = 0x2801

var GL_NEAREST$1 = 0x2600
var GL_LINEAR = 0x2601
var GL_NEAREST_MIPMAP_NEAREST$1 = 0x2700
var GL_LINEAR_MIPMAP_NEAREST$1 = 0x2701
var GL_NEAREST_MIPMAP_LINEAR$1 = 0x2702
var GL_LINEAR_MIPMAP_LINEAR$1 = 0x2703

var GL_GENERATE_MIPMAP_HINT = 0x8192
var GL_DONT_CARE = 0x1100
var GL_FASTEST = 0x1101
var GL_NICEST = 0x1102

var GL_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE

var GL_UNPACK_ALIGNMENT = 0x0CF5
var GL_UNPACK_FLIP_Y_WEBGL = 0x9240
var GL_UNPACK_PREMULTIPLY_ALPHA_WEBGL = 0x9241
var GL_UNPACK_COLORSPACE_CONVERSION_WEBGL = 0x9243

var GL_BROWSER_DEFAULT_WEBGL = 0x9244

var GL_TEXTURE0$1 = 0x84C0

var MIPMAP_FILTERS = [
  GL_NEAREST_MIPMAP_NEAREST$1,
  GL_NEAREST_MIPMAP_LINEAR$1,
  GL_LINEAR_MIPMAP_NEAREST$1,
  GL_LINEAR_MIPMAP_LINEAR$1
]

var CHANNELS_FORMAT = [
  0,
  GL_LUMINANCE,
  GL_LUMINANCE_ALPHA,
  GL_RGB,
  GL_RGBA$1
]

var FORMAT_CHANNELS = {}
FORMAT_CHANNELS[GL_LUMINANCE] =
FORMAT_CHANNELS[GL_ALPHA] =
FORMAT_CHANNELS[GL_DEPTH_COMPONENT] = 1
FORMAT_CHANNELS[GL_DEPTH_STENCIL] =
FORMAT_CHANNELS[GL_LUMINANCE_ALPHA] = 2
FORMAT_CHANNELS[GL_RGB] =
FORMAT_CHANNELS[GL_SRGB_EXT] = 3
FORMAT_CHANNELS[GL_RGBA$1] =
FORMAT_CHANNELS[GL_SRGB_ALPHA_EXT] = 4

function objectName (str) {
  return '[object ' + str + ']'
}

var CANVAS_CLASS = objectName('HTMLCanvasElement')
var OFFSCREENCANVAS_CLASS = objectName('OffscreenCanvas')
var CONTEXT2D_CLASS = objectName('CanvasRenderingContext2D')
var BITMAP_CLASS = objectName('ImageBitmap')
var IMAGE_CLASS = objectName('HTMLImageElement')
var VIDEO_CLASS = objectName('HTMLVideoElement')

var PIXEL_CLASSES = Object.keys(arrayTypes).concat([
  CANVAS_CLASS,
  OFFSCREENCANVAS_CLASS,
  CONTEXT2D_CLASS,
  BITMAP_CLASS,
  IMAGE_CLASS,
  VIDEO_CLASS
])

// for every texture type, store
// the size in bytes.
var TYPE_SIZES = []
TYPE_SIZES[GL_UNSIGNED_BYTE$5] = 1
TYPE_SIZES[GL_FLOAT$4] = 4
TYPE_SIZES[GL_HALF_FLOAT_OES$1] = 2

TYPE_SIZES[GL_UNSIGNED_SHORT$3] = 2
TYPE_SIZES[GL_UNSIGNED_INT$3] = 4

var FORMAT_SIZES_SPECIAL = []
FORMAT_SIZES_SPECIAL[GL_RGBA4] = 2
FORMAT_SIZES_SPECIAL[GL_RGB5_A1] = 2
FORMAT_SIZES_SPECIAL[GL_RGB565] = 2
FORMAT_SIZES_SPECIAL[GL_DEPTH_STENCIL] = 4

FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_S3TC_DXT1_EXT] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_S3TC_DXT1_EXT] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_S3TC_DXT3_EXT] = 1
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_S3TC_DXT5_EXT] = 1

FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_ATC_WEBGL] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL] = 1
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL] = 1

FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG] = 0.25
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG] = 0.5
FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG] = 0.25

FORMAT_SIZES_SPECIAL[GL_COMPRESSED_RGB_ETC1_WEBGL] = 0.5

function isNumericArray (arr) {
  return (
    Array.isArray(arr) &&
    (arr.length === 0 ||
    typeof arr[0] === 'number'))
}

function isRectArray (arr) {
  if (!Array.isArray(arr)) {
    return false
  }
  var width = arr.length
  if (width === 0 || !isArrayLike(arr[0])) {
    return false
  }
  return true
}

function classString (x) {
  return Object.prototype.toString.call(x)
}

function isCanvasElement (object) {
  return classString(object) === CANVAS_CLASS
}

function isOffscreenCanvas (object) {
  return classString(object) === OFFSCREENCANVAS_CLASS
}

function isContext2D (object) {
  return classString(object) === CONTEXT2D_CLASS
}

function isBitmap (object) {
  return classString(object) === BITMAP_CLASS
}

function isImageElement (object) {
  return classString(object) === IMAGE_CLASS
}

function isVideoElement (object) {
  return classString(object) === VIDEO_CLASS
}

function isPixelData (object) {
  if (!object) {
    return false
  }
  var className = classString(object)
  if (PIXEL_CLASSES.indexOf(className) >= 0) {
    return true
  }
  return (
    isNumericArray(object) ||
    isRectArray(object) ||
    isNDArrayLike(object))
}

function typedArrayCode$1 (data) {
  return arrayTypes[Object.prototype.toString.call(data)] | 0
}

function convertData (result, data) {
  var n = data.length
  switch (result.type) {
    case GL_UNSIGNED_BYTE$5:
    case GL_UNSIGNED_SHORT$3:
    case GL_UNSIGNED_INT$3:
    case GL_FLOAT$4:
      var converted = pool.allocType(result.type, n)
      converted.set(data)
      result.data = converted
      break

    case GL_HALF_FLOAT_OES$1:
      result.data = convertToHalfFloat(data)
      break

    default:
      check$1.raise('unsupported texture type, must specify a typed array')
  }
}

function preConvert (image, n) {
  return pool.allocType(
    image.type === GL_HALF_FLOAT_OES$1
      ? GL_FLOAT$4
      : image.type, n)
}

function postConvert (image, data) {
  if (image.type === GL_HALF_FLOAT_OES$1) {
    image.data = convertToHalfFloat(data)
    pool.freeType(data)
  } else {
    image.data = data
  }
}

function transposeData (image, array, strideX, strideY, strideC, offset) {
  var w = image.width
  var h = image.height
  var c = image.channels
  var n = w * h * c
  var data = preConvert(image, n)

  var p = 0
  for (var i = 0; i < h; ++i) {
    for (var j = 0; j < w; ++j) {
      for (var k = 0; k < c; ++k) {
        data[p++] = array[strideX * j + strideY * i + strideC * k + offset]
      }
    }
  }

  postConvert(image, data)
}

function getTextureSize (format, type, width, height, isMipmap, isCube) {
  var s
  if (typeof FORMAT_SIZES_SPECIAL[format] !== 'undefined') {
    // we have a special array for dealing with weird color formats such as RGB5A1
    s = FORMAT_SIZES_SPECIAL[format]
  } else {
    s = FORMAT_CHANNELS[format] * TYPE_SIZES[type]
  }

  if (isCube) {
    s *= 6
  }

  if (isMipmap) {
    // compute the total size of all the mipmaps.
    var total = 0

    var w = width
    while (w >= 1) {
      // we can only use mipmaps on a square image,
      // so we can simply use the width and ignore the height:
      total += s * w * w
      w /= 2
    }
    return total
  } else {
    return s * width * height
  }
}

function createTextureSet (
  gl, extensions, limits, reglPoll, contextState, stats, config) {
  // -------------------------------------------------------
  // Initialize constants and parameter tables here
  // -------------------------------------------------------
  var mipmapHint = {
    "don't care": GL_DONT_CARE,
    'dont care': GL_DONT_CARE,
    'nice': GL_NICEST,
    'fast': GL_FASTEST
  }

  var wrapModes = {
    'repeat': GL_REPEAT,
    'clamp': GL_CLAMP_TO_EDGE$1,
    'mirror': GL_MIRRORED_REPEAT
  }

  var magFilters = {
    'nearest': GL_NEAREST$1,
    'linear': GL_LINEAR
  }

  var minFilters = extend({
    'mipmap': GL_LINEAR_MIPMAP_LINEAR$1,
    'nearest mipmap nearest': GL_NEAREST_MIPMAP_NEAREST$1,
    'linear mipmap nearest': GL_LINEAR_MIPMAP_NEAREST$1,
    'nearest mipmap linear': GL_NEAREST_MIPMAP_LINEAR$1,
    'linear mipmap linear': GL_LINEAR_MIPMAP_LINEAR$1
  }, magFilters)

  var colorSpace = {
    'none': 0,
    'browser': GL_BROWSER_DEFAULT_WEBGL
  }

  var textureTypes = {
    'uint8': GL_UNSIGNED_BYTE$5,
    'rgba4': GL_UNSIGNED_SHORT_4_4_4_4$1,
    'rgb565': GL_UNSIGNED_SHORT_5_6_5$1,
    'rgb5 a1': GL_UNSIGNED_SHORT_5_5_5_1$1
  }

  var textureFormats = {
    'alpha': GL_ALPHA,
    'luminance': GL_LUMINANCE,
    'luminance alpha': GL_LUMINANCE_ALPHA,
    'rgb': GL_RGB,
    'rgba': GL_RGBA$1,
    'rgba4': GL_RGBA4,
    'rgb5 a1': GL_RGB5_A1,
    'rgb565': GL_RGB565
  }

  var compressedTextureFormats = {}

  if (extensions.ext_srgb) {
    textureFormats.srgb = GL_SRGB_EXT
    textureFormats.srgba = GL_SRGB_ALPHA_EXT
  }

  if (extensions.oes_texture_float) {
    textureTypes.float32 = textureTypes.float = GL_FLOAT$4
  }

  if (extensions.oes_texture_half_float) {
    textureTypes['float16'] = textureTypes['half float'] = GL_HALF_FLOAT_OES$1
  }

  if (extensions.webgl_depth_texture) {
    extend(textureFormats, {
      'depth': GL_DEPTH_COMPONENT,
      'depth stencil': GL_DEPTH_STENCIL
    })

    extend(textureTypes, {
      'uint16': GL_UNSIGNED_SHORT$3,
      'uint32': GL_UNSIGNED_INT$3,
      'depth stencil': GL_UNSIGNED_INT_24_8_WEBGL$1
    })
  }

  if (extensions.webgl_compressed_texture_s3tc) {
    extend(compressedTextureFormats, {
      'rgb s3tc dxt1': GL_COMPRESSED_RGB_S3TC_DXT1_EXT,
      'rgba s3tc dxt1': GL_COMPRESSED_RGBA_S3TC_DXT1_EXT,
      'rgba s3tc dxt3': GL_COMPRESSED_RGBA_S3TC_DXT3_EXT,
      'rgba s3tc dxt5': GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
    })
  }

  if (extensions.webgl_compressed_texture_atc) {
    extend(compressedTextureFormats, {
      'rgb atc': GL_COMPRESSED_RGB_ATC_WEBGL,
      'rgba atc explicit alpha': GL_COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL,
      'rgba atc interpolated alpha': GL_COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL
    })
  }

  if (extensions.webgl_compressed_texture_pvrtc) {
    extend(compressedTextureFormats, {
      'rgb pvrtc 4bppv1': GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG,
      'rgb pvrtc 2bppv1': GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG,
      'rgba pvrtc 4bppv1': GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,
      'rgba pvrtc 2bppv1': GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG
    })
  }

  if (extensions.webgl_compressed_texture_etc1) {
    compressedTextureFormats['rgb etc1'] = GL_COMPRESSED_RGB_ETC1_WEBGL
  }

  // Copy over all texture formats
  var supportedCompressedFormats = Array.prototype.slice.call(
    gl.getParameter(GL_COMPRESSED_TEXTURE_FORMATS))
  Object.keys(compressedTextureFormats).forEach(function (name) {
    var format = compressedTextureFormats[name]
    if (supportedCompressedFormats.indexOf(format) >= 0) {
      textureFormats[name] = format
    }
  })

  var supportedFormats = Object.keys(textureFormats)
  limits.textureFormats = supportedFormats

  // associate with every format string its
  // corresponding GL-value.
  var textureFormatsInvert = []
  Object.keys(textureFormats).forEach(function (key) {
    var val = textureFormats[key]
    textureFormatsInvert[val] = key
  })

  // associate with every type string its
  // corresponding GL-value.
  var textureTypesInvert = []
  Object.keys(textureTypes).forEach(function (key) {
    var val = textureTypes[key]
    textureTypesInvert[val] = key
  })

  var magFiltersInvert = []
  Object.keys(magFilters).forEach(function (key) {
    var val = magFilters[key]
    magFiltersInvert[val] = key
  })

  var minFiltersInvert = []
  Object.keys(minFilters).forEach(function (key) {
    var val = minFilters[key]
    minFiltersInvert[val] = key
  })

  var wrapModesInvert = []
  Object.keys(wrapModes).forEach(function (key) {
    var val = wrapModes[key]
    wrapModesInvert[val] = key
  })

  // colorFormats[] gives the format (channels) associated to an
  // internalformat
  var colorFormats = supportedFormats.reduce(function (color, key) {
    var glenum = textureFormats[key]
    if (glenum === GL_LUMINANCE ||
        glenum === GL_ALPHA ||
        glenum === GL_LUMINANCE ||
        glenum === GL_LUMINANCE_ALPHA ||
        glenum === GL_DEPTH_COMPONENT ||
        glenum === GL_DEPTH_STENCIL ||
        (extensions.ext_srgb &&
                (glenum === GL_SRGB_EXT ||
                 glenum === GL_SRGB_ALPHA_EXT))) {
      color[glenum] = glenum
    } else if (glenum === GL_RGB5_A1 || key.indexOf('rgba') >= 0) {
      color[glenum] = GL_RGBA$1
    } else {
      color[glenum] = GL_RGB
    }
    return color
  }, {})

  function TexFlags () {
    // format info
    this.internalformat = GL_RGBA$1
    this.format = GL_RGBA$1
    this.type = GL_UNSIGNED_BYTE$5
    this.compressed = false

    // pixel storage
    this.premultiplyAlpha = false
    this.flipY = false
    this.unpackAlignment = 1
    this.colorSpace = GL_BROWSER_DEFAULT_WEBGL

    // shape info
    this.width = 0
    this.height = 0
    this.channels = 0
  }

  function copyFlags (result, other) {
    result.internalformat = other.internalformat
    result.format = other.format
    result.type = other.type
    result.compressed = other.compressed

    result.premultiplyAlpha = other.premultiplyAlpha
    result.flipY = other.flipY
    result.unpackAlignment = other.unpackAlignment
    result.colorSpace = other.colorSpace

    result.width = other.width
    result.height = other.height
    result.channels = other.channels
  }

  function parseFlags (flags, options) {
    if (typeof options !== 'object' || !options) {
      return
    }

    if ('premultiplyAlpha' in options) {
      check$1.type(options.premultiplyAlpha, 'boolean',
        'invalid premultiplyAlpha')
      flags.premultiplyAlpha = options.premultiplyAlpha
    }

    if ('flipY' in options) {
      check$1.type(options.flipY, 'boolean',
        'invalid texture flip')
      flags.flipY = options.flipY
    }

    if ('alignment' in options) {
      check$1.oneOf(options.alignment, [1, 2, 4, 8],
        'invalid texture unpack alignment')
      flags.unpackAlignment = options.alignment
    }

    if ('colorSpace' in options) {
      check$1.parameter(options.colorSpace, colorSpace,
        'invalid colorSpace')
      flags.colorSpace = colorSpace[options.colorSpace]
    }

    if ('type' in options) {
      var type = options.type
      check$1(extensions.oes_texture_float ||
        !(type === 'float' || type === 'float32'),
      'you must enable the OES_texture_float extension in order to use floating point textures.')
      check$1(extensions.oes_texture_half_float ||
        !(type === 'half float' || type === 'float16'),
      'you must enable the OES_texture_half_float extension in order to use 16-bit floating point textures.')
      check$1(extensions.webgl_depth_texture ||
        !(type === 'uint16' || type === 'uint32' || type === 'depth stencil'),
      'you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures.')
      check$1.parameter(type, textureTypes,
        'invalid texture type')
      flags.type = textureTypes[type]
    }

    var w = flags.width
    var h = flags.height
    var c = flags.channels
    var hasChannels = false
    if ('shape' in options) {
      check$1(Array.isArray(options.shape) && options.shape.length >= 2,
        'shape must be an array')
      w = options.shape[0]
      h = options.shape[1]
      if (options.shape.length === 3) {
        c = options.shape[2]
        check$1(c > 0 && c <= 4, 'invalid number of channels')
        hasChannels = true
      }
      check$1(w >= 0 && w <= limits.maxTextureSize, 'invalid width')
      check$1(h >= 0 && h <= limits.maxTextureSize, 'invalid height')
    } else {
      if ('radius' in options) {
        w = h = options.radius
        check$1(w >= 0 && w <= limits.maxTextureSize, 'invalid radius')
      }
      if ('width' in options) {
        w = options.width
        check$1(w >= 0 && w <= limits.maxTextureSize, 'invalid width')
      }
      if ('height' in options) {
        h = options.height
        check$1(h >= 0 && h <= limits.maxTextureSize, 'invalid height')
      }
      if ('channels' in options) {
        c = options.channels
        check$1(c > 0 && c <= 4, 'invalid number of channels')
        hasChannels = true
      }
    }
    flags.width = w | 0
    flags.height = h | 0
    flags.channels = c | 0

    var hasFormat = false
    if ('format' in options) {
      var formatStr = options.format
      check$1(extensions.webgl_depth_texture ||
        !(formatStr === 'depth' || formatStr === 'depth stencil'),
      'you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures.')
      check$1.parameter(formatStr, textureFormats,
        'invalid texture format')
      var internalformat = flags.internalformat = textureFormats[formatStr]
      flags.format = colorFormats[internalformat]
      if (formatStr in textureTypes) {
        if (!('type' in options)) {
          flags.type = textureTypes[formatStr]
        }
      }
      if (formatStr in compressedTextureFormats) {
        flags.compressed = true
      }
      hasFormat = true
    }

    // Reconcile channels and format
    if (!hasChannels && hasFormat) {
      flags.channels = FORMAT_CHANNELS[flags.format]
    } else if (hasChannels && !hasFormat) {
      if (flags.channels !== CHANNELS_FORMAT[flags.format]) {
        flags.format = flags.internalformat = CHANNELS_FORMAT[flags.channels]
      }
    } else if (hasFormat && hasChannels) {
      check$1(
        flags.channels === FORMAT_CHANNELS[flags.format],
        'number of channels inconsistent with specified format')
    }
  }

  function setFlags (flags) {
    gl.pixelStorei(GL_UNPACK_FLIP_Y_WEBGL, flags.flipY)
    gl.pixelStorei(GL_UNPACK_PREMULTIPLY_ALPHA_WEBGL, flags.premultiplyAlpha)
    gl.pixelStorei(GL_UNPACK_COLORSPACE_CONVERSION_WEBGL, flags.colorSpace)
    gl.pixelStorei(GL_UNPACK_ALIGNMENT, flags.unpackAlignment)
  }

  // -------------------------------------------------------
  // Tex image data
  // -------------------------------------------------------
  function TexImage () {
    TexFlags.call(this)

    this.xOffset = 0
    this.yOffset = 0

    // data
    this.data = null
    this.needsFree = false

    // html element
    this.element = null

    // copyTexImage info
    this.needsCopy = false
  }

  function parseImage (image, options) {
    var data = null
    if (isPixelData(options)) {
      data = options
    } else if (options) {
      check$1.type(options, 'object', 'invalid pixel data type')
      parseFlags(image, options)
      if ('x' in options) {
        image.xOffset = options.x | 0
      }
      if ('y' in options) {
        image.yOffset = options.y | 0
      }
      if (isPixelData(options.data)) {
        data = options.data
      }
    }

    check$1(
      !image.compressed ||
      data instanceof Uint8Array,
      'compressed texture data must be stored in a uint8array')

    if (options.copy) {
      check$1(!data, 'can not specify copy and data field for the same texture')
      var viewW = contextState.viewportWidth
      var viewH = contextState.viewportHeight
      image.width = image.width || (viewW - image.xOffset)
      image.height = image.height || (viewH - image.yOffset)
      image.needsCopy = true
      check$1(image.xOffset >= 0 && image.xOffset < viewW &&
            image.yOffset >= 0 && image.yOffset < viewH &&
            image.width > 0 && image.width <= viewW &&
            image.height > 0 && image.height <= viewH,
      'copy texture read out of bounds')
    } else if (!data) {
      image.width = image.width || 1
      image.height = image.height || 1
      image.channels = image.channels || 4
    } else if (isTypedArray(data)) {
      image.channels = image.channels || 4
      image.data = data
      if (!('type' in options) && image.type === GL_UNSIGNED_BYTE$5) {
        image.type = typedArrayCode$1(data)
      }
    } else if (isNumericArray(data)) {
      image.channels = image.channels || 4
      convertData(image, data)
      image.alignment = 1
      image.needsFree = true
    } else if (isNDArrayLike(data)) {
      var array = data.data
      if (!Array.isArray(array) && image.type === GL_UNSIGNED_BYTE$5) {
        image.type = typedArrayCode$1(array)
      }
      var shape = data.shape
      var stride = data.stride
      var shapeX, shapeY, shapeC, strideX, strideY, strideC
      if (shape.length === 3) {
        shapeC = shape[2]
        strideC = stride[2]
      } else {
        check$1(shape.length === 2, 'invalid ndarray pixel data, must be 2 or 3D')
        shapeC = 1
        strideC = 1
      }
      shapeX = shape[0]
      shapeY = shape[1]
      strideX = stride[0]
      strideY = stride[1]
      image.alignment = 1
      image.width = shapeX
      image.height = shapeY
      image.channels = shapeC
      image.format = image.internalformat = CHANNELS_FORMAT[shapeC]
      image.needsFree = true
      transposeData(image, array, strideX, strideY, strideC, data.offset)
    } else if (isCanvasElement(data) || isOffscreenCanvas(data) || isContext2D(data)) {
      if (isCanvasElement(data) || isOffscreenCanvas(data)) {
        image.element = data
      } else {
        image.element = data.canvas
      }
      image.width = image.element.width
      image.height = image.element.height
      image.channels = 4
    } else if (isBitmap(data)) {
      image.element = data
      image.width = data.width
      image.height = data.height
      image.channels = 4
    } else if (isImageElement(data)) {
      image.element = data
      image.width = data.naturalWidth
      image.height = data.naturalHeight
      image.channels = 4
    } else if (isVideoElement(data)) {
      image.element = data
      image.width = data.videoWidth
      image.height = data.videoHeight
      image.channels = 4
    } else if (isRectArray(data)) {
      var w = image.width || data[0].length
      var h = image.height || data.length
      var c = image.channels
      if (isArrayLike(data[0][0])) {
        c = c || data[0][0].length
      } else {
        c = c || 1
      }
      var arrayShape = flattenUtils.shape(data)
      var n = 1
      for (var dd = 0; dd < arrayShape.length; ++dd) {
        n *= arrayShape[dd]
      }
      var allocData = preConvert(image, n)
      flattenUtils.flatten(data, arrayShape, '', allocData)
      postConvert(image, allocData)
      image.alignment = 1
      image.width = w
      image.height = h
      image.channels = c
      image.format = image.internalformat = CHANNELS_FORMAT[c]
      image.needsFree = true
    }

    if (image.type === GL_FLOAT$4) {
      check$1(limits.extensions.indexOf('oes_texture_float') >= 0,
        'oes_texture_float extension not enabled')
    } else if (image.type === GL_HALF_FLOAT_OES$1) {
      check$1(limits.extensions.indexOf('oes_texture_half_float') >= 0,
        'oes_texture_half_float extension not enabled')
    }

    // do compressed texture  validation here.
  }

  function setImage (info, target, miplevel) {
    var element = info.element
    var data = info.data
    var internalformat = info.internalformat
    var format = info.format
    var type = info.type
    var width = info.width
    var height = info.height

    setFlags(info)

    if (element) {
      gl.texImage2D(target, miplevel, format, format, type, element)
    } else if (info.compressed) {
      gl.compressedTexImage2D(target, miplevel, internalformat, width, height, 0, data)
    } else if (info.needsCopy) {
      reglPoll()
      gl.copyTexImage2D(
        target, miplevel, format, info.xOffset, info.yOffset, width, height, 0)
    } else {
      gl.texImage2D(target, miplevel, format, width, height, 0, format, type, data || null)
    }
  }

  function setSubImage (info, target, x, y, miplevel) {
    var element = info.element
    var data = info.data
    var internalformat = info.internalformat
    var format = info.format
    var type = info.type
    var width = info.width
    var height = info.height

    setFlags(info)

    if (element) {
      gl.texSubImage2D(
        target, miplevel, x, y, format, type, element)
    } else if (info.compressed) {
      gl.compressedTexSubImage2D(
        target, miplevel, x, y, internalformat, width, height, data)
    } else if (info.needsCopy) {
      reglPoll()
      gl.copyTexSubImage2D(
        target, miplevel, x, y, info.xOffset, info.yOffset, width, height)
    } else {
      gl.texSubImage2D(
        target, miplevel, x, y, width, height, format, type, data)
    }
  }

  // texImage pool
  var imagePool = []

  function allocImage () {
    return imagePool.pop() || new TexImage()
  }

  function freeImage (image) {
    if (image.needsFree) {
      pool.freeType(image.data)
    }
    TexImage.call(image)
    imagePool.push(image)
  }

  // -------------------------------------------------------
  // Mip map
  // -------------------------------------------------------
  function MipMap () {
    TexFlags.call(this)

    this.genMipmaps = false
    this.mipmapHint = GL_DONT_CARE
    this.mipmask = 0
    this.images = Array(16)
  }

  function parseMipMapFromShape (mipmap, width, height) {
    var img = mipmap.images[0] = allocImage()
    mipmap.mipmask = 1
    img.width = mipmap.width = width
    img.height = mipmap.height = height
    img.channels = mipmap.channels = 4
  }

  function parseMipMapFromObject (mipmap, options) {
    var imgData = null
    if (isPixelData(options)) {
      imgData = mipmap.images[0] = allocImage()
      copyFlags(imgData, mipmap)
      parseImage(imgData, options)
      mipmap.mipmask = 1
    } else {
      parseFlags(mipmap, options)
      if (Array.isArray(options.mipmap)) {
        var mipData = options.mipmap
        for (var i = 0; i < mipData.length; ++i) {
          imgData = mipmap.images[i] = allocImage()
          copyFlags(imgData, mipmap)
          imgData.width >>= i
          imgData.height >>= i
          parseImage(imgData, mipData[i])
          mipmap.mipmask |= (1 << i)
        }
      } else {
        imgData = mipmap.images[0] = allocImage()
        copyFlags(imgData, mipmap)
        parseImage(imgData, options)
        mipmap.mipmask = 1
      }
    }
    copyFlags(mipmap, mipmap.images[0])

    // For textures of the compressed format WEBGL_compressed_texture_s3tc
    // we must have that
    //
    // "When level equals zero width and height must be a multiple of 4.
    // When level is greater than 0 width and height must be 0, 1, 2 or a multiple of 4. "
    //
    // but we do not yet support having multiple mipmap levels for compressed textures,
    // so we only test for level zero.

    if (
      mipmap.compressed &&
      (
        mipmap.internalformat === GL_COMPRESSED_RGB_S3TC_DXT1_EXT ||
        mipmap.internalformat === GL_COMPRESSED_RGBA_S3TC_DXT1_EXT ||
        mipmap.internalformat === GL_COMPRESSED_RGBA_S3TC_DXT3_EXT ||
        mipmap.internalformat === GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
      )
    ) {
      check$1(mipmap.width % 4 === 0 && mipmap.height % 4 === 0,
        'for compressed texture formats, mipmap level 0 must have width and height that are a multiple of 4')
    }
  }

  function setMipMap (mipmap, target) {
    var images = mipmap.images
    for (var i = 0; i < images.length; ++i) {
      if (!images[i]) {
        return
      }
      setImage(images[i], target, i)
    }
  }

  var mipPool = []

  function allocMipMap () {
    var result = mipPool.pop() || new MipMap()
    TexFlags.call(result)
    result.mipmask = 0
    for (var i = 0; i < 16; ++i) {
      result.images[i] = null
    }
    return result
  }

  function freeMipMap (mipmap) {
    var images = mipmap.images
    for (var i = 0; i < images.length; ++i) {
      if (images[i]) {
        freeImage(images[i])
      }
      images[i] = null
    }
    mipPool.push(mipmap)
  }

  // -------------------------------------------------------
  // Tex info
  // -------------------------------------------------------
  function TexInfo () {
    this.minFilter = GL_NEAREST$1
    this.magFilter = GL_NEAREST$1

    this.wrapS = GL_CLAMP_TO_EDGE$1
    this.wrapT = GL_CLAMP_TO_EDGE$1

    this.anisotropic = 1

    this.genMipmaps = false
    this.mipmapHint = GL_DONT_CARE
  }

  function parseTexInfo (info, options) {
    if ('min' in options) {
      var minFilter = options.min
      check$1.parameter(minFilter, minFilters)
      info.minFilter = minFilters[minFilter]
      if (MIPMAP_FILTERS.indexOf(info.minFilter) >= 0 && !('faces' in options)) {
        info.genMipmaps = true
      }
    }

    if ('mag' in options) {
      var magFilter = options.mag
      check$1.parameter(magFilter, magFilters)
      info.magFilter = magFilters[magFilter]
    }

    var wrapS = info.wrapS
    var wrapT = info.wrapT
    if ('wrap' in options) {
      var wrap = options.wrap
      if (typeof wrap === 'string') {
        check$1.parameter(wrap, wrapModes)
        wrapS = wrapT = wrapModes[wrap]
      } else if (Array.isArray(wrap)) {
        check$1.parameter(wrap[0], wrapModes)
        check$1.parameter(wrap[1], wrapModes)
        wrapS = wrapModes[wrap[0]]
        wrapT = wrapModes[wrap[1]]
      }
    } else {
      if ('wrapS' in options) {
        var optWrapS = options.wrapS
        check$1.parameter(optWrapS, wrapModes)
        wrapS = wrapModes[optWrapS]
      }
      if ('wrapT' in options) {
        var optWrapT = options.wrapT
        check$1.parameter(optWrapT, wrapModes)
        wrapT = wrapModes[optWrapT]
      }
    }
    info.wrapS = wrapS
    info.wrapT = wrapT

    if ('anisotropic' in options) {
      var anisotropic = options.anisotropic
      check$1(typeof anisotropic === 'number' &&
         anisotropic >= 1 && anisotropic <= limits.maxAnisotropic,
      'aniso samples must be between 1 and ')
      info.anisotropic = options.anisotropic
    }

    if ('mipmap' in options) {
      var hasMipMap = false
      switch (typeof options.mipmap) {
        case 'string':
          check$1.parameter(options.mipmap, mipmapHint,
            'invalid mipmap hint')
          info.mipmapHint = mipmapHint[options.mipmap]
          info.genMipmaps = true
          hasMipMap = true
          break

        case 'boolean':
          hasMipMap = info.genMipmaps = options.mipmap
          break

        case 'object':
          check$1(Array.isArray(options.mipmap), 'invalid mipmap type')
          info.genMipmaps = false
          hasMipMap = true
          break

        default:
          check$1.raise('invalid mipmap type')
      }
      if (hasMipMap && !('min' in options)) {
        info.minFilter = GL_NEAREST_MIPMAP_NEAREST$1
      }
    }
  }

  function setTexInfo (info, target) {
    gl.texParameteri(target, GL_TEXTURE_MIN_FILTER, info.minFilter)
    gl.texParameteri(target, GL_TEXTURE_MAG_FILTER, info.magFilter)
    gl.texParameteri(target, GL_TEXTURE_WRAP_S, info.wrapS)
    gl.texParameteri(target, GL_TEXTURE_WRAP_T, info.wrapT)
    if (extensions.ext_texture_filter_anisotropic) {
      gl.texParameteri(target, GL_TEXTURE_MAX_ANISOTROPY_EXT, info.anisotropic)
    }
    if (info.genMipmaps) {
      gl.hint(GL_GENERATE_MIPMAP_HINT, info.mipmapHint)
      gl.generateMipmap(target)
    }
  }

  // -------------------------------------------------------
  // Full texture object
  // -------------------------------------------------------
  var textureCount = 0
  var textureSet = {}
  var numTexUnits = limits.maxTextureUnits
  var textureUnits = Array(numTexUnits).map(function () {
    return null
  })

  function REGLTexture (target) {
    TexFlags.call(this)
    this.mipmask = 0
    this.internalformat = GL_RGBA$1

    this.id = textureCount++

    this.refCount = 1

    this.target = target
    this.texture = gl.createTexture()

    this.unit = -1
    this.bindCount = 0

    this.texInfo = new TexInfo()

    if (config.profile) {
      this.stats = { size: 0 }
    }
  }

  function tempBind (texture) {
    gl.activeTexture(GL_TEXTURE0$1)
    gl.bindTexture(texture.target, texture.texture)
  }

  function tempRestore () {
    var prev = textureUnits[0]
    if (prev) {
      gl.bindTexture(prev.target, prev.texture)
    } else {
      gl.bindTexture(GL_TEXTURE_2D$1, null)
    }
  }

  function destroy (texture) {
    var handle = texture.texture
    check$1(handle, 'must not double destroy texture')
    var unit = texture.unit
    var target = texture.target
    if (unit >= 0) {
      gl.activeTexture(GL_TEXTURE0$1 + unit)
      gl.bindTexture(target, null)
      textureUnits[unit] = null
    }
    gl.deleteTexture(handle)
    texture.texture = null
    texture.params = null
    texture.pixels = null
    texture.refCount = 0
    delete textureSet[texture.id]
    stats.textureCount--
  }

  extend(REGLTexture.prototype, {
    bind: function () {
      var texture = this
      texture.bindCount += 1
      var unit = texture.unit
      if (unit < 0) {
        for (var i = 0; i < numTexUnits; ++i) {
          var other = textureUnits[i]
          if (other) {
            if (other.bindCount > 0) {
              continue
            }
            other.unit = -1
          }
          textureUnits[i] = texture
          unit = i
          break
        }
        if (unit >= numTexUnits) {
          check$1.raise('insufficient number of texture units')
        }
        if (config.profile && stats.maxTextureUnits < (unit + 1)) {
          stats.maxTextureUnits = unit + 1 // +1, since the units are zero-based
        }
        texture.unit = unit
        gl.activeTexture(GL_TEXTURE0$1 + unit)
        gl.bindTexture(texture.target, texture.texture)
      }
      return unit
    },

    unbind: function () {
      this.bindCount -= 1
    },

    decRef: function () {
      if (--this.refCount <= 0) {
        destroy(this)
      }
    }
  })

  function createTexture2D (a, b) {
    var texture = new REGLTexture(GL_TEXTURE_2D$1)
    textureSet[texture.id] = texture
    stats.textureCount++

    function reglTexture2D (a, b) {
      var texInfo = texture.texInfo
      TexInfo.call(texInfo)
      var mipData = allocMipMap()

      if (typeof a === 'number') {
        if (typeof b === 'number') {
          parseMipMapFromShape(mipData, a | 0, b | 0)
        } else {
          parseMipMapFromShape(mipData, a | 0, a | 0)
        }
      } else if (a) {
        check$1.type(a, 'object', 'invalid arguments to regl.texture')
        parseTexInfo(texInfo, a)
        parseMipMapFromObject(mipData, a)
      } else {
        // empty textures get assigned a default shape of 1x1
        parseMipMapFromShape(mipData, 1, 1)
      }

      if (texInfo.genMipmaps) {
        mipData.mipmask = (mipData.width << 1) - 1
      }
      texture.mipmask = mipData.mipmask

      copyFlags(texture, mipData)

      check$1.texture2D(texInfo, mipData, limits)
      texture.internalformat = mipData.internalformat

      reglTexture2D.width = mipData.width
      reglTexture2D.height = mipData.height

      tempBind(texture)
      setMipMap(mipData, GL_TEXTURE_2D$1)
      setTexInfo(texInfo, GL_TEXTURE_2D$1)
      tempRestore()

      freeMipMap(mipData)

      if (config.profile) {
        texture.stats.size = getTextureSize(
          texture.internalformat,
          texture.type,
          mipData.width,
          mipData.height,
          texInfo.genMipmaps,
          false)
      }
      reglTexture2D.format = textureFormatsInvert[texture.internalformat]
      reglTexture2D.type = textureTypesInvert[texture.type]

      reglTexture2D.mag = magFiltersInvert[texInfo.magFilter]
      reglTexture2D.min = minFiltersInvert[texInfo.minFilter]

      reglTexture2D.wrapS = wrapModesInvert[texInfo.wrapS]
      reglTexture2D.wrapT = wrapModesInvert[texInfo.wrapT]

      return reglTexture2D
    }

    function subimage (image, x_, y_, level_) {
      check$1(!!image, 'must specify image data')

      var x = x_ | 0
      var y = y_ | 0
      var level = level_ | 0

      var imageData = allocImage()
      copyFlags(imageData, texture)
      imageData.width = 0
      imageData.height = 0
      parseImage(imageData, image)
      imageData.width = imageData.width || ((texture.width >> level) - x)
      imageData.height = imageData.height || ((texture.height >> level) - y)

      check$1(
        texture.type === imageData.type &&
        texture.format === imageData.format &&
        texture.internalformat === imageData.internalformat,
        'incompatible format for texture.subimage')
      check$1(
        x >= 0 && y >= 0 &&
        x + imageData.width <= texture.width &&
        y + imageData.height <= texture.height,
        'texture.subimage write out of bounds')
      check$1(
        texture.mipmask & (1 << level),
        'missing mipmap data')
      check$1(
        imageData.data || imageData.element || imageData.needsCopy,
        'missing image data')

      tempBind(texture)
      setSubImage(imageData, GL_TEXTURE_2D$1, x, y, level)
      tempRestore()

      freeImage(imageData)

      return reglTexture2D
    }

    function resize (w_, h_) {
      var w = w_ | 0
      var h = (h_ | 0) || w
      if (w === texture.width && h === texture.height) {
        return reglTexture2D
      }

      reglTexture2D.width = texture.width = w
      reglTexture2D.height = texture.height = h

      tempBind(texture)

      for (var i = 0; texture.mipmask >> i; ++i) {
        var _w = w >> i
        var _h = h >> i
        if (!_w || !_h) break
        gl.texImage2D(
          GL_TEXTURE_2D$1,
          i,
          texture.format,
          _w,
          _h,
          0,
          texture.format,
          texture.type,
          null)
      }
      tempRestore()

      // also, recompute the texture size.
      if (config.profile) {
        texture.stats.size = getTextureSize(
          texture.internalformat,
          texture.type,
          w,
          h,
          false,
          false)
      }

      return reglTexture2D
    }

    reglTexture2D(a, b)

    reglTexture2D.subimage = subimage
    reglTexture2D.resize = resize
    reglTexture2D._reglType = 'texture2d'
    reglTexture2D._texture = texture
    if (config.profile) {
      reglTexture2D.stats = texture.stats
    }
    reglTexture2D.destroy = function () {
      texture.decRef()
    }

    return reglTexture2D
  }

  function createTextureCube (a0, a1, a2, a3, a4, a5) {
    var texture = new REGLTexture(GL_TEXTURE_CUBE_MAP$1)
    textureSet[texture.id] = texture
    stats.cubeCount++

    var faces = new Array(6)

    function reglTextureCube (a0, a1, a2, a3, a4, a5) {
      var i
      var texInfo = texture.texInfo
      TexInfo.call(texInfo)
      for (i = 0; i < 6; ++i) {
        faces[i] = allocMipMap()
      }

      if (typeof a0 === 'number' || !a0) {
        var s = (a0 | 0) || 1
        for (i = 0; i < 6; ++i) {
          parseMipMapFromShape(faces[i], s, s)
        }
      } else if (typeof a0 === 'object') {
        if (a1) {
          parseMipMapFromObject(faces[0], a0)
          parseMipMapFromObject(faces[1], a1)
          parseMipMapFromObject(faces[2], a2)
          parseMipMapFromObject(faces[3], a3)
          parseMipMapFromObject(faces[4], a4)
          parseMipMapFromObject(faces[5], a5)
        } else {
          parseTexInfo(texInfo, a0)
          parseFlags(texture, a0)
          if ('faces' in a0) {
            var faceInput = a0.faces
            check$1(Array.isArray(faceInput) && faceInput.length === 6,
              'cube faces must be a length 6 array')
            for (i = 0; i < 6; ++i) {
              check$1(typeof faceInput[i] === 'object' && !!faceInput[i],
                'invalid input for cube map face')
              copyFlags(faces[i], texture)
              parseMipMapFromObject(faces[i], faceInput[i])
            }
          } else {
            for (i = 0; i < 6; ++i) {
              parseMipMapFromObject(faces[i], a0)
            }
          }
        }
      } else {
        check$1.raise('invalid arguments to cube map')
      }

      copyFlags(texture, faces[0])
      check$1.optional(function () {
        if (!limits.npotTextureCube) {
          check$1(isPow2$1(texture.width) && isPow2$1(texture.height), 'your browser does not support non power or two texture dimensions')
        }
      })

      if (texInfo.genMipmaps) {
        texture.mipmask = (faces[0].width << 1) - 1
      } else {
        texture.mipmask = faces[0].mipmask
      }

      check$1.textureCube(texture, texInfo, faces, limits)
      texture.internalformat = faces[0].internalformat

      reglTextureCube.width = faces[0].width
      reglTextureCube.height = faces[0].height

      tempBind(texture)
      for (i = 0; i < 6; ++i) {
        setMipMap(faces[i], GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 + i)
      }
      setTexInfo(texInfo, GL_TEXTURE_CUBE_MAP$1)
      tempRestore()

      if (config.profile) {
        texture.stats.size = getTextureSize(
          texture.internalformat,
          texture.type,
          reglTextureCube.width,
          reglTextureCube.height,
          texInfo.genMipmaps,
          true)
      }

      reglTextureCube.format = textureFormatsInvert[texture.internalformat]
      reglTextureCube.type = textureTypesInvert[texture.type]

      reglTextureCube.mag = magFiltersInvert[texInfo.magFilter]
      reglTextureCube.min = minFiltersInvert[texInfo.minFilter]

      reglTextureCube.wrapS = wrapModesInvert[texInfo.wrapS]
      reglTextureCube.wrapT = wrapModesInvert[texInfo.wrapT]

      for (i = 0; i < 6; ++i) {
        freeMipMap(faces[i])
      }

      return reglTextureCube
    }

    function subimage (face, image, x_, y_, level_) {
      check$1(!!image, 'must specify image data')
      check$1(typeof face === 'number' && face === (face | 0) &&
        face >= 0 && face < 6, 'invalid face')

      var x = x_ | 0
      var y = y_ | 0
      var level = level_ | 0

      var imageData = allocImage()
      copyFlags(imageData, texture)
      imageData.width = 0
      imageData.height = 0
      parseImage(imageData, image)
      imageData.width = imageData.width || ((texture.width >> level) - x)
      imageData.height = imageData.height || ((texture.height >> level) - y)

      check$1(
        texture.type === imageData.type &&
        texture.format === imageData.format &&
        texture.internalformat === imageData.internalformat,
        'incompatible format for texture.subimage')
      check$1(
        x >= 0 && y >= 0 &&
        x + imageData.width <= texture.width &&
        y + imageData.height <= texture.height,
        'texture.subimage write out of bounds')
      check$1(
        texture.mipmask & (1 << level),
        'missing mipmap data')
      check$1(
        imageData.data || imageData.element || imageData.needsCopy,
        'missing image data')

      tempBind(texture)
      setSubImage(imageData, GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 + face, x, y, level)
      tempRestore()

      freeImage(imageData)

      return reglTextureCube
    }

    function resize (radius_) {
      var radius = radius_ | 0
      if (radius === texture.width) {
        return
      }

      reglTextureCube.width = texture.width = radius
      reglTextureCube.height = texture.height = radius

      tempBind(texture)
      for (var i = 0; i < 6; ++i) {
        for (var j = 0; texture.mipmask >> j; ++j) {
          gl.texImage2D(
            GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 + i,
            j,
            texture.format,
            radius >> j,
            radius >> j,
            0,
            texture.format,
            texture.type,
            null)
        }
      }
      tempRestore()

      if (config.profile) {
        texture.stats.size = getTextureSize(
          texture.internalformat,
          texture.type,
          reglTextureCube.width,
          reglTextureCube.height,
          false,
          true)
      }

      return reglTextureCube
    }

    reglTextureCube(a0, a1, a2, a3, a4, a5)

    reglTextureCube.subimage = subimage
    reglTextureCube.resize = resize
    reglTextureCube._reglType = 'textureCube'
    reglTextureCube._texture = texture
    if (config.profile) {
      reglTextureCube.stats = texture.stats
    }
    reglTextureCube.destroy = function () {
      texture.decRef()
    }

    return reglTextureCube
  }

  // Called when regl is destroyed
  function destroyTextures () {
    for (var i = 0; i < numTexUnits; ++i) {
      gl.activeTexture(GL_TEXTURE0$1 + i)
      gl.bindTexture(GL_TEXTURE_2D$1, null)
      textureUnits[i] = null
    }
    values(textureSet).forEach(destroy)

    stats.cubeCount = 0
    stats.textureCount = 0
  }

  if (config.profile) {
    stats.getTotalTextureSize = function () {
      var total = 0
      Object.keys(textureSet).forEach(function (key) {
        total += textureSet[key].stats.size
      })
      return total
    }
  }

  function restoreTextures () {
    for (var i = 0; i < numTexUnits; ++i) {
      var tex = textureUnits[i]
      if (tex) {
        tex.bindCount = 0
        tex.unit = -1
        textureUnits[i] = null
      }
    }

    values(textureSet).forEach(function (texture) {
      texture.texture = gl.createTexture()
      gl.bindTexture(texture.target, texture.texture)
      for (var i = 0; i < 32; ++i) {
        if ((texture.mipmask & (1 << i)) === 0) {
          continue
        }
        if (texture.target === GL_TEXTURE_2D$1) {
          gl.texImage2D(GL_TEXTURE_2D$1,
            i,
            texture.internalformat,
            texture.width >> i,
            texture.height >> i,
            0,
            texture.internalformat,
            texture.type,
            null)
        } else {
          for (var j = 0; j < 6; ++j) {
            gl.texImage2D(GL_TEXTURE_CUBE_MAP_POSITIVE_X$1 + j,
              i,
              texture.internalformat,
              texture.width >> i,
              texture.height >> i,
              0,
              texture.internalformat,
              texture.type,
              null)
          }
        }
      }
      setTexInfo(texture.texInfo, texture.target)
    })
  }

  function refreshTextures () {
    for (var i = 0; i < numTexUnits; ++i) {
      var tex = textureUnits[i]
      if (tex) {
        tex.bindCount = 0
        tex.unit = -1
        textureUnits[i] = null
      }
      gl.activeTexture(GL_TEXTURE0$1 + i)
      gl.bindTexture(GL_TEXTURE_2D$1, null)
      gl.bindTexture(GL_TEXTURE_CUBE_MAP$1, null)
    }
  }

  return {
    create2D: createTexture2D,
    createCube: createTextureCube,
    clear: destroyTextures,
    getTexture: function (wrapper) {
      return null
    },
    restore: restoreTextures,
    refresh: refreshTextures
  }
}

var GL_RENDERBUFFER = 0x8D41

var GL_RGBA4$1 = 0x8056
var GL_RGB5_A1$1 = 0x8057
var GL_RGB565$1 = 0x8D62
var GL_DEPTH_COMPONENT16 = 0x81A5
var GL_STENCIL_INDEX8 = 0x8D48
var GL_DEPTH_STENCIL$1 = 0x84F9

var GL_SRGB8_ALPHA8_EXT = 0x8C43

var GL_RGBA32F_EXT = 0x8814

var GL_RGBA16F_EXT = 0x881A
var GL_RGB16F_EXT = 0x881B

var FORMAT_SIZES = []

FORMAT_SIZES[GL_RGBA4$1] = 2
FORMAT_SIZES[GL_RGB5_A1$1] = 2
FORMAT_SIZES[GL_RGB565$1] = 2

FORMAT_SIZES[GL_DEPTH_COMPONENT16] = 2
FORMAT_SIZES[GL_STENCIL_INDEX8] = 1
FORMAT_SIZES[GL_DEPTH_STENCIL$1] = 4

FORMAT_SIZES[GL_SRGB8_ALPHA8_EXT] = 4
FORMAT_SIZES[GL_RGBA32F_EXT] = 16
FORMAT_SIZES[GL_RGBA16F_EXT] = 8
FORMAT_SIZES[GL_RGB16F_EXT] = 6

function getRenderbufferSize (format, width, height) {
  return FORMAT_SIZES[format] * width * height
}

var wrapRenderbuffers = function (gl, extensions, limits, stats, config) {
  var formatTypes = {
    'rgba4': GL_RGBA4$1,
    'rgb565': GL_RGB565$1,
    'rgb5 a1': GL_RGB5_A1$1,
    'depth': GL_DEPTH_COMPONENT16,
    'stencil': GL_STENCIL_INDEX8,
    'depth stencil': GL_DEPTH_STENCIL$1
  }

  if (extensions.ext_srgb) {
    formatTypes['srgba'] = GL_SRGB8_ALPHA8_EXT
  }

  if (extensions.ext_color_buffer_half_float) {
    formatTypes['rgba16f'] = GL_RGBA16F_EXT
    formatTypes['rgb16f'] = GL_RGB16F_EXT
  }

  if (extensions.webgl_color_buffer_float) {
    formatTypes['rgba32f'] = GL_RGBA32F_EXT
  }

  var formatTypesInvert = []
  Object.keys(formatTypes).forEach(function (key) {
    var val = formatTypes[key]
    formatTypesInvert[val] = key
  })

  var renderbufferCount = 0
  var renderbufferSet = {}

  function REGLRenderbuffer (renderbuffer) {
    this.id = renderbufferCount++
    this.refCount = 1

    this.renderbuffer = renderbuffer

    this.format = GL_RGBA4$1
    this.width = 0
    this.height = 0

    if (config.profile) {
      this.stats = { size: 0 }
    }
  }

  REGLRenderbuffer.prototype.decRef = function () {
    if (--this.refCount <= 0) {
      destroy(this)
    }
  }

  function destroy (rb) {
    var handle = rb.renderbuffer
    check$1(handle, 'must not double destroy renderbuffer')
    gl.bindRenderbuffer(GL_RENDERBUFFER, null)
    gl.deleteRenderbuffer(handle)
    rb.renderbuffer = null
    rb.refCount = 0
    delete renderbufferSet[rb.id]
    stats.renderbufferCount--
  }

  function createRenderbuffer (a, b) {
    var renderbuffer = new REGLRenderbuffer(gl.createRenderbuffer())
    renderbufferSet[renderbuffer.id] = renderbuffer
    stats.renderbufferCount++

    function reglRenderbuffer (a, b) {
      var w = 0
      var h = 0
      var format = GL_RGBA4$1

      if (typeof a === 'object' && a) {
        var options = a
        if ('shape' in options) {
          var shape = options.shape
          check$1(Array.isArray(shape) && shape.length >= 2,
            'invalid renderbuffer shape')
          w = shape[0] | 0
          h = shape[1] | 0
        } else {
          if ('radius' in options) {
            w = h = options.radius | 0
          }
          if ('width' in options) {
            w = options.width | 0
          }
          if ('height' in options) {
            h = options.height | 0
          }
        }
        if ('format' in options) {
          check$1.parameter(options.format, formatTypes,
            'invalid renderbuffer format')
          format = formatTypes[options.format]
        }
      } else if (typeof a === 'number') {
        w = a | 0
        if (typeof b === 'number') {
          h = b | 0
        } else {
          h = w
        }
      } else if (!a) {
        w = h = 1
      } else {
        check$1.raise('invalid arguments to renderbuffer constructor')
      }

      // check shape
      check$1(
        w > 0 && h > 0 &&
        w <= limits.maxRenderbufferSize && h <= limits.maxRenderbufferSize,
        'invalid renderbuffer size')

      if (w === renderbuffer.width &&
          h === renderbuffer.height &&
          format === renderbuffer.format) {
        return
      }

      reglRenderbuffer.width = renderbuffer.width = w
      reglRenderbuffer.height = renderbuffer.height = h
      renderbuffer.format = format

      gl.bindRenderbuffer(GL_RENDERBUFFER, renderbuffer.renderbuffer)
      gl.renderbufferStorage(GL_RENDERBUFFER, format, w, h)

      check$1(
        gl.getError() === 0,
        'invalid render buffer format')

      if (config.profile) {
        renderbuffer.stats.size = getRenderbufferSize(renderbuffer.format, renderbuffer.width, renderbuffer.height)
      }
      reglRenderbuffer.format = formatTypesInvert[renderbuffer.format]

      return reglRenderbuffer
    }

    function resize (w_, h_) {
      var w = w_ | 0
      var h = (h_ | 0) || w

      if (w === renderbuffer.width && h === renderbuffer.height) {
        return reglRenderbuffer
      }

      // check shape
      check$1(
        w > 0 && h > 0 &&
        w <= limits.maxRenderbufferSize && h <= limits.maxRenderbufferSize,
        'invalid renderbuffer size')

      reglRenderbuffer.width = renderbuffer.width = w
      reglRenderbuffer.height = renderbuffer.height = h

      gl.bindRenderbuffer(GL_RENDERBUFFER, renderbuffer.renderbuffer)
      gl.renderbufferStorage(GL_RENDERBUFFER, renderbuffer.format, w, h)

      check$1(
        gl.getError() === 0,
        'invalid render buffer format')

      // also, recompute size.
      if (config.profile) {
        renderbuffer.stats.size = getRenderbufferSize(
          renderbuffer.format, renderbuffer.width, renderbuffer.height)
      }

      return reglRenderbuffer
    }

    reglRenderbuffer(a, b)

    reglRenderbuffer.resize = resize
    reglRenderbuffer._reglType = 'renderbuffer'
    reglRenderbuffer._renderbuffer = renderbuffer
    if (config.profile) {
      reglRenderbuffer.stats = renderbuffer.stats
    }
    reglRenderbuffer.destroy = function () {
      renderbuffer.decRef()
    }

    return reglRenderbuffer
  }

  if (config.profile) {
    stats.getTotalRenderbufferSize = function () {
      var total = 0
      Object.keys(renderbufferSet).forEach(function (key) {
        total += renderbufferSet[key].stats.size
      })
      return total
    }
  }

  function restoreRenderbuffers () {
    values(renderbufferSet).forEach(function (rb) {
      rb.renderbuffer = gl.createRenderbuffer()
      gl.bindRenderbuffer(GL_RENDERBUFFER, rb.renderbuffer)
      gl.renderbufferStorage(GL_RENDERBUFFER, rb.format, rb.width, rb.height)
    })
    gl.bindRenderbuffer(GL_RENDERBUFFER, null)
  }

  return {
    create: createRenderbuffer,
    clear: function () {
      values(renderbufferSet).forEach(destroy)
    },
    restore: restoreRenderbuffers
  }
}

// We store these constants so that the minifier can inline them
var GL_FRAMEBUFFER$1 = 0x8D40
var GL_RENDERBUFFER$1 = 0x8D41

var GL_TEXTURE_2D$2 = 0x0DE1
var GL_TEXTURE_CUBE_MAP_POSITIVE_X$2 = 0x8515

var GL_COLOR_ATTACHMENT0$1 = 0x8CE0
var GL_DEPTH_ATTACHMENT = 0x8D00
var GL_STENCIL_ATTACHMENT = 0x8D20
var GL_DEPTH_STENCIL_ATTACHMENT = 0x821A

var GL_FRAMEBUFFER_COMPLETE$1 = 0x8CD5
var GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6
var GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7
var GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 0x8CD9
var GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD

var GL_HALF_FLOAT_OES$2 = 0x8D61
var GL_UNSIGNED_BYTE$6 = 0x1401
var GL_FLOAT$5 = 0x1406

var GL_RGB$1 = 0x1907
var GL_RGBA$2 = 0x1908

var GL_DEPTH_COMPONENT$1 = 0x1902

var colorTextureFormatEnums = [
  GL_RGB$1,
  GL_RGBA$2
]

// for every texture format, store
// the number of channels
var textureFormatChannels = []
textureFormatChannels[GL_RGBA$2] = 4
textureFormatChannels[GL_RGB$1] = 3

// for every texture type, store
// the size in bytes.
var textureTypeSizes = []
textureTypeSizes[GL_UNSIGNED_BYTE$6] = 1
textureTypeSizes[GL_FLOAT$5] = 4
textureTypeSizes[GL_HALF_FLOAT_OES$2] = 2

var GL_RGBA4$2 = 0x8056
var GL_RGB5_A1$2 = 0x8057
var GL_RGB565$2 = 0x8D62
var GL_DEPTH_COMPONENT16$1 = 0x81A5
var GL_STENCIL_INDEX8$1 = 0x8D48
var GL_DEPTH_STENCIL$2 = 0x84F9

var GL_SRGB8_ALPHA8_EXT$1 = 0x8C43

var GL_RGBA32F_EXT$1 = 0x8814

var GL_RGBA16F_EXT$1 = 0x881A
var GL_RGB16F_EXT$1 = 0x881B

var colorRenderbufferFormatEnums = [
  GL_RGBA4$2,
  GL_RGB5_A1$2,
  GL_RGB565$2,
  GL_SRGB8_ALPHA8_EXT$1,
  GL_RGBA16F_EXT$1,
  GL_RGB16F_EXT$1,
  GL_RGBA32F_EXT$1
]

var statusCode = {}
statusCode[GL_FRAMEBUFFER_COMPLETE$1] = 'complete'
statusCode[GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT] = 'incomplete attachment'
statusCode[GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS] = 'incomplete dimensions'
statusCode[GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT] = 'incomplete, missing attachment'
statusCode[GL_FRAMEBUFFER_UNSUPPORTED] = 'unsupported'

function wrapFBOState (
  gl,
  extensions,
  limits,
  textureState,
  renderbufferState,
  stats) {
  var framebufferState = {
    cur: null,
    next: null,
    dirty: false,
    setFBO: null
  }

  var colorTextureFormats = ['rgba']
  var colorRenderbufferFormats = ['rgba4', 'rgb565', 'rgb5 a1']

  if (extensions.ext_srgb) {
    colorRenderbufferFormats.push('srgba')
  }

  if (extensions.ext_color_buffer_half_float) {
    colorRenderbufferFormats.push('rgba16f', 'rgb16f')
  }

  if (extensions.webgl_color_buffer_float) {
    colorRenderbufferFormats.push('rgba32f')
  }

  var colorTypes = ['uint8']
  if (extensions.oes_texture_half_float) {
    colorTypes.push('half float', 'float16')
  }
  if (extensions.oes_texture_float) {
    colorTypes.push('float', 'float32')
  }

  function FramebufferAttachment (target, texture, renderbuffer) {
    this.target = target
    this.texture = texture
    this.renderbuffer = renderbuffer

    var w = 0
    var h = 0
    if (texture) {
      w = texture.width
      h = texture.height
    } else if (renderbuffer) {
      w = renderbuffer.width
      h = renderbuffer.height
    }
    this.width = w
    this.height = h
  }

  function decRef (attachment) {
    if (attachment) {
      if (attachment.texture) {
        attachment.texture._texture.decRef()
      }
      if (attachment.renderbuffer) {
        attachment.renderbuffer._renderbuffer.decRef()
      }
    }
  }

  function incRefAndCheckShape (attachment, width, height) {
    if (!attachment) {
      return
    }
    if (attachment.texture) {
      var texture = attachment.texture._texture
      var tw = Math.max(1, texture.width)
      var th = Math.max(1, texture.height)
      check$1(tw === width && th === height,
        'inconsistent width/height for supplied texture')
      texture.refCount += 1
    } else {
      var renderbuffer = attachment.renderbuffer._renderbuffer
      check$1(
        renderbuffer.width === width && renderbuffer.height === height,
        'inconsistent width/height for renderbuffer')
      renderbuffer.refCount += 1
    }
  }

  function attach (location, attachment) {
    if (attachment) {
      if (attachment.texture) {
        gl.framebufferTexture2D(
          GL_FRAMEBUFFER$1,
          location,
          attachment.target,
          attachment.texture._texture.texture,
          0)
      } else {
        gl.framebufferRenderbuffer(
          GL_FRAMEBUFFER$1,
          location,
          GL_RENDERBUFFER$1,
          attachment.renderbuffer._renderbuffer.renderbuffer)
      }
    }
  }

  function parseAttachment (attachment) {
    var target = GL_TEXTURE_2D$2
    var texture = null
    var renderbuffer = null

    var data = attachment
    if (typeof attachment === 'object') {
      data = attachment.data
      if ('target' in attachment) {
        target = attachment.target | 0
      }
    }

    check$1.type(data, 'function', 'invalid attachment data')

    var type = data._reglType
    if (type === 'texture2d') {
      texture = data
      check$1(target === GL_TEXTURE_2D$2)
    } else if (type === 'textureCube') {
      texture = data
      check$1(
        target >= GL_TEXTURE_CUBE_MAP_POSITIVE_X$2 &&
        target < GL_TEXTURE_CUBE_MAP_POSITIVE_X$2 + 6,
        'invalid cube map target')
    } else if (type === 'renderbuffer') {
      renderbuffer = data
      target = GL_RENDERBUFFER$1
    } else {
      check$1.raise('invalid regl object for attachment')
    }

    return new FramebufferAttachment(target, texture, renderbuffer)
  }

  function allocAttachment (
    width,
    height,
    isTexture,
    format,
    type) {
    if (isTexture) {
      var texture = textureState.create2D({
        width: width,
        height: height,
        format: format,
        type: type
      })
      texture._texture.refCount = 0
      return new FramebufferAttachment(GL_TEXTURE_2D$2, texture, null)
    } else {
      var rb = renderbufferState.create({
        width: width,
        height: height,
        format: format
      })
      rb._renderbuffer.refCount = 0
      return new FramebufferAttachment(GL_RENDERBUFFER$1, null, rb)
    }
  }

  function unwrapAttachment (attachment) {
    return attachment && (attachment.texture || attachment.renderbuffer)
  }

  function resizeAttachment (attachment, w, h) {
    if (attachment) {
      if (attachment.texture) {
        attachment.texture.resize(w, h)
      } else if (attachment.renderbuffer) {
        attachment.renderbuffer.resize(w, h)
      }
      attachment.width = w
      attachment.height = h
    }
  }

  var framebufferCount = 0
  var framebufferSet = {}

  function REGLFramebuffer () {
    this.id = framebufferCount++
    framebufferSet[this.id] = this

    this.framebuffer = gl.createFramebuffer()
    this.width = 0
    this.height = 0

    this.colorAttachments = []
    this.depthAttachment = null
    this.stencilAttachment = null
    this.depthStencilAttachment = null
  }

  function decFBORefs (framebuffer) {
    framebuffer.colorAttachments.forEach(decRef)
    decRef(framebuffer.depthAttachment)
    decRef(framebuffer.stencilAttachment)
    decRef(framebuffer.depthStencilAttachment)
  }

  function destroy (framebuffer) {
    var handle = framebuffer.framebuffer
    check$1(handle, 'must not double destroy framebuffer')
    gl.deleteFramebuffer(handle)
    framebuffer.framebuffer = null
    stats.framebufferCount--
    delete framebufferSet[framebuffer.id]
  }

  function updateFramebuffer (framebuffer) {
    var i

    gl.bindFramebuffer(GL_FRAMEBUFFER$1, framebuffer.framebuffer)
    var colorAttachments = framebuffer.colorAttachments
    for (i = 0; i < colorAttachments.length; ++i) {
      attach(GL_COLOR_ATTACHMENT0$1 + i, colorAttachments[i])
    }
    for (i = colorAttachments.length; i < limits.maxColorAttachments; ++i) {
      gl.framebufferTexture2D(
        GL_FRAMEBUFFER$1,
        GL_COLOR_ATTACHMENT0$1 + i,
        GL_TEXTURE_2D$2,
        null,
        0)
    }

    gl.framebufferTexture2D(
      GL_FRAMEBUFFER$1,
      GL_DEPTH_STENCIL_ATTACHMENT,
      GL_TEXTURE_2D$2,
      null,
      0)
    gl.framebufferTexture2D(
      GL_FRAMEBUFFER$1,
      GL_DEPTH_ATTACHMENT,
      GL_TEXTURE_2D$2,
      null,
      0)
    gl.framebufferTexture2D(
      GL_FRAMEBUFFER$1,
      GL_STENCIL_ATTACHMENT,
      GL_TEXTURE_2D$2,
      null,
      0)

    attach(GL_DEPTH_ATTACHMENT, framebuffer.depthAttachment)
    attach(GL_STENCIL_ATTACHMENT, framebuffer.stencilAttachment)
    attach(GL_DEPTH_STENCIL_ATTACHMENT, framebuffer.depthStencilAttachment)

    // Check status code
    var status = gl.checkFramebufferStatus(GL_FRAMEBUFFER$1)
    if (!gl.isContextLost() && status !== GL_FRAMEBUFFER_COMPLETE$1) {
      check$1.raise('framebuffer configuration not supported, status = ' +
        statusCode[status])
    }

    gl.bindFramebuffer(GL_FRAMEBUFFER$1, framebufferState.next ? framebufferState.next.framebuffer : null)
    framebufferState.cur = framebufferState.next

    // FIXME: Clear error code here.  This is a work around for a bug in
    // headless-gl
    gl.getError()
  }

  function createFBO (a0, a1) {
    var framebuffer = new REGLFramebuffer()
    stats.framebufferCount++

    function reglFramebuffer (a, b) {
      var i

      check$1(framebufferState.next !== framebuffer,
        'can not update framebuffer which is currently in use')

      var width = 0
      var height = 0

      var needsDepth = true
      var needsStencil = true

      var colorBuffer = null
      var colorTexture = true
      var colorFormat = 'rgba'
      var colorType = 'uint8'
      var colorCount = 1

      var depthBuffer = null
      var stencilBuffer = null
      var depthStencilBuffer = null
      var depthStencilTexture = false

      if (typeof a === 'number') {
        width = a | 0
        height = (b | 0) || width
      } else if (!a) {
        width = height = 1
      } else {
        check$1.type(a, 'object', 'invalid arguments for framebuffer')
        var options = a

        if ('shape' in options) {
          var shape = options.shape
          check$1(Array.isArray(shape) && shape.length >= 2,
            'invalid shape for framebuffer')
          width = shape[0]
          height = shape[1]
        } else {
          if ('radius' in options) {
            width = height = options.radius
          }
          if ('width' in options) {
            width = options.width
          }
          if ('height' in options) {
            height = options.height
          }
        }

        if ('color' in options ||
            'colors' in options) {
          colorBuffer =
            options.color ||
            options.colors
          if (Array.isArray(colorBuffer)) {
            check$1(
              colorBuffer.length === 1 || extensions.webgl_draw_buffers,
              'multiple render targets not supported')
          }
        }

        if (!colorBuffer) {
          if ('colorCount' in options) {
            colorCount = options.colorCount | 0
            check$1(colorCount > 0, 'invalid color buffer count')
          }

          if ('colorTexture' in options) {
            colorTexture = !!options.colorTexture
            colorFormat = 'rgba4'
          }

          if ('colorType' in options) {
            colorType = options.colorType
            if (!colorTexture) {
              if (colorType === 'half float' || colorType === 'float16') {
                check$1(extensions.ext_color_buffer_half_float,
                  'you must enable EXT_color_buffer_half_float to use 16-bit render buffers')
                colorFormat = 'rgba16f'
              } else if (colorType === 'float' || colorType === 'float32') {
                check$1(extensions.webgl_color_buffer_float,
                  'you must enable WEBGL_color_buffer_float in order to use 32-bit floating point renderbuffers')
                colorFormat = 'rgba32f'
              }
            } else {
              check$1(extensions.oes_texture_float ||
                !(colorType === 'float' || colorType === 'float32'),
              'you must enable OES_texture_float in order to use floating point framebuffer objects')
              check$1(extensions.oes_texture_half_float ||
                !(colorType === 'half float' || colorType === 'float16'),
              'you must enable OES_texture_half_float in order to use 16-bit floating point framebuffer objects')
            }
            check$1.oneOf(colorType, colorTypes, 'invalid color type')
          }

          if ('colorFormat' in options) {
            colorFormat = options.colorFormat
            if (colorTextureFormats.indexOf(colorFormat) >= 0) {
              colorTexture = true
            } else if (colorRenderbufferFormats.indexOf(colorFormat) >= 0) {
              colorTexture = false
            } else {
              check$1.optional(function () {
                if (colorTexture) {
                  check$1.oneOf(
                    options.colorFormat, colorTextureFormats,
                    'invalid color format for texture')
                } else {
                  check$1.oneOf(
                    options.colorFormat, colorRenderbufferFormats,
                    'invalid color format for renderbuffer')
                }
              })
            }
          }
        }

        if ('depthTexture' in options || 'depthStencilTexture' in options) {
          depthStencilTexture = !!(options.depthTexture ||
            options.depthStencilTexture)
          check$1(!depthStencilTexture || extensions.webgl_depth_texture,
            'webgl_depth_texture extension not supported')
        }

        if ('depth' in options) {
          if (typeof options.depth === 'boolean') {
            needsDepth = options.depth
          } else {
            depthBuffer = options.depth
            needsStencil = false
          }
        }

        if ('stencil' in options) {
          if (typeof options.stencil === 'boolean') {
            needsStencil = options.stencil
          } else {
            stencilBuffer = options.stencil
            needsDepth = false
          }
        }

        if ('depthStencil' in options) {
          if (typeof options.depthStencil === 'boolean') {
            needsDepth = needsStencil = options.depthStencil
          } else {
            depthStencilBuffer = options.depthStencil
            needsDepth = false
            needsStencil = false
          }
        }
      }

      // parse attachments
      var colorAttachments = null
      var depthAttachment = null
      var stencilAttachment = null
      var depthStencilAttachment = null

      // Set up color attachments
      if (Array.isArray(colorBuffer)) {
        colorAttachments = colorBuffer.map(parseAttachment)
      } else if (colorBuffer) {
        colorAttachments = [parseAttachment(colorBuffer)]
      } else {
        colorAttachments = new Array(colorCount)
        for (i = 0; i < colorCount; ++i) {
          colorAttachments[i] = allocAttachment(
            width,
            height,
            colorTexture,
            colorFormat,
            colorType)
        }
      }

      check$1(extensions.webgl_draw_buffers || colorAttachments.length <= 1,
        'you must enable the WEBGL_draw_buffers extension in order to use multiple color buffers.')
      check$1(colorAttachments.length <= limits.maxColorAttachments,
        'too many color attachments, not supported')

      width = width || colorAttachments[0].width
      height = height || colorAttachments[0].height

      if (depthBuffer) {
        depthAttachment = parseAttachment(depthBuffer)
      } else if (needsDepth && !needsStencil) {
        depthAttachment = allocAttachment(
          width,
          height,
          depthStencilTexture,
          'depth',
          'uint32')
      }

      if (stencilBuffer) {
        stencilAttachment = parseAttachment(stencilBuffer)
      } else if (needsStencil && !needsDepth) {
        stencilAttachment = allocAttachment(
          width,
          height,
          false,
          'stencil',
          'uint8')
      }

      if (depthStencilBuffer) {
        depthStencilAttachment = parseAttachment(depthStencilBuffer)
      } else if (!depthBuffer && !stencilBuffer && needsStencil && needsDepth) {
        depthStencilAttachment = allocAttachment(
          width,
          height,
          depthStencilTexture,
          'depth stencil',
          'depth stencil')
      }

      check$1(
        (!!depthBuffer) + (!!stencilBuffer) + (!!depthStencilBuffer) <= 1,
        'invalid framebuffer configuration, can specify exactly one depth/stencil attachment')

      var commonColorAttachmentSize = null

      for (i = 0; i < colorAttachments.length; ++i) {
        incRefAndCheckShape(colorAttachments[i], width, height)
        check$1(!colorAttachments[i] ||
          (colorAttachments[i].texture &&
            colorTextureFormatEnums.indexOf(colorAttachments[i].texture._texture.format) >= 0) ||
          (colorAttachments[i].renderbuffer &&
            colorRenderbufferFormatEnums.indexOf(colorAttachments[i].renderbuffer._renderbuffer.format) >= 0),
        'framebuffer color attachment ' + i + ' is invalid')

        if (colorAttachments[i] && colorAttachments[i].texture) {
          var colorAttachmentSize =
              textureFormatChannels[colorAttachments[i].texture._texture.format] *
              textureTypeSizes[colorAttachments[i].texture._texture.type]

          if (commonColorAttachmentSize === null) {
            commonColorAttachmentSize = colorAttachmentSize
          } else {
            // We need to make sure that all color attachments have the same number of bitplanes
            // (that is, the same numer of bits per pixel)
            // This is required by the GLES2.0 standard. See the beginning of Chapter 4 in that document.
            check$1(commonColorAttachmentSize === colorAttachmentSize,
              'all color attachments much have the same number of bits per pixel.')
          }
        }
      }
      incRefAndCheckShape(depthAttachment, width, height)
      check$1(!depthAttachment ||
        (depthAttachment.texture &&
          depthAttachment.texture._texture.format === GL_DEPTH_COMPONENT$1) ||
        (depthAttachment.renderbuffer &&
          depthAttachment.renderbuffer._renderbuffer.format === GL_DEPTH_COMPONENT16$1),
      'invalid depth attachment for framebuffer object')
      incRefAndCheckShape(stencilAttachment, width, height)
      check$1(!stencilAttachment ||
        (stencilAttachment.renderbuffer &&
          stencilAttachment.renderbuffer._renderbuffer.format === GL_STENCIL_INDEX8$1),
      'invalid stencil attachment for framebuffer object')
      incRefAndCheckShape(depthStencilAttachment, width, height)
      check$1(!depthStencilAttachment ||
        (depthStencilAttachment.texture &&
          depthStencilAttachment.texture._texture.format === GL_DEPTH_STENCIL$2) ||
        (depthStencilAttachment.renderbuffer &&
          depthStencilAttachment.renderbuffer._renderbuffer.format === GL_DEPTH_STENCIL$2),
      'invalid depth-stencil attachment for framebuffer object')

      // decrement references
      decFBORefs(framebuffer)

      framebuffer.width = width
      framebuffer.height = height

      framebuffer.colorAttachments = colorAttachments
      framebuffer.depthAttachment = depthAttachment
      framebuffer.stencilAttachment = stencilAttachment
      framebuffer.depthStencilAttachment = depthStencilAttachment

      reglFramebuffer.color = colorAttachments.map(unwrapAttachment)
      reglFramebuffer.depth = unwrapAttachment(depthAttachment)
      reglFramebuffer.stencil = unwrapAttachment(stencilAttachment)
      reglFramebuffer.depthStencil = unwrapAttachment(depthStencilAttachment)

      reglFramebuffer.width = framebuffer.width
      reglFramebuffer.height = framebuffer.height

      updateFramebuffer(framebuffer)

      return reglFramebuffer
    }

    function resize (w_, h_) {
      check$1(framebufferState.next !== framebuffer,
        'can not resize a framebuffer which is currently in use')

      var w = Math.max(w_ | 0, 1)
      var h = Math.max((h_ | 0) || w, 1)
      if (w === framebuffer.width && h === framebuffer.height) {
        return reglFramebuffer
      }

      // resize all buffers
      var colorAttachments = framebuffer.colorAttachments
      for (var i = 0; i < colorAttachments.length; ++i) {
        resizeAttachment(colorAttachments[i], w, h)
      }
      resizeAttachment(framebuffer.depthAttachment, w, h)
      resizeAttachment(framebuffer.stencilAttachment, w, h)
      resizeAttachment(framebuffer.depthStencilAttachment, w, h)

      framebuffer.width = reglFramebuffer.width = w
      framebuffer.height = reglFramebuffer.height = h

      updateFramebuffer(framebuffer)

      return reglFramebuffer
    }

    reglFramebuffer(a0, a1)

    return extend(reglFramebuffer, {
      resize: resize,
      _reglType: 'framebuffer',
      _framebuffer: framebuffer,
      destroy: function () {
        destroy(framebuffer)
        decFBORefs(framebuffer)
      },
      use: function (block) {
        framebufferState.setFBO({
          framebuffer: reglFramebuffer
        }, block)
      }
    })
  }

  function createCubeFBO (options) {
    var faces = Array(6)

    function reglFramebufferCube (a) {
      var i

      check$1(faces.indexOf(framebufferState.next) < 0,
        'can not update framebuffer which is currently in use')

      var params = {
        color: null
      }

      var radius = 0

      var colorBuffer = null
      var colorFormat = 'rgba'
      var colorType = 'uint8'
      var colorCount = 1

      if (typeof a === 'number') {
        radius = a | 0
      } else if (!a) {
        radius = 1
      } else {
        check$1.type(a, 'object', 'invalid arguments for framebuffer')
        var options = a

        if ('shape' in options) {
          var shape = options.shape
          check$1(
            Array.isArray(shape) && shape.length >= 2,
            'invalid shape for framebuffer')
          check$1(
            shape[0] === shape[1],
            'cube framebuffer must be square')
          radius = shape[0]
        } else {
          if ('radius' in options) {
            radius = options.radius | 0
          }
          if ('width' in options) {
            radius = options.width | 0
            if ('height' in options) {
              check$1(options.height === radius, 'must be square')
            }
          } else if ('height' in options) {
            radius = options.height | 0
          }
        }

        if ('color' in options ||
            'colors' in options) {
          colorBuffer =
            options.color ||
            options.colors
          if (Array.isArray(colorBuffer)) {
            check$1(
              colorBuffer.length === 1 || extensions.webgl_draw_buffers,
              'multiple render targets not supported')
          }
        }

        if (!colorBuffer) {
          if ('colorCount' in options) {
            colorCount = options.colorCount | 0
            check$1(colorCount > 0, 'invalid color buffer count')
          }

          if ('colorType' in options) {
            check$1.oneOf(
              options.colorType, colorTypes,
              'invalid color type')
            colorType = options.colorType
          }

          if ('colorFormat' in options) {
            colorFormat = options.colorFormat
            check$1.oneOf(
              options.colorFormat, colorTextureFormats,
              'invalid color format for texture')
          }
        }

        if ('depth' in options) {
          params.depth = options.depth
        }

        if ('stencil' in options) {
          params.stencil = options.stencil
        }

        if ('depthStencil' in options) {
          params.depthStencil = options.depthStencil
        }
      }

      var colorCubes
      if (colorBuffer) {
        if (Array.isArray(colorBuffer)) {
          colorCubes = []
          for (i = 0; i < colorBuffer.length; ++i) {
            colorCubes[i] = colorBuffer[i]
          }
        } else {
          colorCubes = [ colorBuffer ]
        }
      } else {
        colorCubes = Array(colorCount)
        var cubeMapParams = {
          radius: radius,
          format: colorFormat,
          type: colorType
        }
        for (i = 0; i < colorCount; ++i) {
          colorCubes[i] = textureState.createCube(cubeMapParams)
        }
      }

      // Check color cubes
      params.color = Array(colorCubes.length)
      for (i = 0; i < colorCubes.length; ++i) {
        var cube = colorCubes[i]
        check$1(
          typeof cube === 'function' && cube._reglType === 'textureCube',
          'invalid cube map')
        radius = radius || cube.width
        check$1(
          cube.width === radius && cube.height === radius,
          'invalid cube map shape')
        params.color[i] = {
          target: GL_TEXTURE_CUBE_MAP_POSITIVE_X$2,
          data: colorCubes[i]
        }
      }

      for (i = 0; i < 6; ++i) {
        for (var j = 0; j < colorCubes.length; ++j) {
          params.color[j].target = GL_TEXTURE_CUBE_MAP_POSITIVE_X$2 + i
        }
        // reuse depth-stencil attachments across all cube maps
        if (i > 0) {
          params.depth = faces[0].depth
          params.stencil = faces[0].stencil
          params.depthStencil = faces[0].depthStencil
        }
        if (faces[i]) {
          (faces[i])(params)
        } else {
          faces[i] = createFBO(params)
        }
      }

      return extend(reglFramebufferCube, {
        width: radius,
        height: radius,
        color: colorCubes
      })
    }

    function resize (radius_) {
      var i
      var radius = radius_ | 0
      check$1(radius > 0 && radius <= limits.maxCubeMapSize,
        'invalid radius for cube fbo')

      if (radius === reglFramebufferCube.width) {
        return reglFramebufferCube
      }

      var colors = reglFramebufferCube.color
      for (i = 0; i < colors.length; ++i) {
        colors[i].resize(radius)
      }

      for (i = 0; i < 6; ++i) {
        faces[i].resize(radius)
      }

      reglFramebufferCube.width = reglFramebufferCube.height = radius

      return reglFramebufferCube
    }

    reglFramebufferCube(options)

    return extend(reglFramebufferCube, {
      faces: faces,
      resize: resize,
      _reglType: 'framebufferCube',
      destroy: function () {
        faces.forEach(function (f) {
          f.destroy()
        })
      }
    })
  }

  function restoreFramebuffers () {
    framebufferState.cur = null
    framebufferState.next = null
    framebufferState.dirty = true
    values(framebufferSet).forEach(function (fb) {
      fb.framebuffer = gl.createFramebuffer()
      updateFramebuffer(fb)
    })
  }

  return extend(framebufferState, {
    getFramebuffer: function (object) {
      if (typeof object === 'function' && object._reglType === 'framebuffer') {
        var fbo = object._framebuffer
        if (fbo instanceof REGLFramebuffer) {
          return fbo
        }
      }
      return null
    },
    create: createFBO,
    createCube: createCubeFBO,
    clear: function () {
      values(framebufferSet).forEach(destroy)
    },
    restore: restoreFramebuffers
  })
}

var GL_FLOAT$6 = 5126
var GL_ARRAY_BUFFER$1 = 34962
var GL_ELEMENT_ARRAY_BUFFER$1 = 34963

var VAO_OPTIONS = [
  'attributes',
  'elements',
  'offset',
  'count',
  'primitive',
  'instances'
]

function AttributeRecord () {
  this.state = 0

  this.x = 0.0
  this.y = 0.0
  this.z = 0.0
  this.w = 0.0

  this.buffer = null
  this.size = 0
  this.normalized = false
  this.type = GL_FLOAT$6
  this.offset = 0
  this.stride = 0
  this.divisor = 0
}

function wrapAttributeState (
  gl,
  extensions,
  limits,
  stats,
  bufferState,
  elementState,
  drawState) {
  var NUM_ATTRIBUTES = limits.maxAttributes
  var attributeBindings = new Array(NUM_ATTRIBUTES)
  for (var i = 0; i < NUM_ATTRIBUTES; ++i) {
    attributeBindings[i] = new AttributeRecord()
  }
  var vaoCount = 0
  var vaoSet = {}

  var state = {
    Record: AttributeRecord,
    scope: {},
    state: attributeBindings,
    currentVAO: null,
    targetVAO: null,
    restore: extVAO() ? restoreVAO : function () {},
    createVAO: createVAO,
    getVAO: getVAO,
    destroyBuffer: destroyBuffer,
    setVAO: extVAO() ? setVAOEXT : setVAOEmulated,
    clear: extVAO() ? destroyVAOEXT : function () {}
  }

  function destroyBuffer (buffer) {
    for (var i = 0; i < attributeBindings.length; ++i) {
      var record = attributeBindings[i]
      if (record.buffer === buffer) {
        gl.disableVertexAttribArray(i)
        record.buffer = null
      }
    }
  }

  function extVAO () {
    return extensions.oes_vertex_array_object
  }

  function extInstanced () {
    return extensions.angle_instanced_arrays
  }

  function getVAO (vao) {
    if (typeof vao === 'function' && vao._vao) {
      return vao._vao
    }
    return null
  }

  function setVAOEXT (vao) {
    if (vao === state.currentVAO) {
      return
    }
    var ext = extVAO()
    if (vao) {
      ext.bindVertexArrayOES(vao.vao)
    } else {
      ext.bindVertexArrayOES(null)
    }
    state.currentVAO = vao
  }

  function setVAOEmulated (vao) {
    if (vao === state.currentVAO) {
      return
    }
    if (vao) {
      vao.bindAttrs()
    } else {
      var exti = extInstanced()
      for (var i = 0; i < attributeBindings.length; ++i) {
        var binding = attributeBindings[i]
        if (binding.buffer) {
          gl.enableVertexAttribArray(i)
          binding.buffer.bind()
          gl.vertexAttribPointer(i, binding.size, binding.type, binding.normalized, binding.stride, binding.offfset)
          if (exti && binding.divisor) {
            exti.vertexAttribDivisorANGLE(i, binding.divisor)
          }
        } else {
          gl.disableVertexAttribArray(i)
          gl.vertexAttrib4f(i, binding.x, binding.y, binding.z, binding.w)
        }
      }
      if (drawState.elements) {
        gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER$1, drawState.elements.buffer.buffer)
      } else {
        gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER$1, null)
      }
    }
    state.currentVAO = vao
  }

  function destroyVAOEXT () {
    values(vaoSet).forEach(function (vao) {
      vao.destroy()
    })
  }

  function REGLVAO () {
    this.id = ++vaoCount
    this.attributes = []
    this.elements = null
    this.ownsElements = false
    this.count = 0
    this.offset = 0
    this.instances = -1
    this.primitive = 4
    var extension = extVAO()
    if (extension) {
      this.vao = extension.createVertexArrayOES()
    } else {
      this.vao = null
    }
    vaoSet[this.id] = this
    this.buffers = []
  }

  REGLVAO.prototype.bindAttrs = function () {
    var exti = extInstanced()
    var attributes = this.attributes
    for (var i = 0; i < attributes.length; ++i) {
      var attr = attributes[i]
      if (attr.buffer) {
        gl.enableVertexAttribArray(i)
        gl.bindBuffer(GL_ARRAY_BUFFER$1, attr.buffer.buffer)
        gl.vertexAttribPointer(i, attr.size, attr.type, attr.normalized, attr.stride, attr.offset)
        if (exti && attr.divisor) {
          exti.vertexAttribDivisorANGLE(i, attr.divisor)
        }
      } else {
        gl.disableVertexAttribArray(i)
        gl.vertexAttrib4f(i, attr.x, attr.y, attr.z, attr.w)
      }
    }
    for (var j = attributes.length; j < NUM_ATTRIBUTES; ++j) {
      gl.disableVertexAttribArray(j)
    }
    var elements = elementState.getElements(this.elements)
    if (elements) {
      gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER$1, elements.buffer.buffer)
    } else {
      gl.bindBuffer(GL_ELEMENT_ARRAY_BUFFER$1, null)
    }
  }

  REGLVAO.prototype.refresh = function () {
    var ext = extVAO()
    if (ext) {
      ext.bindVertexArrayOES(this.vao)
      this.bindAttrs()
      state.currentVAO = null
      ext.bindVertexArrayOES(null)
    }
  }

  REGLVAO.prototype.destroy = function () {
    if (this.vao) {
      var extension = extVAO()
      if (this === state.currentVAO) {
        state.currentVAO = null
        extension.bindVertexArrayOES(null)
      }
      extension.deleteVertexArrayOES(this.vao)
      this.vao = null
    }
    if (this.ownsElements) {
      this.elements.destroy()
      this.elements = null
      this.ownsElements = false
    }
    if (vaoSet[this.id]) {
      delete vaoSet[this.id]
      stats.vaoCount -= 1
    }
  }

  function restoreVAO () {
    var ext = extVAO()
    if (ext) {
      values(vaoSet).forEach(function (vao) {
        vao.refresh()
      })
    }
  }

  function createVAO (_attr) {
    var vao = new REGLVAO()
    stats.vaoCount += 1

    function updateVAO (options) {
      var attributes
      if (Array.isArray(options)) {
        attributes = options
        if (vao.elements && vao.ownsElements) {
          vao.elements.destroy()
        }
        vao.elements = null
        vao.ownsElements = false
        vao.offset = 0
        vao.count = 0
        vao.instances = -1
        vao.primitive = 4
      } else {
        check$1(typeof options === 'object', 'invalid arguments for create vao')
        check$1('attributes' in options, 'must specify attributes for vao')
        if (options.elements) {
          var elements = options.elements
          if (vao.ownsElements) {
            if (typeof elements === 'function' && elements._reglType === 'elements') {
              vao.elements.destroy()
              vao.ownsElements = false
            } else {
              vao.elements(elements)
              vao.ownsElements = false
            }
          } else if (elementState.getElements(options.elements)) {
            vao.elements = options.elements
            vao.ownsElements = false
          } else {
            vao.elements = elementState.create(options.elements)
            vao.ownsElements = true
          }
        } else {
          vao.elements = null
          vao.ownsElements = false
        }
        attributes = options.attributes

        // set default vao
        vao.offset = 0
        vao.count = -1
        vao.instances = -1
        vao.primitive = 4

        // copy element properties
        if (vao.elements) {
          vao.count = vao.elements._elements.vertCount
          vao.primitive = vao.elements._elements.primType
        }

        if ('offset' in options) {
          vao.offset = options.offset | 0
        }
        if ('count' in options) {
          vao.count = options.count | 0
        }
        if ('instances' in options) {
          vao.instances = options.instances | 0
        }
        if ('primitive' in options) {
          check$1(options.primitive in primTypes, 'bad primitive type: ' + options.primitive)
          vao.primitive = primTypes[options.primitive]
        }

        check$1.optional(() => {
          var keys = Object.keys(options)
          for (var i = 0; i < keys.length; ++i) {
            check$1(VAO_OPTIONS.indexOf(keys[i]) >= 0, 'invalid option for vao: "' + keys[i] + '" valid options are ' + VAO_OPTIONS)
          }
        })
        check$1(Array.isArray(attributes), 'attributes must be an array')
      }

      check$1(attributes.length < NUM_ATTRIBUTES, 'too many attributes')
      check$1(attributes.length > 0, 'must specify at least one attribute')

      var bufUpdated = {}
      var nattributes = vao.attributes
      nattributes.length = attributes.length
      for (var i = 0; i < attributes.length; ++i) {
        var spec = attributes[i]
        var rec = nattributes[i] = new AttributeRecord()
        var data = spec.data || spec
        if (Array.isArray(data) || isTypedArray(data) || isNDArrayLike(data)) {
          var buf
          if (vao.buffers[i]) {
            buf = vao.buffers[i]
            if (isTypedArray(data) && buf._buffer.byteLength >= data.byteLength) {
              buf.subdata(data)
            } else {
              buf.destroy()
              vao.buffers[i] = null
            }
          }
          if (!vao.buffers[i]) {
            buf = vao.buffers[i] = bufferState.create(spec, GL_ARRAY_BUFFER$1, false, true)
          }
          rec.buffer = bufferState.getBuffer(buf)
          rec.size = rec.buffer.dimension | 0
          rec.normalized = false
          rec.type = rec.buffer.dtype
          rec.offset = 0
          rec.stride = 0
          rec.divisor = 0
          rec.state = 1
          bufUpdated[i] = 1
        } else if (bufferState.getBuffer(spec)) {
          rec.buffer = bufferState.getBuffer(spec)
          rec.size = rec.buffer.dimension | 0
          rec.normalized = false
          rec.type = rec.buffer.dtype
          rec.offset = 0
          rec.stride = 0
          rec.divisor = 0
          rec.state = 1
        } else if (bufferState.getBuffer(spec.buffer)) {
          rec.buffer = bufferState.getBuffer(spec.buffer)
          rec.size = ((+spec.size) || rec.buffer.dimension) | 0
          rec.normalized = !!spec.normalized || false
          if ('type' in spec) {
            check$1.parameter(spec.type, glTypes, 'invalid buffer type')
            rec.type = glTypes[spec.type]
          } else {
            rec.type = rec.buffer.dtype
          }
          rec.offset = (spec.offset || 0) | 0
          rec.stride = (spec.stride || 0) | 0
          rec.divisor = (spec.divisor || 0) | 0
          rec.state = 1

          check$1(rec.size >= 1 && rec.size <= 4, 'size must be between 1 and 4')
          check$1(rec.offset >= 0, 'invalid offset')
          check$1(rec.stride >= 0 && rec.stride <= 255, 'stride must be between 0 and 255')
          check$1(rec.divisor >= 0, 'divisor must be positive')
          check$1(!rec.divisor || !!extensions.angle_instanced_arrays, 'ANGLE_instanced_arrays must be enabled to use divisor')
        } else if ('x' in spec) {
          check$1(i > 0, 'first attribute must not be a constant')
          rec.x = +spec.x || 0
          rec.y = +spec.y || 0
          rec.z = +spec.z || 0
          rec.w = +spec.w || 0
          rec.state = 2
        } else {
          check$1(false, 'invalid attribute spec for location ' + i)
        }
      }

      // retire unused buffers
      for (var j = 0; j < vao.buffers.length; ++j) {
        if (!bufUpdated[j] && vao.buffers[j]) {
          vao.buffers[j].destroy()
          vao.buffers[j] = null
        }
      }

      vao.refresh()
      return updateVAO
    }

    updateVAO.destroy = function () {
      for (var j = 0; j < vao.buffers.length; ++j) {
        if (vao.buffers[j]) {
          vao.buffers[j].destroy()
        }
      }
      vao.buffers.length = 0

      if (vao.ownsElements) {
        vao.elements.destroy()
        vao.elements = null
        vao.ownsElements = false
      }

      vao.destroy()
    }

    updateVAO._vao = vao
    updateVAO._reglType = 'vao'

    return updateVAO(_attr)
  }

  return state
}

var GL_FRAGMENT_SHADER = 35632
var GL_VERTEX_SHADER = 35633

var GL_ACTIVE_UNIFORMS = 0x8B86
var GL_ACTIVE_ATTRIBUTES = 0x8B89

function wrapShaderState (gl, stringStore, stats, config) {
  // ===================================================
  // glsl compilation and linking
  // ===================================================
  var fragShaders = {}
  var vertShaders = {}

  function ActiveInfo (name, id, location, info) {
    this.name = name
    this.id = id
    this.location = location
    this.info = info
  }

  function insertActiveInfo (list, info) {
    for (var i = 0; i < list.length; ++i) {
      if (list[i].id === info.id) {
        list[i].location = info.location
        return
      }
    }
    list.push(info)
  }

  function getShader (type, id, command) {
    var cache = type === GL_FRAGMENT_SHADER ? fragShaders : vertShaders
    var shader = cache[id]

    if (!shader) {
      var source = stringStore.str(id)
      shader = gl.createShader(type)
      gl.shaderSource(shader, source)
      gl.compileShader(shader)
      check$1.shaderError(gl, shader, source, type, command)
      cache[id] = shader
    }

    return shader
  }

  // ===================================================
  // program linking
  // ===================================================
  var programCache = {}
  var programList = []

  var PROGRAM_COUNTER = 0

  function REGLProgram (fragId, vertId) {
    this.id = PROGRAM_COUNTER++
    this.fragId = fragId
    this.vertId = vertId
    this.program = null
    this.uniforms = []
    this.attributes = []
    this.refCount = 1

    if (config.profile) {
      this.stats = {
        uniformsCount: 0,
        attributesCount: 0
      }
    }
  }

  function linkProgram (desc, command, attributeLocations) {
    var i, info

    // -------------------------------
    // compile & link
    // -------------------------------
    var fragShader = getShader(GL_FRAGMENT_SHADER, desc.fragId)
    var vertShader = getShader(GL_VERTEX_SHADER, desc.vertId)

    var program = desc.program = gl.createProgram()
    gl.attachShader(program, fragShader)
    gl.attachShader(program, vertShader)
    if (attributeLocations) {
      for (i = 0; i < attributeLocations.length; ++i) {
        var binding = attributeLocations[i]
        gl.bindAttribLocation(program, binding[0], binding[1])
      }
    }

    gl.linkProgram(program)
    check$1.linkError(
      gl,
      program,
      stringStore.str(desc.fragId),
      stringStore.str(desc.vertId),
      command)

    // -------------------------------
    // grab uniforms
    // -------------------------------
    var numUniforms = gl.getProgramParameter(program, GL_ACTIVE_UNIFORMS)
    if (config.profile) {
      desc.stats.uniformsCount = numUniforms
    }
    var uniforms = desc.uniforms
    for (i = 0; i < numUniforms; ++i) {
      info = gl.getActiveUniform(program, i)
      if (info) {
        if (info.size > 1) {
          for (var j = 0; j < info.size; ++j) {
            var name = info.name.replace('[0]', '[' + j + ']')
            insertActiveInfo(uniforms, new ActiveInfo(
              name,
              stringStore.id(name),
              gl.getUniformLocation(program, name),
              info))
          }
        }
        var uniName = info.name
        if (info.size > 1) {
          uniName = uniName.replace('[0]', '')
        }
        insertActiveInfo(uniforms, new ActiveInfo(
          uniName,
          stringStore.id(uniName),
          gl.getUniformLocation(program, uniName),
          info))
      }
    }

    // -------------------------------
    // grab attributes
    // -------------------------------
    var numAttributes = gl.getProgramParameter(program, GL_ACTIVE_ATTRIBUTES)
    if (config.profile) {
      desc.stats.attributesCount = numAttributes
    }

    var attributes = desc.attributes
    for (i = 0; i < numAttributes; ++i) {
      info = gl.getActiveAttrib(program, i)
      if (info) {
        insertActiveInfo(attributes, new ActiveInfo(
          info.name,
          stringStore.id(info.name),
          gl.getAttribLocation(program, info.name),
          info))
      }
    }
  }

  if (config.profile) {
    stats.getMaxUniformsCount = function () {
      var m = 0
      programList.forEach(function (desc) {
        if (desc.stats.uniformsCount > m) {
          m = desc.stats.uniformsCount
        }
      })
      return m
    }

    stats.getMaxAttributesCount = function () {
      var m = 0
      programList.forEach(function (desc) {
        if (desc.stats.attributesCount > m) {
          m = desc.stats.attributesCount
        }
      })
      return m
    }
  }

  function restoreShaders () {
    fragShaders = {}
    vertShaders = {}
    for (var i = 0; i < programList.length; ++i) {
      linkProgram(programList[i], null, programList[i].attributes.map(function (info) {
        return [info.location, info.name]
      }))
    }
  }

  return {
    clear: function () {
      var deleteShader = gl.deleteShader.bind(gl)
      values(fragShaders).forEach(deleteShader)
      fragShaders = {}
      values(vertShaders).forEach(deleteShader)
      vertShaders = {}

      programList.forEach(function (desc) {
        gl.deleteProgram(desc.program)
      })
      programList.length = 0
      programCache = {}

      stats.shaderCount = 0
    },

    program: function (vertId, fragId, command, attribLocations) {
      check$1.command(vertId >= 0, 'missing vertex shader', command)
      check$1.command(fragId >= 0, 'missing fragment shader', command)

      var cache = programCache[fragId]
      if (!cache) {
        cache = programCache[fragId] = {}
      }
      var prevProgram = cache[vertId]
      if (prevProgram) {
        prevProgram.refCount++
        if (!attribLocations) {
          return prevProgram
        }
      }
      var program = new REGLProgram(fragId, vertId)
      stats.shaderCount++
      linkProgram(program, command, attribLocations)
      if (!prevProgram) {
        cache[vertId] = program
      }
      programList.push(program)
      return extend(program, {
        destroy: function () {
          program.refCount--
          if (program.refCount <= 0) {
            gl.deleteProgram(program.program)
            var idx = programList.indexOf(program)
            programList.splice(idx, 1)
            stats.shaderCount--
          }
          // no program is linked to this vert anymore
          if (cache[program.vertId].refCount <= 0) {
            gl.deleteShader(vertShaders[program.vertId])
            delete vertShaders[program.vertId]
            delete programCache[program.fragId][program.vertId]
          }
          // no program is linked to this frag anymore
          if (!Object.keys(programCache[program.fragId]).length) {
            gl.deleteShader(fragShaders[program.fragId])
            delete fragShaders[program.fragId]
            delete programCache[program.fragId]
          }
        }
      })
    },

    restore: restoreShaders,

    shader: getShader,

    frag: -1,
    vert: -1
  }
}

var GL_RGBA$3 = 6408
var GL_UNSIGNED_BYTE$7 = 5121
var GL_PACK_ALIGNMENT = 0x0D05
var GL_FLOAT$7 = 0x1406 // 5126

function wrapReadPixels (
  gl,
  framebufferState,
  reglPoll,
  context,
  glAttributes,
  extensions,
  limits) {
  function readPixelsImpl (input) {
    var type
    if (framebufferState.next ==