# synapseai

Generate OpenAI function-calling schemas from your tool classes!

## Features
- Reads all Python tool classes in a folder
- Extracts class name, docstring, and Pydantic Field attributes
- Outputs OpenAI-compatible function-calling schema JSON

## Installation

```bash
pip install synapse
```

### As a Python Library

```python
from synapseai import generate_schema

schemas = generate_schema(folder='/path/to/tools')
# or
schemas = generate_schema(files=['/path/to/tools/ToolA.py', '/path/to/tools/ToolB.py'])
```

## Output Format

The output is a list of schemas in OpenAI function-calling format:

```
[
  {
    "type": "function",
    "function": {
      "name": "tool_name",
      "description": "...",
      "parameters": {
        "type": "object",
        "properties": { ... },
        "required": [ ... ]
      }
    }
  },
  ...
]
```

## License
MIT
