from typing import Literal, Union
from synmax.openapi.client import Result
from datetime import date
class HyperionApiClient:
    def well_completion(self,aggregate_by: list[Literal['county', 'date_completion_start', 'date_completion_end', 'operator', 'region_natgas', 'state_code', 'sub_region_natgas']] = ...,completion_class: Union[list[Literal['oil', 'gas', 'TBD']], Literal['oil', 'gas', 'TBD']] = ...,county: Union[list[str], str] = ...,date_completion_start_min: date = ...,date_completion_start_max: date = ...,date_completion_end_min: date = ...,date_completion_end_max: date = ...,operator: Union[list[str], str] = ...,region_natgas: Union[list[str], str] = ...,state_code: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Well completions. Well level frac jobs by date."""
        ...
    def daily_fracked_feet(self,aggregate_by: list[Literal['date_frac', 'region_natgas', 'sub_region_natgas']] = ...,date_frac_min: date = ...,date_frac_max: date = ...,region_natgas: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Fracked feet per day averaged by subregion."""
        ...
    def daily_production(self,aggregate_by: list[Literal['date_prod', 'region_natgas', 'sub_region_natgas']] = ...,date_prod_min: date = ...,date_prod_max: date = ...,region_natgas: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Returns the daily gas production model for the lower 48, informed from pipeline scrapes, state data, and our short-term production forecast."""
        ...
    def dry_gas_factors(self,date_factor_min: date = ...,date_factor_max: date = ...,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Monthly dry gas factors by natgas subregion"""
        ...
    def ducs_by_operator(self,aggregate_by: list[Literal['county', 'date_observed', 'operator', 'region_natgas', 'state_code', 'sub_region_natgas']] = ...,county: Union[list[str], str] = ...,date_observed_min: date = ...,date_observed_max: date = ...,operator: Union[list[str], str] = ...,region_natgas: Union[list[str], str] = ...,state_code: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Count of drilled but uncompleted wells by county and operator"""
        ...
    def glossary(self,category: list[str] = ...,completion_class: list[str] = ...,county: list[str] = ...,filter_type: str,date_forecast_run: str = ...,frac_class: list[str] = ...,operator: list[str] = ...,region_natgas: list[str] = ...,rig_class: list[str] = ...,search_term: str = ...,service_company: list[str] = ...,source: list[str] = ...,state_code: list[str] = ...,sub_region_natgas: list[str] = ...,target_function: str) -> Result:
        """Returns available filter parameters and values for drop down menus."""
        ...
    def long_term_forecast(self,aggregate_by: list[Literal['date_prod', 'region_natgas', 'sub_region_natgas']] = ...,date_prod_min: date = ...,date_prod_max: date = ...,region_natgas: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Long-term production forecasts for gas production of the lower 48 for the next 12 months."""
        ...
    def fetch_operator_classification(self) -> Result:
        """Whether well operator is public or private company."""
        ...
    def production_by_well(self,aggregate_by: list[Literal['date_prod', 'county', 'operator', 'production_month', 'region_natgas', 'state_code', 'sub_region_natgas']] = ...,county: Union[list[str], str] = ...,date_prod_min: date = ...,date_prod_max: date = ...,operator: Union[list[str], str] = ...,production_month: Union[list[int], int] = ...,production_month_min: int = ...,production_month_max: int = ...,region_natgas: Union[list[str], str] = ...,state_code: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...,well_id: Union[list[str], str] = ...) -> Result:
        """Well level monthly oil and gas production."""
        ...
    def fetch_regions(self) -> Result:
        """Region lookup data"""
        ...
    def rigs(self,aggregate_by: list[Literal['date_observed', 'region_natgas', 'sub_region_natgas', 'county', 'operator', 'state_code']] = ...,date_observed_min: date = ...,date_observed_max: date = ...,region_natgas: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...,county: Union[list[str], str] = ...,operator: Union[list[str], str] = ...,state_code: Union[list[str], str] = ...,rig_class: Union[list[Literal['oil', 'gas', 'TBD']], Literal['oil', 'gas', 'TBD']] = ...) -> Result:
        """Returns location specific to a wellpad and its operating dates."""
        ...
    def short_term_forecast(self,aggregate_by: list[Literal['county', 'date_prod', 'operator', 'region_natgas', 'state_code', 'sub_region_natgas']] = ...,county: Union[list[str], str] = ...,date_prod_min: date = ...,date_prod_max: date = ...,operator: Union[list[str], str] = ...,region_natgas: Union[list[str], str] = ...,state_code: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...,well_id: Union[list[str], str] = ...) -> Result:
        """Returns short-term, monthly gas production forecasts for well APIs."""
        ...
    def short_term_forecast_declines(self,aggregate_by: list[Literal['county', 'date_prod', 'first_production_month', 'modeled', 'operator', 'production_month', 'region_natgas', 'state_code', 'state_reported', 'sub_region_natgas']] = ...,aggregation_type: Literal['average', 'count', 'sum'] = ...,county: Union[list[str], str] = ...,date_prod_min: date = ...,date_prod_max: date = ...,first_production_month_min: date = ...,first_production_month_max: date = ...,modeled: bool = ...,operator: Union[list[str], str] = ...,production_month: Union[list[int], int] = ...,production_month_min: int = ...,production_month_max: int = ...,region_natgas: Union[list[str], str] = ...,state_code: Union[list[str], str] = ...,state_reported: bool = ...,sub_region_natgas: Union[list[str], str] = ...,well_id: Union[list[str], str] = ...) -> Result:
        """Long term well declines at a monthly rate."""
        ...
    def short_term_forecast_history(self,aggregate_by: list[Literal['county', 'date_prod', 'operator', 'region_natgas', 'state_code', 'sub_region_natgas']] = ...,county: Union[list[str], str] = ...,date_forecast_run: date,date_prod_min: date = ...,date_prod_max: date = ...,operator: Union[list[str], str] = ...,region_natgas: Union[list[str], str] = ...,state_code: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...,well_id: Union[list[str], str] = ...) -> Result:
        """Monthly production backcasts by well."""
        ...
    def fetch_forecast_run_dates(self) -> Result:
        """Forecast run dates"""
        ...
    def short_term_forecast_aggregated_history(self,date_forecast_run: date = ...,date_prod_min: date = ...,date_prod_max: date = ...,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Subregion aggregated histories of all shorttermforecasts."""
        ...
    def fetch_tils(self) -> Result:
        """TIL monitoring data."""
        ...
    def wells(self,aggregate_by: list[Literal['county', 'date_first_production', 'date_spud', 'operator', 'region_natgas', 'state_code', 'sub_region_natgas', 'produced_formation', 'produced_basin']] = ...,county: Union[list[str], str] = ...,date_spud_min: date = ...,date_spud_max: date = ...,date_first_production_min: date = ...,date_first_production_max: date = ...,depth_min: float = ...,depth_max: float = ...,horizontal_length_min: float = ...,horizontal_length_max: float = ...,lat_surface_min: float = ...,lat_surface_max: float = ...,lon_surface_min: float = ...,lon_surface_max: float = ...,operator: Union[list[str], str] = ...,region_natgas: Union[list[str], str] = ...,state_code: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...,well_id: Union[list[str], str] = ...,wellpad_id: Union[list[int], int] = ...,produced_formation: list[str] = ...,produced_basin: list[str] = ...,response_fields: list[str] = ...) -> Result:
        """Well level details. Well level data derived from all sources."""
        ...
    def frac_crews(self,aggregate_by: list[Literal['county', 'date_frac', 'operator', 'region_natgas', 'service_company', 'state_code', 'sub_region_natgas']] = ...,county: Union[list[str], str] = ...,date_frac_min: date = ...,date_frac_max: date = ...,frac_class: Union[list[Literal['oil', 'gas', 'TBD']], Literal['oil', 'gas', 'TBD']] = ...,operator: Union[list[str], str] = ...,region_natgas: Union[list[str], str] = ...,service_company: list[str] = ...,state_code: Union[list[str], str] = ...,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Frac crew location by wellpad and date"""
        ...
    def lower_48_total_stf(self) -> Result:
        """Aggregated STF for lower 48, including plug regions"""
        ...
    def well_initial_production_rates(self,wellpad_id: Union[list[str], str] = ...,well_id: Union[list[str], str] = ...) -> Result:
        """Initial production rates for oil and gas wells"""
        ...
    def beta_complete_report_date(self,sub_region_natgas: Union[list[str], str] = ...) -> Result:
        """Get most recent date for which pipeline scrapes, gas and oil datasets are considered complete, by subregion."""
        ...
    def dark_oil_transactions(self,date_min: date = ...,date_max: date = ...,terminal_id: list[str] = ...,terminal: list[str] = ...,country: list[str] = ...) -> Result:
        """Fetch enriched transaction data with vessel information from dark oil terminals"""
        ...
    def dark_oil_volumes(self,date_min: date = ...,date_max: date = ...,terminal_id: list[str] = ...,terminal: list[str] = ...,country: list[str] = ...,aggregate_by: list[Literal['date', 'terminal', 'country', 'month', 'year']] = ...) -> Result:
        """Fetch aggregated transaction volume data from dark oil terminals"""
        ...
    def dark_oil_imagery(self,date_min: date = ...,date_max: date = ...,terminal_id: list[str] = ...,terminal: list[str] = ...,country: list[str] = ...) -> Result:
        """Fetch enriched imagery data from dark oil terminals"""
        ...
    def dark_oil_terminals(self,terminal: list[str] = ...,port: list[str] = ...,country: list[str] = ...,oil_type: list[str] = ...,oil_grade: list[str] = ...) -> Result:
        """Fetch terminal information from dark oil terminals"""
        ...