# Generated by ariadne-codegen
# Source: src/synmetrix_python_client/graphql

from typing import Any, AsyncIterator, Dict, List, Optional, Union

from .access_list import AccessList
from .all_access_lists import AllAccessLists
from .all_data_schemas import AllDataSchemas
from .all_data_sources import AllDataSources
from .all_logs import AllLogs
from .all_schemas import AllSchemas
from .async_base_client import AsyncBaseClient
from .base_model import UNSET, UnsetType
from .check_connection import CheckConnection
from .create_access_list import CreateAccessList
from .create_alert import CreateAlert
from .create_branch import CreateBranch
from .create_data_source import CreateDataSource
from .create_exploration import CreateExploration
from .create_report import CreateReport
from .create_team import CreateTeam
from .create_version import CreateVersion
from .credentials import Credentials
from .current_data_source import CurrentDataSource
from .current_exploration import CurrentExploration
from .current_log import CurrentLog
from .current_team import CurrentTeam
from .current_user import CurrentUser
from .current_version import CurrentVersion
from .datasources import Datasources
from .delete_access_list import DeleteAccessList
from .delete_alert import DeleteAlert
from .delete_credentials import DeleteCredentials
from .delete_data_source import DeleteDataSource
from .delete_member import DeleteMember
from .delete_report import DeleteReport
from .delete_schema import DeleteSchema
from .delete_team import DeleteTeam
from .edit_team import EditTeam
from .export_data import ExportData
from .fetch_meta import FetchMeta
from .fetch_tables import FetchTables
from .gen_data_schemas import GenDataSchemas
from .gen_sql import GenSQL
from .get_users import GetUsers
from .input_types import (
    SourceTable,
    access_lists_bool_exp,
    access_lists_insert_input,
    access_lists_order_by,
    access_lists_pk_columns_input,
    access_lists_set_input,
    alerts_insert_input,
    alerts_pk_columns_input,
    alerts_set_input,
    branches_bool_exp,
    branches_insert_input,
    branches_order_by,
    dataschemas_bool_exp,
    dataschemas_order_by,
    datasources_bool_exp,
    datasources_insert_input,
    datasources_order_by,
    datasources_pk_columns_input,
    datasources_set_input,
    explorations_insert_input,
    member_roles_pk_columns_input,
    member_roles_set_input,
    members_bool_exp,
    members_order_by,
    members_pk_columns_input,
    members_set_input,
    reports_insert_input,
    reports_pk_columns_input,
    reports_set_input,
    request_logs_bool_exp,
    request_logs_order_by,
    sql_credentials_insert_input,
    teams_pk_columns_input,
    teams_set_input,
    versions_insert_input,
)
from .insert_sql_credentials import InsertSqlCredentials
from .invite_member import InviteMember
from .members import Members
from .run_source_sql_query import RunSourceSQLQuery
from .send_test_alert import SendTestAlert
from .set_default_branch import SetDefaultBranch
from .sub_access_lists import SubAccessLists
from .sub_all_logs import SubAllLogs
from .sub_credentials import SubCredentials
from .sub_current_user import SubCurrentUser
from .sub_team_data import SubTeamData
from .team_data import TeamData
from .update_access_list import UpdateAccessList
from .update_alert import UpdateAlert
from .update_data_source import UpdateDataSource
from .update_member import UpdateMember
from .update_member_role import UpdateMemberRole
from .update_report import UpdateReport
from .update_user_info import UpdateUserInfo
from .version_by_branch_id import VersionByBranchId
from .version_doc import VersionDoc
from .versions_count import VersionsCount


def gql(q: str) -> str:
    return q


class Client(AsyncBaseClient):
    async def all_access_lists(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[access_lists_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[access_lists_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AllAccessLists:
        query = gql(
            """
            query AllAccessLists($offset: Int, $limit: Int, $where: access_lists_bool_exp, $order_by: [access_lists_order_by!]) {
              access_lists(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                id
                name
                config
                team_id
                created_at
                updated_at
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        response = await self.execute(
            query=query, operation_name="AllAccessLists", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AllAccessLists.model_validate(data)

    async def sub_access_lists(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[access_lists_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[access_lists_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AsyncIterator[SubAccessLists]:
        query = gql(
            """
            subscription SubAccessLists($offset: Int, $limit: Int, $where: access_lists_bool_exp, $order_by: [access_lists_order_by!]) {
              access_lists(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                id
                name
                config
                created_at
                updated_at
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        async for data in self.execute_ws(
            query=query, operation_name="SubAccessLists", variables=variables, **kwargs
        ):
            yield SubAccessLists.model_validate(data)

    async def access_list(self, id: Any, **kwargs: Any) -> AccessList:
        query = gql(
            """
            query AccessList($id: uuid!) {
              access_lists_by_pk(id: $id) {
                name
                config
                team_id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="AccessList", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AccessList.model_validate(data)

    async def update_access_list(
        self,
        pk_columns: access_lists_pk_columns_input,
        set: access_lists_set_input,
        **kwargs: Any
    ) -> UpdateAccessList:
        query = gql(
            """
            mutation UpdateAccessList($pk_columns: access_lists_pk_columns_input!, $_set: access_lists_set_input!) {
              update_access_lists_by_pk(pk_columns: $pk_columns, _set: $_set) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"pk_columns": pk_columns, "_set": set}
        response = await self.execute(
            query=query,
            operation_name="UpdateAccessList",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateAccessList.model_validate(data)

    async def delete_access_list(self, id: Any, **kwargs: Any) -> DeleteAccessList:
        query = gql(
            """
            mutation DeleteAccessList($id: uuid!) {
              delete_access_lists_by_pk(id: $id) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="DeleteAccessList",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteAccessList.model_validate(data)

    async def create_access_list(
        self, object: access_lists_insert_input, **kwargs: Any
    ) -> CreateAccessList:
        query = gql(
            """
            mutation CreateAccessList($object: access_lists_insert_input!) {
              insert_access_lists_one(object: $object) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"object": object}
        response = await self.execute(
            query=query,
            operation_name="CreateAccessList",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateAccessList.model_validate(data)

    async def create_alert(
        self, object: alerts_insert_input, **kwargs: Any
    ) -> CreateAlert:
        query = gql(
            """
            mutation CreateAlert($object: alerts_insert_input!) {
              insert_alerts_one(object: $object) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"object": object}
        response = await self.execute(
            query=query, operation_name="CreateAlert", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateAlert.model_validate(data)

    async def update_alert(
        self, pk_columns: alerts_pk_columns_input, set: alerts_set_input, **kwargs: Any
    ) -> UpdateAlert:
        query = gql(
            """
            mutation UpdateAlert($pk_columns: alerts_pk_columns_input!, $_set: alerts_set_input!) {
              update_alerts_by_pk(pk_columns: $pk_columns, _set: $_set) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"pk_columns": pk_columns, "_set": set}
        response = await self.execute(
            query=query, operation_name="UpdateAlert", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UpdateAlert.model_validate(data)

    async def delete_alert(self, id: Any, **kwargs: Any) -> DeleteAlert:
        query = gql(
            """
            mutation DeleteAlert($id: uuid!) {
              delete_alerts_by_pk(id: $id) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="DeleteAlert", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DeleteAlert.model_validate(data)

    async def send_test_alert(
        self,
        delivery_config: Any,
        delivery_type: str,
        exploration_id: Union[Optional[Any], UnsetType] = UNSET,
        name: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> SendTestAlert:
        query = gql(
            """
            mutation SendTestAlert($deliveryConfig: json!, $deliveryType: String!, $explorationId: uuid, $name: String) {
              send_test_alert(
                deliveryConfig: $deliveryConfig
                deliveryType: $deliveryType
                name: $name
                explorationId: $explorationId
              ) {
                error
                result
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "deliveryConfig": delivery_config,
            "deliveryType": delivery_type,
            "explorationId": exploration_id,
            "name": name,
        }
        response = await self.execute(
            query=query, operation_name="SendTestAlert", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return SendTestAlert.model_validate(data)

    async def set_default_branch(
        self, branch_id: Any, datasource_id: Any, **kwargs: Any
    ) -> SetDefaultBranch:
        query = gql(
            """
            mutation SetDefaultBranch($branch_id: uuid!, $datasource_id: uuid!) {
              update_branches(
                _set: {status: created}
                where: {datasource_id: {_eq: $datasource_id}, status: {_eq: active}}
              ) {
                affected_rows
              }
              update_branches_by_pk(_set: {status: active}, pk_columns: {id: $branch_id}) {
                id
                name
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "branch_id": branch_id,
            "datasource_id": datasource_id,
        }
        response = await self.execute(
            query=query,
            operation_name="SetDefaultBranch",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SetDefaultBranch.model_validate(data)

    async def export_data(
        self, branch_id: Union[Optional[str], UnsetType] = UNSET, **kwargs: Any
    ) -> ExportData:
        query = gql(
            """
            mutation ExportData($branch_id: String) {
              export_data_models(branch_id: $branch_id) {
                download_url
              }
            }
            """
        )
        variables: Dict[str, object] = {"branch_id": branch_id}
        response = await self.execute(
            query=query, operation_name="ExportData", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return ExportData.model_validate(data)

    async def create_branch(
        self, object: branches_insert_input, **kwargs: Any
    ) -> CreateBranch:
        query = gql(
            """
            mutation CreateBranch($object: branches_insert_input!) {
              insert_branches_one(object: $object) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"object": object}
        response = await self.execute(
            query=query, operation_name="CreateBranch", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateBranch.model_validate(data)

    async def current_user(self, id: Any, **kwargs: Any) -> CurrentUser:
        query = gql(
            """
            query CurrentUser($id: uuid!) {
              users_by_pk(id: $id) {
                id
                display_name
                avatar_url
                account {
                  email
                }
                members(order_by: {updated_at: desc}) {
                  member_roles {
                    team_role
                  }
                  user {
                    id
                    avatar_url
                    display_name
                    account {
                      email
                    }
                  }
                  team {
                    ...UserTeamFields
                  }
                }
              }
            }

            fragment UserTeamFields on teams {
              id
              name
              created_at
              updated_at
              members(order_by: {updated_at: desc}) {
                id
                user_id
                member_roles {
                  team_role
                }
                user {
                  id
                  avatar_url
                  display_name
                  account {
                    email
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="CurrentUser", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CurrentUser.model_validate(data)

    async def sub_current_user(
        self, id: Any, **kwargs: Any
    ) -> AsyncIterator[SubCurrentUser]:
        query = gql(
            """
            subscription SubCurrentUser($id: uuid!) {
              users_by_pk(id: $id) {
                id
                display_name
                avatar_url
                account {
                  email
                }
                members(order_by: {updated_at: desc}) {
                  id
                  user_id
                  member_roles {
                    id
                    team_role
                    created_at
                    updated_at
                    access_list {
                      id
                      name
                      config
                    }
                  }
                  user {
                    id
                    avatar_url
                    display_name
                    account {
                      email
                    }
                  }
                  team {
                    ...UserTeamFields
                  }
                }
              }
            }

            fragment UserTeamFields on teams {
              id
              name
              created_at
              updated_at
              members(order_by: {updated_at: desc}) {
                id
                user_id
                member_roles {
                  team_role
                }
                user {
                  id
                  avatar_url
                  display_name
                  account {
                    email
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        async for data in self.execute_ws(
            query=query, operation_name="SubCurrentUser", variables=variables, **kwargs
        ):
            yield SubCurrentUser.model_validate(data)

    async def team_data(self, team_id: Any, **kwargs: Any) -> TeamData:
        query = gql(
            """
            query TeamData($team_id: uuid!) {
              teams_by_pk(id: $team_id) {
                ...TeamMembersFields
                datasources(order_by: {updated_at: desc}) {
                  id
                  name
                  db_params_computed
                  db_type
                  created_at
                  updated_at
                  branches(
                    where: {status: {_in: [active, created]}}
                    order_by: {created_at: desc}
                  ) {
                    ...BranchesFields
                  }
                  sql_credentials(order_by: {updated_at: desc}) {
                    id
                    username
                    created_at
                    updated_at
                    user {
                      id
                      display_name
                    }
                  }
                }
                alerts(order_by: {created_at: desc}) {
                  id
                  name
                  delivery_type
                  delivery_config
                  trigger_config
                  created_at
                  updated_at
                  schedule
                  user {
                    id
                    avatar_url
                    display_name
                    account {
                      email
                    }
                  }
                  exploration {
                    id
                    playground_state
                  }
                }
                reports(order_by: {created_at: desc}) {
                  id
                  name
                  schedule
                  delivery_type
                  delivery_config
                  created_at
                  updated_at
                  user {
                    id
                    avatar_url
                    display_name
                    account {
                      email
                    }
                  }
                  exploration {
                    id
                    playground_state
                  }
                }
              }
            }

            fragment BranchesFields on branches {
              id
              name
              status
            }

            fragment TeamMembersFields on teams {
              members(order_by: {updated_at: desc}) {
                id
                user_id
                member_roles {
                  id
                  team_role
                  created_at
                  updated_at
                  access_list {
                    id
                    name
                    config
                  }
                }
                user {
                  id
                  avatar_url
                  display_name
                  account {
                    email
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"team_id": team_id}
        response = await self.execute(
            query=query, operation_name="TeamData", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return TeamData.model_validate(data)

    async def sub_team_data(
        self, team_id: Any, **kwargs: Any
    ) -> AsyncIterator[SubTeamData]:
        query = gql(
            """
            subscription SubTeamData($team_id: uuid!) {
              teams_by_pk(id: $team_id) {
                ...TeamMembersFields
                datasources(order_by: {updated_at: desc}) {
                  id
                  name
                  db_params_computed
                  db_type
                  created_at
                  updated_at
                  branches(
                    where: {status: {_in: [active, created]}}
                    order_by: {created_at: desc}
                  ) {
                    ...BranchesFields
                  }
                  sql_credentials {
                    id
                    username
                    created_at
                    updated_at
                    user {
                      id
                      display_name
                    }
                  }
                }
                alerts(order_by: {created_at: desc}) {
                  id
                  name
                  delivery_type
                  delivery_config
                  trigger_config
                  created_at
                  updated_at
                  schedule
                  user {
                    id
                    avatar_url
                    display_name
                    account {
                      email
                    }
                  }
                  exploration {
                    id
                    playground_state
                  }
                }
                reports(order_by: {created_at: desc}) {
                  id
                  name
                  schedule
                  delivery_type
                  delivery_config
                  created_at
                  updated_at
                  user {
                    id
                    avatar_url
                    display_name
                    account {
                      email
                    }
                  }
                  exploration {
                    id
                    playground_state
                  }
                }
              }
            }

            fragment BranchesFields on branches {
              id
              name
              status
            }

            fragment TeamMembersFields on teams {
              members(order_by: {updated_at: desc}) {
                id
                user_id
                member_roles {
                  id
                  team_role
                  created_at
                  updated_at
                  access_list {
                    id
                    name
                    config
                  }
                }
                user {
                  id
                  avatar_url
                  display_name
                  account {
                    email
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"team_id": team_id}
        async for data in self.execute_ws(
            query=query, operation_name="SubTeamData", variables=variables, **kwargs
        ):
            yield SubTeamData.model_validate(data)

    async def update_user_info(
        self,
        user_id: Any,
        display_name: Union[Optional[str], UnsetType] = UNSET,
        email: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> UpdateUserInfo:
        query = gql(
            """
            mutation UpdateUserInfo($user_id: uuid!, $display_name: String, $email: citext) {
              update_users_by_pk(
                pk_columns: {id: $user_id}
                _set: {display_name: $display_name}
              ) {
                id
              }
              update_auth_accounts(where: {user_id: {_eq: $user_id}}, _set: {email: $email}) {
                affected_rows
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "user_id": user_id,
            "display_name": display_name,
            "email": email,
        }
        response = await self.execute(
            query=query, operation_name="UpdateUserInfo", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UpdateUserInfo.model_validate(data)

    async def create_data_source(
        self, object: datasources_insert_input, **kwargs: Any
    ) -> CreateDataSource:
        query = gql(
            """
            mutation CreateDataSource($object: datasources_insert_input!) {
              insert_datasources_one(object: $object) {
                id
                name
                branches {
                  id
                }
                sql_credentials {
                  id
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"object": object}
        response = await self.execute(
            query=query,
            operation_name="CreateDataSource",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateDataSource.model_validate(data)

    async def datasources(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[datasources_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[datasources_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Datasources:
        query = gql(
            """
            query Datasources($offset: Int, $limit: Int, $where: datasources_bool_exp, $order_by: [datasources_order_by!]) {
              datasources(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                id
                name
                db_params_computed
                db_type
                created_at
                updated_at
                branches(where: {status: {_eq: active}}) {
                  id
                }
                sql_credentials {
                  id
                  username
                  created_at
                  updated_at
                  user {
                    id
                    display_name
                  }
                }
              }
              datasources_aggregate(where: $where) {
                aggregate {
                  count
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        response = await self.execute(
            query=query, operation_name="Datasources", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Datasources.model_validate(data)

    async def all_data_sources(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[datasources_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[datasources_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AsyncIterator[AllDataSources]:
        query = gql(
            """
            subscription AllDataSources($offset: Int, $limit: Int, $where: datasources_bool_exp, $order_by: [datasources_order_by!]) {
              datasources(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                id
                name
                db_params_computed
                db_type
                created_at
                updated_at
                branches(where: {status: {_eq: active}}) {
                  id
                }
                sql_credentials {
                  id
                  username
                  created_at
                  updated_at
                  user {
                    id
                    display_name
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        async for data in self.execute_ws(
            query=query, operation_name="AllDataSources", variables=variables, **kwargs
        ):
            yield AllDataSources.model_validate(data)

    async def fetch_tables(self, id: Any, **kwargs: Any) -> FetchTables:
        query = gql(
            """
            query FetchTables($id: uuid!) {
              fetch_tables(datasource_id: $id) {
                schema
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="FetchTables", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return FetchTables.model_validate(data)

    async def fetch_meta(
        self,
        datasource_id: Any,
        branch_id: Union[Optional[Any], UnsetType] = UNSET,
        **kwargs: Any
    ) -> FetchMeta:
        query = gql(
            """
            query FetchMeta($datasource_id: uuid!, $branch_id: uuid) {
              fetch_meta(datasource_id: $datasource_id, branch_id: $branch_id) {
                cubes
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "datasource_id": datasource_id,
            "branch_id": branch_id,
        }
        response = await self.execute(
            query=query, operation_name="FetchMeta", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return FetchMeta.model_validate(data)

    async def current_data_source(self, id: Any, **kwargs: Any) -> CurrentDataSource:
        query = gql(
            """
            query CurrentDataSource($id: uuid!) {
              datasources_by_pk(id: $id) {
                id
                name
                db_type
                db_params_computed
                created_at
                updated_at
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="CurrentDataSource",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CurrentDataSource.model_validate(data)

    async def update_data_source(
        self,
        pk_columns: datasources_pk_columns_input,
        set: datasources_set_input,
        **kwargs: Any
    ) -> UpdateDataSource:
        query = gql(
            """
            mutation UpdateDataSource($pk_columns: datasources_pk_columns_input!, $_set: datasources_set_input!) {
              update_datasources_by_pk(pk_columns: $pk_columns, _set: $_set) {
                id
                branches(where: {status: {_eq: active}}) {
                  id
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"pk_columns": pk_columns, "_set": set}
        response = await self.execute(
            query=query,
            operation_name="UpdateDataSource",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateDataSource.model_validate(data)

    async def check_connection(self, id: Any, **kwargs: Any) -> CheckConnection:
        query = gql(
            """
            mutation CheckConnection($id: uuid!) {
              check_connection(datasource_id: $id) {
                message
                code
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="CheckConnection", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CheckConnection.model_validate(data)

    async def delete_data_source(self, id: Any, **kwargs: Any) -> DeleteDataSource:
        query = gql(
            """
            mutation DeleteDataSource($id: uuid!) {
              delete_datasources_by_pk(id: $id) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="DeleteDataSource",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteDataSource.model_validate(data)

    async def gen_data_schemas(
        self,
        datasource_id: Any,
        branch_id: Any,
        tables: List[SourceTable],
        overwrite: Union[Optional[bool], UnsetType] = UNSET,
        format: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> GenDataSchemas:
        query = gql(
            """
            mutation GenDataSchemas($datasource_id: uuid!, $branch_id: uuid!, $tables: [SourceTable!]!, $overwrite: Boolean, $format: String) {
              gen_dataschemas(
                datasource_id: $datasource_id
                branch_id: $branch_id
                tables: $tables
                overwrite: $overwrite
                format: $format
              ) {
                code
                message
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "datasource_id": datasource_id,
            "branch_id": branch_id,
            "tables": tables,
            "overwrite": overwrite,
            "format": format,
        }
        response = await self.execute(
            query=query, operation_name="GenDataSchemas", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GenDataSchemas.model_validate(data)

    async def run_source_sql_query(
        self, datasource_id: Any, query: str, limit: int, **kwargs: Any
    ) -> RunSourceSQLQuery:
        _query = gql(
            """
            mutation RunSourceSQLQuery($datasource_id: uuid!, $query: String!, $limit: Int!) {
              run_query(datasource_id: $datasource_id, query: $query, limit: $limit) {
                result
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "datasource_id": datasource_id,
            "query": query,
            "limit": limit,
        }
        response = await self.execute(
            query=_query,
            operation_name="RunSourceSQLQuery",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return RunSourceSQLQuery.model_validate(data)

    async def create_exploration(
        self, object: explorations_insert_input, **kwargs: Any
    ) -> CreateExploration:
        query = gql(
            """
            mutation CreateExploration($object: explorations_insert_input!) {
              insert_explorations_one(object: $object) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"object": object}
        response = await self.execute(
            query=query,
            operation_name="CreateExploration",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CreateExploration.model_validate(data)

    async def gen_sql(self, exploration_id: Any, **kwargs: Any) -> GenSQL:
        query = gql(
            """
            mutation GenSQL($exploration_id: uuid!) {
              gen_sql(exploration_id: $exploration_id) {
                result
              }
            }
            """
        )
        variables: Dict[str, object] = {"exploration_id": exploration_id}
        response = await self.execute(
            query=query, operation_name="GenSQL", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GenSQL.model_validate(data)

    async def current_exploration(
        self,
        id: Any,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> CurrentExploration:
        query = gql(
            """
            query CurrentExploration($id: uuid!, $offset: Int, $limit: Int) {
              explorations_by_pk(id: $id) {
                id
                branch_id
                datasource_id
                playground_state
                playground_settings
                created_at
                updated_at
              }
              fetch_dataset(exploration_id: $id, offset: $offset, limit: $limit) {
                annotation
                data
                query
                progress
                hitLimit
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id, "offset": offset, "limit": limit}
        response = await self.execute(
            query=query,
            operation_name="CurrentExploration",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return CurrentExploration.model_validate(data)

    async def members(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[members_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[members_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> Members:
        query = gql(
            """
            query Members($offset: Int, $limit: Int, $where: members_bool_exp, $order_by: [members_order_by!]) {
              members(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                id
                user {
                  id
                  display_name
                  account {
                    email
                  }
                }
                member_roles {
                  id
                  team_role
                  access_list {
                    id
                    name
                  }
                  updated_at
                  created_at
                }
                updated_at
                created_at
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        response = await self.execute(
            query=query, operation_name="Members", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Members.model_validate(data)

    async def update_member(
        self,
        pk_columns: members_pk_columns_input,
        set: members_set_input,
        **kwargs: Any
    ) -> UpdateMember:
        query = gql(
            """
            mutation UpdateMember($pk_columns: members_pk_columns_input!, $_set: members_set_input!) {
              update_members_by_pk(pk_columns: $pk_columns, _set: $_set) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"pk_columns": pk_columns, "_set": set}
        response = await self.execute(
            query=query, operation_name="UpdateMember", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UpdateMember.model_validate(data)

    async def update_member_role(
        self,
        pk_columns: member_roles_pk_columns_input,
        set: member_roles_set_input,
        **kwargs: Any
    ) -> UpdateMemberRole:
        query = gql(
            """
            mutation UpdateMemberRole($pk_columns: member_roles_pk_columns_input!, $_set: member_roles_set_input!) {
              update_member_roles_by_pk(pk_columns: $pk_columns, _set: $_set) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"pk_columns": pk_columns, "_set": set}
        response = await self.execute(
            query=query,
            operation_name="UpdateMemberRole",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return UpdateMemberRole.model_validate(data)

    async def delete_member(self, id: Any, **kwargs: Any) -> DeleteMember:
        query = gql(
            """
            mutation DeleteMember($id: uuid!) {
              delete_members_by_pk(id: $id) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="DeleteMember", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DeleteMember.model_validate(data)

    async def invite_member(
        self,
        email: str,
        team_id: Any,
        role: Union[Optional[str], UnsetType] = UNSET,
        **kwargs: Any
    ) -> InviteMember:
        query = gql(
            """
            mutation InviteMember($email: String!, $teamId: uuid!, $role: String) {
              invite_team_member(email: $email, teamId: $teamId, role: $role) {
                memberId
              }
            }
            """
        )
        variables: Dict[str, object] = {"email": email, "teamId": team_id, "role": role}
        response = await self.execute(
            query=query, operation_name="InviteMember", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return InviteMember.model_validate(data)

    async def current_log(self, id: Any, **kwargs: Any) -> CurrentLog:
        query = gql(
            """
            query CurrentLog($id: uuid!) {
              request_logs_by_pk(id: $id) {
                ...DefaultFields
                end_time
                request_id
                updated_at
                request_event_logs(order_by: {timestamp: desc}) {
                  id
                  duration
                  event
                  path
                  query
                  query_key
                  query_sql
                  query_key_md5
                  queue_prefix
                  time_in_queue
                  timestamp
                  error
                }
              }
            }

            fragment DefaultFields on request_logs {
              id
              created_at
              start_time
              duration
              path
              user_id
              datasource_id
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="CurrentLog", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CurrentLog.model_validate(data)

    async def all_logs(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[request_logs_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[request_logs_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AllLogs:
        query = gql(
            """
            query AllLogs($offset: Int, $limit: Int, $where: request_logs_bool_exp, $order_by: [request_logs_order_by!]) {
              request_logs(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                ...DefaultFields
                request_event_logs_aggregate {
                  aggregate {
                    count
                  }
                }
              }
              request_logs_aggregate(where: $where) {
                aggregate {
                  count
                }
              }
            }

            fragment DefaultFields on request_logs {
              id
              created_at
              start_time
              duration
              path
              user_id
              datasource_id
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        response = await self.execute(
            query=query, operation_name="AllLogs", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AllLogs.model_validate(data)

    async def sub_all_logs(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[request_logs_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[request_logs_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AsyncIterator[SubAllLogs]:
        query = gql(
            """
            subscription SubAllLogs($offset: Int, $limit: Int, $where: request_logs_bool_exp, $order_by: [request_logs_order_by!]) {
              request_logs(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        async for data in self.execute_ws(
            query=query, operation_name="SubAllLogs", variables=variables, **kwargs
        ):
            yield SubAllLogs.model_validate(data)

    async def create_report(
        self, object: reports_insert_input, **kwargs: Any
    ) -> CreateReport:
        query = gql(
            """
            mutation CreateReport($object: reports_insert_input!) {
              insert_reports_one(object: $object) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"object": object}
        response = await self.execute(
            query=query, operation_name="CreateReport", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateReport.model_validate(data)

    async def update_report(
        self,
        pk_columns: reports_pk_columns_input,
        set: reports_set_input,
        **kwargs: Any
    ) -> UpdateReport:
        query = gql(
            """
            mutation UpdateReport($pk_columns: reports_pk_columns_input!, $_set: reports_set_input!) {
              update_reports_by_pk(pk_columns: $pk_columns, _set: $_set) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"pk_columns": pk_columns, "_set": set}
        response = await self.execute(
            query=query, operation_name="UpdateReport", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UpdateReport.model_validate(data)

    async def delete_report(self, id: Any, **kwargs: Any) -> DeleteReport:
        query = gql(
            """
            mutation DeleteReport($id: uuid!) {
              delete_reports_by_pk(id: $id) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="DeleteReport", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DeleteReport.model_validate(data)

    async def all_schemas(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[dataschemas_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[dataschemas_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AsyncIterator[AllSchemas]:
        query = gql(
            """
            subscription AllSchemas($offset: Int, $limit: Int, $where: dataschemas_bool_exp, $order_by: [dataschemas_order_by!]) {
              dataschemas(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                id
                user_id
                name
                checksum
                datasource {
                  team_id
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        async for data in self.execute_ws(
            query=query, operation_name="AllSchemas", variables=variables, **kwargs
        ):
            yield AllSchemas.model_validate(data)

    async def all_data_schemas(
        self,
        offset: Union[Optional[int], UnsetType] = UNSET,
        limit: Union[Optional[int], UnsetType] = UNSET,
        where: Union[Optional[branches_bool_exp], UnsetType] = UNSET,
        order_by: Union[Optional[List[branches_order_by]], UnsetType] = UNSET,
        **kwargs: Any
    ) -> AllDataSchemas:
        query = gql(
            """
            query AllDataSchemas($offset: Int, $limit: Int, $where: branches_bool_exp, $order_by: [branches_order_by!]) {
              branches(offset: $offset, limit: $limit, where: $where, order_by: $order_by) {
                id
                name
                status
                versions(order_by: {created_at: desc}) {
                  id
                  checksum
                  created_at
                  updated_at
                  user {
                    display_name
                  }
                  dataschemas {
                    id
                    name
                    code
                    created_at
                    updated_at
                    datasource_id
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "offset": offset,
            "limit": limit,
            "where": where,
            "order_by": order_by,
        }
        response = await self.execute(
            query=query, operation_name="AllDataSchemas", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return AllDataSchemas.model_validate(data)

    async def delete_schema(self, id: Any, **kwargs: Any) -> DeleteSchema:
        query = gql(
            """
            mutation DeleteSchema($id: uuid!) {
              update_branches_by_pk(_set: {status: archived}, pk_columns: {id: $id}) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="DeleteSchema", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DeleteSchema.model_validate(data)

    async def credentials(self, team_id: Any, **kwargs: Any) -> Credentials:
        query = gql(
            """
            query Credentials($teamId: uuid!) {
              sql_credentials(
                where: {datasource: {team_id: {_eq: $teamId}}}
                order_by: {created_at: desc}
              ) {
                id
                username
                created_at
                user {
                  id
                  display_name
                }
                datasource {
                  id
                  name
                  db_type
                  db_params_computed
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"teamId": team_id}
        response = await self.execute(
            query=query, operation_name="Credentials", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return Credentials.model_validate(data)

    async def sub_credentials(
        self, team_id: Any, **kwargs: Any
    ) -> AsyncIterator[SubCredentials]:
        query = gql(
            """
            subscription SubCredentials($teamId: uuid!) {
              sql_credentials(where: {datasource: {team_id: {_eq: $teamId}}}) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"teamId": team_id}
        async for data in self.execute_ws(
            query=query, operation_name="SubCredentials", variables=variables, **kwargs
        ):
            yield SubCredentials.model_validate(data)

    async def insert_sql_credentials(
        self, object: sql_credentials_insert_input, **kwargs: Any
    ) -> InsertSqlCredentials:
        query = gql(
            """
            mutation InsertSqlCredentials($object: sql_credentials_insert_input!) {
              insert_sql_credentials_one(object: $object) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"object": object}
        response = await self.execute(
            query=query,
            operation_name="InsertSqlCredentials",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return InsertSqlCredentials.model_validate(data)

    async def delete_credentials(self, id: Any, **kwargs: Any) -> DeleteCredentials:
        query = gql(
            """
            mutation DeleteCredentials($id: uuid!) {
              delete_sql_credentials_by_pk(id: $id) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query,
            operation_name="DeleteCredentials",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return DeleteCredentials.model_validate(data)

    async def create_team(self, name: str, **kwargs: Any) -> CreateTeam:
        query = gql(
            """
            mutation CreateTeam($name: String!) {
              create_team(name: $name) {
                id
                name
              }
            }
            """
        )
        variables: Dict[str, object] = {"name": name}
        response = await self.execute(
            query=query, operation_name="CreateTeam", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateTeam.model_validate(data)

    async def edit_team(
        self, pk_columns: teams_pk_columns_input, set: teams_set_input, **kwargs: Any
    ) -> EditTeam:
        query = gql(
            """
            mutation EditTeam($pk_columns: teams_pk_columns_input!, $_set: teams_set_input!) {
              update_teams_by_pk(pk_columns: $pk_columns, _set: $_set) {
                id
                name
              }
            }
            """
        )
        variables: Dict[str, object] = {"pk_columns": pk_columns, "_set": set}
        response = await self.execute(
            query=query, operation_name="EditTeam", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return EditTeam.model_validate(data)

    async def delete_team(self, id: Any, **kwargs: Any) -> DeleteTeam:
        query = gql(
            """
            mutation DeleteTeam($id: uuid!) {
              delete_teams_by_pk(id: $id) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="DeleteTeam", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return DeleteTeam.model_validate(data)

    async def current_team(self, id: Any, **kwargs: Any) -> CurrentTeam:
        query = gql(
            """
            query CurrentTeam($id: uuid!) {
              teams_by_pk(id: $id) {
                id
                created_at
                updated_at
                members {
                  user {
                    display_name
                  }
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        response = await self.execute(
            query=query, operation_name="CurrentTeam", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CurrentTeam.model_validate(data)

    async def get_users(self, **kwargs: Any) -> GetUsers:
        query = gql(
            """
            query GetUsers {
              users {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="GetUsers", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return GetUsers.model_validate(data)

    async def version_doc(self, id: Any, **kwargs: Any) -> AsyncIterator[VersionDoc]:
        query = gql(
            """
            subscription VersionDoc($id: uuid!) {
              versions_by_pk(id: $id) {
                markdown_doc
              }
            }
            """
        )
        variables: Dict[str, object] = {"id": id}
        async for data in self.execute_ws(
            query=query, operation_name="VersionDoc", variables=variables, **kwargs
        ):
            yield VersionDoc.model_validate(data)

    async def create_version(
        self, object: versions_insert_input, **kwargs: Any
    ) -> CreateVersion:
        query = gql(
            """
            mutation CreateVersion($object: versions_insert_input!) {
              insert_versions_one(object: $object) {
                id
              }
            }
            """
        )
        variables: Dict[str, object] = {"object": object}
        response = await self.execute(
            query=query, operation_name="CreateVersion", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CreateVersion.model_validate(data)

    async def version_by_branch_id(
        self,
        branch_id: Any,
        limit: Union[Optional[int], UnsetType] = UNSET,
        offset: Union[Optional[int], UnsetType] = UNSET,
        **kwargs: Any
    ) -> VersionByBranchId:
        query = gql(
            """
            query versionByBranchId($branch_id: uuid!, $limit: Int, $offset: Int) {
              versions(
                limit: $limit
                offset: $offset
                order_by: {created_at: desc}
                where: {branch_id: {_eq: $branch_id}}
              ) {
                id
                checksum
                updated_at
                created_at
                user {
                  display_name
                }
                dataschemas(order_by: {name: asc}) {
                  created_at
                  updated_at
                  datasource_id
                  id
                  user_id
                  name
                  code
                  checksum
                }
              }
              versions_aggregate(where: {branch_id: {_eq: $branch_id}}) {
                aggregate {
                  count
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "branch_id": branch_id,
            "limit": limit,
            "offset": offset,
        }
        response = await self.execute(
            query=query,
            operation_name="versionByBranchId",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return VersionByBranchId.model_validate(data)

    async def current_version(self, branch_id: Any, **kwargs: Any) -> CurrentVersion:
        query = gql(
            """
            query CurrentVersion($branch_id: uuid!) {
              versions(
                limit: 1
                offset: 0
                order_by: {created_at: desc}
                where: {branch_id: {_eq: $branch_id}}
              ) {
                id
                checksum
                dataschemas(order_by: {name: asc}) {
                  created_at
                  updated_at
                  datasource_id
                  id
                  user_id
                  name
                  code
                  checksum
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"branch_id": branch_id}
        response = await self.execute(
            query=query, operation_name="CurrentVersion", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return CurrentVersion.model_validate(data)

    async def versions_count(
        self, branch_id: Any, **kwargs: Any
    ) -> AsyncIterator[VersionsCount]:
        query = gql(
            """
            subscription VersionsCount($branch_id: uuid!) {
              versions_aggregate(where: {branch_id: {_eq: $branch_id}}) {
                aggregate {
                  count
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"branch_id": branch_id}
        async for data in self.execute_ws(
            query=query, operation_name="VersionsCount", variables=variables, **kwargs
        ):
            yield VersionsCount.model_validate(data)
