"""Byoti Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class ObjectType(str, Enum):
    """ObjectType."""

    DOMAIN = "domain"
    HASH = "hash"
    IP = "ip"
    URL = "url"


class ObjectSubtype(str, Enum):
    """ObjectSubtype."""

    IPV4 = "ipv4"
    IPV6 = "ipv6"
    MD5 = "md5"
    SHA1 = "sha1"
    SHA256 = "sha256"


class Severity(str, Enum):
    """Severity."""

    INFO = "INFO"
    LOW = "LOW"
    MEDIUM = "MEDIUM"
    HIGH = "HIGH"
    CRITICAL = "CRITICAL"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchIndicatorsInput:
    """SearchIndicatorsInput."""

    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(
        default=None, metadata=config(field_name="per_page")
    )
    with_partner_tenants: Optional[bool] = field(
        default=None, metadata=config(field_name="with_partner_tenants")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ByotiRejectedIndicatorResponse:
    """ByotiRejectedIndicatorResponse."""

    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    reason: Optional[str] = field(default=None, metadata=config(field_name="reason"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class STIXDocumentInput:
    """STIXDocumentInput."""

    type: Optional[str] = field(default=None, metadata=config(field_name="type"))
    spec_version: Optional[str] = field(
        default=None, metadata=config(field_name="spec_version")
    )
    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    created: Optional[str] = field(default=None, metadata=config(field_name="created"))
    modified: Optional[str] = field(
        default=None, metadata=config(field_name="modified")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    pattern: Optional[str] = field(default=None, metadata=config(field_name="pattern"))
    pattern_type: Optional[str] = field(
        default=None, metadata=config(field_name="pattern_type")
    )
    source_name: Optional[str] = field(
        default=None, metadata=config(field_name="source_name")
    )
    integration_id: Optional[int] = field(
        default=None, metadata=config(field_name="integration_id")
    )
    reference_url: Optional[str] = field(
        default=None, metadata=config(field_name="reference_url")
    )
    valid_from: Optional[str] = field(
        default=None, metadata=config(field_name="valid_from")
    )
    severity: Optional[Severity] = field(
        default=None, metadata=config(field_name="severity")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class GetIndicatorsInput:
    """GetIndicatorsInput."""

    updated_after: Optional[str] = field(
        default=None, metadata=config(field_name="updated_after")
    )
    with_partner_tenants: Optional[bool] = field(
        default=None, metadata=config(field_name="with_partner_tenants")
    )
    reference_url: Optional[str] = field(
        default=None, metadata=config(field_name="reference_url")
    )
    source_name: Optional[str] = field(
        default=None, metadata=config(field_name="source_name")
    )
    integration_id: Optional[int] = field(
        default=None, metadata=config(field_name="integration_id")
    )
    exclude_deleted: Optional[bool] = field(
        default=None, metadata=config(field_name="exclude_deleted")
    )
    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(
        default=None, metadata=config(field_name="per_page")
    )
    object_type: Optional[ObjectType] = field(
        default=None, metadata=config(field_name="object_type")
    )
    severity: Optional[Severity] = field(
        default=None, metadata=config(field_name="severity")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PaginateIndicatorsInput:
    """PaginateIndicatorsInput."""

    updated_after: Optional[str] = field(
        default=None, metadata=config(field_name="updated_after")
    )
    with_partner_tenants: Optional[bool] = field(
        default=None, metadata=config(field_name="with_partner_tenants")
    )
    reference_url: Optional[str] = field(
        default=None, metadata=config(field_name="reference_url")
    )
    source_name: Optional[str] = field(
        default=None, metadata=config(field_name="source_name")
    )
    integration_id: Optional[int] = field(
        default=None, metadata=config(field_name="integration_id")
    )
    exclude_deleted: Optional[bool] = field(
        default=None, metadata=config(field_name="exclude_deleted")
    )
    per_page: Optional[int] = field(
        default=None, metadata=config(field_name="per_page")
    )
    cursor: Optional[str] = field(default=None, metadata=config(field_name="cursor"))
    object_type: Optional[ObjectType] = field(
        default=None, metadata=config(field_name="object_type")
    )
    severity: Optional[Severity] = field(
        default=None, metadata=config(field_name="severity")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ByotiIndicator:
    """ByotiIndicator."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenant_id")
    )
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    reference_url: Optional[str] = field(
        default=None, metadata=config(field_name="reference_url")
    )
    source_name: Optional[str] = field(
        default=None, metadata=config(field_name="source_name")
    )
    integration_id: Optional[int] = field(
        default=None, metadata=config(field_name="integration_id")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="created_at")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updated_at")
    )
    deleted_at: Optional[str] = field(
        default=None, metadata=config(field_name="deleted_at")
    )
    object_type: Optional[ObjectType] = field(
        default=None, metadata=config(field_name="object_type")
    )
    object_subtype: Optional[ObjectSubtype] = field(
        default=None, metadata=config(field_name="object_subtype")
    )
    severity: Optional[Severity] = field(
        default=None, metadata=config(field_name="severity")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class IndicatorInput:
    """IndicatorInput."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))
    reference_url: Optional[str] = field(
        default=None, metadata=config(field_name="reference_url")
    )
    source_name: Optional[str] = field(
        default=None, metadata=config(field_name="source_name")
    )
    integration_id: Optional[int] = field(
        default=None, metadata=config(field_name="integration_id")
    )
    object_type: Optional[ObjectType] = field(
        default=None, metadata=config(field_name="object_type")
    )
    object_subtype: Optional[ObjectSubtype] = field(
        default=None, metadata=config(field_name="object_subtype")
    )
    severity: Optional[Severity] = field(
        default=None, metadata=config(field_name="severity")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchIndicatorsResponse:
    """SearchIndicatorsResponse."""

    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(
        default=None, metadata=config(field_name="per_page")
    )
    offset: Optional[int] = field(default=None, metadata=config(field_name="offset"))
    total_pages: Optional[int] = field(
        default=None, metadata=config(field_name="total_pages")
    )
    current_entries_returned: Optional[int] = field(
        default=None, metadata=config(field_name="current_entries_returned")
    )
    total_entries_size: Optional[int] = field(
        default=None, metadata=config(field_name="total_entries_size")
    )
    cursor: Optional[str] = field(default=None, metadata=config(field_name="cursor"))
    indicators: Optional[List[ByotiIndicator]] = field(
        default=None, metadata=config(field_name="indicators")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteIndicatorResponse:
    """DeleteIndicatorResponse."""

    status: Optional[bool] = field(default=None, metadata=config(field_name="status"))
    indicators: Optional[List[ByotiIndicator]] = field(
        default=None, metadata=config(field_name="indicators")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpsertIndicatorsResponse:
    """UpsertIndicatorsResponse."""

    accepted_indicators: Optional[List[ByotiIndicator]] = field(
        default=None, metadata=config(field_name="accepted_indicators")
    )
    rejected_indicators: Optional[List[ByotiRejectedIndicatorResponse]] = field(
        default=None, metadata=config(field_name="rejected_indicators")
    )
