"""Datasources Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.datasources.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.datasources import DatasourcesService

log = logging.getLogger(__name__)


class TaegisSDKDatasourcesQuery:
    """Taegis Datasources Query operations."""

    def __init__(self, service: DatasourcesService):
        self.service = service

    def get_data_source_last_seen_asset(
        self, input_: Optional[GetDataSourceInput] = None
    ) -> List[LastSeenAsset]:
        """Fetches the last seen data about all data sources associated with a tenant based on input parameters.
        It provides ability to filter the data by collectorId and sourceId. Authorization permission is
        required with read access to the collector object.."""
        endpoint = "getDataSourceLastSeenAsset"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(LastSeenAsset),
        )
        if result.get(endpoint) is not None:
            return LastSeenAsset.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query getDataSourceLastSeenAsset")
