"""Queries Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class QLSortOrderInput(str, Enum):
    """QLSortOrderInput."""

    ASC = "ASC"
    DESC = "DESC"


class QLSortFieldInput(str, Enum):
    """QLSortFieldInput."""

    NAME = "NAME"
    CALLER_NAME = "CALLER_NAME"
    USER_EMAIL = "USER_EMAIL"
    USER_ID = "USER_ID"
    CREATED_AT = "CREATED_AT"
    RAW_QUERY = "RAW_QUERY"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Subject:
    """Subject."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Search:
    """Search."""

    query_id: Optional[str] = field(default=None, metadata=config(field_name="queryId"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteQLQueriesResults:
    """DeleteQLQueriesResults."""

    deleted_count: Optional[int] = field(
        default=None, metadata=config(field_name="deletedCount")
    )
    error: Optional[str] = field(default=None, metadata=config(field_name="error"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PageInfo:
    """PageInfo."""

    end_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="endCursor")
    )
    has_next_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasNextPage")
    )
    start_cursor: Optional[str] = field(
        default=None, metadata=config(field_name="startCursor")
    )
    has_previous_page: Optional[bool] = field(
        default=None, metadata=config(field_name="hasPreviousPage")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateQLQuery:
    """CreateQLQuery."""

    raw_query: Optional[str] = field(
        default=None, metadata=config(field_name="rawQuery")
    )
    caller_name: Optional[str] = field(
        default=None, metadata=config(field_name="callerName")
    )
    metadata: Optional[dict] = field(
        default=None, metadata=config(field_name="metadata")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateSavedQLQuery:
    """CreateSavedQLQuery."""

    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    raw_query: Optional[str] = field(
        default=None, metadata=config(field_name="rawQuery")
    )
    caller_name: Optional[str] = field(
        default=None, metadata=config(field_name="callerName")
    )
    metadata: Optional[dict] = field(
        default=None, metadata=config(field_name="metadata")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class QLQueriesInput:
    """QLQueriesInput."""

    rns: Optional[List[str]] = field(default=None, metadata=config(field_name="rns"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class UpdateSavedQLQueryInput:
    """UpdateSavedQLQueryInput."""

    rn: Optional[str] = field(default=None, metadata=config(field_name="rn"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    raw_query: Optional[str] = field(
        default=None, metadata=config(field_name="rawQuery")
    )
    caller_name: Optional[str] = field(
        default=None, metadata=config(field_name="callerName")
    )
    metadata: Optional[dict] = field(
        default=None, metadata=config(field_name="metadata")
    )
    tenants: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tenants")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class DeleteQLQueriesInput:
    """DeleteQLQueriesInput."""

    rns: Optional[List[str]] = field(default=None, metadata=config(field_name="rns"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class QueryFilters:
    """QueryFilters."""

    created_after: Optional[str] = field(
        default=None, metadata=config(field_name="createdAfter")
    )
    created_before: Optional[str] = field(
        default=None, metadata=config(field_name="createdBefore")
    )
    user_email: Optional[str] = field(
        default=None, metadata=config(field_name="userEmail")
    )
    user_email_matches: Optional[str] = field(
        default=None, metadata=config(field_name="userEmailMatches")
    )
    tenant: Optional[str] = field(default=None, metadata=config(field_name="tenant"))
    user_id: Optional[str] = field(default=None, metadata=config(field_name="userId"))
    raw_query_matches: Optional[str] = field(
        default=None, metadata=config(field_name="rawQueryMatches")
    )
    query_name_matches: Optional[str] = field(
        default=None, metadata=config(field_name="queryNameMatches")
    )
    any_field_match: Optional[str] = field(
        default=None, metadata=config(field_name="anyFieldMatch")
    )
    caller_name: Optional[str] = field(
        default=None, metadata=config(field_name="callerName")
    )
    metadata: Optional[dict] = field(
        default=None, metadata=config(field_name="metadata")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SavedQLQuery:
    """SavedQLQuery."""

    rn: Optional[str] = field(default=None, metadata=config(field_name="rn"))
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    raw_query: Optional[str] = field(
        default=None, metadata=config(field_name="rawQuery")
    )
    caller_name: Optional[str] = field(
        default=None, metadata=config(field_name="callerName")
    )
    metadata: Optional[dict] = field(
        default=None, metadata=config(field_name="metadata")
    )
    tenant_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tenantIds")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    user: Optional[Subject] = field(default=None, metadata=config(field_name="user"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SavedQLQueriesResults:
    """SavedQLQueriesResults."""

    error: Optional[str] = field(default=None, metadata=config(field_name="error"))
    queries: Optional[List[SavedQLQuery]] = field(
        default=None, metadata=config(field_name="queries")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class CreateSavedQLQueryInput:
    """CreateSavedQLQueryInput."""

    tenants: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tenants")
    )
    ql_query: Optional[CreateSavedQLQuery] = field(
        default=None, metadata=config(field_name="qlQuery")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AddQLQueryToHistoryInput:
    """AddQLQueryToHistoryInput."""

    run_in_tenants: Optional[List[str]] = field(
        default=None, metadata=config(field_name="runInTenants")
    )
    ql_query: Optional[CreateQLQuery] = field(
        default=None, metadata=config(field_name="qlQuery")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class QLQuery:
    """QLQuery."""

    rn: Optional[str] = field(default=None, metadata=config(field_name="rn"))
    raw_query: Optional[str] = field(
        default=None, metadata=config(field_name="rawQuery")
    )
    caller_name: Optional[str] = field(
        default=None, metadata=config(field_name="callerName")
    )
    saved_name: Optional[str] = field(
        default=None, metadata=config(field_name="savedName")
    )
    is_saved: Optional[bool] = field(
        default=None, metadata=config(field_name="isSaved")
    )
    metadata: Optional[dict] = field(
        default=None, metadata=config(field_name="metadata")
    )
    tenant_ids: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tenantIds")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    status: Optional[Search] = field(default=None, metadata=config(field_name="status"))
    user: Optional[Subject] = field(default=None, metadata=config(field_name="user"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListQLQueriesResults:
    """ListQLQueriesResults."""

    total_records: Optional[int] = field(
        default=None, metadata=config(field_name="totalRecords")
    )
    queries: Optional[List[QLQuery]] = field(
        default=None, metadata=config(field_name="queries")
    )
    page_info: Optional[PageInfo] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListSavedQLQueriesResults:
    """ListSavedQLQueriesResults."""

    total_records: Optional[int] = field(
        default=None, metadata=config(field_name="totalRecords")
    )
    queries: Optional[List[SavedQLQuery]] = field(
        default=None, metadata=config(field_name="queries")
    )
    page_info: Optional[PageInfo] = field(
        default=None, metadata=config(field_name="pageInfo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class QuerySort:
    """QuerySort."""

    field_: Optional[QLSortFieldInput] = field(
        default=None, metadata=config(field_name="field")
    )
    order: Optional[QLSortOrderInput] = field(
        default=None, metadata=config(field_name="order")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class QLQueriesResults:
    """QLQueriesResults."""

    error: Optional[str] = field(default=None, metadata=config(field_name="error"))
    queries: Optional[List[QLQuery]] = field(
        default=None, metadata=config(field_name="queries")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ListQLQueriesInput:
    """ListQLQueriesInput."""

    first: Optional[int] = field(default=None, metadata=config(field_name="first"))
    after: Optional[str] = field(default=None, metadata=config(field_name="after"))
    last: Optional[int] = field(default=None, metadata=config(field_name="last"))
    before: Optional[str] = field(default=None, metadata=config(field_name="before"))
    filters: Optional[QueryFilters] = field(
        default=None, metadata=config(field_name="filters")
    )
    sort_by: Optional[List[QuerySort]] = field(
        default=None, metadata=config(field_name="sortBy")
    )
