"""ThreatScore Query."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.threat_score.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.threat_score import ThreatScoreService

log = logging.getLogger(__name__)


class TaegisSDKThreatScoreQuery:
    """Taegis Threat_score Query operations."""

    def __init__(self, service: ThreatScoreService):
        self.service = service

    def alert_prioritization_by_id(self, id_: str) -> AlertPrioritization:
        """Get Alert Prioritization using Alert ID.."""
        endpoint = "alertPrioritizationById"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "id": prepare_input(id_),
            },
            output=build_output_string(AlertPrioritization),
        )
        if result.get(endpoint) is not None:
            return AlertPrioritization.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for query alertPrioritizationById")

    def alert_prioritization_by_ids(
        self, ids: Optional[List[str]] = None
    ) -> List[AlertPrioritization]:
        """Provide a list of Alert IDs to retrieve each Alert Prioritization.."""
        endpoint = "alertPrioritizationByIds"

        result = self.service.execute_query(
            endpoint=endpoint,
            variables={
                "ids": prepare_input(ids),
            },
            output=build_output_string(AlertPrioritization),
        )
        if result.get(endpoint) is not None:
            return AlertPrioritization.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for query alertPrioritizationByIds")
