"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TailscaleLambdaProxy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const constructs_1 = require("constructs");
const tailscale_lambda_extension_1 = require("tailscale-lambda-extension");
class TailscaleLambdaProxy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.extension = new tailscale_lambda_extension_1.TailscaleLambdaExtension(scope, 'tailscale-extension', props.options.extension);
        this.lambda = new aws_lambda_nodejs_1.NodejsFunction(this, 'tailscale-proxy-lambda', {
            ...props.options.lambda,
            runtime: lambda.Runtime.NODEJS_20_X,
            entry: 'src/lambda/tailscale-proxy/index.ts',
            layers: [this.extension.layer],
            environment: {
                TS_SECRET_API_KEY: props.tsSecretApiKey.secretArn,
                TS_HOSTNAME: props.tsHostname,
            },
            timeout: cdk.Duration.minutes(15),
            memorySize: 256,
        });
        props.tsSecretApiKey.grantRead(this.lambda);
        this.lambdaFunctionUrl = this.lambda.addFunctionUrl({
            authType: lambda.FunctionUrlAuthType.AWS_IAM,
        });
    }
}
exports.TailscaleLambdaProxy = TailscaleLambdaProxy;
_a = JSII_RTTI_SYMBOL_1;
TailscaleLambdaProxy[_a] = { fqn: "tailscale-lambda-proxy.TailscaleLambdaProxy", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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