import type { MiddlewareArgsLike, SdkClient } from './types/awsSdk.js';
/**
 * Type guard to check if the client provided is a valid AWS SDK v3 client.
 *
 * @internal
 */
declare const isSdkClient: (client: unknown) => client is SdkClient;
/**
 * Helper function to create a custom user agent middleware for the AWS SDK v3 clients.
 *
 * The middleware will append the provided feature name and the current version of
 * the Powertools for AWS Lambda library to the user agent string.
 *
 * @example "PT/Tracer/2.1.0 PTEnv/nodejs20x"
 *
 * @param feature The feature name to be added to the user agent
 *
 * @internal
 */
declare const customUserAgentMiddleware: (feature: string) => <T extends MiddlewareArgsLike>(next: (arg0: T) => Promise<T>) => (args: T) => Promise<T>;
/**
 * Add the Powertools for AWS Lambda user agent middleware to the
 * AWS SDK v3 client provided.
 *
 * We use this middleware to unbotrusively track the usage of the library
 * and secure continued investment in the project.
 *
 * @param client The AWS SDK v3 client to add the middleware to
 * @param feature The feature name to be added to the user agent
 */
declare const addUserAgentMiddleware: (client: unknown, feature: string) => void;
export { customUserAgentMiddleware, addUserAgentMiddleware, isSdkClient };
//# sourceMappingURL=awsSdkUtils.d.ts.map