"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.proxyHttpRequest = proxyHttpRequest;
const http = require("http");
const https = require("https");
const socks_proxy_agent_1 = require("socks-proxy-agent");
async function proxyHttpRequest(target, isHttps, request) {
    async function requestPromise() {
        const socksProxyAgent = new socks_proxy_agent_1.SocksProxyAgent('socks://localhost:1055');
        return new Promise((resolve, reject) => {
            const chunks = [];
            const httpLib = isHttps == undefined ?
                (target.port == 443 ? https : http) :
                (isHttps ? https : http);
            const apiRequest = httpLib.request({
                ...target,
                agent: socksProxyAgent,
                path: request.path,
                method: request.method,
                headers: request.headers,
            }, (res) => {
                res.on('data', (chunk) => {
                    chunks.push(chunk);
                });
                res.on('end', () => {
                    const responseBody = Buffer.concat(chunks);
                    resolve({
                        statusCode: res.statusCode || 500,
                        headers: res.headers,
                        body: responseBody.toString('base64'),
                        isBase64Encoded: true,
                    });
                });
                res.on('error', (error) => {
                    console.error('Error receiving response:', error);
                    reject(error);
                });
            });
            apiRequest.on('error', (error) => {
                console.error('Error sending request:', error);
                reject(error);
            });
            if (request.body != null) {
                apiRequest.write(request.body);
            }
            apiRequest.end();
        });
    }
    const connectionRetryDelays = [10, 50, 100, 500, 1000, 2000, 3000];
    let attempt = 0;
    let success = false;
    let response;
    do {
        try {
            response = await requestPromise();
            success = true;
        }
        catch (error) {
            if (error == 'Error: Socks5 proxy rejected connection - Failure' && attempt < connectionRetryDelays.length) {
                console.error('Error: Socks5 proxy rejected connection - Failure');
                console.log('Retrying in', connectionRetryDelays[attempt], 'ms');
                await new Promise((resolve) => setTimeout(resolve, connectionRetryDelays[attempt]));
                attempt++;
            }
            else {
                throw error;
            }
        }
    } while (!success && attempt < connectionRetryDelays.length);
    if (attempt > 0) {
        console.log('Error: Socks5 proxy rejected connection - Failure - RESOLVED - attempt:', attempt, 'total delay time:', connectionRetryDelays.slice(0, attempt).reduce((a, b) => a + b, 0));
    }
    return response;
}
//# sourceMappingURL=data:application/json;base64,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