import * as lambda from 'aws-cdk-lib/aws-lambda';
import { FunctionUrl } from 'aws-cdk-lib/aws-lambda';
import { NodejsFunction } from 'aws-cdk-lib/aws-lambda-nodejs';
import * as secretsmanager from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { TailscaleLambdaExtension } from 'tailscale-lambda-extension';
export interface TailscaleLambdaProxyPropsLambdaOption {
    readonly functionName?: string;
    readonly nodeTlsRejectUnauthorized?: boolean;
}
export interface TailscaleLambdaProxyPropsOptions {
    readonly extension?: lambda.LayerVersionOptions;
    readonly lambda?: TailscaleLambdaProxyPropsLambdaOption;
}
export interface TailscaleLambdaProxyProps {
    /**
     * The name of the AWS Secrets Manager secret that contains the pure text Tailscale API Key.
     */
    readonly tsSecretApiKey: secretsmanager.ISecret;
    /**
     * The "Machine" name as shown in the Tailscale admin console that identifies the Lambda function.
     */
    readonly tsHostname: string;
    readonly options?: TailscaleLambdaProxyPropsOptions;
    readonly debug?: boolean;
}
export declare class TailscaleLambdaProxy extends Construct {
    readonly extension: TailscaleLambdaExtension;
    readonly lambda: NodejsFunction;
    readonly lambdaFunctionUrl: FunctionUrl;
    constructor(scope: Construct, id: string, props: TailscaleLambdaProxyProps);
}
