"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TailscaleLambdaProxy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const constructs_1 = require("constructs");
const tailscale_lambda_extension_1 = require("tailscale-lambda-extension");
class TailscaleLambdaProxy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.extension = new tailscale_lambda_extension_1.TailscaleLambdaExtension(scope, 'tailscale-proxy-extension', {
            options: props.options?.extension,
        });
        this.lambda = new aws_lambda_nodejs_1.NodejsFunction(this, 'tailscale-proxy-lambda', {
            ...props.options?.lambda,
            runtime: lambda.Runtime.NODEJS_20_X,
            code: lambda.Code.fromAsset(path.join(__dirname, 'lambda/tailscale-proxy')),
            handler: 'index.handler',
            layers: [this.extension.layer],
            environment: {
                TS_SECRET_API_KEY: props.tsSecretApiKey.secretArn,
                TS_HOSTNAME: props.tsHostname,
                ...(props?.debug) ? { DEBUG: 'true' } : {},
                ...(props.options?.lambda?.nodeTlsRejectUnauthorized === false) ? { NODE_TLS_REJECT_UNAUTHORIZED: '0' } : {},
            },
            timeout: cdk.Duration.minutes(15),
            memorySize: 256,
        });
        props.tsSecretApiKey.grantRead(this.lambda);
        this.lambdaFunctionUrl = this.lambda.addFunctionUrl({
            authType: lambda.FunctionUrlAuthType.AWS_IAM,
        });
    }
}
exports.TailscaleLambdaProxy = TailscaleLambdaProxy;
_a = JSII_RTTI_SYMBOL_1;
TailscaleLambdaProxy[_a] = { fqn: "tailscale-lambda-proxy.TailscaleLambdaProxy", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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