/**
 * The dimension key for the cold start metric.
 */
declare const COLD_START_METRIC = "ColdStart";
/**
 * The default namespace for metrics.
 */
declare const DEFAULT_NAMESPACE = "default_namespace";
/**
 * The maximum number of metrics that can be emitted in a single EMF blob.
 */
declare const MAX_METRICS_SIZE = 100;
/**
 * The maximum number of metric values that can be emitted in a single metric.
 */
declare const MAX_METRIC_VALUES_SIZE = 100;
/**
 * The maximum number of dimensions that can be added to a metric (0-indexed).
 */
declare const MAX_DIMENSION_COUNT = 29;
/**
 * The maximum age of a timestamp in milliseconds that can be emitted in a metric.
 * This is set to 14 days.
 */
declare const EMF_MAX_TIMESTAMP_PAST_AGE: number;
/**
 * The maximum age of a timestamp in milliseconds that can be emitted in a metric.
 * This is set to 2 hours.
 */
declare const EMF_MAX_TIMESTAMP_FUTURE_AGE: number;
/**
 * The unit of the metric.
 *
 * @see {@link https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Unit | Amazon CloudWatch Units}
 * @see {@link https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html | Amazon CloudWatch MetricDatum}
 */
declare const MetricUnit: {
    readonly Seconds: "Seconds";
    readonly Microseconds: "Microseconds";
    readonly Milliseconds: "Milliseconds";
    readonly Bytes: "Bytes";
    readonly Kilobytes: "Kilobytes";
    readonly Megabytes: "Megabytes";
    readonly Gigabytes: "Gigabytes";
    readonly Terabytes: "Terabytes";
    readonly Bits: "Bits";
    readonly Kilobits: "Kilobits";
    readonly Megabits: "Megabits";
    readonly Gigabits: "Gigabits";
    readonly Terabits: "Terabits";
    readonly Percent: "Percent";
    readonly Count: "Count";
    readonly BytesPerSecond: "Bytes/Second";
    readonly KilobytesPerSecond: "Kilobytes/Second";
    readonly MegabytesPerSecond: "Megabytes/Second";
    readonly GigabytesPerSecond: "Gigabytes/Second";
    readonly TerabytesPerSecond: "Terabytes/Second";
    readonly BitsPerSecond: "Bits/Second";
    readonly KilobitsPerSecond: "Kilobits/Second";
    readonly MegabitsPerSecond: "Megabits/Second";
    readonly GigabitsPerSecond: "Gigabits/Second";
    readonly TerabitsPerSecond: "Terabits/Second";
    readonly CountPerSecond: "Count/Second";
    readonly NoUnit: "None";
};
/**
 * The resolution of the metric.
 *
 * @see {@link https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Resolution_definition | Amazon CloudWatch Resolution}
 */
declare const MetricResolution: {
    readonly Standard: 60;
    readonly High: 1;
};
export { COLD_START_METRIC, DEFAULT_NAMESPACE, MAX_METRICS_SIZE, MAX_METRIC_VALUES_SIZE, MAX_DIMENSION_COUNT, MetricUnit, MetricResolution, EMF_MAX_TIMESTAMP_PAST_AGE, EMF_MAX_TIMESTAMP_FUTURE_AGE, };
//# sourceMappingURL=constants.d.ts.map