"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TailscaleLambdaProxy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const targets = require("aws-cdk-lib/aws-events-targets");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const constructs_1 = require("constructs");
const tailscale_lambda_extension_1 = require("tailscale-lambda-extension");
class TailscaleLambdaProxy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.extension = new tailscale_lambda_extension_1.TailscaleLambdaExtension(scope, 'tailscale-proxy-extension', {
            options: props.options?.extension,
        });
        this.lambda = new aws_lambda_nodejs_1.NodejsFunction(this, 'tailscale-proxy-lambda', {
            ...props.options?.lambda,
            runtime: lambda.Runtime.NODEJS_22_X,
            code: lambda.Code.fromAsset(path.join(__dirname, 'lambda/tailscale-proxy')),
            handler: 'index.handler',
            layers: [this.extension.layer],
            environment: {
                TS_SECRET_API_KEY: props.tsSecretApiKey.secretArn,
                TS_HOSTNAME: props.tsHostname,
                ...(props?.debug) ? { DEBUG: 'true' } : {},
                ...(props.options?.lambda?.nodeTlsRejectUnauthorized === false) ? { NODE_TLS_REJECT_UNAUTHORIZED: '0' } : {},
            },
            timeout: cdk.Duration.minutes(15),
            memorySize: 256,
        });
        props.tsSecretApiKey.grantRead(this.lambda);
        this.lambdaFunctionUrl = this.lambda.addFunctionUrl({
            authType: lambda.FunctionUrlAuthType.AWS_IAM,
        });
        if (props.options?.warmer) {
            const concurrentInvocations = props.options.warmer.concurrentInvocations ?? 3;
            this.warmer = new aws_lambda_nodejs_1.NodejsFunction(this, 'proxy-warmer-lambda', {
                functionName: props.options.warmer.functionName,
                runtime: lambda.Runtime.NODEJS_22_X,
                code: lambda.Code.fromAsset(path.join(__dirname, 'lambda/proxy-warmer')),
                handler: 'index.handler',
                environment: {
                    ...(props?.debug) ? { DEBUG: 'true' } : {},
                    TARGET_FUNCTION_NAME: this.lambda.functionName,
                    CONCURRENT_INVOCATIONS: concurrentInvocations.toString(),
                },
                timeout: cdk.Duration.minutes(1),
                memorySize: 128,
                retryAttempts: 1,
            });
            this.lambda.grantInvoke(this.warmer);
            this.warmerRule = new events.Rule(this, 'proxy-warmer-rule', {
                schedule: events.Schedule.rate(cdk.Duration.minutes(5)),
            });
            this.warmerRule.addTarget(new targets.LambdaFunction(this.warmer, {
                event: events.RuleTargetInput.fromObject({
                    targetFunctionName: this.lambda.functionName,
                    concurrentInvocations: concurrentInvocations,
                }),
            }));
        }
    }
}
exports.TailscaleLambdaProxy = TailscaleLambdaProxy;
_a = JSII_RTTI_SYMBOL_1;
TailscaleLambdaProxy[_a] = { fqn: "tailscale-lambda-proxy.TailscaleLambdaProxy", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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