import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteCodeSigningConfigCommand, se_DeleteCodeSigningConfigCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class DeleteCodeSigningConfigCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSGirApiService", "DeleteCodeSigningConfig", {})
    .n("LambdaClient", "DeleteCodeSigningConfigCommand")
    .f(void 0, void 0)
    .ser(se_DeleteCodeSigningConfigCommand)
    .de(de_DeleteCodeSigningConfigCommand)
    .build() {
}
