import * as events from 'aws-cdk-lib/aws-events';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { FunctionUrl } from 'aws-cdk-lib/aws-lambda';
import { NodejsFunction } from 'aws-cdk-lib/aws-lambda-nodejs';
import * as secretsmanager from 'aws-cdk-lib/aws-secretsmanager';
import { Construct } from 'constructs';
import { TailscaleLambdaExtension } from 'tailscale-lambda-extension';
export interface TailscaleLambdaProxyPropsLambdaOption {
    readonly functionName?: string;
    readonly nodeTlsRejectUnauthorized?: boolean;
}
export interface TailscaleLambdaProxyPropsWarmerOption {
    readonly functionName?: string;
    readonly concurrentInvocations?: number;
}
export interface TailscaleLambdaProxyPropsOptions {
    readonly extension?: lambda.LayerVersionOptions;
    readonly lambda?: TailscaleLambdaProxyPropsLambdaOption;
    /**
     * If provided, a separate Lambda function will be created to periodically invoke the Tailscale proxy Lambda
     * function to keep it warm.
     */
    readonly warmer?: TailscaleLambdaProxyPropsWarmerOption;
}
export interface TailscaleLambdaProxyProps {
    /**
     * The name of the AWS Secrets Manager secret that contains the pure text Tailscale API Key.
     */
    readonly tsSecretApiKey: secretsmanager.ISecret;
    /**
     * The "Machine" name as shown in the Tailscale admin console that identifies the Lambda function.
     */
    readonly tsHostname: string;
    readonly options?: TailscaleLambdaProxyPropsOptions;
    readonly debug?: boolean;
}
export declare class TailscaleLambdaProxy extends Construct {
    readonly extension: TailscaleLambdaExtension;
    readonly lambda: NodejsFunction;
    readonly lambdaFunctionUrl: FunctionUrl;
    readonly warmer?: NodejsFunction;
    readonly warmerRule?: events.Rule;
    constructor(scope: Construct, id: string, props: TailscaleLambdaProxyProps);
}
