import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListProvisionedConcurrencyConfigsCommand, se_ListProvisionedConcurrencyConfigsCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class ListProvisionedConcurrencyConfigsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSGirApiService", "ListProvisionedConcurrencyConfigs", {})
    .n("LambdaClient", "ListProvisionedConcurrencyConfigsCommand")
    .f(void 0, void 0)
    .ser(se_ListProvisionedConcurrencyConfigsCommand)
    .de(de_ListProvisionedConcurrencyConfigsCommand)
    .build() {
}
