"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TailscaleLambdaProxy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const constructs_1 = require("constructs");
const tailscale_lambda_extension_1 = require("tailscale-lambda-extension");
class TailscaleLambdaProxy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.extension = new tailscale_lambda_extension_1.TailscaleLambdaExtension(scope, 'tailscale-proxy-extension', {
            options: props.options?.extension,
        });
        this.lambda = new aws_lambda_nodejs_1.NodejsFunction(this, 'tailscale-proxy-lambda', {
            ...props.options?.lambda,
            runtime: lambda.Runtime.NODEJS_20_X,
            code: lambda.Code.fromAsset(path.join(__dirname, 'lambda/tailscale-proxy')),
            handler: 'index.handler',
            layers: [this.extension.layer],
            environment: {
                TS_SECRET_API_KEY: props.tsSecretApiKey.secretArn,
                TS_HOSTNAME: props.tsHostname,
            },
            timeout: cdk.Duration.minutes(15),
            memorySize: 256,
        });
        props.tsSecretApiKey.grantRead(this.lambda);
        this.lambdaFunctionUrl = this.lambda.addFunctionUrl({
            authType: lambda.FunctionUrlAuthType.AWS_IAM,
        });
    }
}
exports.TailscaleLambdaProxy = TailscaleLambdaProxy;
_a = JSII_RTTI_SYMBOL_1;
TailscaleLambdaProxy[_a] = { fqn: "tailscale-lambda-proxy.TailscaleLambdaProxy", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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