import { Construct } from '@aws-cdk/core';
import { ISecret } from '@aws-cdk/aws-secretsmanager';
import { IFunction } from '@aws-cdk/aws-lambda';
import { Provider } from '@aws-cdk/custom-resources';
export interface GitlabVariableProps {
    /**
     * the secret containing teh secret to publish to Gitlab
     */
    readonly secret: ISecret;
    /**
     * the field name with the secret to publish
     *
     * @default - use the whole SecretString of the secret as value
     */
    readonly secretField?: string;
    /**
     * the project id within Gitlab `group/project-name`
     */
    readonly projectId: string;
    /**
     * the name of the variable to set in Gitlab
     */
    readonly variableName: string;
    /**
     * the URL of the Gitlab server
     *
     * @default https://gitlab.com
     */
    readonly serverUrl?: string;
    /**
     * the secret containing the Gitlab token to access the API
     */
    readonly gitlabSecret: ISecret;
}
export declare class GitlabVariable extends Construct {
    constructor(scope: Construct, id: string, props: GitlabVariableProps);
    ensureProvider(crLambda: IFunction): Provider;
}
