"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const custom_resources_1 = require("@aws-cdk/custom-resources");
const aws_cloudformation_1 = require("@aws-cdk/aws-cloudformation");
const path_1 = require("path");
class GitlabVariable extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const crLambda = new aws_lambda_1.SingletonFunction(this, 'Function', {
            uuid: 'GitlabVariableCustomResourceFunction',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path_1.join(__dirname, 'lambda.zip')),
            handler: 'dist/index.handler',
            timeout: core_1.Duration.seconds(30),
        });
        props.secret.grantRead(crLambda);
        props.gitlabSecret.grantRead(crLambda);
        new aws_cloudformation_1.CustomResource(this, 'Resource', {
            provider: this.ensureProvider(crLambda),
            resourceType: 'Custom::GitlabVariable',
            properties: {
                secretArn: props.secret.secretArn,
                secretField: props.secretField,
                projectId: props.projectId,
                variableName: props.variableName,
                gitlabSecretArn: props.gitlabSecret.secretArn,
            },
        });
    }
    ensureProvider(crLambda) {
        const constructName = 'GitlabVariableCRProvider';
        const existing = core_1.Stack.of(this).node.tryFindChild(constructName);
        if (existing) {
            return existing;
        }
        return new custom_resources_1.Provider(core_1.Stack.of(this), constructName, { onEventHandler: crLambda });
    }
}
exports.GitlabVariable = GitlabVariable;
//# sourceMappingURL=data:application/json;base64,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