"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const index_1 = require("../lib/index");
const core_1 = require("@aws-cdk/core");
const assert_1 = require("@aws-cdk/assert");
const aws_secretsmanager_1 = require("@aws-cdk/aws-secretsmanager");
test('Has a Lambda function', () => {
    const mockApp = new core_1.App();
    const stack = new core_1.Stack(mockApp, 'testing-stack');
    const secret = new aws_secretsmanager_1.Secret(stack, 'DBSecret', {
        description: 'Some Secret',
        generateSecretString: {
            secretStringTemplate: '{"username":"admin2"}',
            generateStringKey: 'password',
            passwordLength: 20,
        },
    });
    new index_1.GitlabVariable(stack, 'testing', {
        secret,
        secretField: 'password',
        projectId: 'group/secrets-test',
        variableName: 'RDS_PASSWORD2',
        gitlabSecret: aws_secretsmanager_1.Secret.fromSecretArn(stack, 'GitlabToken', 'arn:aws:secretsmanager:eu-central-1:123456789012:secret:GitlabToken-abcd'),
    });
    assert_1.expect(stack).to(assert_1.haveResourceLike("AWS::Lambda::Function", {
        Handler: 'dist/index.handler',
    }));
});
//# sourceMappingURL=data:application/json;base64,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