# coding: utf-8

"""
    Adobe Target Delivery API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Notification(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'address': 'Address',
        'parameters': 'dict(str, str)',
        'profile_parameters': 'dict(str, str)',
        'order': 'Order',
        'product': 'Product',
        'id': 'str',
        'impression_id': 'str',
        'type': 'MetricType',
        'timestamp': 'int',
        'tokens': 'list[str]',
        'mbox': 'NotificationMbox',
        'view': 'NotificationView',
        'page_load': 'NotificationPageLoad'
    }

    attribute_map = {
        'address': 'address',
        'parameters': 'parameters',
        'profile_parameters': 'profileParameters',
        'order': 'order',
        'product': 'product',
        'id': 'id',
        'impression_id': 'impressionId',
        'type': 'type',
        'timestamp': 'timestamp',
        'tokens': 'tokens',
        'mbox': 'mbox',
        'view': 'view',
        'page_load': 'pageLoad'
    }

    def __init__(self, address=None, parameters=None, profile_parameters=None, order=None, product=None, id=None, impression_id=None, type=None, timestamp=None, tokens=None, mbox=None, view=None, page_load=None):
        """Notification - a model defined in OpenAPI"""

        self._address = None
        self._parameters = None
        self._profile_parameters = None
        self._order = None
        self._product = None
        self._id = None
        self._impression_id = None
        self._type = None
        self._timestamp = None
        self._tokens = None
        self._mbox = None
        self._view = None
        self._page_load = None
        self.discriminator = None

        if address is not None:
            self.address = address
        if parameters is not None:
            self.parameters = parameters
        if profile_parameters is not None:
            self.profile_parameters = profile_parameters
        if order is not None:
            self.order = order
        if product is not None:
            self.product = product
        if id is not None:
            self.id = id
        if impression_id is not None:
            self.impression_id = impression_id
        if type is not None:
            self.type = type
        if timestamp is not None:
            self.timestamp = timestamp
        if tokens is not None:
            self.tokens = tokens
        if mbox is not None:
            self.mbox = mbox
        if view is not None:
            self.view = view
        if page_load is not None:
            self.page_load = page_load

    @property
    def address(self):
        """Gets the address of this Notification.


        :return: The address of this Notification.
        :rtype: Address
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this Notification.


        :param address: The address of this Notification.
        :type: Address
        """

        self._address = address

    @property
    def parameters(self):
        """Gets the parameters of this Notification.

        Parameters map. Same object is reused for mbox or profile parameters with slight validation differences. Following names are not allowed for mbox parameters: 'orderId', 'orderTotal', productPurchasedIds' Validation (for both mbox and profile parameters):   * Max 50 parameters limit.   * Parameter name should not be blank.   * Parameter name max length 128.   * Parameter name should not start with 'profile.'   * Parameter value length max 5000. 

        :return: The parameters of this Notification.
        :rtype: dict(str, str)
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """Sets the parameters of this Notification.

        Parameters map. Same object is reused for mbox or profile parameters with slight validation differences. Following names are not allowed for mbox parameters: 'orderId', 'orderTotal', productPurchasedIds' Validation (for both mbox and profile parameters):   * Max 50 parameters limit.   * Parameter name should not be blank.   * Parameter name max length 128.   * Parameter name should not start with 'profile.'   * Parameter value length max 5000. 

        :param parameters: The parameters of this Notification.
        :type: dict(str, str)
        """

        self._parameters = parameters

    @property
    def profile_parameters(self):
        """Gets the profile_parameters of this Notification.

        Parameters map. Same object is reused for mbox or profile parameters with slight validation differences. Following names are not allowed for mbox parameters: 'orderId', 'orderTotal', productPurchasedIds' Validation (for both mbox and profile parameters):   * Max 50 parameters limit.   * Parameter name should not be blank.   * Parameter name max length 128.   * Parameter name should not start with 'profile.'   * Parameter value length max 5000. 

        :return: The profile_parameters of this Notification.
        :rtype: dict(str, str)
        """
        return self._profile_parameters

    @profile_parameters.setter
    def profile_parameters(self, profile_parameters):
        """Sets the profile_parameters of this Notification.

        Parameters map. Same object is reused for mbox or profile parameters with slight validation differences. Following names are not allowed for mbox parameters: 'orderId', 'orderTotal', productPurchasedIds' Validation (for both mbox and profile parameters):   * Max 50 parameters limit.   * Parameter name should not be blank.   * Parameter name max length 128.   * Parameter name should not start with 'profile.'   * Parameter value length max 5000. 

        :param profile_parameters: The profile_parameters of this Notification.
        :type: dict(str, str)
        """

        self._profile_parameters = profile_parameters

    @property
    def order(self):
        """Gets the order of this Notification.


        :return: The order of this Notification.
        :rtype: Order
        """
        return self._order

    @order.setter
    def order(self, order):
        """Sets the order of this Notification.


        :param order: The order of this Notification.
        :type: Order
        """

        self._order = order

    @property
    def product(self):
        """Gets the product of this Notification.


        :return: The product of this Notification.
        :rtype: Product
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this Notification.


        :param product: The product of this Notification.
        :type: Product
        """

        self._product = product

    @property
    def id(self):
        """Gets the id of this Notification.

        Notification id will be returned in response and will indicate that the notification was processed successfully. 

        :return: The id of this Notification.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Notification.

        Notification id will be returned in response and will indicate that the notification was processed successfully. 

        :param id: The id of this Notification.
        :type: str
        """
        if id is not None and len(id) > 200:
            raise ValueError("Invalid value for `id`, length must be less than or equal to `200`")

        self._id = id

    @property
    def impression_id(self):
        """Gets the impression_id of this Notification.

        Impression id is used to stitch (link) the current notification with a previous notification or execute request. In case they both of them match, the second and other subsequent requests will not generate a new impression to the activity, experience etc. 

        :return: The impression_id of this Notification.
        :rtype: str
        """
        return self._impression_id

    @impression_id.setter
    def impression_id(self, impression_id):
        """Sets the impression_id of this Notification.

        Impression id is used to stitch (link) the current notification with a previous notification or execute request. In case they both of them match, the second and other subsequent requests will not generate a new impression to the activity, experience etc. 

        :param impression_id: The impression_id of this Notification.
        :type: str
        """
        if impression_id is not None and len(impression_id) > 128:
            raise ValueError("Invalid value for `impression_id`, length must be less than or equal to `128`")

        self._impression_id = impression_id

    @property
    def type(self):
        """Gets the type of this Notification.


        :return: The type of this Notification.
        :rtype: MetricType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Notification.


        :param type: The type of this Notification.
        :type: MetricType
        """

        self._type = type

    @property
    def timestamp(self):
        """Gets the timestamp of this Notification.

        Timestamp of the notification, in milliseconds elapsed since UNIX epoch.

        :return: The timestamp of this Notification.
        :rtype: int
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this Notification.

        Timestamp of the notification, in milliseconds elapsed since UNIX epoch.

        :param timestamp: The timestamp of this Notification.
        :type: int
        """

        self._timestamp = timestamp

    @property
    def tokens(self):
        """Gets the tokens of this Notification.

        A list of tokens for displayed content or clicked selectors, based on the type of notification.

        :return: The tokens of this Notification.
        :rtype: list[str]
        """
        return self._tokens

    @tokens.setter
    def tokens(self, tokens):
        """Sets the tokens of this Notification.

        A list of tokens for displayed content or clicked selectors, based on the type of notification.

        :param tokens: The tokens of this Notification.
        :type: list[str]
        """

        self._tokens = tokens

    @property
    def mbox(self):
        """Gets the mbox of this Notification.


        :return: The mbox of this Notification.
        :rtype: NotificationMbox
        """
        return self._mbox

    @mbox.setter
    def mbox(self, mbox):
        """Sets the mbox of this Notification.


        :param mbox: The mbox of this Notification.
        :type: NotificationMbox
        """

        self._mbox = mbox

    @property
    def view(self):
        """Gets the view of this Notification.


        :return: The view of this Notification.
        :rtype: NotificationView
        """
        return self._view

    @view.setter
    def view(self, view):
        """Sets the view of this Notification.


        :param view: The view of this Notification.
        :type: NotificationView
        """

        self._view = view

    @property
    def page_load(self):
        """Gets the page_load of this Notification.


        :return: The page_load of this Notification.
        :rtype: NotificationPageLoad
        """
        return self._page_load

    @page_load.setter
    def page_load(self, page_load):
        """Sets the page_load of this Notification.


        :param page_load: The page_load of this Notification.
        :type: NotificationPageLoad
        """

        self._page_load = page_load

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Notification):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
