# coding: utf-8

"""
    Adobe Target Delivery API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class QAMode(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'token': 'str',
        'listed_activities_only': 'bool',
        'evaluate_as_true_audience_ids': 'list[int]',
        'evaluate_as_false_audience_ids': 'list[int]',
        'preview_indexes': 'list[QAModePreviewIndex]'
    }

    attribute_map = {
        'token': 'token',
        'listed_activities_only': 'listedActivitiesOnly',
        'evaluate_as_true_audience_ids': 'evaluateAsTrueAudienceIds',
        'evaluate_as_false_audience_ids': 'evaluateAsFalseAudienceIds',
        'preview_indexes': 'previewIndexes'
    }

    def __init__(self, token=None, listed_activities_only=None, evaluate_as_true_audience_ids=None, evaluate_as_false_audience_ids=None, preview_indexes=None):
        """QAMode - a model defined in OpenAPI"""

        self._token = None
        self._listed_activities_only = None
        self._evaluate_as_true_audience_ids = None
        self._evaluate_as_false_audience_ids = None
        self._preview_indexes = None
        self.discriminator = None

        if token is not None:
            self.token = token
        if listed_activities_only is not None:
            self.listed_activities_only = listed_activities_only
        if evaluate_as_true_audience_ids is not None:
            self.evaluate_as_true_audience_ids = evaluate_as_true_audience_ids
        if evaluate_as_false_audience_ids is not None:
            self.evaluate_as_false_audience_ids = evaluate_as_false_audience_ids
        if preview_indexes is not None:
            self.preview_indexes = preview_indexes

    @property
    def token(self):
        """Gets the token of this QAMode.

        The encrypted token for the QA mode. It contains the list of the activity ids that are allowed to be executed in QA mode. Validation   * After decryption, the client code from the token should match the one from the request.   * After decryption, activities with the ids specified in the token should belong to the client. 

        :return: The token of this QAMode.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this QAMode.

        The encrypted token for the QA mode. It contains the list of the activity ids that are allowed to be executed in QA mode. Validation   * After decryption, the client code from the token should match the one from the request.   * After decryption, activities with the ids specified in the token should belong to the client. 

        :param token: The token of this QAMode.
        :type: str
        """

        self._token = token

    @property
    def listed_activities_only(self):
        """Gets the listed_activities_only of this QAMode.

        Specifies whether qa_mode campaigns should be executed in isolation or if they should be evaluated along other active campaigns for current environment. 

        :return: The listed_activities_only of this QAMode.
        :rtype: bool
        """
        return self._listed_activities_only

    @listed_activities_only.setter
    def listed_activities_only(self, listed_activities_only):
        """Sets the listed_activities_only of this QAMode.

        Specifies whether qa_mode campaigns should be executed in isolation or if they should be evaluated along other active campaigns for current environment. 

        :param listed_activities_only: The listed_activities_only of this QAMode.
        :type: bool
        """

        self._listed_activities_only = listed_activities_only

    @property
    def evaluate_as_true_audience_ids(self):
        """Gets the evaluate_as_true_audience_ids of this QAMode.

        List of audience ids that should be always evaluated as TRUE in the scope of the delivery request 

        :return: The evaluate_as_true_audience_ids of this QAMode.
        :rtype: list[int]
        """
        return self._evaluate_as_true_audience_ids

    @evaluate_as_true_audience_ids.setter
    def evaluate_as_true_audience_ids(self, evaluate_as_true_audience_ids):
        """Sets the evaluate_as_true_audience_ids of this QAMode.

        List of audience ids that should be always evaluated as TRUE in the scope of the delivery request 

        :param evaluate_as_true_audience_ids: The evaluate_as_true_audience_ids of this QAMode.
        :type: list[int]
        """

        self._evaluate_as_true_audience_ids = evaluate_as_true_audience_ids

    @property
    def evaluate_as_false_audience_ids(self):
        """Gets the evaluate_as_false_audience_ids of this QAMode.

        List of audience ids that should be always evaluated as FALSE in the scope of the delivery request 

        :return: The evaluate_as_false_audience_ids of this QAMode.
        :rtype: list[int]
        """
        return self._evaluate_as_false_audience_ids

    @evaluate_as_false_audience_ids.setter
    def evaluate_as_false_audience_ids(self, evaluate_as_false_audience_ids):
        """Sets the evaluate_as_false_audience_ids of this QAMode.

        List of audience ids that should be always evaluated as FALSE in the scope of the delivery request 

        :param evaluate_as_false_audience_ids: The evaluate_as_false_audience_ids of this QAMode.
        :type: list[int]
        """

        self._evaluate_as_false_audience_ids = evaluate_as_false_audience_ids

    @property
    def preview_indexes(self):
        """Gets the preview_indexes of this QAMode.

        List of preview indexes. If present, the list cannot be empty. 

        :return: The preview_indexes of this QAMode.
        :rtype: list[QAModePreviewIndex]
        """
        return self._preview_indexes

    @preview_indexes.setter
    def preview_indexes(self, preview_indexes):
        """Sets the preview_indexes of this QAMode.

        List of preview indexes. If present, the list cannot be empty. 

        :param preview_indexes: The preview_indexes of this QAMode.
        :type: list[QAModePreviewIndex]
        """

        self._preview_indexes = preview_indexes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QAMode):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
