#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

from alipay.aop.api.constant.ParamConstants import *


class AlipayOpenTestQueryModel(object):

    def __init__(self):
        self._user_name = None
        self._user_type = None

    @property
    def user_name(self):
        return self._user_name

    @user_name.setter
    def user_name(self, value):
        self._user_name = value
    @property
    def user_type(self):
        return self._user_type

    @user_type.setter
    def user_type(self, value):
        if isinstance(value, list):
            self._user_type = list()
            for i in value:
                self._user_type.append(i)


    def to_alipay_dict(self):
        params = dict()
        if self.user_name:
            if hasattr(self.user_name, 'to_alipay_dict'):
                params['user_name'] = self.user_name.to_alipay_dict()
            else:
                params['user_name'] = self.user_name
        if self.user_type:
            if isinstance(self.user_type, list):
                for i in range(0, len(self.user_type)):
                    element = self.user_type[i]
                    if hasattr(element, 'to_alipay_dict'):
                        self.user_type[i] = element.to_alipay_dict()
            if hasattr(self.user_type, 'to_alipay_dict'):
                params['user_type'] = self.user_type.to_alipay_dict()
            else:
                params['user_type'] = self.user_type
        return params

    @staticmethod
    def from_alipay_dict(d):
        if not d:
            return None
        o = AlipayOpenTestQueryModel()
        if 'user_name' in d:
            o.user_name = d['user_name']
        if 'user_type' in d:
            o.user_type = d['user_type']
        return o


