[![Build Status](https://travis-ci.org/chasinglogic/taskforge.svg?branch=master)](https://travis-ci.org/chasinglogic/taskforge)
[![PyPI package](https://img.shields.io/pypi/v/taskforge-cli.svg)](https://pypi.python.org/pypi/taskforge-cli/)
[![Python versions](https://img.shields.io/pypi/pyversions/taskforge-cli.svg)](https://pypi.python.org/pypi/taskforge-cli/)
[![GPL v3](https://img.shields.io/badge/license-GPLv3-blue.svg)](https://github.com/chasinglogic/taskforge/blob/master/LICENSE)
[![Docs](https://img.shields.io/badge/docs-passing-green.svg)](http://taskforge.io/docs/)

![Taskforge](https://raw.githubusercontent.com/chasinglogic/taskforge/master/src/docs/_static/logo_wide.png)

Task management tool and library that integrates and aggregates other services.

## Why Taskforge?

Taskforge has many competitors and all of them are great choices for task
management. So why build yet another "todo app"?

The answer is simple, most task management applications require that you
duplicate data into them from other sources. Whether by work, or personal
preference, our actual tasks are managed in different sources today. Whether
that be JIRA, GitHub, Trello etc. the teams and people we interact with rarely
use the same solution as we do. Furthermore, it's even less likely that you'll
be able to use the same systems at work and on projects.

The downside of all this? **These systems put the responsibility on you** to
duplicate that information into a format that you can digest.

This is the problem that Taskforge solves. It aggregates and integrates with
existing systems and provides a unified interface for all the various tasks
systems you're required to interact with.

## Getting Started

Head over to [our documentation website](http://taskforge.io/docs/) for full
documentation. For a getting started guide and more information.

## Contributing

Follow the 
[Code of Conduct](https://github.com/chasinglogic/taskforge/blob/master/src/docs/code_of_conduct.rst)

Contributions are greatly appreciated. We have a process for making a
contribution via Github that you can read in the 
[CONTRIBUTING.md](https://github.com/chasinglogic/taskforge/blob/master/CONTRIBUTING.md)
document.

## License

This code is distributed under the GNU General Public License

```text
    Copyright (C) 2018 Mathew Robinson

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
```
