from collections.abc import Sequence
from typing import Protocol

class _SupportsWrite(Protocol):
    def write(self, s: str, /) -> object: ...

def combine_dedupe_values(values: list[str], separator: str) -> str: ...
def fix_lt_gt(value: str) -> str: ...
def unescape_html_chars(value: str) -> str: ...
def clean_temperature(value: str) -> str: ...
def remove_chinese_chars(value: str) -> str: ...
def strip_html_tags(value: str) -> str: ...
def add_chemical_formula_subscript(value: str) -> str: ...
def convert_to_xlsx(csv_path: str) -> None: ...

class DictWriter:
    def __init__(self, f: _SupportsWrite, fieldnames: Sequence[str]) -> None: ...
    def writeheader(self) -> None: ...
    def writerow(self, row: dict[str, object]) -> None: ...
    def writerows(self, rows: list[dict[str, object]]) -> None: ...
