import time
from collections.abc import Callable
from functools import wraps
from typing import Any


def timeit(func: Callable[..., Any]) -> Any:  # noqa: ANN401
    @wraps(func)
    def timeit_wrapper(*args: Any, **kwargs: Any) -> Any:  # noqa: ANN401
        start_time = time.perf_counter()
        result = func(*args, **kwargs)
        end_time = time.perf_counter()
        total_time = end_time - start_time
        print(f"Function {func.__name__}{args} {kwargs} Took {total_time:.4f} seconds")
        return result

    return timeit_wrapper
