# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.inline_query_result import InlineQueryResult
from tele_api_python.models.inline_query_results_button import InlineQueryResultsButton
from typing import Optional, Set
from typing_extensions import Self

class AnswerInlineQueryPostRequest(BaseModel):
    """
    AnswerInlineQueryPostRequest
    """ # noqa: E501
    inline_query_id: StrictStr = Field(description="Unique identifier for the answered query")
    results: List[InlineQueryResult] = Field(description="A JSON-serialized array of results for the inline query")
    cache_time: Optional[StrictInt] = Field(default=300, description="The maximum amount of time in seconds that the result of the inline query may be cached on the server. Defaults to 300.")
    is_personal: Optional[StrictBool] = Field(default=None, description="Pass *True* if results may be cached on the server side only for the user that sent the query. By default, results may be returned to any user who sends the same query.")
    next_offset: Optional[StrictStr] = Field(default=None, description="Pass the offset that a client should send in the next query with the same text to receive more results. Pass an empty string if there are no more results or if you don't support pagination. Offset length can't exceed 64 bytes.")
    button: Optional[InlineQueryResultsButton] = None
    __properties: ClassVar[List[str]] = ["inline_query_id", "results", "cache_time", "is_personal", "next_offset", "button"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnswerInlineQueryPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in results (list)
        _items = []
        if self.results:
            for _item_results in self.results:
                if _item_results:
                    _items.append(_item_results.to_dict())
            _dict['results'] = _items
        # override the default output from pydantic by calling `to_dict()` of button
        if self.button:
            _dict['button'] = self.button.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnswerInlineQueryPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "inline_query_id": obj.get("inline_query_id"),
            "results": [InlineQueryResult.from_dict(_item) for _item in obj["results"]] if obj.get("results") is not None else None,
            "cache_time": obj.get("cache_time") if obj.get("cache_time") is not None else 300,
            "is_personal": obj.get("is_personal"),
            "next_offset": obj.get("next_offset"),
            "button": InlineQueryResultsButton.from_dict(obj["button"]) if obj.get("button") is not None else None
        })
        return _obj


