# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.shipping_option import ShippingOption
from typing import Optional, Set
from typing_extensions import Self

class AnswerShippingQueryPostRequest(BaseModel):
    """
    AnswerShippingQueryPostRequest
    """ # noqa: E501
    shipping_query_id: StrictStr = Field(description="Unique identifier for the query to be answered")
    ok: StrictBool = Field(description="Pass *True* if delivery to the specified address is possible and *False* if there are any problems (for example, if delivery to the specified address is not possible)")
    shipping_options: Optional[List[ShippingOption]] = Field(default=None, description="Required if *ok* is *True*. A JSON-serialized array of available shipping options.")
    error_message: Optional[StrictStr] = Field(default=None, description="Required if *ok* is *False*. Error message in human readable form that explains why it is impossible to complete the order (e.g. “Sorry, delivery to your desired address is unavailable”). Telegram will display this message to the user.")
    __properties: ClassVar[List[str]] = ["shipping_query_id", "ok", "shipping_options", "error_message"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnswerShippingQueryPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in shipping_options (list)
        _items = []
        if self.shipping_options:
            for _item_shipping_options in self.shipping_options:
                if _item_shipping_options:
                    _items.append(_item_shipping_options.to_dict())
            _dict['shipping_options'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnswerShippingQueryPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "shipping_query_id": obj.get("shipping_query_id"),
            "ok": obj.get("ok"),
            "shipping_options": [ShippingOption.from_dict(_item) for _item in obj["shipping_options"]] if obj.get("shipping_options") is not None else None,
            "error_message": obj.get("error_message")
        })
        return _obj


