# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from tele_api_python.models.background_fill import BackgroundFill
from typing import Optional, Set
from typing_extensions import Self

class BackgroundTypeFill(BaseModel):
    """
    The background is automatically filled based on the selected colors.
    """ # noqa: E501
    type: StrictStr = Field(description="Type of the background, always “fill”")
    fill: BackgroundFill
    dark_theme_dimming: StrictInt = Field(description="Dimming of the background in dark themes, as a percentage; 0-100")
    __properties: ClassVar[List[str]] = ["type", "fill", "dark_theme_dimming"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BackgroundTypeFill from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of fill
        if self.fill:
            _dict['fill'] = self.fill.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BackgroundTypeFill from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type") if obj.get("type") is not None else 'fill',
            "fill": BackgroundFill.from_dict(obj["fill"]) if obj.get("fill") is not None else None,
            "dark_theme_dimming": obj.get("dark_theme_dimming")
        })
        return _obj


