# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Chat(BaseModel):
    """
    This object represents a chat.
    """ # noqa: E501
    id: StrictInt = Field(description="Unique identifier for this chat. This number may have more than 32 significant bits and some programming languages may have difficulty/silent defects in interpreting it. But it has at most 52 significant bits, so a signed 64-bit integer or double-precision float type are safe for storing this identifier.")
    type: StrictStr = Field(description="Type of the chat, can be either “private”, “group”, “supergroup” or “channel”")
    title: Optional[StrictStr] = Field(default=None, description="*Optional*. Title, for supergroups, channels and group chats")
    username: Optional[StrictStr] = Field(default=None, description="*Optional*. Username, for private chats, supergroups and channels if available")
    first_name: Optional[StrictStr] = Field(default=None, description="*Optional*. First name of the other party in a private chat")
    last_name: Optional[StrictStr] = Field(default=None, description="*Optional*. Last name of the other party in a private chat")
    is_forum: Optional[StrictBool] = Field(default=True, description="*Optional*. *True*, if the supergroup chat is a forum (has [topics](https://telegram.org/blog/topics-in-groups-collectible-usernames#topics-in-groups) enabled)")
    __properties: ClassVar[List[str]] = ["id", "type", "title", "username", "first_name", "last_name", "is_forum"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['private', 'group', 'supergroup', 'channel']):
            raise ValueError("must be one of enum values ('private', 'group', 'supergroup', 'channel')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Chat from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Chat from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "title": obj.get("title"),
            "username": obj.get("username"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "is_forum": obj.get("is_forum") if obj.get("is_forum") is not None else True
        })
        return _obj


