# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from tele_api_python.models.chat_boost_source_gift_code import ChatBoostSourceGiftCode
from tele_api_python.models.chat_boost_source_giveaway import ChatBoostSourceGiveaway
from tele_api_python.models.chat_boost_source_premium import ChatBoostSourcePremium
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

CHATBOOSTSOURCE_ANY_OF_SCHEMAS = ["ChatBoostSourceGiftCode", "ChatBoostSourceGiveaway", "ChatBoostSourcePremium"]

class ChatBoostSource(BaseModel):
    """
    This object describes the source of a chat boost. It can be one of  * [ChatBoostSourcePremium](https://core.telegram.org/bots/api/#chatboostsourcepremium) * [ChatBoostSourceGiftCode](https://core.telegram.org/bots/api/#chatboostsourcegiftcode) * [ChatBoostSourceGiveaway](https://core.telegram.org/bots/api/#chatboostsourcegiveaway)
    """

    # data type: ChatBoostSourcePremium
    anyof_schema_1_validator: Optional[ChatBoostSourcePremium] = None
    # data type: ChatBoostSourceGiftCode
    anyof_schema_2_validator: Optional[ChatBoostSourceGiftCode] = None
    # data type: ChatBoostSourceGiveaway
    anyof_schema_3_validator: Optional[ChatBoostSourceGiveaway] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ChatBoostSourceGiftCode, ChatBoostSourceGiveaway, ChatBoostSourcePremium]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ChatBoostSourceGiftCode", "ChatBoostSourceGiveaway", "ChatBoostSourcePremium" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = ChatBoostSource.model_construct()
        error_messages = []
        # validate data type: ChatBoostSourcePremium
        if not isinstance(v, ChatBoostSourcePremium):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatBoostSourcePremium`")
        else:
            return v

        # validate data type: ChatBoostSourceGiftCode
        if not isinstance(v, ChatBoostSourceGiftCode):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatBoostSourceGiftCode`")
        else:
            return v

        # validate data type: ChatBoostSourceGiveaway
        if not isinstance(v, ChatBoostSourceGiveaway):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ChatBoostSourceGiveaway`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in ChatBoostSource with anyOf schemas: ChatBoostSourceGiftCode, ChatBoostSourceGiveaway, ChatBoostSourcePremium. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ChatBoostSourcePremium] = None
        try:
            instance.actual_instance = ChatBoostSourcePremium.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[ChatBoostSourceGiftCode] = None
        try:
            instance.actual_instance = ChatBoostSourceGiftCode.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[ChatBoostSourceGiveaway] = None
        try:
            instance.actual_instance = ChatBoostSourceGiveaway.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ChatBoostSource with anyOf schemas: ChatBoostSourceGiftCode, ChatBoostSourceGiveaway, ChatBoostSourcePremium. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ChatBoostSourceGiftCode, ChatBoostSourceGiveaway, ChatBoostSourcePremium]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


