# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.user import User
from typing import Optional, Set
from typing_extensions import Self

class ChatMemberAdministrator(BaseModel):
    """
    Represents a [chat member](https://core.telegram.org/bots/api/#chatmember) that has some additional privileges.
    """ # noqa: E501
    status: StrictStr = Field(description="The member's status in the chat, always “administrator”")
    user: User
    can_be_edited: StrictBool = Field(description="*True*, if the bot is allowed to edit administrator privileges of that user")
    is_anonymous: StrictBool = Field(description="*True*, if the user's presence in the chat is hidden")
    can_manage_chat: StrictBool = Field(description="*True*, if the administrator can access the chat event log, get boost list, see hidden supergroup and channel members, report spam messages and ignore slow mode. Implied by any other administrator privilege.")
    can_delete_messages: StrictBool = Field(description="*True*, if the administrator can delete messages of other users")
    can_manage_video_chats: StrictBool = Field(description="*True*, if the administrator can manage video chats")
    can_restrict_members: StrictBool = Field(description="*True*, if the administrator can restrict, ban or unban chat members, or access supergroup statistics")
    can_promote_members: StrictBool = Field(description="*True*, if the administrator can add new administrators with a subset of their own privileges or demote administrators that they have promoted, directly or indirectly (promoted by administrators that were appointed by the user)")
    can_change_info: StrictBool = Field(description="*True*, if the user is allowed to change the chat title, photo and other settings")
    can_invite_users: StrictBool = Field(description="*True*, if the user is allowed to invite new users to the chat")
    can_post_stories: StrictBool = Field(description="*True*, if the administrator can post stories to the chat")
    can_edit_stories: StrictBool = Field(description="*True*, if the administrator can edit stories posted by other users, post stories to the chat page, pin chat stories, and access the chat's story archive")
    can_delete_stories: StrictBool = Field(description="*True*, if the administrator can delete stories posted by other users")
    can_post_messages: Optional[StrictBool] = Field(default=None, description="*Optional*. *True*, if the administrator can post messages in the channel, or access channel statistics; for channels only")
    can_edit_messages: Optional[StrictBool] = Field(default=None, description="*Optional*. *True*, if the administrator can edit messages of other users and can pin messages; for channels only")
    can_pin_messages: Optional[StrictBool] = Field(default=None, description="*Optional*. *True*, if the user is allowed to pin messages; for groups and supergroups only")
    can_manage_topics: Optional[StrictBool] = Field(default=None, description="*Optional*. *True*, if the user is allowed to create, rename, close, and reopen forum topics; for supergroups only")
    custom_title: Optional[StrictStr] = Field(default=None, description="*Optional*. Custom title for this user")
    __properties: ClassVar[List[str]] = ["status", "user", "can_be_edited", "is_anonymous", "can_manage_chat", "can_delete_messages", "can_manage_video_chats", "can_restrict_members", "can_promote_members", "can_change_info", "can_invite_users", "can_post_stories", "can_edit_stories", "can_delete_stories", "can_post_messages", "can_edit_messages", "can_pin_messages", "can_manage_topics", "custom_title"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChatMemberAdministrator from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChatMemberAdministrator from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status") if obj.get("status") is not None else 'administrator',
            "user": User.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "can_be_edited": obj.get("can_be_edited"),
            "is_anonymous": obj.get("is_anonymous"),
            "can_manage_chat": obj.get("can_manage_chat"),
            "can_delete_messages": obj.get("can_delete_messages"),
            "can_manage_video_chats": obj.get("can_manage_video_chats"),
            "can_restrict_members": obj.get("can_restrict_members"),
            "can_promote_members": obj.get("can_promote_members"),
            "can_change_info": obj.get("can_change_info"),
            "can_invite_users": obj.get("can_invite_users"),
            "can_post_stories": obj.get("can_post_stories"),
            "can_edit_stories": obj.get("can_edit_stories"),
            "can_delete_stories": obj.get("can_delete_stories"),
            "can_post_messages": obj.get("can_post_messages"),
            "can_edit_messages": obj.get("can_edit_messages"),
            "can_pin_messages": obj.get("can_pin_messages"),
            "can_manage_topics": obj.get("can_manage_topics"),
            "custom_title": obj.get("custom_title")
        })
        return _obj


