# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from tele_api_python.models.restrict_chat_member_post_request_chat_id import RestrictChatMemberPostRequestChatId
from typing import Optional, Set
from typing_extensions import Self

class CreateForumTopicPostRequest(BaseModel):
    """
    CreateForumTopicPostRequest
    """ # noqa: E501
    chat_id: RestrictChatMemberPostRequestChatId
    name: Annotated[str, Field(min_length=1, strict=True, max_length=128)] = Field(description="Topic name, 1-128 characters")
    icon_color: Optional[StrictInt] = Field(default=None, description="Color of the topic icon in RGB format. Currently, must be one of 7322096 (0x6FB9F0), 16766590 (0xFFD67E), 13338331 (0xCB86DB), 9367192 (0x8EEE98), 16749490 (0xFF93B2), or 16478047 (0xFB6F5F)")
    icon_custom_emoji_id: Optional[StrictStr] = Field(default=None, description="Unique identifier of the custom emoji shown as the topic icon. Use [getForumTopicIconStickers](https://core.telegram.org/bots/api/#getforumtopiciconstickers) to get all allowed custom emoji identifiers.")
    __properties: ClassVar[List[str]] = ["chat_id", "name", "icon_color", "icon_custom_emoji_id"]

    @field_validator('icon_color')
    def icon_color_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([7322096, 16766590, 13338331, 9367192, 16749490, 16478047]):
            raise ValueError("must be one of enum values (7322096, 16766590, 13338331, 9367192, 16749490, 16478047)")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateForumTopicPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of chat_id
        if self.chat_id:
            _dict['chat_id'] = self.chat_id.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateForumTopicPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "chat_id": RestrictChatMemberPostRequestChatId.from_dict(obj["chat_id"]) if obj.get("chat_id") is not None else None,
            "name": obj.get("name"),
            "icon_color": obj.get("icon_color"),
            "icon_custom_emoji_id": obj.get("icon_custom_emoji_id")
        })
        return _obj


