# coding: utf-8

"""
    Telegram Bot API

    Auto-generated OpenAPI schema

    The version of the OpenAPI document: 8.3.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from tele_api_python.models.passport_file import PassportFile
from typing import Optional, Set
from typing_extensions import Self

class EncryptedPassportElement(BaseModel):
    """
    Describes documents or other Telegram Passport elements shared with the bot by the user.
    """ # noqa: E501
    type: StrictStr = Field(description="Element type. One of “personal\\_details”, “passport”, “driver\\_license”, “identity\\_card”, “internal\\_passport”, “address”, “utility\\_bill”, “bank\\_statement”, “rental\\_agreement”, “passport\\_registration”, “temporary\\_registration”, “phone\\_number”, “email”.")
    data: Optional[StrictStr] = Field(default=None, description="*Optional*. Base64-encoded encrypted Telegram Passport element data provided by the user; available only for “personal\\_details”, “passport”, “driver\\_license”, “identity\\_card”, “internal\\_passport” and “address” types. Can be decrypted and verified using the accompanying [EncryptedCredentials](https://core.telegram.org/bots/api/#encryptedcredentials).")
    phone_number: Optional[StrictStr] = Field(default=None, description="*Optional*. User's verified phone number; available only for “phone\\_number” type")
    email: Optional[StrictStr] = Field(default=None, description="*Optional*. User's verified email address; available only for “email” type")
    files: Optional[List[PassportFile]] = Field(default=None, description="*Optional*. Array of encrypted files with documents provided by the user; available only for “utility\\_bill”, “bank\\_statement”, “rental\\_agreement”, “passport\\_registration” and “temporary\\_registration” types. Files can be decrypted and verified using the accompanying [EncryptedCredentials](https://core.telegram.org/bots/api/#encryptedcredentials).")
    front_side: Optional[PassportFile] = None
    reverse_side: Optional[PassportFile] = None
    selfie: Optional[PassportFile] = None
    translation: Optional[List[PassportFile]] = Field(default=None, description="*Optional*. Array of encrypted files with translated versions of documents provided by the user; available if requested for “passport”, “driver\\_license”, “identity\\_card”, “internal\\_passport”, “utility\\_bill”, “bank\\_statement”, “rental\\_agreement”, “passport\\_registration” and “temporary\\_registration” types. Files can be decrypted and verified using the accompanying [EncryptedCredentials](https://core.telegram.org/bots/api/#encryptedcredentials).")
    hash: StrictStr = Field(description="Base64-encoded element hash for using in [PassportElementErrorUnspecified](https://core.telegram.org/bots/api/#passportelementerrorunspecified)")
    __properties: ClassVar[List[str]] = ["type", "data", "phone_number", "email", "files", "front_side", "reverse_side", "selfie", "translation", "hash"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['personal_details', 'passport', 'driver_license', 'identity_card', 'internal_passport', 'address', 'utility_bill', 'bank_statement', 'rental_agreement', 'passport_registration', 'temporary_registration', 'phone_number', 'email']):
            raise ValueError("must be one of enum values ('personal_details', 'passport', 'driver_license', 'identity_card', 'internal_passport', 'address', 'utility_bill', 'bank_statement', 'rental_agreement', 'passport_registration', 'temporary_registration', 'phone_number', 'email')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EncryptedPassportElement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in files (list)
        _items = []
        if self.files:
            for _item_files in self.files:
                if _item_files:
                    _items.append(_item_files.to_dict())
            _dict['files'] = _items
        # override the default output from pydantic by calling `to_dict()` of front_side
        if self.front_side:
            _dict['front_side'] = self.front_side.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reverse_side
        if self.reverse_side:
            _dict['reverse_side'] = self.reverse_side.to_dict()
        # override the default output from pydantic by calling `to_dict()` of selfie
        if self.selfie:
            _dict['selfie'] = self.selfie.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in translation (list)
        _items = []
        if self.translation:
            for _item_translation in self.translation:
                if _item_translation:
                    _items.append(_item_translation.to_dict())
            _dict['translation'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EncryptedPassportElement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "data": obj.get("data"),
            "phone_number": obj.get("phone_number"),
            "email": obj.get("email"),
            "files": [PassportFile.from_dict(_item) for _item in obj["files"]] if obj.get("files") is not None else None,
            "front_side": PassportFile.from_dict(obj["front_side"]) if obj.get("front_side") is not None else None,
            "reverse_side": PassportFile.from_dict(obj["reverse_side"]) if obj.get("reverse_side") is not None else None,
            "selfie": PassportFile.from_dict(obj["selfie"]) if obj.get("selfie") is not None else None,
            "translation": [PassportFile.from_dict(_item) for _item in obj["translation"]] if obj.get("translation") is not None else None,
            "hash": obj.get("hash")
        })
        return _obj


